/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.ParserException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.ArrayList;

public class FilterPolicyParser {
    private Object parser = null;
    private Method parseMethod = null;
    private Method getFilterPermissionsMethod = null;
    private static final String CLASS = "com.ibm.ws.security.policy.FilterParserTr";
    private static final String PARSE_METHOD = "parse";
    private static final String GETFILTERPERMISSIONS_METHOD = "getFilterPermissions";
    private static final TraceComponent tc = Tr.register(FilterPolicyParser.class, null, "com.ibm.ejs.resources.security");

    public FilterPolicyParser(Reader rdr, boolean expandProp) throws ParserException {
        try {
            Class<?> clazz = Class.forName(CLASS);
            Constructor<?> c = clazz.getDeclaredConstructor(Reader.class, Boolean.TYPE);
            this.parser = c.newInstance(rdr, new Boolean(expandProp));
            Class<?> cl = Class.forName("com.ibm.ws.security.policy.FilterParser");
            this.parseMethod = cl.getDeclaredMethod(PARSE_METHOD, null);
            this.getFilterPermissionsMethod = cl.getDeclaredMethod(GETFILTERPERMISSIONS_METHOD, null);
        }
        catch (InvocationTargetException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.FilterPolicyParser", "35", this);
            Throwable original = e.getTargetException();
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, original});
            throw new ParserException(original.getMessage());
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.FilterPolicyParser", "40", this);
            Tr.error(tc, "security.policy.parser.cannotcreateclass", new Object[]{CLASS, e});
            throw new ParserException(e.getMessage());
        }
    }

    public void parse() throws ParserException, IOException {
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.parseMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{PARSE_METHOD, CLASS});
        } else {
            try {
                this.parseMethod.invoke(this.parser, (Object[])null);
            }
            catch (IllegalAccessException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.parse", "55", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, e});
                throw new ParserException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.parse", "59", this);
                Throwable original = e.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{PARSE_METHOD, CLASS, original});
                if (original instanceof ParserException) {
                    throw (ParserException)original;
                }
                if (original instanceof IOException) {
                    throw (IOException)original;
                }
                throw new ParserException(original.getMessage());
            }
        }
    }

    public ArrayList getFilterPermissions() throws ParserException {
        ArrayList result = null;
        if (this.parser == null) {
            Tr.error(tc, "security.policy.parser.objectisnull", new Object[]{CLASS});
        } else if (this.getFilterPermissionsMethod == null) {
            Tr.error(tc, "security.policy.parser.methodisnull", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS});
        } else {
            try {
                result = (ArrayList)this.getFilterPermissionsMethod.invoke(this.parser, (Object[])null);
            }
            catch (IllegalAccessException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.getFilterPermissions", "84", this);
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS, e});
                throw new ParserException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.FilterPolicyParser.getFilterPermissions", "88", this);
                Throwable original = e.getTargetException();
                Tr.error(tc, "security.policy.parser.methodinvocationfailed", new Object[]{GETFILTERPERMISSIONS_METHOD, CLASS, original});
                if (original instanceof ParserException) {
                    throw (ParserException)original;
                }
                throw new ParserException(original.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("usage: java " + FilterPolicyParser.class.getName() + " <filerpolicy file>");
            System.exit(1);
        }
        FileReader rdr = null;
        try {
            rdr = new FileReader(args[0]);
            String s = Security.getProperty("policy.expandProperties");
            boolean expandProp = false;
            if (s != null) {
                expandProp = s.equalsIgnoreCase("true");
            }
            FilterPolicyParser parser2 = new FilterPolicyParser(rdr, expandProp);
            parser2.parse();
            System.out.println("Permissions to be filtered: " + parser2.getFilterPermissions());
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, FilterPolicyParser.class, "com.ibm.ws.security.policy.FilterPolicyParser.main", "120");
            System.err.println("Error: exception caught");
            e.printStackTrace();
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, FilterPolicyParser.class, "com.ibm.ws.security.policy.FilterPolicyParser.main", "128");
                    System.err.println("Error: exception caught");
                    ioe.printStackTrace();
                }
            }
        }
    }
}

