/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ffdc.Manager;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;

abstract class ApplicationParser
extends Parser {
    ApplicationParser(Reader rdr, boolean expandProp) {
        super(rdr, expandProp);
    }

    Parser.GrantEntry parseGrantEntry() throws IOException, ParserException {
        Parser.GrantEntry g = new Parser.GrantEntry(this);
        this.parser.match("grant");
        while (!this.parser.peek("{")) {
            if (this.parser.peek("codeBase")) {
                this.parser.match("codeBase");
                g.codeBase = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                g.signedBy = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    Parser.PermissionEntry p = this.parsePermissionEntry();
                    g.add(p);
                }
                catch (Parser.ExpandException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.ApplicationParser.parseGrantEntry", "62", this);
                    this.warning("security.policy.appparser.expandperm", new Object[]{e});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (g.codeBase != null) {
                String myCodeBase = this.canonicalizeCodeBase(g.codeBase);
                g.codeBase = !this.isStandardSymbl(myCodeBase) ? this.expand(myCodeBase, true) : myCodeBase;
            }
            g.signedBy = this.expand(g.signedBy);
        }
        catch (Parser.ExpandException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.ApplicationParser.parseGrantEntry", "81", this);
            this.warning("security.policy.appparser.expandgrant", new Object[]{e});
            return null;
        }
        return g;
    }

    private String canonicalizeCodeBase(String codeBase) {
        String temp = codeBase.toLowerCase();
        String result = codeBase;
        if (temp.startsWith("file:")) {
            try {
                URL url = new URL(codeBase);
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    File file;
                    String fileName = url.getFile();
                    if (this.isDebugEnabled()) {
                        this.debug("fileName = " + fileName);
                    }
                    if (!(file = new File(fileName)).isAbsolute()) {
                        result = fileName.replace('/', File.separatorChar);
                    }
                }
            }
            catch (MalformedURLException e) {
                this.warning("security.policy.malformedURL", new Object[]{e, result});
            }
        }
        if (this.isDebugEnabled()) {
            this.debug("result = " + result);
        }
        return result;
    }

    public boolean isAppSymbol(String codeBase) {
        if (codeBase.equalsIgnoreCase("${app.installed.path}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${was.module.path}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${current.node.name}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${current.cell.name}")) {
            return true;
        }
        return codeBase.equalsIgnoreCase("${current.server.name}");
    }

    public boolean isStandardSymbl(String codeBase) {
        if (codeBase.equalsIgnoreCase("${webcomponent}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${ejbcomponent}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${application}")) {
            return true;
        }
        if (codeBase.equalsIgnoreCase("${jars}")) {
            return true;
        }
        return codeBase.equalsIgnoreCase("${connectorcomponent}");
    }

    String expand(String str, boolean encodeValue) throws Parser.ExpandException {
        if (this.expandProp) {
            int strLen = 0;
            if (str == null || (strLen = str.length()) == 0) {
                return str;
            }
            StringBuffer buf = new StringBuffer(strLen + 25);
            int index = 0;
            for (int last = 0; last < strLen; ++last) {
                index = str.indexOf("${", last);
                if (index == -1) {
                    buf.append(str.substring(last));
                    break;
                }
                buf.append(str.substring(last, index));
                last = str.indexOf("}", index);
                if (last == -1) {
                    buf.append(str.substring(index));
                    break;
                }
                String key = str.substring(index + 2, last);
                if (key.equals("/")) {
                    buf.append(File.separator);
                    continue;
                }
                String value = System.getProperty(key);
                if (value != null) {
                    if (encodeValue) {
                        value = FilePathUtil.encodeFilePath(value);
                    }
                    buf.append(value);
                    continue;
                }
                if (!this.isAppSymbol("${" + key + "}")) {
                    StringBuffer errBuf = new StringBuffer(32);
                    errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                    errBuf.append("unable to expand \"").append(key).append("\"");
                    String errStr = errBuf.toString();
                    this.error("security.policy.parser.encodeFilePath", new Object[]{errStr});
                    throw new Parser.ExpandException(this, errStr);
                }
                buf.append("${");
                buf.append(key);
                buf.append("}");
            }
            return buf.toString();
        }
        return str;
    }
}

