/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.KeyRingFileException;
import com.ibm.ws.orb.transport.WSSSLClientSocketFactory;
import com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl;
import com.ibm.ws.orbimpl.transport.WSTransport;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.ws.security.orbssl.SocketFactoryMessageUtility;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public final class WSSSLClientSocketFactoryImpl
implements WSSSLClientSocketFactory {
    private static final int DEFAULT_SESSION_TIMEOUT = 30;
    private static String[] ENABLED_CIPHERS = null;
    private static String[] SUPPORTED_CIPHERS = null;

    public Socket createSSLSocket(ConnectionData cd) throws KeyRingFileException, IOException {
        return this.createSSLSocket(cd, 0);
    }

    public Socket createSSLSocket(ConnectionData cd, int connTimeout) throws KeyRingFileException, IOException {
        SSLConnectionData exSSLcd = (SSLConnectionData)cd;
        final String sslAlias = exSSLcd.getSSLConfigAlias();
        String host = null;
        String keyString = exSSLcd.getConnectionKey();
        host = WSTransport.getHostFromKeyString(keyString);
        short performQOP = exSSLcd.getPerformQOP();
        boolean messageLoggingEnabled = true;
        int port = -1;
        port = WSTransport.getPortFromKeyString(keyString);
        SSLContext sslContext = null;
        SSLSocket ssl_sock = null;
        boolean i = false;
        boolean csi = false;
        try {
            final HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.remoteHost", host);
            connectionInfo.put("com.ibm.ssl.remotePort", Integer.toString(port));
            connectionInfo.put("com.ibm.ssl.endPointName", "IIOP");
            Properties props = null;
            try {
                props = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(sslAlias, connectionInfo, null);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            sslContext = JSSEHelper.getInstance().getSSLContext(connectionInfo, props);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            try {
                block66: {
                    Socket plainSock;
                    InetSocketAddress server = new InetSocketAddress(host, port);
                    String localHost = cd.getLocalHost();
                    if (exSSLcd.getUseSingleNIC()) {
                        if (connTimeout == 0) {
                            ssl_sock = (SSLSocket)factory.createSocket(host, port, InetAddress.getByName(localHost), 0);
                        } else {
                            plainSock = new Socket();
                            plainSock.bind(new InetSocketAddress(localHost, 0));
                            plainSock.connect(server, connTimeout);
                            ssl_sock = (SSLSocket)factory.createSocket(plainSock, host, port, true);
                        }
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket(cd, connTimeout)", "Bind Client Socket To A Specific NIC card=" + exSSLcd.getUseSingleNIC() + ", Remote Host=" + host + ", Remote Port=" + port + ", LocalHost=" + localHost + ", java.net.InetAddress.getByName( LocalHost )=" + InetAddress.getByName(localHost) + ", ConnectTimeout = " + connTimeout + " ms.");
                        }
                    } else {
                        if (connTimeout == 0) {
                            ssl_sock = (SSLSocket)factory.createSocket(host, port);
                        } else {
                            plainSock = new Socket();
                            plainSock.connect(server, connTimeout);
                            ssl_sock = (SSLSocket)factory.createSocket(plainSock, host, port, true);
                        }
                        if (ORBRas.isTrcLogging && ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "createSSLSocket(cd, connTimeout)", "Bind Client Socket To Multiple NIC cards=" + !exSSLcd.getUseSingleNIC() + ", Remote Host=" + host + ", Remote Port=" + port + ", ConnectTimeout = " + connTimeout + " ms.");
                        }
                    }
                    try {
                        ssl_sock.setKeepAlive(true);
                    }
                    catch (SocketException se) {
                        if (!ORBRas.isTrcLogging) break block66;
                        ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "\n[\nException calling setKeepAlive() " + se.getMessage() + "\n]");
                    }
                }
                try {
                    ssl_sock.setTcpNoDelay(true);
                }
                catch (SocketException se) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "\n[\nException calling setTcpNoDelay() " + se.getMessage() + "\n]");
                    }
                }
            }
            catch (IOException ex) {
                String message = null;
                int minorCode = 1229066352;
                if (ex instanceof SSLHandshakeException) {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLHandshakeException", ex.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
                } else if (ex instanceof SSLProtocolException) {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLProtocolException", ex.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
                } else if (ex instanceof SSLPeerUnverifiedException) {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLPeerUnverifiedException", ex.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
                } else if (ex instanceof SSLKeyException) {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLKeyException", ex.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
                } else if (ex instanceof SSLException) {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", ex.getMessage());
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
                } else {
                    message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.IOException", ex.getMessage());
                    ORBRas.orbTrcLogger.trace(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message);
                    minorCode = 1229066368;
                }
                if (!messageLoggingEnabled && ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)ex);
                }
                if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "388", this);
                }
                String fillins = "Could not create Client Side Socket " + ex.toString();
                throw new COMM_FAILURE("CONNECT_FAILURE_ON_SSL_CLIENT_SOCKET - " + message, minorCode, CompletionStatus.COMPLETED_NO);
            }
            if (ssl_sock != null) {
                String enabledCiphers = props.getProperty("com.ibm.ssl.enabledCipherSuites");
                ENABLED_CIPHERS = SSLConfigManager.getInstance().parseEnabledCiphers(enabledCiphers);
                if (ENABLED_CIPHERS == null) {
                    String securityLevel = props.getProperty("com.ibm.ssl.securityLevel");
                    SUPPORTED_CIPHERS = factory.getSupportedCipherSuites();
                    SUPPORTED_CIPHERS = SSLConfigManager.getInstance().adjustSupportedCiphersToSecurityLevel(SUPPORTED_CIPHERS, securityLevel);
                }
                if (ENABLED_CIPHERS != null && ENABLED_CIPHERS.length > 0) {
                    ssl_sock.setEnabledCipherSuites(ENABLED_CIPHERS);
                } else if (SUPPORTED_CIPHERS != null && SUPPORTED_CIPHERS.length > 0) {
                    ssl_sock.setEnabledCipherSuites(SUPPORTED_CIPHERS);
                }
                ssl_sock.startHandshake();
            }
        }
        catch (IOException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "424", this);
            String message = null;
            if (ex instanceof SSLHandshakeException) {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLHandshakeException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            } else if (ex instanceof SSLProtocolException) {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLProtocolException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            } else if (ex instanceof SSLPeerUnverifiedException) {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLPeerUnverifiedException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            } else if (ex instanceof SSLKeyException) {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLKeyException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            } else if (ex instanceof SSLException) {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.SSLException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            } else {
                message = SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.IOException", ex.getMessage());
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", message, (String)null, (Object)ex);
            }
            if (!messageLoggingEnabled && ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)ex);
            }
            throw new COMM_FAILURE("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_CLIENT_SOCKET: " + message, 1229066352, CompletionStatus.COMPLETED_NO);
        }
        catch (COMM_FAILURE ex) {
            if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "519", this);
            }
            if (!messageLoggingEnabled) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", (Exception)((Object)ex));
                }
            } else if (ORBRas.isMsgLogging) {
                if (((SystemException)((Object)ex)).minor == 1229066368) {
                    ORBRas.orbTrcLogger.trace(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", ex.getMessage());
                } else {
                    ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.createSSLSocket"), (String)null, (Object)ex);
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            if (LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "564", this);
            }
            if (!messageLoggingEnabled) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", ex);
                }
            } else if (ORBRas.isMsgLogging && LocationServiceImpl.threadLocalAvoidLogs.get() == null) {
                ORBRas.orbMsgLogger.msg(4L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "createSSLSocket", SocketFactoryMessageUtility.getMessage("IIOPSSLConnectionClient.createSSLSocket"), (String)null, (Object)ex);
            }
            throw new COMM_FAILURE("CAUGHT_EXCEPTION_WHILE_CONFIGURING_SSL_CLIENT_SOCKET Exception=" + ex, 1229066352, CompletionStatus.COMPLETED_NO);
        }
        SSLSession theSession = null;
        try {
            if (ssl_sock != null) {
                final SSLSocket sock = ssl_sock;
                theSession = (SSLSession)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return sock.getSession();
                    }
                });
            }
        }
        catch (PrivilegedActionException pae) {
            Manager.Ffdc.log(pae, this, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl.createSSLSocket", "634", this);
        }
        if (theSession == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, "com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl", "IIOPSSLConnectionClient.createSSLSocket", "ssl_sock.getSession returned null");
            }
            throw new COMM_FAILURE("GET_SSL_SESSION_RETURNED_NULL", 1229066362, CompletionStatus.COMPLETED_NO);
        }
        return ssl_sock;
    }
}

