/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class LTPATokenizer {
    private static final char TOKEN_DELIM = '%';
    private static final char USER_DATA_DELIM = '$';
    private static final char USER_ATTRIB_DELIM = ':';
    private static final String STRING_ATTRIB_DELIM = "|";
    private static final TraceComponent tc = Tr.register(LTPATokenizer.class, null, "com.ibm.ejs.resources.security");

    public static String createUserData(Map attribs) {
        Iterator iterate = attribs.keySet().iterator();
        String userData = "";
        StringBuffer sb = new StringBuffer(userData);
        if (attribs.size() > 1) {
            TreeSet elementTreeSet = new TreeSet();
            Iterator e = attribs.keySet().iterator();
            while (e.hasNext()) {
                elementTreeSet.add(e.next());
            }
            for (String key : elementTreeSet) {
                ArrayList list = (ArrayList)attribs.get(key);
                String value = LTPATokenizer.convertArrayListToString(list);
                if (value == null) continue;
                sb.append(key).append(':').append(value).append('$');
            }
        } else {
            while (iterate.hasNext()) {
                String key = (String)iterate.next();
                ArrayList list = (ArrayList)attribs.get(key);
                String value = LTPATokenizer.convertArrayListToString(list);
                sb.append(key).append(':').append(value).append('$');
            }
        }
        userData = sb.toString();
        return userData.substring(0, userData.length() - 1);
    }

    private static String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str.length() * 2);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': 
                case '%': 
                case ':': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] parseToken(String tokenStr) throws InvalidTokenException {
        String[] fields = new String[3];
        int tokenLen = tokenStr.length();
        int signBegin = -1;
        int expireBegin = -1;
        try {
            for (int i = tokenLen - 1; i > -1; --i) {
                char c = tokenStr.charAt(i);
                if (c != '%' || tokenStr.charAt(i - 1) == '\\') continue;
                if (signBegin == -1) {
                    signBegin = i + 1;
                    continue;
                }
                expireBegin = i + 1;
                break;
            }
            if (expireBegin == -1) {
                expireBegin = signBegin;
                fields[0] = tokenStr.substring(0, expireBegin - 1);
                fields[1] = tokenStr.substring(expireBegin, tokenLen);
            } else {
                fields[0] = tokenStr.substring(0, expireBegin - 1);
                fields[1] = tokenStr.substring(expireBegin, signBegin - 1);
                fields[2] = tokenStr.substring(signBegin, tokenLen);
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Caught an exception when parsing a token. This could mean the token is invalid: ", e.toString());
            throw new InvalidTokenException(e.getMessage(), e);
        }
        return fields;
    }

    public static Map parseUserData(String userData) throws InvalidTokenException {
        ArrayList list;
        int dataLen;
        int keyIndex;
        String data;
        int tokenLen = userData.length();
        int numOfAttribs = 1;
        int lastDelim = 0;
        int i = 0;
        HashMap<String, ArrayList> attribs = new HashMap<String, ArrayList>();
        String key = "";
        String value = "";
        for (i = 0; i < tokenLen; ++i) {
            if (userData.charAt(i) != '$' || userData.charAt(i - 1) == '\\') continue;
            ++numOfAttribs;
            data = userData.substring(lastDelim, i);
            lastDelim = i + 1;
            keyIndex = 0;
            dataLen = data.length();
            for (keyIndex = 0; keyIndex < dataLen; ++keyIndex) {
                if (data.charAt(keyIndex) != ':' || data.charAt(keyIndex - 1) == '\\') continue;
                key = data.substring(0, keyIndex);
                value = data.substring(keyIndex + 1, dataLen);
                list = LTPATokenizer.convertStringToArrayList(value);
                if (list == null) continue;
                attribs.put(key, list);
            }
        }
        data = userData.substring(lastDelim, tokenLen);
        keyIndex = 0;
        dataLen = data.length();
        for (keyIndex = 0; keyIndex < dataLen; ++keyIndex) {
            if (data.charAt(keyIndex) != ':' || data.charAt(keyIndex - 1) == '\\') continue;
            key = data.substring(0, keyIndex);
            value = data.substring(keyIndex + 1, dataLen);
            list = LTPATokenizer.convertStringToArrayList(value);
            if (list == null) continue;
            attribs.put(key, list);
        }
        return attribs;
    }

    private static String convertArrayListToString(ArrayList value) {
        StringBuffer result = new StringBuffer();
        if (value != null && value.size() > 0) {
            String[] type = null;
            type = value.toArray(new String[0]);
            for (int i = 0; i < type.length; ++i) {
                if (i != 0) {
                    result.append(STRING_ATTRIB_DELIM);
                }
                result.append(LTPATokenizer.escape(type[i]));
            }
            return result.toString();
        }
        return null;
    }

    private static ArrayList convertStringToArrayList(String value) {
        if (value != null && value.length() > 0) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(value, STRING_ATTRIB_DELIM);
            while (st.hasMoreTokens()) {
                String nextString = LTPATokenizer.unescape(st.nextToken());
                if (nextString == null) continue;
                result.add(nextString);
            }
            return result;
        }
        return null;
    }

    private static String unescape(String str) {
        StringBuffer sb = new StringBuffer(str.length() * 2);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && i < len - 1) {
                char d = str.charAt(i + 1);
                if (d == '$' || d == ':' || d == '%') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

