/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.ltpa.LTPATokenizer;
import com.ibm.ws.security.ltpa.UserData;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class LTPAToken
implements Token,
Serializable {
    private static final TraceComponent tc = Tr.register(LTPAToken.class, null, "com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private int defaultExpirationMins = 120;
    private byte[] signature;
    public static final String DELIM = "%";
    private byte[] encryptedBytes = null;
    private byte[] sharedKey = null;
    private LTPAPrivateKey privateKey = null;
    private LTPAPublicKey publicKey = null;
    private String userId = null;
    private short version = 1;
    static long ecreated = 0L;
    static long ecacheHits = 0L;
    static long vcreated = 0L;
    static long vcacheHits = 0L;

    public LTPAToken(byte[] tokenBytes, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LTPAToken(byte[],byte[],LTPAPrivateKey,LTPAPublicKey");
        }
        LTPAToken.checkTokenBytes(tokenBytes);
        this.expiration = 0L;
        this.sharedKey = _sharedKey;
        this.privateKey = _privateKey;
        this.publicKey = _publicKey;
        this.encryptedBytes = tokenBytes;
        this.decrypt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LTPAToken(byte[],byte[],LTPAPrivateKey,LTPAPublicKey");
        }
    }

    public LTPAToken(String _accessID, long expirationTime, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "new LTPAToken from accessID");
        }
        this.encryptedBytes = null;
        this.expiration = (System.currentTimeMillis() + expirationTime * 60L * 1000L + 60000L) / 60000L * 60000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.sharedKey = _sharedKey;
        this.privateKey = _privateKey;
        this.publicKey = _publicKey;
        this.userData = new UserData(_accessID);
        this.userId = _accessID;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new LTPAToken from accessID");
        }
    }

    protected LTPAToken(long expiration, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey, UserData userdata) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "new LTPAToken from clone");
        }
        this.encryptedBytes = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshing expiration of token.");
        }
        Long expTime = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("LTPA").getLong("timeout");
        this.expiration = (System.currentTimeMillis() + expTime * 60L * 1000L + 60000L) / 60000L * 60000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.sharedKey = _sharedKey;
        this.privateKey = _privateKey;
        this.publicKey = _publicKey;
        this.userData = userdata;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new LTPAToken from clone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encrypt() {
        int i;
        LTPAServerObject ltpaServerObject = null;
        try {
            ltpaServerObject = LTPAServerObject.getLTPAServer();
        }
        catch (Exception ex) {
            // empty catch block
        }
        HashMap ehm = ltpaServerObject.getLTPAKeyCache(1);
        LinkedList ell = ltpaServerObject.getLinkedList1(1);
        LinkedList el2 = ltpaServerObject.getLinkedList2(1);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encrypt.key.cache.size:" + ehm.size() + " ell:" + ell.size() + " el2:" + el2.size());
        }
        byte[] encdBytes = Base64Coder.base64Encode(this.signature);
        String signStr = StringUtil.toString(encdBytes);
        String ud = this.userData.toString();
        byte[] accessID = LTPAToken.toBytes(ud);
        StringBuffer sb = new StringBuffer(DELIM);
        sb.append(this.expiration).append(DELIM).append(signStr);
        String key = sb.toString();
        byte[] timeAndSign = StringUtil.getBytes(key);
        HashMap hashMap = ehm;
        synchronized (hashMap) {
            byte[] tmp = (byte[])ehm.get(key);
            if (tmp != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cache hit in encrypt.");
                }
                ++ecacheHits;
                this.encryptedBytes = new byte[tmp.length];
                System.arraycopy(tmp, 0, this.encryptedBytes, 0, tmp.length);
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tokenData before encrypt: " + key);
        }
        byte[] toBeEnc = new byte[accessID.length + timeAndSign.length];
        for (i = 0; i < accessID.length; ++i) {
            toBeEnc[i] = accessID[i];
        }
        for (i = accessID.length; i < toBeEnc.length; ++i) {
            toBeEnc[i] = timeAndSign[i - accessID.length];
        }
        this.encryptedBytes = LTPACrypto.encrypt(toBeEnc, this.sharedKey);
        HashMap hashMap2 = ehm;
        synchronized (hashMap2) {
            ++ecreated;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encrypt [" + ecreated + "/" + ecacheHits + "]added:" + key);
            }
            ehm.put(key, this.encryptedBytes);
            ell.addLast(key);
            el2.addLast(new Long(System.currentTimeMillis()));
            while (ehm.size() > 5000) {
                el2.removeFirst();
                ehm.remove(ell.removeFirst());
            }
            long t = System.currentTimeMillis();
            while (t - (Long)el2.getFirst() > 60000L) {
                el2.removeFirst();
                ehm.remove(ell.removeFirst());
            }
        }
    }

    protected void decrypt() throws InvalidTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt");
        }
        try {
            byte[] decryptBuf = (byte[])this.encryptedBytes.clone();
            byte[] tokenData = LTPACrypto.decrypt(decryptBuf, this.sharedKey);
            LTPAToken.checkTokenBytes(tokenData);
            String UTF8TokenString = LTPAToken.toStrings(tokenData);
            String[] userFields = LTPATokenizer.parseToken(UTF8TokenString);
            Map attribs = LTPATokenizer.parseUserData(userFields[0]);
            this.userData = new UserData(attribs);
            String tokenString = StringUtil.toString(tokenData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenString after decrypt: " + tokenString);
            }
            String[] fields = LTPATokenizer.parseToken(tokenString);
            String[] expirationArray = this.userData.getAttributes("expire");
            if (expirationArray != null && expirationArray[0] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting expiration from userdata area: " + new Date(Long.parseLong(expirationArray[0])));
                }
                this.expiration = Long.parseLong(expirationArray[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting expiration from expiration field: " + new Date(Long.parseLong(fields[1])));
                }
                this.expiration = Long.parseLong(fields[1]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
                }
            }
            String signStr = Base64Coder.base64Decode(fields[2]);
            this.setSignature(StringUtil.getBytes(signStr));
        }
        catch (Throwable t) {
            ContextManagerFactory.getInstance().setRootException(t);
            throw new InvalidTokenException(t.getMessage(), t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt");
        }
    }

    protected void sign() throws NoSuchAlgorithmException {
        byte[] signature = null;
        String dataStr = this.getUserData().toString();
        byte[] data = LTPAToken.toBytes(dataStr);
        signature = LTPADigSignature.sign(data, this.privateKey);
        this.setSignature(signature);
    }

    public boolean isValid() throws InvalidTokenException, TokenExpiredException {
        Date d = new Date();
        Date expD = new Date(this.expiration);
        boolean valid = d.before(expD);
        if (!valid) {
            StringBuffer sb = this.getLogInfo();
            sb.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, sb.toString());
            }
            throw new TokenExpiredException(this.expiration, "Token expiration Date: " + expD + ", current Date: " + d);
        }
        boolean verified = false;
        try {
            verified = this.verify();
        }
        catch (Exception e) {
            verified = false;
            throw new InvalidTokenException(e.getMessage(), e);
        }
        if (!verified) {
            StringBuffer sb = this.getLogInfo();
            sb.insert(0, "invalid signature ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, sb.toString());
            }
        }
        return valid && verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify() throws NoSuchAlgorithmException {
        Boolean tmp;
        LTPAServerObject ltpaServerObject = null;
        try {
            ltpaServerObject = LTPAServerObject.getLTPAServer();
        }
        catch (Exception ex) {
            // empty catch block
        }
        HashMap vhm = ltpaServerObject.getLTPAKeyCache(2);
        LinkedList vll = ltpaServerObject.getLinkedList1(2);
        LinkedList vl2 = ltpaServerObject.getLinkedList2(2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "verify.key.cache.size:" + vhm.size() + " vll:" + vll.size() + " vl2:" + vl2.size());
        }
        boolean verified = false;
        String dataStr = this.getUserData().toString();
        byte[] signature = this.getSignature();
        byte[] data = LTPAToken.toBytes(dataStr);
        StringBuffer sb = new StringBuffer(dataStr);
        sb.append(LTPAToken.toStrings2(signature)).append(LTPAToken.toStrings2(data));
        String key = sb.toString();
        HashMap hashMap = vhm;
        synchronized (hashMap) {
            tmp = (Boolean)vhm.get(key);
            if (tmp != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cache hit in verify.");
                }
                ++vcacheHits;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cache key: " + key);
                }
                return tmp;
            }
        }
        verified = LTPADigSignature.verify(data, signature, this.publicKey);
        hashMap = vhm;
        synchronized (hashMap) {
            ++vcreated;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verify [" + vcreated + "/" + vcacheHits + "]added:" + key);
            }
            tmp = new Boolean(verified);
            vhm.put(key, tmp);
            vll.addLast(key);
            vl2.addLast(new Long(System.currentTimeMillis()));
            while (vhm.size() > 5000) {
                vl2.removeFirst();
                vhm.remove(vll.removeFirst());
            }
            long t = System.currentTimeMillis();
            while (t - (Long)vl2.getFirst() > 60000L) {
                vl2.removeFirst();
                vhm.remove(vll.removeFirst());
            }
        }
        return verified;
    }

    private static String toStrings2(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 3);
        for (int i = b.length - 1; i >= 0; --i) {
            sb.append(b[i]);
        }
        return sb.toString();
    }

    private static String toStrings(byte[] b) {
        String ns = null;
        try {
            ns = new String(b, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "to UTF8 Strings =" + uee.toString());
        }
        return ns;
    }

    private static byte[] toBytes(String str) {
        byte[] b = null;
        try {
            b = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "to UTF8 bytes =" + uee.toString());
        }
        return b;
    }

    public byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        if (this.encryptedBytes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning existing encrypted bytes from token object.");
            }
            return (byte[])this.encryptedBytes.clone();
        }
        try {
            this.sign();
            this.encrypt();
        }
        catch (NoSuchAlgorithmException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NoSuchAlgorithmException: " + e.getMessage(), new Object[]{e});
            }
            throw new InvalidTokenException(e.getMessage(), e);
        }
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Expired or invalid LTPA token constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        return (byte[])this.encryptedBytes.clone();
    }

    public long getExpiration() {
        return this.expiration;
    }

    byte[] getSignature() {
        return this.signature;
    }

    UserData getUserData() {
        return this.userData;
    }

    public String[] addAttribute(String name, String value) {
        return this.userData.addAttribute(name, value);
    }

    public String[] getAttributes(String name) {
        return this.userData.getAttributes(name);
    }

    public Enumeration getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    void setSignature(byte[] newValue) {
        this.signature = newValue;
    }

    public String toString() {
        return StringUtil.toString(this.encryptedBytes);
    }

    public short getVersion() {
        return this.version;
    }

    private StringBuffer getLogInfo() {
        StringBuffer sb = new StringBuffer();
        Enumeration vEnum = this.getAttributeNames();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            String[] attribute = this.getAttributes(key);
            sb.append(key);
            sb.append(": ");
            for (int i = 0; i < attribute.length; ++i) {
                sb.append(attribute[i]);
                if (i >= attribute.length - 1) continue;
                sb.append(" | ");
            }
            sb.append(", ");
        }
        sb.append("Expiration time: ");
        sb.append(dateFormat.format(new Date(this.expiration)));
        return sb;
    }

    public Object clone() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration passed into cloned token: " + this.expiration);
            }
            UserData _userdata = (UserData)this.userData.clone();
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            HashMap primaryMap = ltpaServer.getPrimaryTokenFactoryMap();
            if (primaryMap != null && primaryMap.size() > 0) {
                byte[] tempSharedKey = (byte[])primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
                LTPAPublicKey tempLTPAPubKey = (LTPAPublicKey)primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
                LTPAPrivateKey tempLTPAPrivKey = (LTPAPrivateKey)primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
                if (tempSharedKey != null && tempLTPAPrivKey != null && tempLTPAPubKey != null) {
                    this.sharedKey = tempSharedKey;
                    this.privateKey = tempLTPAPrivKey;
                    this.publicKey = tempLTPAPubKey;
                }
            }
            if (ltpaServer.getSharedKey() != null && ltpaServer.getLtpaPrivateKey() != null && ltpaServer.getLtpaPublicKey() != null) {
                this.sharedKey = ltpaServer.getSharedKey();
                this.privateKey = ltpaServer.getLtpaPrivateKey();
                this.publicKey = ltpaServer.getLtpaPublicKey();
            }
            return new LTPAToken(this.expiration, this.sharedKey, this.privateKey, this.publicKey, _userdata);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPAToken.clone", "591");
            return null;
        }
    }

    public static void checkTokenBytes(byte[] tokenBytes) throws InvalidTokenException {
        if (tokenBytes == null) {
            throw new InvalidTokenException("Token bytes are null");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Token bytes length = " + tokenBytes.length);
        }
        if (tokenBytes.length == 0) {
            throw new InvalidTokenException("Token bytes are empty");
        }
    }
}

