/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.LinkedList;

public final class LTPADigSignature {
    private static final TraceComponent tc = Tr.register(LTPADigSignature.class, null, "com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    static byte[][] testRawPubKey = null;
    static byte[][] testRawPrivKey = null;
    static MessageDigest md1 = null;
    static MessageDigest md2 = null;
    static MessageDigest md1JCE = null;
    static MessageDigest md2JCE = null;
    private static Object lockObj1 = new Object();
    private static Object lockObj2 = new Object();
    static long created;
    static long cacheHits;

    static void generateRSAKeys(byte[][] rsaPubKey, byte[][] rsaPrivKey) {
        byte[][] rsaKey = LTPACrypto.rsaKey(128, true, true);
        rsaPrivKey[2] = rsaKey[2];
        rsaPrivKey[4] = rsaKey[3];
        rsaPrivKey[3] = rsaKey[4];
        rsaPubKey[0] = rsaKey[0];
        rsaPubKey[1] = rsaKey[2];
    }

    static byte[] sign(byte[] mesg, LTPAPrivateKey privKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.sign(mesg, privKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sign(byte[] mesg, LTPAPrivateKey privKey, boolean useJCE) throws NoSuchAlgorithmException {
        byte[] data;
        byte[] b;
        LTPAServerObject ltpaServerObject = null;
        try {
            ltpaServerObject = LTPAServerObject.getLTPAServer();
        }
        catch (Exception ex) {
            // empty catch block
        }
        HashMap hm = ltpaServerObject.getLTPAKeyCache(3);
        LinkedList ll = ltpaServerObject.getLinkedList1(3);
        LinkedList l2 = ltpaServerObject.getLinkedList2(3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sign.key.cache.size:" + hm.size() + " ll:" + ll.size() + " l2:" + l2.size());
        }
        String key = new String(mesg) + useJCE;
        HashMap hashMap = hm;
        synchronized (hashMap) {
            b = (byte[])hm.get(key);
        }
        if (b != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cache hit in sign.");
            }
            byte[] copy = new byte[b.length];
            System.arraycopy(b, 0, copy, 0, b.length);
            ++cacheHits;
            return copy;
        }
        byte[][] rsaPrivKey = privKey.getRawKey();
        Object object = lockObj1;
        synchronized (object) {
            data = useJCE ? md1JCE.digest(mesg) : md1.digest(mesg);
        }
        LTPACrypto.setRSAKey(rsaPrivKey);
        byte[] signature = LTPACrypto.signISO9796(rsaPrivKey, data, 0, data.length, useJCE);
        HashMap hashMap2 = hm;
        synchronized (hashMap2) {
            ++created;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sign [" + created + "/" + cacheHits + "]added:" + key);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "signature:" + StringUtil.toString(signature));
            }
            hm.put(key, signature);
            ll.addLast(key);
            l2.addLast(new Long(System.currentTimeMillis()));
            while (hm.size() > 5000) {
                l2.removeFirst();
                hm.remove(ll.removeFirst());
            }
            long t = System.currentTimeMillis();
            while (t - (Long)l2.getFirst() > 60000L) {
                l2.removeFirst();
                hm.remove(ll.removeFirst());
            }
        }
        return signature;
    }

    static boolean verify(byte[] mesg, byte[] signature, LTPAPublicKey pubKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.verify(mesg, signature, pubKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean verify(byte[] mesg, byte[] signature, LTPAPublicKey pubKey, boolean useJCE) throws NoSuchAlgorithmException {
        byte[] data;
        byte[][] rsaPubKey = pubKey.getRawKey();
        Object object = lockObj2;
        synchronized (object) {
            data = useJCE ? md2JCE.digest(mesg) : md2.digest(mesg);
        }
        boolean ok = LTPACrypto.verifyISO9796(rsaPubKey, data, 0, data.length, signature, 0, signature.length, useJCE);
        return ok;
    }

    static LTPAKeyPair generateLTPAKeyPair() {
        byte[][] rsaPubKey = new byte[2][];
        byte[][] rsaPrivKey = new byte[8][];
        LTPADigSignature.generateRSAKeys(rsaPubKey, rsaPrivKey);
        LTPAPublicKey pubKey = new LTPAPublicKey(rsaPubKey);
        LTPAPrivateKey privKey = new LTPAPrivateKey(rsaPrivKey);
        return new LTPAKeyPair(pubKey, privKey);
    }

    static {
        try {
            md1JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            md2JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
        }
        catch (NoSuchAlgorithmException e) {
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPADigSignature", "53");
        }
        catch (NoSuchProviderException e) {
            Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPADigSignature", "57");
        }
        if (LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA()) {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            }
            catch (NoSuchAlgorithmException e) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
                FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPADigSignature", "66");
            }
            catch (NoSuchProviderException e) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
                FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPADigSignature", "70");
            }
        } else {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPADigSignature", "77");
            }
        }
        created = 0L;
        cacheHits = 0L;
    }
}

