/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.ltpa.LTPATokenizer;
import com.ibm.ws.security.ltpa.UserData;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AuthzPropToken
implements Token,
Serializable {
    private static final TraceComponent tc = Tr.register(AuthzPropToken.class, null, "com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private static final char DELIM = '|';
    private int defaultExpirationMins = 10;
    private byte[] tokenData = null;
    private byte[] sharedKey = null;
    private LTPAPrivateKey privateKey = null;
    private LTPAPublicKey publicKey = null;
    private short version = 1;

    public AuthzPropToken(byte[] tokenBytes, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from byte[]");
        }
        this.expiration = 0L;
        this.tokenData = tokenBytes;
        this.decode();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from byte[]");
        }
    }

    public AuthzPropToken(String _accessID, long expirationTime, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from accessID");
        }
        this.expiration = System.currentTimeMillis() + expirationTime * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.tokenData = null;
        this.userData = new UserData(_accessID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from accessID");
        }
    }

    protected AuthzPropToken(long expiration, byte[] _sharedKey, LTPAPrivateKey _privateKey, LTPAPublicKey _publicKey, UserData userdata) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from userData");
        }
        long currentTime = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshing expiration of token.");
        }
        Long expTime = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("LTPA").getLong("timeout");
        this.expiration = currentTime + expTime * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.tokenData = null;
        this.userData = userdata;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from userData");
        }
    }

    protected void encode() {
        String ud = this.userData.toString();
        StringBuffer sb = new StringBuffer();
        sb.append(this.expiration).append('|').append(ud);
        String tokenString = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tokenString before encode: " + tokenString);
        }
        this.tokenData = AuthzPropToken.toBytes(tokenString);
    }

    protected void decode() throws InvalidTokenException {
        block8: {
            String UTF8TokenString = AuthzPropToken.toStrings(this.tokenData);
            int tokenLen = UTF8TokenString.length();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before parsing, length: " + tokenLen, ", string: " + UTF8TokenString);
            }
            int userDataBegin = -1;
            int expireBegin = 0;
            try {
                for (int i = 0; i < tokenLen - 1; ++i) {
                    char c = UTF8TokenString.charAt(i);
                    if (i > 0 && UTF8TokenString.charAt(i - 1) == '\\' || c != '|' || userDataBegin != -1) continue;
                    userDataBegin = i + 1;
                    break;
                }
                if (userDataBegin != -1) {
                    String expString = UTF8TokenString.substring(expireBegin, userDataBegin - 1);
                    this.expiration = Long.parseLong(expString);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
                    }
                    Map attribs = LTPATokenizer.parseUserData(UTF8TokenString.substring(userDataBegin, tokenLen));
                    this.userData = new UserData(attribs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userData after decode: " + this.userData.toString());
                    }
                    break block8;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UserData delimiter not found.");
                }
                throw new InvalidTokenException("UserData delimiter not found.");
            }
            catch (Exception e) {
                throw new InvalidTokenException(e.getMessage(), e);
            }
        }
    }

    public boolean isValid() throws InvalidTokenException, TokenExpiredException {
        Date d = new Date();
        Date expD = new Date(this.expiration);
        boolean valid = d.before(expD);
        if (!valid) {
            StringBuffer sb = this.getLogInfo();
            sb.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, sb.toString());
            }
            throw new TokenExpiredException(this.expiration, "Token expiration Date: " + expD + ", current Date: " + d);
        }
        return valid;
    }

    private static String toStrings(byte[] b) {
        String ns = null;
        try {
            ns = new String(b, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "to UTF8 Strings =" + uee.toString());
        }
        return ns;
    }

    private static byte[] toBytes(String str) {
        byte[] b = null;
        try {
            b = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Tr.debug(tc, "to UTF8 bytes =" + uee.toString());
        }
        return b;
    }

    public byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        if (this.tokenData != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning existing encoded bytes from token object.");
            }
            return this.tokenData;
        }
        this.encode();
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Expired or invalid LTPA token constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        return this.tokenData;
    }

    public long getExpiration() {
        return this.expiration;
    }

    UserData getUserData() {
        return this.userData;
    }

    public String[] addAttribute(String name, String value) {
        this.tokenData = null;
        return this.userData.addAttribute(name, value);
    }

    public String[] getAttributes(String name) {
        return this.userData.getAttributes(name);
    }

    public Enumeration getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    public String toString() {
        return StringUtil.toString(this.tokenData);
    }

    public short getVersion() {
        return this.version;
    }

    private StringBuffer getLogInfo() {
        StringBuffer sb = new StringBuffer();
        Enumeration vEnum = this.getAttributeNames();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            String[] attributes = this.getAttributes(key);
            sb.append(key);
            sb.append(": ");
            sb.append(attributes);
            sb.append(", ");
        }
        sb.append("Expiration time: ");
        sb.append(dateFormat.format(new Date(this.expiration)));
        return sb;
    }

    public Object clone() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration passed into cloned token: " + this.expiration);
            }
            UserData _userdata = (UserData)this.userData.clone();
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            HashMap primaryMap = ltpaServer.getPrimaryTokenFactoryMap();
            if (primaryMap != null && primaryMap.size() > 0) {
                byte[] tempSharedKey = (byte[])primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
                LTPAPublicKey tempLTPAPubKey = (LTPAPublicKey)primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
                LTPAPrivateKey tempLTPAPrivKey = (LTPAPrivateKey)primaryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
                if (tempSharedKey != null && tempLTPAPrivKey != null && tempLTPAPubKey != null) {
                    this.sharedKey = tempSharedKey;
                    this.privateKey = tempLTPAPrivKey;
                    this.publicKey = tempLTPAPubKey;
                }
            }
            if (ltpaServer.getSharedKey() != null && ltpaServer.getLtpaPrivateKey() != null && ltpaServer.getLtpaPublicKey() != null) {
                this.sharedKey = ltpaServer.getSharedKey();
                this.privateKey = ltpaServer.getLtpaPrivateKey();
                this.publicKey = ltpaServer.getLtpaPublicKey();
            }
            return new AuthzPropToken(this.expiration, this.sharedKey, this.privateKey, this.publicKey, _userdata);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.AuthzPropToken.clone", "366");
            return null;
        }
    }
}

