/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ejb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.ejb.BeanAccessContext;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.wsspi.security.policy.EJBSecurityPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;

public class BeanPermissionRoleMap
extends PermissionRoleMap {
    private static TraceComponent tc = Tr.register(BeanPermissionRoleMap.class, null, "com.ibm.ejs.resources.security");
    private static int MAX_ROLE_ENTRIES = 600;
    private HashMap<AccessContext, SecurityRole[]> requiredRolesCache = new HashMap(MAX_ROLE_ENTRIES);

    protected SecurityRole[] getRequiredRoles(AccessContext ctx, String resourceName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredRoles(AccessContext,String,String)");
        }
        SecurityRole[] requiredRoles = null;
        BeanAccessContext beanContext = null;
        EJBSecurityPolicy policy = null;
        if (!(ctx instanceof BeanAccessContext)) {
            throw new IllegalArgumentException("AccessContext received is not a BeanAccessContext: " + ctx);
        }
        beanContext = (BeanAccessContext)ctx;
        policy = beanContext.getEJBSecurityPolicy();
        if (policy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJBSecurityPolicy is null, getting roles from deployment descriptor.");
            }
            requiredRoles = this.getRequiredRolesFromDD(ctx, resourceName, methodName);
        } else {
            requiredRoles = this.requiredRolesCache.get(ctx);
            if (requiredRoles == null) {
                String[] roles = policy.getRolesAllowed();
                if (policy.isPermitAll()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isPermitAll = true, return NO_REQUIRED_ROLES");
                    }
                    requiredRoles = NO_REQUIRED_ROLES;
                } else if (roles == null || roles.length == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRolesAllowed = null or empty, return NO_REQUIRED_ROLES");
                    }
                    requiredRoles = NO_REQUIRED_ROLES;
                } else {
                    requiredRoles = new SecurityRole[roles.length];
                    for (int i = 0; i < roles.length; ++i) {
                        String roleName = roles[i];
                        requiredRoles[i] = WCCMHelper.createSecurityRole("Role description is not available.", roleName);
                    }
                }
                if (this.requiredRolesCache.size() == MAX_ROLE_ENTRIES) {
                    this.requiredRolesCache.clear();
                }
                this.requiredRolesCache.put(ctx, requiredRoles);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredRoles(AccessContext,String,String)", Arrays.asList(requiredRoles));
        }
        return requiredRoles;
    }

    private SecurityRole[] getRequiredRolesFromDD(AccessContext ctx, String resourceName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredRoles() resource = " + resourceName + " method = " + methodName);
        }
        Vector<SecurityRole> requiredRolesSet = new Vector<SecurityRole>();
        String[] methodParamTypes = new String[]{};
        int index = resourceName.lastIndexOf(58);
        String beanName = resourceName.substring(index + 1);
        try {
            EJBJar ejbjar;
            AssemblyDescriptor ad;
            int i;
            int to_index;
            index = methodName.lastIndexOf(58);
            if (index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            String methodInterface = methodName.substring(index + 1);
            int methodIntf = Integer.parseInt(methodInterface);
            String workString = methodName;
            int from_index = workString.indexOf(58);
            index = from_index;
            if (index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            if ((to_index = workString.indexOf(44)) == -1) {
                to_index = workString.lastIndexOf(58);
            }
            if (to_index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            if (from_index + 1 != to_index) {
                Vector<String> params = new Vector<String>();
                String param = null;
                i = 0;
                while (true) {
                    if (i != 0) {
                        from_index = -1;
                        to_index = workString.indexOf(44);
                        if (to_index == -1) {
                            to_index = workString.lastIndexOf(58);
                        }
                    }
                    if (to_index == -1) break;
                    param = workString.substring(from_index + 1, to_index);
                    workString = workString.substring(to_index + 1);
                    params.add(param);
                    ++i;
                }
                methodParamTypes = params.toArray(new String[0]);
            }
            String method2 = null;
            index = methodName.indexOf(58);
            if (index == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid format for methodName, ", methodName);
                }
            } else {
                method2 = methodName.substring(0, index);
            }
            if ((ad = (ejbjar = ((BeanAccessContext)ctx).getEjbJar()).getAssemblyDescriptor()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Assembly Descriptor");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequiredRoles");
                }
                return NO_REQUIRED_ROLES;
            }
            EList mpList = ad.getMethodPermissions();
            if (mpList == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Method Permission in Assembly Descriptor");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRequiredRoles");
                }
                return NO_REQUIRED_ROLES;
            }
            MethodPermission[] mp = mpList.toArray(new MethodPermission[0]);
            for (i = 0; i < mp.length; ++i) {
                EList roleList = mp[i].getRoles();
                if (roleList == null && !mp[i].isUnchecked()) continue;
                SecurityRole[] roles = roleList.toArray(new SecurityRole[0]);
                EList methodElementList = mp[i].getMethodElements();
                if (methodElementList == null) continue;
                MethodElement[] me = methodElementList.toArray(new MethodElement[0]);
                for (int j = 0; j < me.length; ++j) {
                    int methodInfType;
                    if (me[j].getEnterpriseBean() == null || !me[j].getEnterpriseBean().getName().equals(beanName) || !me[j].getName().equals(method2) && !me[j].getName().equals("*") || (methodInfType = me[j].getType() != null ? me[j].getType().getValue() : 0) != methodIntf && methodInfType != 0) continue;
                    List dd_methodParamsList = me[j].getMethodParams();
                    if (dd_methodParamsList != null && me[j].hasMethodParams()) {
                        int k;
                        String[] dd_methodParams = dd_methodParamsList.toArray(new String[0]);
                        for (k = 0; k < dd_methodParams.length && k < methodParamTypes.length && dd_methodParams[k].equals(methodParamTypes[k]); ++k) {
                        }
                        if (k != dd_methodParams.length || k != methodParamTypes.length) continue;
                    }
                    if (mp[i].isUnchecked()) {
                        return NO_REQUIRED_ROLES;
                    }
                    for (int l = 0; l < roles.length; ++l) {
                        if (requiredRolesSet.contains(roles[l])) continue;
                        requiredRolesSet.add(roles[l]);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ejb.BeanPermissionRoleMap.getRequiredRoles", "219", this);
            Tr.error(tc, "security.ejb.getreqrole.exception", new Object[]{methodName, resourceName, e});
        }
        SecurityRole[] requiredRoles = requiredRolesSet.toArray(new SecurityRole[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Required roles are");
            for (int ii = 0; ii < requiredRoles.length; ++ii) {
                Tr.debug(tc, requiredRoles[ii].getRoleName());
            }
            Tr.debug(tc, ".");
        }
        if (requiredRoles.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning no Required roles");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRequiredRoles");
            }
            return NO_REQUIRED_ROLES;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredRoles");
        }
        return requiredRoles;
    }

    public String getMappedRole(String roleRef, SecurityBeanCookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedRole, roleRef=[" + roleRef + "], SecurityBeanCookie=" + cookie.toString());
        }
        String roleName = null;
        EList roleRefList = cookie.getRoleRefList();
        if (roleRefList != null) {
            SecurityRoleRef[] rf = roleRefList.toArray(new SecurityRoleRef[0]);
            for (int j = 0; j < rf.length; ++j) {
                if (!rf[j].getName().equals(roleRef)) continue;
                roleName = rf[j].getLink();
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "beanName = " + cookie.getBeanName());
            Tr.debug(tc, "Mapped Role name for " + roleRef + "=" + roleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMappedRole, [" + roleName + "]");
        }
        return roleName;
    }

    public static boolean findMatchingMethod(String beanName, String methodName, EList methodElementList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMatchingMethod() bean = " + beanName + " method = " + methodName);
        }
        String[] methodParamTypes = new String[]{};
        try {
            int to_index;
            int index = methodName.lastIndexOf(58);
            if (index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            String methodInterface = methodName.substring(index + 1);
            int methodIntf = Integer.parseInt(methodInterface);
            String workString = methodName;
            int from_index = workString.indexOf(58);
            index = from_index;
            if (index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            if ((to_index = workString.indexOf(44)) == -1) {
                to_index = workString.lastIndexOf(58);
            }
            if (to_index == -1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid format for methodName, ", methodName);
            }
            if (from_index + 1 != to_index) {
                Vector<String> params = new Vector<String>();
                String param = null;
                int i = 0;
                while (true) {
                    if (i != 0) {
                        from_index = -1;
                        to_index = workString.indexOf(44);
                        if (to_index == -1) {
                            to_index = workString.lastIndexOf(58);
                        }
                    }
                    if (to_index == -1) break;
                    param = workString.substring(from_index + 1, to_index);
                    workString = workString.substring(to_index + 1);
                    params.add(param);
                    ++i;
                }
                methodParamTypes = params.toArray(new String[0]);
            }
            String method2 = null;
            index = methodName.indexOf(58);
            if (index == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid format for methodName, ", methodName);
                }
            } else {
                method2 = methodName.substring(0, index);
            }
            MethodElement[] me = methodElementList.toArray(new MethodElement[0]);
            for (int j = 0; j < me.length; ++j) {
                int methodInfType;
                if (me[j].getEnterpriseBean() == null || !me[j].getEnterpriseBean().getName().equals(beanName) || !me[j].getName().equals(method2) && !me[j].getName().equals("*") || (methodInfType = me[j].getType() != null ? me[j].getType().getValue() : 0) != methodIntf && methodInfType != 0) continue;
                List dd_methodParamsList = me[j].getMethodParams();
                if (dd_methodParamsList != null && dd_methodParamsList.size() > 0) {
                    int k;
                    String[] dd_methodParams = dd_methodParamsList.toArray(new String[0]);
                    for (k = 0; k < dd_methodParams.length && k < methodParamTypes.length && dd_methodParams[k].equals(methodParamTypes[k]); ++k) {
                    }
                    if (k != dd_methodParams.length || k != methodParamTypes.length) continue;
                }
                return true;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.ejb.BeanPermissionRoleMap.findMatchingMethod", "403");
            Tr.error(tc, "security.ejb.beanperm.matchmetherr", new Object[]{methodName, beanName, e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMatchingMethod");
        }
        return false;
    }
}

