/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

class SimpleDelegation
implements Delegation {
    private static AuditService auditService = null;
    private String activeUserRegistry = null;
    private static ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private static final TraceComponent tc = Tr.register(SimpleDelegation.class, null, "com.ibm.ejs.resources.security");

    SimpleDelegation() {
    }

    public Subject delegate(EJBKey ejbKey, EJBMethodInfo methodInfo, Subject ownSubject, Subject receivedSubject, SecurityBeanCookie beanCookie, String methodName) throws CSIException {
        ContextHandler contextHandler = null;
        if (auditService == null) {
            auditService = ContextManagerFactory.getInstance().getAuditService();
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "SUCCESS")) {
            if (contextHandler != null) {
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "receivedSubject not null, rSubj: " + rSubj);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receivedSubject null, rSubj null");
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, beanCookie.getAppName().concat(":").concat(beanCookie.getBeanName()).concat(":").concat(methodName), "ejb", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildDelegationData("runAsDelegaton", "clientId", rSubj);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "data: " + data.toString());
                }
                contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 86L);
            }
            try {
                auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
            }
            catch (ProviderFailureException pe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, pe);
            }
        }
        return receivedSubject;
    }

    public Subject delegate(Subject receivedSubject, String contextRoot, WebAccessContext webAccessContext, String servletName) throws CSIException {
        ContextHandler contextHandler = null;
        if (auditService == null) {
            auditService = ContextManagerFactory.getInstance().getAuditService();
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "SUCCESS")) {
            if (contextHandler != null) {
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "receivedSubject not null, rSubj: " + rSubj);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receivedSubject null, rSubj null");
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(webAccessContext != null ? webAccessContext.getWebAppName() : null, "delegation", rSubj, rSubj, null, null, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildDelegationData("runAsDelegaton", "clientId", rSubj);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "data: " + data.toString());
                }
                contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 86L);
            }
            try {
                auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
            }
            catch (ProviderFailureException pe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, pe);
            }
        }
        return receivedSubject;
    }
}

