/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    private static final TraceComponent tc = Tr.register(TrustedIDEvaluatorImpl.class, "Security", "com.ibm.ejs.resources.security");

    public TrustedIDEvaluatorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isTrusted(String name, String password) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String alternateTrustedId = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId");
        String alternateTrustedPassword = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword");
        String serverTrustedId = csiv2.getString("com.ibm.CORBA.loginUserid");
        String serverTrustedPassword = csiv2.getString("com.ibm.CORBA.loginPassword");
        if (serverTrustedId != null && !serverTrustedId.equals("") && name != null && name.equalsIgnoreCase(serverTrustedId) && serverTrustedPassword != null && !serverTrustedPassword.equals("") && password != null && password.equalsIgnoreCase(serverTrustedPassword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The server ID/password is from this cell, returning true.");
            }
            return true;
        }
        if (alternateTrustedId != null && name.equalsIgnoreCase(alternateTrustedId) && alternateTrustedPassword != null && password != null && password.equalsIgnoreCase(alternateTrustedPassword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The alternate ID/password is from this cell, returning true.");
            }
            return true;
        }
        if (serverTrustedId != null && !serverTrustedId.equals("") && (serverTrustedPassword == null || serverTrustedPassword.equals(""))) {
            if (name != null && name.equalsIgnoreCase(serverTrustedId)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The server ID is from this cell, returning true.");
                }
                return true;
            }
            try {
                Subject serverSubject = ContextManagerFactory.getInstance().getServerSubject();
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(serverSubject);
                if (wsCred != null) {
                    String serverAccessID = wsCred.getAccessId();
                    String serverUniqueID = wsCred.getUniqueSecurityName();
                    String securityName = wsCred.getSecurityName();
                    if (serverAccessID != null && name.equalsIgnoreCase(serverAccessID) || serverUniqueID != null && name.equalsIgnoreCase(serverUniqueID) || securityName != null && name.equalsIgnoreCase(securityName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The server access ID, secuirty name, or unique server ID is from this cell, returning true.");
                        }
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting access ID from server credential.", new Object[]{e});
                }
                return false;
            }
        }
        return this.isTrusted(name);
    }

    public boolean isTrusted(String name) {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String s = csiv2.getString("com.ibm.CSI.trustedPrincipalList");
        StringTokenizer st = new StringTokenizer(s, "|");
        while (st.hasMoreTokens()) {
            if (!TrustedIDEvaluatorImpl.clean(st.nextToken()).equalsIgnoreCase(name)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The serverID " + name + " has been found in the trusted list.");
            }
            return true;
        }
        st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            if (!TrustedIDEvaluatorImpl.clean(st.nextToken()).equalsIgnoreCase(name)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The serverID " + name + " has been found in the trusted list.");
            }
            return true;
        }
        return false;
    }

    public boolean isTrusted(X509Certificate[] cert) {
        boolean isTrusted = false;
        if (cert != null && cert[0] != null) {
            String transportPrincipal = cert[0].getIssuerDN().getName();
            isTrusted = this.isTrusted(transportPrincipal);
        } else {
            Tr.debug(tc, "cert chain or the first cert is null");
        }
        return isTrusted;
    }

    public static String clean(String inString) {
        String outString = null;
        if (inString != null && ((outString = inString.trim()).startsWith("\"") && outString.endsWith("\"") || outString.startsWith("'") && outString.endsWith("'"))) {
            outString = outString.substring(1, outString.length() - 1).trim();
        }
        return outString;
    }
}

