/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.distSecurityComponentImpl;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.List;

public final class zOSSecurityComponentImpl
extends distSecurityComponentImpl {
    private static final TraceComponent tc = Tr.register(zOSSecurityComponentImpl.class, "Security", "com.ibm.ejs.resources.security");
    private PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();

    zOSSecurityComponentImpl(SecurityComponentImpl proxy) {
        super(proxy);
    }

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        try {
            String CurrentBitmode = System.getProperty("com.ibm.vm.bitmode");
            int bitmode = Integer.parseInt(CurrentBitmode);
            if (bitmode == 64) {
                System.loadLibrary("bbgsec");
            } else {
                System.loadLibrary("bbosec");
            }
        }
        catch (UnsatisfiedLinkError ule) {
            Tr.event(tc, "Unable to load BBOSEC DLL", ule);
            throw new ConfigurationError(ule);
        }
        super.initialize(config);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    void initializeSecurityConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zOS initializeSecurityConfig");
        }
        super.initializeSecurityConfig();
        String genericShortName = this.getGenericShortName();
        if (genericShortName != null) {
            SecurityObjectLocator.getAdminData().setString("generic.server.short.name", genericShortName);
        }
        NativeConfiguration nativeConfig = NativeConfiguration.getConfig();
        nativeConfig.initializeConfiguration();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zOS initializeSecurityConfig");
        }
    }

    private String getGenericShortName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericShortName");
        }
        String serverName = null;
        String genericShortName = null;
        try {
            ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
            serverName = configService.getServerName();
            ConfigScope scope = configService.createScope(3);
            List resource = configService.getDocumentObjects(scope, "serverindex.xml");
            ConfigObject serverIndex = (ConfigObject)resource.get(0);
            List servers = serverIndex.getObjectList("serverEntries");
            for (ConfigObject server : servers) {
                if (!serverName.equals(server.getString("serverName", null))) continue;
                genericShortName = server.getString("genericShortName", null);
                break;
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Unable to get generic short name", e);
            genericShortName = serverName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericShortName");
        }
        return genericShortName;
    }

    void configureRoleBasedAuthz(ConfigRoot cfgRoot, String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureRoleBasedAuthz", new Object[]{cfgRoot, appName});
        }
        if (!appName.equals("naming-authz")) {
            super.configureRoleBasedAuthz(cfgRoot, appName);
        } else if (appName.equals("naming-authz") && this.isController()) {
            super.configureRoleBasedAuthz(cfgRoot, appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSecurityMBeans");
        }
        super.initializeSecurityMBeans();
        SecurityAdminHelper.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSecurityMBeans");
        }
    }

    boolean isController() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isController");
        }
        boolean controller = this.platformHelper.isControlJvm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isController", new Boolean(controller));
        }
        return controller;
    }
}

