/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.AuthorizationConfig;
import com.ibm.ws.security.config.AuthorizationProviderConfig;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.AppContextManagerFactory;
import com.ibm.ws.security.core.AppContextManagerImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityAdmin;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityDM;
import com.ibm.ws.security.core.SecurityManager;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.policy.JaccPolicyDomainProxy;
import com.ibm.ws.security.policy.NullDynamicPolicy;
import com.ibm.ws.security.policy.WSDynamicPolicy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.DomainContextHelper;
import com.ibm.ws.security.util.JaccUtil;
import com.ibm.ws.security.util.ORBUtils;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.security.authorization.InitializeJACCProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.ecore.resource.Resource;

public class distSecurityComponentImpl
extends ComponentImpl
implements SecurityService,
ConfigChangeListener {
    private static final TraceComponent tc = Tr.register(distSecurityComponentImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private Repository repository = null;
    private EndPointMgr endPointMgr = null;
    private boolean globalSecurityEnabled = true;
    private boolean serverSecurityEnabled = true;
    private boolean securityServiceStarted = false;
    private String processType = null;
    private SecurityServer secServer = null;
    private ArrayList listeners = new ArrayList(32);
    private static RoleBasedConfigurator configurator = null;
    private InitializeJACCProvider initializeJACCProvider = null;
    private static AuditService _auditService = null;
    private boolean expandedVariables = false;
    private boolean auditEnabled = false;
    SecurityComponentImpl Proxy = null;
    private static final String START_EVENT = "start";
    private static final String STOP_EVENT = "stop";
    private ObjectName objName = null;
    private static boolean orbServiceAvailable = true;
    private SecurityConfig _security = null;
    private SecurityConfig _appSecurity = null;
    private static Object _lockObj = new Object();
    private String nameOfNode = null;

    distSecurityComponentImpl(SecurityComponentImpl proxy) {
        this.Proxy = proxy;
    }

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        try {
            this.initializeWCCMConfig();
            DomainInfo.setAdminRealm(this._security.getActiveUserRegistry().getString("realm"));
            this.setAppSecurityInfo();
            this.initializeAuditWCCMConfig();
            this.initializeJava2Sec();
            this.initializeJAAS();
            this.initializeSecurityConfig();
            try {
                if (this.auditEnabled) {
                    this.initializeAudit();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.initializeSSOTAI();
            Tr.info(tc, "security.init.startcomplete");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.initialize", "334", this);
            Tr.audit(tc, "security.init.svcstartfail");
            if (e instanceof ConfigurationError) {
                throw (ConfigurationError)e;
            }
            if (e instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)e;
            }
            throw new ConfigurationError(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, START_EVENT);
            }
            try {
                if (this.globalSecurityEnabled) {
                    TrustAssociationManager.getInstance();
                    String serverType = AdminServiceFactory.getAdminService().getServerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server type: " + serverType);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "orbServiceAvailable: " + orbServiceAvailable);
                    }
                    if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        Properties prop;
                        String dmzProp;
                        Properties metadataProps = new Properties();
                        ManagedObjectMetadataAccessor metadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(metadataProps);
                        ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(metadataAccessor);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nameOfNode: " + this.nameOfNode);
                        }
                        if (!(dmzProp = (prop = metadataHelper.getAccessor().getMetadataProperties(this.nameOfNode)).getProperty("com.ibm.websphere.baseProductShortName")).equalsIgnoreCase("nddmz") && !serverType.equals("PROXY_SERVER") && !serverType.equals("ONDEMAND_ROUTER") && orbServiceAvailable) {
                            this.bindRegistries();
                        }
                    } else if (!serverType.equals("PROXY_SERVER") && !serverType.equals("ONDEMAND_ROUTER") && orbServiceAvailable) {
                        this.bindRegistries();
                    }
                    this.registerListenerWithAdminService();
                }
                if (this.processType.equals("NodeAgent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security server is being started");
                    }
                    this.initialize();
                    this.fireStartedEvent();
                    this.securityServiceStarted = true;
                    Tr.info(tc, "securityServiceStarted is true");
                    Tr.info(tc, "security.init.svcstartcomplete");
                    Tr.info(tc, "security.init.secstatus", new Object[]{new Boolean(this.globalSecurityEnabled)});
                }
                try {
                    EJBContainer ejbContainer = (EJBContainer)this.Proxy.GetService(EJBContainer.class);
                    if (ejbContainer == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempt to get EJBContainer failed");
                        }
                        break block19;
                    }
                    AppContextManagerImpl appContextMgr = (AppContextManagerImpl)AppContextManagerFactory.getInstance();
                    appContextMgr.initialize(ejbContainer);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.start", "399", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempt to initialize AppContextManager failed", e);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.start", "406", this);
                Tr.error(tc, "security.init.error", new Object[]{e});
                Tr.audit(tc, "security.init.svcstartfail");
                throw new RuntimeError(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, START_EVENT);
        }
    }

    private void bindRegistries() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindRegistries");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig("security");
        this.bindRegistry(security2);
        security2 = SecurityObjectLocator.getSecurityConfig("AppSecurity");
        if (security2 != null) {
            this.bindRegistry(security2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindRegistries");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void bindRegistry(SecurityConfig security) throws Exception {
        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry(distSecurityComponentImpl.tc, "bindRegistry " + security);
        }
        if ((urc = security.getActiveUserRegistry()) == null) {
            if (distSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.exit(distSecurityComponentImpl.tc, "bindRegistry has no active user registry: returning as we assume this is an application domain");
            }
            return;
        }
        registryImpl = (UserRegistry)urc.getUserRegistryImpl();
        objref = null;
        ic = null;
        userReg = null;
        tmpUserReg = null;
        ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr.getPlatformHelper().isZOS() && ctxMgr.getPlatformHelper().isServantJvm()) {
            if (distSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.exit(distSecurityComponentImpl.tc, "bindRegistry in SR, Using Local version of userRegistryImpl");
            }
            return;
        }
        remoteReg = security.getProperty("WAS_UseRemoteRegistry");
        if (remoteReg != null && (remoteReg.equalsIgnoreCase("node") || remoteReg.equalsIgnoreCase("cell"))) {
            if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                Tr.debug(distSecurityComponentImpl.tc, "bindRegistry using remote user registry");
            }
            try {
                ic = new InitialContext();
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "529", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Failed to get initial Naming Context");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.get.initCtx", new Object[]{e});
                throw e;
            }
            try {
                if (remoteReg.equalsIgnoreCase("node")) {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug(distSecurityComponentImpl.tc, "bindRegistry looking up node's registry");
                    }
                    objref = ic.lookup("thisNode/nodeAgent/AdminUserRegistry");
                } else {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug(distSecurityComponentImpl.tc, "bindRegistry looking up cell's registry");
                    }
                    objref = ic.lookup("cell/deploymentManager/AdminUserRegistry");
                }
                tmpUserReg = (UserRegistry)PortableRemoteObject.narrow((Object)objref, UserRegistry.class);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "547", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "createRegistryObjects Failed to find user registry in name space");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.find.registry", new Object[]{e});
                throw e;
            }
            try {
                ic.rebind("AdminUserRegistry", (Object)tmpUserReg);
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "557", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Error binding User Registry");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.bind.registry", new Object[]{e});
                throw e;
            }
            try {
                objref = ic.lookup("AdminUserRegistry");
                userReg = (UserRegistry)PortableRemoteObject.narrow((Object)objref, UserRegistry.class);
                urc.setUserRegistryStub(userReg);
                if (!distSecurityComponentImpl.tc.isDebugEnabled()) ** GOTO lbl111
                Tr.debug(distSecurityComponentImpl.tc, "bindRegistry looked up local UserRegistry");
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "572", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "createRegistryObjects Failed to find user registry in name space");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.find.registry", new Object[]{e});
                throw e;
            }
        } else {
            try {
                ic = new InitialContext();
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "584", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Failed to get initial Naming Context");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.get.initCtx", new Object[]{e});
                throw e;
            }
            if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Once I have the IntCtx, issue a rebind on it ");
            }
            try {
                if (urc.getSCO().isDomainConfig()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry binding domain registry as UserRegistry");
                    ic.rebind("UserRegistry", (Object)registryImpl);
                } else {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry binding admin registry as AdminUserRegistry");
                    ic.rebind("AdminUserRegistry", (Object)registryImpl);
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry binding admin registry also as UserRegistry");
                    ic.rebind("UserRegistry", (Object)registryImpl);
                }
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry finished binding user registry");
                }
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "605", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Error binding User Registry");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.bind.registry", new Object[]{e});
                throw e;
            }
            try {
                objref = urc.getSCO().isDomainConfig() != false ? ic.lookup("UserRegistry") : ic.lookup("AdminUserRegistry");
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry narrowing UserRegistry object to get stub", objref);
                }
                userReg = (UserRegistry)PortableRemoteObject.narrow((Object)objref, UserRegistry.class);
                urc.setUserRegistryStub(userReg);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.bindRegistries", "624", this);
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "bindRegistry Failed to find user registry in name space");
                }
                Tr.error(distSecurityComponentImpl.tc, "security.secsrv.find.registry", new Object[]{e});
                throw e;
            }
        }
lbl111:
        // 3 sources

        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.exit(distSecurityComponentImpl.tc, "bindRegistry");
        }
    }

    public void startSecurity() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSecurity");
        }
        this.initialize();
        this.fireStartedEvent();
        this.securityServiceStarted = true;
        Tr.info(tc, "securityServiceStarted is true");
        Tr.info(tc, "security.init.svcstartcomplete");
        Tr.info(tc, "security.init.secstatus", new Object[]{new Boolean(this.globalSecurityEnabled)});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startSecurity");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            SecurityContext.setIsServerProcess();
            ConfigRoot cfgRoot = this.repository.getConfigRoot();
            if (this.globalSecurityEnabled) {
                try {
                    block23: {
                        boolean pop;
                        block22: {
                            this.secServer = SecurityServerFactory.create();
                            this.initializeCache();
                            pop = false;
                            pop = SecurityObjectLocator.pushAdminContext();
                            try {
                                try {
                                    SecurityContext.enable(_auditService);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "681", this);
                                    throw e;
                                }
                                Object var5_5 = null;
                                if (!pop) break block22;
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                if (pop) {
                                    SecurityObjectLocator.popContext();
                                }
                                throw throwable;
                            }
                            SecurityObjectLocator.popContext();
                        }
                        if (DomainInfo.isMultiDomainDefined()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "initializing context manager for the domain");
                            }
                            pop = false;
                            pop = SecurityObjectLocator.pushAppContext("");
                            try {
                                try {
                                    SecurityContext.enable(_auditService);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "696", this);
                                    throw e;
                                }
                                Object var7_11 = null;
                                if (!pop) break block23;
                            }
                            catch (Throwable throwable) {
                                Object var7_12 = null;
                                if (pop) {
                                    SecurityObjectLocator.popContext();
                                }
                                throw throwable;
                            }
                            SecurityObjectLocator.popContext();
                        }
                    }
                    ContextManagerFactory.setIsReadyToInitialize(true);
                    this.initializeServerSubject();
                    String unexpandedServerId = SecurityObjectLocator.getAdminData().getString("security.unexpandedServerId");
                    if (unexpandedServerId != null) {
                        this.getCellHostNames();
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "486", this);
                    Tr.error(tc, "security.init.secidautherror", new Object[]{e});
                    throw e;
                }
            }
            if (this.globalSecurityEnabled) {
                this.configureRoleBasedAuthz(cfgRoot, "admin-authz");
                this.configureRoleBasedAuthz(cfgRoot, "naming-authz");
                this.configureRoleBasedAuthz(cfgRoot, "audit-authz");
                SecurityCollaborator.initialize();
            }
            this.initializeSecurityMBeans();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "510", this);
            if (this.globalSecurityEnabled) {
                Tr.error(tc, "security.init.error", new Object[]{e});
                throw e;
            }
            Tr.warning(tc, "security.init.error", new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerWithAdminService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerListenerWithAdminService");
        }
        Admin adminService = null;
        try {
            block10: {
                try {
                    adminService = (Admin)this.Proxy.GetService(Admin.class);
                    if (adminService == null) break block10;
                    adminService.addConfigChangeListener((ConfigChangeListener)this);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", "544", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempt to register ConfigChangeListener failed", e);
                    }
                    Object var4_3 = null;
                    if (adminService != null) {
                        this.Proxy.ReleaseService(adminService);
                    }
                }
            }
            Object var4_2 = null;
            if (adminService != null) {
                this.Proxy.ReleaseService(adminService);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (adminService != null) {
                this.Proxy.ReleaseService(adminService);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, STOP_EVENT);
        }
        if (this.initializeJACCProvider != null) {
            this.initializeJACCProvider.cleanup();
        }
        if (this.auditEnabled) {
            this.stopAudit();
        }
        this.fireStoppedEvent();
        this.securityServiceStarted = false;
        Tr.info(tc, "securityServiceStarted is false");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, STOP_EVENT);
        }
    }

    private void stopAudit() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopAudit");
        }
        _auditService.stopAuditService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopAudit");
        }
    }

    private void initializeAuditWCCMConfig() throws Exception {
        AuditConfig audit;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAuditWCCMConfig");
        }
        if ((audit = SecurityObjectLocator.getAuditConfig()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeAuditWCCMConfig");
            }
            return;
        }
        this.auditEnabled = audit.getBoolean("auditEnabled");
        if (this.auditEnabled) {
            Tr.info(tc, "security.audit.service.enabled.audit");
        } else {
            Tr.info(tc, "security.audit.service.disabled.audit");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAuditWCCMConfig");
        }
    }

    private void initializeWCCMConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeWCCMConfig");
        }
        this._security = SecurityObjectLocator.getSecurityConfig("security");
        this.globalSecurityEnabled = this._security.getBoolean("enabled");
        this.serverSecurityEnabled = this._security.getBoolean("appEnabled");
        try {
            block25: {
                try {
                    String remoteReg;
                    this.Proxy.AddService(SecurityService.class);
                    this.repository = (Repository)this.Proxy.GetService(Repository.class);
                    SecurityDM dm = new SecurityDM();
                    dm.registerWithFFDCService();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isEnabled = " + this.globalSecurityEnabled + "isAppEnabled = " + this.serverSecurityEnabled);
                    }
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    this.processType = adminService.getProcessType();
                    if (this.processType == null || this.processType.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot determine process type");
                        }
                        Tr.error(tc, "security.init.nullprocesstype");
                        throw new SecurityConfigException("Cannot determine the process type.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process type: " + this.processType);
                    }
                    SecurityObjectLocator.getAdminData().setString("com.ibm.ws.security.processType", this.processType);
                    WSAccessManager.adminapps = AppDeploymentUtil.listSystemApps(this.repository);
                    if (this.processType.equals("NodeAgent")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Non-managed process: Start merging the node agent's and cell's configuration");
                        }
                        if (SecurityObjectLocator.getSecurityConfigManager().merge("server", this.processType) == null) {
                            Tr.error(tc, "security.init.nullsecobject");
                            throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Non-managed process: End of merging the node agent's and cell's configuration");
                        }
                        String remoteReg2 = this._security.getProperty("WAS_UseRemoteRegistry");
                        Properties custProps = this._security.getActiveUserRegistry().getProperties();
                        String dataSource = custProps.getProperty("com.ibm.websphere.registry.UseDataSource");
                        if ("cell".equalsIgnoreCase(remoteReg2) || "true".equalsIgnoreCase(dataSource)) {
                            this._security.setString("WAS_UseRemoteRegistry", "cell");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting remote registry to: cell");
                            }
                        }
                        break block25;
                    }
                    if (this.processType.equals("DeploymentManager")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Non-managed process: Start merging the deployment manager's and cell's configuration");
                        }
                        if (SecurityObjectLocator.getSecurityConfigManager().merge("server", this.processType) == null) {
                            Tr.error(tc, "security.init.nullsecobject");
                            throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Non-managed process: End of merging the deployment manager's and cell's configuration");
                        }
                        break block25;
                    }
                    if (!this.processType.equals("ManagedProcess")) break block25;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Managed process: Start merging the server's and cell's configuration");
                    }
                    if (SecurityObjectLocator.getSecurityConfigManager().merge("server", this.processType) == null) {
                        Tr.error(tc, "security.init.nullsecobject");
                        throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Managed process: End of merging the server's and cell's configuration");
                    }
                    if ((remoteReg = this._security.getProperty("WAS_UseRemoteRegistry")) == null || !remoteReg.equalsIgnoreCase("node") && !remoteReg.equalsIgnoreCase("cell")) break block25;
                    this._security.setString("WAS_UseRemoteRegistry", remoteReg);
                    if (!tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "Setting remote registry to: " + remoteReg);
                }
                catch (Exception e) {
                    Tr.error(tc, "security.init.error", new Object[]{e});
                    throw new ConfigurationError("Error merging security config for cell and server", e);
                }
            }
            Object var7_8 = null;
            if (this.repository != null) {
                this.Proxy.ReleaseService(this.repository);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.repository != null) {
                this.Proxy.ReleaseService(this.repository);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeWCCMConfig");
        }
    }

    private void initializeAudit() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAudit");
        }
        if (this.globalSecurityEnabled) {
            try {
                AuditServiceImpl.initAuditService();
                _auditService = AuditServiceImpl.getAuditService();
                if (_auditService == null) {
                    Tr.error(tc, "security.audit.service.init.error");
                    throw new Exception("Auditing is enabled, but the AuditService is not initialized.");
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.init.error", new Object[]{e});
                throw new ConfigurationError("Failed to initialize AuditService", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAudit");
        }
    }

    private void initializeSSOTAI() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSSOTAI");
        }
        if (this.globalSecurityEnabled) {
            boolean enabledPluggableAuthentication;
            boolean ssoEnabled;
            TrustAssociationManager.getInstance();
            AuthMechanismConfig aam = this._security.getActiveAuthMechanism();
            String authMech = aam.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "active authMech.getType=" + authMech);
            }
            if (authMech.equalsIgnoreCase("LTPA") && !(ssoEnabled = aam.getSingleSignon().getBoolean("enabled"))) {
                Tr.warning(tc, "security.init.ltpawithoutsso");
            }
            if (enabledPluggableAuthentication = this._security.getPropertyBool("security.enablePluggableAuthentication")) {
                try {
                    String cbFactory = this._security.getProperty("security.callbackHandlerFactoryClass");
                    Class<?> c = Class.forName(cbFactory);
                    Method m = c.getMethod("getInstance", String.class);
                    WSCallbackHandlerFactory cbkFactory = (WSCallbackHandlerFactory)m.invoke(null, cbFactory);
                }
                catch (Exception e) {
                    Tr.error(tc, "security.init.error", new Object[]{e});
                    throw new ConfigurationError("Failed to initialize WSCallbackHandlerFactory", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSSOTAI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize_CSIv2(EndPointMgr endPointMgr) {
        if (endPointMgr == null) {
            Tr.debug(tc, "distSecurityComponentImpl initialize_CSIvl: endPointMgr is null");
        } else {
            Tr.debug(tc, "distSecurityComponentImpl initialize_CSIv2: endPointMgr is not null");
        }
        CSIv2Config admin_csiv2 = SecurityObjectLocator.getCSIv2Config(endPointMgr);
        if (this._appSecurity == null || this._appSecurity.getCSIv2Config(false) == null) return;
        boolean pushed = SecurityObjectLocator.pushAppContext("");
        try {
            CSIv2Config application_csiv2 = SecurityObjectLocator.getCSIv2Config(endPointMgr);
            Object var6_5 = null;
            if (!pushed) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!pushed) throw throwable;
            SecurityObjectLocator.popContext();
            throw throwable;
        }
        SecurityObjectLocator.popContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeSecurityConfig() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dist initializeSecurityConfig");
        }
        Properties orbProps = new Properties();
        ORB orbSvc = (ORB)this.Proxy.GetService(ORB.class);
        if (orbSvc == null) {
            orbServiceAvailable = false;
        } else {
            try {
                if (orbSvc != null) {
                    orbProps = orbSvc.getOrbProps();
                }
                Object var4_3 = null;
                if (orbSvc != null) {
                    this.Proxy.ReleaseService(orbSvc);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (orbSvc != null) {
                    this.Proxy.ReleaseService(orbSvc);
                }
                throw throwable;
            }
        }
        this.insertVariables(orbProps);
        Server server = (Server)this.Proxy.GetService(Server.class);
        try {
            AdminData adminData = SecurityObjectLocator.getAdminData();
            this.nameOfNode = server.getNodeName();
            String serverName = server.getCellName() + ":" + server.getNodeName() + ":" + server.getName();
            adminData.setString("process.serverName", serverName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set SERVER_NAME to = " + serverName);
            }
            if (!this._security.getActiveUserRegistry().getBoolean("useRegistryServerId")) {
                StringBuffer sName = new StringBuffer("server");
                sName.append(":").append(server.getCellName()).append("_").append(server.getNodeName()).append("_").append(server.getName());
                String internalServerId = sName.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting internalServerID to = " + internalServerId);
                }
                adminData.setString("com.ibm.ws.security.internalServerId", internalServerId);
            }
            adminData.setString("shortservername", server.getName());
            adminData.setString("server.short.name", server.getShortName());
            adminData.setString("nodename", server.getNodeName());
            adminData.setString("node.short.name", server.getShortNodeName());
            adminData.setString("cellname", server.getCellName());
            adminData.setString("cell.short.name", server.getShortCellName());
            Object var9_10 = null;
            if (server != null) {
                this.Proxy.ReleaseService(server);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (server != null) {
                this.Proxy.ReleaseService(server);
            }
            throw throwable;
        }
        if (this.globalSecurityEnabled && orbProps != null) {
            String tokenSlot;
            String csiInServerAlias;
            String csiInClientAlias;
            String csiOutServerAlias;
            String csiOutClientAlias;
            String sasInServerAlias;
            String sasInClientAlias;
            String sasOutServerAlias;
            String sasOutClientAlias;
            String defaultServerAlias;
            String defaultClientAlias;
            String loginKeyFile = this._security.getProperty("com.ibm.CORBA.keyFileName");
            if (loginKeyFile != null) {
                orbProps.put("com.ibm.CORBA.keyFileName", loginKeyFile);
            }
            if ((defaultClientAlias = this._security.getProperty("com.ibm.ssl.keyStoreClientAlias")) != null) {
                orbProps.put("com.ibm.ssl.keyStoreClientAlias", defaultClientAlias);
            }
            if ((defaultServerAlias = this._security.getProperty("com.ibm.ssl.keyStoreServerAlias")) != null) {
                orbProps.put("com.ibm.ssl.keyStoreServerAlias", defaultServerAlias);
            }
            if ((sasOutClientAlias = this._security.getProperty("com.ibm.ssl.sas.outbound.keyStoreClientAlias")) != null) {
                orbProps.put("com.ibm.ssl.sas.outbound.keyStoreClientAlias", sasOutClientAlias);
            }
            if ((sasOutServerAlias = this._security.getProperty("com.ibm.ssl.sas.outbound.keyStoreServerAlias")) != null) {
                orbProps.put("com.ibm.ssl.sas.outbound.keyStoreServerAlias", sasOutServerAlias);
            }
            if ((sasInClientAlias = this._security.getProperty("com.ibm.ssl.sas.inbound.keyStoreClientAlias")) != null) {
                orbProps.put("com.ibm.ssl.sas.inbound.keyStoreClientAlias", sasInClientAlias);
            }
            if ((sasInServerAlias = this._security.getProperty("com.ibm.ssl.sas.inbound.keyStoreServerAlias")) != null) {
                orbProps.put("com.ibm.ssl.sas.inbound.keyStoreServerAlias", sasInServerAlias);
            }
            if ((csiOutClientAlias = this._security.getProperty("com.ibm.ssl.csi.outbound.keyStoreClientAlias")) != null) {
                orbProps.put("com.ibm.ssl.csi.outbound.keyStoreClientAlias", csiOutClientAlias);
            }
            if ((csiOutServerAlias = this._security.getProperty("com.ibm.ssl.csi.outbound.keyStoreServerAlias")) != null) {
                orbProps.put("com.ibm.ssl.csi.outbound.keyStoreServerAlias", csiOutServerAlias);
            }
            if ((csiInClientAlias = this._security.getProperty("com.ibm.ssl.csi.inbound.keyStoreClientAlias")) != null) {
                orbProps.put("com.ibm.ssl.csi.inbound.keyStoreClientAlias", csiInClientAlias);
            }
            if ((csiInServerAlias = this._security.getProperty("com.ibm.ssl.csi.inbound.keyStoreServerAlias")) != null) {
                orbProps.put("com.ibm.ssl.csi.inbound.keyStoreServerAlias", csiInServerAlias);
            }
            if ((tokenSlot = this._security.getProperty("com.ibm.ssl.tokenSlot")) != null) {
                orbProps.put("com.ibm.ssl.tokenSlot", tokenSlot);
            }
            String use_fips_flag = this._security.getProperty("com.ibm.security.useFIPS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "use_fips_flag = " + use_fips_flag);
            }
            if (use_fips_flag != null) {
                orbProps.put("com.ibm.security.useFIPS", use_fips_flag);
            } else {
                orbProps.put("com.ibm.security.useFIPS", "false");
            }
            String enable_pluggable_auth_flag = this._security.getProperty("security.enablePluggableAuthentication");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enable_pluggable_auth_falg = " + enable_pluggable_auth_flag);
            }
            if (enable_pluggable_auth_flag != null) {
                orbProps.put("security.enablePluggableAuthentication", enable_pluggable_auth_flag);
            } else {
                orbProps.put("security.enablePluggableAuthentication", "false");
            }
            String suppress_exception_stack = this._security.getProperty("com.ibm.websphere.security.suppressExceptionStack");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "suppress_exception_stack = " + suppress_exception_stack);
            }
            if (suppress_exception_stack != null) {
                orbProps.put("com.ibm.websphere.security.suppressExceptionStack", suppress_exception_stack);
            } else {
                orbProps.put("com.ibm.websphere.security.suppressExceptionStack", "false");
            }
        }
        this.endPointMgr = (EndPointMgr)this.Proxy.GetService(EndPointMgr.class);
        if (this.endPointMgr == null) {
            Tr.debug(tc, "distSecurityComponentImpl: endPointMgr is null");
        } else {
            Tr.debug(tc, "distSecurityComponentImpl: endPointMgr is not null");
        }
        try {
            com.ibm.websphere.models.config.process.Server serverDoc = null;
            this.initialize_CSIv2(this.endPointMgr);
            SecurityObjectLocator.getAdminData().setBoolean("isServerProcess", Boolean.TRUE);
            ORBUtils.populateORBProperties(this._security, orbProps, this.endPointMgr, serverDoc);
            Object var20_23 = null;
            if (this.endPointMgr != null) {
                this.Proxy.ReleaseService(this.endPointMgr);
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (this.endPointMgr != null) {
                this.Proxy.ReleaseService(this.endPointMgr);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dist initializeSecurityConfig");
        }
    }

    private void initializeJAAS() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeJAAS");
        }
        try {
            Configuration.setConfiguration((Configuration)new com.ibm.ws.security.auth.login.Configuration());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "1044", this);
            Tr.error(tc, "security.init.wccmjaas.setcfgerror", new Object[]{LOGIN_CONFIG_CLASS, e});
            throw new ConfigurationError("Unable to set com.ibm.ws.security.auth.login.Configuration as the JAAS Login Configuration class.", e);
        }
        Configuration jCfg = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String jCfgClassName = jCfg.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Login Configuration class is: " + jCfgClassName);
        }
        if (!(jCfg instanceof com.ibm.ws.security.auth.login.Configuration)) {
            if (this.globalSecurityEnabled) {
                Tr.error(tc, "security.init.wccmjaas.wrongclasserror", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(tc, "security.init.wccmjaas.wrongclasswarning", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeJAAS");
        }
    }

    private void initializeJaccProxy(DynamicPolicy dyPolicy) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeJaccProxy");
        }
        DynamicPolicyFactory.setInstance(dyPolicy);
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        if (!(scm.isMultiDomainDefined() && this.processType.equals("DeploymentManager") && DomainContextHelper.isDmgrAndMultiDomainAndMultiJacc())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JAAC Provider initialization is handling a single configuration.");
            }
            String jaccProviderPolicyClass = System.getProperty("javax.security.jacc.policy.provider");
            boolean isJACCEnabled = false;
            AuthorizationConfig authConfig = null;
            AuthorizationProviderConfig authProvider = null;
            if (this._appSecurity != null) {
                authConfig = this._appSecurity.getAuthorizationConfig();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAAC Provider attribute is based on the application security domain setting");
                }
            } else {
                authConfig = this._security.getAuthorizationConfig();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAAC Provider attribute is based on the global security domain setting");
                }
            }
            if (authConfig != null) {
                isJACCEnabled = authConfig.getBoolean("useJACCProvider");
                authProvider = authConfig.getAuthorizationProvider();
            }
            if (jaccProviderPolicyClass == null && !isJACCEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using default authorization");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeJaccProxy");
                }
                return;
            }
            this.expandVariables();
            if (jaccProviderPolicyClass == null && authProvider != null && (jaccProviderPolicyClass = authProvider.getString("j2eePolicyImplClassName")) != null) {
                System.setProperty("javax.security.jacc.policy.provider", jaccProviderPolicyClass);
            }
            if (jaccProviderPolicyClass == null) {
                throw new ConfigurationError("The JACC provider's policy class name is null");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The JACC provider's policy implementation class name is: " + jaccProviderPolicyClass);
            }
            if (authProvider.getBoolean("supportsDynamicModuleUpdates")) {
                JaccUtil.setAppDynamicUpdates();
            }
            if (jaccProviderPolicyClass.equals("com.ibm.ws.security.policy.JaccPolicyProxy") || jaccProviderPolicyClass.equals("com.sun.ts.tests.jacc.provider.TSPolicy")) {
                this._security.setBoolean("boolDefaultJaccProvider", true);
                if (this._appSecurity != null) {
                    this._appSecurity.setBoolean("boolDefaultJaccProvider", true);
                }
            }
            String jaccInitName = authProvider.getString("initializeJACCProviderClassName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jaccInit Class Name: ", jaccInitName);
            }
            if (jaccInitName != null && jaccInitName.length() != 0) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    this.initializeJACCProvider = (InitializeJACCProvider)Class.forName(jaccInitName, true, cl).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, cnfe});
                    FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1242", this);
                    throw new ConfigurationError(cnfe.getMessage(), cnfe);
                }
                catch (IllegalAccessException iae) {
                    Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, iae});
                    FFDCFilter.processException((Throwable)iae, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1249", this);
                    throw new ConfigurationError(iae.getMessage(), iae);
                }
                catch (InstantiationException ie) {
                    Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, ie});
                    FFDCFilter.processException((Throwable)ie, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1256", this);
                    throw new ConfigurationError(ie.getMessage(), ie);
                }
                int success = -1;
                try {
                    success = this.initializeJACCProvider.initialize(authProvider.getProperties());
                }
                catch (Exception e) {
                    Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, e});
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1269", this);
                    throw new ConfigurationError(e.getMessage(), e);
                }
                if (success != 0) {
                    String defaultMsg = "The initialize method of " + jaccInitName + " did not return success code 0.  The error code returned was: " + success;
                    String msg = Constants.nls.getFormattedMessage("security.jacc.initialize.error", new Object[]{jaccInitName, new Integer(success)}, defaultMsg);
                    throw new ConfigurationError(msg);
                }
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Policy.setPolicy((Policy)Class.forName(jaccProviderPolicyClass, true, cl).newInstance());
                Policy policy = Policy.getPolicy();
                policy.refresh();
            }
            catch (Throwable th) {
                Tr.error(tc, "security.jacc.init.error", new Object[]{jaccProviderPolicyClass, th});
                FFDCFilter.processException(th, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1293", this);
                throw new ConfigurationError(th.getMessage(), th);
            }
            Tr.audit(tc, "security.jacc.initialized", new Object[]{jaccProviderPolicyClass, authProvider.getString("policyConfigurationFactoryImplClassName"), authProvider.getString("roleConfigurationFactoryImplClassName"), jaccInitName});
            this._security.setObject("nullSourceCode", new CodeSource(null, (Certificate[])null));
            this._security.setObject("nullProtectionDomain", new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, null));
            if (this._appSecurity != null) {
                this._appSecurity.setObject("nullSourceCode", new CodeSource(null, (Certificate[])null));
                this._appSecurity.setObject("nullProtectionDomain", new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, null));
            }
        } else if (this.processType.equals("DeploymentManager")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initilizing JACC for the Dmgr process in multi-security domain and in mulit-jacc configuration.");
            }
            this.expandVariables();
            JaccPolicyDomainProxy policyWrapper = new JaccPolicyDomainProxy();
            try {
                policyWrapper.getDomainPolicy();
                Policy.setPolicy(policyWrapper);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initilizing JACC for the Dmgr process in multi-security domain and in mulit-jacc configuration caught exception: " + e.getMessage());
                }
                throw new ConfigurationError(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeJaccProxy");
        }
    }

    private void initializeJava2Sec() throws SecurityConfigException, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeJava2Sec");
        }
        boolean java2SecurityEnabled = false;
        try {
            if (this._appSecurity != null) {
                java2SecurityEnabled = this._appSecurity.getBoolean("enforceJava2Security");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Java2Sec enablement is based on the application security domain setting: " + java2SecurityEnabled);
                }
            } else {
                java2SecurityEnabled = this._security.getBoolean("enforceJava2Security");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Java2Sec enablement is based on the global security domain setting: " + java2SecurityEnabled);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", "1348", this);
            Tr.error(tc, "security.j2sec.init.error", new Object[]{e});
            throw new ConfigurationError("Failed to get EnforceJava2Security.", e);
        }
        try {
            if (!java2SecurityEnabled) {
                NullDynamicPolicy ndPolicy = new NullDynamicPolicy(Policy.getPolicy());
                Policy.setPolicy(ndPolicy);
                this.initializeJaccProxy(ndPolicy);
                String customSM = System.getProperty("java.security.manager");
                if (customSM != null && customSM.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom SecurityManager is loaded :" + customSM);
                    }
                } else {
                    System.setSecurityManager(null);
                }
                Tr.info(tc, "security.manager.disabled");
            } else {
                WSDynamicPolicy policy = new WSDynamicPolicy(Policy.getPolicy(), this.repository);
                Policy.setPolicy(policy);
                this.initializeJaccProxy(policy);
                String propStr = this._security.getProperty("java.security.debug");
                Server server = (Server)this.Proxy.GetService(Server.class);
                ExtClassLoader extCL = (ExtClassLoader)server.getRuntimeClassLoader();
                this.Proxy.ReleaseService(server);
                boolean enableFiltering = this._security.getBoolean("enableJava2SecRuntimeFiltering");
                SecurityManager sm = new SecurityManager(propStr, extCL, policy.getRuntimeFilteredPermission(), enableFiltering);
                System.setSecurityManager(sm);
                Tr.info(tc, "security.jsecman.installed");
                policy.initApplicationTemplate(this._security.getBoolean("issuePermissionsWarning"));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", "1401", this);
            Tr.error(tc, "security.j2sec.init.error", new Object[]{e});
            throw new ConfigurationError("Error during Java 2 Security and Dynamic Policy initialization", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeJava2Sec");
        }
    }

    void configureRoleBasedAuthz(ConfigRoot cfgRoot, String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureRoleBasedAuthz", new Object[]{cfgRoot, appName});
        }
        String resourceName = appName + ".xml";
        RoleBasedConfigurator rbc = this.getConfigurator();
        if (rbc instanceof RoleBasedConfiguratorImpl) {
            ConfigObject atx = null;
            RoleBasedConfiguratorImpl rbci = (RoleBasedConfiguratorImpl)rbc;
            try {
                ConfigService service = WsServiceRegistry.getService(SecurityConfigManager.class, ConfigService.class);
                List list = service.getDocumentObjects(service.getScope(0), resourceName);
                atx = (ConfigObject)list.get(0);
                if (atx == null) {
                    Tr.error(tc, "ssl.init.nullsecobject.CWPKI0009E");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configureRoleBasedAuthz() error getting AuthorizationTableExt object from List");
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configureRoleBasedAuthz() exception", e);
                }
                throw new RoleBasedAppException("configureRoleBasedAuthz() error loading " + appName + ".xml from RCSList");
            }
            if (rbci.areAccessIdsMissing(atx)) {
                try {
                    Resource r = cfgRoot.getResource(0, resourceName);
                    rbc.loadApplication(appName, r);
                }
                catch (Exception e) {
                    Tr.error(tc, "security.loadresource.error", new Object[]{resourceName, e});
                    throw e;
                }
            } else {
                rbci.loadApplication(appName, atx);
            }
        } else {
            try {
                Resource r = cfgRoot.getResource(0, resourceName);
                rbc.loadApplication(appName, r);
            }
            catch (Exception e) {
                Tr.error(tc, "security.loadresource.error", new Object[]{resourceName, e});
                throw e;
            }
        }
        if (appName.equals("admin-authz")) {
            try {
                this.getConfigurator().loadSecurityPolicy(appName, "/com/ibm/ws/security/server/xml/SecurityServer.xml", "domain");
            }
            catch (Exception ex) {
                Tr.error(tc, "security.load.secConfig", new Object[]{ex});
                throw ex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSecurityMBeans");
        }
        try {
            SecurityAdmin securityAdmin = new SecurityAdmin();
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(securityAdmin, "SecurityAdmin");
            mbeanFactory.activateMBean("SecurityAdmin", collab, mbeanFactory.getConfigId("SecurityAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityAdmin.xml");
        }
        catch (Exception e) {
            Tr.error(tc, "security.init.mbeanerror", new Object[]{"SecurityAdmin", e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSecurityMBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SecurityServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", l);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ListIterator lit = this.listeners.listIterator();
            boolean found = false;
            while (lit.hasNext() && !found) {
                if ((SecurityServiceListener)lit.next() != l) continue;
                found = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found matching listener, not adding");
            }
            if (!found) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not find matching listener, adding listener");
                }
                this.listeners.add(l);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LISTENERS AFTER ADD: ");
            Iterator it1 = this.listeners.iterator();
            while (it1.hasNext()) {
                Tr.debug(tc, " add> " + it1.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListener(String profileThis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearListener: " + profileThis);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LISTENERS BEFORE: ");
            Iterator it1 = this.listeners.iterator();
            while (it1.hasNext()) {
                Tr.debug(tc, " rem_b>  " + it1.next());
            }
        }
        ArrayList<SecurityServiceListener> slist = new ArrayList<SecurityServiceListener>(32);
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (SecurityServiceListener lstr : this.listeners) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lstr: " + lstr.toString());
                }
                if (!lstr.toString().contains(profileThis)) continue;
                slist.add(lstr);
            }
        }
        arrayList = this.listeners;
        synchronized (arrayList) {
            for (SecurityServiceListener lstr : slist) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing: " + lstr.toString());
                }
                this.listeners.remove(lstr);
            }
        }
        if (!slist.isEmpty()) {
            slist.clear();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LISTENERS AFTER: ");
            Iterator it2 = this.listeners.iterator();
            while (it2.hasNext()) {
                Tr.debug(tc, " rem_a>  " + it2.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SecurityServiceListener l) {
        Object it1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", l);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LISTENERS BEFORE ");
            it1 = this.listeners.iterator();
            while (it1.hasNext()) {
                Tr.debug(tc, " rem_b>  " + it1.next());
            }
        }
        it1 = this.listeners;
        synchronized (it1) {
            this.listeners.remove(l);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LISTENERS AFTER: ");
            Iterator it2 = this.listeners.iterator();
            while (it2.hasNext()) {
                Tr.debug(tc, " rem_a>  " + it2.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent evt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", evt);
        }
        try {
            try {
                AdminData adminData = SecurityObjectLocator.getAdminData();
                TreeSet multiServerIDList = (TreeSet)adminData.getObject("security.serverNameList");
                String unexpandedServerId = adminData.getString("security.unexpandedServerId");
                String cellSecurityXMLPath = "cells/" + adminData.getString("cellname") + "/security.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security.xml: " + cellSecurityXMLPath);
                }
                ConfigChangeNotifier[] notifiers = evt.getChanges();
                if (multiServerIDList != null && unexpandedServerId != null) {
                    for (int i = 0; i < notifiers.length; ++i) {
                        ConfigService configService;
                        ConfigScope scope;
                        String[] nodes;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Document changed: " + notifiers[i].getUri());
                        }
                        if (notifiers[i].getChangeType() != 0 && notifiers[i].getChangeType() != 1 || !notifiers[i].getUri().endsWith("serverindex.xml")) continue;
                        String uri = notifiers[i].getUri();
                        int lastSlash = uri.lastIndexOf(47);
                        int secondToLastSlash = -1;
                        if (lastSlash > 0) {
                            secondToLastSlash = uri.lastIndexOf(47, lastSlash - 1);
                        }
                        if (lastSlash <= 0 || secondToLastSlash <= 0) continue;
                        String nodeName = uri.substring(secondToLastSlash + 1, lastSlash);
                        if (tc.isDebugEnabled()) {
                            if (notifiers[i].getChangeType() == 0) {
                                Tr.debug(tc, "Node added: " + nodeName);
                            } else {
                                Tr.debug(tc, "Node removed: " + nodeName);
                            }
                        }
                        if (this.repository == null) {
                            this.repository = (Repository)this.Proxy.GetService(Repository.class);
                        }
                        if ((nodes = (scope = (configService = WsServiceRegistry.getService(this, ConfigService.class)).createScope(3)).list("nodes")) == null) continue;
                        for (int j = 0; j < nodes.length; ++j) {
                            if (!nodes[j].equals(nodeName)) continue;
                            scope.set(3, nodes[i]);
                            List resource = configService.getDocumentObjects(scope, "serverindex.xml");
                            ConfigObject doc = (ConfigObject)resource.get(0);
                            String hostName = doc.getString("hostName", null).toLowerCase();
                            String serverID = ConfigUtils.expandHost(unexpandedServerId, hostName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Expanded serverID: " + serverID);
                            }
                            if (serverID == null) continue;
                            if (notifiers[i].getChangeType() == 0) {
                                boolean added = multiServerIDList.add(serverID);
                                if (!tc.isDebugEnabled()) continue;
                                if (added) {
                                    Tr.debug(tc, "Server ID " + serverID + " was added to the multi-serverID list.");
                                    continue;
                                }
                                Tr.debug(tc, "Server ID " + serverID + " was already in the multi-serverID list.");
                                continue;
                            }
                            if (notifiers[i].getChangeType() != 1) continue;
                            boolean removed = multiServerIDList.remove(serverID);
                            if (!tc.isDebugEnabled()) continue;
                            if (removed) {
                                Tr.debug(tc, "Server ID " + serverID + " was removed to the multi-serverID list.");
                                continue;
                            }
                            Tr.debug(tc, "Server ID " + serverID + " was not present in the multi-serverID list.");
                        }
                    }
                }
                SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
                for (int i = 0; i < notifiers.length; ++i) {
                    int domainNameStart;
                    int endOffset;
                    String domainsDir;
                    int offset;
                    String uri;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged Document changed: " + notifiers[i].getUri());
                    }
                    if ((uri = notifiers[i].getUri()).equalsIgnoreCase(cellSecurityXMLPath)) {
                        try {
                            SecurityConfigObject security_sco;
                            this.refreshSpnegoAuthMech(null);
                            String processDomainName = scm.getDomainName();
                            if (processDomainName != null) {
                                this.refreshSpnegoAuthMech(processDomainName);
                            }
                            if (!(security_sco = scm.refreshSSLConfig()).getBoolean("dynamicallyUpdateSSLConfig").booleanValue()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "entering synchronized()");
                            }
                            Object configService = _lockObj;
                            synchronized (configService) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "entered synchronized()");
                                }
                                try {
                                    AdminServiceImpl adminService = (AdminServiceImpl)AdminServiceFactory.getAdminService();
                                    if (adminService != null && ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") && (adminService.isZOSInitComplete() || !PlatformHelperFactory.getPlatformHelper().isZOS())) {
                                        this.temporarilyDisableCertificateAuthenticationAcrossCell(90000L);
                                    }
                                    SSLConfigManager.getInstance().initializeServerSSL(security_sco, true);
                                    KeySetGroupManager.getInstance().initializeKeySetGroups(security_sco, true);
                                    AbstractJSSEProvider.clearSSLContextCache();
                                    LTPAServerObject ltpaServer = LTPAServerObject.getLTPAServer();
                                    ltpaServer.refreshTokenFactories();
                                    AuthCache.getInstance().removeAllEntries();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "exit synchronized()");
                                    }
                                    SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("RSATOKEN").reinitializeRSAProperties();
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.configChanged", "1708", this);
                                    Tr.debug(tc, "Exception re-loading the SSL config.", new Object[]{e.getMessage()});
                                    throw e;
                                }
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.configChanged", "1708", this);
                            Tr.debug(tc, "Exception re-loading the config.", new Object[]{e.getMessage()});
                            throw e;
                        }
                    }
                    if (uri.indexOf("domain-security.xml") == -1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged found domain-security.xml");
                    }
                    if ((offset = uri.indexOf(domainsDir = "waspolicies/default/securitydomains/")) == -1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged found securitydomains dir at offset " + offset);
                    }
                    if ((endOffset = uri.indexOf("/", domainNameStart = offset + domainsDir.length())) == -1) continue;
                    String domainName = uri.substring(domainNameStart, endOffset);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configChanged domainName: " + domainName);
                    }
                    this.refreshSpnegoAuthMech(domainName);
                }
                Object var23_36 = null;
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityComponentImpl.configChanged", "1717", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught: " + e.getMessage());
                }
                Object var23_37 = null;
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
            }
        }
        catch (Throwable throwable) {
            Object var23_38 = null;
            if (this.repository != null) {
                this.Proxy.ReleaseService(this.repository);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSpnegoAuthMech(String domainName) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshSpnegoAuthMech " + domainName);
            }
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            boolean refresh = false;
            String scope = null;
            if (domainName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSpnegoAuthMech refreshing admin scope");
                }
                refresh = true;
                scope = "Security";
            } else {
                String processDomainName = scm.getDomainName();
                if (processDomainName != null && domainName.equals(processDomainName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "refreshSpnegoAuthMech refreshing process domain: " + processDomainName);
                    }
                    refresh = true;
                    scope = "AppSecurity";
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "refreshSpnegoAuthMech supplied domain is not the process domain, not refreshing");
                }
            }
            if (refresh) {
                boolean pushed = false;
                try {
                    if (domainName != null) {
                        pushed = SecurityObjectLocator.getThreadLocal().pushResource(domainName, "domain");
                    }
                    scm.refreshDynamicReload(scope);
                    SecurityConfigObjectList dynamicAuthMechs = scm.getObjectList(scope + "::dynamicReload::authMechanisms");
                    if (dynamicAuthMechs != null) {
                        for (int ix = 0; ix < dynamicAuthMechs.size(); ++ix) {
                            SecurityConfigObject authMech = dynamicAuthMechs.get(ix);
                            if (!authMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO")) continue;
                            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig(scope);
                            security2.refreshSPNEGOAuthMechanism();
                            AuthMechanismConfig spnegoAuth = security2.getAuthMechanism("SPNEGO");
                            if (!spnegoAuth.getBoolean("spengoEnabled")) continue;
                            Properties props = spnegoAuth.getSpnegoFilterProps();
                            TrustAssociationInterceptorImpl spnegoWeb = TrustAssociationInterceptorImpl.getInstance();
                            spnegoWeb.initialize(spnegoAuth.getSpnegoFilterProps());
                        }
                    }
                    Object var14_14 = null;
                    if (!pushed) break block16;
                    SecurityObjectLocator.getThreadLocal().popResource();
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (pushed) {
                        SecurityObjectLocator.getThreadLocal().popResource();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshSpnegoAuthMech");
        }
    }

    public void temporarilyDisableCertificateAuthenticationAcrossCell(long period) throws Exception {
        this.objName = this.getMBean();
        ObjectName on = new ObjectName("WebSphere:type=SSLAdmin,*");
        Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
        while (it.hasNext()) {
            try {
                on = (ObjectName)it.next();
                if (this.objName.equals(on)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SSLAdmin object name = " + on);
                }
                AdminServiceFactory.getAdminService().invoke(on, "temporarilyDisableCertificateAuthentication", new Object[]{new Long(period)}, new String[]{"java.lang.Long"});
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.core.SSLConfigChangeListener.temporaryDisableCertificateAuthentication", "1747", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                }
                throw ex;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " SSLAdmin object name (self) = " + this.objName);
        }
        AdminServiceFactory.getAdminService().invoke(this.objName, "temporarilyDisableCertificateAuthentication", new Object[]{new Long(period)}, new String[]{"java.lang.Long"});
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String processName = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SSLAdmin,process=" + processName + ",*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!it.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SSLAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)it.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SSLAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.core.SSLConfigChangeListener.getMBean", "1780", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{ex});
                }
                throw ex;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }

    private void getCellHostNames() throws Exception {
        AdminData adminData;
        TreeSet<String> multiServerIDList;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCellHostNames");
            }
            multiServerIDList = new TreeSet<String>();
            adminData = SecurityObjectLocator.getAdminData();
            try {
                ConfigService configService;
                ConfigScope scope;
                String[] nodes;
                WSCredential wsCred = ContextManagerFactory.getInstance().getServerCredential();
                if (wsCred != null) {
                    String accessId = wsCred.getAccessId().toLowerCase();
                    String hostname = adminData.getString("process.hostName");
                    if (hostname == null) {
                        hostname = ConfigUtils.getHostName();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server accessID: " + accessId + ", hostname: " + hostname);
                    }
                    if (hostname != null) {
                        int len = hostname.length();
                        int index = accessId.indexOf(hostname);
                        if (index != -1) {
                            StringBuffer accessIdBuffer = new StringBuffer(accessId);
                            accessIdBuffer.replace(index, index + len, "${HOST}");
                            String unexpandedAccessId = accessIdBuffer.toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexpanded accessID is: " + unexpandedAccessId);
                            }
                            adminData.setString("security.unexpandedServerId", unexpandedAccessId);
                        }
                    }
                }
                if ((nodes = (scope = (configService = WsServiceRegistry.getService(this, ConfigService.class)).createScope(3)).list("nodes")) != null) {
                    for (int i = 0; i < nodes.length; ++i) {
                        boolean added;
                        String serverID;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node name: " + nodes[i]);
                        }
                        scope.set(3, nodes[i]);
                        List resource = configService.getDocumentObjects(scope, "serverindex.xml");
                        ConfigObject doc = (ConfigObject)resource.get(0);
                        String hostName = doc.getString("hostName", null).toLowerCase();
                        String unexpandedServerId = adminData.getString("security.unexpandedServerId");
                        if (unexpandedServerId == null || (serverID = ConfigUtils.expandHost(unexpandedServerId, hostName)) == null || !(added = multiServerIDList.add(serverID))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server ID " + serverID + " was added to the multi-serverID list.");
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Server ID " + serverID + " was already in the multi-serverID list.");
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.getCellHostNames", "1865", this);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "Exception occurred getting Cell hostnames.", new Object[]{e});
            }
        }
        adminData.setObject("security.serverNameList", multiServerIDList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellHostNames");
        }
    }

    private void fireStartedEvent() {
        this.fireEvent(START_EVENT);
    }

    private void fireStoppedEvent() {
        this.fireEvent(STOP_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(String event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireEvent,  event is :" + event2);
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            SecurityServiceEvent e = event2.equals(START_EVENT) ? new SecurityServiceEvent(1) : new SecurityServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + SIZE, "event = " + event2);
            }
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    sb.append(list.get(i).hashCode());
                    sb.append("Listener.toString()");
                    sb.append(list.get(i).toString());
                    Tr.debug(tc, sb.toString());
                }
                try {
                    ((SecurityServiceListener)list.get(i)).stateChanged(e);
                    continue;
                }
                catch (Exception ex) {
                    Tr.error(tc, "security.init.error", new Object[]{ex});
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.core.SecurityComponentImpl.fireEvent", "1931", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireEvent, : event is " + event2);
        }
    }

    public RoleBasedConfigurator getConfigurator() throws RoleBasedAppException {
        RoleBasedConfigurator configurator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigurator");
        }
        if ((configurator = RoleBasedConfiguratorFactory.getConfigurator()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RoleBasedConfigurator not initialized");
            }
            throw new RoleBasedAppException("RoleBasedConfigurator not initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigurator");
        }
        return configurator;
    }

    public Properties getSecureSocketLayer(String alias) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecureSocketLayer", alias);
        }
        if (alias == null || alias.equals("")) {
            throw new IllegalArgumentException("Alias is null or empty string.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayer");
        }
        try {
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "inbound");
            return JSSEHelper.getInstance().getProperties(alias, connectionInfo, null);
        }
        catch (SSLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.distSecurityComponentImpl.getSecureSocketLayer", "1972", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSL properties.", new Object[]{e});
            }
            return null;
        }
    }

    public boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        try {
            return this.globalSecurityEnabled;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.core.SecurityComponentImpl.isSecurityEnabled", "1992", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", t);
            }
            return true;
        }
    }

    public boolean isServerSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSecurityEnabled");
        }
        try {
            return this.serverSecurityEnabled;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.core.SecurityComponentImpl.isServerSecurityEnabled", "2012", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", t);
            }
            return true;
        }
    }

    public boolean isSecurityServiceStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityServiceStarted");
        }
        try {
            return this.securityServiceStarted;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.core.SecurityComponentImpl.isSecurityServiceStarted", "2012", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", t);
            }
            return true;
        }
    }

    public String getRealm() {
        return this._security.getActiveUserRegistry().getString("realm");
    }

    public static boolean isOrbServiceAvailable() {
        return orbServiceAvailable;
    }

    public WSSecurityContext getWSSecurityContext() {
        WSSecurityContext wsSecContext;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWSSecurityContext");
            }
            wsSecContext = null;
            if (this.globalSecurityEnabled) {
                try {
                    String OID2 = String.valueOf(this._security.getActiveAuthMechanism().getString("OID"));
                    WSSecurityContextFactory wsFactory = WSSecurityContextFactory.getInstance();
                    wsSecContext = wsFactory.createContext(OID2);
                }
                catch (Exception ex1) {
                    FFDCFilter.processException((Throwable)ex1, "com.ibm.ws.security.core.SecurityComponentImpl.getWSSecurityContext", "2056", this);
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Exception getting WSSecurityContext", ex1);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSecurityContext", wsSecContext);
        }
        return wsSecContext;
    }

    private void expandVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariables");
        }
        VariableMap vMap = (VariableMap)this.Proxy.GetService(VariableMap.class);
        String wasFolder = "";
        String userFolder = "";
        String tmpFolder = "";
        String etcFolder = "";
        String propsFolder = "";
        String installedAppsFolder = "";
        try {
            wasFolder = vMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_INSTALL_ROOT}");
            }
            wasFolder = System.getProperty("was.install.root");
        }
        try {
            userFolder = vMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${USER_INSTALL_ROOT}");
            }
            userFolder = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            tmpFolder = vMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_TEMP_DIR}");
            }
            tmpFolder = wasFolder + File.separator + "tmp";
        }
        try {
            propsFolder = vMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_PROPS_DIR}");
            }
            propsFolder = wasFolder + File.separator + "properties";
        }
        try {
            installedAppsFolder = vMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${APP_INSTALL_ROOT}");
            }
            installedAppsFolder = wasFolder + File.separator + "installedApps";
        }
        try {
            etcFolder = vMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_ETC_DIR}");
            }
            etcFolder = wasFolder + File.separator + "etc";
        }
        AdminData adminData = SecurityObjectLocator.getAdminData();
        adminData.setString("${WAS_INSTALL_ROOT}", wasFolder);
        adminData.setString("${USER_INSTALL_ROOT}", userFolder);
        adminData.setString("${WAS_TEMP_DIR}", tmpFolder);
        adminData.setString("${WAS_PROPS_DIR}", propsFolder);
        adminData.setString("${WAS_ETC_DIR}", etcFolder);
        adminData.setString("${APP_INSTALL_ROOT}", installedAppsFolder);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "${WAS_INSTALL_ROOT}  = " + wasFolder);
            Tr.debug(tc, "${USER_INSTALL_ROOT} = " + userFolder);
            Tr.debug(tc, "${WAS_TEMP_DIR}      = " + tmpFolder);
            Tr.debug(tc, "${WAS_PROPS_DIR}     = " + propsFolder);
            Tr.debug(tc, "${WAS_ETC_DIR}       = " + etcFolder);
            Tr.debug(tc, "${APP_INSTALL_ROOT}  = " + installedAppsFolder);
        }
        this.expandedVariables = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariables");
        }
    }

    private void insertVariables(Properties orbProps) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inserting variables into orbProps");
        }
        if (!this.expandedVariables) {
            this.expandVariables();
        }
        if (orbProps != null) {
            AdminData adminData = SecurityObjectLocator.getAdminData();
            orbProps.put("${WAS_INSTALL_ROOT}", adminData.getString("${WAS_INSTALL_ROOT}"));
            orbProps.put("${USER_INSTALL_ROOT}", adminData.getString("${USER_INSTALL_ROOT}"));
            orbProps.put("${WAS_TEMP_DIR}", adminData.getString("${WAS_TEMP_DIR}"));
            orbProps.put("${WAS_PROPS_DIR}", adminData.getString("${WAS_PROPS_DIR}"));
            orbProps.put("${WAS_ETC_DIR}", adminData.getString("${WAS_ETC_DIR}"));
            orbProps.put("${APP_INSTALL_ROOT}", adminData.getString("${APP_INSTALL_ROOT}"));
            orbProps.put("com.ibm.ws.security.processType", adminData.getString("com.ibm.ws.security.processType"));
        }
    }

    private void initializeCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCache");
        }
        int timeout = this._security.getInteger("cacheTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "security cache timeout", timeout);
        }
        Cache.setDefaultTimeout((long)timeout * 1000L);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCache");
        }
    }

    Subject initializeServerSubject() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerSubject");
        }
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        Subject subject = ((ContextManagerInternals)ctxMgr).getServerSubjectInternal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeServerSubject", subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkProviderList() {
        block21: {
            in = null;
            s = null;
            javaSecurityFile = null;
            fipsFound = false;
            if (distSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.entry(distSecurityComponentImpl.tc, "checkProviderList");
            }
            javaHome = System.getProperty("java.home");
            javaSecurityFile = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
            try {
                in = new BufferedReader(new FileReader(javaSecurityFile));
                while ((s = in.readLine()) != null) {
                    if (s.trim().startsWith("#") || s.trim().length() <= 0 || !s.trim().startsWith("security.provider")) continue;
                    if (s.indexOf("com.ibm.crypto.fips.provider.IBMJCEFIPS") != -1) {
                        fipsFound = true;
                    }
                    if (s.indexOf("com.ibm.crypto.provider.IBMJCE") == -1) continue;
                    if (fipsFound) break;
                    Tr.warning(distSecurityComponentImpl.tc, "security.checkProviderList.warning");
                    if (!distSecurityComponentImpl.tc.isEntryEnabled()) break;
                    Tr.debug(distSecurityComponentImpl.tc, "In FIPS mode, IBMJCEFIPS provider is not found before the IBMJCE provider in the java.security file.");
                    break;
                }
            }
            catch (FileNotFoundException e) {
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "FileNotFoundException caught for " + javaSecurityFile);
                }
                var8_7 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug(distSecurityComponentImpl.tc, "Exception caught: " + e.getMessage());
                    }
                    break block21;
                }
            }
            catch (Exception ex) {
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug(distSecurityComponentImpl.tc, "Exception caught: " + ex.getMessage());
                }
                var8_8 = null;
                try {}
                catch (Exception e) {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug(distSecurityComponentImpl.tc, "Exception caught: " + e.getMessage());
                    }
                    break block21;
                }
                if (in != null) {
                    in.close();
                }
                break block21;
            }
            var8_6 = null;
            {
                catch (Throwable var7_16) {
                    var8_9 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 316->327)] { 
lbl58:
                    // 1 sources

                    if (in == null) throw var7_16;
                    in.close();
                    throw var7_16;
lbl61:
                    // 1 sources

                    catch (Exception e) {
                        if (distSecurityComponentImpl.tc.isDebugEnabled() == false) throw var7_16;
                        Tr.debug(distSecurityComponentImpl.tc, "Exception caught: " + e.getMessage());
                    }
                    throw var7_16;
                }
                ** try [egrp 2[TRYBLOCK] [6 : 316->327)] { 
lbl66:
                // 1 sources

                if (in != null) {
                    in.close();
                }
lbl70:
                // 1 sources

                catch (Exception e) {}
                if (!distSecurityComponentImpl.tc.isDebugEnabled()) break block21;
                Tr.debug(distSecurityComponentImpl.tc, "Exception caught: " + e.getMessage());
            }
        }
        if (distSecurityComponentImpl.tc.isEntryEnabled() == false) return;
        Tr.exit(distSecurityComponentImpl.tc, "checkProviderList");
    }

    private void setAppSecurityInfo() {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setAppSecurity");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "about to load and process the app-security.xml config file");
                }
                this._appSecurity = SecurityObjectLocator.getSecurityConfig("AppSecurity");
                if (this._appSecurity != null) {
                    UserRegistryConfig aur = this._appSecurity.getActiveUserRegistry(false);
                    if (aur != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "a user registry is defined for the applications domain");
                        }
                        DomainInfo.setAppRealm(aur.getString("realm"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "application domain realm is set to: " + aur.getString("realm"));
                        }
                        this._appSecurity.setBoolean("use_single_registry", Boolean.FALSE);
                        this._security.setBoolean("use_single_registry", Boolean.FALSE);
                        this._appSecurity.setString("security.domain.type", "application");
                        this._security.setString("security.domain.type", "administration");
                        DomainInfo.setUseSingleRealm(false);
                        if (aur.getType().equals("LOCALOS")) {
                            DomainInfo.setAppRegType("LOCALOS");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app domain registry type: LOCALOS");
                            }
                        } else if (aur.getType().equals("CUSTOM")) {
                            DomainInfo.setAppRegType("CUSTOM");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app domain registry type: CUSTOM");
                            }
                        } else if (aur.getType().equals("WIMUserRegistry")) {
                            DomainInfo.setAppRegType("WIM");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app domain registry type: WIM");
                            }
                        } else if (aur.getType().equals("LDAP")) {
                            DomainInfo.setAppRegType("LDAP");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app domain registry type: LDAP");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "app domain active user registry type for app domain is unknown");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "no user registry is defined for the applications domain");
                        }
                        this._security.setBoolean("use_single_registry", Boolean.TRUE);
                        DomainInfo.setUseSingleRealm(true);
                    }
                    DomainInfo.setMultiDomainDefined(true);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no application security domain is defined for this server");
                    }
                    this._security.setString("security.domain.type", "admin_and_app");
                    this._security.setBoolean("use_single_registry", Boolean.TRUE);
                    DomainInfo.setUseSingleRealm(true);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block26;
                Tr.debug(tc, "exception attempting to load the app-security.xml config file", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppSecurity");
        }
    }

    public void setAsynchBeansService(AsynchBeansService svc) {
        AsynchBeansServiceCollaborator collaborator = (AsynchBeansServiceCollaborator)svc;
        this.registerWithAsynchBeansService(collaborator);
    }

    private void registerWithAsynchBeansService(AsynchBeansServiceCollaborator collaborator) {
        if (collaborator != null) {
            AppConfigurationEntry[] loginEntry = Configuration.getConfiguration().getAppConfigurationEntry("system.DESERIALIZE_ASYNCH_CONTEXT");
            if (loginEntry != null) {
                ContextManager mgr = ContextManagerFactory.getInstance();
                ServiceWithContext svc = mgr.getServiceWithContext();
                collaborator.register(svc);
                this.releaseService(collaborator);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security component has successfully registered with AsynchBeans");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "system.DESERIALIZE_ASYNCH_CONTEXT login configuration is unavailable, Security component has not registered with AsynchBeans");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AsynchBeansServiceCollaborator is unavailable, registering a listener with AsynchBeans");
        }
    }
}

