/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.security.auth.login.Configuration;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;

public class SecurityDM
extends DiagnosticModule {
    private static final TraceComponent tc = Tr.register(SecurityDM.class, null, "com.ibm.ejs.resources.security");

    public boolean registerWithFFDCService() {
        boolean result = true;
        int registrationOutcome = 0;
        registrationOutcome = FFDC.registerDiagnosticModule(this, "com.ibm.ws.security");
        Tr.info(tc, "security.init.secdm.init", new Object[]{"com.ibm.ws.security.core.SecurityDM", new Boolean(true)});
        switch (registrationOutcome) {
            case 0: {
                Tr.event(tc, "SecurityDM successfully registered for package com.ibm.ws.security");
                break;
            }
            case 1: {
                Tr.event(tc, "Unable to register SecurityDM as another SecurityDM module has already been registered with the package name com.ibm.ws.security.");
                result = false;
                break;
            }
            case 2: {
                Tr.event(tc, "Unable to register SecurityDM as it does not support the minimum module interface.");
                result = false;
                break;
            }
            case 3: {
                Tr.event(tc, "Unable to register SecurityDM due to an unknown failure.");
                result = false;
                break;
            }
            default: {
                Tr.event(tc, "SecurityDM registration resulted in an unexpected return code.");
                result = false;
            }
        }
        return result;
    }

    public void ffdcDumpDefaultSecurityConfig(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        is.writeLine(SecurityObjectLocator.getSecurityConfig().toString(), th);
    }

    public void ffdcDumpDefaultJAASConfig(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        String dump = null;
        dump = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String tmp = null;
                javax.security.auth.login.Configuration jCfg = javax.security.auth.login.Configuration.getConfiguration();
                String jCfgClassName = jCfg.getClass().getName();
                if (jCfg instanceof Configuration) {
                    Configuration wasCfg = (Configuration)jCfg;
                    String theCfg = wasCfg.toString();
                    tmp = "The dynamic JAAS login configuration is:\n" + wasCfg;
                } else {
                    tmp = "The JAAS Login Configuration provider class is not the one provided by WebSphere, thus, there is no dynamic JAAS Login Configuration.";
                }
                return tmp;
            }
        });
        is.writeLine(dump, th);
    }

    public void ffdcDumpACE(Throwable th, IncidentStream is, Object callerThis, Object[] o, String sourceId) {
        is.writeLine("AccessControlException:", th);
        is.introspectAndWriteLine("Access Violation information", o);
    }
}

