/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SSLConfigValidation;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AuthData;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.security.util.DomainContextHelper;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class SecurityAdmin
implements InvocationHandler {
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private static SecurityConfig security = null;
    private static List cachedDefaultCiphers = null;
    private static final WebSphereRuntimePermission GET_SSO_TOKEN_PERM = new WebSphereRuntimePermission("getSingleSignonToken");
    private static final String[] CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] FIPS_CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"};
    byte[] kerberos_policy_bytes = null;
    private static final TraceComponent tc = Tr.register(SecurityAdmin.class, null, "com.ibm.ejs.resources.security");
    private UserRegistry _registry = null;
    private boolean initialized = false;

    public SecurityAdmin() throws Exception {
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void initialize() throws Exception {
        Boolean secEnabled;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize ");
        }
        if ((secEnabled = Boolean.valueOf((security = SecurityObjectLocator.getSecurityConfig()).getBoolean("enabled"))).booleanValue()) {
            ContextManager contextMgr;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is enabled, therefore initializing references to user registry and ltpa server.");
            }
            if ((contextMgr = ContextManagerFactory.getInstance()) == null) {
                Tr.error(tc, "security.sambean.nullsecserver");
                throw new Exception("Unable to get ContextManager");
            }
            try {
                this._registry = contextMgr.getRegistry(DomainInfo.getAppRealm());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.initialize", "221", this);
                Tr.error(tc, "security.sambean.urerr", new Object[]{e});
                throw e;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security is not enabled, therefore not initializing references to user registry and ltpa server.");
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void purgeUserFromAuthCache(String realm, String userid) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "purgeUserFromAuthCache");
            }
            AuthCache cache = AuthCache.getInstance();
            try {
                cache.removeEntry(realm, userid);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", "257", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception purging user" + userid + " from cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purgeUserFromAuthCache");
        }
    }

    public void clearAuthCache() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clearAuthCache");
            }
            AuthCache cache = AuthCache.getInstance();
            try {
                cache.removeAllEntries();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", "279", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception clearing auth cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAuthCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetLdapBindInfo(String userId, String password) {
        block60: {
            block59: {
                block58: {
                    if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
                        if (SecurityAdmin.tc.isDebugEnabled() == false) return;
                        Tr.debug(SecurityAdmin.tc, "Global security is not enabled.");
                        return;
                    }
                    configService = null;
                    try {
                        adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                        configService = new ConfigServiceProxy(adminClient);
                    }
                    catch (Exception ex) {
                        if (!SecurityAdmin.tc.isDebugEnabled()) break block58;
                        Tr.debug(SecurityAdmin.tc, "Unable to get ConfigService from deployment manager");
                    }
                }
                if (configService == null) {
                    configService = ConfigServiceFactory.getConfigService();
                }
                if (configService == null) {
                    try {
                        prop = new Properties();
                        prop.setProperty("location", "local");
                        configService = ConfigServiceFactory.createConfigService(true, prop);
                    }
                    catch (Exception ex) {
                        if (SecurityAdmin.tc.isDebugEnabled() == false) return;
                        Tr.debug(SecurityAdmin.tc, "Unable to create ConfigService. ", ex);
                        return;
                    }
                }
                if (configService == null) {
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug(SecurityAdmin.tc, "There is no configservice available.");
                    }
                    Tr.audit(SecurityAdmin.tc, "security.registry.ldap.update.audit");
                    return;
                }
                session = null;
                try {
                    try {
                        session = new Session();
                        pattern = ConfigServiceHelper.createObjectName(null, "Security");
                        security = null;
                        cell = configService.resolve(session, "Cell=")[0];
                        if (cell != null) {
                            security = configService.queryConfigObjects(session, cell, pattern, null)[0];
                        }
                        if (security == null) {
                            security = configService.queryConfigObjects(session, null, pattern, null)[0];
                        }
                        activeUserRegistry = (ObjectName)configService.getAttribute(session, security, "activeUserRegistry");
                        isLdap = false;
                        try {
                            tp = ConfigServiceHelper.getConfigDataType(activeUserRegistry);
                            if (tp != null && tp.equalsIgnoreCase("LDAPUserRegistry")) {
                                isLdap = true;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        serverid = null;
                        try {
                            serverid = (String)configService.getAttribute(session, activeUserRegistry, "serverId");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!isLdap) {
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "The active registry is not LDAP, no update is performed.");
                            }
                            var24_17 = null;
                            break block59;
                        }
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug(SecurityAdmin.tc, "This is LDAP user registry.");
                        }
                        ldaps = (ArrayList)configService.getAttribute(session, activeUserRegistry, "hosts");
                        ldapHost = "";
                        ldapProtocol = "ldap://";
                        if (ldaps != null) {
                            for (i = 0; i < ldaps.size(); ++i) {
                                host = (AttributeList)ldaps.get(i);
                                hostName = (String)ConfigServiceHelper.getAttributeValue(host, "host");
                                portnumber = (Integer)ConfigServiceHelper.getAttributeValue(host, "port");
                                ldapurl = new StringBuffer();
                                if (hostName.startsWith(ldapProtocol)) {
                                    hostName = hostName.substring(ldapProtocol.length());
                                }
                                if (ConfigUtils.isIPv6Addr(hostName)) {
                                    hostName = ConfigUtils.formatIPv6Addr(hostName);
                                }
                                ldapurl.append(ldapProtocol).append(hostName);
                                if (portnumber != null && portnumber > 0) {
                                    ldapurl.append(":" + portnumber);
                                }
                                if (ldapurl == null || ldapurl.length() <= 0) continue;
                                if (ldapHost == "") {
                                    ldapHost = ldapurl.toString();
                                    continue;
                                }
                                if (ldapHost.indexOf(ldapurl.toString()) != -1) continue;
                                ldapHost = ldapHost + " " + ldapurl.toString();
                            }
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "LDAP hosts are " + ldapHost);
                            }
                        }
                        bindpassword = (String)configService.getAttribute(session, activeUserRegistry, "bindPassword");
                        bindDN = (String)configService.getAttribute(session, activeUserRegistry, "bindDN");
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug(SecurityAdmin.tc, "New bind DN is " + bindDN);
                        }
                        updateCfg = true;
                        if (password == null || userId == null || password.length() == 0 || userId.length() == 0) {
                            userId = bindDN;
                            password = bindpassword;
                            updateCfg = false;
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "Bind info input  is incompleted, use bind info from security.xml.");
                            }
                        }
                        reg = SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
                        if (password != null && userId != null && password.length() != 0 && userId.length() != 0) {
                            try {
                                userId = dn = reg.checkPassword(userId, password);
                            }
                            catch (Exception ec) {
                                if (SecurityAdmin.tc.isDebugEnabled()) {
                                    Tr.debug(SecurityAdmin.tc, "Bind info is incorrect with Bind DN of " + userId);
                                }
                                Tr.audit(SecurityAdmin.tc, "security.registry.ldap.update.audit");
                                var24_18 = null;
                                try {
                                    configService.discard(session);
                                    return;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                return;
                            }
                        } else {
                            userId = null;
                            password = null;
                        }
                        ((LdapRegistryImpl)reg).refreshRegistry(userId, password, ldapHost);
                        try {
                            if (serverid == null || serverid == "") {
                                serverid = "123";
                            }
                            reg.getUsers(serverid, 1);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if ((bindpassword == null && password == null || bindpassword.equals(password)) && (bindDN == null && userId == null || bindDN.equals(userId))) {
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "Bind info is not changed in security.xml since last update.");
                            }
                            updateCfg = false;
                        }
                        if (updateCfg) {
                            attrList = new AttributeList();
                            attrList.add(new Attribute("bindDN", userId));
                            attrList.add(new Attribute("bindPassword", password));
                            configService.setAttributes(session, activeUserRegistry, attrList);
                            configService.save(session, false);
                            try {
                                configService.discard(session);
                            }
                            catch (Exception de) {
                                // empty catch block
                            }
                            processType = AdminServiceFactory.getAdminService().getProcessType();
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "Process Type is " + processType);
                            }
                            if (processType.equals("DeploymentManager")) {
                                // empty if block
                            }
                            objName = new ObjectName("WebSphere:type=NodeSync,*");
                            for (ObjectName obj : AdminServiceFactory.getAdminService().queryNames(objName, null)) {
                                AdminServiceFactory.getAdminService().invoke(obj, "sync", new Object[0], new String[0]);
                            }
                            if (SecurityAdmin.tc.isDebugEnabled()) {
                                Tr.debug(SecurityAdmin.tc, "security.xml Sync completed.");
                            }
                            break block60;
                        }
                        try {
                            configService.discard(session);
                        }
                        catch (Exception de) {
                        }
                        break block60;
                    }
                    catch (Exception e) {
                        var24_20 = null;
                        try {}
                        catch (Exception e) {
                            return;
                        }
                        configService.discard(session);
                        return;
                    }
                }
                catch (Throwable var23_44) {
                    var24_21 = null;
                    ** try [egrp 10[TRYBLOCK] [16 : 1241->1252)] { 
lbl178:
                    // 1 sources

                    configService.discard(session);
                    throw var23_44;
lbl180:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var23_44;
                }
            }
            ** try [egrp 10[TRYBLOCK] [16 : 1241->1252)] { 
lbl185:
            // 1 sources

            configService.discard(session);
            return;
lbl187:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var24_19 = null;
        ** try [egrp 10[TRYBLOCK] [16 : 1241->1252)] { 
lbl193:
        // 1 sources

        configService.discard(session);
        return;
lbl195:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateAuthDataCfg(HashMap newCfg) {
        block21: {
            if (SecurityAdmin.tc.isEntryEnabled()) {
                Tr.entry(SecurityAdmin.tc, "updateAuthDataCfg ", new Object[]{newCfg});
            }
            if (newCfg != null) {
                WSDefaultPrincipalMapping.refreshAuthData(newCfg);
            } else {
                ws = null;
                try {
                    block20: {
                        id = "" + System.currentTimeMillis();
                        ws = WorkSpaceManagerFactory.getManager().getWorkSpace(id);
                        type = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
                        uri = URI.createURI("security.xml");
                        c = ws.findContext(type);
                        security = null;
                        itr = c.iterator();
                        if (itr.hasNext()) {
                            rc = (RepositoryContext)itr.next();
                            res = rc.getResourceSet().createResource(uri);
                            options = new HashMap<K, V>();
                            res.load(options);
                            security = (Security)res.getContents().get(0);
                        }
                        if (security == null) break block20;
                        authDataMap = new HashMap<String, AuthData>();
                        for (JAASAuthData jad : security.getAuthDataEntries()) {
                            if (jad == null) continue;
                            authDataMap.put(jad.getAlias(), new AuthData(jad.getUserId(), jad.getPassword()));
                            if (!SecurityAdmin.tc.isDebugEnabled()) continue;
                            Tr.debug(SecurityAdmin.tc, "AuthData - add " + jad.getAlias());
                        }
                        WSDefaultPrincipalMapping.refreshAuthData(authDataMap);
                    }
                    var13_13 = null;
                    ** if (ws == null) goto lbl-1000
                }
                catch (Throwable var12_22) {
                    block22: {
                        var13_15 = null;
                        if (ws != null) {
                            try {
                                user = ws.getUserName();
                                WorkSpaceManagerFactory.getManager().removeWorkSpace(user);
                            }
                            catch (WorkSpaceException wse) {
                                if (!SecurityAdmin.tc.isDebugEnabled()) break block22;
                                Tr.debug(SecurityAdmin.tc, "Exception removing WorkSpace.");
                            }
                        }
                    }
                    throw var12_22;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        user = ws.getUserName();
                        WorkSpaceManagerFactory.getManager().removeWorkSpace(user);
                    }
                    catch (WorkSpaceException wse) {
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug(SecurityAdmin.tc, "Exception removing WorkSpace.");
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                    break block21;
                    catch (Exception e) {
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug(SecurityAdmin.tc, "Exception refreshing J2C AuthData.");
                        }
                        var13_14 = null;
                        if (ws != null) {
                            try {
                                user = ws.getUserName();
                                WorkSpaceManagerFactory.getManager().removeWorkSpace(user);
                            }
                            catch (WorkSpaceException wse) {
                                if (SecurityAdmin.tc.isDebugEnabled()) {
                                    Tr.debug(SecurityAdmin.tc, "Exception removing WorkSpace.");
                                }
                            }
                        }
                    }
                }
            }
        }
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit(SecurityAdmin.tc, "updateAuthDataCfg ");
        }
    }

    public void updateJAASCfg(String newCfg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateJAASCfg ");
        }
        Configuration jCfg = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String jCfgClassName = jCfg.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Login Configuration class is: " + jCfgClassName);
        }
        if (jCfg instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration wasCfg = (com.ibm.ws.security.auth.login.Configuration)jCfg;
                wasCfg.updateWCCMAppConfig(newCfg);
                wasCfg.refresh();
                if (tc.isDebugEnabled()) {
                    String theCfg = wasCfg.toString();
                    Tr.debug(tc, "The dynamic JAAS login configuration is:\n" + theCfg);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.updateJAASCfg", "638", this);
                Tr.error(tc, "security.init.wccmjaas.error", new Object[]{e});
            }
        } else {
            Boolean secEnabled = security.getBoolean("enabled");
            if (secEnabled != null && secEnabled.booleanValue()) {
                Tr.error(tc, "security.init.wccmjaas.wrongclasserror", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(tc, "security.init.wccmjaas.wrongclasswarning", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateJAASCfg ");
        }
    }

    public String getJAASCfg() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJAASCfg ");
        }
        String theCfg = null;
        Configuration jCfg = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String jCfgClassName = jCfg.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Login Configuration class is: " + jCfgClassName);
        }
        if (jCfg instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration wasCfg = (com.ibm.ws.security.auth.login.Configuration)jCfg;
                theCfg = wasCfg.toString();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getJAASCfg", "690", this);
                Tr.error(tc, "security.init.wccmjaas.error", new Object[]{e});
            }
        } else {
            Boolean secEnabled = security.getBoolean("enabled");
            if (secEnabled != null && secEnabled.booleanValue()) {
                Tr.error(tc, "security.init.wccmjaas.wrongclasserror", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(tc, "security.init.wccmjaas.wrongclasswarning", new Object[]{jCfgClassName, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJAASCfg ");
        }
        return theCfg;
    }

    public Result getUsers(String pattern, Integer lim, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers ", pattern + " " + lim);
        }
        int limit = lim;
        Result result = null;
        UserRegistry reg = this.getRegistry(props);
        if (reg != null) {
            try {
                result = reg.getUsers(ConfigUtils.variableMapExpand(pattern), limit);
            }
            catch (CustomRegistryException cre) {
                FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.getUsers", "740", this);
                Tr.error(tc, "security.sambean.getusrerr", new Object[]{pattern, new Integer(limit), cre});
                throw cre;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getUsers", "746", this);
                Tr.error(tc, "security.sambean.getusrerr", new Object[]{pattern, new Integer(limit), e});
                throw e;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers ");
        }
        return result;
    }

    public Result getGroups(String pattern, Integer lim, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups ", pattern + " " + lim);
        }
        int limit = lim;
        Result result = null;
        UserRegistry reg = this.getRegistry(props);
        if (reg != null) {
            try {
                result = reg.getGroups(pattern, limit);
            }
            catch (CustomRegistryException cre) {
                FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.getGroups", "778", this);
                Tr.error(tc, "security.sambean.getgrperr", new Object[]{pattern, new Integer(limit), cre});
                throw cre;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getGroups", "784", this);
                Tr.error(tc, "security.sambean.getgrperr", new Object[]{pattern, new Integer(limit), e});
                throw e;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups ");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean checkRunAsUser(List usrList, List grpList, String userName, Properties props) throws Exception {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRunAsUser", userName);
        }
        if (security.getAuthorizationConfig().getBoolean("useJACCProvider")) {
            if (!tc.isDebugEnabled()) return Boolean.TRUE;
            Tr.debug(tc, "No runAsRole to role checking when JACC is enabled");
            return Boolean.TRUE;
        }
        boolean check = false;
        UserRegistry reg = null;
        if (userName == null || userName.trim().length() <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RunAs username is null");
            }
            check = true;
        } else if (usrList != null && usrList.contains(userName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user " + userName + " is in the user list");
            }
            check = true;
        } else {
            reg = this.getRegistry(props);
            Result result = null;
            String uName = null;
            if (reg != null) {
                result = reg.getUsers(userName, 1);
                if (result != null) {
                    uName = (String)result.getList().get(0);
                }
                if (usrList != null && uName != null && uName.length() > 0 && usrList.contains(uName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "user " + userName + " is in the list");
                    }
                    check = true;
                }
            } else {
                Tr.error(tc, "security.sa.no.registry");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cannot determine if user " + userName + " is in the list since registry is null. Returing false");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkRunAsUser");
                }
            }
        }
        if (!check && reg != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user " + userName + " is not in the user list. Checking in the group list");
            }
            boolean ignoreCase = false;
            Boolean isIgnoreCase = security.getActiveUserRegistry().getBoolean("ignoreCase");
            if (isIgnoreCase != null && isIgnoreCase.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
            List groupList = reg.getGroupsForUser(userName);
            if (grpList != null && groupList != null) {
                block0: for (int i = 0; i < grpList.size() && !check; ++i) {
                    if (ignoreCase) {
                    } else {
                        if (!groupList.contains(grpList.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "user " + userName + " is in the group list");
                        }
                        check = true;
                        continue;
                    }
                    for (int j = 0; j < groupList.size(); ++j) {
                        String grpString;
                        String groupStr = (String)groupList.get(j);
                        if (!groupStr.equalsIgnoreCase(grpString = (String)grpList.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "user " + userName + " is in the group list");
                        }
                        check = true;
                        continue block0;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRunAsUser", check ? Boolean.TRUE : Boolean.FALSE);
        }
        if (check) {
            bl = Boolean.TRUE;
            return bl;
        }
        bl = Boolean.FALSE;
        return bl;
    }

    public String getAccessIds(boolean isUser, String name, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessIds", name);
        }
        String accessId = null;
        UserRegistry reg = this.getRegistry(props);
        if (reg != null) {
            accessId = isUser ? reg.getUniqueUserId(name) : reg.getUniqueGroupId(name);
        } else {
            Tr.error(tc, "security.sa.no.registry");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "registry is null. Returing null accessId");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessIds");
        }
        return accessId;
    }

    public String getRealm(Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm ");
        }
        UserRegistry reg = this.getRegistry(props);
        String realm = null;
        if (reg != null) {
            try {
                realm = reg.getRealm();
            }
            catch (CustomRegistryException cre) {
                FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.getRealm", "943", this);
                Tr.error(tc, "security.sa.get.realm", new Object[]{cre});
                throw cre;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getRealm", "949", this);
                Tr.error(tc, "security.sa.get.realm", new Object[]{e});
                throw e;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm ", realm);
        }
        return realm;
    }

    public void generateKeys(String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeys");
        }
        this.generateKeysForKeySetGroup(null, Boolean.TRUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKeys");
        }
    }

    public void updateRuntimeKeys(Map keys) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRuntimeKeys ");
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            ltpaServer.updateLTPAKeysFromMap(keys);
            ContextManager contextMgr = ContextManagerFactory.getInstance();
            contextMgr.refreshServerSubject(true);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateRuntimeKeys ");
            }
            return;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.updateRuntimeKeys", "998", this);
            Tr.error(tc, "security.ErrorCreatingLTPAKeys", new Object[]{e});
            throw e;
        }
    }

    public Map generateKeysForKeySetGroup(Session session, Boolean updateRuntime) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeysForKeySetGroup");
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            Map newKeys = ltpaServer.generateKeysForKeySetGroup(session, updateRuntime);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateKeysForKeySetGroup");
            }
            return newKeys;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.generateKeysForKeySetGroup", "1020", this);
            Tr.error(tc, "security.ErrorCreatingLTPAKeys", new Object[]{e});
            throw e;
        }
    }

    public Properties genKeys(String password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genKeys ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genKeys ");
        }
        Map map = this.generateKeysForKeySetGroup(null, Boolean.FALSE);
        return null;
    }

    public void exportKeys(String fileName, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportKeys filename:" + fileName);
        }
        LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
        String password = props.getProperty("ltpa_password");
        Properties ssoProps = null;
        try {
            if (ltpaServer != null) {
                ssoProps = ltpaServer.exportSSOProperties(password.getBytes("UTF8"));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.exportKeys", "1054", this);
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{e});
            throw e;
        }
        try {
            this.setProps(ssoProps, fileName);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.exportKeys", "1066", this);
            Tr.error(tc, "security.sa.set.props", new Object[]{fileName, e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportKeys ");
        }
    }

    public void importKeys(String fileName, byte[] passwd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKeys " + fileName);
        }
        Properties ssoProps = new Properties();
        try {
            ssoProps = this.getProps(fileName);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.importKeys", "1087", this);
            Tr.error(tc, "security.sa.set.props", new Object[]{fileName, e});
            throw e;
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            ltpaServer.importSSOProperties(ssoProps, passwd);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.importKeys", "1100", this);
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{ssoProps, e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importKeys ");
        }
    }

    public void getApplicationRoles(String appName) {
    }

    public void getEjbModuleRoles(String appName, String module) {
    }

    public void getWebModuleRoles(String appName, String module) {
    }

    public Map importSSOPropertiesToKeySetGroup(Properties ssoProps, byte[] password, Session session, Boolean updateRuntime) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importSSOPropertiesToKeySetGroup");
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            if (null != ltpaServer) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importSSOPropertiesToKeySetGroup");
                }
                return ltpaServer.importSSOPropertiesToKeySetGroup(ssoProps, password, session, updateRuntime);
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{ssoProps, e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", "1148", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importSSOPropertiesToKeySetGroup", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importSSOPropertiesToKeySetGroup (null)");
        }
        return null;
    }

    public void importLTPAKeys(Properties ssoProps, byte[] password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importLTPAKeys");
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            if (null != ltpaServer) {
                ltpaServer.importSSOProperties(ssoProps, password);
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{ssoProps, e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", "1172", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importLTPAKeys", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importLTPAKeys");
        }
    }

    public void checkImportLTPAKeys(Properties ssoProps, byte[] password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkImportLTPAKeys");
        }
        try {
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            if (null != ltpaServer) {
                ltpaServer.checkImportSSOProperties(ssoProps, password);
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{ssoProps, e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.checkImportLTPAKeys", "1193", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkImportLTPAKeys", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkImportLTPAKeys");
        }
    }

    public Properties exportLTPAKeys(byte[] password) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportLTPAKeys (with pw)");
        }
        try {
            Properties props = null;
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            if (ltpaServer != null) {
                props = ltpaServer.exportSSOProperties(password);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys: " + (props != null ? props.toString() : "null props"));
            }
            return props;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", "1222", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys", e);
            }
            throw e;
        }
    }

    public Properties exportLTPAKeys() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportLTPAKeys");
        }
        try {
            Properties props = null;
            LTPAServerObject ltpaServer = LTPAServerObject.getInstance();
            if (ltpaServer != null) {
                props = ltpaServer.exportSSOProperties(ManagementScopeManager.getInstance().getCellName().getBytes("UTF8"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys: " + (props != null ? props.toString() : "null props"));
            }
            return props;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", "1251", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys", e);
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Boolean checkPassword(String userId, String password, Properties props) throws Exception {
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.entry(SecurityAdmin.tc, "checkPassword");
        }
        checkPass = false;
        if (props != null) {
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug(SecurityAdmin.tc, "props=" + props.toString());
            }
            isSSLEnabled = (Boolean)props.get("sslEnabled");
            sslConfig = (Hashtable)props.get("sslConfig");
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug(SecurityAdmin.tc, "sslEnabled=" + isSSLEnabled);
            }
            if (isSSLEnabled != null && isSSLEnabled.toString().equals("true")) {
                props.put("sslEnabled", Boolean.TRUE);
                if (sslConfig != null) {
                    props.put("LDAP.validation", "true");
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug(SecurityAdmin.tc, "LDAP validation property is set to true");
                    }
                }
            }
        }
        reg = this.getRegistry(props);
        userId = ConfigUtils.variableMapExpand(userId);
        password = ConfigUtils.variableMapExpand(password);
        try {
            password = PasswordUtil.decode(password);
        }
        catch (InvalidPasswordDecodingException e) {
            // empty catch block
        }
        if (reg != null) {
            try {
                activeOID = SecurityAdmin.security.getActiveAuthMechanism().getString("OID");
                ctxMgr = ContextManagerFactory.getInstance();
                if (ctxMgr.isCellSecurityEnabled() && activeOID != null && "oid:1.2.840.113554.1.2.2".endsWith(activeOID)) {
                    kerberos_realm = SecurityAdmin.security.getActiveAuthMechanism().getString("krb5Realm");
                    if (kerberos_realm != null && !kerberos_realm.equals("") && userId.indexOf(64) == -1) {
                        userId = userId + "@" + kerberos_realm;
                    }
                    if ((subject = ctxMgr.login(ctxMgr.getDefaultRealm(), userId, password)) == null) ** GOTO lbl58
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug(SecurityAdmin.tc, "password is ok");
                    }
                    checkPass = true;
                }
                name = reg.checkPassword(userId, password);
                checkPass = true;
            }
            catch (PasswordCheckFailedException pfe) {
                FFDCFilter.processException((Throwable)pfe, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1334", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password", new Object[]{userId, pfe});
                throw pfe;
            }
            catch (CustomRegistryException cre) {
                FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1340", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password.custom", new Object[]{userId, cre});
                throw cre;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1346", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password.custom", new Object[]{userId, e});
                throw e;
            }
        } else {
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug(SecurityAdmin.tc, "registry is null: checkPassword failed");
            }
            Tr.error(SecurityAdmin.tc, "security.sa.no.registry");
        }
lbl58:
        // 4 sources

        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit(SecurityAdmin.tc, "checkPassword", checkPass != false ? Boolean.TRUE : Boolean.FALSE);
        }
        return checkPass != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Integer checkTokenLibFile(String tokenType, String tokenLib, String tokenSlot, String tokenPasswordEncoded, String serverAlias, String clientAlias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTokenLibFile");
        }
        int status = SSLConfigValidation.checkTokenLibFile(tokenType, tokenLib, tokenSlot, tokenPasswordEncoded, serverAlias, clientAlias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTokenLibFile", "status=" + status);
        }
        return new Integer(status);
    }

    public Integer checkKeyFile(String fileType, String fileName, String filePasswordEncoded, String serverAlias, String clientAlias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyFile");
        }
        int status = SSLConfigValidation.checkKeyFile(fileType, fileName, filePasswordEncoded, serverAlias, clientAlias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile", "status=" + status);
        }
        return new Integer(status);
    }

    public Integer checkTrustFile(String fileType, String fileName, String filePasswordEncoded) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTrustFile");
        }
        int status = SSLConfigValidation.checkTrustFile(fileType, fileName, filePasswordEncoded);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTrustFile", "status=" + status);
        }
        return new Integer(status);
    }

    public TokenHolder getOpaqueToken(ByteArray ssoToken) {
        TokenHolder th;
        byte[] opaqueToken;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueToken");
            }
            opaqueToken = null;
            th = null;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                block14: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Extract stoken of input ssoToken's originating servant.");
                    }
                    Token ltpa_token_object = null;
                    try {
                        ltpa_token_object = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(ssoToken.getArray());
                        String[] servantID = ltpa_token_object.getAttributes("com.ibm.websphere.zOS.ServantIdentifier");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "retrieved servantID" + servantID[0]);
                        }
                        th = SecurityAdminHelper.getOpaqueToken(ssoToken, servantID[0]);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getOpaqueToken returns token." + th);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1474", this);
                        if (!tc.isEntryEnabled()) break block14;
                        Tr.exit(tc, "Exception occurred extracting stoken of input ssoToken's originating servant.", new Object[]{e});
                    }
                }
                return th;
            }
            try {
                DistributedMap dm = DistributedMapFactory.getMap("WSSecureMap");
                if (dm != null) {
                    opaqueToken = (byte[])dm.get((Object)ssoToken);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1490", this);
                if (!tc.isEntryEnabled()) break block15;
                Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{e});
            }
        }
        if (opaqueToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns opaque token.");
            }
            th = new TokenHolder(opaqueToken, "WS_OPAQUE", 1);
        }
        return th;
    }

    public TokenHolder getInitialContextToken(ByteArray ssoToken, String targetServer) {
        TokenHolder th;
        byte[] initialContextToken;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInitialContextToken, targetServer: " + targetServer);
            }
            initialContextToken = null;
            th = null;
            if (targetServer != null && targetServer.length() > 0) {
                GSSCredential gssCred = null;
                GSSContext clientContext = null;
                GSSManager _manager = GSSManager.getInstance();
                try {
                    DistributedMap dm = DistributedMapFactory.getMap("WSSecureMapNotShared");
                    if (dm != null) {
                        KRBAuthnToken krbAuthnToken = (KRBAuthnToken)dm.get((Object)ssoToken);
                        if (krbAuthnToken != null) {
                            gssCred = krbAuthnToken.getGSSCredential();
                        }
                    } else {
                        Tr.error(tc, "dm is null");
                    }
                    if (gssCred != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "gssCred is not null. good ");
                        }
                        String targetSPN = null;
                        if (targetServer != null && targetServer.indexOf("/") == -1) {
                            String spnName = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Spn");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "spnName:  " + spnName);
                            }
                            if (spnName != null && spnName.length() > 0) {
                                String krbServiceName = null;
                                if (spnName.indexOf("/") != -1) {
                                    krbServiceName = spnName.substring(0, spnName.indexOf("/"));
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Kerberos service name: " + krbServiceName);
                                    }
                                }
                                targetSPN = krbServiceName + "/" + targetServer;
                            }
                        } else {
                            targetSPN = targetServer;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Target Kerberos service principal name (service/host@REALM): " + targetSPN);
                        }
                        Oid _krb5Mech = Krb5Utils.getKrb5MechOid();
                        GSSName serverName = null;
                        try {
                            serverName = _manager.createName(targetSPN, GSSName.NT_USER_NAME, _krb5Mech);
                        }
                        catch (GSSException exc) {
                            Object[] parms = new Object[]{_manager, "createName()", exc};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception calling createName: " + exc.getMessage());
                            }
                            throw exc;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ServerName: " + serverName);
                        }
                        try {
                            clientContext = _manager.createContext(serverName, _krb5Mech, gssCred, Integer.MAX_VALUE);
                        }
                        catch (GSSException exc) {
                            Object[] parms = new Object[]{_manager, "createContext()", exc};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception calling createContext: " + exc.getMessage());
                            }
                            throw exc;
                        }
                        try {
                            clientContext.requestCredDeleg(true);
                        }
                        catch (GSSException exc) {
                            Object[] parms = new Object[]{clientContext, "requestCredDeleg(true)", exc};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception calling requestCredDeleg: " + exc.getMessage());
                            }
                            throw exc;
                        }
                        byte[] inToken = null;
                        int len = 0;
                        try {
                            initialContextToken = clientContext.initSecContext(inToken, 0, len);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Token = " + initialContextToken.length + initialContextToken);
                            }
                        }
                        catch (GSSException exc) {
                            Object[] parms = new Object[]{clientContext, "initSecContext()", exc};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception calling initSecContext: " + exc.getMessage());
                            }
                            throw exc;
                        }
                        if (clientContext.isEstablished()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "initSecContext: clientContext established successfully.");
                            }
                        } else {
                            Object[] parms = new Object[]{clientContext, targetSPN};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "initSecContext: clientContext not established.");
                            }
                        }
                        break block39;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initSecContext: gssCred was null");
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1652", this);
                    if (!tc.isEntryEnabled()) break block39;
                    Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{e});
                }
            }
        }
        if (initialContextToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns opaque token.");
            }
            th = new TokenHolder(initialContextToken, "INIT_CONTEXT_TOKEN", 1);
        }
        return th;
    }

    public TokenHolder[] getSingleSignonTokens() {
        TokenHolder defaultToken;
        SingleSignonToken[] tokens;
        block13: {
            SecurityManager sm;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSingleSignonTokens");
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting: " + GET_SSO_TOKEN_PERM);
                }
                sm.checkPermission(GET_SSO_TOKEN_PERM);
            }
            tokens = null;
            defaultToken = null;
            try {
                final Subject subject = ContextManagerFactory.getInstance().getCallerSubject();
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
                if (subject != null && cred != null && !cred.isUnauthenticated() && !cred.isBasicAuth()) {
                    tokens = (SingleSignonToken[])com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            HashSet<SingleSignonToken> creds = new HashSet<SingleSignonToken>();
                            Set<SingleSignonToken> privateCreds = subject.getPrivateCredentials(SingleSignonToken.class);
                            Set<SingleSignonToken> publicCreds = subject.getPublicCredentials(SingleSignonToken.class);
                            if (privateCreds != null) {
                                creds.addAll(privateCreds);
                            }
                            if (publicCreds != null) {
                                creds.addAll(publicCreds);
                            }
                            return creds.toArray(new SingleSignonToken[0]);
                        }
                    });
                    defaultToken = new TokenHolder(cred.getCredentialToken(), "LtpaToken", -1);
                }
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1722", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception getting token list", e);
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1727", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Unexpected exception getting token list", ex);
            }
        }
        HashSet<TokenHolder> holders = new HashSet<TokenHolder>();
        for (int i = 0; tokens != null && i < tokens.length; ++i) {
            try {
                holders.add(new TokenHolder(tokens[i].getBytes(), tokens[i].getName(), tokens[i].getVersion()));
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1743", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unexpected exception building TokenHolder list", e);
            }
        }
        boolean sso_interop = security.getPropertyBool("com.ibm.ws.security.ssoInteropModeEnabled");
        if ((sso_interop || holders.size() == 0) && defaultToken != null) {
            holders.add(defaultToken);
        }
        TokenHolder[] tokenHolders = holders.toArray(new TokenHolder[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleSignonTokens", tokenHolders);
        }
        return tokenHolders;
    }

    private UserRegistry getRegistry(Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Properties props1 = ConfigUtils.maskPasswords(props);
            Tr.entry(tc, "getRegistry " + props1);
        }
        UserRegistry reg = this._registry;
        if (props == null && reg != null) {
            return reg;
        }
        if (props == null && reg == null) {
            Properties uprops = security.getActiveUserRegistry().getProperties();
            props = ConfigUtils.expandProps(uprops);
        }
        try {
            Boolean sslEnabled;
            Properties newProps = null;
            if (props != null) {
                newProps = new Properties();
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    newProps.put(key, props.get(key));
                }
            }
            if (newProps != null && (sslEnabled = (Boolean)newProps.get("sslEnabled")) != null && sslEnabled.booleanValue()) {
                Properties ssl2;
                block15: {
                    ssl2 = null;
                    try {
                        ssl2 = (Properties)newProps.get("sslConfig");
                    }
                    catch (ClassCastException e) {
                        SecureSocketLayer sslObject = (SecureSocketLayer)newProps.get("sslConfig");
                        if (sslObject == null) break block15;
                        ssl2 = this.createPropertiesFromSecureSocketLayer(sslObject);
                    }
                }
                if (ssl2 != null) {
                    newProps.put("sslConfig", ssl2);
                }
            }
            UserRegistryImpl regImpl = new UserRegistryImpl();
            Properties expProps = ConfigUtils.expandProps(newProps);
            regImpl.initialize(expProps);
            reg = regImpl;
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1843", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{re2});
            throw re2;
        }
        catch (CustomRegistryException cre) {
            FFDCFilter.processException((Throwable)cre, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1849", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{cre});
            throw cre;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1855", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry ");
        }
        if (this._registry == null) {
            this._registry = reg;
        }
        return reg;
    }

    private Properties createPropertiesFromSecureSocketLayer(SecureSocketLayer ssl2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Converting SSL config to properties.");
        }
        try {
            SSLConfig config = SSLConfigManager.getInstance().parseSecureSocketLayer(null, null, ssl2, true);
            return config;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.createPropertiesFromSecureSocketLayer", "1879", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception converting the properties.", new Object[]{e});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getProps(String fName) throws IOException {
        Properties ssoProps;
        block8: {
            URL ssoURL;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getProps ");
                }
                String fileName = fName;
                ssoURL = null;
                try {
                    ssoURL = new URL(fileName);
                }
                catch (MalformedURLException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getProps", "1902", this);
                    Tr.error(tc, "security.sa.set.props", new Object[]{fileName, e});
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Malformed url", fileName);
                }
            }
            ssoProps = new Properties();
            InputStream is = ssoURL.openStream();
            try {
                ssoProps.load(is);
                Object var7_7 = null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProps ");
        }
        return ssoProps;
    }

    private void setProps(Properties ssoProps, String fName) throws IOException {
        URL ssoURL;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setProps ");
            }
            String fileName = fName;
            ssoURL = null;
            try {
                ssoURL = new URL(fileName);
            }
            catch (MalformedURLException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.setProps", "1935", this);
                Tr.error(tc, "security.sa.set.props", new Object[]{fileName, e});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Malformed url", fileName);
            }
        }
        FileOutputStream os2 = null;
        os2 = new FileOutputStream(ssoURL.getFile());
        ssoProps.save(os2, "SSOProperties");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProps ");
        }
    }

    public void preInvoke(String methodName, Object[] parms, String[] signatures, StateObject stateObject, int correlationValue) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public void postInvoke(String methodName, Object[] parms, String[] signatures, StateObject stateObject, int correlationValue, Throwable thrownException, boolean invokeException) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (methodName.equals("purgeUserFromAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "purgeUserFromAuthCache()");
            }
            this.purgeUserFromAuthCache((String)parms[0], (String)parms[1]);
        } else if (methodName.equals("clearAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clearAuthCache()");
            }
            this.clearAuthCache();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagatePolicyToJACCProvider(String appList) throws Exception {
        block17: {
            String user2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "propagatePolicyToJACCProvider");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appList: " + appList);
            }
            WorkSpace ws = null;
            Archive archive = null;
            Resource res = null;
            try {
                String id = "" + System.currentTimeMillis();
                ws = WorkSpaceManagerFactory.getManager().getWorkSpace(id);
                RepositoryContextType type = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("deployments");
                Collection c = ws.findContext(type);
                Iterator itr = c.iterator();
                URI uri = URI.createURI("deployment.xml");
                while (itr.hasNext()) {
                    boolean switched;
                    String appName;
                    block16: {
                        Object var25_24;
                        RepositoryContext rc = (RepositoryContext)itr.next();
                        appName = rc.getName();
                        boolean found = false;
                        if (appList != null) {
                            StringTokenizer st = new StringTokenizer(appList, ":");
                            while (st.hasMoreTokens()) {
                                if (!appName.equals(st.nextToken())) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "appName to be propagated is: " + appName);
                                }
                                found = true;
                            }
                        }
                        if (appList != null && !found) continue;
                        String dirName = rc.getPath();
                        rc.extract(false);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appName is: " + appName + ", dirName is " + dirName);
                        }
                        switched = false;
                        try {
                            switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                            ArchiveOptions opt = new ArchiveOptions();
                            opt.setUseJavaReflection(false);
                            opt.setIsReadOnly(true);
                            res = rc.getResourceSet().createResource(uri);
                            HashMap options = new HashMap();
                            res.load(options);
                            Deployment d = (Deployment)res.getContents().get(0);
                            ApplicationDeployment appdepl = (ApplicationDeployment)d.getDeployedObject();
                            String contextID = appdepl.getAppContextIDForSecurity();
                            Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
                            prefs.put("app.client.locale", Locale.getDefault());
                            RepositoryContext rc1 = AppUtils.findAppContextFromConfig(appName, ws, prefs);
                            ResourceBundle resBundle = AppUtils.getBundle(prefs);
                            archive = ConfigRepoHelper.getEarFileForApp(ws, rc1, resBundle, true);
                            AppInstallNotify.getInstance().appInstall((EARFile)archive, appName, contextID, false);
                            var25_24 = null;
                            if (archive == null) break block16;
                        }
                        catch (Throwable throwable) {
                            var25_24 = null;
                            if (archive != null) {
                                archive.close();
                            }
                            if (res != null) {
                                res.unload();
                                res = null;
                            }
                            if (switched) {
                                DomainContextHelper.unwindAppDomain(appName);
                            }
                            throw throwable;
                        }
                        archive.close();
                    }
                    if (res != null) {
                        res.unload();
                        res = null;
                    }
                    if (!switched) continue;
                    DomainContextHelper.unwindAppDomain(appName);
                    {
                    }
                }
                Object var27_26 = null;
                if (ws == null) break block17;
                user2 = ws.getUserName();
            }
            catch (Throwable throwable) {
                Object var27_27 = null;
                if (ws != null) {
                    String user2 = ws.getUserName();
                    WorkSpaceManagerFactory.getManager().removeWorkSpace(user2);
                }
                throw throwable;
            }
            WorkSpaceManagerFactory.getManager().removeWorkSpace(user2);
            {
            }
        }
    }

    public static List getSecureSocketLayerCipherList(Boolean fipsEnabledFlag) {
        SSLContext sslContext = null;
        String[] cipherList = null;
        ArrayList<String> cipherObjectList = new ArrayList<String>();
        boolean systemFips = JSSEProviderFactory.isFipsEnabled();
        if (systemFips == fipsEnabledFlag) {
            CSIv2Config csiv2;
            String csiInboundConfigAlias;
            if (cachedDefaultCiphers != null && cachedDefaultCiphers.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSecureSocketLayerCipherList returning cached Ciphers: " + cachedDefaultCiphers);
                }
                return cachedDefaultCiphers;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecureSocketLayerCipherList cachedDefaultCiphers is null, proceed to determine the provider.");
            }
            if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && (csiInboundConfigAlias = (csiv2 = SecurityObjectLocator.getCSIv2Config()).getString("com.ibm.ssl.csi.inbound.alias")) != null) {
                block14: {
                    try {
                        HashMap<String, String> connectionInfo = new HashMap<String, String>();
                        connectionInfo.put("com.ibm.ssl.direction", "inbound");
                        connectionInfo.put("com.ibm.ssl.endPointName", "IIOP");
                        sslContext = JSSEHelper.getInstance().getSSLContext(csiInboundConfigAlias, connectionInfo, null);
                    }
                    catch (SSLException e) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Error getting sslConfig for alias " + csiInboundConfigAlias, new Object[]{e});
                    }
                }
                if (sslContext != null) {
                    cipherList = sslContext.getServerSocketFactory().getDefaultCipherSuites();
                    String[] supportedCipherList = sslContext.getServerSocketFactory().getSupportedCipherSuites();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default Cipher Suites: " + cipherList);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Supported Cipher Suites: " + supportedCipherList);
                    }
                }
            }
        }
        if (cipherList == null) {
            cipherList = fipsEnabledFlag != false ? FIPS_CIPHER_SUITES_LIST : CIPHER_SUITES_LIST;
        }
        cipherObjectList = new ArrayList(cipherList.length);
        for (int i = 0; i < cipherList.length; ++i) {
            if (cipherList[i].equals("SSL_DH_anon_WITH_AES_128_CBC_SHA") || cipherList[i].equals("SSL_DH_anon_WITH_RC4_128_MD5") || cipherList[i].equals("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA") || cipherList[i].equals("SSL_DH_anon_WITH_DES_CBC_SHA") || cipherList[i].equals("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5") || cipherList[i].equals("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA") || cipherList.equals("SSL_DH_anon_WITH_AES_256_CBC_SHA")) continue;
            cipherObjectList.add(cipherList[i]);
        }
        if (cipherObjectList != null && fipsEnabledFlag == systemFips) {
            cachedDefaultCiphers = cipherObjectList;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayerCipherList = " + cipherObjectList);
        }
        return cipherObjectList;
    }

    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        try {
            OpenKeyStoreAction action = new OpenKeyStoreAction(fileName);
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    public List warnForLocalOS(Boolean nodeIsZOS, String nodeHostName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "warnForLocalOS", "nodeIsZOS: " + nodeIsZOS + ", nodeHostName" + nodeHostName);
        }
        Boolean issueMessage = false;
        String dmgrHostName = null;
        ArrayList<Object> returnList = new ArrayList<Object>();
        Boolean secEnabled = security.getBoolean("enabled");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security is enabled: " + secEnabled);
        }
        if (secEnabled != null && secEnabled.booleanValue() && security.getActiveUserRegistry().getType().equals("LOCALOS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The active user registry for the deployment manager is LocalOS.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The deployment manager is on z/OS: " + AdminHelper.getPlatformHelper().isZOS());
            }
            if (!(nodeIsZOS.booleanValue() && AdminHelper.getPlatformHelper().isZOS() || (dmgrHostName = AdminHelper.getInstance().getHostName()) == null || dmgrHostName.equalsIgnoreCase(nodeHostName))) {
                issueMessage = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "warnForLocalOS", issueMessage + ", " + dmgrHostName);
        }
        returnList.add(issueMessage);
        returnList.add(dmgrHostName);
        return returnList;
    }

    public byte[] getKerberosPolicy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosPolicy");
        }
        try {
            if (this.kerberos_policy_bytes == null && OID.compareOIDs(SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("OID"), "oid:1.2.840.113554.1.2.2")) {
                String realmName = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm");
                String spnName = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Spn");
                if (realmName != null && realmName.length() > 0 && spnName != null && spnName.length() > 0) {
                    KerberosPolicy kp = new KerberosPolicy(spnName, realmName);
                    this.kerberos_policy_bytes = kp.getBytes();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKerberosPolicy");
            }
            return this.kerberos_policy_bytes;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityAdmin.getKerberosPolicy", "2348", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting the kerberos policy: " + e.getMessage() != null ? e.getMessage() : e.getClass().getName());
            }
            return null;
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "OpenKeyStoreAction.run");
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "OpenKeyStoreAction.run");
            }
            return fis;
        }
    }
}

