/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.configrpt;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CertValidity {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static Vector report = new Vector();
    int index = 0;
    int visited = 0;

    public String doCheck(Session session) throws Exception {
        Hashtable h = new Hashtable();
        String S = new String();
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        String commandListMgmtScopes = "listManagementScopes";
        AdminCommand listMgmtScopesCmd = null;
        Boolean displayObjectName = new Boolean(false);
        try {
            listMgmtScopesCmd = commandMgr.createCommand(commandListMgmtScopes);
            listMgmtScopesCmd.setConfigSession(session);
            listMgmtScopesCmd.setParameter("displayObjectName", displayObjectName);
        }
        catch (InvalidParameterNameException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (CommandNotFoundException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (CommandException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (ConnectorException e) {
            System.out.println("Caught exception: " + e);
        }
        listMgmtScopesCmd.execute();
        CommandResult mgmtScopesResult = listMgmtScopesCmd.getCommandResult();
        if (mgmtScopesResult.isSuccessful()) {
            List mgmtScopes = (List)mgmtScopesResult.getResult();
            int mgmtScopeSize = mgmtScopes.size();
            Iterator scopeIter = mgmtScopes.iterator();
            while (scopeIter.hasNext()) {
                String mgmtScopeName = scopeIter.next().toString();
                String command = "listKeyStores";
                AdminCommand listKeyStoresCmd = null;
                String scopeName = mgmtScopeName.substring(11, mgmtScopeName.length() - 1);
                try {
                    listKeyStoresCmd = commandMgr.createCommand(command);
                    listKeyStoresCmd.setConfigSession(session);
                    listKeyStoresCmd.setParameter("scopeName", scopeName);
                }
                catch (InvalidParameterNameException e) {
                    System.out.println("Caught exception: " + e);
                }
                catch (CommandNotFoundException e) {
                    System.out.println("Caught exception: " + e);
                }
                catch (CommandException e) {
                    System.out.println("Caught exception: " + e);
                }
                catch (ConnectorException e) {
                    System.out.println("Caught exception: " + e);
                }
                listKeyStoresCmd.execute();
                CommandResult cmdResult = listKeyStoresCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    List result = (List)cmdResult.getResult();
                    int keystore_size = result.size();
                    for (ObjectName keyStore : result) {
                        try {
                            KeyStore ks = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)keyStore);
                            String name = ks.getName();
                            String type = ks.getType();
                            String password = ks.getPassword();
                            this.listCertificates("listPersonalCertificates", session, name, scopeName);
                            this.listCertificates("listSignerCertificates", session, name, scopeName);
                        }
                        catch (Exception e) {
                            System.out.println("Caught exception: " + e);
                        }
                    }
                    continue;
                }
                try {
                    throw cmdResult.getException();
                }
                catch (Throwable e) {
                    System.out.println("Caught exception: " + e);
                }
            }
        }
        for (int count = 0; count < this.index; ++count) {
            h = (Hashtable)report.get(count);
            S = S + (String)h.get("label") + " ; " + (String)h.get("name") + " ; " + (String)h.get("value") + " ; " + (String)h.get("navigation") + " ; " + "\n";
        }
        return S;
    }

    private int listCertificates(String certCommand, Session session, String keyStoreName, String scopeName) throws Exception {
        CommandMgr certCommandMgr = CommandMgr.getCommandMgr();
        AdminCommand listCertCmd = null;
        try {
            listCertCmd = certCommandMgr.createCommand(certCommand);
            listCertCmd.setConfigSession(session);
            listCertCmd.setParameter("keyStoreName", keyStoreName);
            listCertCmd.setParameter("keyStoreScope", scopeName);
        }
        catch (InvalidParameterNameException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (CommandNotFoundException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (CommandException e) {
            System.out.println("Caught exception: " + e);
        }
        catch (ConnectorException e) {
            System.out.println("Caught exception: " + e);
        }
        listCertCmd.execute();
        CommandResult cmdCertResult = listCertCmd.getCommandResult();
        if (cmdCertResult.isSuccessful()) {
            List certResult = (List)cmdCertResult.getResult();
            int cert_size = certResult.size();
            if (cert_size > 0 && this.visited == 0) {
                Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                String label = new String();
                hashTable.put("label", "_" + CertValidity.getLabel("security.configrpt.Certificate.Console.Name"));
                hashTable.put("name", CertValidity.getLabel("security.configrpt.Certificate.Alias") + " ( " + CertValidity.getLabel("security.configrpt.core.keyStore") + " )");
                hashTable.put("value", CertValidity.getLabel("security.configrpt.Certificate.Expiry"));
                hashTable.put("navigation", CertValidity.getLabel("security.configrpt.core.Security") + " > " + CertValidity.getLabel("security.configrpt.secure.communications"));
                report.add(this.index, hashTable);
                ++this.index;
                this.visited = 1;
            }
            for (AttributeList attrbList : certResult) {
                String alias = "";
                String expiry = "";
                for (Attribute attr : attrbList) {
                    if (attr.getName().equals("alias")) {
                        alias = (String)attr.getValue();
                        continue;
                    }
                    if (!attr.getName().equals("validity")) continue;
                    expiry = (String)attr.getValue();
                }
                if (alias.length() <= 0 || expiry.length() <= 0) continue;
                Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                String label = new String();
                hashTable.put("label", CertValidity.getLabel("security.configrpt.Certificate.Management"));
                hashTable.put("name", alias + " ( " + keyStoreName + " )");
                hashTable.put("value", expiry);
                hashTable.put("navigation", CertValidity.getLabel("security.configrpt.core.Security") + " > " + CertValidity.getLabel("security.configrpt.secure.communications"));
                report.add(this.index, hashTable);
                ++this.index;
            }
            return 0;
        }
        return 1;
    }

    private static String getLabel(String key) {
        String message = " ";
        try {
            message = resBundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + " in resource bundle" + resBundle.toString());
            }
        }
        catch (Exception e) {
            message = new String(key);
            return message;
        }
        if (message.startsWith("SECJ")) {
            message = message.substring(11, message.length());
        }
        return message;
    }
}

