/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.HostConfig;
import com.ibm.ws.security.config.HostConfigImpl;
import com.ibm.ws.security.config.SearchFilterConfig;
import com.ibm.ws.security.config.SearchFilterConfigImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserRegistryConfigImpl
extends GenericConfigHelperImpl
implements UserRegistryConfig {
    private static final String SEARCH_FILTER = "searchFilter";
    private static final String HOSTS = "hosts";
    private String realm = null;
    private boolean firstTimeRealm = true;
    private static TraceComponent tc = Tr.register(UserRegistryConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private SearchFilterConfig sfc = null;
    private List<HostConfig> hosts = null;
    private Properties props = null;
    private String type = null;
    private UserRegistry registryStub = null;
    private boolean registryStubInitialized = false;
    private UserRegistry registryImpl = null;
    private boolean registryImplInitialized = false;

    public UserRegistryConfigImpl(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("serverId", null);
        this.defaults.put("serverPassword", null);
        this.defaults.put("realm", null);
        this.defaults.put("useRegistryServerId", Boolean.FALSE);
        this.defaults.put("primaryAdminId", null);
        this.defaults.put("registryClassName", null);
        this.defaults.put("customRegistryClassName", null);
        this.defaults.put("ignoreCase", Boolean.FALSE);
        this.defaults.put("type", "IBM_DIRECTORY_SERVER");
        this.defaults.put("sslEnabled", Boolean.FALSE);
        this.defaults.put("sslConfig", null);
        this.defaults.put("baseDN", null);
        this.defaults.put("bindDN", null);
        this.defaults.put("bindPassword", null);
        this.defaults.put("searchTimeout", 0L);
        this.defaults.put("reuseConnection", Boolean.FALSE);
        this.defaults.put("com.ibm.websphere.security.registry.UseTAM", Boolean.FALSE);
    }

    private void initialization() {
        String useTAM;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialization " + this.cacheKey);
        }
        if (this.sco.isDomainConfig() && !SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
            this.setBoolean("useRegistryServerId", SecurityObjectLocator.getSecurityConfig("security").getActiveUserRegistry().getBoolean("useRegistryServerId"));
        }
        if ((useTAM = this.getProperty("com.ibm.websphere.security.registry.UseTAM")) != null) {
            this.setBoolean("com.ibm.websphere.security.registry.UseTAM", Boolean.valueOf(useTAM));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using Tivoli Access Manager");
            }
        }
        if (this.getType().equals("LOCALOS") && PlatformHelperFactory.getPlatformHelper().isZOS()) {
            String regServerId = this.getString("serverId");
            String regServerPw = this.getDecodedString("serverPassword");
            regServerId = regServerId == null || regServerId.length() == 0 ? null : regServerId;
            String string = regServerPw = regServerPw == null || regServerPw.length() == 0 ? null : regServerPw;
            if (regServerId == null || regServerPw == null || !this.getBoolean("useRegistryServerId")) {
                this.setString("serverId", System.getProperty("user.name"));
                this.setString("serverPassword", "");
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialization " + this.cacheKey);
        }
    }

    @Override
    public String getType() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType " + this.cacheKey);
        }
        if (this.type != null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "getType " + this.cacheKey, this.type);
            }
            return this.type;
        }
        if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LDAPUserRegistry")) {
            this.type = "LDAP";
        } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LocalOSUserRegistry")) {
            this.type = "LOCALOS";
        } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "CustomUserRegistry")) {
            this.type = "CUSTOM";
        } else if (this.sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "WIMUserRegistry")) {
            this.type = "WIMUserRegistry";
        } else {
            Tr.error(tc, "Unable to determine the correct type for this authMechanism");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getType " + this.cacheKey, this.type);
        }
        return this.type;
    }

    private String buildLDAPURL(String ldapHost, String hostName, Integer portInt, Properties props) {
        StringBuffer ldapURL;
        block21: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "buildLDAPURL " + this.cacheKey, new Object[]{ldapHost, hostName, portInt, props});
            }
            String ldapProtocol = "ldap://";
            String port = null;
            if (portInt != null && portInt > 0) {
                port = portInt.toString();
            }
            if (hostName != null && !hostName.equals("")) {
                props.put("com.ibm.ssl.remoteHost", hostName);
            }
            if (port != null && !port.equals("")) {
                props.put("com.ibm.ssl.remotePort", port);
            }
            ldapURL = new StringBuffer();
            if (hostName != null && hostName.startsWith("ldap://")) {
                hostName = hostName.substring("ldap://".length());
            }
            if (ConfigUtils.isIPv6Addr(hostName)) {
                hostName = ConfigUtils.formatIPv6Addr(hostName);
            }
            ldapURL.append("ldap://").append(hostName);
            if (port != null && port.length() > 0) {
                ldapURL.append(":" + port);
            }
            boolean useSingleIP = false;
            String singleLDAP = (String)props.get("com.ibm.websphere.security.registry.ldap.singleLDAP");
            if (singleLDAP != null && singleLDAP.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "com.ibm.websphere.security.registry.ldap.singleLDAP property is set to true");
                }
                useSingleIP = true;
            }
            if (!useSingleIP && hostName != null && hostName.length() > 0) {
                try {
                    InetAddress[] IPs = InetAddress.getAllByName(hostName);
                    if (IPs != null && IPs.length > 1) {
                        StringBuffer IPlist = new StringBuffer(hostName);
                        IPlist.append(" has multiple IP addresses of ");
                        for (int i = 0; i < IPs.length; ++i) {
                            String ip = IPs[i].getHostAddress();
                            if (ConfigUtils.isIPv6Addr(ip)) {
                                ip = ConfigUtils.formatIPv6Addr(ip);
                            }
                            IPlist.append(" ").append(ip).append(",");
                            ldapURL.append(" ldap://").append(ip);
                            if (port == null || port.length() <= 0) continue;
                            ldapURL.append(":" + port);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, IPlist.toString());
                        }
                    }
                }
                catch (Exception e) {
                    if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Could not resolve IP address(es) of LDAP host name: " + hostName);
                }
            }
        }
        if (ldapURL != null && ldapURL.length() > 0) {
            if (ldapHost == "") {
                ldapHost = ldapURL.toString();
            } else {
                String bLdap = ldapURL.toString();
                if (ldapHost.indexOf(bLdap) == -1) {
                    ldapHost = ldapHost + " " + bLdap;
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildLDAPURL " + this.cacheKey, ldapHost);
        }
        return ldapHost;
    }

    private Properties setupLDAPProperties() {
        String sslProps;
        String type;
        String bindDN;
        String baseDN;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setupLDAPProperties " + this.cacheKey);
        }
        this.props = this.sco.getProperties();
        if (this.props == null) {
            this.props = new Properties();
        }
        String serverId = this.getUnexpandedString("serverId");
        try {
            serverId = ConfigUtils.expandHost((SecurityConfig)((Object)this.parent), serverId, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (serverId != null && serverId.length() > 0) {
            this.props.put("LDAP.server.id", ConfigUtils.variableMapExpand(serverId));
        } else {
            this.props.put("LDAP.server.id", "");
        }
        String utf8_passwd = null;
        String passwd = this.getDecodedString("serverPassword");
        byte[] serverPasswordBytes = null;
        if (passwd != null && passwd.length() > 0) {
            try {
                serverPasswordBytes = passwd.getBytes("UTF-8");
                utf8_passwd = new String(serverPasswordBytes, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (utf8_passwd != null) {
            this.props.put("LDAP.server.pwd", ConfigUtils.variableMapExpand(utf8_passwd));
        } else {
            this.props.put("LDAP.server.pwd", "");
        }
        String realm = this.getString("realm");
        if (realm != null && realm.length() > 0) {
            this.props.put("LDAP.server.realm", ConfigUtils.variableMapExpand(realm));
        } else {
            this.props.put("LDAP.server.realm", "");
        }
        SearchFilterConfig searchFilter = this.getSearchFilter();
        if (searchFilter != null) {
            String val;
            SecurityConfig securityConfig = (SecurityConfig)((Object)this.parent);
            String activeAuthMech = securityConfig.getActiveAuthMechanism(true).getType();
            String userFilter = searchFilter.getString("userFilter");
            String krbUserFilter = searchFilter.getString("krbUserFilter");
            if (activeAuthMech.equalsIgnoreCase("KRB5") && krbUserFilter != null && krbUserFilter.length() != 0) {
                if (userFilter != null && userFilter.length() != 0) {
                    this.props.put("user.filter", "(|" + krbUserFilter + userFilter + ")");
                } else {
                    this.props.put("user.filter", krbUserFilter);
                }
            } else if (userFilter != null && userFilter.length() != 0) {
                this.props.put("user.filter", userFilter);
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "userFilter: " + this.props.get("user.filter"));
            }
            if ((val = searchFilter.getString("groupFilter")) != null) {
                this.props.put("group.filter", val);
            }
            if ((val = searchFilter.getString("groupIdMap")) != null) {
                this.props.put("group.idmap", val);
            }
            if ((val = searchFilter.getString("userIdMap")) != null) {
                this.props.put("user.idmap", val);
            }
            if ((val = searchFilter.getString("groupMemberIdMap")) != null) {
                this.props.put("groupmember.idmap", val);
            }
            this.props.put("security.registry.ldap.searchTimeLimit", String.valueOf(this.getLong("searchTimeout")));
            this.props.put("security.registry.ldap.reuseConn", String.valueOf(this.getBoolean("reuseConnection")));
            String certificateFilter = searchFilter.getUnexpandedString("certificateFilter");
            String certificateMapMode = searchFilter.getString("certificateMapMode");
            if (certificateMapMode.equals("EXACT_DN")) {
                this.props.put("certificate.map.mode", "exactDNMode");
                this.props.put("certificate.map.filter", "");
            } else if (certificateMapMode.equals("CERTIFICATE_FILTER")) {
                this.props.put("certificate.map.mode", "filterDescriptorMode");
                if (certificateFilter != null) {
                    this.props.put("certificate.map.filter", certificateFilter);
                }
            }
        }
        String ldapURLS = "";
        List<HostConfig> hosts = this.getHosts();
        if (hosts != null && hosts.size() > 0) {
            for (int j = 0; j < hosts.size(); ++j) {
                String hostName = "";
                Integer portInt = null;
                HostConfig host = hosts.get(j);
                hostName = ConfigUtils.variableMapExpand(host.getString("host"));
                portInt = host.getInteger("port");
                ldapURLS = this.buildLDAPURL(ldapURLS, hostName, portInt, this.props);
            }
            this.props.put("java.naming.provider.url", ldapURLS);
        }
        if ((baseDN = this.getString("baseDN")) != null && baseDN.length() > 0) {
            this.props.put("ldap.basedn", ConfigUtils.variableMapExpand(baseDN));
        }
        if ((bindDN = this.getString("bindDN")) != null && bindDN.length() > 0) {
            this.props.put("java.naming.security.principal", ConfigUtils.variableMapExpand(bindDN));
        }
        String bindPassword = this.getDecodedString("bindPassword");
        String utf8_bindPassword = null;
        byte[] bindPasswordBytes = null;
        if (bindPassword != null && bindPassword.length() > 0) {
            try {
                bindPasswordBytes = bindPassword.getBytes("UTF-8");
                utf8_bindPassword = new String(bindPasswordBytes, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (utf8_bindPassword != null && utf8_bindPassword.length() > 0) {
            this.props.put("java.naming.security.credentials", ConfigUtils.variableMapExpand(utf8_bindPassword));
        }
        if ((type = this.getString("type")) != null) {
            if (type.equals("IBM_DIRECTORY_SERVER")) {
                this.props.put("dirType", "ibm_dir_server");
            } else if (type.equals("IPLANET")) {
                this.props.put("dirType", "iplanet");
            } else if (type.equals("NETSCAPE")) {
                this.props.put("dirType", "netscape");
            } else if (type.equals("DOMINO502")) {
                this.props.put("dirType", "domino50");
            } else if (type.equals("SECUREWAY")) {
                this.props.put("dirType", "secureway");
            } else if (type.equals("ACTIVE_DIRECTORY")) {
                this.props.put("dirType", "actived");
            } else if (type.equals("NDS")) {
                this.props.put("dirType", "edirectory");
            } else if (type.equals("CUSTOM")) {
                this.props.put("dirType", "custom");
            }
        }
        Boolean sslEnabled = this.getBoolean("sslEnabled");
        this.props.put("sslEnabled", sslEnabled);
        if (sslEnabled.booleanValue() && (sslProps = this.getString("sslConfig")) != null) {
            this.props.put("security.registry.ldap.SSLAlias", sslProps);
        }
        this.props.put("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "setupLDAPProperties " + this.cacheKey, this.props);
        }
        return this.props;
    }

    private synchronized void do_getProperties() {
        if (this.props == null) {
            String custImpl;
            if (this.getType() == "LDAP") {
                this.props = this.setupLDAPProperties();
            } else if (this.getType() == "WIMUserRegistry") {
                this.props = this.sco.getProperties();
                custImpl = this.getString("registryClassName");
                if (custImpl != null) {
                    if (this.props == null) {
                        this.props = new Properties();
                    }
                    this.props.put("CustUserRegImplClass", custImpl);
                }
            } else if (this.getType() == "CUSTOM") {
                this.props = this.sco.getProperties();
                custImpl = this.getString("customRegistryClassName");
                if (custImpl != null) {
                    if (this.props == null) {
                        this.props = new Properties();
                    }
                    this.props.put("CustUserRegImplClass", custImpl);
                }
            } else {
                this.props = this.sco.getProperties();
            }
            Boolean useRegistryRealm = this.getBoolean("useRegistryRealm");
            String urRealm = super.getString("realm");
            if (useRegistryRealm != null && urRealm != null) {
                if (this.props == null) {
                    this.props = new Properties();
                }
                this.props.put("WAS_UseRegistryRealm", useRegistryRealm.toString());
                this.props.put("WAS_Realm", urRealm);
            }
        }
    }

    @Override
    public Properties getProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties " + this.cacheKey);
        }
        if (this.props == null) {
            this.do_getProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties " + this.cacheKey, this.props);
        }
        return this.props;
    }

    @Override
    public String getProperty(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty " + key + " " + this.cacheKey);
        }
        String result = null;
        if (this.props == null) {
            this.getProperties();
        }
        if (this.props != null) {
            result = this.props.getProperty(key);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty " + this.cacheKey, result);
        }
        return result;
    }

    private synchronized void do_getSearchFilter() {
        if (this.sfc == null) {
            SecurityConfigObject sso_sfc = this.sco.getObject(SEARCH_FILTER);
            this.sfc = new SearchFilterConfigImpl(sso_sfc, this, this.cacheKey);
        }
    }

    public SearchFilterConfig getSearchFilter() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSearchFilter " + this.cacheKey);
        }
        if (this.sfc == null) {
            this.do_getSearchFilter();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSearchFilter " + this.cacheKey, this.sfc);
        }
        return this.sfc;
    }

    private synchronized void do_getHosts() {
        if (this.hosts == null) {
            SecurityConfigObjectList scol = this.sco.getObjectList(HOSTS);
            int size = scol.size();
            this.hosts = new LinkedList<HostConfig>();
            for (int i = 0; i < size; ++i) {
                this.hosts.add(new HostConfigImpl(scol.get(i), this, this.cacheKey));
            }
        }
    }

    public List<HostConfig> getHosts() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHosts " + this.cacheKey);
        }
        if (this.hosts == null) {
            this.do_getHosts();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHosts " + this.cacheKey, this.hosts);
        }
        return this.hosts;
    }

    @Override
    public String getPrincipalName() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipalName " + this.cacheKey);
        }
        String realmName = this.getString("realm");
        String loginUserId = this.getString("serverId");
        if ((realmName == null || loginUserId == null) && tc.isDebugEnabled()) {
            Tr.debug(tc, "realmName or loginUserId is NULL, realmName=" + realmName + " loginUserId=" + loginUserId);
        }
        if (loginUserId == null) {
            loginUserId = "";
        }
        realmName = realmName + "/" + loginUserId;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrincipalName " + this.cacheKey, realmName);
        }
        return realmName;
    }

    @Override
    public Object getUserRegistryStub() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistryStub " + this.cacheKey);
        }
        Object registry = null;
        PlatformHelper helper = PlatformHelperFactory.getPlatformHelper();
        if (helper.isZOS() && helper.isServantJvm()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "getUserRegistryStub in zOS servant, returning impl");
            }
            registry = this.getUserRegistryImpl();
        } else {
            if (!this.registryStubInitialized) {
                this.createRegistryObjects();
            }
            registry = this.registryStub;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserRegistryStub " + this.cacheKey, registry);
        }
        return registry;
    }

    @Override
    public Object getUserRegistryImpl() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistryImpl " + this.cacheKey);
        }
        if (!this.registryImplInitialized) {
            this.createRegistryObjects();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserRegistryImpl " + this.cacheKey, this.registryImpl);
        }
        return this.registryImpl;
    }

    private synchronized void createRegistryObjects() {
        block3: {
            if (!this.registryImplInitialized) {
                try {
                    this.do_createRegistryObjects();
                }
                catch (Exception e) {
                    if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "getUserRegistryImpl unexpected exception calling createRegistryObjects", e);
                }
            }
        }
    }

    private void do_createRegistryObjects() throws CustomRegistryException, NamingException, Exception {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "createRegistryObjects " + this.cacheKey);
        }
        InitialContext ic = null;
        SecurityConfig security2 = (SecurityConfig)((Object)this.parent);
        String remoteReg = security2.getProperty("WAS_UseRemoteRegistry");
        if (remoteReg != null && (remoteReg.equalsIgnoreCase("node") || remoteReg.equalsIgnoreCase("cell"))) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "createRegistryObjects (remote)");
            }
            return;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "createRegistryObjects creating user registry");
        }
        Properties props = this.getProperties();
        Properties urProps = ConfigUtils.expandProps(props);
        boolean pushed = false;
        try {
            if (this.getSCO().isDomainConfig()) {
                pushed = SecurityObjectLocator.pushAppContext("");
                urProps.put("security.domain.type", "admin_and_app");
            } else {
                urProps.put("security.domain.type", "administration");
            }
            Class<?> myClass = Class.forName("com.ibm.ws.security.auth.ContextManagerImpl");
            Method myMethod = myClass.getMethod("getNewRegistryImpl", null);
            this.registryImpl = (UserRegistry)myMethod.invoke((Object)null, (Object[])null);
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects got registryImpl", this.registryImpl);
            }
            this.registryImpl.initialize(urProps);
            this.registryImplInitialized = true;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects initialized registry for realm: " + this.registryImpl.getRealm());
            }
        }
        catch (CustomRegistryException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "709", this);
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects error creating User Registry");
            }
            Tr.error(tc, "security.secsrv.create.registry", new Object[]{e});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "719", this);
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects error creating User Registry");
            }
            Tr.error(tc, "security.secsrv.create.registry", new Object[]{e});
            throw e;
        }
        finally {
            if (pushed) {
                SecurityObjectLocator.popContext();
            }
        }
        String name = null;
        String serverType = null;
        if (this.getSCO().isDomainConfig()) {
            PlatformHelper helper = PlatformHelperFactory.getPlatformHelper();
            AdminData ad = SecurityObjectLocator.getAdminData();
            if (ad != null) {
                serverType = ad.getServerType();
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Server type: " + serverType);
            }
            if (helper.isZOS() && helper.isServantJvm() || "SECUREPROXY".equals(serverType)) {
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createRegistryObjects in SR or proxy server, Using Local version of userRegistryImpl");
                }
                return;
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects not in the  SR or proxy server, getting the InitialContext ");
            }
            try {
                ic = new InitialContext();
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "751", this);
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createRegistryObjects Failed to get initial Naming Context");
                }
                Tr.error(tc, "security.secsrv.get.initCtx", new Object[]{e});
                throw e;
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "createRegistryObjects have the InitialContext, now rebind");
            }
            try {
                String profileId = AdminContext.peek();
                name = profileId != null ? "UserRegistry-" + profileId : "UserRegistry";
                final String name_final = name;
                final InitialContext ic_final = ic;
                try {
                    SecurityContext.runAsSystem(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ic_final.rebind(name_final, (Object)UserRegistryConfigImpl.this.registryImpl);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception ex = pae.getException();
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "732", this);
                    throw ex;
                }
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createRegistryObjects bound registry " + this.registryImpl + " to name " + name);
                }
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "773", this);
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createRegistryObjects Error binding User Registry");
                }
                Tr.error(tc, "security.secsrv.bind.registry", new Object[]{e});
                throw e;
            }
            try {
                Object objref = ic.lookup(name);
                this.registryStub = (UserRegistry)PortableRemoteObject.narrow((Object)objref, UserRegistry.class);
                this.registryStubInitialized = true;
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createRegistryObjects narrow returned stub " + this.registryStub);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.SecurityServerImpl.getUserRegistry", "793", this);
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "createRegistryObjects exception looking up or narrowing registry");
                }
                Tr.error(tc, "security.secsrv.find.registry", new Object[]{e});
                throw e;
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "createRegistryObjects" + this.cacheKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(String key) {
        String returnValue;
        block10: {
            block11: {
                block12: {
                    if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                        Tr.entry(tc, "getString() key=" + key + " " + this.cacheKey);
                    }
                    returnValue = null;
                    if (key != "realm" && !key.equals("realm")) break block11;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "key == UserRegistryConfig.REALM");
                    }
                    if (this.realm == null || this.realm.equals("")) break block12;
                    returnValue = this.realm;
                    break block10;
                }
                returnValue = this.realm = super.getString(key);
                if (this.realm != null && this.realm.length() != 0) break block10;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getString() realm null in config, getting from registry", this.registryImpl);
                }
                if (this.firstTimeRealm) {
                    this.firstTimeRealm = false;
                    returnValue = super.getString(key);
                    break block10;
                } else {
                    try {
                        if (this.registryImpl == null) {
                            returnValue = "DEFAULT";
                            break block10;
                        }
                        returnValue = this.realm = ((UserRegistry)this.getUserRegistryImpl()).getRealm();
                        this.setString("realm", returnValue);
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getString() unexpected exception getting realm from registry", e);
                        }
                        break block10;
                    }
                }
            }
            returnValue = super.getString(key);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getString() key=" + key + " " + this.cacheKey, returnValue);
        }
        return returnValue;
    }

    @Override
    public String getRealmFromConfig() {
        String realm = super.getString("realm");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmFromConfig", realm);
        }
        return realm;
    }

    @Override
    public void setUserRegistryStub(Object userRegistryStub) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUserRegistryStub " + this.registryStub + " " + this.cacheKey);
        }
        this.registryStub = (UserRegistry)userRegistryStub;
    }
}

