/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.AuthMechanismConfigImpl;
import com.ibm.ws.security.config.AuthorizationConfig;
import com.ibm.ws.security.config.AuthorizationConfigImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.CSIv2ConfigData;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.JAASLoginConfig;
import com.ibm.ws.security.config.JAASLoginConfigImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustAssociationConfig;
import com.ibm.ws.security.config.TrustAssociationConfigImpl;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.config.UserRegistryConfigImpl;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConfigImpl
extends GenericConfigHelperImpl
implements SecurityConfig {
    private static final String AUTH_MECHANISMS = "authMechanisms";
    private static final String USER_REGISTRIES = "userRegistries";
    private static final String TRUST_ASSOCIATION = "trustAssociation";
    private static final String AUTHORIZATION_CONFIG = "authConfig";
    private static final String CSIv2 = "CSI";
    private static final String INBOUND_TRUSTED_AUTHENTICATION_REALM = "inboundTrustedAuthenticationRealm";
    private static final String OUTBOUND_TRUSTED_AUTHENTICATION_REALM = "outboundTrustedAuthenticationRealm";
    private static final String ACTIVE_AUTH_MECHANISM = "activeAuthMechanism";
    private static final String ACTIVE_USER_REGISTRY = "activeUserRegistry";
    private static char UNCHECKED = '\u0000';
    private static char CHECKED = '\u0001';
    private static char INHERITED = (char)16;
    private static TraceComponent tc = Tr.register(SecurityConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private AuthMechanismConfig activeAuthMech = null;
    private char state_activeAuthMech = UNCHECKED;
    private AuthMechanismConfig adminPreferredAuthMech = null;
    private List<AuthMechanismConfig> authMechanisms = null;
    private char state_tai = UNCHECKED;
    private TrustAssociationConfig tai = null;
    private UserRegistryConfig activeUserReg = null;
    private char state_activeUserReg = UNCHECKED;
    private List<UserRegistryConfig> userRegistries = null;
    private char state_userRegistries = UNCHECKED;
    private AuthorizationConfig authzConfig = null;
    private char state_authzConfig = UNCHECKED;
    private JAASLoginConfig loginConfig = null;
    private CSIv2ConfigData csiv2Data = null;
    private char state_csiv2Data = UNCHECKED;
    private TrustedAuthenticationRealm inboundTrustedAuthenticationRealm = null;
    private char state_inboundTrustedAuthenticationRealm = UNCHECKED;
    private TrustedAuthenticationRealm outboundTrustedAuthenticationRealm = null;
    private char state_outboundTrustedAuthenticationRealm = UNCHECKED;
    private Properties props = null;
    private HashMap<String, String> defaultProps = null;
    private Boolean _performTAIForUnprotectedURI = null;
    private HashMap<String, String> propsCache = null;
    private HashMap<String, Boolean> boolPropsCache = null;

    public SecurityConfigImpl(SecurityConfigObject obj, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, obj);
        }
        this.propsCache = new HashMap(30);
        this.boolPropsCache = new HashMap(20);
        super.initialize(obj, null, _cacheKey);
        this.initialize_defaults();
        this.initialize_default_props();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            this.dumpProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize_defaults " + this.cacheKey);
        }
        this.defaults.put("enabled", Boolean.TRUE);
        this.defaults.put("appEnabled", Boolean.FALSE);
        this.defaults.put(ACTIVE_AUTH_MECHANISM, "LTPA");
        this.defaults.put("adminPreferredAuthMech", "LTPA");
        this.defaults.put("cacheTimeout", 30000);
        this.defaults.put("enforceFineGrainedJCASecurity", Boolean.TRUE);
        this.defaults.put("enforceJava2Security", Boolean.FALSE);
        this.defaults.put("useLocalSecurityServer", Boolean.TRUE);
        this.defaults.put("useDomainQualifiedUserNames", Boolean.FALSE);
        this.defaults.put("issuePermissionsWarning", Boolean.FALSE);
        this.defaults.put("activeProtocol", "");
        this.defaults.put("dynamicallyUpdateSSLConfig", Boolean.FALSE);
        this.defaults.put("com.ibm.wsspi.security.web.webAuthReq", "lazy");
        this.defaults.put("com.ibm.wsspi.security.web.failOverToBasicAuth", Boolean.FALSE);
        this.defaults.put("security.domain.type", "admin_and_app");
        this.defaults.put("use_single_registry", Boolean.FALSE);
        this.defaults.put("boolNativeAuthz", Boolean.TRUE);
        this.defaults.put("com.ibm.CORBA.delegateCredentials", null);
        this.defaults.put("boolDefaultJaccProvider", Boolean.FALSE);
        this.defaults.put("com.ibm.websphere.security.rsaCertificateAliasCache", 5000);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize_defaults " + this.cacheKey);
        }
    }

    private void initialize_default_props() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize_default_props " + this.cacheKey);
        }
        this.defaultProps = new HashMap();
        this.defaultProps.put("security.useShortHostName", "false");
        this.defaultProps.put("com.ibm.wsspi.security.token.authorizationTokenFactory", "com.ibm.ws.security.ltpa.AuthzPropTokenFactory");
        this.defaultProps.put("com.ibm.wsspi.security.token.propagationTokenFactory", "com.ibm.ws.security.ltpa.AuthzPropTokenFactory");
        this.defaultProps.put("com.ibm.wsspi.security.token.authenticationTokenFactory", "com.ibm.ws.security.ltpa.LTPATokenFactory");
        this.defaultProps.put("com.ibm.wsspi.security.token.singleSignonTokenFactory", "com.ibm.ws.security.ltpa.LTPATokenFactory");
        this.defaultProps.put("com.ibm.wsspi.security.token.defaultTokenFactory", "com.ibm.ws.security.ltpa.LTPATokenFactory");
        this.defaultProps.put("com.ibm.wsspi.security.ltpa.tokenFactory", "com.ibm.ws.security.ltpa.LTPATokenFactory|com.ibm.ws.security.ltpa.AuthzPropTokenFactory");
        this.defaultProps.put("com.ibm.security.useFIPS", "false");
        this.defaultProps.put("com.ibm.websphere.security.registry.propagateExceptionsToClient", "false");
        this.defaultProps.put("com.ibm.CSI.authenticateSpecialMethods", "false");
        this.defaultProps.put("com.ibm.CSI.rmiOutboundPropagationEnabled", "false");
        this.defaultProps.put("com.ibm.CSI.rmiInboundPropagationEnabled", "false");
        this.defaultProps.put("com.ibm.CSI.rmiOutboundLoginEnabled", "false");
        this.defaultProps.put("com.ibm.ws.security.webInboundPropagationEnabled", "false");
        this.defaultProps.put("com.ibm.ws.security.ssoInteropModeEnabled", "false");
        this.defaultProps.put("com.ibm.CSI.rmiOutboundMappingEnabled", "false");
        this.defaultProps.put("com.ibm.CSI.rmiInboundMappingEnabled", "false");
        this.defaultProps.put("com.ibm.CSI.rmiInboundLoginConfig", "system.LTPA");
        this.defaultProps.put("com.ibm.ws.security.defaultLoginConfig", "system.LTPA");
        this.defaultProps.put("com.ibm.CSI.rmiOutboundLoginConfig", "system.RMI_OUTBOUND");
        this.defaultProps.put("com.ibm.ws.security.webInboundLoginConfig", "system.LTPA_WEB");
        this.defaultProps.put("com.ibm.ws.security.includeRunAsChangesInCallerList", "false");
        this.defaultProps.put("com.ibm.wsspi.security.token.ltpaToken2Cipher", "AES/CBC/PKCS5Padding");
        this.defaultProps.put("com.ibm.ws.security.createTokenSubjectForAsynchLogin", "false");
        this.defaultProps.put("com.ibm.ws.security.ltpa.forceSoftwareJCEProviderForLTPA", "false");
        this.defaultProps.put("com.ibm.ws.security.webPropagationTransport", "SOAP");
        this.defaultProps.put("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound", "true");
        this.defaultProps.put("com.ibm.ws.security.propagationExcludeList", "");
        this.defaultProps.put("com.ibm.ws.security.assertLDAPShortName", "false");
        this.defaultProps.put("com.ibm.websphere.security.registry.maxUseridSize", "256");
        this.defaultProps.put("com.ibm.websphere.security.registry.maxPasswordSize", "256");
        this.defaultProps.put("security.enablePluggableAuthentication", "false");
        this.defaultProps.put("security.enableAuthorizationAttributes", "false");
        this.defaultProps.put("com.ibm.ws.security.cacheCushionMin", "3");
        this.defaultProps.put("com.ibm.ws.security.cacheCushionMax", "10");
        this.defaultProps.put("security.callbackHandlerFactoryClass", "com.ibm.ws.security.auth.callback.WSCallbackHandlerFactoryImpl");
        this.defaultProps.put("security.mappingCallbackHandlerFactoryClass", "com.ibm.ws.security.auth.callback.WSMappingCallbackHandlerFactoryImpl");
        this.defaultProps.put("security.callbackHandlerClass", "com.ibm.ws.security.auth.callback.WSCallbackHandler");
        this.defaultProps.put("security.useDefaultPolicyWhenJ2SDisabled", "false");
        this.defaultProps.put("com.ibm.ws.security.web.logoutOnHTTPSessionExpire", "false");
        this.defaultProps.put("com.ibm.websphere.gss.cred.propagation", "false");
        this.defaultProps.put("com.ibm.websphere.runas.id.assert", "false");
        this.defaultProps.put("com.ibm.websphere.security.InvokeTAIbeforeSSO", "");
        this.defaultProps.put("com.ibm.websphere.security.util.postParamSaveMethod", "0");
        this.defaultProps.put("com.ibm.websphere.security.util.postParamMaxCookieSize", "16384");
        this.defaultProps.put("com.ibm.websphere.security.util.fullyQualifiedURL", "false");
        this.defaultProps.put("com.ibm.websphere.security.suppressExceptionStack", "false");
        this.defaultProps.put("com.ibm.websphere.security.util.enableOneCharacterVariablesExpansion", "false");
        this.defaultProps.put("com.ibm.CSI.refreshClientSubjectGoingOutbound", "true");
        this.defaultProps.put("com.ibm.ws.security.addHttpOnlyAttributeToCookies", "false");
        this.defaultProps.put("com.ibm.websphere.security.krb.canonical_host", "false");
        this.defaultProps.put("com.ibm.websphere.security.domain.inherit.J2C", "true");
        this.defaultProps.put("com.ibm.websphere.security.domain.inherit.JAAS", "true");
        this.defaultProps.put("com.ibm.security.SAF.useAPPLprofile", "true");
        this.defaultProps.put("security.zOS.domainType", "none");
        this.defaultProps.put("com.ibm.security.SAF.profilePrefix", "");
        this.defaultProps.put("com.ibm.websphere.security.rsaCertificateAliasCache", "5000");
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize_default_props " + this.cacheKey);
        }
    }

    private String getDescriptiveProperties(SecurityConfigObjectList props, String key) {
        SecurityConfigObject desProp;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptiveProperties " + this.cacheKey, new Object[]{props, key});
        }
        String outString = null;
        if (props != null && props.size() > 0 && (desProp = props.getObject("name", key)) != null) {
            outString = desProp.getString("value", null);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptiveProperties " + this.cacheKey, outString);
        }
        return outString;
    }

    private void initialization_zOS() {
        String safAuthzEnabled;
        String securityZOSDomainType;
        UserRegistryConfig aur;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialization_zOS " + this.cacheKey);
        }
        if ((aur = this.getActiveUserRegistry()).getType().equals("LOCALOS")) {
            this.setString("com.ibm.websphere.security.TrustedIDEvaluator", "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl");
        }
        if (null != (securityZOSDomainType = this.getProperty("security.zOS.domainType"))) {
            this.setString("security.zOS.domainType", securityZOSDomainType);
        }
        String profilePrefix = this.getProperty("security.zOS.domainName");
        if ("cellQualified".equalsIgnoreCase(securityZOSDomainType) && profilePrefix != null) {
            this.setString("security.zOS.domainName", profilePrefix);
        }
        if ((safAuthzEnabled = this.getProperty("com.ibm.security.SAF.authorization")) == null || safAuthzEnabled.equals("")) {
            safAuthzEnabled = "false";
        }
        if (safAuthzEnabled.equalsIgnoreCase("true")) {
            this.setProperty("com.ibm.websphere.security.authorizationTable", "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl");
            String safRoleMapperClassName = this.getProperty("com.ibm.websphere.security.SAF.RoleMapper");
            if (safRoleMapperClassName != null && !safRoleMapperClassName.equals("")) {
                safRoleMapperClassName = "com.ibm.ws.security.zOS.authz.SAFRoleMapperImpl";
            }
            this.setString("com.ibm.websphere.security.SAF.RoleMapper", safRoleMapperClassName);
            String safDelegationEnabled = this.getProperty("com.ibm.security.SAF.delegation");
            if (safDelegationEnabled == null || safDelegationEnabled.equals("")) {
                safDelegationEnabled = "false";
            }
            if (safDelegationEnabled.equalsIgnoreCase("true")) {
                this.setString("com.ibm.CORBA.delegateCredentials", "saf");
            }
        } else {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting delegation policy to null and removing pluggable authz prop");
            }
            this.setString("com.ibm.CORBA.delegateCredentials", "methoddefined");
            this.props.remove("com.ibm.websphere.security.authorizationTable");
        }
        String safUnauthenticatedId = this.getProperty("com.ibm.security.SAF.unauthenticated");
        if (safUnauthenticatedId == null || safUnauthenticatedId.equals("")) {
            safUnauthenticatedId = "WSGUEST";
        }
        this.setString("com.ibm.security.SAF.unauthenticated", safUnauthenticatedId);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialization_zOS " + this.cacheKey);
        }
    }

    private void initialization_domain() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialization_domain " + this.cacheKey);
        }
        SecurityConfig admin_security = SecurityObjectLocator.getSecurityConfig("security");
        if (this.isSet("enabled")) {
            Tr.warning(tc, "Attribute [enabled] is not valid for domains");
        }
        this.setBoolean("enabled", admin_security.getBoolean("enabled"));
        if (!this.isSet("appEnabled")) {
            this.setBoolean("appEnabled", admin_security.getBoolean("appEnabled"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: appEnabled");
            }
        }
        if (!this.isSet("useDomainQualifiedUserNames")) {
            this.setBoolean("useDomainQualifiedUserNames", admin_security.getBoolean("useDomainQualifiedUserNames"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: useDomainQualifiedUserNames");
            }
        }
        if (!this.isSet("cacheTimeout")) {
            this.setInteger("cacheTimeout", admin_security.getInteger("cacheTimeout"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: cacheTimeout");
            }
        }
        if (!this.isSet("issuePermissionsWarning")) {
            this.setBoolean("issuePermissionsWarning", admin_security.getBoolean("issuePermissionsWarning"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: issuePermissionsWarning");
            }
        }
        if (!this.isSet("enforceJava2Security")) {
            this.setBoolean("enforceJava2Security", admin_security.getBoolean("enforceJava2Security"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: enforceJava2Security");
            }
        }
        if (!this.isSet("enforceFineGrainedJCASecurity")) {
            this.setBoolean("enforceFineGrainedJCASecurity", admin_security.getBoolean("enforceFineGrainedJCASecurity"));
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Using cell attribute: enforceFineGrainedJCASecurity");
            }
        }
        if (this.isSet("dynamicallyUpdateSSLConfig")) {
            Tr.warning(tc, "Attribute [dynamicallyUpdateSSLConfig] is not valid for domains");
        }
        this.setBoolean("dynamicallyUpdateSSLConfig", admin_security.getBoolean("dynamicallyUpdateSSLConfig"));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialization_domain " + this.cacheKey);
        }
    }

    private void initialization() {
        String failOverToBasicAuth;
        SecurityConfigObjectList webAuthAttrsList = this.sco.getObjectList("webAuthAttrs");
        String webAuthReq = System.getProperty("com.ibm.wsspi.security.web.webAuthReq");
        if (webAuthReq == null && webAuthAttrsList != null) {
            webAuthReq = this.getDescriptiveProperties(webAuthAttrsList, "com.ibm.wsspi.security.web.webAuthReq");
        }
        if (webAuthReq != null) {
            this.setString("com.ibm.wsspi.security.web.webAuthReq", webAuthReq);
        }
        if ((failOverToBasicAuth = System.getProperty("com.ibm.wsspi.security.web.failOverToBasicAuth")) == null && webAuthAttrsList != null) {
            failOverToBasicAuth = this.getDescriptiveProperties(webAuthAttrsList, "com.ibm.wsspi.security.web.failOverToBasicAuth");
        }
        if (failOverToBasicAuth != null) {
            this.setBoolean("com.ibm.wsspi.security.web.failOverToBasicAuth", Boolean.valueOf(failOverToBasicAuth));
        }
        if (this.sco.isDomainConfig() && !scm.isAdminAgent()) {
            this.initialization_domain();
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this.initialization_zOS();
        }
    }

    private Object returnOnlyIfValidInheritance(Object obj, char state, boolean inherit) {
        Object ret = inherit ? obj : (!inherit && (state & INHERITED) == INHERITED ? null : obj);
        return ret;
    }

    private synchronized List<AuthMechanismConfig> do_getAuthMechanisms() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "do_getAuthMechanisms");
        }
        if (this.authMechanisms == null) {
            SecurityConfigObjectList scol;
            int i;
            int size;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "do_getAuthMechanisms building list of authMechs");
            }
            this.authMechanisms = new LinkedList<AuthMechanismConfig>();
            if (this.sco.isDomainConfig() && !scm.isAdminAgent()) {
                List<AuthMechanismConfig> adminMechs = SecurityObjectLocator.getSecurityConfig("security").getAuthMechanisms();
                size = adminMechs.size();
                for (i = 0; i < size; ++i) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "do_getAuthMechanisms inheriting authMech from admin config", (AuthMechanismConfigImpl)adminMechs.get(i));
                    }
                    this.authMechanisms.add((AuthMechanismConfigImpl)adminMechs.get(i));
                }
            }
            if ((scol = this.sco.getObjectList(AUTH_MECHANISMS, false)) != null) {
                size = scol.size();
                for (i = 0; i < size; ++i) {
                    SecurityConfigObject scoMech = scol.get(i);
                    if (!scol.isDomainConfig() || scm.isAdminAgent() || scoMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LTPA") || scoMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO") || scoMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "KRB5")) {
                        AuthMechanismConfigImpl authMech = null;
                        if (scol.isDomainConfig() && !scm.isAdminAgent() && scoMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LTPA")) {
                            AuthMechanismConfigImpl adminLTPA = (AuthMechanismConfigImpl)SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("LTPA");
                            authMech = new AuthMechanismConfigImpl(adminLTPA.getSCO(), scoMech, this, this.cacheKey);
                        } else {
                            authMech = new AuthMechanismConfigImpl(scoMech, this, this.cacheKey);
                        }
                        boolean replaced = false;
                        if (this.sco.isDomainConfig()) {
                            int sizej = this.authMechanisms.size();
                            for (int j = 0; j < sizej; ++j) {
                                AuthMechanismConfig currentAuthMech = this.authMechanisms.get(j);
                                if (!currentAuthMech.getSCO().isAdminConfig() || !authMech.getType().equals(currentAuthMech.getType())) continue;
                                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "do_getAuthMechanisms replacing admin authMech with domain authMech", new Object[]{currentAuthMech, authMech});
                                }
                                this.authMechanisms.set(j, authMech);
                                replaced = true;
                            }
                        }
                        if (replaced) continue;
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "do_getAuthMechanisms adding authMech: " + authMech);
                        }
                        this.authMechanisms.add(authMech);
                        continue;
                    }
                    if (!SecurityConfigGlobals.enableVerbose || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "do_getAuthMechanisms ignoring authMech: " + scoMech);
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "do_getAuthMechanisms", this.authMechanisms);
        }
        return this.authMechanisms;
    }

    @Override
    public List<AuthMechanismConfig> getAuthMechanisms() {
        return this.getAuthMechanisms(true);
    }

    @Override
    public List<AuthMechanismConfig> getAuthMechanisms(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechanisms " + this.cacheKey, inherit);
        }
        List<AuthMechanismConfig> ret = null;
        if (this.authMechanisms == null) {
            ret = this.do_getAuthMechanisms();
        }
        if (this.authMechanisms != null) {
            if (inherit || this.sco.isAdminConfig() || scm.isAdminAgent()) {
                ret = this.authMechanisms;
            } else {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthMechanisms inherit=false returning only domain authMechs");
                }
                ret = new LinkedList<AuthMechanismConfig>();
                int size = this.authMechanisms.size();
                for (int i = 0; i < size; ++i) {
                    AuthMechanismConfig currentAuthMech = this.authMechanisms.get(i);
                    if (!currentAuthMech.getSCO().isDomainConfig()) continue;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "do_getAuthMechanisms inherit=false returning domain authMech: " + currentAuthMech);
                    }
                    ret.add(currentAuthMech);
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechanisms " + this.cacheKey, ret);
        }
        return ret;
    }

    @Override
    public AuthMechanismConfig getAuthMechanism(String type) {
        return this.getAuthMechanism(type, true);
    }

    @Override
    public AuthMechanismConfig getAuthMechanism(String type, boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechanism " + this.cacheKey, new Object[]{type, inherit});
        }
        AuthMechanismConfig amc = this.getAuthMechFromList(type, this.getAuthMechanisms(true));
        if (!inherit && amc != null && this.sco.isDomainConfig() && amc.getSCO().isAdminConfig()) {
            amc = null;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechanism " + this.cacheKey, amc);
        }
        return amc;
    }

    private AuthMechanismConfig getAuthMechFromList(String type, List<AuthMechanismConfig> list) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechFromList " + this.cacheKey, new Object[]{type, list});
        }
        AuthMechanismConfig amc = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getType().equals(type)) continue;
                amc = list.get(i);
                break;
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechFromList " + this.cacheKey, amc);
        }
        return amc;
    }

    private synchronized AuthMechanismConfig do_getActiveAuthMechanism(boolean inherit) {
        Object ret = null;
        if (this.state_activeAuthMech == UNCHECKED) {
            SecurityConfigObject am = this.sco.getObject(ACTIVE_AUTH_MECHANISM, true);
            this.state_activeAuthMech = (char)(this.state_activeAuthMech | CHECKED);
            if (am != null) {
                if (am.isAdminConfig() && this.sco.isDomainConfig()) {
                    this.state_activeAuthMech = (char)(this.state_activeAuthMech | INHERITED);
                }
                this.activeAuthMech = new AuthMechanismConfigImpl(am, this, this.cacheKey);
                ret = !inherit && (this.state_activeAuthMech & INHERITED) == INHERITED ? null : this.activeAuthMech;
            }
        } else {
            ret = inherit ? this.activeAuthMech : (!inherit && (this.state_activeAuthMech & INHERITED) == INHERITED ? null : this.activeAuthMech);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_activeAuthMech=" + this.state_activeAuthMech);
        }
        return ret;
    }

    @Override
    public AuthMechanismConfig getActiveAuthMechanism() {
        return this.getActiveAuthMechanism(true);
    }

    @Override
    public AuthMechanismConfig getActiveAuthMechanism(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveAuthMechanism " + this.cacheKey, inherit);
        }
        Object ret = null;
        ret = this.state_activeAuthMech == UNCHECKED ? this.do_getActiveAuthMechanism(inherit) : (inherit ? this.activeAuthMech : (!inherit && (this.state_activeAuthMech & INHERITED) == INHERITED ? null : this.activeAuthMech));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveAuthMechanism " + this.cacheKey, ret);
        }
        return ret;
    }

    private synchronized void do_getAdminPreferredAuthMechanism() {
        if (this.adminPreferredAuthMech == null) {
            SecurityConfigObject am = this.sco.getObject("adminPreferredAuthMech", true);
            if (am != null) {
                this.adminPreferredAuthMech = new AuthMechanismConfigImpl(am, this, this.cacheKey);
            } else {
                am = this.sco.getObject(ACTIVE_AUTH_MECHANISM, true);
                if (am != null) {
                    this.adminPreferredAuthMech = new AuthMechanismConfigImpl(am, this, this.cacheKey);
                }
            }
        }
    }

    @Override
    public AuthMechanismConfig getAdminPreferredAuthMechanism() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminPreferredAuthMechanism " + this.cacheKey);
        }
        if (this.adminPreferredAuthMech == null) {
            this.do_getAdminPreferredAuthMechanism();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminPreferredAuthMechanism " + this.cacheKey, this.adminPreferredAuthMech);
        }
        return this.adminPreferredAuthMech;
    }

    @Override
    public void setAuthMechanism(AuthMechanismConfig authMechCfg) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthMechanism " + this.cacheKey, authMechCfg);
        }
        if (this.authMechanisms == null) {
            this.getAuthMechanisms();
        }
        boolean replaced = false;
        for (int i = 0; i < this.authMechanisms.size(); ++i) {
            if (!this.authMechanisms.get(i).getType().equals(authMechCfg.getType())) continue;
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "setAuthMechanism replacing existing auth mech in list");
            }
            this.authMechanisms.set(i, authMechCfg);
            replaced = true;
            break;
        }
        if (!replaced) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "setAuthMechanism adding auth mech to list");
            }
            this.authMechanisms.add(authMechCfg);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthMechanism " + this.cacheKey);
        }
    }

    @Override
    public void refreshSPNEGOAuthMechanism() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshSPNEGOAuthMechanism " + this.cacheKey);
        }
        String scope = this.sco.isDomainConfig() ? "AppSecurity" : "security";
        scm.refreshSPNEGOAuthMechanism(scope);
        if (this.sco.isDomainConfig()) {
            this.authMechanisms = null;
            this.do_getAuthMechanisms();
        } else {
            Iterator<AuthMechanismConfig> iter = this.authMechanisms.iterator();
            while (iter.hasNext()) {
                AuthMechanismConfig mech = iter.next();
                if (!mech.getType().equals("SPNEGO") && !mech.getType().equals("KRB5")) continue;
                iter.remove();
            }
            SecurityConfigObjectList scol = this.sco.getObjectList(AUTH_MECHANISMS, false);
            if (scol != null) {
                int size = scol.size();
                for (int i = 0; i < size; ++i) {
                    SecurityConfigObject sco = scol.get(i);
                    if (!sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO") && !sco.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "KRB5")) continue;
                    this.authMechanisms.add(new AuthMechanismConfigImpl(sco, this, this.cacheKey));
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthMechanism " + this.cacheKey);
        }
    }

    private synchronized TrustAssociationConfig do_getTrustAssociation(String type, boolean inherit) {
        TrustAssociationConfig ret = null;
        if (this.state_tai == UNCHECKED) {
            SecurityConfigObject ta;
            AuthMechanismConfigImpl am;
            SecurityConfigObjectList scol;
            if (this.sco.isDomainConfig() && !scm.isAdminAgent() && (scol = this.sco.getObjectList(AUTH_MECHANISMS, false)) != null) {
                int size = scol.size();
                for (int i = 0; i < size; ++i) {
                    SecurityConfigObject ta2;
                    SecurityConfigObject scoMech = scol.get(i);
                    if (!scoMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "LTPA") || (ta2 = scoMech.getObject(TRUST_ASSOCIATION, false)) == null) continue;
                    this.tai = new TrustAssociationConfigImpl(ta2, this, this.cacheKey);
                    if (!SecurityConfigGlobals.enableVerbose || !tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "trustAssociation found at the domain level");
                }
            }
            if (this.tai == null && (am = (AuthMechanismConfigImpl)this.getAuthMechanism(type, inherit)) != null && (ta = am.getSCO().getObject(TRUST_ASSOCIATION, false)) != null) {
                this.tai = new TrustAssociationConfigImpl(ta, this, this.cacheKey);
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.debug(tc, "trustAssociation found at the global level");
                }
                if (ta.isAdminConfig() && this.sco.isDomainConfig()) {
                    this.state_tai = (char)(this.state_tai | INHERITED);
                }
            }
            this.state_tai = (char)(this.state_tai | CHECKED);
            ret = (TrustAssociationConfig)this.returnOnlyIfValidInheritance(this.tai, this.state_tai, inherit);
        } else {
            ret = (TrustAssociationConfig)this.returnOnlyIfValidInheritance(this.tai, this.state_tai, inherit);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_tai=" + this.state_tai);
        }
        return ret;
    }

    @Override
    public TrustAssociationConfig getTrustAssociation() {
        return this.getTrustAssociation("LTPA", true);
    }

    @Override
    public TrustAssociationConfig getTrustAssociation(String authMechanismType) {
        return this.getTrustAssociation(authMechanismType, true);
    }

    @Override
    public TrustAssociationConfig getTrustAssociation(String type, boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAssociation " + this.cacheKey, new Object[]{type, inherit});
        }
        TrustAssociationConfig ret = null;
        ret = this.state_tai == UNCHECKED || !type.equals("LTPA") ? this.do_getTrustAssociation(type, inherit) : (TrustAssociationConfig)this.returnOnlyIfValidInheritance(this.tai, this.state_tai, inherit);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAssociation " + this.cacheKey, ret);
        }
        return ret;
    }

    private synchronized List<UserRegistryConfig> do_getUserRegistries(boolean inherit) {
        Object ret = null;
        if (this.state_userRegistries == UNCHECKED) {
            SecurityConfigObjectList scol = this.sco.getObjectList(USER_REGISTRIES, true);
            this.state_userRegistries = (char)(this.state_userRegistries | CHECKED);
            if (scol != null) {
                if (!scol.isDomainConfig() && this.sco.isDomainConfig()) {
                    this.state_userRegistries = (char)(this.state_userRegistries | INHERITED);
                }
                int size = scol.size();
                this.userRegistries = new LinkedList<UserRegistryConfig>();
                for (int i = 0; i < size; ++i) {
                    this.userRegistries.add(new UserRegistryConfigImpl(scol.get(i), this, this.cacheKey));
                }
                ret = !inherit && (this.state_userRegistries & INHERITED) == INHERITED ? null : this.userRegistries;
            }
        } else {
            ret = inherit ? this.userRegistries : (!inherit && (this.state_userRegistries & INHERITED) == INHERITED ? null : this.userRegistries);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_userRegistries=" + this.state_userRegistries);
        }
        return ret;
    }

    @Override
    public List<UserRegistryConfig> getUserRegistries() {
        return this.getUserRegistries(true);
    }

    @Override
    public List<UserRegistryConfig> getUserRegistries(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistries " + this.cacheKey, inherit);
        }
        Object ret = null;
        ret = this.state_userRegistries == UNCHECKED ? this.do_getUserRegistries(inherit) : (inherit ? this.userRegistries : (!inherit && (this.state_userRegistries & INHERITED) == INHERITED ? null : this.userRegistries));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserRegistries" + this.cacheKey, ret);
        }
        return ret;
    }

    @Override
    public UserRegistryConfig getUserRegistry(String type) {
        return this.getUserRegistry(type, true);
    }

    @Override
    public UserRegistryConfig getUserRegistry(String type, boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistry " + this.cacheKey, new Object[]{type, inherit});
        }
        UserRegistryConfig ur = null;
        List<UserRegistryConfig> list = this.getUserRegistries(inherit);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getType().equals(type)) continue;
                ur = list.get(i);
                break;
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserRegistry " + this.cacheKey, ur);
        }
        return ur;
    }

    private synchronized UserRegistryConfig do_getActiveUserRegistry(boolean inherit) {
        Object ret = null;
        if (this.state_activeUserReg == UNCHECKED) {
            SecurityConfigObject ur = this.sco.getObject(ACTIVE_USER_REGISTRY, true);
            this.state_activeUserReg = (char)(this.state_activeUserReg | CHECKED);
            if (ur != null) {
                if (ur.isAdminConfig() && this.sco.isDomainConfig()) {
                    this.state_activeUserReg = (char)(this.state_activeUserReg | INHERITED);
                }
                if (this.activeUserReg == null) {
                    this.activeUserReg = new UserRegistryConfigImpl(ur, this, this.cacheKey);
                }
                ret = !inherit && (this.state_activeUserReg & INHERITED) == INHERITED ? null : this.activeUserReg;
            }
        } else {
            ret = inherit ? this.activeUserReg : (!inherit && (this.state_activeUserReg & INHERITED) == INHERITED ? null : this.activeUserReg);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_activeUserReg=" + this.state_activeUserReg);
        }
        return ret;
    }

    @Override
    public UserRegistryConfig getActiveUserRegistry() {
        return this.getActiveUserRegistry(true);
    }

    @Override
    public UserRegistryConfig getActiveUserRegistry(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveUserRegistry " + this.cacheKey, inherit);
        }
        Object ret = null;
        ret = this.state_activeUserReg == UNCHECKED ? this.do_getActiveUserRegistry(inherit) : (inherit ? this.activeUserReg : (!inherit && (this.state_activeUserReg & INHERITED) == INHERITED ? null : this.activeUserReg));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveUserRegistry " + this.cacheKey, ret);
        }
        return ret;
    }

    protected synchronized AuthorizationConfig setAuthorizationConfig(AuthorizationConfig _authzConfig) {
        boolean isDomainScope = this.sco.isDomainConfig();
        boolean isDomainAuthzConfig = _authzConfig.getSCO().isDomainConfig();
        if (isDomainScope && !isDomainAuthzConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting AuthorizationConfig for domain scope using global configuration");
            }
        } else if (!isDomainScope && isDomainAuthzConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting AuthorizationConfig for global scope using domain configuration");
            }
        } else {
            throw new IllegalStateException("Trying to set AuthorizationConfig for a scope using configuration from that scope. isDomainAuthzConfig=" + isDomainAuthzConfig);
        }
        this.state_authzConfig = CHECKED;
        this.authzConfig = _authzConfig;
        return _authzConfig;
    }

    private synchronized AuthorizationConfig do_getAuthorizationConfig(boolean inherit) {
        Object ret = null;
        if (this.state_authzConfig == UNCHECKED) {
            SecurityConfig global;
            AuthorizationConfig globalAuthz;
            SecurityConfigObject ac = this.sco.getObject(AUTHORIZATION_CONFIG, inherit);
            this.state_authzConfig = (char)(this.state_authzConfig | CHECKED);
            if (ac != null) {
                if (ac.isAdminConfig() && this.sco.isDomainConfig()) {
                    this.state_authzConfig = (char)(this.state_authzConfig | INHERITED);
                }
                this.authzConfig = new AuthorizationConfigImpl(ac, this, this.cacheKey);
                ret = !inherit && (this.state_authzConfig & INHERITED) == INHERITED ? null : this.authzConfig;
                if (this.sco.isDomainConfig() && (this.state_authzConfig & INHERITED) != INHERITED && this.authzConfig != null) {
                    SecurityConfigImpl global2 = (SecurityConfigImpl)SecurityObjectLocator.getSecurityConfig("security");
                    global2.setAuthorizationConfig(this.authzConfig);
                }
            } else if (this.sco.isDomainConfig() && (globalAuthz = (global = SecurityObjectLocator.getSecurityConfig("security")).getAuthorizationConfig()) != null) {
                ret = this.setAuthorizationConfig(globalAuthz);
            }
        } else {
            ret = inherit ? this.authzConfig : (!inherit && (this.state_authzConfig & INHERITED) == INHERITED ? null : this.authzConfig);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_authzConfig=" + this.state_authzConfig);
        }
        return ret;
    }

    @Override
    public AuthorizationConfig getAuthorizationConfig() {
        return this.getAuthorizationConfig(true);
    }

    @Override
    public AuthorizationConfig getAuthorizationConfig(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationConfig " + this.cacheKey, inherit);
        }
        Object ret = null;
        ret = this.state_authzConfig == UNCHECKED ? this.do_getAuthorizationConfig(inherit) : (inherit ? this.authzConfig : (!inherit && (this.state_authzConfig & INHERITED) == INHERITED ? null : this.authzConfig));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationConfig " + this.cacheKey, ret);
        }
        return ret;
    }

    private synchronized void do_getJAASLoginConfig() {
        if (this.loginConfig == null) {
            this.loginConfig = new JAASLoginConfigImpl(this.sco, this.cacheKey);
        }
    }

    @Override
    public JAASLoginConfig getJAASLoginConfig() {
        return this.getJAASLoginConfig(true);
    }

    @Override
    public JAASLoginConfig getJAASLoginConfig(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getJAASLoginConfig " + this.cacheKey, inherit);
        }
        if (this.loginConfig == null) {
            this.do_getJAASLoginConfig();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getJAASLoginConfig " + this.cacheKey, this.loginConfig);
        }
        return this.loginConfig;
    }

    @Override
    public CSIv2Config getCSIv2Config() {
        return this.getCSIv2Config(true);
    }

    @Override
    public CSIv2Config getCSIv2Config(boolean inherit) {
        CSIv2ConfigData tmp = this.getCSIv2Data(inherit);
        if (tmp == null) {
            return null;
        }
        return SecurityObjectLocator.getCSIv2Config();
    }

    private synchronized CSIv2ConfigData do_getCSIv2Data(boolean inherit) {
        Object ret = null;
        if (this.state_csiv2Data == UNCHECKED) {
            SecurityConfigObject csi = this.sco.getObject(CSIv2, true);
            this.state_csiv2Data = (char)(this.state_csiv2Data | CHECKED);
            if (csi != null) {
                if (csi.isAdminConfig() && this.sco.isDomainConfig()) {
                    this.state_csiv2Data = (char)(this.state_csiv2Data | INHERITED);
                }
                this.csiv2Data = new CSIv2ConfigData(csi, this, this.cacheKey);
                ret = !inherit && (this.state_csiv2Data & INHERITED) == INHERITED ? null : this.csiv2Data;
            }
        } else {
            ret = inherit ? this.csiv2Data : (!inherit && (this.state_csiv2Data & INHERITED) == INHERITED ? null : this.csiv2Data);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_csiv2Data=" + this.state_csiv2Data);
        }
        return ret;
    }

    public CSIv2ConfigData getCSIv2Data() {
        return this.getCSIv2Data(true);
    }

    public CSIv2ConfigData getCSIv2Data(boolean inherit) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2Data " + this.cacheKey, inherit);
        }
        Object ret = null;
        ret = this.state_csiv2Data == UNCHECKED ? this.do_getCSIv2Data(inherit) : (inherit ? this.csiv2Data : (!inherit && (this.state_csiv2Data & INHERITED) == INHERITED ? null : this.csiv2Data));
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2Data " + this.cacheKey, ret);
        }
        return ret;
    }

    private synchronized TrustedAuthenticationRealm do_getInboundTrustedAuthenticationRealm() {
        TrustedAuthenticationRealm ret = null;
        if (this.state_inboundTrustedAuthenticationRealm == UNCHECKED) {
            SecurityConfigObject inbound = this.sco.getObject(INBOUND_TRUSTED_AUTHENTICATION_REALM, false);
            this.state_inboundTrustedAuthenticationRealm = (char)(this.state_inboundTrustedAuthenticationRealm | CHECKED);
            ret = this.inboundTrustedAuthenticationRealm = new TrustedAuthenticationRealm(false, inbound, this, this.cacheKey);
        } else {
            ret = this.inboundTrustedAuthenticationRealm;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_inboundTrustedAuthenticationRealm=" + this.state_inboundTrustedAuthenticationRealm);
        }
        return ret;
    }

    @Override
    public TrustedAuthenticationRealm getInboundTrustedAuthenticationRealm() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundTrustedAuthenticationRealm " + this.cacheKey);
        }
        TrustedAuthenticationRealm ret = null;
        ret = this.state_inboundTrustedAuthenticationRealm == UNCHECKED ? this.do_getInboundTrustedAuthenticationRealm() : this.inboundTrustedAuthenticationRealm;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundTrustedAuthenticationRealm " + this.cacheKey, ret);
        }
        return ret;
    }

    private synchronized TrustedAuthenticationRealm do_getOutboundTrustedAuthenticationRealm() {
        TrustedAuthenticationRealm ret = null;
        if (this.state_outboundTrustedAuthenticationRealm == UNCHECKED) {
            SecurityConfigObject outbound = this.sco.getObject(OUTBOUND_TRUSTED_AUTHENTICATION_REALM, false);
            this.state_outboundTrustedAuthenticationRealm = (char)(this.state_outboundTrustedAuthenticationRealm | CHECKED);
            ret = this.outboundTrustedAuthenticationRealm = new TrustedAuthenticationRealm(true, outbound, this, this.cacheKey);
        } else {
            ret = this.outboundTrustedAuthenticationRealm;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "state_outboundTrustedAuthenticationRealm=" + this.state_outboundTrustedAuthenticationRealm);
        }
        return ret;
    }

    @Override
    public TrustedAuthenticationRealm getOutboundTrustedAuthenticationRealm() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundTrustedAuthenticationRealm " + this.cacheKey);
        }
        TrustedAuthenticationRealm ret = null;
        ret = this.state_outboundTrustedAuthenticationRealm == UNCHECKED ? this.do_getOutboundTrustedAuthenticationRealm() : this.outboundTrustedAuthenticationRealm;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundTrustedAuthenticationRealm " + this.cacheKey, ret);
        }
        return ret;
    }

    @Override
    public boolean isPropertySet(String key, boolean localOnly) {
        if (!localOnly) {
            return this.props.containsKey(key);
        }
        return this.sco.getProperties().containsKey(key);
    }

    private synchronized void do_getProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "do_getProperties " + this.cacheKey);
        }
        if (this.props == null) {
            Properties myProps = this.sco.getProperties();
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "Properties defined for this SCO:" + myProps);
            }
            if (this.sco.isDomainConfig() && !scm.isAdminAgent()) {
                Properties parentProps = SecurityObjectLocator.getSecurityConfig("security").getProperties();
                if (parentProps != null) {
                    Properties cleanProps = new Properties();
                    cleanProps.putAll((Map<?, ?>)parentProps);
                    Properties domainProps = this.sco.getProperties(false);
                    if (domainProps == null || !domainProps.containsKey("com.ibm.CSI.supportedTargetRealms")) {
                        cleanProps.remove("com.ibm.CSI.supportedTargetRealms");
                        myProps.remove("com.ibm.CSI.supportedTargetRealms");
                    }
                    cleanProps.putAll((Map<?, ?>)myProps);
                    this.props = cleanProps;
                } else {
                    this.props = myProps;
                }
                SecurityConfigImpl globalSecCfg = (SecurityConfigImpl)SecurityObjectLocator.getSecurityConfig("Security");
                if (this.props.containsKey("was.security.EnableSyncToOSThread")) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Overriding global level property was.security.EnableSyncToOSThread with the value at the domain level: " + (String)this.props.get("was.security.EnableSyncToOSThread"));
                    }
                    globalSecCfg.setProperty("was.security.EnableSyncToOSThread", (String)this.props.get("was.security.EnableSyncToOSThread"));
                }
                if (this.props.containsKey("was.security.EnableRunAsIdentity")) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Overriding global level property was.security.EnableRunAsIdentity with the value at the domain level: " + (String)this.props.get("was.security.EnableRunAsIdentity"));
                    }
                    globalSecCfg.setProperty("was.security.EnableRunAsIdentity", (String)this.props.get("was.security.EnableRunAsIdentity"));
                }
            } else {
                this.props = myProps;
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                this.dumpProperties();
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "do_getProperties " + this.cacheKey);
        }
    }

    @Override
    public Properties getProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties " + this.cacheKey);
        }
        if (this.props == null) {
            this.do_getProperties();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties " + this.cacheKey, this.props);
        }
        return this.props;
    }

    private String getDefaultProp(String key) {
        if (!this.defaultProps.containsKey(key)) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Default property value for key [" + key + "] in SCO [" + this.sco.toString() + "] is not defined " + this.cacheKey);
            }
            return null;
        }
        return this.defaultProps.get(key);
    }

    @Override
    public String getProperty(String key) {
        String val;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty key=" + key + " " + this.cacheKey);
        }
        if ((val = this.propsCache.get(key)) == null) {
            val = System.getProperty(key, null);
            if (val == null) {
                if (this.props == null) {
                    this.getProperties();
                }
                if (this.props == null) {
                    val = this.getDefaultProp(key);
                } else {
                    val = (String)this.props.get(key);
                    if (val == null) {
                        val = this.getDefaultProp(key);
                    }
                }
            }
            if (val != null) {
                this.propsCache.put(key, val);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty key=" + key + " " + this.cacheKey, val);
        }
        return val;
    }

    @Override
    public boolean getPropertyBool(String id) {
        return this.getPropertyBool(id, false);
    }

    @Override
    public boolean getPropertyBool(String id, boolean defaultValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyBool id=" + id + " default=" + defaultValue + " " + this.cacheKey);
        }
        Boolean val = null;
        if (this._performTAIForUnprotectedURI != null && id.equals("com.ibm.websphere.security.performTAIForUnprotectedURI")) {
            val = this._performTAIForUnprotectedURI;
        } else {
            val = this.boolPropsCache.get(id);
            if (val == null) {
                String bool_str = this.getProperty(id);
                val = bool_str == null ? Boolean.valueOf(defaultValue) : Boolean.valueOf(bool_str);
                this.boolPropsCache.put(id, val);
                if (id.equals("com.ibm.websphere.security.performTAIForUnprotectedURI")) {
                    this._performTAIForUnprotectedURI = val;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyBool id=" + id + " " + this.cacheKey + " val=" + val);
        }
        return val;
    }

    void setProperty(String key, String value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty key=" + key + " value=" + value + " " + this.cacheKey);
        }
        if (key != null && value != null) {
            if (this.props == null) {
                this.getProperties();
            }
            if (this.props != null) {
                this.props.put(key, value);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to set proprety key=" + key + " because property table is NULL");
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty key=" + key + " value=" + value + " " + this.cacheKey);
        }
    }

    @Override
    public Object getObject(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject: key=" + key + this.cacheKey);
        }
        Object result = !this.sco.isAdminConfig() && key.equals("process.jmxConnectorProps") ? SecurityObjectLocator.getSecurityConfig("security").getObject(key) : super.getObject(key);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject" + this.cacheKey, result);
        }
        return result;
    }

    @Override
    public String getDomain() {
        String domain = scm.getDomain();
        if (domain == null) {
            return "global";
        }
        return domain;
    }

    public void dumpProperties() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpProperties() " + this.cacheKey);
        }
        StringBuffer buf = new StringBuffer();
        if (this.props != null && this.props.size() > 0) {
            buf.append("Properties: {\n");
            for (String string : this.props.keySet()) {
                String value = this.props.getProperty(string);
                if (string.toLowerCase().indexOf("password") != -1) {
                    buf.append(string);
                    buf.append(" = ");
                    buf.append(ConfigUtils.mask(value));
                    buf.append("\n");
                    continue;
                }
                buf.append(string);
                buf.append(" = ");
                buf.append(value);
                buf.append("\n");
            }
            buf.append("}");
        }
        if (this.defaultProps != null && this.defaultProps.size() > 0) {
            buf.append("\nDefaults:\n");
            buf.append(this.defaultProps.toString());
            buf.append("\n");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, buf.toString());
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpProperties() " + this.cacheKey);
        }
    }

    @Override
    public String getSAFProfilePrefix() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSAFProfilePrefix");
        }
        String profilePrefix = null;
        if (this.isPropertySet("security.zOS.domainType", true) && this.isPropertySet("security.zOS.domainName", true)) {
            if ("cellQualified".equalsIgnoreCase(this.getProperty("security.zOS.domainType")) && this.getProperty("security.zOS.domainName").length() > 0) {
                profilePrefix = this.getProperty("security.zOS.domainName");
            }
        } else if (this.isPropertySet("com.ibm.security.SAF.profilePrefix", true) && "com.ibm.security.SAF.profilePrefix".length() > 0) {
            profilePrefix = this.getProperty("com.ibm.security.SAF.profilePrefix");
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSAFProfilePrefix: " + profilePrefix);
        }
        return profilePrefix;
    }
}

