/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.AuthorizationConfig;
import com.ibm.ws.security.config.AuthorizationProviderConfig;
import com.ibm.ws.security.config.AuthorizationProviderConfigImpl;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationConfigImpl
extends GenericConfigHelperImpl
implements AuthorizationConfig {
    private static final String AUTHORIZATION_PROVIDERS = "authorizationProviders";
    private static TraceComponent tc = Tr.register(AuthorizationConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private List<AuthorizationProviderConfig> authzProviders = null;
    private boolean useJaccProvider = false;
    private boolean isSet_useJaccProvider = false;

    public AuthorizationConfigImpl(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("useJACCProvider", Boolean.FALSE);
    }

    @Override
    public AuthorizationProviderConfig getAuthorizationProvider() {
        return this.getAuthorizationProviders().get(0);
    }

    private synchronized void do_getAuthorizationProviders() {
        if (this.authzProviders == null) {
            SecurityConfigObjectList scol = this.sco.getObjectList(AUTHORIZATION_PROVIDERS);
            int size = scol.size();
            this.authzProviders = new LinkedList<AuthorizationProviderConfig>();
            for (int i = 0; i < size; ++i) {
                this.authzProviders.add(new AuthorizationProviderConfigImpl(scol.get(i), this, this.cacheKey));
            }
        }
    }

    @Override
    public List<AuthorizationProviderConfig> getAuthorizationProviders() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationProviders" + this.cacheKey);
        }
        if (this.authzProviders == null) {
            this.do_getAuthorizationProviders();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationProviders" + this.cacheKey, this.authzProviders);
        }
        return this.authzProviders;
    }

    @Override
    public boolean getBoolean(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean() key=" + key + " " + this.cacheKey);
        }
        boolean returnValue = false;
        if (key == "useJACCProvider" || key.equals("useJACCProvider")) {
            if (this.isSet_useJaccProvider) {
                returnValue = this.useJaccProvider;
            } else {
                returnValue = this.useJaccProvider = super.getBoolean(key);
                this.isSet_useJaccProvider = true;
            }
        } else {
            returnValue = super.getBoolean(key);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean() " + this.cacheKey, returnValue);
        }
        return returnValue;
    }
}

