/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.profileregistry.ProfileRegistry;
import com.ibm.ws.management.profileregistry.ProfileRegistryFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.SecurityConfigComponentImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminDataImpl
implements AdminData {
    private static final TraceComponent tc = Tr.register(AdminDataImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private String cacheKey = null;
    private HashMap<String, Object> data = new HashMap();
    private String processType = null;
    private String processName = null;
    private String serverType = null;
    private String nodeName = null;
    private String[] nodeGroupNames = null;
    private String cellName = null;
    private String jvmType = null;
    private String clusterName = null;
    private String[] currentScopeNames = null;
    private String[] currentNodeGroupScopeNames = null;
    private String currentClusterScopeName = null;
    private String currentProcessScopeName = null;
    private String currentNodeScopeName = null;
    private String currentCellScopeName = null;
    private String configRootPath = null;
    private String userInstallRootPath = null;
    private String cellURI = null;
    private String nodesURI = null;
    private String clustersURI = null;
    private Repository repository = null;
    private boolean checked = false;
    private boolean setupInternalServerId = false;
    private static final String NODEGROUPHELPER_CLASS = "com.ibm.ws.management.commands.nodegroup.NodeGroupHelper";
    private static Class _nodeGroupHelperClass = null;
    private static Method _getNodeGroupMembersMethod = null;

    public AdminDataImpl(String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey);
        }
        this.cacheKey = _cacheKey;
        this.initialize_defaults();
        this.initialization();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor " + this.cacheKey);
        }
    }

    private void initialize_defaults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialization() {
        block31: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "initialization " + this.cacheKey);
            }
            try {
                String repositoryRoot = System.getProperty("was.repository.root");
                if (!RasHelper.isServer()) {
                    Tr.debug(tc, "On client");
                    this.processType = "client";
                    this.setString("com.ibm.ws.security.processType", this.processType);
                    this.processName = "client";
                    this.serverType = "client";
                    this.nodeName = "client";
                    this.setString("nodename", this.nodeName);
                    this.nodeGroupNames = new String[]{"client"};
                    this.cellName = "client";
                    this.setString("cellname", this.nodeName);
                    this.jvmType = "client";
                    this.clusterName = "client";
                    this.currentScopeNames = new String[]{"client"};
                    this.currentNodeGroupScopeNames = new String[]{"client"};
                    this.currentClusterScopeName = "client";
                    this.currentProcessScopeName = "client";
                    this.currentNodeScopeName = "client";
                    this.currentCellScopeName = "client";
                    if (repositoryRoot == null) {
                        repositoryRoot = System.getProperty("user.install.root") + File.separator + "config";
                    }
                    this.configRootPath = repositoryRoot;
                    this.cellURI = "client";
                    this.nodesURI = "client";
                    this.clustersURI = "client";
                    this.userInstallRootPath = System.getProperty("user.install.root");
                    this.setBoolean("isServerProcess", Boolean.FALSE);
                } else {
                    AdminService adminService;
                    block29: {
                        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                            Tr.debug(tc, "On server");
                        }
                        this.setBoolean("isServerProcess", Boolean.TRUE);
                        adminService = AdminServiceFactory.getAdminService();
                        String uuid = AdminContext.peek();
                        if (uuid != null) {
                            try {
                                ProfileRegistry pr = ProfileRegistryFactory.getRegistry();
                                Map profileData = pr.lookupProfile(uuid);
                                this.configRootPath = (String)profileData.get("profile.registry.profile.root") + "/config/";
                                this.userInstallRootPath = (String)profileData.get("profile.registry.profile.root");
                                this.processType = "UnManagedProcess";
                                this.setString("com.ibm.ws.security.processType", this.processType);
                                this.processName = "server1";
                                this.serverType = (String)profileData.get("profile.registry.profile.type");
                                this.setString("nodename", (String)profileData.get("profile.registry.node.name"));
                                String cellName = (String)profileData.get("profile.registry.cell.name");
                                this.setString("cellname", cellName);
                                this.setupInternalServerId = true;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException(e, AdminDataImpl.class.getName(), "176");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception getting profile data.", new Object[]{e});
                                }
                                break block29;
                            }
                        }
                        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
                        if (!scm.getDomainId().equalsIgnoreCase("admin")) {
                            String id = null;
                            boolean pop = SecurityObjectLocator.pushAdminContext();
                            try {
                                id = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                            }
                            catch (Exception e) {
                                FFDCFilter.processException(e, AdminDataImpl.class.getName(), "196");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception getting cell internal server id", e);
                                }
                            }
                            finally {
                                if (pop) {
                                    SecurityObjectLocator.popContext();
                                }
                            }
                            if (id != null) {
                                this.setString("com.ibm.ws.security.internalServerId", id);
                            }
                        }
                        if (repositoryRoot == null) {
                            repositoryRoot = System.getProperty("user.install.root") + File.separator + "config";
                        }
                        this.configRootPath = repositoryRoot;
                        this.processType = adminService.getProcessType();
                        this.setString("com.ibm.ws.security.processType", this.processType);
                        this.processName = adminService.getProcessName();
                        this.serverType = adminService.getServerType();
                        this.userInstallRootPath = System.getProperty("user.install.root");
                    }
                    this.nodeName = adminService.getNodeName();
                    this.setString("nodename", this.nodeName);
                    this.cellName = adminService.getCellName();
                    this.setString("cellname", this.cellName);
                    this.jvmType = adminService.getJvmType();
                    this.clusterName = this.getClusterNameFromConfig();
                    this.cellURI = "cells/" + this.cellName + "/";
                    this.nodesURI = "cells/" + this.cellName + "/nodes/";
                    this.clustersURI = "cells/" + this.cellName + "/clusters/";
                    this.nodeGroupNames = this.getCurrentNodeGroupNames(this.nodeName);
                    this.currentScopeNames = this.formCurrentFullScopeNames();
                    this.currentNodeGroupScopeNames = this.formNodeGroupScopes(this.nodeGroupNames);
                    this.currentProcessScopeName = this.formProcessScope();
                    this.currentNodeScopeName = this.formNodeScope();
                    this.currentCellScopeName = this.formCellScope();
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("CurrentProcessData:\njvm type: ");
                    sb.append(this.jvmType);
                    sb.append("\nconfigRootPath: ");
                    sb.append(this.configRootPath);
                    sb.append("\nuserInstallRootPath: ");
                    sb.append(this.userInstallRootPath);
                    sb.append("\ncellURI: ");
                    sb.append(this.cellURI);
                    sb.append("\nnodesURI: ");
                    sb.append(this.nodesURI);
                    sb.append("\nclustersURI: ");
                    sb.append(this.clustersURI);
                    if (this.nodeGroupNames != null) {
                        sb.append("\nnodeGroupNames: ");
                        for (int i = 0; i < this.nodeGroupNames.length; ++i) {
                            sb.append(this.nodeGroupNames[i]);
                            if (i >= this.nodeGroupNames.length) continue;
                            sb.append(", ");
                        }
                    }
                    sb.append("\nprocess type: ");
                    sb.append(this.processType);
                    sb.append("\nprocess name: ");
                    sb.append(this.processName);
                    sb.append("\nserver type: ");
                    sb.append(this.serverType);
                    sb.append("\ncluster name: ");
                    sb.append(this.clusterName);
                    sb.append("\nnode name: ");
                    sb.append(this.nodeName);
                    sb.append("\ncell name: ");
                    sb.append(this.cellName);
                    if (this.currentScopeNames != null) {
                        sb.append("\ncurrentScopeNames: ");
                        for (int i = 0; i < this.currentScopeNames.length; ++i) {
                            sb.append(this.currentScopeNames[i]);
                            if (i >= this.currentScopeNames.length) continue;
                            sb.append(", ");
                        }
                    }
                    if (this.currentNodeGroupScopeNames != null) {
                        sb.append("\ncurrentNodeGroupScopeNames: ");
                        for (int i = 0; i < this.currentNodeGroupScopeNames.length; ++i) {
                            sb.append(this.currentNodeGroupScopeNames[i]);
                            if (i >= this.currentNodeGroupScopeNames.length) continue;
                            sb.append(", ");
                        }
                    }
                    sb.append("\ncurrentClusterScopeName: ");
                    sb.append(this.currentClusterScopeName);
                    sb.append("\ncurrentProcessScopeName: ");
                    sb.append(this.currentProcessScopeName);
                    sb.append("\ncurrentNodeScopeName: ");
                    sb.append(this.currentNodeScopeName);
                    sb.append("\ncurrentCellScopeName: ");
                    sb.append(this.currentCellScopeName);
                    Tr.debug(tc, sb.toString());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, AdminDataImpl.class.getName(), "268");
                if (!tc.isDebugEnabled()) break block31;
                Tr.debug(tc, "initialization Exception", new Object[]{e});
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialization " + this.cacheKey, new Object[]{this.currentScopeNames[0]});
        }
    }

    @Override
    public boolean getBoolean(String key) {
        Object result;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean key=" + key + " " + this.cacheKey);
        }
        if ((result = this.data.get(key)) == null) {
            result = Boolean.FALSE;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean " + this.cacheKey, result);
        }
        return (Boolean)result;
    }

    @Override
    public Object getObject(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject key=" + key + " " + this.cacheKey);
        }
        Object result = this.data.get(key);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject " + this.cacheKey, result);
        }
        return result;
    }

    @Override
    public String getString(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getString key=" + key + " " + this.cacheKey);
        }
        if (this.setupInternalServerId && key.equals("com.ibm.ws.security.internalServerId")) {
            String uuid;
            this.setupInternalServerId = false;
            if (RasHelper.isServer() && (uuid = AdminContext.peek()) != null && !SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("useRegistryServerId")) {
                String internalServerId = "server:" + this.cellName + "_" + uuid;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting internalServerID to = " + internalServerId);
                }
                this.setString("com.ibm.ws.security.internalServerId", internalServerId);
            }
        }
        Object result = this.data.get(key);
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getString " + this.cacheKey, result);
        }
        return (String)result;
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setBoolean " + this.cacheKey, new Object[]{key, value});
        }
        this.data.put(key, value);
    }

    @Override
    public void setObject(String key, Object value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setObject " + this.cacheKey, new Object[]{key, value});
        }
        this.data.put(key, value);
    }

    @Override
    public void setString(String key, String value) {
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "setString " + this.cacheKey, new Object[]{key, value});
        }
        this.data.put(key, value);
    }

    @Override
    public String getConfigRootPath() {
        return this.configRootPath;
    }

    @Override
    public String getUserInstallRootPath() {
        return this.userInstallRootPath;
    }

    @Override
    public String getProcessType() {
        return this.processType;
    }

    @Override
    public String getProcessName() {
        return this.processName;
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String[] getNodeGroupNames() {
        return this.nodeGroupNames;
    }

    @Override
    public String getCellName() {
        return this.cellName;
    }

    @Override
    public String getJvmType() {
        return this.jvmType;
    }

    @Override
    public String getClusterName() {
        if (this.clusterName == null && this.repository == null) {
            this.clusterName = this.getClusterNameFromConfig();
        }
        return this.clusterName;
    }

    @Override
    public String[] getCurrentScopeNames() {
        return this.currentScopeNames;
    }

    @Override
    public String[] getCurrentNodeGroupScopeNames() {
        return this.currentNodeGroupScopeNames;
    }

    @Override
    public String getCurrentClusterScopeName() {
        return this.formClusterScope();
    }

    @Override
    public String getCurrentProcessScopeName() {
        return this.currentProcessScopeName;
    }

    @Override
    public String getCurrentNodeScopeName() {
        return this.currentNodeScopeName;
    }

    @Override
    public String getCurrentCellScopeName() {
        return this.currentCellScopeName;
    }

    private static Class getNodeGroupHelperClass() {
        block3: {
            if (_nodeGroupHelperClass == null) {
                Class<?> clazz = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    clazz = cl != null ? cl.loadClass(NODEGROUPHELPER_CLASS) : Class.forName(NODEGROUPHELPER_CLASS);
                    _nodeGroupHelperClass = clazz;
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, AdminDataImpl.class.getName(), "704");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting NodeGroupHelper class.", new Object[]{e});
                }
            }
        }
        return _nodeGroupHelperClass;
    }

    private static Method getNodeGroupMembersMethod() {
        block3: {
            Class clazz;
            if (_getNodeGroupMembersMethod == null && (clazz = AdminDataImpl.getNodeGroupHelperClass()) != null) {
                try {
                    _getNodeGroupMembersMethod = clazz.getMethod("getNodeGroupMembers", Session.class, ConfigService.class, String.class);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, AdminDataImpl.class.getName(), "725");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting NodeGroupHelper class.", new Object[]{e});
                }
            }
        }
        return _getNodeGroupMembersMethod;
    }

    private String[] formCurrentFullScopeNames() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formCurrentScopeNames " + this.cacheKey);
        }
        if (this.nodeGroupNames != null && this.nodeGroupNames.length == 1) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "formCurrentScopeNames(1) " + this.cacheKey);
            }
            return new String[]{this.formCurrentFullScope(this.nodeGroupNames[0])};
        }
        if (this.nodeGroupNames != null && this.nodeGroupNames.length > 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.nodeGroupNames.length; ++i) {
                list.add(this.formCurrentFullScope(this.nodeGroupNames[i]));
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "formCurrentScopeNames(>1) " + this.cacheKey);
            }
            return list.toArray(new String[0]);
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formCurrentScopeNames(null) " + this.cacheKey);
        }
        return new String[]{this.formCurrentFullScope(null)};
    }

    public ArrayList getClusterMembers(ConfigRoot configRoot, String clusterName) {
        return null;
    }

    private String[] formNodeGroupScopes(String[] nodeGroupNames) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeGroupScopes " + this.cacheKey);
        }
        if (nodeGroupNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < nodeGroupNames.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append("(cell):");
                sb.append(this.cellName);
                sb.append(":(nodegroup):");
                sb.append(nodeGroupNames[i]);
                String scope = sb.toString();
                list.add(scope);
            }
            String[] scopes = list.toArray(new String[0]);
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "formNodeGroupScopes " + this.cacheKey);
            }
            return scopes;
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeGroupScopes (null) " + this.cacheKey);
        }
        return null;
    }

    private String formCurrentFullScope(String nodeGroupName) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formCurrentFullScope " + this.cacheKey);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(cell):");
        sb.append(this.cellName);
        if (nodeGroupName != null) {
            sb.append(":(nodegroup):");
            sb.append(nodeGroupName);
        }
        if (this.clusterName != null) {
            sb.append(":(cluster):");
            sb.append(this.clusterName);
        }
        sb.append(":(node):");
        sb.append(this.nodeName);
        sb.append(":(server):");
        sb.append(this.processName);
        String scope = sb.toString();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formCurrentFullScope " + this.cacheKey, scope);
        }
        return scope;
    }

    private String formProcessScope() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formProcessScope " + this.cacheKey);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(cell):");
        sb.append(this.cellName);
        sb.append(":(node):");
        sb.append(this.nodeName);
        sb.append(":(server):");
        sb.append(this.processName);
        String scope = sb.toString();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formProcessScope " + this.cacheKey, scope);
        }
        return scope;
    }

    private String formNodeScope() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeScope " + this.cacheKey);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(cell):");
        sb.append(this.cellName);
        sb.append(":(node):");
        sb.append(this.nodeName);
        String scope = sb.toString();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeScope " + this.cacheKey, scope);
        }
        return scope;
    }

    private String formCellScope() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formCellScope " + this.cacheKey);
        }
        String scope = "(cell):" + this.cellName;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formCellScope " + this.cacheKey, scope);
        }
        return scope;
    }

    private String formClusterScope() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "formClusterScope " + this.cacheKey);
        }
        if (this.repository == null) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "formClusterScope: repository is null, hence returning null");
            }
            return null;
        }
        if (this.checked) {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "formClusterScope: already checked, returning :" + this.currentClusterScopeName);
            }
            return this.currentClusterScopeName;
        }
        String scope = null;
        if (this.clusterName != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("(cell):");
            sb.append(this.cellName);
            sb.append(":(cluster):");
            sb.append(this.clusterName);
            scope = sb.toString();
        }
        this.checked = true;
        this.currentClusterScopeName = scope;
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "formClusterScope: " + this.currentClusterScopeName + " " + this.cacheKey);
        }
        return this.currentClusterScopeName;
    }

    private String getClusterNameFromConfig() {
        String clusterName;
        block8: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "getClusterName " + this.cacheKey);
            }
            clusterName = null;
            try {
                this.repository = SecurityConfigComponentImpl.getRepository();
                if (this.repository != null) {
                    clusterName = this.repository.getClusterName();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Repository is null.");
                }
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getClusterName -> " + clusterName + " " + this.cacheKey);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AdminDataImpl.getClusterName", "943", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception occurred getting Cluster name.", new Object[]{e});
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName -> null " + this.cacheKey);
        }
        return clusterName;
    }

    private String[] getCurrentNodeGroupNames(String nodeName) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentNodeGroupNames " + this.cacheKey, new Object[]{nodeName});
        }
        ArrayList<String> nodeGroupNames = this.getNodeGroupNames(this.configRootPath, this.cellURI);
        String[] nodeGroupMembers = null;
        if (nodeGroupNames != null && nodeGroupNames.size() == 1) {
            return new String[]{nodeGroupNames.get(0)};
        }
        if (nodeGroupNames != null && nodeGroupNames.size() > 1) {
            ArrayList<String> list = new ArrayList<String>();
            String[] nodeGroupNamesArray = nodeGroupNames.toArray(new String[0]);
            for (int i = 0; i < nodeGroupNamesArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeGroup[" + i + "]: " + nodeGroupNamesArray[i]);
                }
                if ((nodeGroupMembers = this.getNodeGroupMembers(nodeGroupNamesArray[i])) == null) continue;
                for (int j = 0; j < nodeGroupMembers.length; ++j) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "NodeGroupMember[" + j + "]: " + nodeGroupMembers[j]);
                    }
                    if (!nodeName.equals(nodeGroupMembers[j])) continue;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "This node is a member of NodeGroup: " + nodeGroupNamesArray[i]);
                    }
                    list.add(nodeGroupNamesArray[i]);
                }
            }
            if (list != null) {
                if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentNodeGroupNames " + this.cacheKey, new Object[]{list});
                }
                return list.toArray(new String[0]);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentNodeGroupNames -> null " + this.cacheKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNodeGroupMembers(String nodeGroupName) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupMembers" + this.cacheKey);
        }
        ConfigService configService = null;
        Session session = null;
        try {
            Method m;
            String[] members = null;
            session = new Session();
            configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                Properties prop = new Properties();
                prop.setProperty("location", "local");
                configService = ConfigServiceFactory.createConfigService(true, prop);
            }
            if ((m = AdminDataImpl.getNodeGroupMembersMethod()) != null) {
                members = (String[])m.invoke(null, session, configService, nodeGroupName);
            }
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeGroupMembers " + this.cacheKey, new Object[]{members});
            }
            String[] stringArray = members;
            return stringArray;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AdminDataImpl.getNodeGroupMembers", "1030", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting NodeGroup members.", new Object[]{e});
            }
        }
        finally {
            block19: {
                try {
                    if (session != null && configService != null) {
                        configService.discard(session);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Exception occurred discarding the configService session");
                }
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupMembers -> null " + this.cacheKey);
        }
        return null;
    }

    private ArrayList<String> getNodeGroupNames(String configRootPath, String cellURI) {
        block7: {
            if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeGroupNames " + this.cacheKey);
            }
            try {
                File[] nodeGroupDirFiles;
                String nodeGroupPath = configRootPath + cellURI + "nodegroups/";
                File nodeGroupDir = new File(nodeGroupPath);
                if (nodeGroupDir != null && nodeGroupDir.isDirectory() && (nodeGroupDirFiles = nodeGroupDir.listFiles()) != null && nodeGroupDirFiles.length > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < nodeGroupDirFiles.length; ++i) {
                        if (!nodeGroupDirFiles[i].isDirectory()) continue;
                        list.add(nodeGroupDirFiles[i].getName());
                    }
                    if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getNodeGroupNames " + this.cacheKey, new Object[]{list});
                    }
                    return list;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.AdminDataImpl.getNodeGroupNames", "10801", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception occurred getting NodeGroup names.", new Object[]{e});
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupNames -> null " + this.cacheKey);
        }
        return null;
    }

    @Override
    public Object peek() {
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        if (scm.isAdminAgent()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "This process is an admin agent.");
            }
            return AdminContext.peek();
        }
        return SecurityObjectLocator.peekContext();
    }

    @Override
    public boolean push(String domainName) {
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        if (scm.isAdminAgent()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "This process is an admin agent.");
            }
            return AdminContext.push(domainName);
        }
        if (domainName.equals("domain:admin") || domainName.equals("admin")) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "Pushing admin.");
            }
            return SecurityObjectLocator.pushAdminContext();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "Pushing application.");
        }
        return SecurityObjectLocator.pushAppContext("");
    }

    @Override
    public Object pop() {
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        if (scm.isAdminAgent()) {
            if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                Tr.debug(tc, "This process is an admin agent.");
            }
            return AdminContext.pop();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
            Tr.debug(tc, "This process is an admin agent.");
        }
        return SecurityObjectLocator.popContext();
    }
}

