/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class MergeSecurityConfig {
    private static TraceComponent tc = Tr.register(MergeSecurityConfig.class, null, "com.ibm.ejs.resources.security");
    private static ManagementScope cellScope = null;
    private static String DIST = "windows";
    private static String ZOS1 = "os390";
    private static String ZOS2 = "os400";
    private static String DefaultSSLSettings = "DefaultSSLSettings";
    private static String DefaultCellSSL = "CellDefaultSSLSettings";
    private static String DefaultNodeSSL = "NodeDefaultSSLSettings";
    private static String DefaultKeyStore = "DefaultKeyStore";
    private static String DefaultTrustStore = "DefaultTrustStore";
    private static String DefaultNodeLTPA = "NodeLTPA";
    private static String DefaultCellScope = "cell";
    private static String DefaultNodeScope = "node";
    private static String DefaultConfigCellsPath = "/config/cells/";
    private static String DefaultCellsPath = "/cells/";
    private static String DefaultNodesPath = "/nodes/";
    private static String DefaultEtcPath = "/etc";
    private static String DefaultP12KeyStore = "key.p12";
    private static String DefaultP12TrustStore = "trust.p12";
    private static String DefaultHostnameVariable = "${hostname}";
    private static Object nodeHost;

    public static Security merge(String workSpaceArchivePath, String workSpaceUserPath, Security cellSecurity, Security serverSecurity, String nodeName, String nodeHostName) throws Exception {
        return MergeSecurityConfig.merge(workSpaceArchivePath, workSpaceUserPath, cellSecurity, serverSecurity, nodeName, nodeHostName, DIST, DIST);
    }

    public static Security merge(String workSpaceArchivePath, String workSpaceUserPath, Security cellSecurity, Security serverSecurity, String nodeName, String nodeHostName, String cellOS, String nodeOS) throws Exception {
        return MergeSecurityConfig.merge(workSpaceArchivePath, workSpaceUserPath, cellSecurity, serverSecurity, nodeName, nodeHostName, DIST, DIST, false, null);
    }

    public static Security merge(String workSpaceArchivePath, String workSpaceUserPath, Security cellSecurity, Security serverSecurity, String nodeName, String nodeHostName, String cellOS, String nodeOS, boolean isOlderThan61Node, String dmgrNodeName) throws Exception {
        return MergeSecurityConfig.merge(workSpaceArchivePath, workSpaceUserPath, cellSecurity, serverSecurity, nodeName, nodeHostName, DIST, DIST, false, null, null);
    }

    public static Security merge(String workSpaceArchivePath, String workSpaceUserPath, Security cellSecurity, Security serverSecurity, String nodeName, String nodeHostName, String cellOS, String nodeOS, boolean isOlderThan61Node, String dmgrNodeName, String nodeVersion) throws Exception {
        String claimSSLAlias;
        ManagementScope newScope;
        Resource r;
        ArrayList<EObject> summaryList;
        Iterator itr6;
        ArrayList<String> cellAliases;
        EObject entry;
        String scope;
        Resource r2;
        String scope2;
        String refId;
        String refId2;
        Resource r3;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", new Object[]{workSpaceArchivePath, workSpaceUserPath, nodeName, nodeHostName, cellOS, nodeOS, Boolean.toString(isOlderThan61Node), dmgrNodeName});
        }
        if (cellSecurity == null) {
            throw new Exception("Null cell level security object provided");
        }
        if (serverSecurity == null) {
            throw new Exception("Null server level security object provided");
        }
        if (nodeName == null) {
            throw new Exception("Null nodeName provided");
        }
        boolean is61 = false;
        if (nodeVersion != null && nodeVersion.startsWith("6.1")) {
            is61 = true;
        }
        if (cellSecurity.isEnabled() && isOlderThan61Node) {
            boolean isIntSvrID;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding a older version node. Check for validSecurityConfig. ");
            }
            if (isIntSvrID = MergeSecurityConfig.checkIfInternalServerIdUsed(cellSecurity)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InternalServerId is set in the dmgr config. Cannot add an older version node unless the serverID/passwd option is used. ");
                }
                throw new Exception("InternalServerId is used in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the serverID/passwd before adding an older version node");
            }
            if (!cellOS.equals(ZOS1) || !(cellSecurity.getActiveUserRegistry() instanceof LocalOSUserRegistry)) {
                boolean isNullSvrPasswd = MergeSecurityConfig.checkIfNullServerPasswordUsed(cellSecurity);
                if (isNullSvrPasswd) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The server password is null or missing in the dmgr config. Cannot add an older version node unless the server password is entered. ");
                    }
                    throw new Exception("The server password is null or missing in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the server password before adding an older version node");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The dmgr security config check passed.");
                }
            }
        }
        nodeName = "_" + nodeName + "_";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node name is " + nodeName);
        }
        if (serverSecurity.getApplicationLoginConfig() != null && serverSecurity.getApplicationLoginConfig().getEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting JAAS configuration.");
            }
            EList cellEntries = cellSecurity.getApplicationLoginConfig().getEntries();
            ArrayList<String> cellAliases2 = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases2 = new ArrayList<String>(cellEntries.size());
                for (JAASConfigurationEntry jaas : cellEntries) {
                    cellAliases2.add(jaas.getAlias());
                }
            }
            EList svrJAASList = serverSecurity.getApplicationLoginConfig().getEntries();
            Iterator itr2 = svrJAASList.iterator();
            ArrayList<JAASConfigurationEntry> jaasList = new ArrayList<JAASConfigurationEntry>(svrJAASList.size());
            while (itr2.hasNext()) {
                JAASConfigurationEntry jaas = (JAASConfigurationEntry)itr2.next();
                if (cellAliases2 == null || !cellAliases2.contains(jaas.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding JAAS alias: " + jaas.getAlias() + " to cell.");
                    }
                    jaasList.add(jaas);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding JAAS alias: " + jaas.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jaas.getAlias()});
            }
            for (i = 0; i < jaasList.size(); ++i) {
                JAASConfigurationEntry je = (JAASConfigurationEntry)jaasList.get(i);
                r3 = je.eResource();
                refId2 = null;
                if (r3 instanceof XMIResource) {
                    refId2 = ((XMIResource)r3).getID(je);
                }
                StringBuffer sb1 = null;
                if (refId2 != null) {
                    int index = refId2.indexOf(95);
                    StringBuffer sb = new StringBuffer(refId2);
                    if (index != -1) {
                        sb1 = sb.replace(index, index + 1, nodeName);
                        ((XMIResource)r3).setID(je, sb1.toString());
                    } else {
                        sb1 = sb.append(nodeName);
                        ((XMIResource)r3).setID(je, sb1.toString());
                    }
                }
                EList lms = je.getLoginModules();
                for (int j = 0; j < lms.size(); ++j) {
                    JAASLoginModule lm = (JAASLoginModule)lms.get(j);
                    EList props = lm.getOptions();
                    r3 = lm.eResource();
                    if (r3 instanceof XMIResource) {
                        refId2 = ((XMIResource)r3).getID(lm);
                    }
                    if (refId2 != null) {
                        int index = refId2.indexOf(95);
                        StringBuffer sb = new StringBuffer(refId2);
                        sb1 = null;
                        if (index != -1) {
                            sb1 = sb.replace(index, index + 1, nodeName);
                            ((XMIResource)r3).setID(lm, sb1.toString());
                        } else {
                            sb1 = sb.append(nodeName);
                            ((XMIResource)r3).setID(lm, sb1.toString());
                        }
                    }
                    if (props == null) continue;
                    for (Property p : props) {
                        r3 = p.eResource();
                        refId2 = null;
                        if (r3 instanceof XMIResource) {
                            refId2 = ((XMIResource)r3).getID(p);
                        }
                        if (refId2 == null) continue;
                        StringBuffer sb = new StringBuffer(refId2);
                        int index = refId2.indexOf(95);
                        if (index != -1) {
                            sb1 = sb.replace(index, index + 1, nodeName);
                            ((XMIResource)r3).setID(p, sb1.toString());
                            continue;
                        }
                        sb1 = sb.append(nodeName);
                        ((XMIResource)r3).setID(p, sb1.toString());
                    }
                }
                cellSecurity.getApplicationLoginConfig().getEntries().add(jaasList.get(i));
            }
        }
        if (serverSecurity.getAuthDataEntries() != null && serverSecurity.getAuthDataEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting J2C configuration.");
            }
            EList cellEntries = cellSecurity.getAuthDataEntries();
            ArrayList<String> cellAliases3 = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases3 = new ArrayList<String>(cellEntries.size());
                for (JAASAuthData jad : cellEntries) {
                    cellAliases3.add(jad.getAlias());
                }
            }
            EList svrJ2CList = serverSecurity.getAuthDataEntries();
            ArrayList<JAASAuthData> j2cList = new ArrayList<JAASAuthData>(svrJ2CList.size());
            for (JAASAuthData jad : svrJ2CList) {
                if (cellAliases3 == null || !cellAliases3.contains(jad.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding J2C alias: " + jad.getAlias() + " to cell.");
                    }
                    j2cList.add(jad);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding J2C alias: " + jad.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jad.getAlias()});
            }
            for (i = 0; i < j2cList.size(); ++i) {
                JAASAuthData ja = (JAASAuthData)j2cList.get(i);
                r3 = ja.eResource();
                refId2 = null;
                if (r3 instanceof XMIResource) {
                    refId2 = ((XMIResource)r3).getID(ja);
                }
                if (refId2 != null) {
                    int index = refId2.indexOf(95);
                    StringBuffer sb = new StringBuffer(refId2);
                    StringBuffer sb1 = null;
                    if (index != -1) {
                        sb1 = sb.replace(index, index + 1, nodeName);
                        ((XMIResource)r3).setID(ja, sb1.toString());
                    } else {
                        sb1 = sb.append(nodeName);
                        ((XMIResource)r3).setID(ja, sb1.toString());
                    }
                }
                cellSecurity.getAuthDataEntries().add(j2cList.get(i));
            }
        }
        if (serverSecurity.getManagementScopes() != null && serverSecurity.getManagementScopes().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting getManagementScopes configuration.");
            }
            EList cellEntries = cellSecurity.getManagementScopes();
            ArrayList<String> cellAliases4 = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases4 = new ArrayList<String>(cellEntries.size());
                for (ManagementScope entry2 : cellEntries) {
                    if (entry2 == null) continue;
                    Resource r4 = entry2.eResource();
                    String refId3 = null;
                    if (r4 instanceof XMIResource) {
                        refId3 = ((XMIResource)r4).getID(entry2);
                    }
                    if (refId3 == null) continue;
                    cellAliases4.add(entry2.getScopeName());
                }
            }
            EList serverManagementScopeList = serverSecurity.getManagementScopes();
            Iterator itr62 = serverManagementScopeList.iterator();
            ArrayList<ManagementScope> managementScopeList = new ArrayList<ManagementScope>(serverManagementScopeList.size());
            while (itr62.hasNext()) {
                ManagementScope entry3 = (ManagementScope)itr62.next();
                Resource r5 = entry3.eResource();
                String refId4 = null;
                if (r5 instanceof XMIResource) {
                    refId4 = ((XMIResource)r5).getID(entry3);
                }
                if (cellScope == null) {
                    cellScope = (ManagementScope)cellEntries.get(0);
                }
                entry3 = MergeSecurityConfig.fixUpCell(entry3, cellScope);
                if (cellAliases4 == null || refId4 != null && !cellAliases4.contains(entry3.getScopeName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding ManagementScope alias: " + entry3.getScopeName() + " to cell.");
                    }
                    managementScopeList.add(entry3);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding ManagementScope alias: " + entry3.getScopeName() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry3.getScopeName()});
            }
            for (i = 0; i < managementScopeList.size(); ++i) {
                ManagementScope entry4 = (ManagementScope)managementScopeList.get(i);
                if (entry4 == null) continue;
                cellSecurity.getManagementScopes().add(entry4);
            }
        }
        String configRootDir = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        com.ibm.websphere.models.config.ipc.ssl.KeyStore cellTrustStore = null;
        EList entries = cellSecurity.getKeyStores();
        for (int j = 0; j < entries.size(); ++j) {
            com.ibm.websphere.models.config.ipc.ssl.KeyStore entry5 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)entries.get(j);
            String scopeType = null;
            if (entry5.getManagementScope() != null) {
                scopeType = entry5.getManagementScope().getScopeType();
            }
            if (scopeType == null || !scopeType.equals(DefaultCellScope) || !entry5.getName().endsWith(DefaultTrustStore)) continue;
            cellTrustStore = entry5;
        }
        boolean cellDefaultSSLSettingsModifiedByMigration = false;
        com.ibm.websphere.models.config.ipc.ssl.KeyStore cellDefaultKeyStoreForNodeIfMigration = null;
        com.ibm.websphere.models.config.ipc.ssl.KeyStore cellDefaultTrustStoreForNodeIfMigration = null;
        if (serverSecurity.getRepertoire() != null && serverSecurity.getRepertoire().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL configuration.");
            }
            EList cellEntries = cellSecurity.getRepertoire();
            ArrayList<String> cellAliases5 = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases5 = new ArrayList<String>(cellEntries.size());
                for (SSLConfig entry6 : cellEntries) {
                    String alias = entry6.getAlias();
                    if (alias != null && alias.equals(DefaultCellSSL)) {
                        com.ibm.websphere.models.config.ipc.ssl.KeyStore ks = entry6.getSetting().getKeyStore();
                        com.ibm.websphere.models.config.ipc.ssl.KeyStore ts = entry6.getSetting().getTrustStore();
                        if (ks != null && ts != null) {
                            if (ks.getLocation() != null && ks.isFileBased() && !ks.isReadOnly() && ks.getType() != null && !ks.getType().equals("JCERACFKS") && !ks.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration keystore to: " + ks.getName());
                                }
                                cellDefaultKeyStoreForNodeIfMigration = ks;
                                cellDefaultSSLSettingsModifiedByMigration = true;
                            }
                            if (ts.getLocation() != null && ts.isFileBased() && !ks.isReadOnly() && ts.getType() != null && !ts.getType().equals("JCERACFKS") && !ts.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration truststore to: " + ts.getName());
                                }
                                cellDefaultTrustStoreForNodeIfMigration = ts;
                                cellDefaultSSLSettingsModifiedByMigration = true;
                            }
                        }
                    }
                    String trustFile = entry6.getSetting().getTrustFileName();
                    String trustPassword = entry6.getSetting().getTrustFilePassword();
                    KeyFileFormatKind trustType = entry6.getSetting().getTrustFileFormat();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is an old style ssl config special handing to exchange the keys");
                    }
                    if (trustFile != null && trustPassword != null && trustType != null) {
                        MergeSecurityConfig.addTrustToCommonTrustStore(entry6.getAlias(), cellEntries, configRootDir, workSpaceUserPath);
                        MergeSecurityConfig.addServerTrustToTrustFile(entry6.getAlias(), trustFile, trustPassword, serverSecurity, configRootDir, workSpaceUserPath);
                    }
                    Resource r6 = entry6.eResource();
                    refId = null;
                    if (r6 instanceof XMIResource) {
                        refId = ((XMIResource)r6).getID(entry6);
                    }
                    if (refId == null) continue;
                    scope2 = entry6.getManagementScope() != null ? entry6.getManagementScope().getScopeName() : refId;
                    cellAliases5.add(MergeSecurityConfig.getCellAliasKey(entry6.getAlias(), scope2));
                }
            }
            EList svrSSLList = serverSecurity.getRepertoire();
            Iterator itr63 = svrSSLList.iterator();
            ArrayList<SSLConfig> sslConfigList = new ArrayList<SSLConfig>(svrSSLList.size());
            while (itr63.hasNext()) {
                SSLConfig entry7 = (SSLConfig)itr63.next();
                String alias = entry7.getAlias();
                if (cellDefaultSSLSettingsModifiedByMigration && alias != null && alias.equals(DefaultNodeSSL)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alias " + alias + " keystores to the cell keystores due to migration.");
                    }
                    entry7.getSetting().setKeyStore(cellDefaultKeyStoreForNodeIfMigration);
                    entry7.getSetting().setTrustStore(cellDefaultTrustStoreForNodeIfMigration);
                }
                if (entry7.getType() == null || entry7.getType().getName().equals("JSSE")) {
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore ks = entry7.getSetting().getKeyStore();
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore ts = entry7.getSetting().getTrustStore();
                    if (ks != null && ts != null) {
                        try {
                            Certificate signer = MergeSecurityConfig.checkIfKeyStoreExistsAndCreateIfNot(ks, configRootDir, workSpaceUserPath, nodeHostName);
                            if (signer != null) {
                                MergeSecurityConfig.checkIfTrustStoreExistsAndCreateIfNot(ts, configRootDir, workSpaceUserPath, signer);
                            }
                        }
                        catch (SSLException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception creating keystore or truststore.", new Object[]{e});
                            }
                            Tr.error(tc, "security.merge.node.keystore.creation.failed", new Object[]{nodeName, e.getMessage()});
                            throw e;
                        }
                    }
                }
                if (cellTrustStore != null && cellTrustStore.isFileBased() && !cellTrustStore.isReadOnly()) {
                    entry7 = MergeSecurityConfig.replaceDefaultNodeTrustStoreWithCellTrustStore(entry7, cellTrustStore);
                }
                r2 = entry7.eResource();
                String refId5 = null;
                if (r2 instanceof XMIResource) {
                    refId5 = ((XMIResource)r2).getID(entry7);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server refID: " + refId5);
                }
                scope = refId5;
                if (entry7.getManagementScope() != null) {
                    ManagementScope newScope2 = MergeSecurityConfig.fixUpCell(entry7.getManagementScope(), cellScope);
                    scope = newScope2.getScopeName();
                }
                if (cellAliases5 == null || !cellAliases5.contains(MergeSecurityConfig.getCellAliasKey(entry7.getAlias(), scope))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(entry7.getAlias(), scope) + " to cell.");
                    }
                    sslConfigList.add(entry7);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(entry7.getAlias(), scope) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry7.getAlias()});
            }
            for (int i2 = 0; i2 < sslConfigList.size(); ++i2) {
                StringBuffer sb;
                int index;
                SSLConfig sslC = (SSLConfig)sslConfigList.get(i2);
                SecureSocketLayer ssl2 = sslC.getSetting();
                CryptoHardwareToken crypto = ssl2.getCryptoHardware();
                EList props = ssl2.getProperties();
                StringBuffer sb1 = null;
                Resource r7 = sslC.eResource();
                String refId6 = null;
                if (r7 instanceof XMIResource) {
                    refId6 = ((XMIResource)r7).getID(sslC);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fixing refID: " + refId6);
                }
                if (refId6 != null) {
                    index = refId6.indexOf(95);
                    sb = new StringBuffer(refId6);
                    if (index != -1) {
                        sb1 = sb.replace(index, index + 1, nodeName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + sb1.toString());
                        }
                        ((XMIResource)r7).setID(sslC, sb1.toString());
                    } else {
                        sb1 = sb.append(nodeName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + sb1.toString());
                        }
                        ((XMIResource)r7).setID(sslC, sb1.toString());
                    }
                }
                if (ssl2 != null) {
                    r7 = ssl2.eResource();
                    refId6 = null;
                    if (r7 instanceof XMIResource) {
                        refId6 = ((XMIResource)r7).getID(ssl2);
                    }
                    if (refId6 != null) {
                        index = refId6.indexOf(95);
                        sb = new StringBuffer(refId6);
                        if (index != -1) {
                            sb1 = sb.replace(index, index + 1, nodeName);
                            ((XMIResource)r7).setID(ssl2, sb1.toString());
                        } else {
                            sb1 = sb.append(nodeName);
                            ((XMIResource)r7).setID(ssl2, sb1.toString());
                        }
                    }
                }
                if (crypto != null) {
                    r7 = crypto.eResource();
                    refId6 = null;
                    if (r7 instanceof XMIResource) {
                        refId6 = ((XMIResource)r7).getID(crypto);
                    }
                    if (refId6 != null) {
                        index = refId6.indexOf(95);
                        sb = new StringBuffer(refId6);
                        if (index != -1) {
                            sb1 = sb.replace(index, index + 1, nodeName);
                            ((XMIResource)r7).setID(crypto, sb1.toString());
                        } else {
                            sb1 = sb.append(nodeName);
                            ((XMIResource)r7).setID(crypto, sb1.toString());
                        }
                    }
                }
                if (props != null) {
                    for (Property p : props) {
                        r7 = p.eResource();
                        refId6 = null;
                        if (r7 instanceof XMIResource) {
                            refId6 = ((XMIResource)r7).getID(p);
                        }
                        if (refId6 == null) continue;
                        StringBuffer sb2 = new StringBuffer(refId6);
                        int index2 = refId6.indexOf(95);
                        if (index2 != -1) {
                            sb1 = sb2.replace(index2, index2 + 1, nodeName);
                            ((XMIResource)r7).setID(p, sb1.toString());
                            continue;
                        }
                        sb1 = sb2.append(nodeName);
                        ((XMIResource)r7).setID(p, sb1.toString());
                    }
                }
                cellSecurity.getRepertoire().add(sslConfigList.get(i2));
            }
        }
        boolean cellSignerExchanged = false;
        boolean nodeSignerExchanged = false;
        boolean nodeDefaultKeyReplaced = false;
        if (serverSecurity.getKeyStores() != null && serverSecurity.getKeyStores().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyStore configuration.");
            }
            ArrayList cellScopedEntries = new ArrayList();
            EList cellEntries = cellSecurity.getKeyStores();
            ArrayList<String> cellAliases6 = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases6 = new ArrayList<String>(cellEntries.size());
                for (com.ibm.websphere.models.config.ipc.ssl.KeyStore entry8 : cellEntries) {
                    if (entry8 == null) continue;
                    Resource r8 = entry8.eResource();
                    refId = null;
                    if (r8 instanceof XMIResource) {
                        refId = ((XMIResource)r8).getID(entry8);
                    }
                    if (refId == null) continue;
                    scope2 = entry8.getManagementScope() != null ? entry8.getManagementScope().getScopeName() : refId;
                    cellAliases6.add(MergeSecurityConfig.getCellAliasKey(entry8.getName(), scope2));
                }
            }
            EList serverEntries = serverSecurity.getKeyStores();
            Iterator itr64 = serverEntries.iterator();
            ArrayList<EObject> summaryList2 = new ArrayList<EObject>(serverEntries.size());
            while (itr64.hasNext()) {
                entry = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)itr64.next();
                if (entry.getLocation().indexOf(DefaultConfigCellsPath) != -1 || entry.getLocation().indexOf(DefaultCellsPath) != -1) {
                    entry.setLocation(MergeSecurityConfig.fixUpKeyStoreCell(entry.getLocation()));
                }
                Resource r9 = entry.eResource();
                String refId7 = null;
                if (r9 instanceof XMIResource) {
                    refId7 = ((XMIResource)r9).getID(entry);
                }
                String scope3 = refId7;
                if (entry.getManagementScope() != null) {
                    ManagementScope newScope3 = MergeSecurityConfig.fixUpCell(entry.getManagementScope(), cellScope);
                    scope3 = newScope3.getScopeName();
                }
                if (cellAliases6 == null || refId7 != null && !cellAliases6.contains(MergeSecurityConfig.getCellAliasKey(entry.getName(), scope3))) {
                    if (entry.getName().startsWith(DefaultNodeLTPA) || entry.getName().endsWith("DefaultRootStore") || entry.getName().endsWith("DefaultSignersStore") || entry.getName().endsWith("DefaultDeletedStore") || entry.getName().endsWith("RSATokenKeyStore") || entry.getName().endsWith("RSATokenTrustStore") || entry.getName().endsWith("RSATokenRootStore")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(entry.getName(), scope3) + " to cell.");
                    }
                    summaryList2.add(entry);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(entry.getName(), scope3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry.getName()});
            }
            for (int i3 = 0; i3 < summaryList2.size(); ++i3) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore entry9 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)summaryList2.get(i3);
                if (entry9 == null) continue;
                cellSecurity.getKeyStores().add(entry9);
            }
            EList allEntries = cellSecurity.getKeyStores();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total number of keystores = " + allEntries.size());
            }
            for (int i4 = 0; i4 < allEntries.size(); ++i4) {
                String nodeKeyStoreLocation;
                String scopeType2;
                com.ibm.websphere.models.config.ipc.ssl.KeyStore entry2;
                int j;
                com.ibm.websphere.models.config.ipc.ssl.KeyStore entry1 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)allEntries.get(i4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking at keystore " + entry1.getName() + " (" + entry1.getManagementScope() != null ? entry1.getManagementScope().getScopeName() : "no scope found).");
                }
                String scopeType1 = null;
                if (entry1.getManagementScope() != null) {
                    scopeType1 = entry1.getManagementScope().getScopeType();
                }
                if (scopeType1 != null && scopeType1.equals(DefaultCellScope) && entry1.getName().endsWith(DefaultKeyStore) && entry1.isFileBased()) {
                    for (j = 0; j < allEntries.size(); ++j) {
                        entry2 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)allEntries.get(j);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking at keystore " + entry2.getName() + " (" + entry2.getManagementScope() != null ? entry2.getManagementScope().getScopeName() : "no scope found).");
                        }
                        scopeType2 = null;
                        if (entry2.getManagementScope() != null) {
                            scopeType2 = entry2.getManagementScope().getScopeType();
                        }
                        if (scopeType2 != null && !scopeType2.equals(DefaultCellScope) && entry2.getName().endsWith(DefaultTrustStore) && entry2.isFileBased()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exchanging signers from keystore " + entry1.getName() + " in scope " + entry1.getManagementScope() != null ? entry1.getManagementScope().getScopeName() : ("no scope found with truststore " + entry2.getName() + " in scope " + entry2.getManagementScope() != null ? entry2.getManagementScope().getScopeName() : "no scope found"));
                            }
                            String nodeTrustStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry2.getLocation(), configRootDir, workSpaceUserPath);
                            KeyStoreManager.getInstance().exchangeSigners(configRootDir, entry1, nodeTrustStoreLocation, entry2);
                            cellSignerExchanged = true;
                        }
                        try {
                            CertReqInfo certReq;
                            X509Certificate cert;
                            KeyStore keyStore;
                            String alias;
                            String defaultAlias;
                            KeyStoreInfo ksInfo;
                            Boolean initializeAtStartupBoolean;
                            Boolean readOnlyBoolean;
                            Boolean fileBasedBoolean;
                            Boolean stashBoolean;
                            String description;
                            String scope4;
                            String provider;
                            String type;
                            String password;
                            String name;
                            String newLocation;
                            Thread.currentThread().getContextClassLoader().loadClass("com.ibm.security.certclient.util.PkNewCertFactory");
                            if (is61) continue;
                            if (scopeType2 != null && !scopeType2.equals(DefaultCellScope) && entry2.getName().endsWith(DefaultKeyStore) && entry2.isFileBased()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding certificate signed by the cell to key store " + entry2.getName() + " in scope " + entry2.getManagementScope().getScopeName());
                                }
                                nodeKeyStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry2.getLocation(), configRootDir, workSpaceUserPath);
                                newLocation = MergeSecurityConfig.fixupLocationWithRepositoryRoot(nodeKeyStoreLocation, entry2.getLocation());
                                name = entry2.getName();
                                password = entry2.getPassword();
                                type = entry2.getType();
                                provider = entry2.getProvider();
                                scope4 = entry2.getManagementScope().getScopeName();
                                description = entry2.getDescription();
                                stashBoolean = Boolean.TRUE;
                                fileBasedBoolean = Boolean.TRUE;
                                readOnlyBoolean = Boolean.FALSE;
                                initializeAtStartupBoolean = Boolean.TRUE;
                                ksInfo = new KeyStoreInfo(name, newLocation, password, provider, type, fileBasedBoolean, null, scope4, null, readOnlyBoolean, initializeAtStartupBoolean, stashBoolean, null, new Integer(0), Boolean.FALSE, null, description);
                                defaultAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                                alias = null;
                                alias = defaultAlias != null ? defaultAlias : "default";
                                keyStore = KeyStoreManager.getInstance().getKeyStore(name, type, provider, newLocation, password, scope4, false, null);
                                if (keyStore != null) {
                                    cert = (X509Certificate)keyStore.getCertificate(alias);
                                    certReq = MergeSecurityConfig.createCertInfoFromCert(alias, cert, ksInfo);
                                    CertificateManager.getInstance().chainedCertificateCreate(certReq, "root", null);
                                    nodeDefaultKeyReplaced = true;
                                }
                            }
                            if (scopeType2 == null || !entry2.getName().equals("CMSKeyStore") || !scopeType2.equalsIgnoreCase("server") || !entry2.isFileBased()) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding certificate signed by the cell to key store " + entry2.getName() + " in scope " + entry2.getManagementScope().getScopeName());
                            }
                            nodeKeyStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry2.getLocation(), configRootDir, workSpaceUserPath);
                            newLocation = MergeSecurityConfig.fixupLocationWithRepositoryRoot(nodeKeyStoreLocation, entry2.getLocation());
                            name = entry2.getName();
                            password = entry2.getPassword();
                            type = entry2.getType();
                            provider = entry2.getProvider();
                            scope4 = entry2.getManagementScope().getScopeName();
                            description = entry2.getDescription();
                            stashBoolean = Boolean.TRUE;
                            fileBasedBoolean = Boolean.TRUE;
                            readOnlyBoolean = Boolean.FALSE;
                            initializeAtStartupBoolean = Boolean.TRUE;
                            ksInfo = new KeyStoreInfo(name, newLocation, password, provider, type, fileBasedBoolean, null, scope4, null, readOnlyBoolean, initializeAtStartupBoolean, stashBoolean, null, new Integer(0), Boolean.FALSE, null, description);
                            defaultAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                            alias = null;
                            alias = defaultAlias != null ? defaultAlias : "default";
                            keyStore = KeyStoreManager.getInstance().getKeyStore(name, type, provider, newLocation, password, scope4, false, null);
                            if (keyStore == null) continue;
                            cert = (X509Certificate)keyStore.getCertificate(alias);
                            certReq = MergeSecurityConfig.createCertInfoFromCert(alias, cert, ksInfo);
                            CertificateManager.getInstance().chainedCertificateCreate(certReq, "root", null);
                            nodeDefaultKeyReplaced = true;
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Certificate Signing API's are not available: " + e.getMessage());
                        }
                    }
                }
                if (scopeType1 != null && !scopeType1.equals(DefaultCellScope) && entry1.getName().endsWith(DefaultKeyStore) && entry1.isFileBased()) {
                    for (j = 0; j < allEntries.size(); ++j) {
                        entry2 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)allEntries.get(j);
                        scopeType2 = null;
                        if (entry2.getManagementScope() != null) {
                            scopeType2 = entry2.getManagementScope().getScopeType();
                        }
                        if (scopeType2 == null || !scopeType2.equals(DefaultCellScope) || !entry2.getName().endsWith(DefaultTrustStore) || !entry2.isFileBased()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exchanging signers from keystore " + entry1.getName() + " in scope " + entry1.getManagementScope() != null ? entry1.getManagementScope().getScopeName() : ("no scope found with truststore " + entry2.getName() + " in scope " + entry2.getManagementScope() != null ? entry2.getManagementScope().getScopeName() : "no scope found"));
                        }
                        nodeKeyStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry1.getLocation(), configRootDir, workSpaceUserPath);
                        KeyStoreManager.getInstance().exchangeSigners(nodeKeyStoreLocation, entry1, configRootDir, entry2);
                        nodeSignerExchanged = true;
                    }
                }
                if (!entry1.getName().equals("CMSKeyStore") || !entry1.isFileBased() || entry1.getManagementScope() == null) continue;
                for (j = 0; j < allEntries.size(); ++j) {
                    entry2 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)allEntries.get(j);
                    if (!entry2.getName().endsWith(DefaultKeyStore) || !entry2.isFileBased() || entry2.getManagementScope() == null || entry1.getManagementScope().getScopeName().equals(entry2.getManagementScope().getScopeName())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exchanging signers from keystore " + entry2.getName() + " with keystore " + entry1.getName());
                    }
                    String cmsKeyStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry1.getLocation(), configRootDir, workSpaceUserPath);
                    String defaultKeyStoreLocation = MergeSecurityConfig.whichLocationKeyStoreExists(entry2.getLocation(), configRootDir, workSpaceUserPath);
                    KeyStoreManager.getInstance().exchangeSigners(defaultKeyStoreLocation, entry2, cmsKeyStoreLocation, entry1);
                }
            }
        }
        if (!cellSignerExchanged) {
            Tr.info(tc, "security.merge.cell.signer.not.exchanged", new Object[]{nodeName});
        }
        if (!nodeSignerExchanged) {
            Tr.info(tc, "security.merge.node.signer.not.exchanged", new Object[]{nodeName});
        }
        if (!nodeDefaultKeyReplaced) {
            Tr.info(tc, "Could not replace the key with one signed by the dmgr cell");
        }
        if (serverSecurity.getKeySets() != null && serverSecurity.getKeySets().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySet configuration.");
            }
            EList cellEntries = cellSecurity.getKeySets();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList<String>(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId8 = null;
                    if (r2 instanceof XMIResource) {
                        refId8 = ((XMIResource)r2).getID(entry10);
                    }
                    if (refId8 == null) continue;
                    scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId8;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName(), scope));
                }
            }
            EList serverEntries = serverSecurity.getKeySets();
            itr6 = serverEntries.iterator();
            summaryList = new ArrayList<EObject>(serverEntries.size());
            while (itr6.hasNext()) {
                KeySet entry11 = (KeySet)itr6.next();
                r = entry11.eResource();
                String refId9 = null;
                if (r instanceof XMIResource) {
                    refId9 = ((XMIResource)r).getID(entry11);
                }
                String scope5 = refId9;
                if (entry11.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry11.getManagementScope(), cellScope);
                    scope5 = newScope.getScopeName();
                }
                if (cellAliases == null || refId9 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry11.getName(), scope5))) {
                    if (entry11.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(entry11.getName(), scope5) + " to cell.");
                    }
                    summaryList.add(entry11);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(entry11.getName(), scope5) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry11.getName()});
            }
            for (int i5 = 0; i5 < summaryList.size(); ++i5) {
                entry = (KeySet)summaryList.get(i5);
                if (entry == null) continue;
                cellSecurity.getKeySets().add(entry);
            }
        }
        if (serverSecurity.getKeySetGroups() != null && serverSecurity.getKeySetGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySetGroup configuration.");
            }
            EList cellEntries = cellSecurity.getKeySetGroups();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId10 = null;
                    if (r2 instanceof XMIResource) {
                        refId10 = ((XMIResource)r2).getID(entry10);
                    }
                    String string = scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId10;
                    if (refId10 == null) continue;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName(), scope));
                }
            }
            EList serverEntries = serverSecurity.getKeySetGroups();
            itr6 = serverEntries.iterator();
            summaryList = new ArrayList(serverEntries.size());
            while (itr6.hasNext()) {
                KeySetGroup entry12 = (KeySetGroup)itr6.next();
                r = entry12.eResource();
                String refId11 = null;
                if (r instanceof XMIResource) {
                    refId11 = ((XMIResource)r).getID(entry12);
                }
                String scope6 = refId11;
                if (entry12.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry12.getManagementScope(), cellScope);
                    scope6 = newScope.getScopeName();
                }
                if (cellAliases == null || refId11 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry12.getName(), scope6))) {
                    if (entry12.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(entry12.getName(), scope6) + " to cell.");
                    }
                    summaryList.add(entry12);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(entry12.getName(), scope6) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry12.getName()});
            }
            for (int i6 = 0; i6 < summaryList.size(); ++i6) {
                entry = (KeySetGroup)summaryList.get(i6);
                if (entry == null) continue;
                cellSecurity.getKeySetGroups().add(entry);
            }
        }
        if (serverSecurity.getDynamicSSLConfigSelections() != null && serverSecurity.getDynamicSSLConfigSelections().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting DynamicSSLConfigSelection configuration.");
            }
            EList cellEntries = cellSecurity.getDynamicSSLConfigSelections();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId12 = null;
                    if (r2 instanceof XMIResource) {
                        refId12 = ((XMIResource)r2).getID(entry10);
                    }
                    if (refId12 == null) continue;
                    scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId12;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName(), scope));
                }
            }
            EList serverEntries = serverSecurity.getDynamicSSLConfigSelections();
            itr6 = serverEntries.iterator();
            summaryList = new ArrayList(serverEntries.size());
            while (itr6.hasNext()) {
                DynamicSSLConfigSelection entry13 = (DynamicSSLConfigSelection)itr6.next();
                r = entry13.eResource();
                String refId13 = null;
                if (r instanceof XMIResource) {
                    refId13 = ((XMIResource)r).getID(entry13);
                }
                String scope7 = refId13;
                if (entry13.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry13.getManagementScope(), cellScope);
                    scope7 = newScope.getScopeName();
                }
                if (cellAliases == null || refId13 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry13.getName(), scope7))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(entry13.getName(), scope7) + " to cell.");
                    }
                    summaryList.add(entry13);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(entry13.getName(), scope7) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry13.getName()});
            }
            for (int i7 = 0; i7 < summaryList.size(); ++i7) {
                entry = (DynamicSSLConfigSelection)summaryList.get(i7);
                if (entry == null) continue;
                cellSecurity.getDynamicSSLConfigSelections().add(entry);
            }
        }
        if (serverSecurity.getKeyManagers() != null && serverSecurity.getKeyManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyManager configuration.");
            }
            EList cellEntries = cellSecurity.getKeyManagers();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId14 = null;
                    if (r2 instanceof XMIResource) {
                        refId14 = ((XMIResource)r2).getID(entry10);
                    }
                    if (refId14 == null) continue;
                    scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId14;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName(), scope));
                }
            }
            EList serverEntries = serverSecurity.getKeyManagers();
            itr6 = serverEntries.iterator();
            summaryList = new ArrayList(serverEntries.size());
            while (itr6.hasNext()) {
                KeyManager entry14 = (KeyManager)itr6.next();
                r = entry14.eResource();
                String refId15 = null;
                if (r instanceof XMIResource) {
                    refId15 = ((XMIResource)r).getID(entry14);
                }
                String scope8 = refId15;
                if (entry14.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry14.getManagementScope(), cellScope);
                    scope8 = newScope.getScopeName();
                }
                if (cellAliases == null || refId15 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry14.getName(), scope8))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(entry14.getName(), scope8) + " to cell.");
                    }
                    summaryList.add(entry14);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(entry14.getName(), scope8) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry14.getName()});
            }
            for (int i8 = 0; i8 < summaryList.size(); ++i8) {
                entry = (KeyManager)summaryList.get(i8);
                if (entry == null) continue;
                cellSecurity.getKeyManagers().add(entry);
            }
        }
        if (serverSecurity.getTrustManagers() != null && serverSecurity.getTrustManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting TrustManager configuration.");
            }
            EList cellEntries = cellSecurity.getTrustManagers();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId16 = null;
                    if (r2 instanceof XMIResource) {
                        refId16 = ((XMIResource)r2).getID(entry10);
                    }
                    if (refId16 == null) continue;
                    scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId16;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName(), scope));
                }
            }
            EList serverEntries = serverSecurity.getTrustManagers();
            itr6 = serverEntries.iterator();
            summaryList = new ArrayList(serverEntries.size());
            while (itr6.hasNext()) {
                TrustManager entry15 = (TrustManager)itr6.next();
                r = entry15.eResource();
                String refId17 = null;
                if (r instanceof XMIResource) {
                    refId17 = ((XMIResource)r).getID(entry15);
                }
                String scope9 = refId17;
                if (entry15.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry15.getManagementScope(), cellScope);
                    scope9 = newScope.getScopeName();
                }
                if (cellAliases == null || refId17 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry15.getName(), scope9))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(entry15.getName(), scope9) + " to cell.");
                    }
                    summaryList.add(entry15);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(entry15.getName(), scope9) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry15.getName()});
            }
            for (int i9 = 0; i9 < summaryList.size(); ++i9) {
                entry = (TrustManager)summaryList.get(i9);
                if (entry == null) continue;
                cellSecurity.getTrustManagers().add(entry);
            }
        }
        if (serverSecurity.getSslConfigGroups() != null && serverSecurity.getSslConfigGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSLConfigGroups configuration.");
            }
            EList cellEntries = cellSecurity.getSslConfigGroups();
            cellAliases = null;
            if (cellEntries != null && cellEntries.size() > 0) {
                cellAliases = new ArrayList(cellEntries.size());
                for (EObject entry10 : cellEntries) {
                    if (entry10 == null) continue;
                    r2 = entry10.eResource();
                    String refId18 = null;
                    if (r2 instanceof XMIResource) {
                        refId18 = ((XMIResource)r2).getID(entry10);
                    }
                    if (refId18 == null) continue;
                    scope = entry10.getManagementScope() != null ? entry10.getManagementScope().getScopeName() : refId18;
                    cellAliases.add(MergeSecurityConfig.getCellAliasKey(entry10.getName() + ":" + entry10.getDirection(), scope));
                }
            }
            EList serverSSLConfigGroupList = serverSecurity.getSslConfigGroups();
            itr6 = serverSSLConfigGroupList.iterator();
            ArrayList<SSLConfigGroup> sslConfigGroupList = new ArrayList<SSLConfigGroup>(serverSSLConfigGroupList.size());
            while (itr6.hasNext()) {
                SSLConfigGroup entry16 = (SSLConfigGroup)itr6.next();
                r = entry16.eResource();
                String refId19 = null;
                if (r instanceof XMIResource) {
                    refId19 = ((XMIResource)r).getID(entry16);
                }
                String scope10 = refId19;
                if (entry16.getManagementScope() != null) {
                    newScope = MergeSecurityConfig.fixUpCell(entry16.getManagementScope(), cellScope);
                    scope10 = newScope.getScopeName();
                }
                if (cellAliases == null || refId19 != null && !cellAliases.contains(MergeSecurityConfig.getCellAliasKey(entry16.getName() + ":" + entry16.getDirection(), scope10))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(entry16.getName() + ":" + entry16.getDirection(), scope10) + " to cell.");
                    }
                    sslConfigGroupList.add(entry16);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(entry16.getName() + ":" + entry16.getDirection(), scope10) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{entry16.getName()});
            }
            for (int i10 = 0; i10 < sslConfigGroupList.size(); ++i10) {
                entry = (SSLConfigGroup)sslConfigGroupList.get(i10);
                if (entry == null) continue;
                cellSecurity.getSslConfigGroups().add(entry);
            }
        }
        if (cellOS.equals(ZOS1) || cellOS.equals(ZOS2) || nodeOS.equals(ZOS1) || nodeOS.equals(ZOS2)) {
            if (!MergeSecurityConfig.iiopPropExists(cellSecurity)) {
                String val1 = null;
                String val2 = null;
                Security sec2 = null;
                sec2 = cellOS.equals(ZOS1) || cellOS.equals(ZOS2) ? cellSecurity : serverSecurity;
                val1 = MergeSecurityConfig.getIIOPClaimSSLAlias(sec2);
                val2 = MergeSecurityConfig.getIIOPPerformSSLAlias(sec2);
                if (cellOS.equals(ZOS1) || nodeOS.equals(ZOS1)) {
                    MergeSecurityConfig.createZOSProperties(cellSecurity, val1, val2);
                }
            }
            if (cellOS.equals(ZOS1)) {
                String existingPerformSSLAlias;
                MergeSecurityConfig.mergeIBMProtocolToCell(cellSecurity, serverSecurity);
                String existingClaimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(cellSecurity);
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingClaimSSLAlias)) {
                    claimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(serverSecurity);
                    MergeSecurityConfig.setIIOPClaimSSLAlias(cellSecurity, claimSSLAlias);
                }
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingPerformSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(cellSecurity))) {
                    String performSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(serverSecurity);
                    MergeSecurityConfig.setIIOPPerformSSLAlias(cellSecurity, performSSLAlias);
                }
            }
        } else if (isOlderThan61Node) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fixed up SSL alias for previous node version");
            }
            String existingClaimSSLAlias = null;
            claimSSLAlias = null;
            String performSSLAlias = null;
            existingClaimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(cellSecurity);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingClaimSSLAlias = " + existingClaimSSLAlias);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingClaimSSLAlias)) {
                claimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(serverSecurity);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI claimSSLAlias = " + claimSSLAlias);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(cellSecurity, claimSSLAlias);
            }
            String existingPerformSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(cellSecurity);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingPerformSSLAlias = " + existingPerformSSLAlias);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingPerformSSLAlias)) {
                performSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(serverSecurity);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI performSSLAlias = " + performSSLAlias);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(cellSecurity, performSSLAlias);
            }
            MergeSecurityConfig.mergeIBMProtocolToCell(cellSecurity, serverSecurity, isOlderThan61Node);
            existingClaimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(cellSecurity);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IBM existingClaimSSLAlias = " + existingClaimSSLAlias);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingClaimSSLAlias)) {
                claimSSLAlias = MergeSecurityConfig.getIIOPClaimSSLAlias(serverSecurity);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM claimSSLAlias = " + claimSSLAlias);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(cellSecurity, claimSSLAlias);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(cellSecurity, existingPerformSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(cellSecurity))) {
                performSSLAlias = MergeSecurityConfig.getIIOPPerformSSLAlias(serverSecurity);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM performSSLAlias = " + performSSLAlias);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(cellSecurity, performSSLAlias);
            }
        }
        if (isOlderThan61Node) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create Dmgr_node/DefaultSSLSettings if not exist for older version node");
            }
            String dmgrDefaultSSL = dmgrNodeName + "/" + DefaultSSLSettings;
            MergeSecurityConfig.createDmgrDefaultSSLSettings(cellSecurity, dmgrDefaultSSL);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "merging custom properties");
        }
        EList cellProps = cellSecurity.getProperties();
        EList serverProps = serverSecurity.getProperties();
        for (int i11 = 0; i11 < serverProps.size(); ++i11) {
            Property sp;
            block255: {
                block257: {
                    block256: {
                        sp = (Property)serverProps.get(i11);
                        boolean found = false;
                        for (int j = 0; j < cellProps.size(); ++j) {
                            Property cp = (Property)cellProps.get(j);
                            if (!cp.getName().equals(sp.getName())) continue;
                            found = true;
                        }
                        if (found) break block255;
                        MergeSecurityConfig.modifyProp(sp, nodeName);
                        SecurityConfig secConfig = SecurityObjectLocator.getSecurityConfig();
                        String propName = sp.getName();
                        if (propName.equals("com.ibm.security.SAF.authorization")) break block256;
                        if (propName.equals("com.ibm.security.SAF.Authz.Log.Option")) break block256;
                        if (propName.equals("com.ibm.security.SAF.delegation")) break block256;
                        if (propName.equals("com.ibm.security.SAF.profilePrefix")) break block256;
                        if (propName.equals("com.ibm.websphere.security.SAF.RoleMapper")) break block256;
                        if (propName.equals("com.ibm.security.SAF.unauthenticated")) break block256;
                        if (propName.equals("com.ibm.security.SAF.useAPPLprofile")) break block256;
                        if (propName.equals("com.ibm.websphere.security.krb.useBuiltInMappingToSAF")) break block256;
                        if (propName.equals("com.ibm.websphere.security.krb.authenticateInCRandSR")) break block256;
                        if (propName.equals("security.zOS.domainName")) break block256;
                        if (!propName.equals("security.zOS.domainType")) break block257;
                    }
                    Tr.info(tc, "security.merge.notadded", new Object[]{sp.getName()});
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + sp.getName() + "=" + sp.getValue() + "to cell");
                }
                cellProps.add(sp);
                continue;
            }
            Tr.info(tc, "security.merge.notadded", new Object[]{sp.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
        return cellSecurity;
    }

    private static void addServerTrustToTrustFile(String sslCfgAlias, String trustFile, String trustPassword, Security serverSecurity, String configRootDir, String workSpaceUserPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServerTrustToTrustFile");
        }
        EList svrSSLList = serverSecurity.getRepertoire();
        Iterator itr6 = svrSSLList.iterator();
        while (itr6.hasNext()) {
            try {
                Certificate cert;
                String serverKeyFile;
                com.ibm.websphere.models.config.ipc.ssl.KeyStore serverKey;
                SSLConfig entry = (SSLConfig)itr6.next();
                String alias = entry.getAlias();
                if (alias == null || !alias.equals(DefaultNodeSSL)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeDefaultTrustStore found let get it's signers.");
                }
                if ((serverKey = entry.getSetting().getKeyStore()) == null) continue;
                WSKeyStore cellTrust = KeyStoreManager.getInstance().getKeyStore(sslCfgAlias + "_trust");
                KeyStore cellTs = cellTrust.getKeyStore(true, false);
                WSKeyStore cellKey = KeyStoreManager.getInstance().getKeyStore(sslCfgAlias + "_key");
                KeyStore cellKs = cellTrust.getKeyStore(true, false);
                String cellTrustFile = trustFile;
                if (cellTrustFile.startsWith("${USER_INSTALL_ROOT}")) {
                    cellTrustFile = KeyStoreManager.getInstance().expand(cellTrustFile);
                } else {
                    cellTrustFile = MergeSecurityConfig.fixUpKeyStoreCell(cellTrustFile);
                    cellTrustFile = MergeSecurityConfig.fixupLocationWithRepositoryRoot(workSpaceUserPath, cellTrustFile);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cellTrustFile is " + cellTrustFile);
                }
                if ((serverKeyFile = serverKey.getLocation()).startsWith("${USER_INSTALL_ROOT}")) {
                    serverKeyFile = KeyStoreManager.getInstance().expand(serverKeyFile);
                } else {
                    serverKeyFile = MergeSecurityConfig.fixUpKeyStoreCell(serverKeyFile);
                    serverKeyFile = MergeSecurityConfig.fixupLocationWithRepositoryRoot(workSpaceUserPath, serverKeyFile);
                }
                KeyStore serverKs = WSKeyStore.loadKeyStore(serverKeyFile, serverKey.getType(), serverKey.getPassword());
                if (cellTs == null || serverKs == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cell ts and server ts found.");
                }
                Enumeration<String> e = serverKs.aliases();
                while (e.hasMoreElements()) {
                    String serverCertAlias = e.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "alias name is " + serverCertAlias);
                    }
                    if ((cert = serverKs.getCertificate(serverCertAlias)) == null) continue;
                    if (cellTs.containsAlias(serverCertAlias)) {
                        String newAlias = CertificateManager.getInstance().incrementAlias(cellTs, serverCertAlias);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting new alias " + newAlias);
                        }
                        cellTs.setCertificateEntry(newAlias, cert);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alias " + serverCertAlias);
                    }
                    cellTs.setCertificateEntry(serverCertAlias, cert);
                }
                e = cellKs.aliases();
                while (e.hasMoreElements()) {
                    String cellCertAlias = e.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell cert alias name is " + cellCertAlias);
                    }
                    if ((cert = cellKs.getCertificate(cellCertAlias)) == null) continue;
                    MergeSecurityConfig.checkIfTrustStoreExistsAndCreateIfNot(entry.getSetting().getTrustStore(), configRootDir, workSpaceUserPath, cert);
                }
                FileOutputStream fos = new FileOutputStream(cellTrustFile);
                cellTs.store(fos, trustPassword.toCharArray());
                if (fos == null) continue;
                fos.close();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "EXCEPTION while loading signer in old style keystore: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServerTrustToTrustFile");
        }
    }

    private static void addTrustToCommonTrustStore(String sslCfgAlias, List cellEntries, String configRootDir, String workSpaceUserPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTrustToCommonTrustStore");
        }
        Iterator itr = cellEntries.iterator();
        while (itr.hasNext()) {
            try {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore commonTrust;
                SSLConfig entry = (SSLConfig)itr.next();
                String alias = entry.getAlias();
                if (alias == null || !alias.equals(DefaultCellSSL)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get the common trust store.");
                }
                if ((commonTrust = entry.getSetting().getTrustStore()) == null) continue;
                WSKeyStore cellTrust = KeyStoreManager.getInstance().getKeyStore(sslCfgAlias + "_trust");
                KeyStore cellTs = cellTrust.getKeyStore(true, false);
                String serverTrustFile = commonTrust.getLocation();
                serverTrustFile = KeyStoreManager.getInstance().expand(serverTrustFile);
                KeyStore serverTs = WSKeyStore.loadKeyStore(serverTrustFile, commonTrust.getType(), commonTrust.getPassword());
                if (cellTs != null && serverTs != null) {
                    Enumeration<String> e = cellTs.aliases();
                    while (e.hasMoreElements()) {
                        Certificate cert;
                        String trustCertAlias = e.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding " + trustCertAlias + " to " + commonTrust.getName());
                        }
                        if ((cert = cellTs.getCertificate(trustCertAlias)) == null) continue;
                        serverTs.setCertificateEntry(trustCertAlias, cert);
                    }
                }
                FileOutputStream fos = new FileOutputStream(serverTrustFile);
                serverTs.store(fos, commonTrust.getPassword().toCharArray());
                if (fos == null) continue;
                fos.close();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "EXCEPTION while loading signer in old style keystore: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTrustToCommonTrustStore");
        }
    }

    private static boolean isJSSETypeFromCellRepertoire(Security cellSecurity, String SSLAlias) {
        EList cellEntries;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJSSETypeFromCellRepertoire");
        }
        if ((cellEntries = cellSecurity.getRepertoire()) != null && cellEntries.size() > 0) {
            for (SSLConfig sslConfig : cellEntries) {
                if (!sslConfig.getAlias().equals(SSLAlias)) continue;
                SSLType type = sslConfig.getType();
                if (type.getValue() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isJSSETypeFromCellRepertoire: true");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (type is SSSL)");
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (entry not found)");
        }
        return false;
    }

    private static void mergeIBMProtocolToCell(Security cellSecurity, Security serverSecurity) {
        MergeSecurityConfig.mergeIBMProtocolToCell(cellSecurity, serverSecurity, false);
    }

    private static void mergeIBMProtocolToCell(Security cellSecurity, Security serverSecurity, boolean OldVersionNode) {
        IIOPSecurityProtocol ibm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeIBMProtocolToCell");
        }
        if ((ibm = cellSecurity.getIBM()) != null && !OldVersionNode) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nothing to do, IBM protocol information already exists");
            }
            return;
        }
        IIOPSecurityProtocol distributed_ibm = serverSecurity.getIBM();
        if (distributed_ibm != null) {
            cellSecurity.setIBM(distributed_ibm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeIBMProtocolToCell");
        }
    }

    private static void modifyProp(Property p, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyProp " + p + " " + nodeName);
        }
        Resource r = p.eResource();
        String refId = null;
        StringBuffer sb1 = null;
        if (r instanceof XMIResource) {
            refId = ((XMIResource)r).getID(p);
        }
        if (refId != null) {
            StringBuffer sb = new StringBuffer(refId);
            int index = refId.indexOf(95);
            if (index != -1) {
                sb1 = sb.replace(index, index + 1, nodeName);
                ((XMIResource)r).setID(p, sb1.toString());
            } else {
                sb1 = sb.append(nodeName);
                ((XMIResource)r).setID(p, sb1.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyProp " + p);
        }
    }

    private static void createZOSProperties(Security cellSecurity, String val1, String val2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createZOSProperties " + val1 + " " + val2);
        }
        PropertiesPackage propertiespkg = PropertiesPackage.eINSTANCE;
        PropertiesFactory propertiesFactory = propertiespkg.getPropertiesFactory();
        Property p1 = propertiesFactory.createProperty();
        Property p2 = propertiesFactory.createProperty();
        p1.setName("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
        p2.setName("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
        p1.setValue(val1);
        p2.setValue(val2);
        EList cellProps = cellSecurity.getProperties();
        cellProps.add(p1);
        cellProps.add(p2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createZOSProperties");
        }
    }

    private static boolean iiopPropExists(Security cellSecurity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "iiopPropExists " + cellSecurity);
        }
        boolean ret = false;
        EList cellProps = cellSecurity.getProperties();
        for (int j = 0; j < cellProps.size(); ++j) {
            Property cp = (Property)cellProps.get(j);
            if (!cp.getName().equals("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig")) continue;
            ret = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "iiopPropExists " + ret);
        }
        return ret;
    }

    private static String getIIOPClaimSSLAlias(Security sec2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPClaimSSLAlias " + sec2);
        }
        IIOPSecurityProtocol csiv2 = sec2.getCSI();
        CommonSecureInterop claimCSI = (CommonSecureInterop)csiv2.getClaims();
        EList lst = claimCSI.getLayers();
        Object o = null;
        Iterator itr = lst.iterator();
        while (itr.hasNext() && !((o = itr.next()) instanceof TransportLayer)) {
        }
        TransportLayer csiv2ClaimIIOPTransportLayer = o;
        IIOPTransport csiv2ClaimIIOPTransportSSLServerAuth = csiv2ClaimIIOPTransportLayer.getServerAuthentication();
        String sslConfig = csiv2ClaimIIOPTransportSSLServerAuth.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPClaimSSLAlias " + sslConfig);
        }
        return sslConfig;
    }

    private static void setIIOPClaimSSLAlias(Security sec2, String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPClaimSSLAlias with alias: " + alias + ", into cell security.xml: " + sec2);
        }
        IIOPSecurityProtocol csiv2 = sec2.getCSI();
        CommonSecureInterop claimCSI = (CommonSecureInterop)csiv2.getClaims();
        EList lst = claimCSI.getLayers();
        Object o = null;
        Iterator itr = lst.iterator();
        while (itr.hasNext() && !((o = itr.next()) instanceof TransportLayer)) {
        }
        TransportLayer csiv2ClaimIIOPTransportLayer = o;
        IIOPTransport csiv2ClaimIIOPTransportSSLServerAuth = csiv2ClaimIIOPTransportLayer.getServerAuthentication();
        csiv2ClaimIIOPTransportSSLServerAuth.setSslConfig(alias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIIOPClaimSSLAlias");
        }
    }

    private static String getIIOPPerformSSLAlias(Security sec2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPPerformSSLAlias " + sec2);
        }
        IIOPSecurityProtocol csiv2 = sec2.getCSI();
        CommonSecureInterop performCSI = (CommonSecureInterop)csiv2.getPerforms();
        EList lst = performCSI.getLayers();
        Object o = null;
        Iterator itr = lst.iterator();
        while (itr.hasNext() && !((o = itr.next()) instanceof TransportLayer)) {
        }
        TransportLayer csiv2PerformIIOPTransportLayer = o;
        IIOPTransport csiv2PerformIIOPTransportSSLServerAuth = csiv2PerformIIOPTransportLayer.getServerAuthentication();
        String sslConfig = csiv2PerformIIOPTransportSSLServerAuth.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias " + sslConfig);
        }
        return sslConfig;
    }

    private static ManagementScope fixUpCell(ManagementScope serverEntry, ManagementScope cellEntry) {
        String scopeName = serverEntry.getScopeName();
        ManagementScopeData servermsd = new ManagementScopeData(scopeName);
        scopeName = cellEntry.getScopeName();
        ManagementScopeData cellmsd = new ManagementScopeData(scopeName);
        servermsd.setCellName(cellmsd.getCellName());
        String fullScope = servermsd.formFullScope();
        serverEntry.setScopeName(fullScope);
        return serverEntry;
    }

    private static String fixUpKeyStoreCell(String keyStoreLocation) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + keyStoreLocation);
        }
        String cellName = ManagementScopeManager.getInstance().getCellName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + cellName);
        }
        int index = keyStoreLocation.indexOf(DefaultConfigCellsPath);
        String newKeyStoreLocation = keyStoreLocation;
        String firstPart = null;
        String theRest = null;
        String lastPart = null;
        if (index != -1) {
            firstPart = keyStoreLocation.substring(0, index + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + firstPart);
            }
            theRest = keyStoreLocation.substring(index + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + theRest);
            }
        } else {
            index = keyStoreLocation.lastIndexOf(DefaultCellsPath);
            if (index != -1) {
                firstPart = keyStoreLocation.substring(0, index + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + firstPart);
                }
                theRest = keyStoreLocation.substring(index + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + theRest);
                }
            }
        }
        if (firstPart != null && theRest != null) {
            if (theRest.indexOf(DefaultNodesPath) != -1) {
                index = theRest.indexOf(DefaultNodesPath);
                lastPart = theRest.substring(index + DefaultNodesPath.length());
                newKeyStoreLocation = firstPart + cellName + DefaultNodesPath + lastPart;
            } else {
                index = theRest.indexOf("/");
                lastPart = theRest.substring(index + "/".length());
                newKeyStoreLocation = firstPart + cellName + "/" + lastPart;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + lastPart);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + newKeyStoreLocation);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + newKeyStoreLocation);
        }
        return newKeyStoreLocation;
    }

    private static void setIIOPPerformSSLAlias(Security sec2, String alias) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPPerformSSLAlias with alias: " + alias + ", into cell security.xml: " + sec2);
        }
        IIOPSecurityProtocol csiv2 = sec2.getCSI();
        CommonSecureInterop performCSI = (CommonSecureInterop)csiv2.getPerforms();
        EList lst = performCSI.getLayers();
        Object o = null;
        Iterator itr = lst.iterator();
        while (itr.hasNext() && !((o = itr.next()) instanceof TransportLayer)) {
        }
        TransportLayer csiv2PerformIIOPTransportLayer = o;
        IIOPTransport csiv2PerformIIOPTransportSSLServerAuth = csiv2PerformIIOPTransportLayer.getServerAuthentication();
        csiv2PerformIIOPTransportSSLServerAuth.setSslConfig(alias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias");
        }
    }

    private static SSLConfig replaceDefaultNodeTrustStoreWithCellTrustStore(SSLConfig sslConfig, com.ibm.websphere.models.config.ipc.ssl.KeyStore cellTrustStore) {
        com.ibm.websphere.models.config.ipc.ssl.KeyStore trustStore;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDefaultNodeTrustStoreWithCellTrustStore", new Object[]{sslConfig.getAlias(), cellTrustStore.getName()});
        }
        if (sslConfig.getType() != null && sslConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sslConfig;
        }
        SecureSocketLayer ssl2 = sslConfig.getSetting();
        if (ssl2 != null && (trustStore = ssl2.getTrustStore()) != null && trustStore.getName().endsWith(DefaultTrustStore)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing Node TrustStore with Cell TrustStore.");
            }
            ssl2.setTrustStore(cellTrustStore);
            sslConfig.setSetting(ssl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sslConfig;
    }

    private static SSLConfig replaceDummyKeyStoreWithCellKeyStoreIfNecessary(SSLConfig sslConfig, List cellKeyStoreList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary", new Object[]{sslConfig.getAlias()});
        }
        if (sslConfig.getType() != null && sslConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sslConfig;
        }
        SecureSocketLayer ssl2 = sslConfig.getSetting();
        if (ssl2 != null) {
            String keyFileName = ssl2.getKeyFileName();
            if (keyFileName != null && keyFileName.endsWith("DummyServerKeyFile.jks")) {
                for (com.ibm.websphere.models.config.ipc.ssl.KeyStore entry : cellKeyStoreList) {
                    if (entry == null) continue;
                    String name = entry.getName();
                    String scopeType = null;
                    if (entry.getManagementScope() != null) {
                        scopeType = entry.getManagementScope().getScopeType();
                    }
                    if (scopeType != null && scopeType.equals(DefaultCellScope) && name != null && name.endsWith(DefaultKeyStore)) {
                        ssl2.setKeyFileName(MergeSecurityConfig.fixupNodeConfigRoot(keyFileName, entry.getLocation()));
                        ssl2.setKeyFilePassword(entry.getPassword());
                        ssl2.setKeyFileFormat(KeyFileFormatKind.get(entry.getType()));
                    }
                    if (scopeType != null && scopeType.equals(DefaultCellScope) && name != null && name.endsWith(DefaultTrustStore)) {
                        ssl2.setTrustFileName(MergeSecurityConfig.fixupNodeConfigRoot(keyFileName, entry.getLocation()));
                        ssl2.setTrustFilePassword(entry.getPassword());
                        ssl2.setTrustFileFormat(KeyFileFormatKind.get(entry.getType()));
                    }
                    sslConfig.setSetting(ssl2);
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (not a dummy keystore)");
                }
                return sslConfig;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sslConfig;
    }

    private static String fixupNodeConfigRoot(String nodeKeyStore, String cellKeyStoreLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupNodeConfigRoot", new Object[]{nodeKeyStore, cellKeyStoreLocation});
        }
        String newPath = nodeKeyStore;
        int index1 = cellKeyStoreLocation.indexOf(DefaultConfigCellsPath);
        if (index1 != -1) {
            String lastPart = cellKeyStoreLocation.substring(index1);
            int index2 = nodeKeyStore.indexOf(DefaultEtcPath);
            if (index2 != -1) {
                String firstPart = nodeKeyStore.substring(0, index2);
                newPath = firstPart + lastPart;
            }
        } else {
            int index = cellKeyStoreLocation.lastIndexOf(DefaultCellsPath);
            if (index != -1) {
                String lastPart = cellKeyStoreLocation.substring(index);
                int index2 = nodeKeyStore.indexOf(DefaultEtcPath);
                if (index2 != -1) {
                    String firstPart = nodeKeyStore.substring(0, index2);
                    newPath = firstPart + "/config" + lastPart;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupNodeConfigRoot -> " + newPath);
        }
        return newPath;
    }

    public static Certificate checkIfKeyStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore ks, String repositoryRoot, String workSpaceRoot, String nodeHostName) throws SSLException {
        String scopeType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfKeyStoreExistsAndCreateIfNot");
        }
        boolean fileBased = ks.isFileBased();
        String location = ks.getLocation();
        String keyStoreName = ks.getName();
        String string = scopeType = ks.getManagementScope() != null ? ks.getManagementScope().getScopeName() : null;
        if (keyStoreName != null && keyStoreName.endsWith(DefaultKeyStore) && scopeType != null && !scopeType.equals(DefaultCellScope) && fileBased) {
            location = MergeSecurityConfig.fixupLocationWithRepositoryRoot(workSpaceRoot, location);
            File keyStoreFile = new File(location = MergeSecurityConfig.fixUpKeyStoreCell(location));
            if (keyStoreFile.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return null;
            }
            try {
                location = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(repositoryRoot, ks.getLocation());
                String name = keyStoreName;
                String password = ks.getPassword();
                String type = ks.getType();
                String provider = ks.getProvider();
                String scope = ks.getManagementScope() != null ? ks.getManagementScope().getScopeName() : null;
                String description = ks.getDescription();
                Boolean stashBoolean = Boolean.TRUE;
                Boolean fileBasedBoolean = Boolean.TRUE;
                Boolean readOnlyBoolean = Boolean.FALSE;
                Boolean initializeAtStartupBoolean = Boolean.TRUE;
                KeyStoreInfo ksInfo = new KeyStoreInfo(name, location, password, provider, type, fileBasedBoolean, null, scope, null, readOnlyBoolean, initializeAtStartupBoolean, stashBoolean, null, new Integer(0), Boolean.FALSE, null, description);
                String defaultAlias = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                String alias = null;
                alias = defaultAlias != null ? defaultAlias : "default";
                String sizeString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String subjectDN = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US");
                subjectDN = subjectDN.indexOf(DefaultHostnameVariable) != -1 && nodeHostName != null ? MergeSecurityConfig.expandHostNameVariable(subjectDN, nodeHostName) : KeyStoreManager.getInstance().expand(subjectDN);
                String daysString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "365");
                int size = new Integer(sizeString);
                int days = new Integer(daysString);
                CertReqInfo certReq = new CertReqInfo(alias, size, subjectDN, days, ksInfo, null);
                Certificate signer = CertificateManager.getInstance().chainedCertificateCreate(certReq, "root", null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot");
                }
                return signer;
            }
            catch (Exception e) {
                if (e instanceof SSLException) {
                    throw (SSLException)e;
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
        return null;
    }

    private static String expandHostNameVariable(String subjectDN, String nodeHostName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandHostNameVariable", new Object[]{subjectDN, nodeHostName});
        }
        String expandedSubjectDN = subjectDN;
        int index1 = subjectDN.indexOf(DefaultHostnameVariable);
        if (index1 != -1) {
            String firstPart = subjectDN.substring(0, index1);
            String lastPart = subjectDN.substring(index1 + DefaultHostnameVariable.length());
            if (firstPart != null && !firstPart.equals("") && lastPart != null && !lastPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName + lastPart;
            } else if (firstPart != null && !firstPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName;
            } else if (lastPart != null && !lastPart.equals("")) {
                expandedSubjectDN = nodeHostName + lastPart;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandHostNameVariable -> " + expandedSubjectDN);
        }
        return expandedSubjectDN;
    }

    public static void checkIfTrustStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore ts, String repositoryRoot, String workSpaceRoot, Certificate signer) throws SSLException {
        String scopeType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTrustStoreExistsAndCreateIfNot");
        }
        boolean fileBased = ts.isFileBased();
        String location = ts.getLocation();
        String trustStoreName = ts.getName();
        String string = scopeType = ts.getManagementScope() != null ? ts.getManagementScope().getScopeName() : null;
        if (trustStoreName != null && trustStoreName.endsWith(DefaultTrustStore) && scopeType != null && !scopeType.equals(DefaultCellScope) && fileBased) {
            location = MergeSecurityConfig.fixupLocationWithRepositoryRoot(workSpaceRoot, location);
            File trustStoreFile = new File(location = MergeSecurityConfig.fixUpKeyStoreCell(location));
            if (trustStoreFile.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            try {
                location = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(repositoryRoot, ts.getLocation());
                String name = trustStoreName;
                String password = ts.getPassword();
                String type = ts.getType();
                String provider = ts.getProvider();
                String scope = ts.getManagementScope() != null ? ts.getManagementScope().getScopeName() : null;
                KeyStore keyStore = KeyStoreManager.getInstance().getKeyStore(name, type, provider, location, password, scope, true, null);
                String signer_alias = "default_signer";
                if (keyStore != null) {
                    keyStore.setCertificateEntry(signer_alias, signer);
                    FileOutputStream fos = new FileOutputStream(location);
                    keyStore.store(fos, password.toCharArray());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (signer set)");
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof SSLException) {
                    throw (SSLException)e;
                }
                throw new SSLException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
    }

    private static String checkForLocationInRepositoryRootMakeDirectoryIfNecessary(String repositoryRoot, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary", new Object[]{repositoryRoot, location});
        }
        String newLocation = MergeSecurityConfig.fixupLocationWithRepositoryRoot(repositoryRoot, location);
        newLocation = MergeSecurityConfig.fixUpKeyStoreCell(newLocation);
        String newLocationPath = MergeSecurityConfig.stripFileFromPath(newLocation);
        File newLocationFile = new File(newLocationPath);
        boolean createdNewDirs = false;
        if (!newLocationFile.exists()) {
            createdNewDirs = newLocationFile.mkdirs();
        }
        if (!createdNewDirs && tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not create the directory to add the keyfile.  AddNode is going to fail.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary");
        }
        return newLocation;
    }

    private static String stripFileFromPath(String location) {
        int index = location.lastIndexOf("/");
        if (index != -1) {
            return location.substring(0, index);
        }
        return location;
    }

    private static String whichLocationKeyStoreExists(String keyStorePath, String configRootDir, String workSpaceUserPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "whichLocationKeyStoreExists");
        }
        String newLocation = MergeSecurityConfig.fixupLocationWithRepositoryRoot(workSpaceUserPath, keyStorePath);
        File newLocationFile = new File(newLocation = MergeSecurityConfig.fixUpKeyStoreCell(newLocation));
        if (newLocationFile.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "whichLocationKeyStoreExists -> " + workSpaceUserPath);
            }
            return workSpaceUserPath;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "whichLocationKeyStoreExists -> " + configRootDir);
        }
        return configRootDir;
    }

    private static String fixupLocationWithRepositoryRoot(String repositoryRoot, String location) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{repositoryRoot, location});
        }
        int index = location.lastIndexOf(DefaultCellsPath);
        String newPath = location;
        if (index != -1) {
            String lastPart = location.substring(index);
            newPath = repositoryRoot + lastPart;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + newPath);
        }
        return newPath;
    }

    private static String getCellAliasKey(String alias, String scope) {
        StringBuffer sb = new StringBuffer(alias);
        sb.append(":");
        sb.append(scope);
        String cellAliasKey = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellAliasKey -> " + cellAliasKey);
        }
        return cellAliasKey;
    }

    private static void createDmgrDefaultSSLSettings(Security cellSecurity, String defaultSSL) {
        EList cellEntries;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDmgrDefaultSSLSettings(" + defaultSSL + ")");
        }
        if ((cellEntries = cellSecurity.getRepertoire()) != null && cellEntries.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "search" + defaultSSL);
            }
            for (SSLConfig entry : cellEntries) {
                Resource r = entry.eResource();
                String refId = null;
                if (r instanceof XMIResource) {
                    refId = ((XMIResource)r).getID(entry);
                }
                if (refId == null || !defaultSSL.equals(entry.getAlias())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found: " + defaultSSL + "  Cell refID: " + refId);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search" + DefaultCellSSL);
        }
        SSLConfig defaultSSLCfg = null;
        for (SSLConfig entry : cellEntries) {
            Resource r = entry.eResource();
            String refId = null;
            if (r instanceof XMIResource) {
                refId = ((XMIResource)r).getID(entry);
            }
            if (refId == null || !DefaultCellSSL.equals(entry.getAlias())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found: " + DefaultCellSSL + "  Cell refID: " + refId);
            }
            defaultSSLCfg = entry;
            break;
        }
        if (defaultSSLCfg != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add " + defaultSSL);
            }
            SecurityPackage securitypkg = SecurityPackage.eINSTANCE;
            SecurityFactory securityFactory = securitypkg.getSecurityFactory();
            SslPackage sslPkg = SslPackage.eINSTANCE;
            SslFactory sslFactory = sslPkg.getSslFactory();
            SSLConfig sslCfg = securityFactory.createSSLConfig();
            SecureSocketLayer ssl2 = sslFactory.createSecureSocketLayer();
            SecureSocketLayer dmgrSSL = defaultSSLCfg.getSetting();
            sslCfg.setAlias(defaultSSL);
            sslCfg.setManagementScope(defaultSSLCfg.getManagementScope());
            ssl2.setClientAuthentication(dmgrSSL.isClientAuthentication());
            ssl2.setSecurityLevel(dmgrSSL.getSecurityLevel());
            ssl2.setEnableCryptoHardwareSupport(dmgrSSL.isEnableCryptoHardwareSupport());
            ssl2.setEnabledCiphers(dmgrSSL.getEnabledCiphers());
            ssl2.setJsseProvider(dmgrSSL.getJsseProvider());
            ssl2.setClientAuthenticationSupported(dmgrSSL.isClientAuthenticationSupported());
            ssl2.setSslProtocol(dmgrSSL.getSslProtocol());
            EList tmEntries = dmgrSSL.getTrustManager();
            for (TrustManager tm : tmEntries) {
                ssl2.getTrustManager().add(tm);
            }
            ssl2.setKeyManager(dmgrSSL.getKeyManager());
            ssl2.setKeyStore(dmgrSSL.getKeyStore());
            ssl2.setTrustStore(dmgrSSL.getTrustStore());
            sslCfg.setSetting(ssl2);
            cellSecurity.getRepertoire().add(sslCfg);
        }
    }

    public static Security updateCellNameAndNodeName(Security serverSecurity, String cellName, String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellNameAndNodeName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + cellName + "Node name: " + nodeName);
        }
        if (serverSecurity.getKeyStores() != null && serverSecurity.getKeyStores().size() > 0) {
            EList keyStoreEntries;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for KeyStore.");
            }
            if ((keyStoreEntries = serverSecurity.getKeyStores()) != null) {
                for (EObject entry : keyStoreEntries) {
                    if (entry.getLocation().indexOf(DefaultConfigCellsPath) == -1 && entry.getLocation().indexOf(DefaultCellsPath) == -1) continue;
                    entry.setLocation(MergeSecurityConfig.fixUpKeyStore(entry.getLocation(), cellName, nodeName));
                }
            }
        }
        if (serverSecurity.getManagementScopes() != null && serverSecurity.getManagementScopes().size() > 0) {
            EList mgrScopesEntries;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for ManagementScopes.");
            }
            if ((mgrScopesEntries = serverSecurity.getManagementScopes()) != null) {
                for (EObject entry : mgrScopesEntries) {
                    if (entry.getScopeName().indexOf("(cell):") == -1) continue;
                    entry.setScopeName(MergeSecurityConfig.fixUpManagementScope(entry.getScopeType(), cellName, nodeName));
                }
            }
        }
        MergeSecurityConfig.fixUpSslConfigGroup(cellName, nodeName, serverSecurity);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellNameAndNodeName");
        }
        return serverSecurity;
    }

    private static String fixUpKeyStore(String keyStoreLocation, String cellName, String nodeName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + keyStoreLocation);
        }
        int index = keyStoreLocation.indexOf(DefaultConfigCellsPath);
        String newKeyStoreLocation = keyStoreLocation;
        String firstPart = null;
        String theRest = null;
        String lastPart = null;
        if (index != -1) {
            firstPart = keyStoreLocation.substring(0, index + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + firstPart);
            }
            theRest = keyStoreLocation.substring(index + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + theRest);
            }
        } else {
            index = keyStoreLocation.lastIndexOf(DefaultCellsPath);
            if (index != -1) {
                firstPart = keyStoreLocation.substring(0, index + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + firstPart);
                }
                theRest = keyStoreLocation.substring(index + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + theRest);
                }
            }
        }
        if (firstPart != null && theRest != null) {
            if (theRest.indexOf(DefaultNodesPath) != -1) {
                index = theRest.indexOf(DefaultNodesPath);
                lastPart = theRest.substring(index + DefaultNodesPath.length());
                if (lastPart != null && lastPart.indexOf("/") != -1) {
                    index = lastPart.indexOf("/");
                    lastPart = lastPart.substring(index + "/".length());
                }
                newKeyStoreLocation = firstPart + cellName + DefaultNodesPath + nodeName + "/" + lastPart;
            } else {
                index = theRest.indexOf("/");
                lastPart = theRest.substring(index + "/".length());
                newKeyStoreLocation = firstPart + cellName + "/" + lastPart;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + lastPart);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + newKeyStoreLocation);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + newKeyStoreLocation);
        }
        return newKeyStoreLocation;
    }

    private static String fixUpManagementScope(String scopeType, String cellName, String nodeName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scoprType: " + scopeType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + cellName + "Node name: " + nodeName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(cell):");
        sb.append(cellName);
        if (scopeType.equals(DefaultNodeScope)) {
            sb.append(":(node):");
            sb.append(nodeName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New newScopeName: " + sb.toString());
        }
        return sb.toString();
    }

    private static void fixUpSslConfigGroup(String cellName, String nodeName, Security serverSecurity) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enter fixUpSslConfigGroup");
        }
        if (serverSecurity.getSslConfigGroups() != null && serverSecurity.getSslConfigGroups().size() > 0) {
            EList sslConfigGroupsEntries;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for sslConfigGroup.");
            }
            if ((sslConfigGroupsEntries = serverSecurity.getSslConfigGroups()) != null) {
                for (SSLConfigGroup entry : sslConfigGroupsEntries) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scopeType: " + entry.getManagementScope() != null ? entry.getManagementScope().getScopeName() : "no scope found");
                    }
                    if (entry.getManagementScope() == null) continue;
                    if (entry.getManagementScope().getScopeType().equals(DefaultCellScope)) {
                        entry.setName(cellName);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "set cell Name: " + cellName);
                        continue;
                    }
                    entry.setName(nodeName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "set node Name: " + nodeName);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exit fixUpSslConfigGroup");
        }
    }

    private static boolean checkIfInternalServerIdUsed(Security cellSecurity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfInternalServerIdUsed");
        }
        boolean isUseRegistrySvrId = cellSecurity.getActiveUserRegistry().isUseRegistryServerId();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfInternalServerIdUsed", isUseRegistrySvrId ? Boolean.FALSE : Boolean.TRUE);
        }
        return !isUseRegistrySvrId;
    }

    private static boolean checkIfNullServerPasswordUsed(Security cellSecurity) {
        String passwd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfNullServerPasswordUsed");
        }
        if ((passwd = cellSecurity.getActiveUserRegistry().getServerPassword()) == null || passwd.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfNullServerPasswordUsed", " null server passwd. return true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfNullServerPasswordUsed", " return false.");
        }
        return false;
    }

    private static CertReqInfo createCertInfoFromCert(String certAlias, X509Certificate cert, KeyStoreInfo ksInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertInfoFromCert");
        }
        PublicKey publicKey = cert.getPublicKey();
        int keySize = -1;
        keySize = publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        if (keySize % 2 != 0) {
            ++keySize;
        }
        Date begin = cert.getNotBefore();
        Date end = cert.getNotAfter();
        long difference = end.getTime() - begin.getTime();
        long differenceDays = difference / 86400000L;
        int validDays = new Long(differenceDays).intValue();
        String subjectDN = ((Object)cert.getSubjectDN()).toString();
        String profileUUID = MergeSecurityConfig.getUUIDFromCert(cert);
        CertReqInfo newCertInfo = new CertReqInfo(certAlias, keySize, subjectDN, validDays, ksInfo, null);
        if (profileUUID != null) {
            newCertInfo.setProfileUUID(profileUUID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertInfoFromCert");
        }
        return newCertInfo;
    }

    private static String getUUIDFromCert(X509Certificate cert) throws Exception {
        String UUIDString = null;
        try {
            Collection<List<?>> subjectAltNames = cert.getSubjectAlternativeNames();
            if (subjectAltNames != null && subjectAltNames.size() > 0) {
                for (List<?> subjectAltNameList : subjectAltNames) {
                    if (subjectAltNameList == null || subjectAltNameList.size() <= 0) continue;
                    for (int i = 0; i < subjectAltNameList.size(); ++i) {
                        String profileUUID;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Alt name value is: " + subjectAltNameList.get(i));
                        }
                        if (!(profileUUID = subjectAltNameList.get(i).toString()).startsWith("ProfileUUID:")) continue;
                        UUIDString = profileUUID.substring("ProfileUUID:".length());
                        return UUIDString;
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while checking AltSubjectNames.", new Object[]{e});
            }
            throw e;
        }
        return UUIDString;
    }
}

