/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.Serializable;
import javax.security.auth.Subject;

public class WSPrincipalImpl
implements WSPrincipal,
Serializable {
    private static final long serialVersionUID = 2133882273669797665L;
    private String realmDelimiter = "/";
    private String username = null;
    private String fullname = null;
    private static final TraceComponent tc = Tr.register(WSPrincipalImpl.class, null, "com.ibm.ejs.resources.security");

    public WSPrincipalImpl(String name) {
        this.fullname = name;
        this.username = this.extractUserName(name);
    }

    public WSCredential getCredential() {
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        if (contextMgr != null) {
            try {
                Subject subject = contextMgr.getInvocationSubject();
                return SubjectHelper.getWSCredentialFromSubject(subject);
            }
            catch (WSSecurityException wSSecurityException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object another) {
        boolean equal = false;
        if (another == null || !(another instanceof WSPrincipal)) {
            equal = false;
        } else {
            WSPrincipal p = (WSPrincipal)another;
            equal = this.getName() == null && p.getName() == null ? true : (this.getName() != null ? this.getName().equals(p.getName()) : p.getName().equals(this.getName()));
        }
        return equal;
    }

    public String toString() {
        return this.fullname;
    }

    public int hashCode() {
        int ret = 0;
        ret = this.fullname == null || this.fullname.length() == 0 ? 0 : this.fullname.hashCode();
        return ret;
    }

    public String getName() {
        return this.fullname;
    }

    public String getUserName() {
        return this.username;
    }

    private String extractUserName(String name) {
        if (name == null) {
            return null;
        }
        int realmDelimiterIndex = name.lastIndexOf(this.realmDelimiter);
        if (realmDelimiterIndex < 0) {
            return name;
        }
        return name.substring(realmDelimiterIndex + 1);
    }
}

