/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.authorize.JaccTaskUtil;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.security.util.DomainContextHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.security.jacc.PolicyConfiguration;
import org.eclipse.emf.common.util.EList;

public class JaccModifiedTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(JaccModifiedTask.class, null, "com.ibm.ejs.resources.security");
    private static String nativeJACC = "com.ibm.ws.security.policy.JaccPolicyProxy";
    private static final int MODULE_ADDED = 0;
    private static final int MODULE_DELETED = 1;
    private static final int MODULE_UPDATED = 2;
    private static final String EJB_DD = "/META-INF/ejb-jar.xml";
    private static final String WEB_DD = "/WEB-INF/web.xml";
    private static final String APP_UPDATE = "com.ibm.websphere.security.jacc.propagateonappupdate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        block56: {
            int op;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sec-modify performTask");
            }
            if (!this._isLocal) {
                String processType = null;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    processType = adminService.getProcessType();
                }
                if (processType == null) {
                    return true;
                }
                if (!processType.equals("DeploymentManager") && !processType.equals("UnManagedProcess")) {
                    return true;
                }
            } else {
                if (this._isInNodeSync) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "No jacc operation during node sync. sec performTask");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Not during node sync. Continue with jacc operation");
                }
            }
            if (((op = newAD.getOperations()) & 0x10000) == 0 && (op & 0x100000) == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sec performTask: not a full or partial update.");
                }
                return true;
            }
            String appName = newAD.getAppName();
            boolean switched = false;
            try {
                block55: {
                    try {
                        boolean jaccEnabled;
                        switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Check to see if JACC is enabled");
                        }
                        boolean pre_proceed = (jaccEnabled = JaccTaskUtil.checkForJacc(this._repository, this._isLocal, this._cellName, false)) && !"false".equalsIgnoreCase(System.getProperty(APP_UPDATE));
                        boolean proceed = false;
                        if (pre_proceed) {
                            EList propsList;
                            Properties adProps;
                            String propagate;
                            proceed = true;
                            Hashtable newADProps = newAD.getProperties();
                            ApplicationDeployment ad = (ApplicationDeployment)newADProps.get("OLDDEPLOY_KEY");
                            if (ad != null && "false".equalsIgnoreCase(propagate = (String)(adProps = ConfigUtils.getProperties(propsList = ad.getProperties())).get(APP_UPDATE))) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Propagate set to false for application: " + newAD.getAppName());
                                }
                                proceed = false;
                            }
                        }
                        if (!proceed) break block55;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JACC is enabled and the propagation is set to true");
                        }
                        EARFile earFile = newAD.getEAR();
                        String contextID = newAD.getAppContextIDForSecurity();
                        if ((op & 0x10000) != 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing for full updates");
                            }
                            ApplicationDeployment appDepl = (ApplicationDeployment)cachedAD.getProperties().get("OLDDEPLOY_KEY");
                            AppInstallNotify.getInstance().appUninstall(appDepl, appName, contextID, this._isLocal);
                            AppInstallNotify.getInstance().appInstall(earFile, appName, contextID, this._isLocal);
                            break block55;
                        }
                        if ((op & 0x100000) == 0) break block55;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing for partial updates");
                        }
                        boolean rolePropagation = false;
                        ArrayList<String> addedEJBModules = new ArrayList<String>();
                        ArrayList<String> addedWebModules = new ArrayList<String>();
                        ArrayList<String> removedEJBModules = new ArrayList<String>();
                        ArrayList<String> removedWebModules = new ArrayList<String>();
                        ArrayList<String> modifiedEJBModules = new ArrayList<String>();
                        ArrayList<String> modifiedWebModules = new ArrayList<String>();
                        Hashtable fileChanges = newAD.getFileChangesInRepository();
                        List addedFiles = (List)fileChanges.get("DOCSADDED_KEY");
                        for (int i = 0; i < addedFiles.size(); ++i) {
                            String addedFile = (String)addedFiles.get(i);
                            if (addedFile.endsWith(EJB_DD)) {
                                String addedEJBModule = this.getModule(addedFile, appName, true);
                                addedEJBModules.add(addedEJBModule);
                                rolePropagation = true;
                                continue;
                            }
                            if (!addedFile.endsWith(WEB_DD)) continue;
                            String addedWebModule = this.getModule(addedFile, appName, false);
                            addedWebModules.add(addedWebModule);
                            rolePropagation = true;
                        }
                        if (tc.isDebugEnabled()) {
                            if (addedEJBModules.size() > 0) {
                                Tr.debug(tc, "EJB modules added are: " + addedEJBModules);
                            }
                            if (addedWebModules.size() > 0) {
                                Tr.debug(tc, "Web modules added are: " + addedWebModules);
                            }
                        }
                        List removedFiles = (List)fileChanges.get("DOCSREMOVED_KEY");
                        for (int i = 0; i < removedFiles.size(); ++i) {
                            String removedFile = (String)removedFiles.get(i);
                            if (removedFile.endsWith(EJB_DD)) {
                                String removedEJBModule = this.getModule(removedFile, appName, true);
                                removedEJBModules.add(removedEJBModule);
                                rolePropagation = true;
                                continue;
                            }
                            if (!removedFile.endsWith(WEB_DD)) continue;
                            String removedWebModule = this.getModule(removedFile, appName, false);
                            removedWebModules.add(removedWebModule);
                            rolePropagation = true;
                        }
                        if (tc.isDebugEnabled()) {
                            if (removedEJBModules.size() > 0) {
                                Tr.debug(tc, "EJB modules removed are: " + removedEJBModules);
                            }
                            if (removedWebModules.size() > 0) {
                                Tr.debug(tc, "Web modules removed are: " + removedWebModules);
                            }
                        }
                        List modifiedFiles = (List)fileChanges.get("DOCSMODIFIED_KEY");
                        for (int i = 0; i < modifiedFiles.size(); ++i) {
                            String modifiedFile = (String)modifiedFiles.get(i);
                            if (modifiedFile.endsWith(EJB_DD)) {
                                String modifiedEJBModule = this.getModule(modifiedFile, appName, true);
                                modifiedEJBModules.add(modifiedEJBModule);
                                rolePropagation = true;
                                continue;
                            }
                            if (!modifiedFile.endsWith(WEB_DD)) continue;
                            String modifiedWebModule = this.getModule(modifiedFile, appName, false);
                            modifiedWebModules.add(modifiedWebModule);
                            rolePropagation = true;
                        }
                        if (tc.isDebugEnabled()) {
                            if (modifiedEJBModules.size() > 0) {
                                Tr.debug(tc, "EJB modules modified are: " + modifiedEJBModules);
                            }
                            if (modifiedWebModules.size() > 0) {
                                Tr.debug(tc, "Web modules modified are: " + modifiedWebModules);
                            }
                        }
                        String oldModuleName = null;
                        PolicyConfiguration pc = null;
                        if (!rolePropagation) break block55;
                        oldModuleName = this.getOldModuleName(earFile, addedEJBModules, removedEJBModules, modifiedEJBModules, addedWebModules, removedWebModules, modifiedWebModules, newAD);
                        if (oldModuleName != null) {
                            pc = AppInstallNotify.getInstance().getPolicyConfiguration(oldModuleName, appName, contextID, this._isLocal, false);
                        }
                        if (addedEJBModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the new EJB modules");
                            }
                            this.processEJBModules(earFile, appName, contextID, addedEJBModules, pc, 0);
                        }
                        if (removedEJBModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the removed EJB modules");
                            }
                            this.processRemovedModules(appName, contextID, removedEJBModules);
                        }
                        if (modifiedEJBModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the modified EJB modules");
                            }
                            this.processEJBModules(earFile, appName, contextID, modifiedEJBModules, pc, 2);
                        }
                        if (addedWebModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the new Web modules");
                            }
                            this.processWebModules(earFile, appName, contextID, addedWebModules, pc, 0);
                        }
                        if (removedWebModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the removed Web modules");
                            }
                            this.processRemovedModules(appName, contextID, removedWebModules);
                        }
                        if (modifiedWebModules.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " processing the modified Web modules");
                            }
                            this.processEJBModules(earFile, appName, contextID, modifiedWebModules, pc, 2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing the authorization table");
                        }
                        AppInstallNotify.getInstance().addAuthorizationTable(earFile, appName, contextID, this._isLocal);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.JaccModifiedTask.performTask", "133", this);
                        Tr.error(tc, "security.jacc.updated.task", new Object[]{newAD.getAppName(), e});
                        Object var27_35 = null;
                        if (switched) {
                            DomainContextHelper.unwindAppDomain(appName);
                        }
                        break block56;
                    }
                }
                Object var27_34 = null;
                if (!switched) break block56;
            }
            catch (Throwable throwable) {
                Object var27_36 = null;
                if (switched) {
                    DomainContextHelper.unwindAppDomain(appName);
                }
                throw throwable;
            }
            DomainContextHelper.unwindAppDomain(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sec performTask");
        }
        return true;
    }

    private String getModule(String pathName, String appName, boolean isEJB) throws Exception {
        String moduleName = null;
        int len = appName.length();
        if (isEJB) {
            int i = pathName.lastIndexOf(EJB_DD);
            int j = pathName.lastIndexOf(appName);
            moduleName = pathName.substring(j + len + 1, i);
        } else {
            int i = pathName.lastIndexOf(WEB_DD);
            int j = pathName.lastIndexOf(appName);
            moduleName = pathName.substring(j + len + 1, i);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleName is = " + moduleName);
        }
        return moduleName;
    }

    private void processWebModules(EARFile earFile, String appName, String contextID, List moduleChanges, PolicyConfiguration pc, int task) throws Exception {
        List webRefList = earFile.getWebModuleRefs();
        if (webRefList != null && webRefList.size() > 0) {
            for (WebModuleRef webModuleRef : webRefList) {
                switch (task) {
                    case 0: {
                        if (!moduleChanges.contains(webModuleRef.getUri())) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding web module: " + webModuleRef.getUri() + " to the JACC provider");
                        }
                        AppInstallNotify.getInstance().addWebPermissions(webModuleRef, appName, contextID, this._isLocal, pc);
                        break;
                    }
                    case 2: {
                        if (!moduleChanges.contains(webModuleRef.getUri())) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Modifying web module: " + webModuleRef.getUri() + " in the JACC provider");
                        }
                        AppInstallNotify.getInstance().addWebPermissions(webModuleRef, appName, contextID, this._isLocal, pc);
                        break;
                    }
                }
            }
        }
    }

    private void processEJBModules(EARFile earFile, String appName, String contextID, List moduleChanges, PolicyConfiguration pc, int task) throws Exception {
        List ejbRefList = earFile.getEJBModuleRefs();
        if (ejbRefList != null && ejbRefList.size() > 0) {
            for (EJBModuleRef ejbModuleRef : ejbRefList) {
                switch (task) {
                    case 0: {
                        if (!moduleChanges.contains(ejbModuleRef.getUri())) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding EJB module: " + ejbModuleRef.getUri() + " to the JACC provider");
                        }
                        AppInstallNotify.getInstance().addEJBPermissions(ejbModuleRef, appName, contextID, this._isLocal, pc);
                        break;
                    }
                    case 2: {
                        if (!moduleChanges.contains(ejbModuleRef.getUri())) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Modifying EJB module: " + ejbModuleRef.getUri() + " in the JACC provider");
                        }
                        AppInstallNotify.getInstance().addEJBPermissions(ejbModuleRef, appName, contextID, this._isLocal, pc);
                        break;
                    }
                }
            }
        }
    }

    private void processRemovedModules(String appName, String contextID, List moduleChanges) throws Exception {
        for (int i = 0; i < moduleChanges.size(); ++i) {
            String mRemove = (String)moduleChanges.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing the module: " + mRemove + " from the JACC provider");
            }
            AppInstallNotify.getInstance().deleteModule(mRemove, appName, contextID, this._isLocal);
        }
    }

    private String getOldModuleName(EARFile earFile, List addedEJBModules, List removedEJBModules, List modifiedEJBModules, List addedWebModules, List removedWebModules, List modifiedWebModules, AppData newAD) throws Exception {
        List ejbRefList;
        if (removedEJBModules.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI for linking policyConfigs is : " + removedEJBModules.get(0));
            }
            return (String)removedEJBModules.get(0);
        }
        if (removedWebModules.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI for linking policyConfigs is : " + removedWebModules.get(0));
            }
            return (String)removedWebModules.get(0);
        }
        if (modifiedEJBModules.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI for linking policyConfigs is = " + modifiedEJBModules.get(0));
            }
            return (String)modifiedEJBModules.get(0);
        }
        if (modifiedWebModules.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI for linking policyConfigs is = " + modifiedWebModules.get(0));
            }
            return (String)modifiedWebModules.get(0);
        }
        List webRefList = earFile.getWebModuleRefs();
        if (webRefList != null && webRefList.size() > 0) {
            for (WebModuleRef webModuleRef : webRefList) {
                String webUri = webModuleRef.getUri();
                if (addedWebModules.contains(webUri)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "URI for linking policyConfigs is: " + webUri);
                }
                return webUri;
            }
        }
        if ((ejbRefList = earFile.getEJBModuleRefs()) != null && ejbRefList.size() > 0) {
            for (EJBModuleRef ejbModuleRef : ejbRefList) {
                String ejbUri = ejbModuleRef.getUri();
                if (addedEJBModules.contains(ejbUri)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "URI for linking policyConfigs is: " + ejbUri);
                }
                return ejbUri;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot obtain the original module for the app " + newAD.getAppName());
        }
        return null;
    }
}

