/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.auth.rsatoken.RSAToken;
import com.ibm.ws.security.auth.rsatoken.SecretKeyToken;
import com.ibm.ws.security.auth.rsatoken.SecretKeyTokenCacheKey;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class RSAPropagationToken {
    private static final TraceComponent tc = Tr.register(RSAPropagationToken.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static HashMap decryptedSecretKeyTokenMap = new HashMap();
    private static HashMap encryptedSecretKeyTokenMap = new HashMap();
    private static int maxSecretKeyTokens = 100;
    public static final String tokenHeader = "WS_ROLE_PROP_TOKEN_HEADER";
    private static final byte[] tokenHeaderBytes = "WS_ROLE_PROP_TOKEN_HEADER".getBytes();
    private final int tokenHeaderSize = tokenHeaderBytes.length;
    private int version;
    private SecretKeyToken secretKeyTokenObject;
    private RSAToken rsaTokenObject;
    private byte[] secretKeyToken;
    private byte[] encryptedSecretKeyToken;
    private byte[] signatureOfSecretKeyToken;
    private byte[] rsaToken;
    private byte[] encryptedRSAToken;
    private byte[] signatureOfRSAToken;
    private byte[] sendingCertificate;
    private X509Certificate sendingX509Certificate;
    private X509Certificate receivingX509Certificate;
    private PublicKey receivingPublicKey;
    private PublicKey sendingPublicKey;
    private PrivateKey sendingPrivateKey;
    private PrivateKey receivingPrivateKey;
    int key_length = 1024;
    SecureRandom random = null;

    RSAPropagationToken() {
    }

    RSAPropagationToken(X509Certificate _sendingX509Certificate, PrivateKey _sendingPrivateKey, X509Certificate _targetX509Certificate, byte[] _secretKeyToken, byte[] _rsaToken, int _version) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RSAPropagationToken <create init>", new Object[]{_sendingX509Certificate, _targetX509Certificate});
        }
        this.version = _version;
        try {
            this.sendingX509Certificate = _sendingX509Certificate;
            this.sendingCertificate = _sendingX509Certificate.getEncoded();
            this.sendingPublicKey = this.sendingX509Certificate.getPublicKey();
            this.sendingPrivateKey = _sendingPrivateKey;
            this.receivingX509Certificate = _targetX509Certificate;
            this.receivingPublicKey = this.receivingX509Certificate.getPublicKey();
            this.secretKeyToken = _secretKeyToken;
            this.rsaToken = _rsaToken;
            this.secretKeyTokenObject = new SecretKeyToken(this.secretKeyToken);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initialization RSA propagation token.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.<init>", "82", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RSAPropagationToken <init>");
        }
    }

    RSAPropagationToken(X509Certificate _receivingX509Certificate, PrivateKey _receivingPrivateKey, byte[] rsaPropagationToken) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RSAPropagationToken <validate init>", new Object[]{_receivingX509Certificate});
        }
        this.receivingX509Certificate = _receivingX509Certificate;
        this.receivingPublicKey = this.receivingX509Certificate.getPublicKey();
        this.receivingPrivateKey = _receivingPrivateKey;
        this.readBytes(rsaPropagationToken);
        if (this.rsaTokenObject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rsa token did not validate properly.");
            }
            throw new WSSecurityException("The rsa token did not validate properly.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RSAPropagationToken <init>");
        }
    }

    RSAPropagationToken(X509Certificate _receivingX509Certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RSAPropagationToken <cert validation only>", new Object[]{_receivingX509Certificate});
        }
        this.receivingX509Certificate = _receivingX509Certificate;
        this.receivingPublicKey = this.receivingX509Certificate.getPublicKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RSAPropagationToken <init>");
        }
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getSendingCertificate() {
        return this.sendingCertificate;
    }

    public X509Certificate getSendingX509Certificate() {
        return this.sendingX509Certificate;
    }

    public byte[] getSecretKeyToken() {
        return this.secretKeyToken;
    }

    public byte[] getRSAToken() {
        return this.rsaToken;
    }

    public RSAToken getRSATokenObject() {
        if (this.rsaToken != null && this.rsaTokenObject == null) {
            this.rsaTokenObject = new RSAToken(this.rsaToken);
        }
        return this.rsaTokenObject;
    }

    public void setVersion(int _version) {
        this.version = _version;
    }

    public void setSendingCertificate(byte[] _sendingCertificate) {
        this.sendingCertificate = _sendingCertificate;
    }

    public void setSecretKeyToken(byte[] _secretKeyToken) {
        this.secretKeyToken = _secretKeyToken;
    }

    public void setRSAToken(byte[] _rsaToken) {
        this.rsaToken = _rsaToken;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readBytes(byte[] rsa_token_bytes) throws WSSecurityException {
        block27: {
            block23: {
                block26: {
                    if (RSAPropagationToken.tc.isEntryEnabled()) {
                        Tr.entry(RSAPropagationToken.tc, "readBytes");
                    }
                    bais = null;
                    dis = null;
                    try {
                        try {
                            bais = new ByteArrayInputStream(rsa_token_bytes);
                            dis = new DataInputStream(bais);
                            isRSAPropagationToken = this.checkRSAPropagationTokenHeader(dis);
                            if (isRSAPropagationToken) {
                                if (RSAPropagationToken.tc.isDebugEnabled()) {
                                    Tr.debug(RSAPropagationToken.tc, "Found RSA propagation token.");
                                }
                                this.version = dis.readInt();
                                if (this.version == 1) {
                                    if (RSAPropagationToken.tc.isDebugEnabled()) {
                                        Tr.debug(RSAPropagationToken.tc, "Token version == 1");
                                    }
                                    this.readRSAPropagationTokenV1Bytes(dis);
                                }
                                break block23;
                            }
                            if (RSAPropagationToken.tc.isEntryEnabled()) {
                                Tr.exit(RSAPropagationToken.tc, "readBytes (Not a WAS opaque authorization token, returning null)");
                            }
                            var6_6 = null;
                        }
                        catch (Exception e) {
                            if (RSAPropagationToken.tc.isDebugEnabled()) {
                                Tr.debug(RSAPropagationToken.tc, "Exception reading information from RSA propagation token bytes.", new Object[]{e});
                            }
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.readBytes", "299", new Object[]{this});
                            throw new WSSecurityException(e.getMessage(), e);
                        }
                    }
                    catch (Throwable var5_12) {
                        var6_8 = null;
                        try {
                            if (bais != null) {
                                bais.close();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            if (dis == null) throw var5_12;
                            dis.close();
                            throw var5_12;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var5_12;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 212->223)] { 
lbl48:
                    // 1 sources

                    if (bais != null) {
                        bais.close();
                    }
                    break block26;
lbl51:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 225->236)] { 
lbl55:
                // 1 sources

                if (dis == null) return;
                dis.close();
                return;
lbl58:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            var6_7 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 212->223)] { 
lbl64:
            // 1 sources

            if (bais != null) {
                bais.close();
            }
            break block27;
lbl67:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {}
        if (dis != null) {
            dis.close();
        }
        if (RSAPropagationToken.tc.isEntryEnabled() == false) return;
        Tr.exit(RSAPropagationToken.tc, "readBytes");
    }

    private void readRSAPropagationTokenV1Bytes(DataInputStream dis) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRSAPropagationTokenV1Bytes");
        }
        int sending_certificate_len = dis.readInt();
        this.sendingCertificate = new byte[sending_certificate_len];
        dis.read(this.sendingCertificate, 0, sending_certificate_len);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.sendingCertificate);
        BufferedInputStream bis = new BufferedInputStream(bais);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        while (bis.available() > 0) {
            this.sendingX509Certificate = (X509Certificate)cf.generateCertificate(bis);
            this.sendingPublicKey = this.sendingX509Certificate.getPublicKey();
        }
        this.verifyCertificate(new X509Certificate[]{this.sendingX509Certificate});
        int secret_key_token_len = dis.readInt();
        this.encryptedSecretKeyToken = new byte[secret_key_token_len];
        dis.read(this.encryptedSecretKeyToken, 0, secret_key_token_len);
        int secret_key_token_signature_len = dis.readInt();
        this.signatureOfSecretKeyToken = new byte[secret_key_token_signature_len];
        dis.read(this.signatureOfSecretKeyToken, 0, secret_key_token_signature_len);
        this.decryptAndVerifySecretKeyToken();
        int rsa_token_len = dis.readInt();
        this.encryptedRSAToken = new byte[rsa_token_len];
        dis.read(this.encryptedRSAToken, 0, rsa_token_len);
        int rsa_token_signature_len = dis.readInt();
        this.signatureOfRSAToken = new byte[rsa_token_signature_len];
        dis.read(this.signatureOfRSAToken, 0, rsa_token_signature_len);
        this.decryptAndVerifyRSAToken();
        this.rsaTokenObject = new RSAToken(this.rsaToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readRSAPropagationTokenV1Bytes");
        }
    }

    private boolean checkRSAPropagationTokenHeader(DataInputStream dis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRSAPropagationTokenHeader");
        }
        try {
            byte[] header = null;
            String headerString = null;
            header = new byte[this.tokenHeaderSize];
            dis.read(header, 0, this.tokenHeaderSize);
            if (header != null) {
                headerString = new String(header, "UTF-8");
                if (headerString.equals(tokenHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkRSAPropagationTokenHeader (true)");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkRSAPropagationTokenHeader (invalid header, false)");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRSAPropagationTokenHeader (no header, false)");
            }
            return false;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.checkRSAPropagationTokenHeader", "427", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception reading RSA propagation token header.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkRSAPropagationTokenHeader (exception, false)");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] writeBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBytes");
        }
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        baos = new ByteArrayOutputStream(500);
        dos = new DataOutputStream(baos);
        dos.write(tokenHeaderBytes, 0, this.tokenHeaderSize);
        dos.writeInt(this.version);
        int sending_certificate_len = this.sendingCertificate.length;
        dos.writeInt(sending_certificate_len);
        dos.write(this.sendingCertificate, 0, sending_certificate_len);
        this.signAndEncryptSecretKeyToken();
        int encrypted_secret_key_token_len = this.encryptedSecretKeyToken.length;
        dos.writeInt(encrypted_secret_key_token_len);
        dos.write(this.encryptedSecretKeyToken, 0, encrypted_secret_key_token_len);
        int secret_key_token_signature_len = this.signatureOfSecretKeyToken.length;
        dos.writeInt(secret_key_token_signature_len);
        dos.write(this.signatureOfSecretKeyToken, 0, secret_key_token_signature_len);
        this.signAndEncryptRSAToken();
        int rsa_token_len = this.encryptedRSAToken.length;
        dos.writeInt(rsa_token_len);
        dos.write(this.encryptedRSAToken, 0, rsa_token_len);
        int rsa_token_signature_len = this.signatureOfRSAToken.length;
        dos.writeInt(rsa_token_signature_len);
        dos.write(this.signatureOfRSAToken, 0, rsa_token_signature_len);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Total opaque token length: " + baos.size());
        }
        byte[] byArray = baos.toByteArray();
        Object var10_11 = null;
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (dos != null) {
                dos.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return byArray;
        catch (Exception e) {
            byte[] byArray2;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception writing information from RSA propagation token to bytes.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.writeBytes", "495", this);
                byArray2 = null;
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (Exception e2) {}
                throw throwable;
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return byArray2;
        }
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Version: ");
        buf.append(this.version);
        buf.append("\n");
        buf.append("SendingCertificate: ");
        for (i = 0; i < this.sendingCertificate.length; ++i) {
            buf.append((char)this.sendingCertificate[i]);
        }
        buf.append("\n");
        buf.append("SecretKeyToken: ");
        for (i = 0; i < this.secretKeyToken.length; ++i) {
            buf.append((char)this.secretKeyToken[i]);
        }
        buf.append("\n");
        buf.append("RSAToken: ");
        for (i = 0; i < this.rsaToken.length; ++i) {
            buf.append((char)this.rsaToken[i]);
        }
        buf.append("\n");
        return buf.toString();
    }

    private synchronized void signAndEncryptSecretKeyToken() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signAndEncryptSecretKeyToken");
        }
        if (this.secretKeyToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeBytes (SecretKeyToken is null)");
            }
            throw new NullPointerException("SecretKeyToken is null.  Cannot sign and/or encrypt.");
        }
        byte[] receivingCertificateEncoded = this.receivingX509Certificate.getEncoded();
        byte[] cacheBytes = new byte[this.secretKeyToken.length + receivingCertificateEncoded.length];
        System.arraycopy(this.secretKeyToken, 0, cacheBytes, 0, this.secretKeyToken.length);
        System.arraycopy(receivingCertificateEncoded, 0, cacheBytes, this.secretKeyToken.length, receivingCertificateEncoded.length);
        ByteArray decryptedSKTByteArray = new ByteArray(cacheBytes);
        SecretKeyTokenCacheKey sktCacheObject = null;
        sktCacheObject = (SecretKeyTokenCacheKey)encryptedSecretKeyTokenMap.get(decryptedSKTByteArray);
        if (sktCacheObject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find encrypted secret key token in cache, validating the token.");
            }
            this.encryptedSecretKeyToken = this.rsaEncryptBytes(this.receivingPublicKey, this.secretKeyToken);
            this.signatureOfSecretKeyToken = this.rsaSignBytes(this.sendingPrivateKey, this.secretKeyToken);
            sktCacheObject = new SecretKeyTokenCacheKey(this.encryptedSecretKeyToken, this.signatureOfSecretKeyToken);
            if (sktCacheObject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current number of encrypted secret key tokens in cache: " + encryptedSecretKeyTokenMap.size());
                }
                if (encryptedSecretKeyTokenMap.size() > maxSecretKeyTokens) {
                    encryptedSecretKeyTokenMap.clear();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding encrypted secret key token to cache.");
                }
                encryptedSecretKeyTokenMap.put(decryptedSKTByteArray, sktCacheObject);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found encrypted secret key token in cache.");
            }
            this.encryptedSecretKeyToken = sktCacheObject.getEncryptedBytes();
            this.signatureOfSecretKeyToken = sktCacheObject.getSignatureBytes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signAndEncryptSecretKeyToken");
        }
    }

    private void decryptAndVerifySecretKeyToken() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptAndVerifySecretKeyToken");
        }
        if (this.encryptedSecretKeyToken == null || this.signatureOfSecretKeyToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "decryptAndVerifySecretKeyToken (Encrypted bytes or signature of SecretKeyToken was null)");
            }
            throw new NullPointerException("Encrypted bytes or signature of SecretKeyToken was null.  Cannot verify and/or decrypt.");
        }
        SecretKeyTokenCacheKey sktCacheKey = new SecretKeyTokenCacheKey(this.encryptedSecretKeyToken, this.signatureOfSecretKeyToken);
        this.secretKeyTokenObject = (SecretKeyToken)decryptedSecretKeyTokenMap.get(sktCacheKey);
        if (this.secretKeyTokenObject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find decrypted secret key token in cache, validating the token.");
            }
            this.secretKeyToken = this.rsaDecryptBytes(this.receivingPrivateKey, this.encryptedSecretKeyToken);
            boolean verified = this.rsaVerifyBytes(this.sendingPublicKey, this.signatureOfSecretKeyToken, this.secretKeyToken);
            if (!verified) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Verification failed, throwing exception.");
                }
                throw new Exception("The signature of the secret key token was not verified.");
            }
            this.secretKeyTokenObject = new SecretKeyToken(this.secretKeyToken);
            if (this.secretKeyTokenObject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current number of decrypted secret key tokens in cache: " + decryptedSecretKeyTokenMap.size());
                }
                if (decryptedSecretKeyTokenMap.size() > maxSecretKeyTokens) {
                    decryptedSecretKeyTokenMap.clear();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding secret key token to cache.");
                }
                decryptedSecretKeyTokenMap.put(sktCacheKey, this.secretKeyTokenObject);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found decrypted secret key token in cache.");
            }
            this.secretKeyToken = this.secretKeyTokenObject.getBytes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptAndVerifySecretKeyToken");
        }
    }

    private void signAndEncryptRSAToken() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signAndEncryptRSAToken");
        }
        if (this.rsaToken == null) {
            throw new NullPointerException("RSAToken is null.  Cannot sign and/or encrypt.");
        }
        byte[] secretKey = this.secretKeyTokenObject.getSecretKey();
        this.signatureOfRSAToken = this.rsaSignBytes(this.sendingPrivateKey, this.rsaToken);
        this.encryptedRSAToken = this.aesEncryptBytes(secretKey, this.rsaToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signAndEncryptRSAToken");
        }
    }

    private void decryptAndVerifyRSAToken() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptAndVerifyRSAToken");
        }
        if (this.encryptedRSAToken == null || this.signatureOfRSAToken == null) {
            throw new NullPointerException("Encrypted bytes or signature of SecretKeyToken was null.  Cannot verify and/or decrypt.");
        }
        byte[] secretKey = this.secretKeyTokenObject.getSecretKey();
        this.rsaToken = this.aesDecryptBytes(secretKey, this.encryptedRSAToken);
        boolean verified = this.rsaVerifyBytes(this.sendingPublicKey, this.signatureOfRSAToken, this.rsaToken);
        if (!verified) {
            throw new Exception("The signature of the rsa token was not verified.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptAndVerifyRSAToken");
        }
    }

    public byte[] rsaSignBytes(PrivateKey key, byte[] value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rsaSignBytes");
        }
        byte[] signature = null;
        try {
            Signature rsaSig = Signature.getInstance("SHA1withRSA");
            rsaSig.initSign(key);
            long start_time = System.currentTimeMillis();
            rsaSig.update(value, 0, value.length);
            signature = rsaSig.sign();
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total RSA sign millis for data size " + value.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception signing bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.rsaSignBytes", "746", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rsaSignBytes");
        }
        return signature;
    }

    public boolean rsaVerifyBytes(PublicKey key, byte[] signature, byte[] value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rsaVerifyBytes");
        }
        boolean verified = false;
        try {
            Signature rsaSig = Signature.getInstance("SHA1withRSA");
            rsaSig.initVerify(key);
            long start_time = System.currentTimeMillis();
            rsaSig.update(value, 0, value.length);
            verified = rsaSig.verify(signature);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total RSA verify millis for data size " + value.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception verifying signature of bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.rsaVerifyBytes", "780", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rsaVerifyBytes");
        }
        return verified;
    }

    public byte[] rsaEncryptBytes(PublicKey key, byte[] value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rsaEncryptBytes");
        }
        byte[] cipherText = null;
        try {
            Cipher engine2 = Cipher.getInstance("RSA");
            engine2.init(1, key);
            long start_time = System.currentTimeMillis();
            cipherText = engine2.doFinal(value);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total RSA encrypt millis for data size " + value.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception RSA encrypting bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.rsaEncryptBytes", "816", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rsaEncryptBytes");
        }
        return cipherText;
    }

    public byte[] rsaDecryptBytes(PrivateKey key, byte[] cipherText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rsaDecryptBytes");
        }
        byte[] plainText = null;
        try {
            Cipher engine2 = Cipher.getInstance("RSA");
            engine2.init(2, key);
            long start_time = System.currentTimeMillis();
            plainText = engine2.doFinal(cipherText);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total RSA decrypt millis for data size " + cipherText.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception RSA decrypting bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.rsaDecryptBytes", "850", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rsaDecryptBytes");
        }
        return plainText;
    }

    public byte[] aesEncryptBytes(byte[] secret_key, byte[] value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aesEncryptBytes");
        }
        byte[] cipherText = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret_key, this.secretKeyTokenObject.getEncryptAlgorithm());
            Cipher engine2 = Cipher.getInstance(this.secretKeyTokenObject.getEncryptAlgorithm());
            engine2.init(1, secretKeySpec);
            long start_time = System.currentTimeMillis();
            cipherText = engine2.doFinal(value);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total AES encrypt millis for data size " + value.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception AES encrypting bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.aesEncryptBytes", "885", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aesEncryptBytes");
        }
        return cipherText;
    }

    public byte[] aesDecryptBytes(byte[] secret_key, byte[] cipherText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aesDecryptBytes");
        }
        byte[] plainText = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret_key, this.secretKeyTokenObject.getEncryptAlgorithm());
            Cipher engine2 = Cipher.getInstance(this.secretKeyTokenObject.getEncryptAlgorithm());
            engine2.init(2, secretKeySpec);
            long start_time = System.currentTimeMillis();
            plainText = engine2.doFinal(cipherText);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total AES decrypt millis for data size " + cipherText.length + " is " + (end_time - start_time) + " millis.");
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception AES decrypting bytes for RSA token.", new Object[]{ex});
            }
            Manager.Ffdc.log(ex, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.aesDecryptBytes", "919", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aesDecryptBytes");
        }
        return plainText;
    }

    public boolean verifyCertificate(X509Certificate[] signed_cert) throws Exception {
        CertPathValidatorException rootCauseException;
        block47: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "verifyCertificate", new Object[]{signed_cert[0]});
            }
            rootCauseException = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to verify sending certificate with target certificate first.");
                }
                boolean verified = false;
                try {
                    this.verifyCertificateInternal(signed_cert, this.receivingX509Certificate);
                    verified = true;
                }
                catch (CertPathValidatorException cpve) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Verification failure, going on to try trust store certificates.");
                    }
                    rootCauseException = cpve;
                }
                if (!verified) {
                    WSKeyStore wsts;
                    String adminTrustStoreName = RSAPropagationManager.getInstance().getAdminTrustStoreName();
                    if (adminTrustStoreName == null) break block47;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Verifying with trust store name: " + adminTrustStoreName);
                    }
                    if ((wsts = KeyStoreManager.getInstance().getKeyStore(adminTrustStoreName)) != null) {
                        KeyStore ts = wsts.getKeyStore(false, false);
                        if (ts != null) {
                            Certificate cert;
                            String alias;
                            String digest;
                            String cachedAlias;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking the certificate alias cache.");
                            }
                            if ((cachedAlias = RSAPropagationManager.getSignerCertificateAliasFromCache(digest = KeyStoreManager.getInstance().generateDigest("SHA-1", signed_cert[0]))) != null) {
                                Certificate cert2;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(AliasCache) Found cached alias, retrieving from trust store.");
                                }
                                if ((cert2 = ts.getCertificate(cachedAlias)) == null) break block47;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(AliasCache) Verifying with the following root certificate.", new Object[]{cert2});
                                }
                                verified = false;
                                try {
                                    this.verifyCertificateInternal(signed_cert, (X509Certificate)cert2);
                                    verified = true;
                                }
                                catch (CertPathValidatorException cpve) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(AliasCache) Verification failure, going on to try trust store certificates.");
                                    }
                                    rootCauseException = cpve;
                                }
                                if (verified) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(AliasCache) (SUCCESS) Sending certificate was validated by " + ((X509Certificate)cert2).getIssuerX500Principal());
                                    }
                                    return true;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(AliasCache) Sending certificate was not validated by " + ((X509Certificate)cert2).getIssuerX500Principal() + ", trying the next certificate.");
                                }
                                break block47;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "(CachedTrustStore) Could not find a cached alias, checking cached trust store.");
                            }
                            Enumeration<String> e = ts.aliases();
                            while (e.hasMoreElements()) {
                                alias = e.nextElement();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(CachedTrustStore) Looking up certificate from alias \"" + alias + "\".");
                                }
                                if ((cert = ts.getCertificate(alias)) == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(CachedTrustStore) Verifying with the following root certificate.", new Object[]{cert});
                                }
                                verified = false;
                                try {
                                    this.verifyCertificateInternal(signed_cert, (X509Certificate)cert);
                                    verified = true;
                                    if (RSAPropagationManager.getSignerCertificateAliasFromCache(digest) == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "(CachedTrustStore) Adding certificate with digest \"" + digest + "\" and alias \"" + alias + "\" to the certificate alias cache.");
                                        }
                                        RSAPropagationManager.addSignerCertificateAliasToCache(digest, alias);
                                    }
                                }
                                catch (CertPathValidatorException cpve) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(CachedTrustStore) Verification failure, going on to try trust store certificates.");
                                    }
                                    rootCauseException = cpve;
                                }
                                if (verified) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(CachedTrustStore) (SUCCESS) Sending certificate was validated by " + ((X509Certificate)cert).getIssuerX500Principal());
                                    }
                                    return true;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "(CachedTrustStore) Sending certificate was not validated by " + ((X509Certificate)cert).getIssuerX500Principal() + ", trying the next certificate.");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "(DiskTrustStore) Could not find a cached alias, checking trust store on disk.");
                            }
                            ts = wsts.getKeyStore(true, false);
                            e = ts.aliases();
                            while (e.hasMoreElements()) {
                                alias = e.nextElement();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(DiskTrustStore) Looking up certificate from alias \"" + alias + "\".");
                                }
                                if ((cert = ts.getCertificate(alias)) == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "(DiskTrustStore) Verifying with the following root certificate.", new Object[]{cert});
                                }
                                verified = false;
                                try {
                                    this.verifyCertificateInternal(signed_cert, (X509Certificate)cert);
                                    verified = true;
                                    if (RSAPropagationManager.getSignerCertificateAliasFromCache(digest) == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "(DiskTrustStore) Adding certificate with digest \"" + digest + "\" and alias \"" + alias + "\" to the certificate alias cache.");
                                        }
                                        RSAPropagationManager.addSignerCertificateAliasToCache(digest, alias);
                                    }
                                }
                                catch (CertPathValidatorException cpve) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(DiskTrustStore) Verification failure.");
                                    }
                                    rootCauseException = cpve;
                                }
                                if (verified) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "(DiskTrustStore) (SUCCESS) Sending certificate was validated by " + ((X509Certificate)cert).getIssuerX500Principal());
                                    }
                                    return true;
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "(DiskTrustStore) Sending certificate was not validated by " + ((X509Certificate)cert).getIssuerX500Principal() + ", trying the next certificate.");
                            }
                            break block47;
                        }
                        throw new WSSecurityException("The admin truststore is not valid.");
                    }
                    throw new IllegalArgumentException("The admin truststore alias is not found.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending certificate was validated by this processes personal certificate.");
                }
                return true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception verifying sending certificate from RSA token.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.RSAPropagationToken.verifyCertificate", "1034", this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exhaused all certificates in the trust store.   Verification failed of sending certificate.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyCertificate");
        }
        throw rootCauseException;
    }

    private void verifyCertificateInternal(X509Certificate[] signed_cert, X509Certificate root_cert) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyCertificateInternal");
        }
        long start_time = System.currentTimeMillis();
        X509Certificate[] certArray = signed_cert;
        List<X509Certificate> certList = Arrays.asList(certArray);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        CertPath cp = cf.generateCertPath(certList);
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        TrustAnchor anchor = new TrustAnchor(root_cert, null);
        PKIXParameters params = new PKIXParameters(Collections.singleton(anchor));
        params.setRevocationEnabled(false);
        try {
            for (int i = 0; i < signed_cert.length; ++i) {
                signed_cert[i].checkValidity();
            }
        }
        catch (CertificateExpiredException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate expiration exception: " + e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Hit a java.security.cert.CertificateExpiredException while checking the certificate validity.");
            }
            throw e;
        }
        try {
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(cp, params);
            long end_time = System.currentTimeMillis();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total certificate verification time is " + (end_time - start_time) + " millis.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate validated successfully: " + result);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyCertificateInternal");
            }
            return;
        }
        catch (CertPathValidatorException cpve) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Validation failure, cert[" + cpve.getIndex() + "] :" + cpve.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "verifyCertificateInternal");
            }
            throw cpve;
        }
    }

    public static void main(String[] args) {
    }
}

