/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.rsatoken.NonceCache;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.math.BigInteger;
import java.security.SecureRandom;

public class NonceManager {
    private static final TraceComponent tc = Tr.register(NonceManager.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.security.rsatoken.nonceCacheSize";
    private static final int MIN_NONCE_CACHESIZE = 200;
    private SecureRandom _random = null;
    private boolean _bServer = false;
    private NonceCache _cache = null;
    private long nonceInstance = 0L;

    public NonceManager(int cacheSize, long cacheTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonceManager(String int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "],");
        }
        String nonceCacheSize = System.getProperty(NONCE_CACHE_SIZE_KEY);
        int size = cacheSize;
        if (nonceCacheSize != null && (nonceCacheSize = nonceCacheSize.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(nonceCacheSize);
                if (i <= 200) {
                    size = cacheSize;
                } else {
                    size = i;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce cache size from system property (com.ibm.websphere.security.rsatoken.nonceCacheSize) = " + size);
                    }
                }
            }
            catch (NumberFormatException e) {
                Manager.Ffdc.log(e, this, NonceManager.class.getName() + ".NonceManager", "89", this);
            }
        }
        this._cache = new NonceCache(size, cacheTimeout, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server process: enabled NonceCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonceManager(int cacheSize, int cacheTimeout)");
        }
    }

    public boolean validate(String nonce) throws IllegalArgumentException {
        boolean retVal;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if (nonce == null || nonce.equals("")) {
            throw new IllegalArgumentException("Invalid nonce value");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating nonce: ", nonce);
        }
        boolean bl = retVal = !this._cache.contains(nonce);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate returns " + retVal);
        }
        return retVal;
    }

    public String generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generate()");
        }
        String nonceString = ManagementScopeManager.getInstance().getProcessScopeName() + ":" + ++this.nonceInstance + ":" + System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce string: " + nonceString);
        }
        byte[] onewayhash = null;
        try {
            onewayhash = ServerCredSigner.getInstance().getOneWayHash(nonceString);
            if (tc.isDebugEnabled() && onewayhash != null) {
                Tr.debug(tc, "One-way password hash using SHA is: " + new BigInteger(onewayhash));
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.rsatoken.NonceManager.generate", "132", this);
        }
        if (onewayhash != null) {
            BigInteger hashInt = new BigInteger(onewayhash);
            String nonce = hashInt.toString();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generate returns (onewayhash): " + nonce);
            }
            return nonce;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generate returns (toBytes): " + nonceString);
        }
        return nonceString;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

