/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.FFDC_OMIT;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.NonPromptCallbackHandler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ValidateKrbConfig
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ValidateKrbConfig.class, "ValidateKrbConfig", "com.ibm.ws.security.auth.kerberos.admintask");
    private String secDomain = null;
    private boolean checkConfigOnly = false;
    private boolean validateKrbRealm = false;
    private boolean useGlobalSecurityConfig = false;
    private String serverId = null;
    @FFDC_OMIT
    private String serverIdPassword = null;
    private String krb5Spn = null;
    private String uxpKrb5Config = null;
    private String krb5Config = null;
    private String uxpKrb5Keytab = null;
    private String krb5Keytab = null;
    private String krb5Realm = null;
    private String _uxpKrb5Config = null;
    private String _krb5Config = null;
    private String _uxpKrb5Keytab = null;
    private String _krb5Keytab = null;
    private String _krb5Realm = null;
    private String _krb5Spn = null;
    private String _serverId = null;
    private boolean _configured = false;
    @FFDC_OMIT
    private String _serverIdPassword = null;
    boolean _useRegServerId = false;

    public ValidateKrbConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ValidateKrbConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.secDomain = (String)this.getParameter("securityDomainName");
        this.checkConfigOnly = (Boolean)this.getParameter("checkConfigOnly");
        this.validateKrbRealm = (Boolean)this.getParameter("validateKrbRealm");
        this.useGlobalSecurityConfig = (Boolean)this.getParameter("useGlobalSecurityConfig");
        this.serverId = (String)this.getParameter("serverId");
        this.serverIdPassword = (String)this.getParameter("serverIdPassword");
        this.krb5Spn = (String)this.getParameter("krb5Spn");
        this.uxpKrb5Config = (String)this.getParameter("krb5Config");
        this.krb5Config = ConfigUtils.expandKrbFile(this.uxpKrb5Config);
        this.uxpKrb5Keytab = (String)this.getParameter("krb5Keytab");
        this.krb5Keytab = ConfigUtils.expandKrbFile(this.uxpKrb5Keytab);
        this.krb5Realm = (String)this.getParameter("krb5Realm");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** Input parameters ***");
            Tr.debug(tc, "securityDomainName name is " + this.secDomain);
            Tr.debug(tc, "checkConfigOnly:  " + this.checkConfigOnly);
            Tr.debug(tc, "useGlobalSecurityConfig:  " + this.useGlobalSecurityConfig);
            Tr.debug(tc, "validateKrbRealm:  " + this.validateKrbRealm);
            Tr.debug(tc, "serverId:  " + this.serverId);
            Tr.debug(tc, "serverIdPassword:  " + (this.serverIdPassword == null ? "null" : "*****"));
            Tr.debug(tc, "krb5Spn:  " + this.krb5Spn);
            Tr.debug(tc, "unexpand krb5Config:  " + this.uxpKrb5Config);
            Tr.debug(tc, "krb5Config:  " + this.krb5Config);
            Tr.debug(tc, "unexpand krb5Keytab:  " + this.uxpKrb5Keytab);
            Tr.debug(tc, "krb5Keytab:  " + this.krb5Keytab);
            Tr.debug(tc, "krb5Realm:  " + this.krb5Realm);
        }
        if (this.useGlobalSecurityConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using global security config instead of input parameters");
            }
            this.getKrbConfigInThisSession();
        }
        if (!this.checkConfigOnly) {
            File keytab;
            File config;
            if (this.useGlobalSecurityConfig) {
                if (this._useRegServerId) {
                    if (this._serverId == null || this._serverId.length() == 0) {
                        String msg = this.getMsg(resBundle, "security.admintask.missingParameter.userRegistry.SECJ7770E", new Object[]{"serverId"});
                        throw new CommandValidationException(msg);
                    }
                    this.serverId = this._serverId;
                    if (this._serverIdPassword == null || this._serverIdPassword.length() == 0) {
                        String msg = this.getMsg(resBundle, "security.admintask.missingParameter.userRegistry.SECJ7770E", new Object[]{"serverIdPassword"});
                        throw new CommandValidationException(msg);
                    }
                    this.serverIdPassword = this._serverIdPassword;
                }
                if (this._krb5Spn == null || this._krb5Spn.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Auth.SECJ7771E", new Object[]{"krb5Spn"});
                    throw new CommandValidationException(msg);
                }
                this.krb5Spn = this._krb5Spn;
                if (this.krb5Config == null || this.krb5Config.length() == 0) {
                    if (this._krb5Config == null || this._krb5Config.length() == 0) {
                        String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Auth.SECJ7771E", new Object[]{"krb5Config"});
                        throw new CommandValidationException(msg);
                    }
                    this.krb5Config = this._krb5Config;
                }
                if (this.krb5Config != null && this.krb5Config.length() > 0) {
                    if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
                        if (this._krb5Keytab == null || this._krb5Keytab.length() == 0) {
                            String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity.SECJ7785E", new Object[]{"Keytab", this.krb5Config});
                            throw new CommandValidationException(msg);
                        }
                        this.krb5Keytab = this._krb5Keytab;
                    }
                    if (this.krb5Realm == null || this.krb5Realm.length() == 0) {
                        if (this._krb5Realm == null || this._krb5Realm.length() == 0) {
                            String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity.SECJ7785E", new Object[]{"krb5Realm", this.krb5Config});
                            throw new CommandValidationException(msg);
                        }
                        this.krb5Realm = this._krb5Realm;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "*** use security.xml instead of input parameters ***");
                    Tr.debug(tc, "securityDomainName name is " + this.secDomain);
                    Tr.debug(tc, "useGlobalSecurityConfig:  " + this.useGlobalSecurityConfig);
                    Tr.debug(tc, "validateKrbRealm:  " + this.validateKrbRealm);
                    Tr.debug(tc, "serverId:  " + this.serverId);
                    Tr.debug(tc, "serverIdPassword:  " + (this.serverIdPassword == null ? "null" : "*****"));
                    Tr.debug(tc, "krb5Spn:  " + this.krb5Spn);
                    Tr.debug(tc, "unexpand krb5Config:  " + this.uxpKrb5Config);
                    Tr.debug(tc, "krb5Config:  " + this.krb5Config);
                    Tr.debug(tc, "unexpand krb5Keytab:  " + this.uxpKrb5Keytab);
                    Tr.debug(tc, "krb5Keytab:  " + this.krb5Keytab);
                    Tr.debug(tc, "krb5Realm:  " + this.krb5Realm);
                }
            }
            if (this.krb5Spn != null && !this.krb5Spn.contains("/")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The format of the Kerberos service principal name " + this.krb5Spn + "is invalid");
                }
                String msg = this.getMsg(resBundle, "security.admintask.invalid.SPN.SECJ7767E", new Object[]{this.krb5Spn});
                throw new CommandValidationException(msg);
            }
            if (this.krb5Config != null && this.krb5Config.length() > 0 && !(config = new File(this.krb5Config)).exists()) {
                String msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Config});
                throw new CommandValidationException(msg);
            }
            if (this.krb5Keytab != null && this.krb5Keytab.length() > 0 && !(keytab = new File(this.krb5Keytab)).exists()) {
                String msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Keytab});
                throw new CommandValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String krb5DefaultRealm;
            if (this.checkConfigOnly) {
                if (this._configured) {
                    result.setResult(new Boolean(true));
                } else {
                    result.setResult(new Boolean(false));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            if (!this.useGlobalSecurityConfig) {
                if (this.krb5Spn == null || this.krb5Spn.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Auth.SECJ7771E", new Object[]{"krb5Spn"});
                    throw new CommandValidationException(msg);
                }
                if (this.krb5Config == null || this.krb5Config.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Auth.SECJ7771E", new Object[]{"krb5Config"});
                    throw new CommandValidationException(msg);
                }
                if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity.SECJ7785E", new Object[]{"Keytab", this.krb5Config});
                    throw new CommandValidationException(msg);
                }
            }
            if ((krb5DefaultRealm = Krb5Utils.getDefaultRealm(this.krb5Config)) == null || krb5DefaultRealm.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Config.SECJ7772E", new Object[]{"Kerberos realm", this.krb5Config});
                throw new CommandValidationException(msg);
            }
            if (this.validateKrbRealm && this.krb5Realm != null && this.krb5Realm.length() > 0 && !this.krb5Realm.equals(krb5DefaultRealm)) {
                String msg = this.getMsg(resBundle, "security.admintask.mismatch.krbRealm.SECJ7768E", new Object[]{this.krb5Realm, this.krb5Config, krb5DefaultRealm});
                throw new CommandValidationException(msg);
            }
            if (this._useRegServerId && this.serverId != null && this.serverId.length() > 0 && this.serverIdPassword != null && this.serverIdPassword.length() > 0) {
                try {
                    LoginContext lc = new LoginContext("WSKRB5Login", new NonPromptCallbackHandler(this.krb5Realm, this.serverId, this.serverIdPassword));
                    lc.login();
                    Subject subject = lc.getSubject();
                }
                catch (WSLoginFailedException wlfe) {
                    FFDCFilter.processException((Throwable)wlfe, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "368", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, wlfe.getMessage(), new Object[]{wlfe});
                    }
                    throw wlfe;
                }
                catch (LoginException le) {
                    FFDCFilter.processException((Throwable)le, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "372", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, le.getMessage(), new Object[]{le});
                    }
                    throw le;
                }
            }
            if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
                this.krb5Keytab = Krb5Utils.getDefaultKeytab(this.krb5Config);
            }
            if (this.krb5Keytab == null && this.krb5Keytab.length() == 0) {
                String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5Config.SECJ7772E", new Object[]{"Kerberos keytab", this.krb5Config});
                throw new CommandValidationException(msg);
            }
            try {
                Oid krb5MechanismOid = Krb5Utils.getKrb5MechOid();
                Oid spnegoMechanismOid = Krb5Utils.getSpnegoMechOid();
                Krb5Utils.setUseSubjectCredsOnly(false);
                Krb5Utils.setKrbKeytabProp(this.krb5Keytab);
                GSSManager mgr = GSSManager.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "krb5Spn: " + this.krb5Spn);
                }
                GSSName gssName = mgr.createName(this.krb5Spn.replace("/", "@"), GSSName.NT_HOSTBASED_SERVICE, krb5MechanismOid);
                GSSCredential krb5SpnGSSCred = mgr.createCredential(gssName.canonicalize(krb5MechanismOid), Integer.MAX_VALUE, krb5MechanismOid, 2);
                krb5SpnGSSCred.add(gssName.canonicalize(spnegoMechanismOid), Integer.MAX_VALUE, Integer.MAX_VALUE, spnegoMechanismOid, 2);
                Krb5Utils.setUseSubjectCredsOnly(true);
            }
            catch (GSSException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "427", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, exc.getMessage(), new Object[]{exc});
                }
                throw exc;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "431", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
                throw e;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "439", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        result.setResult(new Boolean(true));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void getKrbConfigInThisSession() {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKrbConfigInThisSession");
            }
            try {
                ObjectName activeUserRegistryObj;
                ObjectName security2 = null;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session s = this.getConfigSession();
                security2 = this.secDomain != null ? SecConfigTaskHelper.getSecDomain(s, cs, this.secDomain) : SecConfigTaskHelper.getSecurityObjectName(s, cs);
                if (security2 == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{this.secDomain});
                    throw new CommandValidationException(msg);
                }
                ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "KRB5");
                if (krb5AuthMechObj != null) {
                    this._uxpKrb5Config = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Config", false);
                    this._krb5Config = ConfigUtils.expandKrbFile(this._uxpKrb5Config);
                    if (this._krb5Config != null && this._krb5Config.length() > 0) {
                        this._uxpKrb5Keytab = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Keytab", false);
                        this._krb5Keytab = ConfigUtils.expandKrbFile(this._uxpKrb5Keytab);
                        if (this._krb5Keytab == null || this._krb5Keytab.length() == 0) {
                            this._krb5Keytab = Krb5Utils.getDefaultKeytab(this._krb5Config);
                        }
                        this._krb5Realm = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Realm", false);
                        if (this._krb5Realm == null || this._krb5Realm.length() == 0) {
                            this._krb5Realm = Krb5Utils.getDefaultRealm(this._krb5Config);
                        }
                    }
                    String spn = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Spn", false);
                    this._krb5Spn = ConfigUtils.expandHost(spn, null);
                    this._configured = (Boolean)cs.getAttribute(s, krb5AuthMechObj, "configured", false);
                }
                if ((activeUserRegistryObj = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry")) != null) {
                    this._useRegServerId = (Boolean)cs.getAttribute(s, activeUserRegistryObj, "useRegistryServerId", false);
                    this._serverId = (String)cs.getAttribute(s, activeUserRegistryObj, "serverId", false);
                    this._serverIdPassword = (String)cs.getAttribute(s, activeUserRegistryObj, "serverPassword", false);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_uxpKrb5Config: " + this._uxpKrb5Config);
                    Tr.debug(tc, "_krb5Config: " + this._krb5Config);
                    Tr.debug(tc, "_uxpKrb5Keytab: " + this._uxpKrb5Keytab);
                    Tr.debug(tc, "_krb5Keytab: " + this._krb5Keytab);
                    Tr.debug(tc, "_krb5Realm: " + this._krb5Realm);
                    Tr.debug(tc, "_useRegServerId: " + this._useRegServerId);
                    Tr.debug(tc, "_serverId: " + this._serverId);
                    Tr.debug(tc, "_serverIdPassword: " + (this._serverIdPassword == null ? "null" : "*****"));
                    Tr.debug(tc, "_configured: " + this._configured);
                }
            }
            catch (CommandValidationException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "519", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command validation exception occurred.", new Object[]{ex});
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "524", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKrbConfigInThisSession");
        }
    }
}

