/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKrbAuthMechanism
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(DeleteKrbAuthMechanism.class, "DeleteKrbAuthMechanism", "com.ibm.ws.security.auth.kerberos.admintask");
    static final String krb5LoginModuleWrapper = "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper";
    static final String wsKrb5LoginModule = "com.ibm.ws.security.auth.kerberos.WSKrb5LoginModule";
    static final String ltpaLoginModule = "com.ibm.ws.security.server.lm.ltpaLoginModule";
    static final String delimiter = "|";
    String krb5Realm = null;
    String krb5Config = null;
    String krb5Keytab = null;
    String serviceName = null;
    String krb5Spn = null;
    Boolean trimUserName = true;
    Boolean enabledGssCredDelegate = true;

    public DeleteKrbAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteKrbAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            security2 = cs.resolve(s, "Cell=:Security=")[0];
            AttributeList attrList2 = new AttributeList();
            ArrayList authMechs = (ArrayList)cs.getAttribute(s, security2, "authMechanisms");
            for (int i = 0; i < authMechs.size(); ++i) {
                AttributeList authAttrs = (AttributeList)authMechs.get(i);
                Object authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authObj: " + authObj.toString());
                }
                if (authObj.toString().equalsIgnoreCase("ltpa")) {
                    ObjectName[] ltpaObjName = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(authAttrs), null);
                    attrList2.clear();
                    attrList2.add(new Attribute("activeAuthMechanism", ltpaObjName[0]));
                    cs.setAttributes(s, security2, attrList2);
                    continue;
                }
                if (!authObj.toString().equalsIgnoreCase("krb5")) continue;
                ObjectName[] krb5ObjName = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(authAttrs), null);
                boolean spnegoEnabled = false;
                ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "SPNEGO");
                if (spnegoAuthMechObj != null) {
                    attrList2.clear();
                    attrList2.add(new Attribute("OID", null));
                    attrList2.add(new Attribute("authContextImplClass", null));
                    attrList2.add(new Attribute("authConfig", null));
                    attrList2.add(new Attribute("simpleAuthConfig", null));
                    attrList2.add(new Attribute("authValidationConfig", null));
                    attrList2.add(new Attribute("krb5Realm", null));
                    attrList2.add(new Attribute("krb5Spn", null));
                    attrList2.add(new Attribute("trimUserName", null));
                    attrList2.add(new Attribute("enabledGssCredDelegate", null));
                    attrList2.add(new Attribute("configured", false));
                    cs.setAttributes(s, krb5ObjName[0], attrList2);
                    continue;
                }
                cs.deleteConfigData(s, krb5ObjName[0]);
            }
            ObjectName[] JAASConfigurationEntries = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(null, "JAASConfigurationEntry"), null);
            for (int i = 0; i < JAASConfigurationEntries.length; ++i) {
                Object alias = cs.getAttribute(s, JAASConfigurationEntries[i], "alias");
                if (alias == null || !alias.toString().equals("WEB_INBOUND") && !alias.toString().equals("RMI_INBOUND") && !alias.toString().equals("DEFAULT")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAASConfigurationEntries: " + JAASConfigurationEntries[i]);
                }
                AttributeList entriesAttrList = cs.getAttributes(s, JAASConfigurationEntries[i], null, true);
                for (Attribute entriesAttr : entriesAttrList) {
                    boolean ltpaLoginModuleExist = false;
                    if (!entriesAttr.getName().equals("loginModules")) continue;
                    List loginModulesList = (List)entriesAttr.getValue();
                    for (AttributeList attrList2 : loginModulesList) {
                        ObjectName[] loginModuleObjs = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(attrList2), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "loginModuleObjs: " + loginModuleObjs);
                        }
                        if (loginModuleObjs == null || loginModuleObjs.length == 0) continue;
                        Object moduleClassName = cs.getAttribute(s, loginModuleObjs[0], "moduleClassName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleClassName: " + moduleClassName.toString());
                        }
                        if (krb5LoginModuleWrapper.equals(moduleClassName.toString()) || wsKrb5LoginModule.equals(moduleClassName.toString())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Delete moduleClassName: " + moduleClassName.toString());
                            }
                            cs.deleteConfigData(s, loginModuleObjs[0]);
                        }
                        if (!ltpaLoginModule.equals(moduleClassName.toString())) continue;
                        ltpaLoginModuleExist = true;
                    }
                    if (ltpaLoginModuleExist) continue;
                    attrList2.clear();
                    attrList2.add(new Attribute("moduleClassName", ltpaLoginModule));
                    attrList2.add(new Attribute("authenticationStrategy", "REQUIRED"));
                    cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 0);
                }
            }
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand getUserCmd = null;
            CommandResult cmdResult = null;
            String supportedAuthMechList = null;
            String newAuthMechs = null;
            attrList2.clear();
            attrList2 = (AttributeList)cs.getAttribute(s, security2, "CSI");
            ObjectName csiObj = cs.queryConfigObjects(s, security2, ConfigServiceHelper.createObjectName(attrList2), null)[0];
            AttributeList claims = (AttributeList)cs.getAttribute(s, csiObj, "claims");
            ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(claims, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI inbound, supportedAuthMechList: " + supportedAuthMechList);
            }
            if ((supportedAuthMechList = supportedAuthMechList.toLowerCase()) != null && supportedAuthMechList.length() != 0 && supportedAuthMechList.contains("krb5")) {
                newAuthMechs = supportedAuthMechList.contains("krb5|") ? supportedAuthMechList.replace("krb5|", "") : (supportedAuthMechList.contains("|krb5") ? supportedAuthMechList.replace("|krb5", "") : supportedAuthMechList.replace("krb5", ""));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI inbound, update supportedAuthMechList: " + newAuthMechs);
                }
                getUserCmd = commandMgr.createCommand("configureCSIInbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI inbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI inbound", new Object[]{e.getMessage()});
                }
            }
            AttributeList performs = (AttributeList)cs.getAttribute(s, csiObj, "performs");
            layers = (ArrayList)ConfigServiceHelper.getAttributeValue(performs, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI outbound, supportedAuthMechList " + supportedAuthMechList);
            }
            if ((supportedAuthMechList = supportedAuthMechList.toLowerCase()) != null && supportedAuthMechList.length() != 0 && supportedAuthMechList.contains("krb5")) {
                newAuthMechs = supportedAuthMechList.contains("krb5|") ? supportedAuthMechList.replace("krb5|", "") : (supportedAuthMechList.contains("|krb5") ? supportedAuthMechList.replace("|krb5", "") : supportedAuthMechList.replace("krb5", ""));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI outbound, update supportedAuthMechList: " + newAuthMechs);
                }
                getUserCmd = commandMgr.createCommand("configureCSIOutbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI outbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI outbound", new Object[]{e.getMessage()});
                }
            }
            result.setResult(new Boolean(true));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.DeleteKrbAuthMechanism.afterStepsExecuted", "297", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

