/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKrbAuthMechanism
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateKrbAuthMechanism.class, "CreateKrbAuthMechanism", "com.ibm.ws.security.auth.kerberos.admintask");
    static final String krb5LoginModuleWrapper = "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper";
    static final String wsKrb5LoginModule = "com.ibm.ws.security.auth.kerberos.WSKrb5LoginModule";
    static final String ltpaLoginModule = "com.ibm.ws.security.server.lm.ltpaLoginModule";
    static final String pdLoginModuleWrapper = "com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper";
    static final String delimiter = "|";
    String krb5Realm = null;
    String uxpKrb5Config = null;
    String krb5Config = null;
    String uxpKrb5Keytab = null;
    String krb5Keytab = null;
    String serviceName = null;
    String krb5Spn = null;
    Boolean trimUserName = true;
    Boolean enabledGssCredDelegate = true;
    Boolean allowKrbAuthForCsiInbound = true;
    Boolean allowKrbAuthForCsiOutbound = true;
    private String _uxpKrb5Config = null;
    private String _krb5Config = null;
    private String _uxpKrb5Keytab = null;
    private String _krb5Keytab = null;
    private String _krb5Realm = null;
    private String _krb5Spn = null;
    private String _serverId = null;
    private String _serverIdPassword = null;
    private boolean _useRegServerId = false;
    private String defaultKrb5Realm = null;
    private String defaultKrb5Keytab = null;

    public CreateKrbAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateKrbAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.krb5Realm = (String)this.getParameter("krb5Realm");
        this.uxpKrb5Config = (String)this.getParameter("krb5Config");
        this.krb5Config = ConfigUtils.expandKrbFile(this.uxpKrb5Config);
        this.uxpKrb5Keytab = (String)this.getParameter("krb5Keytab");
        this.krb5Keytab = ConfigUtils.expandKrbFile(this.uxpKrb5Keytab);
        this.serviceName = (String)this.getParameter("serviceName");
        this.trimUserName = (Boolean)this.getParameter("trimUserName");
        this.enabledGssCredDelegate = (Boolean)this.getParameter("enabledGssCredDelegate");
        this.allowKrbAuthForCsiInbound = (Boolean)this.getParameter("allowKrbAuthForCsiInbound");
        this.allowKrbAuthForCsiOutbound = (Boolean)this.getParameter("allowKrbAuthForCsiOutbound");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unexpand krb5Config:  " + this.uxpKrb5Config);
            Tr.debug(tc, "krb5Config:  " + this.krb5Config);
            Tr.debug(tc, "krb5Realm:  " + this.krb5Realm);
            Tr.debug(tc, "unexpand krb5Keytab:  " + this.uxpKrb5Keytab);
            Tr.debug(tc, "krb5Keytab:  " + this.krb5Keytab);
            Tr.debug(tc, "serviceName:  " + this.serviceName);
            Tr.debug(tc, "trimUserName:  " + this.trimUserName);
            Tr.debug(tc, "enabledGssCredDelegate:  " + this.enabledGssCredDelegate);
            Tr.debug(tc, "allowKrbAuthForCsiInbound:  " + this.allowKrbAuthForCsiInbound);
            Tr.debug(tc, "allowKrbAuthForCsiOutbound:  " + this.allowKrbAuthForCsiOutbound);
        }
        try {
            if (this.krb5Realm == null || this.krb5Realm.length() == 0) {
                if (this.krb5Config != null && this.krb5Config.length() > 0) {
                    this.defaultKrb5Realm = Krb5Utils.getDefaultRealm(this.krb5Config);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "default_realm is: " + this.defaultKrb5Realm + " in " + this.krb5Config);
                }
                if (this.defaultKrb5Realm == null || this.defaultKrb5Realm.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity.SECJ7785E", new Object[]{"default_realm", this.krb5Config});
                    Tr.error(tc, msg);
                    throw new CommandValidationException(msg);
                }
            }
            if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
                if (this.krb5Config != null && this.krb5Config.length() > 0) {
                    this.defaultKrb5Keytab = Krb5Utils.getDefaultKeytab(this.krb5Config);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "default_keytab_name is: " + this.defaultKrb5Keytab + " in " + this.krb5Config);
                }
                if (this.defaultKrb5Keytab == null || this.defaultKrb5Keytab.length() == 0) {
                    String msg = this.getMsg(resBundle, "security.admintask.missingParameter.krb5ConfigAndSecurity.SECJ7785E", new Object[]{"default_keytab_name", this.krb5Config});
                    Tr.error(tc, msg);
                    throw new CommandValidationException(msg);
                }
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (this.serviceName != null && this.serviceName.contains("/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The service name contains a char slash");
            }
            String msg = this.getMsg(resBundle, "security.admintask.invalid.serviceName", new Object[]{this.serviceName});
            throw new CommandValidationException(msg);
        }
        if (this.serviceName != null) {
            this.krb5Spn = this.serviceName + "/${HOST}";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "krb5Spn:  " + this.krb5Spn);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        File keytab;
        String msg;
        File config;
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean krb5LoginModuleWrapperExist = false;
        boolean wsKrb5LoginModuleExist = false;
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        if (this.krb5Config != null && this.krb5Config.length() != 0 && !(config = new File(this.krb5Config)).exists()) {
            msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Config});
            Tr.warning(tc, msg);
            result.addWarnings(msg);
        }
        if (this.krb5Keytab != null && this.krb5Keytab.length() != 0 && !(keytab = new File(this.krb5Keytab)).exists()) {
            msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Keytab});
            Tr.warning(tc, msg);
            result.addWarnings(msg);
        }
        try {
            Object moduleClassName;
            List loginModulesList;
            AttributeList entriesAttrList;
            Object alias;
            int i;
            boolean krb5ConfigMatch;
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            security2 = cs.resolve(s, "Cell=:Security=")[0];
            ObjectName activeUserRegistry = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry");
            String serverId = null;
            String serverIdPassword = null;
            boolean useRegServerId = (Boolean)cs.getAttribute(s, activeUserRegistry, "useRegistryServerId", false);
            if (useRegServerId) {
                serverId = (String)cs.getAttribute(s, activeUserRegistry, "serverId", false);
                serverIdPassword = (String)cs.getAttribute(s, activeUserRegistry, "serverPassword", false);
            }
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand getUserCmd = null;
            CommandResult cmdResult = null;
            String host = AdminHelper.getInstance().getHostName();
            getUserCmd = commandMgr.createCommand("validateKrbConfig");
            getUserCmd.setParameter("checkConfigOnly", false);
            getUserCmd.setParameter("validateKrbRealm", true);
            getUserCmd.setParameter("useGlobalSecurityConfig", false);
            if (serverId == null || serverId.length() == 0 || serverIdPassword == null || serverIdPassword.length() == 0 || this.serviceName == null || this.serviceName.length() == 0 || this.krb5Config == null || this.krb5Config.length() == 0 || this.krb5Keytab == null || this.krb5Keytab.length() == 0 || this.krb5Realm == null || this.krb5Realm.length() == 0) {
                this.getKrbConfigInThisSession(s, cs, security2);
            }
            if (serverId != null && serverId.length() > 0) {
                getUserCmd.setParameter("serverId", serverId);
            } else {
                getUserCmd.setParameter("serverId", this._serverId);
            }
            if (serverIdPassword != null && serverIdPassword.length() > 0) {
                getUserCmd.setParameter("serverIdPassword", serverIdPassword);
            } else {
                getUserCmd.setParameter("serverIdPassword", this._serverIdPassword);
            }
            if (this.serviceName != null && this.serviceName.length() > 0) {
                getUserCmd.setParameter("krb5Spn", this.serviceName + "/" + host);
            } else {
                getUserCmd.setParameter("krb5Spn", this._krb5Spn);
            }
            if (this.uxpKrb5Config != null && this.uxpKrb5Config.length() > 0) {
                getUserCmd.setParameter("krb5Config", this.uxpKrb5Config);
            } else {
                getUserCmd.setParameter("krb5Config", this._uxpKrb5Config);
            }
            if (this.uxpKrb5Keytab != null && this.uxpKrb5Keytab.length() > 0) {
                getUserCmd.setParameter("krb5Keytab", this.uxpKrb5Keytab);
            } else if (this._uxpKrb5Keytab != null && this._uxpKrb5Keytab.length() > 0) {
                getUserCmd.setParameter("krb5Keytab", this._uxpKrb5Keytab);
            } else {
                getUserCmd.setParameter("krb5Keytab", this.defaultKrb5Keytab);
            }
            if (this.krb5Realm != null && this.krb5Realm.length() > 0) {
                getUserCmd.setParameter("krb5Realm", this.krb5Realm);
            } else if (this._krb5Realm != null && this._krb5Realm.length() > 0) {
                getUserCmd.setParameter("krb5Realm", this._krb5Realm);
            } else {
                getUserCmd.setParameter("krb5Realm", this.defaultKrb5Realm);
            }
            getUserCmd.setConfigSession(s);
            getUserCmd.execute();
            cmdResult = getUserCmd.getCommandResult();
            if (!cmdResult.isSuccessful()) {
                Throwable e = cmdResult.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating Kerberos configuration failed", new Object[]{e});
                }
                Tr.error(tc, "Validating Kerberos configuration failed", new Object[]{e.getMessage()});
                throw new CommandValidationException(e.getMessage());
            }
            boolean spnegoEnabled = false;
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "SPNEGO");
            if (spnegoAuthMechObj != null) {
                spnegoEnabled = (Boolean)cs.getAttribute(s, spnegoAuthMechObj, "enabled", false);
            }
            if (spnegoEnabled && !(krb5ConfigMatch = this.krb5ConfigEquals(s, cs, security2, this.krb5Config, this.krb5Keytab))) {
                getUserCmd = commandMgr.createCommand("validateSpnegoConfig");
                getUserCmd.setParameter("krb5Config", this.krb5Config);
                getUserCmd.setParameter("krb5Keytab", this.krb5Keytab);
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating SPNEGO Web auth configuration with the new Kerberos configuration failed", new Object[]{e});
                    }
                    Tr.error(tc, "Validating SPNEGO Web auth with the new Kerberos configuration failed", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            AttributeList attrList2 = new AttributeList();
            ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "KRB5");
            if (krb5AuthMechObj == null) {
                krb5AuthMechObj = CreateKrbAuthMechanism.createDefaultKrb5AuthMechObj(s, cs, security2);
            } else {
                attrList2.add(new Attribute("activeAuthMechanism", krb5AuthMechObj));
                cs.setAttributes(s, security2, attrList2);
            }
            attrList2.clear();
            attrList2.add(new Attribute("OID", "oid:1.2.840.113554.1.2.2"));
            attrList2.add(new Attribute("authContextImplClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl"));
            attrList2.add(new Attribute("authConfig", "system.KRB5"));
            attrList2.add(new Attribute("simpleAuthConfig", "system.KRB5"));
            attrList2.add(new Attribute("authValidationConfig", "system.KRB5"));
            attrList2.add(new Attribute("krb5Realm", this.krb5Realm));
            attrList2.add(new Attribute("krb5Config", this.uxpKrb5Config));
            attrList2.add(new Attribute("krb5Keytab", this.uxpKrb5Keytab));
            attrList2.add(new Attribute("krb5Spn", this.krb5Spn));
            attrList2.add(new Attribute("trimUserName", this.trimUserName));
            attrList2.add(new Attribute("enabledGssCredDelegate", this.enabledGssCredDelegate));
            attrList2.add(new Attribute("configured", true));
            cs.setAttributes(s, krb5AuthMechObj, attrList2);
            ObjectName[] JAASConfigurationEntries = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(null, "JAASConfigurationEntry"), null);
            for (i = 0; i < JAASConfigurationEntries.length; ++i) {
                alias = cs.getAttribute(s, JAASConfigurationEntries[i], "alias");
                if (alias == null || !alias.toString().equals("WEB_INBOUND") && !alias.toString().equals("RMI_INBOUND") && !alias.toString().equals("DEFAULT")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAASConfigurationEntries: " + JAASConfigurationEntries[i]);
                }
                entriesAttrList = cs.getAttributes(s, JAASConfigurationEntries[i], null, true);
                for (Attribute entriesAttr : entriesAttrList) {
                    if (!entriesAttr.getName().equals("loginModules")) continue;
                    loginModulesList = (List)entriesAttr.getValue();
                    for (AttributeList attrList2 : loginModulesList) {
                        ObjectName[] loginModuleObjs = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(attrList2), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "loginModuleObjs: " + loginModuleObjs);
                        }
                        if (loginModuleObjs == null || loginModuleObjs.length == 0) continue;
                        moduleClassName = cs.getAttribute(s, loginModuleObjs[0], "moduleClassName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleClassName: " + moduleClassName.toString());
                        }
                        if (krb5LoginModuleWrapper.equals(moduleClassName.toString())) {
                            krb5LoginModuleWrapperExist = true;
                        }
                        if (!wsKrb5LoginModule.equals(moduleClassName.toString())) continue;
                        wsKrb5LoginModuleExist = true;
                    }
                    if (!krb5LoginModuleWrapperExist) {
                        attrList2.clear();
                        attrList2.add(new Attribute("moduleClassName", krb5LoginModuleWrapper));
                        attrList2.add(new Attribute("authenticationStrategy", "REQUIRED"));
                        cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 0);
                    }
                    if (wsKrb5LoginModuleExist) continue;
                    attrList2.clear();
                    attrList2.add(new Attribute("moduleClassName", wsKrb5LoginModule));
                    attrList2.add(new Attribute("authenticationStrategy", "REQUIRED"));
                    cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 1);
                }
            }
            JAASConfigurationEntries = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(null, "JAASConfigurationEntry"), null);
            if (!krb5LoginModuleWrapperExist) {
                for (i = 0; i < JAASConfigurationEntries.length; ++i) {
                    alias = (String)cs.getAttribute(s, JAASConfigurationEntries[i], "alias");
                    if (alias == null || !((String)alias).equals("WEB_INBOUND") && !((String)alias).equals("RMI_INBOUND") && !((String)alias).equals("DEFAULT")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "alias: " + (String)alias);
                    }
                    entriesAttrList = cs.getAttributes(s, JAASConfigurationEntries[i], null, true);
                    for (Attribute entriesAttr : entriesAttrList) {
                        if (!entriesAttr.getName().equals("loginModules")) continue;
                        loginModulesList = (List)entriesAttr.getValue();
                        for (AttributeList attrList2 : loginModulesList) {
                            ObjectName[] jaasLoginModules = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(attrList2), null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "jaasLoginModules: " + jaasLoginModules);
                            }
                            if (jaasLoginModules == null || jaasLoginModules.length == 0) continue;
                            moduleClassName = (String)cs.getAttribute(s, jaasLoginModules[0], "moduleClassName");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "moduleClassName: " + ((String)moduleClassName).toString());
                            }
                            if (!krb5LoginModuleWrapper.equals(moduleClassName)) continue;
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "storeSharedStateCredentials"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "refreshKrb5Config"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "credsType"));
                            attrList2.add(new Attribute("value", "both"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "tryFirstPass"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "renewable"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "forwardable"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                            attrList2.clear();
                            attrList2.add(new Attribute("name", "noAddress"));
                            attrList2.add(new Attribute("value", "true"));
                            attrList2.add(new Attribute("required", false));
                            cs.addElement(s, jaasLoginModules[0], "options", attrList2, -1);
                        }
                    }
                }
            }
            String supportedAuthMechList = null;
            String newAuthMechs = null;
            boolean krbAuthExist = false;
            attrList2.clear();
            attrList2 = (AttributeList)cs.getAttribute(s, security2, "CSI");
            ObjectName csiObj = cs.queryConfigObjects(s, security2, ConfigServiceHelper.createObjectName(attrList2), null)[0];
            AttributeList claims = (AttributeList)cs.getAttribute(s, csiObj, "claims");
            ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(claims, "layers");
            for (int i2 = 0; i2 < layers.size(); ++i2) {
                AttributeList layer = (AttributeList)layers.get(i2);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI inbound, supportedAuthMechList: " + supportedAuthMechList);
            }
            if (supportedAuthMechList != null && supportedAuthMechList.length() != 0 && (supportedAuthMechList = supportedAuthMechList.toLowerCase()).contains("krb5")) {
                krbAuthExist = true;
            }
            newAuthMechs = supportedAuthMechList;
            if (krbAuthExist) {
                if (!this.allowKrbAuthForCsiInbound.booleanValue()) {
                    newAuthMechs = supportedAuthMechList.replace("krb5|", "");
                }
            } else if (this.allowKrbAuthForCsiInbound.booleanValue()) {
                newAuthMechs = "krb5|" + supportedAuthMechList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI inbound, update supportedAuthMechList: " + newAuthMechs);
            }
            if (newAuthMechs != null) {
                getUserCmd = null;
                cmdResult = null;
                getUserCmd = commandMgr.createCommand("configureCSIInbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI inbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI inbound", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            supportedAuthMechList = null;
            newAuthMechs = null;
            krbAuthExist = false;
            AttributeList performs = (AttributeList)cs.getAttribute(s, csiObj, "performs");
            layers = (ArrayList)ConfigServiceHelper.getAttributeValue(performs, "layers");
            for (int i3 = 0; i3 < layers.size(); ++i3) {
                AttributeList layer = (AttributeList)layers.get(i3);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI outbound, supportedAuthMechList " + supportedAuthMechList);
            }
            if (supportedAuthMechList != null && supportedAuthMechList.length() != 0 && (supportedAuthMechList = supportedAuthMechList.toLowerCase()).contains("krb5")) {
                krbAuthExist = true;
            }
            newAuthMechs = supportedAuthMechList;
            if (krbAuthExist) {
                if (!this.allowKrbAuthForCsiOutbound.booleanValue()) {
                    newAuthMechs = supportedAuthMechList.replace("krb5|", "");
                }
            } else if (this.allowKrbAuthForCsiOutbound.booleanValue()) {
                newAuthMechs = "krb5|" + supportedAuthMechList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI outbound, update supportedAuthMechList " + newAuthMechs);
            }
            if (newAuthMechs != null) {
                getUserCmd = null;
                cmdResult = null;
                getUserCmd = commandMgr.createCommand("configureCSIOutbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI outbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI outbound", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            result.setResult(new Boolean(true));
        }
        catch (CommandValidationException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "580", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command validation exception occurred.", new Object[]{ex});
            }
            result.setException(new CommandException(ex, ex.getMessage()));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "586", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public boolean krb5ConfigEquals(Session session, ConfigService configService, ObjectName securityObj, String krb5Config, String krb5Keytab) throws Exception {
        ObjectName krb5AuthMechObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "krb5ConfigEquals");
        }
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "krb5Config: " + krb5Config);
            Tr.debug(tc, "krb5Keytab: " + krb5Keytab);
        }
        if ((krb5AuthMechObj = Krb5Utils.getAuthMechObj(session, configService, securityObj, "KRB5")) != null) {
            String existed_krb5Config = ConfigUtils.expandKrbFile((String)configService.getAttribute(session, krb5AuthMechObj, "krb5Config", false));
            String existed_krb5Keytab = ConfigUtils.expandKrbFile((String)configService.getAttribute(session, krb5AuthMechObj, "krb5Keytab", false));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existed krb5Config: " + existed_krb5Config);
                Tr.debug(tc, "existed krb5Keytab: " + existed_krb5Keytab);
            }
            if (existed_krb5Config != null && existed_krb5Config.length() != 0 && existed_krb5Config.equalsIgnoreCase(krb5Config)) {
                if (!(existed_krb5Keytab != null && existed_krb5Keytab.length() != 0 || krb5Keytab != null && krb5Keytab.length() != 0)) {
                    result = true;
                } else if (existed_krb5Keytab != null && krb5Keytab != null && existed_krb5Keytab.equalsIgnoreCase(krb5Keytab)) {
                    result = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "krb5ConfigEquals " + result);
        }
        return result;
    }

    public static ObjectName createDefaultKrb5AuthMechObj(Session session, ConfigService configService, ObjectName securityObj) throws Exception {
        ObjectName krb5Obj;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createDefaultKrb5AuthMechObj");
            }
            krb5Obj = null;
            try {
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("OID", "oid:1.2.840.113554.1.2.2"));
                attrList.add(new Attribute("authContextImplClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl"));
                attrList.add(new Attribute("authConfig", "system.KRB5"));
                attrList.add(new Attribute("simpleAuthConfig", "system.KRB5"));
                attrList.add(new Attribute("authValidationConfig", "system.KRB5"));
                attrList.add(new Attribute("krb5Realm", null));
                attrList.add(new Attribute("krb5Config", null));
                attrList.add(new Attribute("krb5Keytab", null));
                krb5Obj = configService.createConfigData(session, securityObj, "authMechanisms", "KRB5", attrList);
            }
            catch (InvalidAttributeNameException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "createDefaultKrb5AuthMechObj caught an unexpected exception.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultKrb5AuthMechObj " + krb5Obj);
        }
        return krb5Obj;
    }

    public void getKrbConfigInThisSession(Session s, ConfigService cs, ObjectName security2) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getKrbConfigInThisSession");
            }
            try {
                ObjectName activeUserRegistryObj;
                ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "KRB5");
                if (krb5AuthMechObj != null) {
                    this._uxpKrb5Config = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Config", false);
                    this._krb5Config = ConfigUtils.expandKrbFile(this._uxpKrb5Config);
                    if (this._krb5Config != null && this._krb5Config.length() > 0) {
                        this._uxpKrb5Keytab = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Keytab", false);
                        this._krb5Keytab = ConfigUtils.expandKrbFile(this._uxpKrb5Keytab);
                        if (this._krb5Keytab == null || this._krb5Keytab.length() == 0) {
                            this._krb5Keytab = Krb5Utils.getDefaultKeytab(this._krb5Config);
                        }
                        this._krb5Realm = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Realm", false);
                        if (this._krb5Realm == null || this._krb5Realm.length() == 0) {
                            this._krb5Realm = Krb5Utils.getDefaultRealm(this._krb5Config);
                        }
                    }
                    String spn = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Spn", false);
                    this._krb5Spn = ConfigUtils.expandHost(spn, null);
                }
                if ((activeUserRegistryObj = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry")) != null) {
                    this._useRegServerId = (Boolean)cs.getAttribute(s, activeUserRegistryObj, "useRegistryServerId", false);
                    this._serverId = (String)cs.getAttribute(s, activeUserRegistryObj, "serverId", false);
                    this._serverIdPassword = (String)cs.getAttribute(s, activeUserRegistryObj, "serverPassword", false);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_uxpKrb5Config: " + this._uxpKrb5Config);
                    Tr.debug(tc, "_krb5Config: " + this._krb5Config);
                    Tr.debug(tc, "_uxpKrb5Keytab: " + this._uxpKrb5Keytab);
                    Tr.debug(tc, "_krb5Keytab: " + this._krb5Keytab);
                    Tr.debug(tc, "_krb5Realm: " + this._krb5Realm);
                    Tr.debug(tc, "_useRegServerId: " + this._useRegServerId);
                    Tr.debug(tc, "_serverId: " + this._serverId);
                    Tr.debug(tc, "_serverIdPassword: " + (this._serverIdPassword == null ? "null" : "*****"));
                }
            }
            catch (CommandValidationException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "790", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command validation exception occurred.", new Object[]{ex});
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.CreateKrbAuthMechanism.afterStepsExecuted", "795", this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKrbConfigInThisSession");
        }
    }
}

