/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class WSKrb5LoginModule
implements LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private WSPrincipal _principal;
    private WSCredential _credential;
    private GSSCredential _gssCred = null;
    private KerberosTicket _kTicket = null;
    private KerberosPrincipal _kPrinc = null;
    private String mapUid = null;
    private String _racfId = null;
    private String _loginUser = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    protected boolean validatedone = false;
    protected boolean authenticatedone = false;
    private boolean isKerberosLogin = true;
    private boolean skipCreateWSCredential = false;
    protected boolean debug = true;
    private static final TraceComponent tc = Tr.register(WSKrb5LoginModule.class, null, "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public WSKrb5LoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKrb5LoginModule()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKrb5LoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        this._sharedState = sharedState;
        this._options = options;
        this.debug = "true".equalsIgnoreCase((String)this._options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        byte[] tmpCred;
        char[] tmp;
        ContextManager contextManager;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if (!(contextManager = ContextManagerFactory.getInstance()).isCellSecurityEnabled()) {
            try {
                Tr.warning(tc, "security.disabled.during.login");
                if (tc.isDebugEnabled()) {
                    Thread.dumpStack();
                }
                Subject unAuthSubject = SubjectHelper.createUnauthenticatedSubject();
                this._credential = SubjectHelper.getWSCredentialFromSubject(unAuthSubject);
                this._principal = SubjectHelper.createPrincipal(this._credential);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating principal.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.WSKrb5LoginModule.login", "245", this);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            this._sharedState.put("WSPrincipal", this._principal);
            this._sharedState.put("WSCredential", this._credential);
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "login(security disabled)");
            }
            return this.succeeded;
        }
        Iterator keys = this._sharedState.keySet().iterator();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "shared state contains: " + this._sharedState.keySet());
        }
        if (this.commitSucceeded) {
            this.succeeded = false;
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if (this._callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to gather authentication information from the user.");
        }
        NameCallback nameCallback = null;
        PasswordCallback passwordCallback = null;
        WSCredTokenCallbackImpl wsCredTokenCallback = null;
        WSServletRequestCallback wsServletRequestCallback = null;
        WSServletResponseCallback wsServletResponseCallback = null;
        WSAppContextCallback wsAppContextCallback = null;
        WSTokenHolderCallback wsTokenHolderCallback = null;
        WSRealmNameCallbackImpl wsRealmNameCallback = null;
        WSX509CertificateChainCallback wsX509CertificateCallback = null;
        WSAuthMechOidCallbackImpl wsAuthMechOidCallback = null;
        Callback[] callbacks = null;
        if (!this._sharedState.containsKey("Callback")) {
            if (this._callbackHandler == null) {
                WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                throw e;
            }
            callbacks = new Callback[10];
            nameCallback = new NameCallback("Username: ");
            callbacks[0] = nameCallback;
            passwordCallback = new PasswordCallback("Password: ", false);
            callbacks[1] = passwordCallback;
            wsCredTokenCallback = new WSCredTokenCallbackImpl("Credential Token: ");
            callbacks[2] = wsCredTokenCallback;
            wsServletRequestCallback = new WSServletRequestCallback("HttpServletRequest: ");
            callbacks[3] = wsServletRequestCallback;
            wsServletResponseCallback = new WSServletResponseCallback("HttpServletResponse: ");
            callbacks[4] = wsServletResponseCallback;
            wsAppContextCallback = new WSAppContextCallback("ApplicationContextCallback: ");
            callbacks[5] = wsAppContextCallback;
            wsTokenHolderCallback = new WSTokenHolderCallback("Authz Token List: ");
            callbacks[6] = wsTokenHolderCallback;
            wsRealmNameCallback = new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm());
            callbacks[7] = wsRealmNameCallback;
            wsX509CertificateCallback = new WSX509CertificateChainCallback("X509Certificate[]: ");
            callbacks[8] = wsX509CertificateCallback;
            wsAuthMechOidCallback = new WSAuthMechOidCallbackImpl("AuthMechOid: ");
            callbacks[9] = wsAuthMechOidCallback;
            try {
                this._callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "312", this);
                Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "317", this);
                Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
            }
            this._sharedState.put("Callback", callbacks);
        } else {
            callbacks = (Callback[])this._sharedState.get("Callback");
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] == null) continue;
                if (callbacks[i] instanceof NameCallback) {
                    nameCallback = (NameCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    passwordCallback = (PasswordCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                    wsCredTokenCallback = (WSCredTokenCallbackImpl)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSServletRequestCallback) {
                    wsServletRequestCallback = (WSServletRequestCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSServletResponseCallback) {
                    wsServletResponseCallback = (WSServletResponseCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSAppContextCallback) {
                    wsAppContextCallback = (WSAppContextCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSTokenHolderCallback) {
                    wsTokenHolderCallback = (WSTokenHolderCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                    wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSX509CertificateChainCallback) {
                    wsX509CertificateCallback = (WSX509CertificateChainCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSAuthMechOidCallbackImpl) {
                    wsAuthMechOidCallback = (WSAuthMechOidCallbackImpl)callbacks[i];
                    continue;
                }
                if (!this.debug && !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The following callback was ignored: " + callbacks[i].getClass().getName());
            }
        }
        String uid = null;
        String realm = null;
        char[] password = null;
        byte[] credToken = null;
        String authMechOid = null;
        X509Certificate[] certChain = null;
        List authzTokenList = null;
        if (wsAuthMechOidCallback != null) {
            authMechOid = wsAuthMechOidCallback.getAuthMechOid();
        }
        if (nameCallback != null) {
            uid = nameCallback.getName();
        }
        if (passwordCallback != null && (tmp = passwordCallback.getPassword()) != null && tmp.length != 0) {
            password = new char[tmp.length];
            System.arraycopy(tmp, 0, password, 0, tmp.length);
        }
        if (wsRealmNameCallback != null) {
            realm = wsRealmNameCallback.getRealmName();
        }
        if (wsCredTokenCallback != null && (tmpCred = wsCredTokenCallback.getCredToken()) != null) {
            credToken = CredentialsHelper.copyCredToken(tmpCred);
            if (authMechOid == null || authMechOid.length() == 0) {
                try {
                    authMechOid = GSSFactory.getMechOIDFromGSSToken(credToken);
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "authMechOid pass in is null, get authMechOid from the credToken: " + authMechOid);
                    }
                }
                catch (Exception e) {
                    Object[] parms = new Object[]{WSKrb5LoginModule.class, "credToken"};
                    throw new WSLoginFailedException("Get authMechOid from the credToken exception - " + e.getMessage(), e);
                }
            }
        }
        this.isKerberosLogin = Krb5Utils.isKrb5Login(authMechOid, uid);
        if (!this.isKerberosLogin) {
            this.succeeded = true;
            return this.succeeded;
        }
        if (wsX509CertificateCallback != null) {
            certChain = wsX509CertificateCallback.getX509CertificateChain();
        }
        if (wsTokenHolderCallback != null) {
            authzTokenList = wsTokenHolderCallback.getTokenHolderList();
        }
        this._gssCred = SubjectHelper.getGSSCredentialFromSubject(this._subject);
        Hashtable customProperties = (Hashtable)this._sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (customProperties == null) {
            try {
                final Subject subjectPriv = this._subject;
                customProperties = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                        if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < list_public.length; ++i) {
                            if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                            }
                            if (!(list_public[i] instanceof Hashtable) || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return list_public[i];
                        }
                        Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                        if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < list_private.length; ++i) {
                            if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                            }
                            if (!(list_private[i] instanceof Hashtable) || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return list_private[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.kerberos.wskrb5loginmodule.login", "468", this);
                contextManager.setRootException(e.getException());
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
        }
        if (customProperties != null) {
            this.mapUid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "sharedState mapUid: " + this.mapUid);
        }
        this._kTicket = (KerberosTicket)this._sharedState.get("javax.security.auth.kerberos.KerberosTicket");
        this._kPrinc = (KerberosPrincipal)this._sharedState.get("javax.security.auth.kerberos.KerberosPrincipal");
        if (this._kPrinc != null) {
            this._racfId = Krb5Utils.mapKerbPrincToRACF(this._kPrinc.toString(), this._gssCred);
            if (this._racfId != null) {
                this.mapUid = this._racfId;
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Map Kerberos principal to RACF id (mapUid): " + this.mapUid);
                }
                this._sharedState.put("com.ibm.wsspi.security.cred.userId", this.mapUid);
            }
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + uid);
            Tr.debug(tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(tc, "mapUid = " + this.mapUid);
            Tr.debug(tc, "_kPrinc = " + this._kPrinc);
            Tr.debug(tc, "_racfId = " + this._racfId);
            Tr.debug(tc, "realm = " + realm);
            Tr.debug(tc, "authMechOid = " + authMechOid);
            Tr.debug(tc, "cred token = " + (credToken != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "_kTicket = " + (this._kTicket != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "_gssCred = " + (this._gssCred != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "certChain = " + certChain);
            Tr.debug(tc, "customProperties = " + customProperties);
            Tr.debug(tc, "authz token list = " + authzTokenList);
        }
        if (certChain != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate pass in. Skipping WSKrb5LoginModule. Handling login outside this login module.");
            }
            this.isKerberosLogin = false;
            this.succeeded = true;
            return this.succeeded;
        }
        boolean isTrimUser = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("trimUserName");
        if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.uniqueId") != null) {
            String temp_uniqueid = null;
            if (customProperties != null) {
                temp_uniqueid = (String)customProperties.get("com.ibm.wsspi.security.cred.uniqueId");
            }
            if (temp_uniqueid != null && !temp_uniqueid.equals("") && this._gssCred != null) {
                this.createCredentialsFromHashtable(customProperties, this._gssCred);
                this._sharedState.put("WSCredential", this._credential);
                this._sharedState.put("WSPrincipal", this._principal);
            } else {
                this.skipCreateWSCredential = true;
            }
            this.succeeded = true;
            return this.succeeded;
        }
        if (this._gssCred != null && authzTokenList == null) {
            try {
                GSSName gssUserName = this._gssCred.getName();
                if (gssUserName != null) {
                    String userName = ((Object)gssUserName).toString();
                    this._racfId = Krb5Utils.mapKerbPrincToRACF(userName, this._gssCred);
                    if (this._racfId != null) {
                        this.mapUid = this._racfId;
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Map gssUserName to RACF id (mapUid): " + this.mapUid);
                        }
                    }
                    this._loginUser = this.mapUid != null ? this.mapUid : (isTrimUser ? Krb5Utils.trimUserName(userName) : userName);
                    this.createCredentialsFromUsername(this._loginUser);
                    this._sharedState.put("com.ibm.wsspi.security.cred.userId", this._loginUser);
                    this._sharedState.put("WSCredential", this._credential);
                    this._sharedState.put("WSPrincipal", this._principal);
                }
            }
            catch (GSSException e) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting name from GSSCredential.");
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            this.succeeded = true;
            return this.succeeded;
        }
        if ((credToken != null || this._gssCred != null) && authzTokenList != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipping WSKrb5LoginModule to validate in wsMapDefaultInboundLoginModule.");
            }
            this.isKerberosLogin = false;
            this.succeeded = true;
            return this.succeeded;
        }
        if (uid == null && password == null && credToken == null || uid == null && this.mapUid == null && this._kPrinc == null) {
            throw new LoginException("No authentication data.");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully gathered authentication information");
        }
        if (uid != null && (password == null || password.length == 0) && credToken == null) {
            this.isKerberosLogin = false;
            this.succeeded = true;
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Only UID pass in. Skipping WSKrb5LoginModule. Handling login outside this login module.");
            }
            return this.succeeded;
        }
        if (uid != null || password != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using Kerberos ticket for authentication");
            }
            try {
                this._loginUser = this.mapUid != null ? this.mapUid : (isTrimUser ? Krb5Utils.trimUserName(uid) : uid);
                this.authenticatedone = this.authenticate(this._loginUser);
                this._sharedState.put("com.ibm.wsspi.security.cred.userId", this._loginUser);
                this.succeeded = true;
            }
            catch (Exception e) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.error(tc, "security.auth.kerberos.LoginException", new Object[]{this._loginUser, e});
                }
            }
        } else if (credToken != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using Kerberos token for authentication");
            }
            if (this.mapUid != null) {
                this._loginUser = this.mapUid;
            } else if (this._kPrinc != null) {
                this._loginUser = isTrimUser ? Krb5Utils.trimUserName(this._kPrinc.toString()) : this._kPrinc.toString();
            }
            this.createCredentialsFromUsername(this._loginUser);
            this._sharedState.put("com.ibm.wsspi.security.cred.userId", this._loginUser);
            this.validatedone = true;
            if (this._credential != null) {
                this.succeeded = true;
                this.authenticatedone = true;
            } else {
                this.succeeded = false;
            }
        } else {
            throw new LoginException("No authentication data");
        }
        if (this._credential == null && !this.skipCreateWSCredential) {
            throw new LoginException("credential is null");
        }
        Tr.debug(tc, "credential = " + this._credential);
        if (this._credential != null) {
            this._sharedState.put("WSCredential", this._credential);
            this._sharedState.put("WSPrincipal", this._principal);
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        boolean bRet;
        block51: {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "commit()");
            }
            if (!this.isKerberosLogin || this.skipCreateWSCredential) {
                return true;
            }
            bRet = false;
            if (!this.succeeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do not commit because of authentication failed.");
                }
                return false;
            }
            if (!this.commitSucceeded) {
                if (this.authenticatedone) {
                    try {
                        this._credential = (WSCredential)this._sharedState.get("WSCredential");
                        this._principal = (WSPrincipal)this._sharedState.get("WSPrincipal");
                        this._kTicket = SubjectHelper.getKerberosTicketFromSubject(this._subject);
                        if (this._kTicket == null) {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Kerberos Ticket is null ");
                            }
                        } else {
                            boolean _renewable = this._kTicket.isRenewable();
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Kerberos Ticket renewable is " + String.valueOf(_renewable));
                            }
                            final String _myName = this._kTicket.getClient().getName();
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Name for cred: " + _myName);
                            }
                            Krb5Utils.setUseSubjectCredsOnly(true);
                            try {
                                Subject.doAs(this._subject, new PrivilegedExceptionAction(){

                                    public Object run() throws WSLoginFailedException {
                                        try {
                                            Oid krb5MechOid = Krb5Utils.getKrb5MechOid();
                                            GSSManager _mgr = GSSManager.getInstance();
                                            GSSName _gssName = null;
                                            if (WSKrb5LoginModule.this._gssCred == null) {
                                                SingleSignonToken ssoToken;
                                                _gssName = _myName != null ? _mgr.createName(_myName, GSSName.NT_USER_NAME, krb5MechOid) : null;
                                                boolean credsType = false;
                                                WSKrb5LoginModule.this._gssCred = _mgr.createCredential(_gssName.canonicalize(krb5MechOid), Integer.MAX_VALUE, krb5MechOid, 1);
                                                if (WSKrb5LoginModule.this._gssCred != null && WSKrb5LoginModule.this._credential == null) {
                                                    SubjectHelper.putGSSCredentialInSubject(WSKrb5LoginModule.this._gssCred, WSKrb5LoginModule.this._subject);
                                                }
                                                if (WSKrb5LoginModule.this._credential != null) {
                                                    WSKrb5LoginModule.this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(WSKrb5LoginModule.this._subject, WSKrb5LoginModule.this._gssCred, WSKrb5LoginModule.this._credential);
                                                    WSKrb5LoginModule.this._sharedState.put("WSCredential", WSKrb5LoginModule.this._credential);
                                                }
                                                if ((ssoToken = (SingleSignonToken)WSKrb5LoginModule.this._sharedState.get("com.ibm.wsspi.security.token.wsSingleSignonToken")) != null) {
                                                    if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Setting expiration in SSO token: " + String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    }
                                                    ssoToken.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    WSKrb5LoginModule.this._sharedState.put("com.ibm.wsspi.security.token.wsSingleSignonToken", ssoToken);
                                                } else if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Could not find the SSO token in shared state.");
                                                }
                                                AuthorizationToken authzToken = (AuthorizationToken)WSKrb5LoginModule.this._sharedState.get("com.ibm.wsspi.security.token.wsAuthorizationToken");
                                                if (authzToken != null) {
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(WSKrb5LoginModule.this._credential.getExpiration()));
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.oid", WSKrb5LoginModule.this._credential.getOID());
                                                    boolean f_boolean = WSKrb5LoginModule.this._credential.isForwardable();
                                                    authzToken.addAttribute("com.ibm.wsspi.security.cred.forwardable", String.valueOf(f_boolean));
                                                } else if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Could not find the authorization token in shared state.");
                                                }
                                            }
                                        }
                                        catch (GSSException e) {
                                            if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                                Tr.error(tc, "security.auth.kerberos.GSSException", new Object[]{e});
                                            }
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        catch (Exception e) {
                                            if (WSKrb5LoginModule.this.debug || tc.isDebugEnabled()) {
                                                Tr.error(tc, "security.auth.kerberos.Exception", new Object[]{e});
                                            }
                                            throw new WSLoginFailedException(e.getMessage(), e);
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                Tr.debug(tc, "Exception in Subject.doAS.", new Object[]{e});
                                throw e.getException();
                            }
                        }
                        KRBAuthnToken krbAuthnToken = null;
                        if (SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("enabledGssCredDelegate") || !this.validatedone) {
                            if (this._gssCred != null || this._kTicket != null || this._kPrinc != null) {
                                krbAuthnToken = Krb5Utils.createKRBAuthnToken(this._kTicket, this._gssCred, this._kPrinc, null, 0L);
                            } else if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "No gssCred, Kerberos ticket, and  Kerberos principal in shared state, can not create KRBAuthnToken");
                            }
                        } else {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Delegated GSSCredential is not enabled");
                            }
                            if (this._kPrinc != null) {
                                krbAuthnToken = Krb5Utils.createKRBAuthnToken(null, null, this._kPrinc, null, 0L);
                            } else if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "No Kerberos principal in shared state, can not create KRBAuthnToken");
                            }
                        }
                        if (krbAuthnToken != null && this.mapUid != null && this.mapUid.length() > 0) {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "krbAuthnToken addAttribute mapUid: " + this.mapUid);
                            }
                            krbAuthnToken.addTokenAttribute("krb_map_uid", this.mapUid);
                        }
                        if (krbAuthnToken != null && !this._subject.getPrivateCredentials().contains(krbAuthnToken)) {
                            this._subject.getPrivateCredentials().add(krbAuthnToken);
                        }
                    }
                    catch (Exception e) {
                        Tr.debug(tc, "Exception during commit.", new Object[]{e});
                        if (e instanceof WSLoginFailedException) {
                            throw (WSLoginFailedException)e;
                        }
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                }
                if (this._principal == null) {
                    this._principal = (WSPrincipal)this._sharedState.get("WSPrincipal");
                    if (this._principal == null) {
                        throw new WSLoginFailedException("WSPrincipal is null in commit (phase 2) stage");
                    }
                } else if (this._sharedState.get("WSPrincipal") == null) {
                    this._sharedState.put("WSPrincipal", this._principal);
                }
                if (this._credential == null) {
                    this._credential = (WSCredential)this._sharedState.get("WSCredential");
                    if (this._credential == null) {
                        throw new WSLoginFailedException("WSCredential is null in commit (phase 2) stage");
                    }
                } else if (this._sharedState.get("WSCredential") == null) {
                    this._sharedState.put("WSCredential", this._credential);
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (!WSKrb5LoginModule.this._subject.getPrincipals().contains(WSKrb5LoginModule.this._principal)) {
                                WSKrb5LoginModule.this._subject.getPrincipals().add(WSKrb5LoginModule.this._principal);
                            }
                            if (!WSKrb5LoginModule.this._subject.getPublicCredentials().contains(WSKrb5LoginModule.this._credential)) {
                                WSKrb5LoginModule.this._subject.getPublicCredentials().add(WSKrb5LoginModule.this._credential);
                            }
                            return null;
                        }
                    });
                    GSSCredential verifyCred = SubjectHelper.getGSSCredentialFromSubject(this._subject);
                    if (verifyCred == null && WSSecurityHelper.isGlobalSecurityEnabled() && (this.debug || tc.isDebugEnabled())) {
                        Tr.debug(tc, "GSSCredential is not in the Subject after commit (phase 2) stage.");
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.error(tc, "security.auth.kerberos.DoPrivException", new Object[]{e});
                    }
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            try {
                if (this._kTicket != null && this._subject.getPrivateCredentials().contains(this._kTicket)) {
                    KerberosTicket tk;
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removed Kerberos ticket from a subject: " + this._kTicket);
                    }
                    this._subject.getPrivateCredentials().remove(this._kTicket);
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removed KerberosTicket from sharedState");
                    }
                    if ((tk = (KerberosTicket)this._sharedState.get("javax.security.auth.kerberos.KerberosTicket")) != null) {
                        this._sharedState.remove("javax.security.auth.kerberos.KerberosTicket");
                    }
                }
            }
            catch (Exception e) {
                if (!this.debug && !tc.isDebugEnabled()) break block51;
                Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
            }
        }
        bRet = this.commitSucceeded;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principal and credential, reset variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes principal and credential, reset variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing principal, Kerberos ticket and credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                try {
                                    if (WSKrb5LoginModule.this._principal != null && WSKrb5LoginModule.this._subject.getPrincipals().contains(WSKrb5LoginModule.this._principal)) {
                                        WSKrb5LoginModule.this._subject.getPrincipals().remove(WSKrb5LoginModule.this._principal);
                                    }
                                }
                                catch (Exception e) {
                                    if (!WSKrb5LoginModule.this.debug && !tc.isDebugEnabled()) break block13;
                                    Tr.error(tc, "security.auth.kerberos.RemPrincException", new Object[]{e});
                                }
                            }
                            try {
                                if (WSKrb5LoginModule.this._credential != null && WSKrb5LoginModule.this._subject.getPublicCredentials().contains(WSKrb5LoginModule.this._credential)) {
                                    WSKrb5LoginModule.this._subject.getPublicCredentials().remove(WSKrb5LoginModule.this._credential);
                                }
                            }
                            catch (Exception e) {
                                if (!WSKrb5LoginModule.this.debug && !tc.isDebugEnabled()) break block14;
                                Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
                            }
                        }
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "acceptSecContext: clean up Kerberos ticket " + WSKrb5LoginModule.this._kTicket);
                            }
                            if (WSKrb5LoginModule.this._kTicket != null && WSKrb5LoginModule.this._subject.getPrivateCredentials().contains(WSKrb5LoginModule.this._kTicket)) {
                                WSKrb5LoginModule.this._subject.getPrivateCredentials().remove(WSKrb5LoginModule.this._kTicket);
                                Tr.debug(tc, "acceptSecContext: removed Kerberos ticket " + WSKrb5LoginModule.this._kTicket);
                            }
                        }
                        catch (Exception e) {
                            if (!WSKrb5LoginModule.this.debug && !tc.isDebugEnabled()) break block15;
                            Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
                        }
                    }
                    if (WSKrb5LoginModule.this._credential != null) {
                        try {
                            WSKrb5LoginModule.this._credential.destroy();
                        }
                        catch (Exception e) {
                            if (!WSKrb5LoginModule.this.debug && !tc.isDebugEnabled()) break block16;
                            Tr.error(tc, "security.auth.kerberos.DestroyCredException", new Object[]{e});
                        }
                    }
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this._principal = null;
        this._credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private boolean authenticate(String uid) throws LoginException {
        block9: {
            block8: {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.entry(tc, "authenticate() " + uid);
                }
                try {
                    this._credential = Krb5WSCredentialUtils.Krb5ToRegistryWSCredential(uid);
                }
                catch (Exception ex) {
                    if (!this.debug && !tc.isDebugEnabled()) break block8;
                    Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
                }
            }
            try {
                if (this._credential == null) {
                    throw new LoginException("WSCredential is null in login (phase 1) stage");
                }
                this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                if (this._principal == null) {
                    throw new LoginException("WSPrincipal is null in login (phase 1) stage");
                }
            }
            catch (Exception ex) {
                if (!this.debug && !tc.isDebugEnabled()) break block9;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate()");
        }
        return true;
    }

    private void createCredentialsFromUsername(String userName) {
        block6: {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredentialsFromUsername()", userName);
            }
            try {
                this._credential = Krb5WSCredentialUtils.Krb5ToRegistryWSCredential(userName);
                if (this._credential != null) {
                    this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(this._subject, this._gssCred, this._credential);
                    this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                    if (this._principal == null) {
                        throw new LoginException("WSPrincipal is null in validate stage");
                    }
                    break block6;
                }
                throw new LoginException("WSCredential is null in validate stage");
            }
            catch (Exception ex) {
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredentialsFromUsername()");
        }
    }

    private void createCredentialsFromHashtable(Hashtable customProperties, GSSCredential _gssCred) {
        block6: {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredentialsFromHashtable()");
            }
            try {
                WSCredentialTokenMapperInterface wsCredMapper = WSCredentialTokenMapper.getInstance();
                this._credential = wsCredMapper.createWSCredentialFromProperties(customProperties);
                if (this._credential != null) {
                    this._credential = Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential(this._subject, _gssCred, this._credential);
                    this._principal = ContextManagerFactory.getInstance().createPrincipal(this._credential);
                    if (this._principal == null) {
                        throw new LoginException("WSPrincipal is null in validate stage");
                    }
                    break block6;
                }
                throw new LoginException("WSCredential is null in validate stage");
            }
            catch (Exception ex) {
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.error(tc, "security.auth.kerberos.CredUtilsException", new Object[]{ex});
            }
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredentialsFromHashtable()");
        }
    }
}

