/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.CredentialMapFailedException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.auth.kerberos.NoCredentialFoundException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class Krb5WSCredentialUtils {
    private static final GSSManager _manager = GSSManager.getInstance();
    private static LTPAServerObject _ltpaServer = null;
    private static SecurityConfig _security = null;
    private static SecurityConfigManager _scm = null;
    private static TraceComponent tc = Tr.register(Krb5WSCredentialUtils.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public static WSCredential Krb5ToRegistryWSCredential(String userName) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToRegistryWSCredential", new Object[]{userName});
        }
        Object credential = null;
        String searchUserName = Krb5WSCredentialUtils.adjustUserName(userName);
        UserRegistry _userRegistry = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        if (_userRegistry != null) {
            try {
                String userDN = Krb5WSCredentialUtils.getUserDN(_userRegistry, searchUserName);
                credential = _userRegistry.createCredential(userDN);
                credential.set("security.login_uid", searchUserName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning from createCredential");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.Krb5ToRegistryWSCredential", "164");
                e.printStackTrace();
            }
        }
        if (tc.isDebugEnabled()) {
            if (credential == null) {
                Tr.debug(tc, "*** newly created WSCredential is NULL!");
            } else {
                Tr.debug(tc, credential.toString());
            }
        }
        if (credential == null && _userRegistry != null) {
            Tr.error(tc, "security.auth.kerberos.NoCredFound");
            throw new NoCredentialFoundException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Krb5ToRegistryWSCredential()");
        }
        return credential;
    }

    public static String Krb5ToRegistryDN(String userName) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToRegistryDN", new Object[]{userName});
        }
        String searchUserName = Krb5WSCredentialUtils.adjustUserName(userName);
        UserRegistry _userRegistry = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        if (_userRegistry != null) {
            try {
                return Krb5WSCredentialUtils.getUserDN(_userRegistry, searchUserName);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.Krb5ToRegistryDN", "219");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in Krb5ToRegistryDN: ", new Object[]{e});
                }
                if (e instanceof CredentialMapFailedException) {
                    throw (CredentialMapFailedException)e;
                }
                if (e instanceof NoCredentialFoundException) {
                    throw (NoCredentialFoundException)e;
                }
                throw new NoCredentialFoundException(e.getMessage());
            }
        }
        return null;
    }

    public static WSCredential Krb5ToAuthMechWSCredential(Subject subject, GSSCredential gssCredential, WSCredential urCred) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToAuthMechWSCredential");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Entry parameters:");
            Tr.debug(tc, subject != null && subject.toString().length() != 0 ? subject.toString() : "subject: NULL");
            Tr.debug(tc, gssCredential != null ? gssCredential.toString() : "gssCredential: NULL");
            Tr.debug(tc, urCred != null ? urCred.toString() : "urCred: NULL");
        }
        long krb5expiration = 0L;
        String authMechOid = "oid:1.2.840.113554.1.2.2";
        WSCredentialImpl credential = null;
        try {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            Long expirationLong = security2.getActiveAuthMechanism().getLong("timeout");
            long expiration = expirationLong * 60L * 1000L + System.currentTimeMillis();
            if (gssCredential != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Krb5ToAuthMechWSCredential for " + ((Object)gssCredential.getName()).toString());
                }
                krb5expiration = (long)(gssCredential.getRemainingLifetime() * 1000) + System.currentTimeMillis();
            } else {
                authMechOid = "oid:1.3.18.0.2.30.2";
                krb5expiration = expiration;
            }
            boolean ltpaSupported = security2.getActiveAuthMechanism().getBoolean("allowLPTAAuth");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Krb5ToAuthMechWSCredential - authMechOid: " + authMechOid + ", krb5expiration: " + krb5expiration + ", ltpaSupported: " + ltpaSupported);
            }
            if (ltpaSupported) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating WSCredential with LTPA token for backwards compatiblity.");
                }
                LTPAServerObject ltpaServer = Krb5WSCredentialUtils.getLTPAServerObject();
                String factory = security2.getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
                Token ltpaToken = ltpaServer.createLTPAToken(urCred.getAccessId(), factory);
                byte[] ltpaTokenBytes = ltpaToken.getBytes();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Krb5ToAuthMechWSCredential - ltpaToken: " + StringUtil.toString(ltpaTokenBytes));
                }
                long l = expiration = krb5expiration < expiration ? krb5expiration : expiration;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Krb5ToAuthMechWSCredential - expiration: " + expiration);
                }
                credential = new WSCredentialImpl(urCred, authMechOid, ltpaTokenBytes, true, expiration);
            } else {
                credential = new WSCredentialImpl(urCred, authMechOid, new byte[0], true, krb5expiration);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.Krb5ToAuthMechWSCredential", "332");
            Object[] parms = new Object[]{"createCredential()", e};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw new CredentialMapFailedException(e.getMessage(), e);
        }
        if (credential == null) {
            Tr.error(tc, "security.auth.kerberos.NoCredFound");
            throw new NoCredentialFoundException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Krb5ToAuthMechWSCredential()");
        }
        return credential;
    }

    public static KRBAuthnToken validateToken(byte[] token) throws Exception, GSSException {
        KRBAuthnToken krbAuthnToken = null;
        GSSCredential serverCred = null;
        GSSContext serverContext = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken() " + new Object[]{token});
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            serverCred = contextManager.getServerSpnGSSCred();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: serverCred is :" + serverCred);
            }
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "372");
            Object[] parms = new Object[]{"createCredential()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw exc;
        }
        try {
            serverContext = _manager.createContext(serverCred);
        }
        catch (GSSException exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "382");
            Object[] parms = new Object[]{"createContext()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw exc;
        }
        Krb5Utils.setUseSubjectCredsOnly(true);
        byte[] outToken = null;
        Subject subject = new Subject();
        try {
            final GSSContext inServerContext = serverContext;
            final byte[] inCredToken = token;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validateToken: calling acceptSecContext.");
                    }
                    return inServerContext.acceptSecContext(inCredToken, 0, inCredToken.length);
                }
            };
            try {
                outToken = (byte[])Subject.doAsPrivileged(subject, action, AccessController.getContext());
            }
            catch (PrivilegedActionException e) {
                if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "410");
                }
                throw e.getException();
            }
        }
        catch (GSSException exc) {
            Object[] parms = new Object[]{"validateToken()", exc};
            if (exc.getMinorString().contains("major code: 10, minor code: 37")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Suppressing SECJ9314E error message for retriable clock skew error.");
                }
                if (!SecurityMessages.suppressFFDCforKrbSkewError(exc)) {
                    FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "421");
                }
            } else {
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "426");
            }
            throw new WSLoginFailedException(exc.getMessage(), exc);
        }
        catch (Exception e) {
            Object[] parms = new Object[]{serverContext, "validateToken()", e};
            Tr.error(tc, "security.auth.kerberos.exception", parms);
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "433");
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (outToken == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "validateToken: outToken is null");
        }
        KerberosTicket kt = null;
        if (subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: " + subject.toString());
            }
            kt = SubjectHelper.getKerberosTicketFromSubject(subject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateToken: subject is null.");
        }
        KerberosPrincipal kPrinc = null;
        long lifetime = 0L;
        if (serverContext.isEstablished()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: serverContext established successfully.");
            }
            lifetime = serverContext.getLifetime();
            GSSName gssName = serverContext.getSrcName();
            if (gssName != null) {
                kPrinc = new KerberosPrincipal(((Object)gssName).toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateToken: serverContext is not established");
        }
        GSSCredential gssCred = null;
        if (SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("enabledGssCredDelegate")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: Delegated GSSCredential is enabled");
            }
            try {
                gssCred = serverContext.getDelegCred();
            }
            catch (GSSException exc) {
                FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "484");
                Object[] parms = new Object[]{"getDelegCred()", exc};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                throw exc;
            }
            if (tc.isDebugEnabled()) {
                if (gssCred == null) {
                    Tr.debug(tc, "validateToken: Delegated GSSCredential is null.");
                } else {
                    Tr.debug(tc, "validateToken: Delegated GSSCredential is not null.");
                }
            }
            if (kt != null || gssCred != null || kPrinc != null) {
                krbAuthnToken = Krb5Utils.createKRBAuthnToken(kt, gssCred, kPrinc, null, lifetime);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: Delegated GSSCredential is disabled");
            }
            if (kPrinc != null) {
                krbAuthnToken = Krb5Utils.createKRBAuthnToken(null, null, kPrinc, null, lifetime);
            }
        }
        subject = null;
        if (serverContext != null) {
            try {
                serverContext.dispose();
            }
            catch (GSSException exc) {
                FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.validateToken", "517");
                Object[] parms = new Object[]{"dispose()", exc};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken()");
        }
        return krbAuthnToken;
    }

    public static String adjustUserName(String userName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustUserName() " + userName);
        }
        String user = userName;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        boolean trimUserName = security2.getActiveAuthMechanism().getBoolean("trimUserName");
        String kerberos_realm = security2.getActiveAuthMechanism().getString("krb5Realm");
        if (trimUserName) {
            user = Krb5Utils.trimUserName(userName);
        } else if (userName.indexOf("@") < 0 && kerberos_realm != null && !kerberos_realm.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "kerberos_realm: " + kerberos_realm);
            }
            user = userName + "@" + kerberos_realm;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustUserName() " + user);
        }
        return user;
    }

    public static String getUserDN(UserRegistry userRegistry, String userName) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDN() " + userName);
        }
        String userDN = null;
        try {
            SecurityConfig secCfg = SecurityObjectLocator.getSecurityConfig();
            UserRegistryConfig aur = secCfg.getActiveUserRegistry();
            if (PlatformHelperFactory.getPlatformHelper().isZOS() && aur.getType().equals("LOCALOS") || aur.getType().equals("WIMUserRegistry")) {
                String accessID = userRegistry.getUniqueUserId(userName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessID found is " + accessID);
                }
                if (accessID != null && accessID.length() > 0) {
                    userDN = accessID.indexOf("/") != -1 ? accessID.substring(accessID.indexOf("/") + 1, accessID.length()) : accessID;
                }
            } else {
                Result users = userRegistry.getUsers(userName, 1);
                if (users.getList().size() > 1) {
                    throw new CredentialMapFailedException("Returned multiple users from the registry getUsers: " + userName);
                }
                if (users.getList().size() == 1) {
                    userDN = (String)users.getList().get(0);
                }
            }
            if (userDN == null || userDN.length() == 0) {
                throw new NoCredentialFoundException("Did not find user in userRegistry for userName: " + userName);
            }
        }
        catch (EntryNotFoundException e) {
            throw new NoCredentialFoundException(e.getMessage());
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.getUserDN", "601");
            Object[] parms = new Object[]{"getUserDN()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw new CredentialMapFailedException(exc.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getuserDN() " + userDN);
        }
        return userDN;
    }

    private static LTPAServerObject getLTPAServerObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAServerObject");
        }
        LTPAServerObject ltpaServer = null;
        try {
            if (_scm == null) {
                _scm = SecurityObjectLocator.getSecurityConfigManager();
            }
            if (_scm != null && _scm.isAdminAgent()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "in AdminAgent process, get LTPAServerObject from thread each time");
                    Tr.debug(tc, "AdminContext.peek() = " + AdminContext.peek());
                }
                ltpaServer = (LTPAServerObject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return LTPAServerObject.getLTPAServer();
                    }
                });
            } else {
                if (_ltpaServer == null) {
                    _ltpaServer = (LTPAServerObject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return LTPAServerObject.getLTPAServer();
                        }
                    });
                }
                ltpaServer = _ltpaServer;
            }
        }
        catch (PrivilegedActionException ex) {
            Tr.debug(tc, "PrivilegedActionException getting LTPAServerObject", new Object[]{ex});
            FFDCFilter.processException(ex, "com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils.LTPAServerObject", "658");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAServerObject", ltpaServer);
        }
        return ltpaServer;
    }
}

