/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.auth.callback.CcacheFileTextInputCallback;
import com.ibm.security.auth.callback.DefaultCcacheTextInputCallback;
import com.ibm.security.auth.module.Krb5LoginModule;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class Krb5LoginModuleWrapperClient
extends Krb5LoginModule {
    protected boolean _debug = true;
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private WSCredential _credential;
    private GSSCredential _gssCred = null;
    private String _realmName = null;
    private String clientRealm = null;
    private String defaultRealm = null;
    private static final Oid krb5MechOid = Krb5Utils.getKrb5MechOid();
    private static final TraceComponent tc = Tr.register(Krb5LoginModuleWrapperClient.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");
    boolean login_called = false;

    public Krb5LoginModuleWrapperClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5LoginModuleWrapperClient()");
            Tr.exit(tc, "Krb5LoginModuleWrapperClient()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
            }
            try {
                super.initialize(subject, callbackHandler, sharedState, options);
                this._subject = subject;
                this._callbackHandler = callbackHandler;
                this._sharedState = sharedState;
                this._options = options;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapperClient.initialize", "175", (Object)this);
                if (!this._debug && !tc.isEntryEnabled()) break block5;
                Tr.error(tc, "initialize", new Object[]{e});
            }
        }
        this._debug = "true".equalsIgnoreCase((String)this._options.get("debug"));
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Krb5LoginModuleWrapperClient");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws CredentialExpiredException, FailedLoginException, LoginException {
        char[] tmp;
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        String uid = null;
        char[] password = null;
        Object defaultKeytab = null;
        String defaultCcache = null;
        String ccacheFile = null;
        Object keytabFile = null;
        Object authzTokenList = null;
        Object customProperties = null;
        boolean result = false;
        NameCallback nameCallback = null;
        PasswordCallback passwordCallback = null;
        WSRealmNameCallbackImpl wsRealmNameCallback = null;
        CcacheFileTextInputCallback ccacheFileTextInputCallback = null;
        DefaultCcacheTextInputCallback defaultCcacheTextInputCallback = null;
        Callback[] callbacks = null;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (!this._sharedState.containsKey("Callback")) {
            if (this._callbackHandler == null) {
                WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                throw e;
            }
            callbacks = new Callback[5];
            nameCallback = new NameCallback("Username: ");
            callbacks[0] = nameCallback;
            passwordCallback = new PasswordCallback("Password: ", false);
            callbacks[1] = passwordCallback;
            wsRealmNameCallback = new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm());
            callbacks[2] = wsRealmNameCallback;
            ccacheFileTextInputCallback = new CcacheFileTextInputCallback("CcacheFile: ");
            callbacks[3] = ccacheFileTextInputCallback;
            defaultCcacheTextInputCallback = new DefaultCcacheTextInputCallback("DefaultCcache: ");
            callbacks[4] = defaultCcacheTextInputCallback;
            try {
                this._callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapperClient.login", "249", (Object)this);
                Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{((Object)((Object)this)).getClass().getName(), e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapperClient.login", "254", (Object)this);
                Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{((Object)((Object)this)).getClass().getName(), uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
            }
            this._sharedState.put("Callback", callbacks);
        } else {
            callbacks = (Callback[])this._sharedState.get("Callback");
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] == null) continue;
                if (callbacks[i] instanceof NameCallback) {
                    nameCallback = (NameCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    passwordCallback = (PasswordCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                    wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof CcacheFileTextInputCallback) {
                    ccacheFileTextInputCallback = (CcacheFileTextInputCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof DefaultCcacheTextInputCallback) {
                    defaultCcacheTextInputCallback = (DefaultCcacheTextInputCallback)callbacks[i];
                    continue;
                }
                if (!this._debug && !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The following callback was ignored: " + callbacks[i].getClass().getName());
            }
        }
        if (nameCallback != null) {
            uid = nameCallback.getName();
        }
        if (passwordCallback != null && (tmp = passwordCallback.getPassword()) != null && tmp.length != 0) {
            password = new char[tmp.length];
            System.arraycopy(tmp, 0, password, 0, tmp.length);
        }
        if (wsRealmNameCallback != null) {
            this._realmName = wsRealmNameCallback.getRealmName();
        }
        if (ccacheFileTextInputCallback != null) {
            ccacheFile = ccacheFileTextInputCallback.getText();
        }
        if (defaultCcacheTextInputCallback != null) {
            defaultCcache = defaultCcacheTextInputCallback.getText();
        }
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + (uid == null ? "<null>" : uid));
            Tr.debug(tc, "password = " + (password != null ? "<not null>" : "<null>"));
            Tr.debug(tc, "realm = " + this._realmName);
            Tr.debug(tc, "ccache File Name = " + (ccacheFile == null ? "<null>" : ccacheFile));
            Tr.debug(tc, "use DefaultCcache File = " + (defaultCcache == null ? "<null>" : defaultCcache));
        }
        try {
            if (uid != null && password != null) {
                this.login_called = true;
                this.clientRealm = Krb5Utils.getDefaultRealm("");
                this.defaultRealm = contextManager.getDefaultRealm();
                if (!(this._realmName.equals(this.defaultRealm) || this._realmName.equals(this.clientRealm) || this._realmName.equals("<default>"))) {
                    Tr.warning(tc, "security.auth.kerberos.RealmMismatch", new Object[]{this._realmName, this.clientRealm, this.defaultRealm});
                }
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling super.login() from wrapper with uid and password.");
                }
                return super.login();
            }
            if (uid != null) {
                this.login_called = true;
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling super.login() from wrapper with uid.");
                }
                return super.login();
            }
            this.login_called = true;
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.login() from wrapper client.");
            }
            return super.login();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapperClient.login", "346", (Object)this);
            if (this._debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "login()", new Object[]{e});
            }
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean commit() throws LoginException {
        block14: {
            if (this._debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "commit()");
            }
            if (!this.login_called) return true;
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.commit() from wrapper.");
            }
            super.commit();
            try {
                Set<KerberosTicket> kerberosTickets = this._subject.getPrivateCredentials(KerberosTicket.class);
                if (kerberosTickets.size() > 1) {
                    Tr.warning(tc, "security.auth.kerberos.MultipleCredsFound");
                }
                KerberosTicket kTicket = null;
                Iterator<KerberosTicket> credIter = kerberosTickets.iterator();
                KerberosPrincipal kPrinc = null;
                while (credIter.hasNext()) {
                    KerberosTicket credObj = credIter.next();
                    if (!(credObj instanceof KerberosTicket)) continue;
                    kTicket = credObj;
                }
                if (kTicket == null) {
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos Ticket is null ");
                    }
                    break block14;
                }
                final long kTicketEndTime = kTicket.getEndTime().getTime();
                kPrinc = kTicket.getClient();
                final String _myName = kTicket.getClient().getName();
                if (this._debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Name for cred: " + _myName);
                    Tr.debug(tc, "_subject: " + this._subject);
                }
                try {
                    KRBAuthnToken krbAuthnToken;
                    Subject.doAs(this._subject, new PrivilegedExceptionAction(){

                        public Object run() throws WSLoginFailedException, GSSException, Exception {
                            if (Krb5LoginModuleWrapperClient.this._gssCred == null) {
                                Krb5LoginModuleWrapperClient.this._gssCred = Krb5Utils.createGSSCredential(Krb5LoginModuleWrapperClient.this._subject);
                                if (Krb5LoginModuleWrapperClient.this._gssCred != null) {
                                    SubjectHelper.putGSSCredentialInSubject(Krb5LoginModuleWrapperClient.this._gssCred, Krb5LoginModuleWrapperClient.this._subject);
                                }
                            }
                            String resolveRealm = null;
                            resolveRealm = Krb5LoginModuleWrapperClient.this.clientRealm != null && Krb5LoginModuleWrapperClient.this.clientRealm.length() > 0 ? Krb5LoginModuleWrapperClient.this.clientRealm : (Krb5LoginModuleWrapperClient.this._realmName != null && Krb5LoginModuleWrapperClient.this._realmName.length() > 0 ? Krb5LoginModuleWrapperClient.this._realmName : Krb5LoginModuleWrapperClient.this.defaultRealm);
                            String accessId = resolveRealm + "/" + _myName;
                            Krb5LoginModuleWrapperClient.this._credential = new WSCredentialImpl(resolveRealm, _myName, _myName, null, accessId, null, null, krb5MechOid.toString(), null, true, kTicketEndTime);
                            Krb5LoginModuleWrapperClient.this._sharedState.put("WSCredential", Krb5LoginModuleWrapperClient.this._credential);
                            if (!Krb5LoginModuleWrapperClient.this._subject.getPublicCredentials().contains(Krb5LoginModuleWrapperClient.this._credential)) {
                                Krb5LoginModuleWrapperClient.this._subject.getPublicCredentials().add(Krb5LoginModuleWrapperClient.this._credential);
                            }
                            return null;
                        }
                    });
                    if ((kTicket != null || this._gssCred != null || kPrinc != null) && (krbAuthnToken = Krb5Utils.createKRBAuthnToken(kTicket, this._gssCred, kPrinc, null, 0L)) != null) {
                        this._subject.getPrivateCredentials().add(krbAuthnToken);
                    }
                    if (this._debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "_credential.", this._credential);
                    }
                }
                catch (PrivilegedActionException e) {
                    Tr.debug(tc, "Exception in Subject.doAS.", new Object[]{e});
                    throw e.getException();
                }
            }
            catch (Exception e) {
                if (this._debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Exception during commit.", new Object[]{e});
                }
                if (!(e instanceof WSLoginFailedException)) throw new WSLoginFailedException(e.getMessage(), e);
                throw (WSLoginFailedException)e;
            }
        }
        if (!tc.isEntryEnabled()) return true;
        Tr.exit(tc, "commit()");
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.login_called) {
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.abort() from wrapper.");
            }
            return super.abort();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.login_called) {
            this.cleanup();
            if (this._debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.logout() from wrapper.");
            }
            return super.logout();
        }
        return true;
    }

    private void cleanup() {
        if (this._debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block11: {
                    block10: {
                        block9: {
                            try {
                                if (Krb5LoginModuleWrapperClient.this._gssCred != null && Krb5LoginModuleWrapperClient.this._subject.getPrivateCredentials().contains(Krb5LoginModuleWrapperClient.this._gssCred)) {
                                    Krb5LoginModuleWrapperClient.this._subject.getPrivateCredentials().remove(Krb5LoginModuleWrapperClient.this._gssCred);
                                }
                            }
                            catch (Exception ex) {
                                if (!Krb5LoginModuleWrapperClient.this._debug && !tc.isDebugEnabled()) break block9;
                                Tr.error(tc, "security.auth.kerberos.RemGSSCredException", new Object[]{ex});
                            }
                        }
                        try {
                            if (Krb5LoginModuleWrapperClient.this._credential != null && Krb5LoginModuleWrapperClient.this._subject.getPublicCredentials().contains(Krb5LoginModuleWrapperClient.this._credential)) {
                                Krb5LoginModuleWrapperClient.this._subject.getPublicCredentials().remove(Krb5LoginModuleWrapperClient.this._credential);
                            }
                        }
                        catch (Exception e) {
                            if (!Krb5LoginModuleWrapperClient.this._debug && !tc.isDebugEnabled()) break block10;
                            Tr.error(tc, "security.auth.kerberos.RemCredException", new Object[]{e});
                        }
                    }
                    if (Krb5LoginModuleWrapperClient.this._credential != null) {
                        try {
                            Krb5LoginModuleWrapperClient.this._credential.destroy();
                        }
                        catch (Exception e) {
                            if (!Krb5LoginModuleWrapperClient.this._debug && !tc.isDebugEnabled()) break block11;
                            Tr.error(tc, "security.auth.kerberos.DestroyCredException", new Object[]{e});
                        }
                    }
                }
                return null;
            }
        });
        if (this._debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this._credential = null;
        this._gssCred = null;
        if (this._debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }
}

