/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.auth.module.Krb5LoginModule;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class Krb5LoginModuleWrapper
extends Krb5LoginModule {
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Map _sharedState;
    private Map _options;
    private KerberosPrincipal _kPrinc = null;
    private KerberosTicket _kTicket = null;
    private GSSCredential _gssCred = null;
    private KRBAuthnToken _krbAuthnToken = null;
    private boolean isKerberosLogin = true;
    private boolean login_called = false;
    private boolean succeeded = true;
    protected boolean debug = true;
    private static final TraceComponent tc = Tr.register(Krb5LoginModuleWrapper.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public Krb5LoginModuleWrapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5LoginModuleWrapper()");
            Tr.exit(tc, "Krb5LoginModuleWrapper()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
            }
            try {
                super.initialize(subject, callbackHandler, sharedState, options);
                this._subject = subject;
                this._callbackHandler = callbackHandler;
                this._sharedState = sharedState;
                this._options = options;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.initialize", "170", (Object)this);
                if (!this.debug && !tc.isDebugEnabled()) break block5;
                Tr.error(tc, "initialize", new Object[]{e});
            }
        }
        this.debug = "true".equalsIgnoreCase((String)this._options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Krb5LoginModuleWrapper");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws CredentialExpiredException, FailedLoginException, LoginException {
        ContextManager contextManager;
        block77: {
            char[] tmp;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            if (!(contextManager = ContextManagerFactory.getInstance()).isCellSecurityEnabled()) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(security disabled)");
                }
                this.isKerberosLogin = false;
                this.succeeded = true;
                return this.succeeded;
            }
            if (this._callbackHandler == null) {
                throw new LoginException("No CallbackHandler available to gather authentication information from the user.");
            }
            String uid = null;
            String realm = null;
            char[] password = null;
            String authMechOid = null;
            X509Certificate[] certChain = null;
            byte[] credToken = null;
            List authzTokenList = null;
            Hashtable customProperties = null;
            NameCallback nameCallback = null;
            PasswordCallback passwordCallback = null;
            WSCredTokenCallbackImpl wsCredTokenCallback = null;
            WSServletRequestCallback wsServletRequestCallback = null;
            WSServletResponseCallback wsServletResponseCallback = null;
            WSAppContextCallback wsAppContextCallback = null;
            WSTokenHolderCallback wsTokenHolderCallback = null;
            WSRealmNameCallbackImpl wsRealmNameCallback = null;
            WSX509CertificateChainCallback wsX509CertificateCallback = null;
            WSAuthMechOidCallbackImpl wsAuthMechOidCallback = null;
            Callback[] callbacks = null;
            if (!this._sharedState.containsKey("Callback")) {
                if (this._callbackHandler == null) {
                    WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                    contextManager.setRootException(e);
                    throw e;
                }
                callbacks = new Callback[10];
                nameCallback = new NameCallback("Username: ");
                callbacks[0] = nameCallback;
                passwordCallback = new PasswordCallback("Password: ", false);
                callbacks[1] = passwordCallback;
                wsCredTokenCallback = new WSCredTokenCallbackImpl("Credential Token: ");
                callbacks[2] = wsCredTokenCallback;
                wsServletRequestCallback = new WSServletRequestCallback("HttpServletRequest: ");
                callbacks[3] = wsServletRequestCallback;
                wsServletResponseCallback = new WSServletResponseCallback("HttpServletResponse: ");
                callbacks[4] = wsServletResponseCallback;
                wsAppContextCallback = new WSAppContextCallback("ApplicationContextCallback: ");
                callbacks[5] = wsAppContextCallback;
                wsTokenHolderCallback = new WSTokenHolderCallback("Authz Token List: ");
                callbacks[6] = wsTokenHolderCallback;
                wsRealmNameCallback = new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm());
                callbacks[7] = wsRealmNameCallback;
                wsX509CertificateCallback = new WSX509CertificateChainCallback("X509Certificate[]: ");
                callbacks[8] = wsX509CertificateCallback;
                wsAuthMechOidCallback = new WSAuthMechOidCallbackImpl("AuthMechOid: ");
                callbacks[9] = wsAuthMechOidCallback;
                try {
                    this._callbackHandler.handle(callbacks);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "267", (Object)this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{((Object)((Object)this)).getClass().getName(), e});
                    contextManager.setRootException(e);
                    throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
                }
                catch (UnsupportedCallbackException uce) {
                    FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "272", (Object)this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{((Object)((Object)this)).getClass().getName(), uce.getCallback().toString(), uce});
                    contextManager.setRootException(uce);
                    throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
                }
                this._sharedState.put("Callback", callbacks);
            } else {
                callbacks = (Callback[])this._sharedState.get("Callback");
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] == null) continue;
                    if (callbacks[i] instanceof NameCallback) {
                        nameCallback = (NameCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        passwordCallback = (PasswordCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                        wsCredTokenCallback = (WSCredTokenCallbackImpl)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSServletRequestCallback) {
                        wsServletRequestCallback = (WSServletRequestCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSServletResponseCallback) {
                        wsServletResponseCallback = (WSServletResponseCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSAppContextCallback) {
                        wsAppContextCallback = (WSAppContextCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSTokenHolderCallback) {
                        wsTokenHolderCallback = (WSTokenHolderCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                        wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSX509CertificateChainCallback) {
                        wsX509CertificateCallback = (WSX509CertificateChainCallback)callbacks[i];
                        continue;
                    }
                    if (callbacks[i] instanceof WSAuthMechOidCallbackImpl) {
                        wsAuthMechOidCallback = (WSAuthMechOidCallbackImpl)callbacks[i];
                        continue;
                    }
                    if (!this.debug && !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The following callback was ignored: " + callbacks[i].getClass().getName());
                }
            }
            if (wsAuthMechOidCallback != null) {
                authMechOid = wsAuthMechOidCallback.getAuthMechOid();
            }
            if (nameCallback != null) {
                uid = nameCallback.getName();
            }
            this.isKerberosLogin = Krb5Utils.isKrb5Login(authMechOid, uid);
            if (!this.isKerberosLogin) {
                this.succeeded = true;
                return this.succeeded;
            }
            if (wsX509CertificateCallback != null) {
                certChain = wsX509CertificateCallback.getX509CertificateChain();
            }
            if (certChain != null) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Certificate pass in. Skipping Krb5LoginModuleWrapper. Handling login outside this login module.");
                }
                this.isKerberosLogin = false;
                this.succeeded = true;
                return this.succeeded;
            }
            if (passwordCallback != null && (tmp = passwordCallback.getPassword()) != null && tmp.length != 0) {
                password = new char[tmp.length];
                System.arraycopy(tmp, 0, password, 0, tmp.length);
            }
            if (wsRealmNameCallback != null) {
                realm = wsRealmNameCallback.getRealmName();
            }
            if (wsCredTokenCallback != null) {
                byte[] tmpCred = wsCredTokenCallback.getCredToken();
                if (tmpCred != null) {
                    credToken = CredentialsHelper.copyCredToken(tmpCred);
                }
                if (authMechOid == null || authMechOid.length() == 0) {
                    try {
                        authMechOid = GSSFactory.getMechOIDFromGSSToken(credToken);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "authMechOid pass in is null, get authMechOid from the credToken: " + authMechOid);
                        }
                    }
                    catch (Exception e) {
                        Object[] parms = new Object[]{Krb5LoginModuleWrapper.class, "credToken"};
                        throw new WSLoginFailedException("Get authMechOid from the credToken exception - " + e.getMessage(), e);
                    }
                }
            }
            if (wsTokenHolderCallback != null) {
                authzTokenList = wsTokenHolderCallback.getTokenHolderList();
            }
            if ((customProperties = (Hashtable)this._sharedState.get("com.ibm.wsspi.security.cred.propertiesObject")) == null) {
                try {
                    final Subject subjectPriv = this._subject;
                    customProperties = (Hashtable)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                            Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                            if (Krb5LoginModuleWrapper.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for custom properties in public cred list.");
                            }
                            for (int i = 0; i < list_public.length; ++i) {
                                if (Krb5LoginModuleWrapper.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                                }
                                if (!(list_public[i] instanceof Hashtable) || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.userId") == null || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.password") == null) continue;
                                return list_public[i];
                            }
                            Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                            for (int i = 0; i < list_private.length; ++i) {
                                if (Krb5LoginModuleWrapper.this.debug || tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                                }
                                if (!(list_private[i] instanceof Hashtable) || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.userId") == null || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.password") == null) continue;
                                return list_private[i];
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "413", (Object)this);
                    contextManager.setRootException(e.getException());
                    throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                }
                if (customProperties != null) {
                    this._sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", customProperties);
                }
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + uid);
                Tr.debug(tc, "password = " + (password != null ? "<not null>" : "<null>"));
                Tr.debug(tc, "realm = " + realm);
                Tr.debug(tc, "cred token = " + Util.toString(credToken));
                Tr.debug(tc, "certChain = " + certChain);
                Tr.debug(tc, "authz token list = " + authzTokenList);
                Tr.debug(tc, "custom properties = " + customProperties);
                Tr.debug(tc, "authMechOid = " + authMechOid);
            }
            if (customProperties != null) {
                String temp_uid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
                String temp_password = (String)customProperties.get("com.ibm.wsspi.security.cred.password");
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logging in using JAASClient login configuration with user: " + temp_uid);
                }
                if (temp_uid != null && !temp_uid.equals("") && temp_password != null && !temp_password.equals("")) {
                    uid = temp_uid;
                    password = temp_password.toCharArray();
                    String serverRealm = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm");
                    String defaultRealm = contextManager.getDefaultRealm();
                    if (!(realm.equals(defaultRealm) || realm.equals(serverRealm) || realm.equals("<default>"))) {
                        String exceptionMessage = "The login will be failed because the Kerberos realm name specified in the callback handler, " + realm + ", does not match the Kerberos realm name specified in the server's security configuration: " + serverRealm + " or the default realm name: " + defaultRealm;
                        if (this.debug || tc.isEntryEnabled()) {
                            Tr.exit(tc, "login()", exceptionMessage);
                        }
                        throw new WSLoginFailedException(exceptionMessage);
                    }
                    try {
                        GSSCredential _gssCred;
                        Subject temp_subject;
                        LoginContext lc = new LoginContext("JAASClient", new WSCallbackHandlerImpl(uid, temp_password));
                        lc.login();
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting subject from login context.");
                        }
                        if ((temp_subject = lc.getSubject()) != null && (_gssCred = Krb5Utils.createGSSCredential(temp_subject)) != null) {
                            com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    if (!Krb5LoginModuleWrapper.this._subject.getPrivateCredentials().contains(_gssCred)) {
                                        if (Krb5LoginModuleWrapper.this.debug || tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding GSSCredential to Subject.");
                                        }
                                        Krb5LoginModuleWrapper.this._subject.getPrivateCredentials().add(_gssCred);
                                    }
                                    return null;
                                }
                            });
                        }
                        this.succeeded = true;
                        return this.succeeded;
                    }
                    catch (LoginException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "489", (Object)this);
                        if (this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception calling JAASClient login context: " + e.toString());
                        }
                        this.succeeded = true;
                        return this.succeeded;
                    }
                }
            }
            if (WSCredentialTokenMapper.isAnyPropagationEnabled() && authzTokenList != null && credToken == null) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.debug(tc, "Security attribute propagation data has been received.  Handling login outside this login module.");
                    Tr.exit(tc, "login()");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            if (uid == null && (password == null || password.length == 0) && credToken == null) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "No uid, password and Kerberos token have been received. Skipping Krb5LoginModuleWrapper. Handling login outside this login module.");
                }
                this.isKerberosLogin = false;
                this.succeeded = true;
                return this.succeeded;
            }
            if (uid != null && (password == null || password.length == 0) && credToken == null) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "uid with no password and no credToken has been received. Handling login outside this login module.");
                }
                this.isKerberosLogin = false;
                this.succeeded = true;
                return this.succeeded;
            }
            if (uid != null && password != null) {
                this.login_called = true;
                String serverRealm = SecurityObjectLocator.getSecurityConfig("security").getAuthMechanism("KRB5").getString("krb5Realm");
                String defaultRealm = contextManager.getDefaultRealm();
                if (!(realm.equals(defaultRealm) || realm.equals(serverRealm) || realm.equals("<default>"))) {
                    String exceptionMessage = "The login failed because the Kerberos realm name specified in the callback handler, " + realm + ", does not match the Kerberos realm name specified in the server's security configuration: " + serverRealm + " or the default realm name: " + defaultRealm;
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "login()", exceptionMessage);
                    }
                    throw new WSLoginFailedException(exceptionMessage);
                }
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling super.login() from wrapper with uid and password.");
                }
                try {
                    this.succeeded = super.login();
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "super.login() result: " + this.succeeded);
                    }
                    this._kTicket = (KerberosTicket)this._sharedState.get("javax.security.auth.kerberos.KerberosTicket");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "super.login(), _kTicket: " + this._kTicket);
                    }
                    this._kPrinc = (KerberosPrincipal)this._sharedState.get("javax.security.auth.kerberos.KerberosPrincipal");
                    this.addKrbAuthnTokenToSubject(this._kPrinc);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "552", (Object)this);
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "login()", new Object[]{e});
                    }
                    contextManager.setRootException(e);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                this.succeeded = true;
                return this.succeeded;
            }
            if (credToken != null) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using Kerberos token for authentication");
                }
                try {
                    this.login_called = false;
                    return this.validateKerberosToken(credToken);
                }
                catch (WSLoginFailedException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    if (!this.debug && !tc.isDebugEnabled()) break block77;
                    Tr.error(tc, "security.auth.kerberos.validateKerberosTokenException", new Object[]{e});
                }
            }
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling super.login() from wrapper.");
        }
        try {
            this.login_called = true;
            this.succeeded = super.login();
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "super.login() result: " + this.succeeded);
            }
            this._kTicket = (KerberosTicket)this._sharedState.get("javax.security.auth.kerberos.KerberosTicket");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "super.login(), _kTicket: " + this._kTicket);
            }
            this._kPrinc = (KerberosPrincipal)this._sharedState.get("javax.security.auth.kerberos.KerberosPrincipal");
            this.addKrbAuthnTokenToSubject(this._kPrinc);
            return this.succeeded;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.login", "595", (Object)this);
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "login()", new Object[]{e});
            }
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public boolean commit() throws LoginException {
        if (!this.isKerberosLogin) {
            return true;
        }
        if (this._krbAuthnToken != null && this._subject.getPrivateCredentials().contains(this._krbAuthnToken)) {
            this._subject.getPrivateCredentials().remove(this._krbAuthnToken);
        }
        if (this.login_called) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.commit() from wrapper.");
            }
            return super.commit();
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.login_called) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.abort() from wrapper.");
            }
            return super.abort();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.login_called) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling super.logout() from wrapper.");
            }
            return super.logout();
        }
        return true;
    }

    private boolean validateKerberosToken(byte[] CredToken) throws WSLoginFailedException {
        GSSContext serverContext;
        block44: {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "validateKerberosToken()");
            }
            byte[] outToken = null;
            GSSCredential serverCred = null;
            serverContext = null;
            boolean credDelegState = false;
            GSSManager _mgr = GSSManager.getInstance();
            try {
                Object[] parms;
                if (CredToken == null || CredToken.length == 0) {
                    throw new WSLoginFailedException("CredToken is null");
                }
                ContextManager contextManager = ContextManagerFactory.getInstance();
                try {
                    serverCred = contextManager.getServerSpnGSSCred();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "acceptSecContext: SPN GSScredentials: " + serverCred);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    Object[] parms2 = new Object[]{"getServerSpnGSSCred()", exc};
                    Tr.error(tc, "security.auth.kerberos.exception", parms2);
                    throw new WSLoginFailedException(exc.getMessage(), exc);
                }
                try {
                    serverContext = _mgr.createContext(serverCred);
                }
                catch (GSSException exc) {
                    exc.printStackTrace();
                    Object[] parms3 = new Object[]{"createContext()", exc};
                    Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms3);
                    throw new WSLoginFailedException(exc.getMessage(), exc);
                }
                Krb5Utils.setUseSubjectCredsOnly(true);
                try {
                    final GSSContext inServerContext = serverContext;
                    final byte[] inCredToken = CredToken;
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "acceptSecContext: calling acceptSecContext.");
                            }
                            return inServerContext.acceptSecContext(inCredToken, 0, inCredToken.length);
                        }
                    };
                    try {
                        outToken = (byte[])Subject.doAsPrivileged(this._subject, action, AccessController.getContext());
                    }
                    catch (PrivilegedActionException e) {
                        if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.validateKerberosToken", "754", (Object)this);
                        }
                        throw e.getException();
                    }
                }
                catch (GSSException exc) {
                    if (exc.getMinorString().contains("major code: 10, minor code: 37")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Suppressing SECJ9314E error message for retriable clock skew error.");
                        }
                        if (!SecurityMessages.suppressFFDCforKrbSkewError(exc)) {
                            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.validateKerberosToken", "764", (Object)this);
                        }
                    } else {
                        Object[] parms4 = new Object[]{"acceptSecContext()", exc};
                        Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms4);
                        FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.validateKerberosToken", "770", (Object)this);
                    }
                    throw new WSLoginFailedException(exc.getMessage(), exc);
                }
                catch (Exception e) {
                    Object[] parms5 = new Object[]{"acceptSecContext()", e};
                    Tr.error(tc, "security.auth.kerberos.exception", parms5);
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.validateKerberosToken", "777", (Object)this);
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                if (outToken == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "acceptSecContext: outToken is null");
                }
                if (this._subject != null && this._subject.toString().length() != 0) {
                    this._kTicket = SubjectHelper.getKerberosTicketFromSubject(this._subject);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "acceptSecContext: " + this._subject.toString());
                        Tr.debug(tc, "acceptSecContext: _kTicket: " + this._kTicket);
                    }
                    if (this._kTicket != null) {
                        this._sharedState.put("javax.security.auth.kerberos.KerberosTicket", this._kTicket);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "acceptSecContext: subject is null.");
                }
                if (serverContext.isEstablished()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "acceptSecContext: serverContext established successfully.");
                    }
                } else {
                    Object[] parms6 = new Object[]{serverContext};
                    Tr.error(tc, "security.auth.kerberos.init.ctxnotestablished", parms6);
                    throw new WSLoginFailedException("Server context is not establish");
                }
                boolean enabledGssCredDel = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getBoolean("enabledGssCredDelegate");
                if (enabledGssCredDel) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "acceptSecContext: delegated credentials state for the context is " + serverContext.getCredDelegState());
                        }
                        this._gssCred = serverContext.getDelegCred();
                    }
                    catch (GSSException exc) {
                        parms = new Object[]{"getDelegCred()", exc};
                        Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                    }
                }
                GSSName gssUserName = null;
                gssUserName = this._gssCred != null ? this._gssCred.getName() : serverContext.getSrcName();
                if (gssUserName != null) {
                    String userName = ((Object)gssUserName).toString();
                    this._kPrinc = new KerberosPrincipal(userName);
                    this.addKrbAuthnTokenToSubject(this._kPrinc);
                    this._sharedState.put("javax.security.auth.kerberos.KerberosPrincipal", this._kPrinc);
                    if (!this._subject.getPrivateCredentials().contains(this._kPrinc)) {
                        this._subject.getPrivateCredentials().add(this._kPrinc);
                    }
                    if (this._gssCred == null && enabledGssCredDel) {
                        Tr.warning(tc, "security.auth.kerberos.noDelegatedCredentialsFound", userName);
                    }
                    break block44;
                }
                parms = new Object[]{serverContext};
                Tr.error(tc, "security.auth.kerberos.gssUserNameIsNull", parms);
                throw new WSLoginFailedException("GSS user name is null");
            }
            catch (Exception exc) {
                if (exc.getMessage().contains("major code: 10, minor code: 37")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Suppressing SECJ9314E error message for retriable clock skew error.");
                    }
                } else {
                    Object[] parms = new Object[]{"validateKerberosToken()", exc};
                    Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                }
                if (exc instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)exc;
                }
                throw new WSLoginFailedException(exc.getMessage(), exc);
            }
        }
        if (serverContext != null) {
            try {
                serverContext.dispose();
            }
            catch (GSSException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper.validateKerberosToken", "868", (Object)this);
                Object[] parms = new Object[]{"dispose()", exc};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            }
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "validateKerberosToken()");
        }
        return true;
    }

    public void addKrbAuthnTokenToSubject(KerberosPrincipal kPrinc) {
        if (kPrinc != null) {
            this._krbAuthnToken = Krb5Utils.createKRBAuthnToken(null, null, kPrinc, null, 0L);
            if (this._krbAuthnToken != null && !this._subject.getPrivateCredentials().contains(this._krbAuthnToken)) {
                this._subject.getPrivateCredentials().add(this._krbAuthnToken);
            }
        }
    }
}

