/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.omg.CORBA.INTERNAL;

public class KerberosPolicy {
    private String spnName = null;
    private String realmName = null;
    byte[] krb5_policy_bytes = null;
    private static final String kerberos_policy_header = "KRB5_POLICY";
    int policy_version = 1;
    private static final TraceComponent tc = Tr.register(KerberosPolicy.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public KerberosPolicy(String _spnName, String _realmName) {
        this.spnName = _spnName;
        this.realmName = _realmName;
    }

    public KerberosPolicy(byte[] _krb5_policy_bytes) throws Exception {
        this.krb5_policy_bytes = _krb5_policy_bytes;
        this.constructFromBytes(this.krb5_policy_bytes);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Kerberos policy contents after de-serialization: " + this.toString());
        }
    }

    public String get_spn_name() {
        return this.spnName;
    }

    public String get_realm_name() {
        return this.realmName;
    }

    public byte[] getBytes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Policy contents prior to serialization: " + this.toString());
        }
        if (this.krb5_policy_bytes == null) {
            this.krb5_policy_bytes = this.serializeVariables();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", this.krb5_policy_bytes);
        }
        return this.krb5_policy_bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeVariables() throws Exception {
        DataOutputStream dos;
        ByteArrayOutputStream baos;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "serializeVariables", this);
            }
            baos = new ByteArrayOutputStream(300);
            dos = new DataOutputStream(baos);
            try {
                try {
                    byte[] kerberos_policy_header_bytes = kerberos_policy_header.getBytes("UTF-8");
                    dos.writeInt(kerberos_policy_header.length());
                    dos.write(kerberos_policy_header_bytes, 0, kerberos_policy_header.length());
                    dos.writeInt(this.policy_version);
                    if (this.spnName != null && this.spnName.length() > 0) {
                        byte[] spnName_bytes = this.spnName.getBytes("UTF-8");
                        dos.writeInt(this.spnName.length());
                        dos.write(spnName_bytes, 0, this.spnName.length());
                    } else {
                        dos.writeInt(0);
                    }
                    if (this.realmName != null && this.realmName.length() > 0) {
                        byte[] realmName_bytes = this.realmName.getBytes("UTF-8");
                        dos.writeInt(this.realmName.length());
                        dos.write(realmName_bytes, 0, this.realmName.length());
                    } else {
                        dos.writeInt(0);
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.KerberosPolicy.serializeVariables", "851", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception serializing native variables.", new Object[]{e});
                    }
                    throw e;
                }
                Object var6_6 = null;
                if (baos == null) break block15;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (baos != null) {
                    baos.close();
                }
                if (dos != null) {
                    dos.close();
                }
                throw throwable;
            }
            baos.close();
        }
        if (dos != null) {
            dos.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeVariables");
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void constructFromBytes(byte[] policy_bytes) throws Exception {
        DataInputStream dis;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "constructFromBytes", new Object[]{policy_bytes, this});
            }
            ByteArrayInputStream bais = null;
            dis = null;
            if (policy_bytes == null) {
                throw new INTERNAL("Service context data is not found.");
            }
            try {
                block15: {
                    try {
                        int version;
                        bais = new ByteArrayInputStream(policy_bytes);
                        dis = new DataInputStream(bais);
                        String header = null;
                        int stringSize = dis.readInt();
                        if (stringSize > 0) {
                            byte[] stringBytes = new byte[stringSize];
                            dis.read(stringBytes, 0, stringSize);
                            header = new String(stringBytes);
                        }
                        if (!header.equals(kerberos_policy_header)) {
                            // empty if block
                        }
                        if ((version = dis.readInt()) == 1) {
                            this.deserializeVariablesV1(dis);
                            break block15;
                        }
                        if (version > 1) {
                            this.deserializeVariablesV1(dis);
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.KerberosPolicy.constructFromBytes", "639", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception constructing private service context.", new Object[]{e});
                        }
                        throw e;
                    }
                }
                Object var8_9 = null;
                if (bais == null) break block16;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (bais != null) {
                    bais.close();
                }
                if (dis != null) {
                    dis.close();
                }
                throw throwable;
            }
            bais.close();
        }
        if (dis != null) {
            dis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructFromBytes");
        }
    }

    private void deserializeVariablesV1(DataInputStream dis) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeVariables");
        }
        try {
            byte[] stringBytes;
            int stringSize = dis.readInt();
            if (stringSize > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.spnName = new String(stringBytes, "UTF-8");
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.realmName = new String(stringBytes, "UTF-8");
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.KerberosPolicy.deserializeVariables", "947", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception de-serializing native variables.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeVariables");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nspnName " + this.spnName);
        sb.append("\nrealmName " + this.realmName);
        return sb.toString();
    }
}

