/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.GenericCredentialImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.ltpa.Token;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.AuthPermission;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class WSCredentialImpl
implements WSCredential {
    private String realmname;
    private String username;
    private String uniqueusername;
    private String realmusername;
    private String realmuniqueusername;
    private String hostname;
    private String oid;
    private String primaryGroupId;
    private String accessId;
    private Token token = null;
    private byte[] credentialToken;
    private boolean forwardable;
    private long expiration = 0L;
    private boolean unauthenticated = false;
    private ArrayList groupIds;
    private ArrayList roles;
    private Hashtable hashTable = null;
    private boolean isBasicAuthCred = false;
    private boolean destroyed = false;
    private byte[] refreshSync = null;
    private byte[] serverCredCipher = null;
    private byte[] wsCredCipher = null;
    private GenericCredentialImpl genericCred = null;
    private Subject wsSubject = null;
    private boolean isServerCred = false;
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    static final long serialVersionUID = 4148961460865333593L;
    private static final AuthPermission APP_READ_PERMISSION = new AuthPermission("wssecurity.applicationReadCredential");
    private static final AuthPermission APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");
    private static final AuthPermission READ_PERMISSION = new AuthPermission("wssecurity.readCredential");
    private static final AuthPermission UPDATE_PERMISSION = new AuthPermission("wssecurity.updateCredential");
    private static final AuthPermission CREATE_PERMISSION = new AuthPermission("wssecurity.createCredential");
    private static final AuthPermission DESTROY_PERMISSION = new AuthPermission("wssecurity.destroyCredential");
    private static final AuthPermission REFRESH_PERMISSION = new AuthPermission("wssecurity.refreshCredential");
    private static final TraceComponent tc = Tr.register(WSCredentialImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public WSCredentialImpl(String _realmName, String _securityName, String _uniqueSecurityName, String _primaryGroupId, String _accessId, ArrayList _roles, ArrayList _groupIds) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{_realmName, _securityName, _uniqueSecurityName, _primaryGroupId, _accessId, _roles, _groupIds});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = _realmName;
        this.username = _securityName;
        this.uniqueusername = _uniqueSecurityName;
        this.primaryGroupId = _primaryGroupId;
        this.accessId = _accessId;
        this.hashTable = new Hashtable(32);
        if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
            this.unauthenticated = true;
        }
        this.roles = _roles != null ? (ArrayList)_roles.clone() : new ArrayList();
        ArrayList arrayList = this.groupIds = _groupIds != null ? (ArrayList)_groupIds.clone() : new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(String _realmName, String _securityName, String _uniqueSecurityName, String _primaryGroupId, String _accessId, ArrayList _groupIds, ArrayList _roles, String _oid, Token _token, boolean _forwardable, long _expiration) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{_realmName, _securityName, _uniqueSecurityName, _primaryGroupId, _accessId, _groupIds, _oid, _token, new Boolean(_forwardable), new Long(_expiration)});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = _realmName;
        this.username = _securityName;
        this.uniqueusername = _uniqueSecurityName;
        this.primaryGroupId = _primaryGroupId;
        this.accessId = _accessId;
        this.oid = _oid;
        this.token = _token;
        this.forwardable = _forwardable;
        this.expiration = _expiration;
        this.hashTable = new Hashtable(32);
        if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
            this.unauthenticated = true;
        }
        this.roles = _roles != null ? (ArrayList)_roles.clone() : new ArrayList();
        ArrayList arrayList = this.groupIds = _groupIds != null ? (ArrayList)_groupIds.clone() : new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(WSCredential registryCred, String _oid, Token _token, boolean _forwardable, long _expiration) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{registryCred, _oid, _token, new Boolean(_forwardable), new Long(_expiration)});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = registryCred.getRealmName();
            this.username = registryCred.getSecurityName();
            this.uniqueusername = registryCred.getUniqueSecurityName();
            this.primaryGroupId = registryCred.getPrimaryGroupId();
            this.accessId = registryCred.getAccessId();
            this.roles = registryCred.getRoles();
            this.groupIds = registryCred.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = _oid;
            this.forwardable = _forwardable;
            this.expiration = _expiration;
            this.token = _token;
            this.hashTable = ((WSCredentialImpl)registryCred).getTable();
            if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
                this.unauthenticated = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while creating credential.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSCredentialImpl.constructor", "222");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(WSCredential registryCred, String _oid, byte[] _token, boolean _forwardable, long _expiration) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{registryCred, _oid, _token, new Boolean(_forwardable), new Long(_expiration)});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
        try {
            this.refreshSync = new byte[0];
            this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
            this.realmname = registryCred.getRealmName();
            this.username = registryCred.getSecurityName();
            this.uniqueusername = registryCred.getUniqueSecurityName();
            this.primaryGroupId = registryCred.getPrimaryGroupId();
            this.accessId = registryCred.getAccessId();
            this.roles = registryCred.getRoles();
            this.groupIds = registryCred.getGroupIds();
            this.hashTable = new Hashtable(32);
            this.oid = _oid;
            this.forwardable = _forwardable;
            this.expiration = _expiration;
            this.credentialToken = _token;
            this.hashTable = ((WSCredentialImpl)registryCred).getTable();
            if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
                this.unauthenticated = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred while creating credential.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSCredentialImpl.constructor", "266");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl(String _realmName, String _securityName, String _password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{_realmName, _securityName, _password == null ? null : "****"});
        }
        this.refreshSync = new byte[0];
        this.wsCredCipher = ServerCredSigner.getInstance().getEncryptedWSCredSigner();
        this.realmname = _realmName;
        this.username = _securityName;
        this.uniqueusername = _securityName;
        this.accessId = _securityName;
        this.credentialToken = StringBytesConversion.getConvertedBytes(_password);
        this.isBasicAuthCred = true;
        this.oid = "oid:2.23.130.1.1.1";
        this.forwardable = true;
        this.expiration = 0L;
        this.hashTable = new Hashtable(32);
        this.groupIds = new ArrayList();
        if (this.username.endsWith(ctxMgr.getUnauthenticatedString())) {
            this.unauthenticated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSCredentialImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.realmname = null;
        this.realmusername = null;
        this.realmuniqueusername = null;
        this.username = null;
        this.uniqueusername = null;
        this.oid = null;
        this.primaryGroupId = null;
        this.accessId = null;
        this.forwardable = false;
        this.expiration = 0L;
        this.credentialToken = null;
        this.groupIds = null;
        this.hashTable = null;
        this.isBasicAuthCred = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup", this);
        }
    }

    public GenericCredentialImpl getGenericCredential() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericCredential", this.genericCred);
        }
        return this.genericCred;
    }

    public void setGenericCredential(GenericCredentialImpl gCred) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGenericCredential", gCred);
        }
        this.genericCred = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setGenericCredential");
        }
    }

    public void setSubject(Subject subject) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubject", subject);
        }
        this.wsSubject = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSubject");
        }
    }

    public Subject getSubject() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject", this.wsSubject);
        }
        return this.wsSubject;
    }

    public String getRealmName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmName", this.realmname);
        }
        return this.realmname;
    }

    public String getSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", this.username);
        }
        return this.username;
    }

    public String getRealmSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmSecurityName");
        }
        if (this.realmusername != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRealmSecurityName", this.realmusername);
            }
            return this.realmusername;
        }
        this.realmusername = this.getRealmName() + "/" + this.getSecurityName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmSecurityName", this.realmusername);
        }
        return this.realmusername;
    }

    public String getUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueSecurityName", this.uniqueusername);
        }
        return this.uniqueusername;
    }

    public String getRealmUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealmUniqueSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmUniqueSecurityName");
        }
        if (this.realmuniqueusername != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRealmUniqueSecurityName", this.realmuniqueusername);
            }
            return this.realmuniqueusername;
        }
        this.realmuniqueusername = this.getRealmName() + "/" + this.getUniqueSecurityName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealmUniqueSecurityName", this.realmuniqueusername);
        }
        return this.realmuniqueusername;
    }

    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialToken");
        }
        if (this.credentialToken != null) {
            if (tc.isDebugEnabled() && !this.isBasicAuthCred) {
                Tr.debug(tc, "Initializing credential token", new Object[]{this.credentialToken});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCredentialToken");
            }
            return this.credentialToken;
        }
        if (this.credentialToken == null && this.token != null) {
            try {
                this.credentialToken = this.token.getBytes();
                if (tc.isDebugEnabled() && !this.isBasicAuthCred) {
                    Tr.debug(tc, "Initializing credential token", new Object[]{this.credentialToken});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCredentialToken");
                }
                return this.credentialToken;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting bytes[] from token.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.WSCredentialImpl.getCredentialToken", "563");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCredentialToken");
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCredentialToken() -> null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken");
        }
        return null;
    }

    public String getHostName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostname");
        }
        if (this.hostname == null || this.hostname.length() == 0) {
            this.hostname = VaultImpl.getInstance().getORB().getLocalHost();
            if (this.hostname == null || this.hostname.length() == 0) {
                this.hostname = "localHost";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName", this.hostname);
        }
        return this.hostname;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOID", this.oid);
        }
        return this.oid;
    }

    public boolean isForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardable", new Boolean(this.forwardable));
        }
        return this.forwardable;
    }

    public boolean isForwardable(String target_realm) throws CredentialDestroyedException, CredentialExpiredException {
        return this.isForwardable(target_realm, null, null);
    }

    public boolean isForwardable(String target_realm, CSIv2EffectivePerformPolicy effectivePolicy, Subject subject) throws CredentialDestroyedException, CredentialExpiredException {
        boolean realm_check_needed;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardable: ", new Object[]{target_realm, effectivePolicy});
        }
        boolean krbAuthMechOid = false;
        if (effectivePolicy != null && OID.compareOIDs("oid:1.2.840.113554.1.2.2", effectivePolicy.getPerformClientAuthMechOID())) {
            krbAuthMechOid = true;
        }
        String current_realm = null;
        current_realm = krbAuthMechOid ? SubjectHelper.getKerberosRealmNameFromSubject(subject) : this.realmname;
        String default_realm = "<default>";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isForwardable current_realm is: " + current_realm);
        }
        boolean bl = realm_check_needed = current_realm != null && target_realm != null && !current_realm.equalsIgnoreCase(target_realm) && !current_realm.equalsIgnoreCase(default_realm);
        if (RasHelper.isServer() && realm_check_needed) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target realm does not match current realm, target realm: " + target_realm + ", current realm: " + current_realm + ". Going to check the outboundTrustedAuthenticationRealm property");
            }
            TrustedAuthenticationRealm outboundRealms = SecurityObjectLocator.getSecurityConfig().getOutboundTrustedAuthenticationRealm();
            String realmList = outboundRealms.getRealmList();
            boolean trustAllRealms = outboundRealms.getTrustAllRealms();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found outbound realms element: trustAllRealms = " + trustAllRealms + " : realmList = " + realmList);
            }
            if (trustAllRealms) {
                realm_check_needed = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "trustAllRealms is true");
                }
            }
            if (realm_check_needed) {
                if (realmList != null && !realmList.equals("")) {
                    StringTokenizer st = new StringTokenizer(realmList, "|");
                    while (st.hasMoreTokens()) {
                        String realm = st.nextToken();
                        if (!realm.equalsIgnoreCase(target_realm)) continue;
                        realm_check_needed = false;
                        break;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realmList String is null or empty");
                }
            }
        } else if (!RasHelper.isServer() && krbAuthMechOid) {
            realm_check_needed = false;
        }
        if (realm_check_needed && tc.isDebugEnabled()) {
            Tr.debug(tc, "Target realm does not match current realm, target realm: " + target_realm + ", current realm: " + current_realm + ".");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isForwardable() -> " + !realm_check_needed);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardable", new Boolean(!realm_check_needed));
        }
        return !realm_check_needed;
    }

    public long getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpiration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration", new Long(this.expiration));
        }
        return this.expiration;
    }

    public String getPrimaryGroupId() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrimaryGroupId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrimaryGroupId", this.primaryGroupId);
        }
        return this.primaryGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRoles() throws CredentialDestroyedException, CredentialExpiredException {
        block6: {
            ArrayList arrayList;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getRoles");
            }
            try {
                if (this.roles == null) break block6;
                arrayList = (ArrayList)this.roles.clone();
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var3_5 = null;
                    if (!tc.isEntryEnabled()) break block7;
                    Tr.exit(tc, "getRoles", this.roles);
                }
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRoles", this.roles);
            }
            return arrayList;
        }
        ArrayList arrayList = null;
        Object var3_4 = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoles", this.roles);
        }
        return arrayList;
    }

    public String getAccessId() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", this.accessId);
        }
        return this.accessId;
    }

    public ArrayList getGroupIds() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIds", this.groupIds);
        }
        return (ArrayList)this.groupIds.clone();
    }

    public Object get(String key) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", key);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(APP_READ_PERMISSION);
        }
        if (key.startsWith("wssecurity") && sm != null) {
            sm.checkPermission(READ_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", this.hashTable);
        }
        return this.hashTable.get(key);
    }

    public Object set(String key, Object value) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "set", new Object[]{key, value});
        }
        SecurityManager sm = System.getSecurityManager();
        if (key.startsWith("wssecurity") && sm != null) {
            sm.checkPermission(UPDATE_PERMISSION);
        }
        if (this.hashTable.get(key) != null && sm != null) {
            sm.checkPermission(APP_UPDATE_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "set", this.hashTable);
        }
        return this.hashTable.put(key, value);
    }

    public boolean isCurrent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrent");
        }
        if (this.isDestroyed()) {
            return false;
        }
        boolean ret = false;
        try {
            long current_time;
            long time_remaining;
            ret = this.expiration != -1L && this.expiration != 0L ? ((time_remaining = this.expiration - (current_time = System.currentTimeMillis())) <= 0L ? ServerCredSigner.getInstance().isServerCred(this) : true) : true;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refresh of credential failed.");
            }
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSCredentialImpl.refresh", "927", this);
            ret = false;
        }
        if (tc.isDebugEnabled() && !ret) {
            Tr.debug(tc, "isCurrent() -> " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCurrent", new Boolean(ret));
        }
        return ret;
    }

    public boolean isUnauthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnauthenticated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnauthenticated", new Boolean(this.unauthenticated));
        }
        return this.unauthenticated;
    }

    public final void markAsUnauthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markAsUnauthenticated");
        }
        this.unauthenticated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markAsUnauthenticated");
        }
    }

    public void destroy() throws DestroyFailedException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(DESTROY_PERMISSION);
        }
        if (ServerCredSigner.getInstance().isServerCred(this)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy() -> Server cred cannot be destroyed");
            }
            return;
        }
        this.destroyed = true;
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public boolean isDestroyed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDestroyed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDestroyed", new Boolean(this.destroyed));
        }
        return this.destroyed;
    }

    public boolean isBasicAuth() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBasicAuth");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBasicAuth", new Boolean(this.isBasicAuthCred));
        }
        return this.isBasicAuthCred;
    }

    public void refresh() throws RefreshFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
        throw new RefreshFailedException("Refresh is not supported in this mechanism.");
    }

    public Hashtable getTable() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTable");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(READ_PERMISSION);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTable", this.hashTable);
        }
        return this.hashTable != null ? (Hashtable)this.hashTable.clone() : null;
    }

    public void setTable(Hashtable table) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTable", table);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(UPDATE_PERMISSION);
        }
        this.hashTable = (Hashtable)table.clone();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTable");
        }
    }

    protected void markServerCred(byte[] cipher) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerCred", cipher);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(UPDATE_PERMISSION);
        }
        this.serverCredCipher = cipher;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerCred");
        }
    }

    protected byte[] getServerCredCipher() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerCredCipher");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerCredCipher", this.serverCredCipher);
        }
        return this.serverCredCipher;
    }

    public boolean isServerCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCred", new Boolean(this.isServerCred));
        }
        return this.isServerCred;
    }

    public boolean isWSCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSCred");
        }
        return true;
    }

    public void markServerCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markServerCred");
        }
        this.isServerCred = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markServerCred");
        }
    }

    protected byte[] getWSCredCipher() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSCredCipher");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSCredCipher", this.wsCredCipher);
        }
        return this.wsCredCipher;
    }

    public Token getTokenObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenObject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenObject(token not null? " + (this.token != null) + ")");
        }
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshCred(WSCredential wsCred) throws WSSecurityException {
        block15: {
            SecurityManager sm;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshCred", wsCred);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(UPDATE_PERMISSION);
            }
            try {
                if (wsCred.isBasicAuth()) break block15;
                if (wsCred != null && !this.destroyed) {
                    byte[] byArray = this.refreshSync;
                    // MONITORENTER : this.refreshSync
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Refreshing only the credential token and expiration: " + new Date(wsCred.getExpiration()));
                    }
                    this.credentialToken = wsCred.getCredentialToken();
                    this.expiration = wsCred.getExpiration();
                    this.token = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completed refresh.");
                    }
                    // MONITOREXIT : byArray
                    break block15;
                }
                if (wsCred != null) {
                    byte[] byArray = this.refreshSync;
                    // MONITORENTER : this.refreshSync
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Refreshing the entire WSCredential.");
                    }
                    this.destroyed = true;
                    this.token = null;
                    this.realmuniqueusername = null;
                    this.realmusername = null;
                    this.credentialToken = wsCred.getCredentialToken();
                    this.expiration = wsCred.getExpiration();
                    this.realmname = wsCred.getRealmName();
                    this.username = wsCred.getSecurityName();
                    this.uniqueusername = wsCred.getUniqueSecurityName();
                    this.hostname = wsCred.getHostName();
                    this.oid = wsCred.getOID();
                    this.primaryGroupId = wsCred.getPrimaryGroupId();
                    this.accessId = wsCred.getAccessId();
                    this.forwardable = wsCred.isForwardable();
                    this.unauthenticated = false;
                    this.groupIds = wsCred.getGroupIds();
                    this.roles = wsCred.getRoles();
                    this.hashTable = ((WSCredentialImpl)wsCred).getTable();
                    this.isBasicAuthCred = false;
                    this.destroyed = false;
                    wsCred = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Completed refresh.");
                    }
                    // MONITOREXIT : byArray
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred while refreshing credential.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.WSCredentialImpl.refreshCred", "1227", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "refreshCred");
    }

    public String toString() {
        return super.toString();
    }
}

