/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.KerberosToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.wssecurity.platform.token.AuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class SubjectHelper {
    private static Subject unauthenticatedSubject = null;
    private static final TraceComponent tc = Tr.register(SubjectHelper.class, null, "com.ibm.ejs.resources.security");
    private static Integer maxSizeValue = null;
    private static String currentHost = null;
    private static Oid krb5MechOid = null;
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static final Class thisClass = SubjectHelper.class;
    private static String propagateFirstCallerOnlyProperty = null;
    private static boolean propagateFirstCallerOnly = false;
    private static String disableCallerListProperty = null;
    private static boolean disableCallerList = false;

    public static Subject createSubjectFromWSCredential(WSCredential cred) {
        return SubjectHelper.createSubjectFromWSCredential(cred, null);
    }

    public static Subject createSubjectFromWSCredential(final WSCredential cred, WSPrincipal principal) {
        if (cred == null) {
            return null;
        }
        if (principal == null) {
            try {
                principal = SubjectHelper.createPrincipal(cred);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createSubjectFromWSCredential", "168");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating principal from WSCredential.", new Object[]{e});
                }
                return null;
            }
        }
        try {
            final Subject subject = new Subject();
            final WSPrincipal principalPriv = principal;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!subject.getPrincipals().contains(principalPriv)) {
                        subject.getPrincipals().add(principalPriv);
                    }
                    if (!subject.getPublicCredentials().contains(cred)) {
                        subject.getPublicCredentials().add(cred);
                    }
                    return null;
                }
            });
            return subject;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createSubjectFromWSCredential", "200");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception creating Subject from WSCredential.", new Object[]{e});
            }
            return null;
        }
    }

    public static boolean subjectContainsCredential(Subject subject) {
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject passed in is null. Returning false");
            }
            return false;
        }
        Set<Object> publicCreds = subject.getPublicCredentials();
        if (publicCreds != null && publicCreds.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject passed has publicCreds. Returning true");
            }
            return true;
        }
        return false;
    }

    public static WSCredential getWSCredentialFromSubject(Subject subject) {
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject passed in is null.");
            }
            return null;
        }
        Set<Object> publicCreds = subject.getPublicCredentials();
        if (publicCreds != null && publicCreds.size() > 0) {
            for (Object cred : publicCreds) {
                if (cred == null || !(cred instanceof WSCredential)) continue;
                return (WSCredential)cred;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSCredential not present in Subject.");
        }
        return null;
    }

    public static GSSCredential getGSSCredentialFromSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGSSCredentialFromSubject");
        }
        if (subject == null) {
            return null;
        }
        GSSCredential credential = null;
        try {
            credential = (GSSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Set<GSSCredential> privCredentials;
                        GSSCredential gssCredInSubject2 = null;
                        Set<KRBAuthnToken> privateCredentials = subject.getPrivateCredentials(KRBAuthnToken.class);
                        if (privateCredentials != null) {
                            KRBAuthnToken krbAuthnToken = null;
                            Iterator<KRBAuthnToken> privCredIterator = privateCredentials.iterator();
                            while (privCredIterator.hasNext() && krbAuthnToken == null) {
                                krbAuthnToken = privCredIterator.next();
                            }
                            if (krbAuthnToken != null) {
                                gssCredInSubject2 = krbAuthnToken.getGSSCredential();
                            }
                        }
                        if (gssCredInSubject2 == null && (privCredentials = subject.getPrivateCredentials(GSSCredential.class)) != null) {
                            for (GSSCredential gssCredInSubject2 : privCredentials) {
                            }
                        }
                        return gssCredInSubject2;
                    }
                    catch (Throwable t) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting GSSCredential from krbAuthnToken or subject.", new Object[]{t});
                        }
                        return null;
                    }
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found default GSSCredential? " + (credential != null));
            }
            return credential;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getGSSCredentialFromSubject", "335");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting GSSCredential from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static boolean putGSSCredentialInSubject(final GSSCredential gssCred, final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putGSSCredentialInSubject");
        }
        if (subject == null || gssCred == null) {
            return false;
        }
        try {
            Boolean added = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (!subject.getPrivateCredentials().contains(GSSCredential.class)) {
                        block4: {
                            try {
                                KerberosPrincipal krbPrinc = new KerberosPrincipal(((Object)gssCred.getName()).toString());
                                if (!subject.getPrincipals().contains(krbPrinc)) {
                                    subject.getPrincipals().add(krbPrinc);
                                }
                            }
                            catch (GSSException ge) {
                                Manager.Ffdc.log(ge, this, "com.ibm.ws.security.auth.SubjectHelper.putGSSCredentialInSubject", "370");
                                if (!tc.isDebugEnabled()) break block4;
                                Tr.debug(tc, "Exception adding Kerberos principal to Subject.", new Object[]{ge});
                            }
                        }
                        subject.getPrivateCredentials().add(gssCred);
                        return true;
                    }
                    return false;
                }
            });
            return added;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.putGSSCredentialInSubject", "385");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding GSSCredential to Subject.", new Object[]{e});
            }
            return false;
        }
    }

    public static boolean isKerberosTicketRenewable(KerberosTicket krbTicket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKerberosTicketRenewable");
        }
        boolean renewable = false;
        if (krbTicket != null) {
            if (!krbTicket.isRenewable() && tc.isEntryEnabled()) {
                Tr.debug(tc, "Kerberos ticket is not renewable");
                Tr.exit(tc, "isKerberosTicketRenewable: " + new Object[]{krbTicket});
                return renewable;
            }
            if (!krbTicket.isCurrent() && tc.isEntryEnabled()) {
                Tr.debug(tc, "Kerberos ticket is not current");
                Tr.exit(tc, "isKerberosTicketRenewable: " + new Object[]{krbTicket});
                return renewable;
            }
            Date renewTill = krbTicket.getRenewTill();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "renewTill: " + renewTill);
            }
            if (renewTill != null) {
                long renewTillInSeconds = renewTill.getTime();
                long currentTime = System.currentTimeMillis();
                long timeleft = renewTillInSeconds - currentTime - 300000L;
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "renewTillInSeconds: " + renewTillInSeconds);
                    Tr.debug(tc, "currentTime: " + currentTime);
                    Tr.debug(tc, "timeleft: " + timeleft);
                    Tr.debug(tc, "Kerberos tickets: " + new Object[]{krbTicket});
                }
                if (timeleft > 0L) {
                    renewable = true;
                }
            }
        } else if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Kerberos ticket is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKerberosTicketRenewable " + renewable);
        }
        return renewable;
    }

    public static SingleSignonToken getDefaultSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        SingleSignonToken ssoToken = null;
        try {
            ssoToken = (SingleSignonToken)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (SingleSignonToken ssoToken : subject.getPrivateCredentials(SingleSignonToken.class)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing SSO token with name: " + ssoToken.getName());
                        }
                        if (!ssoToken.getName().equals("LtpaToken")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found default SSO token.");
                        }
                        return ssoToken;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not find default SSO token.");
                    }
                    return null;
                }
            });
            return ssoToken;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getDefaultSSOTokenFromSubject", "489");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SingleSignonToken from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static AuthorizationToken getDefaultAuthzTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthorizationToken authzToken2 = null;
        try {
            for (AuthorizationToken authzToken2 : subject.getPrivateCredentials(AuthorizationToken.class)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing AUTHZ token with name: " + authzToken2.getName());
                }
                if (!authzToken2.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default AuthorizationToken.");
                }
                return authzToken2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Authorization token.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getDefaultAuthzTokenFromSubject", "530");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthorizationToken from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static AuthenticationToken getDefaultAuthTokenFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        AuthenticationToken authToken = null;
        try {
            Iterator<AuthenticationToken> authIterator = subject.getPrivateCredentials(AuthenticationToken.class).iterator();
            if (authIterator.hasNext()) {
                authToken = authIterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing AUTH token with name: " + authToken.getName());
                }
                return authToken;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default AuthenticationToken.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getDefaultAuthzTokenFromSubject", "565");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting AuthenticationToken from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static KerberosToken getDefaultKerberosTokenFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKerberosTokenFromSubject");
        }
        if (subject == null) {
            return null;
        }
        KerberosToken kerberosToken2 = null;
        try {
            for (KerberosToken kerberosToken2 : subject.getPrivateCredentials(KerberosToken.class)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing Kerberos token with name: " + kerberosToken2.getName());
                }
                if (!kerberosToken2.getName().equals("com.ibm.ws.security.token.KerberosTokenImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default KerberosToken.");
                }
                return kerberosToken2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Kerberos token.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getDefaultKerberosTokenFromSubject", "531");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting KerberosToken from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static KerberosToken getDefaultKerberosServiceTicketFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKerberosTokenFromSubject");
        }
        if (subject == null) {
            return null;
        }
        KerberosToken kerberosTicket2 = null;
        try {
            for (KerberosToken kerberosTicket2 : subject.getPrivateCredentials(KerberosToken.class)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing Kerberos ticket with name: " + kerberosTicket2.getName());
                }
                if (!kerberosTicket2.getName().equals("com.ibm.ws.security.token.KerberosServiceTicketImpl")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default KerberosServiceTicket.");
                }
                return kerberosTicket2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find default Kerberos Service Ticket.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getDefaultKerberosServiceTicketFromSubject", "573");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting KerberosServiceTicket from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static long getKerberosTicketExpirationTime(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosTicketExpirationTime", subject);
        }
        long time2 = 0L;
        KerberosTicket krbTicket = SubjectHelper.getKerberosTicketFromSubject(subject);
        if (krbTicket != null) {
            time2 = krbTicket.getEndTime().getTime();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosTicketExpirationTime " + time2);
        }
        return time2;
    }

    public static long getKerberosTicketExpirationTime(KerberosTicket krbTicket) {
        if (krbTicket != null) {
            return krbTicket.getEndTime().getTime();
        }
        return 0L;
    }

    public static KerberosTicket getKerberosTicketFromSubject(Subject subject) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKerberosTicketFromSubject", subject);
            }
            KerberosTicket krbTicket = null;
            if (subject != null) {
                KRBAuthnToken krbToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
                if (krbToken != null && krbToken instanceof KRBTicket) {
                    krbTicket = ((KRBTicket)((Object)krbToken)).getKerberosTicket();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found default Kerberos Ticket");
                    }
                    return krbTicket;
                }
                try {
                    Set<KerberosTicket> kerberosTickets = subject.getPrivateCredentials(KerberosTicket.class);
                    if (kerberosTickets.size() > 1) {
                        Tr.warning(tc, "Multiple Kerberos tickets found");
                    }
                    for (KerberosTicket credObj : kerberosTickets) {
                        if (!(credObj instanceof KerberosTicket)) continue;
                        krbTicket = credObj;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found default Kerberos Ticket");
                        }
                        return krbTicket;
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getKerberosTicketFromSubject", "647");
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception getting Kerberos ticket from Subject.", new Object[]{e});
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not find default Kerberos Ticket.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String getKerberosRealmNameFromSubject(Subject subject) {
        if (SubjectHelper.tc.isEntryEnabled()) {
            Tr.entry(SubjectHelper.tc, "getKerberosRealmNameFromSubject", subject);
        }
        realmName = null;
        if (subject != null) {
            principal = null;
            cred = SubjectHelper.getGSSCredentialFromSubject(subject);
            if (cred != null) {
                try {
                    principal = cred.getName(SubjectHelper.getKrb5MechOid()).toString();
                    index = principal.indexOf("@");
                    if (principal == null || index == -1) ** GOTO lbl25
                    realmName = principal.substring(index + 1, principal.length());
                }
                catch (GSSException e) {
                    exceptionMessage = "Caught an exception trying to get the mechanism name from the GSS credential: " + e + ", codes: " + e.getMajor() + e.getMinor() + e.getMinorString();
                    if (SubjectHelper.tc.isDebugEnabled()) {
                        Tr.debug(SubjectHelper.tc, exceptionMessage);
                    }
                    Manager.Ffdc.log(e, SubjectHelper.thisClass, "com.ibm.ws.security.auth.SubjectHelper.getKerberosRealmNameFromSubject", "684", new Object[]{SubjectHelper.thisClass});
                    if (SubjectHelper.tc.isEntryEnabled()) {
                        Tr.exit(SubjectHelper.tc, "getKerberosRealmNameFromSubject", "false");
                    }
                    return null;
                }
            } else {
                krbToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
                if (krbToken != null) {
                    realmName = krbToken.getTokenRealm();
                }
            }
        }
lbl25:
        // 7 sources

        if (SubjectHelper.tc.isEntryEnabled()) {
            Tr.exit(SubjectHelper.tc, "getKerberosRealmNameFromSubject", realmName);
        }
        return realmName;
    }

    public static boolean putKerberosTicketToSubject(final KerberosTicket kerberosTickets, final Subject subject) {
        if (subject == null || kerberosTickets == null) {
            return false;
        }
        try {
            Boolean added = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Set<KerberosTicket> krbTicketsInSubject = subject.getPrivateCredentials(KerberosTicket.class);
                        if (krbTicketsInSubject.size() > 0) {
                            subject.getPrivateCredentials().remove(krbTicketsInSubject);
                        }
                        subject.getPrivateCredentials().add(kerberosTickets);
                    }
                    catch (Exception ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.SubjectHelper.putKerberosTicketToSubject", "674");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception putting Kerberos tickets to a Subject.", new Object[]{ex});
                        }
                        return false;
                    }
                    return true;
                }
            });
            return added;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.putKerberosTicketToSubject", "684");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding Kerberos ticket to Subject.", new Object[]{e});
            }
            return false;
        }
    }

    public static boolean isKerberosTicketExist(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKerberosTicketExist");
        }
        boolean exist = false;
        KerberosTicket krbTicket = SubjectHelper.getKerberosTicketFromSubject(subject);
        if (krbTicket != null) {
            exist = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKerberosTicketExist -> " + exist);
        }
        return exist;
    }

    public static boolean isWSCredentialValid(Subject subject) {
        return SubjectHelper.isWSCredentialValid(subject, false);
    }

    public static boolean isWSCredentialValid(final Subject subject, boolean useCushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSCredentialValid");
        }
        if (subject == null) {
            return false;
        }
        WSCredential credential = null;
        try {
            credential = (WSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (Object cred : subject.getPublicCredentials()) {
                        if (!(cred instanceof WSCredential)) continue;
                        return (WSCredential)cred;
                    }
                    return null;
                }
            });
            if (useCushion) {
                long expiration = credential.getExpiration();
                long cushion = ContextManagerFactory.getInstance().getReqTimeout();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cushion in use is " + cushion + " millis.");
                }
                if (expiration != -1L && expiration != 0L) {
                    long current_time = System.currentTimeMillis();
                    long time_remaining = expiration - (current_time + cushion);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Time remaining is: " + time_remaining + " millis.");
                    }
                    if (time_remaining <= 0L) {
                        return ServerCredSigner.getInstance().isServerCred(credential);
                    }
                    return true;
                }
                return true;
            }
            boolean current = credential.isCurrent();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Is credential valid? " + current);
            }
            return current;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getWSCredentialFromSubject", "792");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSCredential from Subject.", new Object[]{e});
            }
            return false;
        }
    }

    public static WSPrincipal getPrincipalFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        try {
            WSPrincipal principal = (WSPrincipal)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return subject.getPrincipals(WSPrincipal.class).iterator().next();
                }
            });
            return principal;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getPrincipalFromSubject", "826");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSPrincipal from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static WSPrincipal createPrincipal(WSCredential cred) throws WSSecurityException {
        WSPrincipal principal = null;
        try {
            if (cred != null) {
                String securityName = cred.getRealmSecurityName();
                if (securityName == null || securityName.length() == 0) {
                    StringBuffer buf = new StringBuffer(ContextManagerFactory.getInstance().getDefaultRealm());
                    buf.append("/").append(cred.getSecurityName());
                    securityName = buf.toString();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Principal name: " + securityName);
                }
                final String securityNamePriv = securityName;
                principal = (WSPrincipal)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new WSPrincipalImpl(securityNamePriv);
                    }
                });
            }
        }
        catch (CredentialExpiredException e) {
            throw new WSSecurityException(e.getMessage(), e);
        }
        return principal;
    }

    public static Subject createBasicAuthSubject(String realm, String user, String password) {
        WSCredentialImpl cred = null;
        cred = realm == null || realm.length() == 0 ? new WSCredentialImpl(ContextManagerFactory.getInstance().getDefaultRealm(), user, password) : new WSCredentialImpl(realm, user, password);
        return SubjectHelper.createSubjectFromWSCredential(cred);
    }

    public static Subject createUnauthenticatedSubject() {
        block3: {
            if (unauthenticatedSubject == null) {
                try {
                    WSCredentialImpl unAuthCred = new WSCredentialImpl("", ContextManagerFactory.getInstance().getUnauthenticatedString(), "");
                    unauthenticatedSubject = SubjectHelper.createSubjectFromWSCredential(unAuthCred);
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createUnauthenticatedSubject", "298");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception getting real unauthenticated subject, use constant UNAUTHENTICATED", new Object[]{e});
                }
            }
        }
        return unauthenticatedSubject;
    }

    public static Subject createNewSubjectFromExisting(Subject subject) {
        Subject temp_subject;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createNewSubjectFromExisting");
            }
            if (subject == null) {
                return null;
            }
            temp_subject = new Subject();
            try {
                Set<Object> publicSet = subject.getPublicCredentials();
                Set<Object> privateSet = subject.getPrivateCredentials();
                Set<Principal> principalSet = subject.getPrincipals();
                if (publicSet.size() > 0) {
                    for (Object publicObject : publicSet) {
                        temp_subject.getPublicCredentials().add(publicObject);
                    }
                }
                if (privateSet.size() > 0) {
                    for (Object privateObject : privateSet) {
                        temp_subject.getPrivateCredentials().add(privateObject);
                    }
                }
                if (principalSet.size() > 0) {
                    for (Principal principalObject : principalSet) {
                        temp_subject.getPrincipals().add(principalObject);
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createNewSubjectFromExisting", "970");
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Error copying existing Subject.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewSubjectFromExisting");
        }
        return temp_subject;
    }

    public static Subject createNewSubjectFromExisting(Subject subject, CSIv2EffectivePerformPolicy performPolicy) {
        Subject temp_subject;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createNewSubjectFromExisting", new Object[]{performPolicy});
            }
            if (subject == null) {
                return null;
            }
            temp_subject = new Subject();
            try {
                Set<Object> publicSet = subject.getPublicCredentials();
                Set<Object> privateSet = subject.getPrivateCredentials();
                Set<Principal> principalSet = subject.getPrincipals();
                String wscredOID = null;
                WSCredentialImpl newCred = null;
                boolean replaceAuthAuthzTokens = false;
                boolean wsCredFound = false;
                boolean authnTokenFound = false;
                boolean krbAuthnTokenFound = false;
                boolean authzTokenFound = false;
                String performOID = performPolicy.getPerformClientAuthMechOID();
                if (publicSet.size() > 0) {
                    for (Object publicObject : publicSet) {
                        if (OID.compareOIDs(performOID, "oid:1.3.18.0.2.30.2")) {
                            if (!wsCredFound && publicObject instanceof WSCredential) {
                                wsCredFound = true;
                                WSCredential cred = (WSCredential)publicObject;
                                WSCredentialImpl urCred = null;
                                Hashtable table = null;
                                wscredOID = cred.getOID();
                                if (OID.compareOIDs(wscredOID, "oid:1.2.840.113554.1.2.2")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "The OID of the effective perform policy [" + performOID + "] does not match the OID of the WSCredential [" + wscredOID + "]. Will create new WSCred, " + "auth, authz token using the OID of the effective perform policy.");
                                    }
                                    table = ((WSCredentialImpl)cred).getTable();
                                    urCred = new WSCredentialImpl(cred.getRealmName(), cred.getSecurityName(), cred.getUniqueSecurityName(), cred.getPrimaryGroupId(), cred.getAccessId(), cred.getRoles(), cred.getGroupIds());
                                    newCred = new WSCredentialImpl((WSCredential)urCred, performOID, cred.getCredentialToken(), cred.isForwardable(), cred.getExpiration());
                                    newCred.setTable(table);
                                    temp_subject.getPublicCredentials().add(newCred);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Updating Subject with new wsCred token.");
                                    }
                                    ((WSCredentialImpl)cred).refreshCred(newCred);
                                    replaceAuthAuthzTokens = true;
                                    continue;
                                }
                                temp_subject.getPublicCredentials().add(publicObject);
                                continue;
                            }
                            temp_subject.getPublicCredentials().add(publicObject);
                            continue;
                        }
                        temp_subject.getPublicCredentials().add(publicObject);
                    }
                }
                if (privateSet.size() > 0) {
                    for (Object privateObject : privateSet) {
                        if (!replaceAuthAuthzTokens) {
                            temp_subject.getPrivateCredentials().add(privateObject);
                            continue;
                        }
                        if (privateObject instanceof AuthenticationToken) {
                            if (!krbAuthnTokenFound && privateObject instanceof KRBAuthnToken) {
                                krbAuthnTokenFound = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Updating Subject with KRBAuthnToken.");
                                }
                                temp_subject.getPrivateCredentials().add(privateObject);
                                continue;
                            }
                            authnTokenFound = true;
                            continue;
                        }
                        if (!authzTokenFound && privateObject instanceof AuthorizationToken) {
                            authzTokenFound = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Updating Subject with new authz token.");
                            }
                            AuthorizationToken authzToken = ContextManagerFactory.getInstance().getWSCredTokenMapper().createAuthzTokenFromWSCredential(newCred);
                            temp_subject.getPrivateCredentials().remove(privateObject);
                            temp_subject.getPrivateCredentials().add(authzToken);
                            continue;
                        }
                        temp_subject.getPrivateCredentials().add(privateObject);
                    }
                }
                if (krbAuthnTokenFound && !authnTokenFound) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating Subject with new authn token.");
                    }
                    AuthenticationToken authnToken = ContextManagerFactory.getInstance().getWSCredTokenMapper().createAuthTokenFromWSCredential(newCred);
                    temp_subject.getPrivateCredentials().add(authnToken);
                }
                if (principalSet.size() > 0) {
                    for (Principal principalObject : principalSet) {
                        temp_subject.getPrincipals().add(principalObject);
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createNewSubjectFromExisting", "970");
                if (!tc.isDebugEnabled()) break block24;
                Tr.debug(tc, "Error copying existing Subject.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewSubjectFromExisting", temp_subject);
        }
        return temp_subject;
    }

    public static Subject createSubjectFromKRBAuthnToken(Subject subject) {
        Subject temp_subject;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubjectFromKRBAuthnToken");
            }
            if (subject == null) {
                return null;
            }
            KRBAuthnToken krbAuthnToken = null;
            GSSCredential gssCred = null;
            KerberosTicket kTicket = null;
            temp_subject = new Subject();
            try {
                Set<Object> publicSet = subject.getPublicCredentials();
                Set<Object> privateSet = subject.getPrivateCredentials();
                Set<Principal> principalSet = subject.getPrincipals();
                if (publicSet.size() > 0) {
                    for (Object publicObject : publicSet) {
                        temp_subject.getPublicCredentials().add(publicObject);
                    }
                }
                if (privateSet.size() > 0) {
                    for (Object privateObject : privateSet) {
                        if (privateObject instanceof KerberosTicket) {
                            kTicket = (KerberosTicket)privateObject;
                            continue;
                        }
                        if (privateObject instanceof GSSCredential) {
                            gssCred = (GSSCredential)privateObject;
                            continue;
                        }
                        if (privateObject instanceof KRBAuthnToken) {
                            krbAuthnToken = (KRBAuthnToken)privateObject;
                            continue;
                        }
                        temp_subject.getPrivateCredentials().add(privateObject);
                    }
                    if (krbAuthnToken != null) {
                        GSSCredential gss = krbAuthnToken.getGSSCredential();
                        if (gss != null) {
                            temp_subject.getPrivateCredentials().add(gss);
                        }
                    } else {
                        if (gssCred != null) {
                            temp_subject.getPrivateCredentials().add(gssCred);
                        }
                        if (kTicket != null) {
                            temp_subject.getPrivateCredentials().add(kTicket);
                        }
                    }
                }
                if (principalSet.size() > 0) {
                    for (Principal principalObject : principalSet) {
                        temp_subject.getPrincipals().add(principalObject);
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.createSubjectFromKRBAuthnToken", "1358");
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Error copying existing Subject with GSSCredential.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectFromKRBAuthnToken");
        }
        return temp_subject;
    }

    private static void initializePropagateFirstCaller() {
        SecurityConfigObject security2;
        propagateFirstCallerOnlyProperty = System.getProperty("com.ibm.CSI.propagateFirstCallerOnly");
        if (propagateFirstCallerOnlyProperty == null && (security2 = SecurityObjectLocator.getSecurityConfigManager().getObject("security")) != null) {
            propagateFirstCallerOnlyProperty = security2.getProperties().getProperty("com.ibm.CSI.propagateFirstCallerOnly");
        }
        if (propagateFirstCallerOnlyProperty == null) {
            propagateFirstCallerOnlyProperty = "false";
        }
        propagateFirstCallerOnly = propagateFirstCallerOnlyProperty.equalsIgnoreCase("true") || propagateFirstCallerOnlyProperty.equalsIgnoreCase("yes");
    }

    private static void initializeDisableCallerList() {
        SecurityConfigObject security2;
        disableCallerListProperty = System.getProperty("com.ibm.CSI.disablePropagationCallerList");
        if (disableCallerListProperty == null && (security2 = SecurityObjectLocator.getSecurityConfigManager().getObject("security")) != null) {
            disableCallerListProperty = security2.getProperties().getProperty("com.ibm.CSI.disablePropagationCallerList");
        }
        if (disableCallerListProperty == null) {
            disableCallerListProperty = "false";
        }
        disableCallerList = disableCallerListProperty.equalsIgnoreCase("true") || disableCallerListProperty.equalsIgnoreCase("yes");
    }

    public static PropagationToken updatePropagationTokenWithSubjectChange(final Subject subject) {
        PropagationToken propToken;
        block12: {
            ContextManager cmi;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updatePropagationTokenWithSubjectChange");
            }
            if ((cmi = ContextManagerFactory.getInstance()).getThreadLocal().get_update_to_caller_list_disabled_during_login()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange: Disabled during login.");
                }
                return null;
            }
            if (cmi.getThreadLocal().get_update_to_caller_list_disabled_during_login()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange: Disabled during login.");
                }
                return null;
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange: Subject is null.");
                }
                return null;
            }
            if (disableCallerListProperty == null) {
                SubjectHelper.initializeDisableCallerList();
            }
            if (disableCallerList) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange: Caller list is disabled.");
                }
                return null;
            }
            propToken = null;
            try {
                propToken = (PropagationToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSSecurityException {
                        if (currentHost == null) {
                            currentHost = SecurityObjectLocator.getAdminData().getString("process.serverName");
                        }
                        try {
                            WSCredential cred;
                            PropagationToken propagationToken = cmi.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                            if (propagationToken != null) {
                                if (propagateFirstCallerOnlyProperty == null) {
                                    SubjectHelper.initializePropagateFirstCaller();
                                }
                                if (propagateFirstCallerOnly) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "updatePropagationTokenWithSubjectChange: propagation token already exists and propagateFirstCallerOnly is true.");
                                    }
                                    return propagationToken;
                                }
                            }
                            if ((cred = SubjectHelper.getWSCredentialFromSubject(subject)) == null || cred != null && cred.isUnauthenticated()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not setting propagation token for UNAUTHENTICATED subject.");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                                }
                                return null;
                            }
                            if (maxSizeValue == null) {
                                String maxSize = cmi.getProperty("com.ibm.websphere.security.auth.PropTokenMaxEntrySize");
                                if (maxSize != null && !maxSize.equals("")) {
                                    maxSizeValue = new Integer(maxSize);
                                } else {
                                    maxSizeValue = new Integer("20");
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Maximum PropagationToken Entries:" + maxSizeValue);
                                }
                            }
                            if (propagationToken == null) {
                                block64: {
                                    try {
                                        propagationToken = cmi.createPropagationToken(subject);
                                        cmi.setPropagationToken(propagationToken.getName() + ":" + propagationToken.getVersion(), propagationToken);
                                    }
                                    catch (Exception e) {
                                        Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "735");
                                        if (!tc.isDebugEnabled()) break block64;
                                        Tr.debug(tc, "Error setting propagation token.", new Object[]{e});
                                    }
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange, new");
                                }
                                return propagationToken;
                            }
                            if (cred != null) {
                                String[] hosts;
                                boolean modified;
                                block69: {
                                    block68: {
                                        String[] callers;
                                        block66: {
                                            block65: {
                                                callers = null;
                                                try {
                                                    callers = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                                }
                                                catch (Exception e) {
                                                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "762");
                                                    if (!tc.isDebugEnabled()) break block65;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                                }
                                            }
                                            String lastCaller = null;
                                            String currentCaller = currentHost + ":" + cred.getRealmSecurityName();
                                            modified = false;
                                            if (callers != null && callers.length > 0) {
                                                lastCaller = callers[callers.length - 1];
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Last caller: " + lastCaller);
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Current caller: " + currentCaller);
                                                }
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Number of Callers entry: " + callers.length);
                                                }
                                                if (!(cred.isUnauthenticated() || lastCaller == null || lastCaller.equals(currentCaller) || maxSizeValue != 0 && callers.length >= maxSizeValue)) {
                                                    try {
                                                        propagationToken.addAttribute("com.ibm.wsspi.security.propagation.callers", currentCaller);
                                                        modified = true;
                                                    }
                                                    catch (Exception e) {
                                                        Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "793");
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                                        }
                                                    }
                                                }
                                            } else {
                                                try {
                                                    propagationToken.addAttribute("com.ibm.wsspi.security.propagation.callers", currentCaller);
                                                    modified = true;
                                                }
                                                catch (Exception e) {
                                                    Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "817");
                                                    if (!tc.isDebugEnabled()) break block66;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                                }
                                            }
                                        }
                                        if (tc.isDebugEnabled()) {
                                            block67: {
                                                try {
                                                    callers = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                                                }
                                                catch (Exception e) {
                                                    Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "840");
                                                    if (!tc.isDebugEnabled()) break block67;
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                                }
                                            }
                                            StringBuffer sb = new StringBuffer();
                                            sb.append("New contents of caller list: ");
                                            for (int i = 0; i < callers.length; ++i) {
                                                if (i != 0) {
                                                    sb.append("|");
                                                }
                                                sb.append(callers[i]);
                                            }
                                            Tr.debug(tc, sb.toString());
                                        }
                                        hosts = null;
                                        try {
                                            hosts = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                                        }
                                        catch (Exception e) {
                                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "873");
                                            if (!tc.isDebugEnabled()) break block68;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                        }
                                    }
                                    String lastHost = null;
                                    if (hosts != null && hosts.length > 0) {
                                        lastHost = hosts[hosts.length - 1];
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Last host: " + lastHost);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Current host: " + currentHost);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Number of Hosts entry: " + hosts.length);
                                        }
                                        if (!(lastHost == null || lastHost.equals(currentHost) || maxSizeValue != 0 && hosts.length >= maxSizeValue)) {
                                            try {
                                                propagationToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", currentHost);
                                                modified = true;
                                            }
                                            catch (Exception e) {
                                                Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "903");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                                }
                                            }
                                        }
                                    } else {
                                        try {
                                            propagationToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", currentHost);
                                            modified = true;
                                        }
                                        catch (Exception e) {
                                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "927");
                                            if (!tc.isDebugEnabled()) break block69;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                        }
                                    }
                                }
                                if (tc.isDebugEnabled()) {
                                    block70: {
                                        try {
                                            hosts = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                                        }
                                        catch (Exception e) {
                                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "949");
                                            if (!tc.isDebugEnabled()) break block70;
                                            Tr.debug(tc, "Error setting propagation token attribute.", new Object[]{e});
                                        }
                                    }
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("New contents of hosts list: ");
                                    for (int i = 0; i < hosts.length; ++i) {
                                        if (i != 0) {
                                            sb.append("|");
                                        }
                                        sb.append(hosts[i]);
                                    }
                                    Tr.debug(tc, sb.toString());
                                }
                                if (modified) {
                                    block71: {
                                        try {
                                            cmi.setPropagationToken(propagationToken.getName() + ":" + propagationToken.getVersion(), propagationToken);
                                        }
                                        catch (Exception e) {
                                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "983");
                                            if (!tc.isDebugEnabled()) break block71;
                                            Tr.debug(tc, "Exception setting propagation token.", new Object[]{e});
                                        }
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "updatePropagationTokenWithSubjectChange, modified propagation token.");
                                    }
                                } else if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "updatePropagationTokenWithSubjectChange, propagation token unchanged.");
                                }
                                return propagationToken;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                            }
                            return null;
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception occurred updating propagation token.", new Object[]{e});
                            }
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "1005");
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "updatePropagationTokenWithSubjectChange");
                            }
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log(e.getException(), thisClass, "com.ibm.ws.security.auth.SubjectHelper.updatePropagationTokenWithSubjectChange", "1339");
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception updating propagation token.", new Object[]{e.getException()});
            }
        }
        return propToken;
    }

    public static boolean containsKerberosCredential(Subject subject) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "containsKerberosCredential");
            }
            if (subject != null) {
                try {
                    GSSCredential gssCred = SubjectHelper.getGSSCredentialFromSubject(subject);
                    if (gssCred == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "containsKerberosCredential: no GSSCredential in subject private creds");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "containsKerberosCredential (false)");
                        }
                        return false;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "containsKerberosCredential: found GSSCredential in subject private creds");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "containsKerberosCredential (true)");
                    }
                    return true;
                }
                catch (Exception exc) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception looking for Kerberos credential.", exc.getMessage() != null ? exc.getMessage() : exc.getClass().getName());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsKerberosCredential (false, no Subject or exception)");
        }
        return false;
    }

    public static Oid getKrb5MechOid() {
        if (krb5MechOid != null) {
            return krb5MechOid;
        }
        try {
            krb5MechOid = new Oid(KRB5_OID);
        }
        catch (GSSException ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getKrb5MechOid", "1805");
            Object[] parms = new Object[]{Oid.class, "Oid(\"1.2.840.113554.1.2.2\")", ex};
            Tr.debug(tc, "krb5MechOid is null", parms);
            krb5MechOid = null;
        }
        return krb5MechOid;
    }

    public static KRBAuthnToken getKerberosAuthnTokenFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosAuthnTokenFromSubject", subject);
        }
        if (subject != null) {
            Iterator<KRBAuthnToken> privCredIterator;
            KRBAuthnToken krbToken = null;
            Set<KRBAuthnToken> privateCredentials = subject.getPrivateCredentials(KRBAuthnToken.class);
            if (privateCredentials != null && privateCredentials.size() > 0 && (privCredIterator = privateCredentials.iterator()).hasNext() && krbToken == null) {
                krbToken = privCredIterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default KRBAuthnToken.");
                }
                return krbToken;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not find default KRBAuthnToken.");
        }
        return null;
    }

    public static KerberosPrincipal getKerberosPrincipalFromSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosPrincipalFromSubject");
        }
        if (subject == null) {
            return null;
        }
        KerberosPrincipal kPrinc = null;
        try {
            kPrinc = (KerberosPrincipal)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Set<KerberosPrincipal> privCredentials;
                        KerberosPrincipal kPrincInSubj2 = null;
                        Set<KRBAuthnToken> privateCredentials = subject.getPrivateCredentials(KRBAuthnToken.class);
                        if (privateCredentials != null) {
                            AuthnToken krbAuthnToken = null;
                            Iterator<KRBAuthnToken> privCredIterator = privateCredentials.iterator();
                            while (privCredIterator.hasNext() && krbAuthnToken == null) {
                                krbAuthnToken = privCredIterator.next();
                            }
                            if (krbAuthnToken != null) {
                                String princ = krbAuthnToken.getTokenPrincipal();
                                String realm = krbAuthnToken.getTokenRealm();
                                kPrincInSubj2 = new KerberosPrincipal(princ + "@" + realm);
                            }
                        }
                        if (kPrincInSubj2 == null && (privCredentials = subject.getPrivateCredentials(KerberosPrincipal.class)) != null) {
                            for (KerberosPrincipal kPrincInSubj2 : privCredentials) {
                            }
                        }
                        return kPrincInSubj2;
                    }
                    catch (Throwable t) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting KerberosPrincipal from krbAuthnToken or subject.", new Object[]{t});
                        }
                        return null;
                    }
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get default Kerberos principal name: " + kPrinc);
            }
            return kPrinc;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.getKerberosPrincipalFromSubject", "1909");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting KerberosPrincipal from Subject.", new Object[]{e});
            }
            return null;
        }
    }

    public static boolean putKerberosAuthnTokenToSubject(final KRBAuthnToken krbAuthnToken, final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putKerberosAuthnTokenToSubject", subject);
        }
        if (subject == null || krbAuthnToken == null) {
            return false;
        }
        try {
            Boolean added = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        KRBAuthnToken krbAuthnTokenInSubject = null;
                        Set<KRBAuthnToken> privateCredentials = subject.getPrivateCredentials(KRBAuthnToken.class);
                        Iterator<KRBAuthnToken> privCredIterator = privateCredentials.iterator();
                        while (privCredIterator.hasNext() && krbAuthnTokenInSubject == null) {
                            krbAuthnTokenInSubject = privCredIterator.next();
                        }
                        if (krbAuthnTokenInSubject != null) {
                            subject.getPrivateCredentials().remove(krbAuthnTokenInSubject);
                        }
                        subject.getPrivateCredentials().add(krbAuthnToken);
                    }
                    catch (Exception ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ws.security.auth.SubjectHelper.putKerberosAuthnTokenToSubject", "1947");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception putting Kerberos authentication token to a Subject.", new Object[]{ex});
                        }
                        return false;
                    }
                    return true;
                }
            });
            return added;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ws.security.auth.SubjectHelper.putKerberosAuthnTokenToSubject", "1959");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding Kerberos authentication token to Subject.", new Object[]{e});
            }
            return false;
        }
    }

    public static void setClientDefaultSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientDefaultSubject", subject);
        }
        if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            VaultImpl.getInstance().set_default_subject(subject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setClientDefaultSubject invoked on a server");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientDefaultSubject");
        }
    }
}

