/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.GenericCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.Subject;

public final class PlatformCredential
implements Serializable {
    public static final CredentialType BASIC = new CredentialType("Basic");
    public static final CredentialType DEFAULT = new CredentialType("Default");
    public static final CredentialType CERTIFICATE = new CredentialType("Certificate");
    public static final CredentialType ASSERTED = new CredentialType("Asserted");
    public static final CredentialType ROLE = new CredentialType("Role");
    public static final CredentialType SERVER = new CredentialType("Server");
    public static final int STATE_FREED = 1;
    private static final int VERSION_UNSET = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private static final long serialVersionUID = -4979494157999039784L;
    private static final TraceComponent tc = Tr.register(PlatformCredential.class, "Security", "com.ibm.ejs.resources.security");
    private static final boolean isServant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
    private transient String unauthenticatedUserId;
    private transient Subject j2cSubject;
    private transient boolean authenticated = false;
    private int version = 3;
    private String userId = null;
    private String mvsUserId = null;
    private String auditString = null;
    private long serializationTime;
    private CredentialType credType = DEFAULT;
    private boolean isDefault = false;
    private X509Certificate[] certChain = null;
    private String roleProfile = null;

    public PlatformCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.userId = this.getUnauthenticatedUserId();
        this.auditString = "WebSphere Default/Unauthenticated Login";
        this.credType = DEFAULT;
        this.isDefault = true;
        this.j2cSubject = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential(CredentialType type, String name, String auditString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{type, name, auditString});
        }
        this.credType = type;
        this.auditString = auditString;
        if (type == ROLE) {
            this.roleProfile = name;
        } else {
            String string = this.userId = name != null ? name.toUpperCase().trim() : name;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential(X509Certificate[] certChain, String auditString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{certChain, auditString});
        }
        this.credType = CERTIFICATE;
        this.certChain = certChain;
        this.auditString = auditString;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public String getUserId() {
        String userId;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserId");
        }
        if ((userId = this.userId) == null) {
            userId = this.getMvsUserId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserId", userId);
        }
        return userId;
    }

    public String getMvsUserId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMvsUserId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMvsUserId", this.mvsUserId);
        }
        return this.mvsUserId;
    }

    public void setMvsUserId(String mvsUserId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMvsUserId", mvsUserId);
        }
        String string = this.mvsUserId = mvsUserId != null ? mvsUserId.toUpperCase().trim() : mvsUserId;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMvsUserId");
        }
    }

    public String getUnauthenticatedUserId() {
        if (this.unauthenticatedUserId == null) {
            ContextManager contextMgr = ContextManagerFactory.getInstance();
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            this.unauthenticatedUserId = security2.getProperty("com.ibm.security.SAF.unauthenticated");
            this.unauthenticatedUserId = this.unauthenticatedUserId.toUpperCase().trim();
        }
        return this.unauthenticatedUserId;
    }

    public CredentialType getCredentialType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialType", this.credType);
        }
        return this.credType;
    }

    public String getAuditString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuditString", this.auditString);
        }
        return this.auditString;
    }

    public X509Certificate[] getCertificateChain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateChain", this.certChain);
        }
        return this.certChain;
    }

    public String getRoleProfile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleProfileName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleProfileName", this.roleProfile);
        }
        return this.roleProfile;
    }

    public boolean isAuthenticated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthenticated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthenticated", new Boolean(this.authenticated));
        }
        return this.authenticated;
    }

    private void setAuthenticated(boolean authenticated) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthenticated", new Boolean(authenticated));
        }
        this.authenticated = authenticated;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthenticated");
        }
    }

    public boolean isDefault() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefault");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDefault", new Boolean(this.isDefault));
        }
        return this.isDefault;
    }

    public Subject getPlatformCredSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredSubject");
        }
        Subject subject = this.createSubjectFromPlatformCred();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredSubject", subject);
        }
        return subject;
    }

    public Subject getJ2CSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2CSubject");
        }
        Subject subject = null;
        subject = this.j2cSubject != null ? this.j2cSubject : this.createJ2CSubject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2CSubject", subject);
        }
        return subject;
    }

    private Subject createJ2CSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CSubject");
        }
        Subject subject = null;
        byte[] utoken = PlatformCredentialManager.instance().createUtoken(this);
        if (utoken == null) {
            throw new IllegalStateException("Could not create credential utoken");
        }
        String userId = this.getUserId();
        GenericCredentialImpl genericCred = new GenericCredentialImpl(userId, utoken, "oid:1.3.18.0.2.30.1");
        subject = new Subject();
        subject.getPrivateCredentials().add(genericCred);
        subject.getPrivateCredentials().add(this);
        WSPrincipalImpl principal = new WSPrincipalImpl(this.getMvsUserId());
        subject.getPrincipals().add(principal);
        subject.setReadOnly();
        this.j2cSubject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CSubject", subject);
        }
        return subject;
    }

    private Subject createSubjectFromPlatformCred() {
        Subject subject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubjectFromPlatformCred");
            }
            subject = null;
            ContextManager contextMgr = ContextManagerFactory.getInstance();
            String realm = contextMgr.getProperty("security.activeUserRegistry.realm");
            String userId = this.getUserId();
            try {
                subject = contextMgr.login(realm, userId);
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.PlatformCredential.createSubjectFromPlatformCred", "517", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Login failed", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectFromPlatformCred", subject);
        }
        return subject;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", s);
        }
        long serializationTime = System.currentTimeMillis();
        CredentialType credType = this.credType;
        if (credType == BASIC && this.authenticated) {
            credType = ASSERTED;
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("version", this.version);
        fields.put("userId", this.userId);
        fields.put("auditString", this.auditString);
        fields.put("serializationTime", serializationTime);
        fields.put("isDefault", this.isDefault);
        fields.put("mvsUserId", this.mvsUserId);
        fields.put("credType", credType);
        fields.put("certChain", this.certChain);
        fields.put("roleProfile", this.roleProfile);
        s.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "readObject", s);
        }
        ObjectInputStream.GetField fields = null;
        try {
            fields = s.readFields();
            this.version = fields.get("version", 1);
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine version", ioe);
            }
            this.version = 0;
            this.userId = this.getUnauthenticatedUserId();
            this.isDefault = true;
        }
        switch (this.version) {
            default: {
                this.mvsUserId = (String)fields.get("mvsUserId", null);
                this.credType = (CredentialType)fields.get("credType", DEFAULT);
                this.certChain = (X509Certificate[])fields.get("certChain", null);
                this.roleProfile = (String)fields.get("roleProfile", null);
                this.credType = this.getNormalizedCredentialType(this.credType);
            }
            case 2: {
                this.userId = (String)fields.get("userId", this.getUnauthenticatedUserId());
                this.auditString = (String)fields.get("auditString", null);
                this.isDefault = fields.get("isDefault", true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Last serialized date", new Date(fields.get("serializationTime", 0L)));
            }
            case 0: 
            case 1: 
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String getCacheKeyString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheKeyString");
        }
        StringBuffer cacheKey = new StringBuffer();
        cacheKey.append(this.credType).append(": ");
        cacheKey.append("auditString=").append(this.auditString);
        if (this.credType == ROLE) {
            cacheKey.append(",roleProfile=").append(this.roleProfile);
            cacheKey.append(",mvsUserId=").append(this.mvsUserId);
        } else {
            cacheKey.append(",userId=").append(this.userId);
            cacheKey.append(",isDefault=").append(this.isDefault);
        }
        if (this.certChain != null && this.certChain[0] != null) {
            BigInteger serialNumber = this.certChain[0].getSerialNumber();
            cacheKey.append(",certSerialNumber=").append(serialNumber);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKeyString", cacheKey);
        }
        return cacheKey.toString();
    }

    public String toString() {
        return super.toString() + ",userId=" + this.userId + ",mvsUserId=" + this.mvsUserId + ",isDefault=" + this.isDefault + ",authenticated=" + this.authenticated + ",credType=" + this.credType + ",auditString=" + this.auditString;
    }

    public int hashCode() {
        String hash = this.credType + this.userId + this.isDefault + this.auditString;
        return hash.hashCode();
    }

    public boolean equals(Object o) {
        PlatformCredential that = null;
        if (this == o) {
            return true;
        }
        if (o instanceof PlatformCredential) {
            that = (PlatformCredential)o;
        }
        if (that != null) {
            boolean userIdsEqual = this.credType == ROLE || this.userId == null && that.userId == null || this.userId != null && this.userId.equals(that.userId);
            boolean mvsUserIdsEqual = this.credType == ROLE || this.mvsUserId == null && that.mvsUserId == null || this.mvsUserId != null && this.mvsUserId.equals(that.mvsUserId);
            boolean auditStringsEqual = this.auditString == null && that.auditString == null || this.auditString != null && this.auditString.equals(that.auditString);
            boolean roleProfilesEqual = this.roleProfile == null && that.roleProfile == null || this.roleProfile != null && this.roleProfile.equals(that.roleProfile);
            boolean authenticatedsEqual = this.credType != BASIC || this.authenticated == that.authenticated;
            return this.version == that.version && this.isDefault == that.isDefault && this.credType == that.credType && authenticatedsEqual && auditStringsEqual && userIdsEqual && mvsUserIdsEqual && roleProfilesEqual;
        }
        return false;
    }

    private CredentialType getNormalizedCredentialType(CredentialType credType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeCredentialType", credType);
        }
        CredentialType cred = DEFAULT;
        if (BASIC.equals(credType)) {
            cred = BASIC;
        } else if (CERTIFICATE.equals(credType)) {
            cred = CERTIFICATE;
        } else if (ASSERTED.equals(credType)) {
            cred = ASSERTED;
        } else if (ROLE.equals(credType)) {
            cred = ROLE;
        } else if (SERVER.equals(credType)) {
            cred = SERVER;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeCredentialType", cred);
        }
        return cred;
    }

    public static final class CredentialType
    implements Serializable {
        final String name;

        CredentialType(String name) {
            this.name = name;
        }

        public String toString() {
            return "[" + this.name + "]";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CredentialType) {
                CredentialType that = (CredentialType)o;
                return this.name.equals(that.name);
            }
            return false;
        }
    }
}

