/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ISecurityUtilityImpl.StateofCurrObj;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.ThreadContextImpl;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.JaasLoginHelper;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.WSSubjectWrapperImpl;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.context.ContextImpl;
import com.ibm.ws.security.context.ServiceWithContextImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.stat.impl.SecurityAuthenticationModuleImpl;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.ws390.sm.smf.SmfJActivity;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.auth.WSSubjectWrapper;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ContextManagerImpl
implements ContextManager,
ContextManagerInternals,
SecurityServiceListener {
    private static final TraceComponent tc = Tr.register(ContextManagerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String DEFAULT_REALM = "<default>";
    private static final String EMPTY = "";
    private String WIM_UR = "WIMUserRegistry";
    private PlatformCredentialManager _platformCredManager;
    private static final WebSphereRuntimePermission GET_OWN_CRED_PERM = new WebSphereRuntimePermission("SecOwnCredentials");
    private static final WebSphereRuntimePermission GET_SERVER_CRED_PERM = new WebSphereRuntimePermission("ContextManager.getServerCredential");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final ThreadLocal threadLocStorage = new SecurityThreadLocal();
    private static final String DISABLE_AUTH_RETRY = "wssecurity.disableauthretry";
    private static ServerCredSigner scs = null;
    private AuditService _auditService = null;
    private Object _registryObject = null;
    private SecurityCache cache = null;
    private JaasLoginHelper jaasLoginHelper = null;
    private String regionUserid = System.getProperty("user.name");
    private String SECURITY_REALM = "";
    private SecurityServer securityServer = null;
    private AuthenticationToken serverAuthToken = null;
    private AuthorizationToken serverAuthzToken = null;
    private WSCredential serverBACred = null;
    private Subject serverBASubject = null;
    private boolean cellSecurityEnabled = true;
    private boolean serverSecurityEnabled = true;
    private SingleSignonToken serverSSOToken = null;
    private Subject serverSubject = null;
    private WSCredential serverTokenCred = null;
    private GSSCredential serverSpnGSSCred = null;
    private KRBAuthnToken serverKRBAuthnToken = null;
    private String serverUniqueIdentity = null;
    private boolean serverSubjectCreated = false;
    private HashMap<String, String> getPropertyCache = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private static final String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    private boolean isEnabled = false;
    private boolean isServerSecurityEnabledAlreadyChecked = false;
    private boolean isCellSecurityEnabledAlreadyChecked = false;
    private boolean isAuthenticateSpecialMethodsEnabled = false;
    private boolean isSecurityServiceStarted = false;
    private SecurityAuthenticationModuleImpl authModule;
    private boolean isKerberosServerSubject = false;
    private String adminRealm = null;
    private String appRealm = null;
    private String _domainId = null;
    private boolean initialized = false;
    private boolean renewKRBAuthnToken = false;
    private SecurityConfig domainSecurityConfig = null;
    private SecurityConfig adminSecurityConfig = null;
    private static String unauthenticatedId = null;
    boolean refreshServerSubject = false;
    private static ServiceWithContext svc;

    public static synchronized void registerPackage(String pkgNamePrefix) {
        ArrayList<String> transportPackages = new ArrayList<String>();
        String currentPackageList = System.getProperty(URL_HANDLER_PROP);
        if (currentPackageList != null) {
            StringTokenizer tok = new StringTokenizer(currentPackageList, PKGNAME_DELIMITER);
            while (tok.hasMoreTokens()) {
                transportPackages.add(tok.nextToken());
            }
        }
        if (transportPackages.contains(pkgNamePrefix)) {
            return;
        }
        transportPackages.add(pkgNamePrefix);
        StringBuffer currentPackages = new StringBuffer();
        Iterator i = transportPackages.iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            currentPackages.append(thisPackage);
            if (!i.hasNext()) continue;
            currentPackages.append('|');
        }
        System.setProperty(URL_HANDLER_PROP, currentPackages.toString());
    }

    public ContextManagerImpl() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (RasHelper.isServer()) {
            this.cellSecurityEnabled = SecurityObjectLocator.getSecurityConfigManager().getObject("security").getBoolean("enabled");
            this.isCellSecurityEnabledAlreadyChecked = true;
        }
        this.getPropertyCache = new HashMap();
        if (StatsFactory.isPMIEnabled()) {
            this.authModule = SecurityAuthenticationModuleImpl.getInstance("Security Authentication");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void addWSSubjectToCache(Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSSubjectToCache", subject);
        }
        if (subject != null && this.processIsServer() && this.isWSSubject(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding WSSubject to cache.");
            }
            this.cache.insert(subject);
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            this.processSubjectForPropagationAfterLogin(subject, csiv2.getString("com.ibm.CSI.authMechAuthAlias"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSSubjectToCache");
        }
    }

    public void addPropagationTokensToCacheObject(Object cacheKey, Map tokenMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPropagationTokensToCacheObject", cacheKey);
        }
        if (cacheKey != null && this.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding WSSubject to cache.");
            }
            this.cache.updateEntry(cacheKey, tokenMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPropagationTokensToCacheObject");
        }
    }

    public WSCredential authenticate(String realm, byte[] token) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", new Object[]{realm, token});
        }
        WSCredential wsCred = null;
        try {
            Subject subject = this.login(realm, token);
            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (LoginException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "540", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "547", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate", wsCred);
        }
        return wsCred;
    }

    public WSCredential authenticate(String realm, String user, String password) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", new Object[]{realm, user, password == null ? null : "****"});
        }
        WSCredential wsCred = null;
        try {
            Subject subject = this.login(realm, user, password);
            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "573", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "580", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", wsCred);
        }
        return wsCred;
    }

    public WSCredential authenticate(WSCredential credential) throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", credential);
        }
        WSCredential wsCred = null;
        try {
            Subject subject = this.login(credential);
            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "602", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.authenticate", "609", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authenticate failed: " + this.dump(e));
            }
            AuthenticationFailedException ae = new AuthenticationFailedException(e.getMessage());
            ae.addException(e);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate", wsCred);
        }
        return wsCred;
    }

    public boolean callerSubjectIsServerIdentity() {
        boolean isServerId;
        block20: {
            WSCredential callerCred;
            block19: {
                block18: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "callerSubjectIsServerIdentity");
                    }
                    isServerId = false;
                    if (this.serverUniqueIdentity == null) {
                        try {
                            Subject serverSubject = this.getServerSubject();
                            WSCredential serverCred = SubjectHelper.getWSCredentialFromSubject(serverSubject);
                            this.serverUniqueIdentity = serverCred.getAccessId();
                        }
                        catch (WSSecurityException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "634", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getServerSubject() failed", e);
                            }
                        }
                        catch (CredentialExpiredException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "638", this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "getRealmUniqueSecurityName() on server credential failed", e);
                        }
                    }
                }
                callerCred = null;
                try {
                    Subject callerSubject = this.getCallerSubject();
                    callerCred = SubjectHelper.getWSCredentialFromSubject(callerSubject);
                }
                catch (WSSecurityException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "649", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "getCallerSubject() failed", e);
                }
            }
            if (callerCred != null && callerCred.isCurrent() && !callerCred.isUnauthenticated()) {
                try {
                    String callerUniqueIdentity = callerCred.getAccessId();
                    SecurityConfig security2 = this.getSecurityConfig();
                    if (callerUniqueIdentity != null) {
                        if (callerUniqueIdentity.equals(this.serverUniqueIdentity)) {
                            isServerId = true;
                        } else if (callerUniqueIdentity.equalsIgnoreCase(this.serverUniqueIdentity) && security2.getActiveUserRegistry().getBoolean("ignoreCase")) {
                            isServerId = true;
                        } else if (this.isInternalServerId(callerUniqueIdentity)) {
                            isServerId = true;
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.callerSubjectIsServerIdentity", "670", this);
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "getRealmUniqueSecurityName() failed", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callerSubjectIsServerIdentity", new Boolean(isServerId));
        }
        return isServerId;
    }

    private void checkAuthRetryForThread() {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        Boolean value = (Boolean)this.get(DISABLE_AUTH_RETRY);
        if (value != null && value.booleanValue()) {
            this.getThreadLocal().set_authretry_for_jaas(false);
        }
    }

    public void clearCallerContext() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCallerContext");
        }
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        the_state.setCallerSubject(null);
        the_state.setOwnSubject(null);
        the_state.setInvocationSubject(null);
        the_state.setFirstAuthUser(null);
        the_state.setAuthFlag(false);
        this.removeStateFromTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCallerContext");
        }
    }

    public void clearRootException() {
        this.setRootException(null);
    }

    public boolean contains(String key) {
        if (!this.isCellSecurityEnabled()) {
            return false;
        }
        return this.getThreadLocal().contains_property(key);
    }

    public WSCredential createBasicAuthCredential(String realm, String user, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicAuthCredential", new Object[]{realm, user, password == null ? null : "****"});
        }
        WSCredentialImpl cred = null;
        cred = realm == null || realm.length() == 0 ? new WSCredentialImpl(this.getDefaultRealm(), user, password) : new WSCredentialImpl(realm, user, password);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicAuthCredential", cred);
        }
        return cred;
    }

    public WSPrincipal createPrincipal(WSCredential cred) throws WSSecurityException {
        return SubjectHelper.createPrincipal(cred);
    }

    public PropagationToken createPropagationToken(Subject subject) throws WSSecurityException {
        PropagationToken pt;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createPropagationToken", subject);
            }
            pt = null;
            try {
                WSCredentialTokenMapperInterface wsCredTokenMapper = this.getWSCredTokenMapper();
                if (wsCredTokenMapper != null && subject != null) {
                    WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
                    pt = wsCredTokenMapper.createPropagationTokenFromWSCredential(cred);
                    break block9;
                }
                if (wsCredTokenMapper != null && subject == null) {
                    pt = wsCredTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet();
                    break block9;
                }
                throw new WSSecurityException("Could not instantiate WSCredTokenMapper.");
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSecurityException creating propagation token.");
                }
                throw e;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating propagation token.");
                }
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPropagationToken", pt);
        }
        return pt;
    }

    public Subject createUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createUnauthenticatedSubject();
    }

    private void debugCallingMethod() {
        if (!tc.isDebugEnabled()) {
            return;
        }
        StackTraceElement[] ste = new Exception().getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement stackTraceElement = ste[i];
            if (stackTraceElement.getClassName().equals(this.getClass().getName()) || stackTraceElement.getClassName().equals("com.ibm.ws.security.core.SecurityContext") || !stackTraceElement.getClassName().startsWith("com.ibm.")) continue;
            Tr.debug(tc, "Calling routine: " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
            break;
        }
    }

    private String dump(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public Object get(String key) {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        return this.getThreadLocal().get_property(key);
    }

    public AuditService getAuditService() {
        return this._auditService;
    }

    public WSCredential[] getCallerCredentials() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerCredentials");
        }
        WSCredential[] recCredsList = null;
        try {
            StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            recCredsList = the_state.getWSReceivedCreds();
            if (recCredsList != null && recCredsList[0] != null && !recCredsList[0].isCurrent()) {
                throw new WSSecurityException("Received credential has expired.");
            }
            if (recCredsList == null || recCredsList.length == 0) {
                recCredsList = null;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getCallerCredentials", "855", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerCredentials");
        }
        return recCredsList;
    }

    public Subject getCallerSubject() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerSubject");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCallerSubject cell security not enabled, returning");
            }
            return null;
        }
        if (!this.initialized && RasHelper.isServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCallerSubject ContextManager not initialized returning");
            }
            return null;
        }
        Subject subject = null;
        try {
            final StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            subject = (Subject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return the_state.getCallerSubject();
                }
            });
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getCallerSubject", "890", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        final Subject subjectPriv = subject;
        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerSubject", subjectPriv);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerSubject", subject);
        }
        return subject;
    }

    public byte[] getClientUniqueIDArrayForOutboundRequests(Subject subject) {
        String uniqueId;
        byte[] token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientUniqueIDArrayForOutboundRequests", subject);
        }
        byte[] byArray = token = (uniqueId = this.getClientUniqueIDForOutboundRequests(subject)) != null ? uniqueId.getBytes() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueIDArrayForOutboundRequests", token);
        }
        return token;
    }

    public String getClientUniqueIDForOutboundRequests(Subject subject) {
        String uniqueId;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getClientUniqueIDForOutboundRequests", subject);
            }
            uniqueId = null;
            try {
                WSCredentialTokenMapperInterface wsCredTokenMapper = this.getWSCredTokenMapper();
                if (wsCredTokenMapper != null && subject != null) {
                    uniqueId = wsCredTokenMapper.createUniqueIDFromAllTokens(subject);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getClientUniqueIDForOutboundRequests", "932");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Caught exception.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueIDForOutboundRequests", uniqueId);
        }
        return uniqueId;
    }

    public String getDefaultRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        String realm = null;
        if (this.isCellSecurityEnabled()) {
            realm = RasHelper.isServer() ? this.getSecurityConfig().getActiveUserRegistry().getString("realm") : DEFAULT_REALM;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, default realm name will be returned");
            }
            realm = this.SECURITY_REALM = DEFAULT_REALM;
        }
        if (realm == null || realm.length() == 0) {
            realm = this.SECURITY_REALM;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realm still null or empty setting to SECURITY_REALM");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm", realm);
        }
        return realm;
    }

    public String getDefaultRealm(String in_oid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm", in_oid);
        }
        String realm = null;
        if (this.isCellSecurityEnabled()) {
            if (RasHelper.isServer()) {
                SecurityConfig secCfg = this.getSecurityConfig();
                if (OID.compareOIDs(in_oid, "oid:1.2.840.113554.1.2.2") && "KRB5".equals(secCfg.getActiveAuthMechanism().getType())) {
                    try {
                        realm = Krb5Utils.getKrb5Realm();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getDefaultRealm", "995", this);
                        if (tc.isEntryEnabled()) {
                            Tr.error(tc, "security.auth.kerberos.Exception", new Object[]{"getDefaultRealm()", e});
                        }
                    }
                } else {
                    realm = this.getSecurityConfig().getActiveUserRegistry().getString("realm");
                }
            } else {
                if (OID.compareOIDs(in_oid, "oid:1.2.840.113554.1.2.2")) {
                    Tr.warning(tc, "security.auth.kerberos.cannot.getSPNonClient");
                    return null;
                }
                realm = DEFAULT_REALM;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, default realm name will be returned");
            }
            realm = this.SECURITY_REALM = DEFAULT_REALM;
        }
        if (realm == null || realm.length() == 0) {
            realm = this.SECURITY_REALM;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realm still null or empty setting to SECURITY_REALM");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm", realm);
        }
        return realm;
    }

    public String getDefaultKrbSpn() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultKrbSpn");
        }
        String spn = null;
        if (this.isCellSecurityEnabled()) {
            if (RasHelper.isServer()) {
                SecurityConfig secCfg = this.getSecurityConfig();
                if ("KRB5".equals(secCfg.getActiveAuthMechanism().getType())) {
                    spn = secCfg.getAuthMechanism("KRB5").getString("krb5Spn");
                }
            } else {
                Tr.warning(tc, "security.auth.kerberos.cannot.getSPNonClient");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKrbSpn", spn);
        }
        return spn;
    }

    public String getAdminRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminRealm");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.adminRealm == null) {
                this.adminRealm = this.getAdminSecurityConfig().getActiveUserRegistry().getString("realm");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, default realm name will be returned");
            }
            this.adminRealm = DEFAULT_REALM;
        }
        if (this.adminRealm == null || this.adminRealm.equals(EMPTY)) {
            this.adminRealm = this.getDefaultRealm();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "admin realm still null or empty setting to default realm");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminRealm", this.adminRealm);
        }
        return this.adminRealm;
    }

    public String getAppRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppRealm ERROR SHOULD NOT BE CALLED");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.appRealm == null) {
                this.appRealm = DomainInfo.getDefaultRealm();
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled, default realm name will be returned");
            }
            this.appRealm = DEFAULT_REALM;
        }
        if (this.appRealm == null || this.appRealm.equals(EMPTY)) {
            this.appRealm = this.getDefaultRealm();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "app realm still null or empty setting to default realm");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppRealm", this.appRealm);
        }
        return this.appRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renew(Subject subject, int thresholdInPercentage, boolean forceRenew) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew", new Object[]{new Integer(thresholdInPercentage), new Boolean(forceRenew)});
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Subject is null.");
            }
            throw new WSSecurityException("Subject is null.");
        }
        if (thresholdInPercentage >= 100 || thresholdInPercentage < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Not renewed - " + thresholdInPercentage + " % too large or too small");
            }
            throw new WSSecurityException("Not renewed - " + thresholdInPercentage + " % too large or too small");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Security is disabled.");
            }
            return true;
        }
        if (!this.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Not applicable to client side");
            }
            return true;
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CSI.refreshClientSubjectGoingOutbound") && !this.isServerSubject(subject)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Client credential but com.ibm.CSI.getRefreshClientSubjectGoingOutbound is not enabled.");
            }
            return false;
        }
        SecurityConfig security2 = this.getSecurityConfig();
        String activeAuthMechOid = security2.getActiveAuthMechanism().getString("OID");
        try {
            block32: {
                if (!forceRenew) {
                    WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    try {
                        if (wsCred == null || !wsCred.isForwardable()) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "Not forwardable");
                            }
                            return true;
                        }
                    }
                    catch (CredentialExpiredException ex) {
                        // empty catch block
                    }
                    if (wsCred != null) {
                        try {
                            long current_time = System.currentTimeMillis();
                            long expiration_time = wsCred.getExpiration();
                            long timeToLiveMillis = expiration_time - current_time;
                            Long expTime = security2.getActiveAuthMechanism().getLong("timeout");
                            long threshold = expTime * 60L * 1000L / 100L * (long)thresholdInPercentage;
                            if (timeToLiveMillis <= threshold) break block32;
                            KRBAuthnToken krbAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
                            if (krbAuthnToken != null) {
                                int krb5ClockSkew;
                                long krb5ExpirationTime = krbAuthnToken.getTokenExpiration();
                                long krb5TimeToLiveMillis = krb5ExpirationTime - current_time - this.cache.getCushion();
                                if (krb5TimeToLiveMillis > (long)(krb5ClockSkew = this.getSecurityConfig().getAuthMechanism("KRB5").getKrb5ClockSkew())) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "not renewed because KRBAuthnToken remaining time " + krb5TimeToLiveMillis + " in milliseconds > Kerberos clock skew " + krb5ClockSkew);
                                        Tr.exit(tc, "not renewed because WSCredential remaining time " + timeToLiveMillis + " in milliseconds > threshold " + threshold);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "KRBAuthnToken refresh not required");
                                    }
                                    return true;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "KRBAuthnToken needs to refresh");
                                }
                                break block32;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "not renewed because WSCred remaining time " + timeToLiveMillis + " in milliseconds > threshold " + threshold);
                            }
                            return true;
                        }
                        catch (CredentialExpiredException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing Subject.");
            }
            final Subject subjectPriv = subject;
            Subject subject2 = subject;
            synchronized (subject2) {
                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException, WSSecurityException {
                        com.ibm.wsspi.security.token.Token newAuthnToken = null;
                        AuthorizationToken newAuthzToken = null;
                        SingleSignonToken newSSOToken = null;
                        Iterator<Object> privCreds = subjectPriv.getPrivateCredentials().iterator();
                        WSCredential subjectWSCred = SubjectHelper.getWSCredentialFromSubject(subjectPriv);
                        while (privCreds.hasNext()) {
                            Object cred = privCreds.next();
                            if (cred instanceof AuthorizationToken && cred instanceof AbstractTokenImpl) {
                                newAuthzToken = (AuthorizationToken)cred;
                                newAuthzToken = (AuthorizationToken)newAuthzToken.clone();
                                ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)((Object)newAuthzToken)).getToken());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "New AuthorizationToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)cred).getExpiration()));
                                continue;
                            }
                            if (cred instanceof KRBAuthnToken) {
                                block15: {
                                    try {
                                        if (ContextManagerImpl.this.isKrbAuthnTokenRenewable((KRBAuthnToken)cred)) {
                                            if (!(cred instanceof KRBTicket)) break block15;
                                            KerberosTicket kt = ((KRBTicket)cred).getKerberosTicket();
                                            KerberosTicket rkt = ContextManagerImpl.refreshKerberosTicket(kt);
                                            if (rkt != null) {
                                                ((KRBTicket)cred).setKerberosTicket(rkt);
                                                break block15;
                                            }
                                            return false;
                                        }
                                        return false;
                                    }
                                    catch (Exception e) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception refreshing the KRBAuthnToken.", new Object[]{e.getMessage()});
                                        }
                                        return false;
                                    }
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "New KRBAuthnToken expiration: " + new Date(((KRBAuthnToken)cred).getTokenExpiration()));
                                continue;
                            }
                            if (cred instanceof AuthenticationToken && cred instanceof AbstractTokenImpl) {
                                newAuthnToken = (AuthenticationToken)cred;
                                newAuthnToken = (AuthenticationToken)((Object)newAuthnToken).clone();
                                ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)newAuthnToken).getToken());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "New AuthenticationToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)cred).getExpiration()));
                                continue;
                            }
                            if (!(cred instanceof SingleSignonToken) || !(cred instanceof AbstractTokenImpl)) continue;
                            newSSOToken = (SingleSignonToken)cred;
                            newSSOToken = (SingleSignonToken)newSSOToken.clone();
                            ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)((Object)newSSOToken)).getToken());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "New SingleSignonToken expiration: " + new Date(((com.ibm.wsspi.security.token.Token)cred).getExpiration()));
                        }
                        if (newAuthnToken != null && newAuthzToken != null) {
                            try {
                                WSCredential newCred = ContextManagerImpl.this.getWSCredTokenMapper().createWSCredentialFromTokens(newAuthnToken.getBytes(), newAuthzToken);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Updating Subject with new wsCred token.");
                                }
                                ((WSCredentialImpl)subjectWSCred).refreshCred(newCred);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "New WSCredential expiration: " + new Date(subjectWSCred.getExpiration()));
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.renew", "1297", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception refreshing the WSCredential.", new Object[]{e});
                                }
                                throw new WSSecurityException(e.getMessage(), e);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.renew", "1309", this);
            this.setRootException(e.getException());
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renew if below " + thresholdInPercentage + " %");
        }
        return true;
    }

    private Object getDistributedObject(Object key) {
        Object value;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDistributedObject", key);
            }
            value = null;
            try {
                value = this.getWSCredTokenMapper().getDistributedObject(key);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "1346");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error getting distributed object.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObject", value);
        }
        return value;
    }

    private Object getDistributedObjectNotShared(Object key) {
        Object value;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDistributedObjectNotShared", key);
            }
            value = null;
            try {
                value = this.getWSCredTokenMapper().getDistributedObjectNotShared(key);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.distContextManager.getDistributedObjectNotShared", "1381");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error getting none shared distributed object.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObjectNotShared", value);
        }
        return value;
    }

    private byte[] getInitialContextTokenFromMBean(final ByteArray ssoToken, final String serverName, final Properties connectorProps) {
        byte[] returnedToken;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInitialContextTokenFromMBean", new Object[]{ssoToken, serverName, connectorProps});
            }
            returnedToken = null;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ContextManagerImpl.this.getWSCredTokenMapper().getInitialContextTokenFromMBean(ssoToken, serverName, connectorProps);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getInitialContextTokenFromMBean", "1407", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting initial context token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                returnedToken = (byte[])this.runAsSystem(action);
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getInitialContextTokenFromMBean", "1420", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception getting initial context token from originating server.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialContextTokenFromMBean", returnedToken);
        }
        return returnedToken;
    }

    public WSCredential getInvocationCredential() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationCredential");
        }
        WSCredential invokeCred = null;
        try {
            StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            invokeCred = the_state.getWSInvocationCred();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getInvocationCredential", "1443", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationCredential", invokeCred);
        }
        return invokeCred;
    }

    public Subject getInvocationSubject() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject");
        }
        Subject subject = null;
        try {
            StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            subject = the_state.getInvocationSubject();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getInvocationSubject", "1466", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject");
        }
        return subject;
    }

    private JaasLoginHelper getJaasLoginHelper() throws WSSecurityException {
        if (this.jaasLoginHelper == null) {
            try {
                CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                this.jaasLoginHelper = new JaasLoginHelper(csiv2.getString("com.ibm.CSI.authMechAuthAlias"));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getJaasLoginHelper()");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getJaasLoginHelper", "1484");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, EMPTY, e);
                }
                this.jaasLoginHelper = null;
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        return this.jaasLoginHelper;
    }

    private Object getOpaqueTokenFromCacheOrOriginatingServer(byte[] token) throws WSLoginFailedException {
        Object return_object;
        block52: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromCacheOrOriginatingServer");
            }
            Subject subject = null;
            return_object = null;
            try {
                CSIv2Config csiv2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting distributed object from DynaCache.");
                }
                String[] serverName = null;
                String[] tokenUniqueID = null;
                ByteArray sso_token = new ByteArray(token);
                byte[] opaque_token = (byte[])this.getDistributedObject(sso_token);
                Properties connectorProps = new Properties();
                String[] oid = null;
                KRBAuthnToken krbAuthnToken = (KRBAuthnToken)this.getDistributedObjectNotShared(sso_token);
                if (krbAuthnToken != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting return_object = KRBAuthnToken.");
                    }
                    return_object = krbAuthnToken;
                }
                Token ltpa_token_object = null;
                String[] providerURL = null;
                String[] connectorType = null;
                String[] connectorHost = null;
                String[] connectorPort = null;
                boolean kerberos_enabled = OID.compareOIDs(this.getSecurityConfig().getActiveAuthMechanism().getString("OID"), "oid:1.2.840.113554.1.2.2") || Boolean.valueOf(this.getSecurityConfig().getAuthMechanism("SPNEGO").getBoolean("enabled")) != false;
                String t = "true";
                if (opaque_token == null || krbAuthnToken == null && kerberos_enabled) {
                    ltpa_token_object = this.getWSCredTokenMapper().validateLTPAToken(token);
                    serverName = ltpa_token_object.getAttributes("process.serverName");
                    if (serverName != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverName is " + serverName[0]);
                    }
                    tokenUniqueID = ltpa_token_object.getAttributes("hashed_uid");
                    providerURL = ltpa_token_object.getAttributes("java.naming.provider.url");
                    connectorType = ltpa_token_object.getAttributes("type");
                    connectorHost = ltpa_token_object.getAttributes("host");
                    connectorPort = ltpa_token_object.getAttributes("port");
                    oid = ltpa_token_object.getAttributes("security.authMechOID");
                    if (krbAuthnToken == null) {
                        String[] sso_krb5_exists = ltpa_token_object.getAttributes("krb5_exists");
                        if (sso_krb5_exists != null) {
                            kerberos_enabled = t.equalsIgnoreCase(sso_krb5_exists[0]);
                        }
                        if (!kerberos_enabled && (sso_krb5_exists = ltpa_token_object.getAttributes("security.ltpa.sso.spnego")) != null) {
                            kerberos_enabled = t.equalsIgnoreCase(sso_krb5_exists[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO_KRB5_EXISTS is " + kerberos_enabled);
                        }
                    }
                    if (sso_token != null && connectorType != null && connectorHost != null && connectorPort != null && serverName != null && serverName[0] != null) {
                        connectorProps.setProperty("type", connectorType[0]);
                        connectorProps.setProperty("host", connectorHost[0]);
                        connectorProps.setProperty("port", connectorPort[0]);
                    }
                }
                if (opaque_token == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not found subject in DynaCache, getting distributed object using MBean.");
                    }
                    if (tokenUniqueID != null && tokenUniqueID[0] != null) {
                        subject = this.cache.getSubject(tokenUniqueID[0]);
                    }
                    if (subject != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found subject using token unique ID: " + tokenUniqueID);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer");
                        }
                        return subject;
                    }
                    SecurityConfig security2 = this.getSecurityConfig();
                    if (security2.getProperty("com.ibm.ws.security.webPropagationTransport").equals("IIOP") && providerURL != null) {
                        Hashtable<String, String> connectorHash = new Hashtable<String, String>();
                        connectorHash.put("java.naming.provider.url", providerURL[0]);
                        connectorHash.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                        opaque_token = this.getOpaqueTokenFromCorbaObject(sso_token, connectorHash);
                    } else if (sso_token != null && connectorType != null && connectorHost != null && connectorPort != null && serverName != null && serverName[0] != null) {
                        opaque_token = this.getOpaqueTokenFromMBean(sso_token, serverName[0], connectorProps);
                    }
                }
                if (opaque_token != null) {
                    ArrayList tokenList = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting token holder list from opaque token.");
                        }
                        if ((tokenList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(opaque_token)) != null && kerberos_enabled && krbAuthnToken == null) {
                            Iterator tokenIterator = tokenList.iterator();
                            boolean found = false;
                            while (tokenIterator.hasNext()) {
                                byte[] initial_ctx_token;
                                TokenHolder tokenHolder = (TokenHolder)tokenIterator.next();
                                if (tokenHolder.getName().startsWith(KRBAuthnToken.WSSECURITY_KRBAUTHNTOKEN_NAME)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found \"" + KRBAuthnToken.WSSECURITY_KRBAUTHNTOKEN_NAME + "\" in the Subject.");
                                    }
                                    found = true;
                                }
                                if (found) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "KRBAuthnToken not found locally, getting from MBean.");
                                }
                                if (serverName != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Get token from Mbean " + sso_token + serverName[0]);
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "serverName is null");
                                }
                                if ((initial_ctx_token = this.getInitialContextTokenFromMBean(sso_token, serverName[0], connectorProps)) == null) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Token is null");
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting return_object = initial context token.");
                                }
                                return_object = initial_ctx_token;
                            }
                        }
                        if (tokenList != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "Token holder list has been set on the thread.");
                            }
                            this.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), tokenList);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get token holder list.");
                        }
                        break block52;
                    }
                    catch (WSSecurityException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get token holder list.", new Object[]{e});
                        }
                        break block52;
                    }
                }
                if (tokenUniqueID != null && tokenUniqueID[0] != null && (csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound")) {
                    throw new WSLoginFailedException("SSO token uniqueID not null, but opaque token not found.  Need to re-challenge the user to login again.");
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", "1665", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{e});
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", "1670", this);
                if (!tc.isDebugEnabled()) break block52;
                Tr.debug(tc, "Exception getting opaque token from originating server.");
            }
        }
        if (return_object != null && return_object instanceof KRBAuthnToken) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (KRBAuthnToken)");
            } else if (return_object != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (byte[])");
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSubjectFromDynaCacheOrOriginatingServer (null)");
                }
            }
        }
        return return_object;
    }

    private byte[] getOpaqueTokenFromCorbaObject(final ByteArray ssoToken, final Hashtable connectorProps) {
        byte[] returnedToken;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromCorbaObject", new Object[]{ssoToken, connectorProps});
            }
            returnedToken = null;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block3: {
                        try {
                            TokenHolder th;
                            com.ibm.ws.security.server.SecurityServer securityServer;
                            InitialContext ic = new InitialContext(connectorProps);
                            Object objref = ic.lookup("SecurityServer");
                            if (objref != null && (securityServer = (com.ibm.ws.security.server.SecurityServer)PortableRemoteObject.narrow((Object)objref, com.ibm.ws.security.server.SecurityServer.class)) != null && (th = securityServer.getOpaqueToken(ssoToken)) != null) {
                                return th.getBytes();
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1717", this);
                            if (!tc.isDebugEnabled()) break block3;
                            Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{e});
                        }
                    }
                    return null;
                }
            };
            try {
                returnedToken = (byte[])this.runAsSpecified(this.createUnauthenticatedSubject(), action);
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1730", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{e});
                }
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromCorbaObject", "1734", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromCorbaObject", returnedToken);
        }
        return returnedToken;
    }

    private byte[] getOpaqueTokenFromMBean(final ByteArray ssoToken, final String serverName, final Properties connectorProps) {
        byte[] returnedToken;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueTokenFromMBean", new Object[]{ssoToken, serverName, connectorProps});
            }
            returnedToken = null;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return ContextManagerImpl.this.getWSCredTokenMapper().getOpaqueTokenFromMBean(ssoToken, serverName, connectorProps);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", "1763", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting opaque token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                returnedToken = (byte[])this.runAsSystem(action);
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getOpaqueTokenFromMBean", "1776", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception getting opaque token from originating server.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromMBean", returnedToken);
        }
        return returnedToken;
    }

    public Subject getOwnSubject() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOwnSubject");
        }
        Subject subject = null;
        try {
            StateofCurrObj the_state;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GET_OWN_CRED_PERM.toString());
                }
                sm.checkPermission(GET_OWN_CRED_PERM);
            }
            if ((subject = (the_state = this.getThreadLocal().get_state_of_curr_obj()).getOwnSubject()) == null && !this.processIsServer()) {
                subject = VaultImpl.getInstance().get_default_subject();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getOwnSubject", "1812", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOwnSubject");
        }
        return subject;
    }

    public PlatformHelper getPlatformHelper() {
        return PlatformHelperFactory.getPlatformHelper();
    }

    public PropagationToken getPropagationToken(String key) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationToken", key);
        }
        if (key == null) {
            throw new WSSecurityException("Invalid null parameter");
        }
        PropagationToken pt = null;
        if (this.isCellSecurityEnabled()) {
            pt = this.getThreadLocal().get_propagation_token(key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropagationToken", pt);
        }
        return pt;
    }

    public Map getPropagationTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationTokens");
        }
        Map map = null;
        if (this.isCellSecurityEnabled()) {
            map = this.getThreadLocal().get_propagation_tokens();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropagationTokens", map);
        }
        return map;
    }

    public String getProperty(String name) {
        String retProperty;
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getProperty : " + name);
        }
        if ((retProperty = this.getPropertyCache.get(name)) == null) {
            ORB theORB;
            String propObject = null;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (csiv2 != null) {
                propObject = csiv2.getString(name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property from csiv2 config is: " + propObject);
                }
            }
            if (propObject == null && RasHelper.isServer()) {
                SecurityConfig sec2 = this.getSecurityConfig();
                if (sec2 != null) {
                    propObject = sec2.getString(name);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property from security config is: " + propObject);
                    }
                }
            } else if (!RasHelper.isServer() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getProperty is called on client, skipping SecurityConfig check.");
            }
            if (propObject == null && (theORB = VaultImpl.getInstance().getORB()) != null) {
                propObject = theORB.getProperty(name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Property from orb is: " + propObject + ", the orb: " + theORB);
                }
            }
            String string = retProperty = propObject != null ? propObject.toString() : EMPTY;
            if (retProperty != null) {
                this.getPropertyCache.put(name, retProperty);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning: " + retProperty);
        }
        return retProperty;
    }

    public String getProperty(String name, String defaultProperty) {
        String retProperty = this.getProperty(name);
        retProperty = retProperty == null ? defaultProperty : retProperty;
        return retProperty;
    }

    public List getRealms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealms");
        }
        List realms = null;
        try {
            realms = this.getSecurityServer().getRealms();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getRealms", "1933", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getRealms(): ", new Object[]{e});
            }
            realms = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealms", realms);
        }
        return realms;
    }

    public String getRegionId() {
        return this.regionUserid;
    }

    public static UserRegistry getNewRegistryImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewRegistryImpl");
        }
        UserRegistryImpl registry = null;
        try {
            registry = new UserRegistryImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewRegistryImpl", registry);
        }
        return registry;
    }

    public UserRegistry getNewRegistry() {
        return null;
    }

    public UserRegistry getRegistry(String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistry", realm);
        }
        UserRegistry registry = null;
        try {
            registry = this.getSecurityServer().getRegistry(realm);
            if (registry == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getRegistry is null (likely bootstrap), returning getRegistryImpl.");
                }
                registry = SecurityServerImpl.getRegistryImpl(realm);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getRegistry", "1984", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during getRegistry(): ", new Object[]{e});
            }
            registry = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry", registry);
        }
        return registry;
    }

    private Object getRegistryObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegistryObject");
        }
        if (this._registryObject == null) {
            try {
                this._registryObject = SecurityServerImpl.getRegistryImpl(this.getDefaultRealm());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getRegistryObject", "2001");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting registry instance during bootstrap check.", e);
                }
                this._registryObject = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistryObject", this._registryObject);
        }
        return this._registryObject;
    }

    public long getReqTimeout() {
        ORB theORB = VaultImpl.getInstance().getORB();
        long minCushion = theORB.getRequestTimeout() - 5000;
        return minCushion;
    }

    public Throwable getRootException() {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        return this.getThreadLocal().get_root_exception();
    }

    private SecurityServer getSecurityServer() throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityServer");
        }
        if (this.securityServer == null) {
            try {
                this.securityServer = VaultImpl.getInstance().getSecurityServer();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getSecurityServer", "2036");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, EMPTY, e);
                }
                this.securityServer = null;
                throw new AuthenticationFailedException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityServer", this.securityServer);
        }
        return this.securityServer;
    }

    public String getSecurityServerHost() {
        if (this.isCellSecurityEnabled()) {
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            return csiv2.getString("com.ibm.CORBA.securityServerHost");
        }
        return EMPTY;
    }

    public String getSecurityServerPort() {
        if (this.isCellSecurityEnabled()) {
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            return csiv2.getString("com.ibm.CORBA.securityServerPort");
        }
        return EMPTY;
    }

    public synchronized WSCredential getServerCredential() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerCredential");
        }
        WSCredential serverCred = null;
        if (!this.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerCredential, not on server");
            }
            return null;
        }
        Subject subject = this.getServerSubject();
        serverCred = SubjectHelper.getWSCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerCredential", serverCred);
        }
        return serverCred;
    }

    public boolean getServerSecurityEnabled() {
        return this.serverSecurityEnabled;
    }

    public void refreshServerSubject() throws WSSecurityException {
        this.refreshServerSubject(false);
    }

    public void refreshServerSubject(boolean forceOnLTPAKeyRefresh) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshServerSubject");
        }
        try {
            this.refreshServerSubject = true;
            this.getServerSubjectInternal(forceOnLTPAKeyRefresh);
        }
        catch (WSSecurityException e) {
            throw e;
        }
        finally {
            this.refreshServerSubject = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshServerSubject");
        }
    }

    public Subject getServerSubject() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSubject");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubject cell security not enabled, returning null");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            if (this.serverSubject != null) {
                Tr.debug(tc, "AdminContext.peek() = " + AdminContext.peek() + " _domainId: " + this._domainId + " initialized: " + this.initialized + " serverSubject: " + this.serverSubject.toString());
            } else {
                Tr.debug(tc, "AdminContext.peek() = " + AdminContext.peek() + " _domainId: " + this._domainId + " initialized: " + this.initialized + " serverSubject is NULL");
            }
        }
        if (AdminContext.peek() == null && !this._domainId.equalsIgnoreCase("admin")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerSubject sending to admin ContextManager");
            }
            this.serverSubject = ContextManagerFactory.getInstance("admin").getServerSubject();
            return this.serverSubject;
        }
        Subject subject = null;
        if (tc.isDebugEnabled() && this.serverSubject != null) {
            Tr.debug(tc, "serverSubject again: " + this.serverSubject.toString());
        }
        if (this.serverSubject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BOOTSTRAP MODE");
            }
            if (AdminContext.peek() != null && this._domainId != null && this._domainId.startsWith("profile:")) {
                return ContextManagerFactory.getInstance("admin").getServerSubject();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BOOTSTRAP MODE: Returning BasicAuth server subject");
            }
            subject = this.serverBASubject;
            if (tc.isDebugEnabled()) {
                if (this.serverBASubject == null) {
                    Tr.debug(tc, "serverBASubject is null");
                } else {
                    Tr.debug(tc, "serverBASubject: " + this.serverBASubject.toString());
                }
            }
        } else {
            subject = this.getServerSubjectInternal();
        }
        if (tc.isEntryEnabled()) {
            final Subject subjectPriv = subject;
            com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Tr.exit(tc, "getServerSubject", subjectPriv);
                    return null;
                }
            });
        }
        return subject;
    }

    public Subject getServerSubjectInternal() throws WSSecurityException {
        return this.getServerSubjectInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getServerSubjectInternal(boolean forceOnLTPAKeyRefresh) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSubjectInternal");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubjectInternal cell security not enabled, returning null");
            }
            return null;
        }
        if (!this.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubjectInternal", null);
            }
            return null;
        }
        if (AdminContext.peek() == null && !this._domainId.equalsIgnoreCase("admin")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getServerSubjectInternal sending to admin ContextManager");
            }
            this.serverSubject = ContextManagerFactory.getInstance("admin").getServerSubject();
            return this.serverSubject;
        }
        if (this.getRegistryObject() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BOOTSTRAP MODE: Returning unauthenticated server subject.");
            }
            Subject unauthenticatedSubject = this.createUnauthenticatedSubject();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSubjectInternal", unauthenticatedSubject);
            }
            return unauthenticatedSubject;
        }
        SecurityConfig security2 = this.getSecurityConfig();
        String activeAuthMechOid = security2.getActiveAuthMechanism().getString("OID");
        if (this.serverTokenCred != null && !this.serverTokenCred.isDestroyed()) {
            boolean valid = true;
            long timeRemaining = 0L;
            try {
                long expiration = 0L;
                long krbAuthnTokenExpiration = 0L;
                ContextManagerImpl contextManagerImpl = this;
                synchronized (contextManagerImpl) {
                    expiration = this.serverTokenCred.getExpiration();
                    if (this.serverKRBAuthnToken != null) {
                        krbAuthnTokenExpiration = this.serverKRBAuthnToken.getTokenExpiration();
                    }
                }
                if (expiration == -1L || expiration == 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Subject does not expire.");
                    }
                    return this.serverSubject;
                }
                long current_time = System.currentTimeMillis();
                timeRemaining = expiration - current_time - this.cache.getCushion();
                if (timeRemaining < 0L) {
                    valid = false;
                }
                if (this.serverKRBAuthnToken != null) {
                    long krbAuthnTokenTimeRemaining = krbAuthnTokenExpiration - current_time - this.cache.getCushion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "current_time: " + current_time);
                        Tr.debug(tc, "cushion: " + this.cache.getCushion());
                        Tr.debug(tc, "WSCredential time remaining:  " + timeRemaining);
                        Tr.debug(tc, "KRBAuthnToken time remaining: " + krbAuthnTokenTimeRemaining);
                    }
                    if (krbAuthnTokenTimeRemaining < 0L) {
                        valid = false;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is server subject valid? " + valid);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2283");
                Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{e});
                throw new WSSecurityException(e.getMessage(), e);
            }
            if (valid && !this.refreshServerSubject) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerSubjectInternal: Server Subject returned with sufficient time left.");
                }
                return this.serverSubject;
            }
            ContextManagerImpl e = this;
            synchronized (e) {
                block68: {
                    long krbAuthnTokenTimeRemaining;
                    long expiration = 0L;
                    long krbAuthnTokenExpiration = 0L;
                    try {
                        expiration = this.serverTokenCred.getExpiration();
                        if (this.serverKRBAuthnToken != null) {
                            krbAuthnTokenExpiration = this.serverKRBAuthnToken.getTokenExpiration();
                        }
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException(e2, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2306");
                        Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{e2});
                        throw new WSSecurityException(e2.getMessage(), e2);
                    }
                    long current_time = System.currentTimeMillis();
                    timeRemaining = expiration - (current_time + this.cache.getCushion());
                    if (timeRemaining <= 0L || forceOnLTPAKeyRefresh) {
                        if (forceOnLTPAKeyRefresh) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "LTPA runtime keys being refreshed, forcing refresh of server subject");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Subject expired, refreshing...");
                        }
                        valid = false;
                    }
                    if (this.serverKRBAuthnToken != null && (krbAuthnTokenTimeRemaining = krbAuthnTokenExpiration - current_time - this.cache.getCushion()) < 0L) {
                        valid = false;
                    }
                    if (!valid) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Subject expired, refreshing...");
                        }
                        try {
                            Subject subjectPriv;
                            SecurityConfig securityConfig;
                            if (AdminContext.peek() == null && !this._domainId.equalsIgnoreCase("admin")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "getServerSubject sending to admin ContextManager");
                                }
                                this.serverSubject = ContextManagerFactory.getInstance("admin").getServerSubject();
                                return this.serverSubject;
                            }
                            if (this.serverAuthToken != null) {
                                this.serverAuthToken = (AuthenticationToken)this.serverAuthToken.clone();
                            }
                            if (this.serverAuthzToken != null) {
                                this.serverAuthzToken = (AuthorizationToken)this.serverAuthzToken.clone();
                            }
                            if (this.serverSSOToken != null) {
                                this.serverSSOToken = (SingleSignonToken)this.serverSSOToken.clone();
                            }
                            try {
                                securityConfig = security2;
                                subjectPriv = this.serverSubject;
                                final AuthorizationToken newAuthzToken = this.serverAuthzToken;
                                final AuthenticationToken newAuthToken = this.serverAuthToken;
                                final SingleSignonToken newSSOToken = this.serverSSOToken;
                                this.isKerberosServerSubject = false;
                                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws WSLoginFailedException, WSSecurityException {
                                        Iterator<Object> privCreds = subjectPriv.getPrivateCredentials().iterator();
                                        Object kt = null;
                                        Object rkt = null;
                                        while (privCreds.hasNext()) {
                                            Object cred = privCreds.next();
                                            if (cred instanceof AuthorizationToken && cred instanceof AbstractTokenImpl) {
                                                ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)((Object)newAuthzToken)).getToken());
                                                continue;
                                            }
                                            if (cred instanceof KRBAuthnToken) {
                                                ContextManagerImpl.this.isKerberosServerSubject = true;
                                                continue;
                                            }
                                            if (cred instanceof AuthenticationToken && cred instanceof AbstractTokenImpl) {
                                                ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)((Object)newAuthToken)).getToken());
                                                continue;
                                            }
                                            if (!(cred instanceof SingleSignonToken) || !(cred instanceof AbstractTokenImpl)) continue;
                                            ((AbstractTokenImpl)cred).setToken(((AbstractTokenImpl)((Object)newSSOToken)).getToken());
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e3) {
                                FFDCFilter.processException((Throwable)e3.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2394", this);
                                this.setRootException(e3.getException());
                                throw new WSSecurityException(e3.getException().getMessage(), e3.getException());
                            }
                            if (this.serverAuthToken != null && this.serverAuthzToken != null) {
                                WSCredential newCred = this.getWSCredTokenMapper().createWSCredentialFromTokens(this.serverAuthToken.getBytes(), this.serverAuthzToken);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Updating server Subject with new wsCred token.");
                                }
                                ((WSCredentialImpl)this.serverTokenCred).refreshCred(newCred);
                            }
                            if (!this.isKerberosServerSubject) break block68;
                            try {
                                securityConfig = security2;
                                subjectPriv = this.serverSubject;
                                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws WSLoginFailedException, WSSecurityException {
                                        Iterator<Object> privCreds = subjectPriv.getPrivateCredentials().iterator();
                                        KerberosTicket kt = null;
                                        KerberosTicket rkt = null;
                                        while (privCreds.hasNext()) {
                                            block10: {
                                                Object cred = privCreds.next();
                                                if (!(cred instanceof KRBAuthnToken)) continue;
                                                try {
                                                    if (cred instanceof KRBTicket && ContextManagerImpl.this.isKrbAuthnTokenRenewable((KRBAuthnToken)cred)) {
                                                        kt = ((KRBTicket)cred).getKerberosTicket();
                                                        if (kt != null) {
                                                            rkt = ContextManagerImpl.refreshKerberosTicket(kt);
                                                        }
                                                        if (rkt != null && tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "Refresh Kerberos ticket successful");
                                                        }
                                                    }
                                                    if (kt != null && rkt == null || kt == null && securityConfig.getActiveAuthMechanism().getBoolean("enabledGssCredDelegate")) {
                                                        if (tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "Kerberos ticket is not renewed or failed to refresh or existed, get a new one.");
                                                        }
                                                        if (!securityConfig.getPropertyBool("com.ibm.websphere.security.krb.not.get.kerberos.ticket")) {
                                                            rkt = ContextManagerImpl.this.getKerberosTicketFromKDC();
                                                        }
                                                    }
                                                    if (kt != null && rkt == null) {
                                                        Tr.warning(tc, "Can not refresh nor get a new Kerberos ticket, so fallback to LTPA authentication until the next refresh");
                                                    }
                                                    ((KRBTicket)cred).setKerberosTicket(rkt);
                                                }
                                                catch (Exception e) {
                                                    if (!tc.isDebugEnabled()) break block10;
                                                    Tr.debug(tc, "Exception refreshing the KRBAuthnToken.", new Object[]{e.getMessage()});
                                                }
                                            }
                                            return null;
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException e4) {
                                FFDCFilter.processException((Throwable)e4.getException(), "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2461", this);
                                this.setRootException(e4.getException());
                                throw new WSSecurityException(e4.getException().getMessage(), e4.getException());
                            }
                        }
                        catch (Exception e5) {
                            FFDCFilter.processException(e5, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2468");
                        }
                    }
                }
            }
        }
        if (this.serverTokenCred == null) {
            try {
                Subject subject = null;
                String internalServerId = null;
                CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                boolean useRegistryServerId = csiv2.getBoolean("com.ibm.ws.security.isUseRegistryServerId");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "useRegistryServerId", new Boolean(useRegistryServerId));
                }
                if (!useRegistryServerId) {
                    internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                    if (internalServerId == null) {
                        throw new WSSecurityException("Found null internalServerId.");
                    }
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    String uniqueId = "server:" + this.getDefaultRealm() + "/" + internalServerId;
                    hashtable.put("com.ibm.wsspi.security.cred.uniqueId", uniqueId);
                    String securityName = internalServerId;
                    hashtable.put("com.ibm.wsspi.security.cred.securityName", securityName);
                    Subject in_subject = new Subject();
                    in_subject.getPublicCredentials().add(hashtable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "internal serverID's uniqueID = " + uniqueId + " and securityName = " + securityName);
                    }
                    if ((subject = this.login(this.getAdminRealm(), internalServerId, null, null, null, null, in_subject)).getPublicCredentials().contains(hashtable)) {
                        subject.getPublicCredentials().remove(hashtable);
                    }
                    this.cache.insert(subject);
                } else {
                    String loginPassword = csiv2.getString("com.ibm.CORBA.loginPassword");
                    if (loginPassword == null || loginPassword.equals(EMPTY)) {
                        subject = this.login(this.getAdminRealm(), csiv2.getString("com.ibm.CORBA.loginUserid"));
                        this.cache.insert(subject);
                    } else {
                        subject = this.login(this.getAdminRealm(), csiv2.getString("com.ibm.CORBA.loginUserid"), loginPassword);
                        this.cache.insert(subject, loginPassword);
                    }
                }
                if (subject != null) {
                    this.serverKRBAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
                    WSCredential newCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (this.getPlatformHelper().isZOS()) {
                        PlatformCredential pc = PlatformCredentialManager.instance().createServerCredential();
                        newCred.set("com.ibm.ws.security.zos.PlatformCredential", pc);
                    }
                    this.serverTokenCred = newCred;
                    this.serverSubject = subject;
                    this.serverSubject.setReadOnly();
                    ((WSCredentialImpl)this.serverTokenCred).markServerCred(scs.getEncryptedServerSigner());
                    if (this.serverTokenCred.isForwardable()) {
                        this.serverAuthToken = this.getWSCredTokenMapper().createAuthTokenFromWSCredential(this.serverTokenCred);
                        this.serverAuthzToken = this.getWSCredTokenMapper().createAuthzTokenFromWSCredential(this.serverTokenCred);
                        this.serverSSOToken = this.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.serverTokenCred);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSubjectInternal", "2554");
                Tr.error(tc, "security.SecurityContext.getActualCreds", new Object[]{e});
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        this.serverSubjectCreated = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerSubjectInternal: Server Subject created or refreshed.");
        }
        return this.serverSubject;
    }

    public String getSpecificSecurityServerHost() {
        if (!this.isCellSecurityEnabled()) {
            return EMPTY;
        }
        return this.getThreadLocal().get_all_hosts();
    }

    public String getSpecificSecurityServerPort() {
        if (!this.isCellSecurityEnabled()) {
            return EMPTY;
        }
        return this.getThreadLocal().get_all_ports();
    }

    private Subject getSubjectFromHashtableCacheKey(Subject inSubject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromHashtableCacheKey", inSubject);
        }
        Subject subject = null;
        Object cacheKey = null;
        if (inSubject != null && (cacheKey = this.getWSCredTokenMapper().getCacheKeyFromHashtable(inSubject)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for Subject using cacheKey (" + cacheKey + ") from hashtable.");
            }
            subject = cacheKey instanceof byte[] ? this.cache.getSubject((byte[])cacheKey) : this.cache.getSubject(cacheKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromHashtableCacheKey", subject);
        }
        return subject;
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] token, List tokenHolderList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromTokenHolderCacheKey", new Object[]{token, tokenHolderList});
        }
        Subject subject = null;
        String cacheKeyString = null;
        if (tokenHolderList != null) {
            for (int i = 0; i < tokenHolderList.size(); ++i) {
                boolean tokenMatches;
                TokenHolder th = (TokenHolder)tokenHolderList.get(i);
                if (!th.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] cacheKeyBytes = th.getBytes();
                if (cacheKeyBytes != null) {
                    cacheKeyString = StringBytesConversion.getConvertedString(cacheKeyBytes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cache key from token holder list: " + cacheKeyString);
                    }
                    subject = this.cache.getSubject(cacheKeyString);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Subject using cacheKey from prop token.");
                }
                if (token == null) continue;
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken ssoToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl = tokenMatches = wsCred != null && Arrays.equals(token, wsCred.getCredentialToken()) || ssoToken != null && Arrays.equals(token, ssoToken.getBytes());
                if (tokenMatches) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] return_objects = null;
        if (subject != null || cacheKeyString != null) {
            return_objects = new Object[]{subject, cacheKeyString};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromTokenHolderCacheKey", return_objects);
        }
        return return_objects;
    }

    public ThreadContextImpl getThreadLocal() {
        ThreadContextImpl result = (ThreadContextImpl)this.getThreadLocalStorage().get();
        if (result == null) {
            result = new ThreadContextImpl();
            this.getThreadLocalStorage().set(result);
        }
        return result;
    }

    private ThreadLocal getThreadLocalStorage() {
        return threadLocStorage;
    }

    public WSCredential getUnauthenticatedCredential() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnauthenticatedCredential");
        }
        Subject subject = this.createUnauthenticatedSubject();
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnauthenticatedCredential", cred);
        }
        return cred;
    }

    public String getUnauthenticatedString() {
        if (unauthenticatedId == null) {
            UserRegistryConfig registryType;
            unauthenticatedId = "UNAUTHENTICATED";
            SecurityConfig secCfg = this.getSecurityConfig();
            if (RasHelper.isServer() && this.getPlatformHelper().isZOS() && secCfg != null && (registryType = secCfg.getActiveUserRegistry()) != null && registryType.getType().equals("LOCALOS")) {
                String SAFUnauthenticatedID = this.getProperty("com.ibm.security.SAF.unauthenticated");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUnauthenticatedString SAF Unauthenticated ID is ", SAFUnauthenticatedID);
                }
                if (SAFUnauthenticatedID != null) {
                    unauthenticatedId = SAFUnauthenticatedID;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUnauthenticatedString Unauthenticated ID is ", unauthenticatedId);
            }
        }
        return unauthenticatedId;
    }

    public WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper == null) {
            this.wsCredTokenMapper = new WSCredentialTokenMapper();
        }
        return this.wsCredTokenMapper;
    }

    private void init() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        this.isAuthenticateSpecialMethodsEnabled = csiv2.getBoolean("com.ibm.CSI.authenticateSpecialMethods");
        if (!this.processIsServer()) {
            this.isSecurityServiceStarted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private void initialize() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize(): Security not enabled, returning");
            }
            return;
        }
        if (this.initialized && RasHelper.isServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize(): already initialized, returning");
            }
            return;
        }
        this.initialized = true;
        try {
            this.init();
        }
        catch (Exception e) {
            this.initialized = false;
            if (e instanceof WSSecurityException) {
                throw (WSSecurityException)e;
            }
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (!RasHelper.isServer()) {
            return;
        }
        CSIv2Config csiv2 = null;
        try {
            SecurityService ss;
            csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (this.getPlatformHelper().isZOS()) {
                this._platformCredManager = PlatformCredentialManager.instance();
            }
            scs = ServerCredSigner.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "init(): Server cred signer instance: ", scs);
            }
            if ((ss = this.getSecurityService()) == null) {
                throw new WSSecurityException("Security Service not available");
            }
            ss.addListener(this);
            this.cache = AuthCache.getInstance();
        }
        catch (WSSecurityException e) {
            this.initialized = false;
            throw e;
        }
        catch (Exception e) {
            this.initialized = false;
            throw new WSSecurityException(e.getMessage(), e);
        }
        try {
            if (csiv2.getBoolean("com.ibm.ws.security.isUseRegistryServerId")) {
                this.serverBASubject = SubjectHelper.createBasicAuthSubject(this.getDefaultRealm(), csiv2.getString("com.ibm.CORBA.loginUserid"), csiv2.getString("com.ibm.CORBA.loginPassword"));
                this.serverBACred = SubjectHelper.getWSCredentialFromSubject(this.serverBASubject);
                ((WSCredentialImpl)this.serverBACred).markServerCred(scs.getEncryptedServerSigner());
            }
            SecurityServerFactory.create();
            Subject serverSubject = this.getServerSubjectInternal();
            this.serverTokenCred = SubjectHelper.getWSCredentialFromSubject(serverSubject);
            if (AdminContext.peek() == null || !SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                this.setOwnSubject(serverSubject);
                this.setCallerSubject(serverSubject);
                this.setInvocationSubject(serverSubject);
            }
        }
        catch (Exception ex) {
            this.initialized = false;
            FFDCFilter.processException(ex, "com.ibm.ws.security.auth.ContextManagerImpl.enable", "2843");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, EMPTY, ex);
            }
            throw new WSSecurityException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void initialize(AuditService auditService) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{auditService});
        }
        this.initialize();
        if (auditService != null && this._auditService == null) {
            this._auditService = auditService;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void initializeCallerContext(Subject received_subject) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCallerContext");
        }
        if (tc.isDebugEnabled() && received_subject != null) {
            Tr.debug(tc, "received_subject: " + received_subject.toString());
        }
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        the_state.setCallerSubject(received_subject);
        the_state.setOwnSubject(null);
        the_state.setInvocationSubject(received_subject);
        the_state.setFirstAuthUser(null);
        the_state.setAuthFlag(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCallerContext");
        }
    }

    public void initializeCallerContext(WSCredential[] received_credentials) throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCallerContext");
        }
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        the_state.setWSReceivedCreds(received_credentials);
        the_state.setWSOwnCred(null);
        if (received_credentials != null) {
            the_state.setWSInvocationCred(received_credentials[0]);
        } else {
            the_state.setWSInvocationCred(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCallerContext");
        }
    }

    public void initializeSystemContext() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSystemContext");
        }
        this.initializeCallerContext(this.getServerSubject());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSystemContext");
        }
    }

    public void clearListener(String s) {
        SecurityService ss;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearListener");
        }
        if ((ss = this.getSecurityService()) != null) {
            ss.clearListener(s);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearListener");
        }
    }

    public boolean isCellSecurityEnabled() {
        if (this.isCellSecurityEnabledAlreadyChecked) {
            return this.cellSecurityEnabled;
        }
        if (!RasHelper.isServer()) {
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            this.cellSecurityEnabled = csiv2.getBoolean("com.ibm.CORBA.securityEnabled");
            this.isCellSecurityEnabledAlreadyChecked = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isCellSecurityEnabled " + this.cellSecurityEnabled);
        }
        return this.cellSecurityEnabled;
    }

    public boolean isServerCred(WSCredential cred) throws WSSecurityException {
        boolean isServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCred", cred);
        }
        if (scs == null) {
            isServer = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServerCred scs is null, returning true");
            }
        } else {
            isServer = scs.isServerCred(cred);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCred", new Boolean(isServer));
        }
        return isServer;
    }

    public boolean isServerSecurityEnabled() {
        if (this.isServerSecurityEnabledAlreadyChecked) {
            return this.isEnabled;
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSecurityEnabled");
        }
        String processType = SecurityObjectLocator.getAdminData().getProcessType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processType = " + processType);
        }
        if (processType != null) {
            boolean isAppServer;
            boolean bl = isAppServer = processType.equals("ManagedProcess") || processType.equals("UnManagedProcess");
            this.isEnabled = isAppServer ? csiv2.getBoolean("com.ibm.CORBA.securityEnabled") && csiv2.getBoolean("com.ibm.CORBA.serverSecurityEnabled") : csiv2.getBoolean("com.ibm.CORBA.securityEnabled");
            this.isServerSecurityEnabledAlreadyChecked = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerSecurityEnabled", this.isEnabled);
        }
        return this.isEnabled;
    }

    public boolean isServerSubject(Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSubject", subject);
        }
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        boolean isServer = this.isServerCred(wsCred);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerSubject", new Boolean(isServer));
        }
        return isServer;
    }

    public boolean isWSCred(WSCredential cred) throws WSSecurityException {
        return scs.isWSCred(cred);
    }

    public boolean isWSSubject(Subject subject) throws WSSecurityException {
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        if (scs != null) {
            return scs.isWSCred(wsCred);
        }
        return false;
    }

    public Subject login(String realm, byte[] token) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{realm, token});
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String authMech = csiv2.getString("com.ibm.CSI.authMechAuthAlias");
        String oidStr = null;
        try {
            if (token != null) {
                oidStr = GSSFactory.getMechOIDFromGSSToken(token);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Subject subject = this.login(realm, token, authMech, null, null, null, null, oidStr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    public Subject login(String realm, byte[] token, String authMechOid) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{realm, token, authMechOid});
        }
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String authMech = csiv2.getString("com.ibm.CSI.authMechAuthAlias");
        Subject subject = this.login(realm, token, authMech, null, null, null, null, authMechOid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    public Subject login(String realm, byte[] token, String authMech, HttpServletRequest req, HttpServletResponse resp, Map appContext) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{realm, token, authMech, req, resp, appContext});
        }
        Subject subject = this.login(realm, token, authMech, req, resp, appContext, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    public Subject login(String realm, byte[] token, String authMech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject inSubject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login", new Object[]{realm, token, authMech, req, resp, appContext, inSubject});
        }
        Subject subject = this.login(realm, token, authMech, req, resp, appContext, inSubject, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String realm, byte[] token, String authMech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject inSubject, String authMechOid) throws WSLoginFailedException {
        long startTime = 0L;
        long endTime = 0L;
        try {
            block68: {
                if (StatsFactory.isPMIEnabled()) {
                    startTime = System.currentTimeMillis();
                    if (this.authModule != null) {
                        this.authModule.onTokenAuthCount();
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "login", new Object[]{realm, token, authMech, req, resp, appContext, inSubject, authMechOid});
                }
                if (!this.isCellSecurityEnabled() || token == null || token.length == 0) break block68;
                if (!this.processIsServer()) {
                    Subject subject = null;
                    return subject;
                }
                this.checkAuthRetryForThread();
                try {
                    block69: {
                        Subject subject;
                        String cacheKeyString;
                        block67: {
                            block70: {
                                block71: {
                                    Object return_object;
                                    block74: {
                                        block73: {
                                            block72: {
                                                GSSCredential gssCred;
                                                if (!this.processIsServer()) break block69;
                                                ArrayList tokenHolderList = null;
                                                cacheKeyString = null;
                                                subject = null;
                                                CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Web inbound login config: " + csiv2.getString("com.ibm.ws.security.webInboundLoginConfig"));
                                                }
                                                if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") || csiv2.getBoolean("com.ibm.CSI.rmiOutboundPropagationEnabled") || csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled")) {
                                                    Object[] returned_objects;
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Looking for opaque token on the thread before Subject cache lookup.");
                                                    }
                                                    if ((returned_objects = this.getSubjectFromTokenHolderCacheKey(token, tokenHolderList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null && (returned_objects[0] != null || returned_objects[1] != null)) {
                                                        subject = (Subject)returned_objects[0];
                                                        cacheKeyString = (String)returned_objects[1];
                                                    }
                                                }
                                                if (tokenHolderList == null) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Looking for subject from cache using token as lookup.");
                                                    }
                                                    if ((subject = this.cache.getSubject(token)) != null && authMech != null && authMech.startsWith(csiv2.getString("com.ibm.ws.security.webInboundLoginConfig")) && !this.isTokenMatch(token, subject)) {
                                                        try {
                                                            this.getWSCredTokenMapper().validateLTPAToken(token);
                                                        }
                                                        catch (Exception e) {
                                                            if (tc.isDebugEnabled()) {
                                                                Tr.debug(tc, "Token validation was failed. Most likely ltpatoken is expired. Removing cache entry.");
                                                            }
                                                            ByteArray credArray = new ByteArray(token);
                                                            this.cache.removeEntry(credArray);
                                                            subject = null;
                                                        }
                                                    }
                                                }
                                                if (subject != null || !csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled") || authMech == null || !authMech.startsWith(csiv2.getString("com.ibm.ws.security.webInboundLoginConfig"))) break block70;
                                                return_object = this.getOpaqueTokenFromCacheOrOriginatingServer(token);
                                                if (return_object == null) break block71;
                                                if (!(return_object instanceof KRBAuthnToken)) break block72;
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Logging in with KRBAuthnToken.");
                                                }
                                                if (inSubject != null) {
                                                    if (!inSubject.getPrivateCredentials().contains(return_object)) {
                                                        inSubject.getPrivateCredentials().add(return_object);
                                                    }
                                                } else {
                                                    inSubject = new Subject();
                                                    inSubject.getPrivateCredentials().add(return_object);
                                                }
                                                if ((gssCred = ((KRBAuthnToken)return_object).getGSSCredential()) != null && !inSubject.getPrivateCredentials().contains(GSSCredential.class)) {
                                                    inSubject.getPrivateCredentials().add(gssCred);
                                                }
                                                subject = authMech == null ? this.getJaasLoginHelper().jaas_login(realm, ((KRBAuthnToken)return_object).getTokenPrincipal(), (String)null, inSubject) : (req == null && resp == null && appContext == null ? this.getJaasLoginHelper().jaas_login(realm, ((KRBAuthnToken)return_object).getTokenPrincipal(), null, authMech, inSubject) : this.getJaasLoginHelper().jaas_login(realm, ((KRBAuthnToken)return_object).getTokenPrincipal(), null, authMech, req, resp, appContext, inSubject));
                                                break block71;
                                            }
                                            if (!(return_object instanceof Subject)) break block73;
                                            subject = (Subject)return_object;
                                            break block71;
                                        }
                                        if (!(return_object instanceof GSSCredential)) break block74;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Logging in with GSSCredential in subject.");
                                        }
                                        if (inSubject != null) {
                                            if (!inSubject.getPrivateCredentials().contains(return_object)) {
                                                inSubject.getPrivateCredentials().add(return_object);
                                            }
                                            break block71;
                                        } else {
                                            inSubject = new Subject();
                                            inSubject.getPrivateCredentials().add(return_object);
                                        }
                                        break block71;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Logging in with initial context token.");
                                    }
                                    token = (byte[])return_object;
                                    authMechOid = "oid:1.2.840.113554.1.2.2";
                                }
                                if (subject == null) {
                                    subject = this.getJaasLoginHelper().jaas_login(token, authMech, req, resp, inSubject, appContext, authMechOid);
                                }
                                if (subject != null) {
                                    this.processSubjectForPropagationAfterLogin(subject, authMech, token);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding propagation login Subject to cache.");
                                    }
                                    if (cacheKeyString != null) {
                                        this.cache.insert(subject, new Object[]{cacheKeyString, token});
                                    } else {
                                        this.cache.insert(subject, new Object[]{token});
                                    }
                                }
                            }
                            if (subject == null) break block67;
                            try {
                                WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                                if (credential != null) {
                                    boolean is_destroyed = credential.isDestroyed();
                                    boolean isSubjectValid = this.getWSCredTokenMapper().checkValidityOfAllTokens(subject);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "login(realm, token, . . .): is subject valid? " + isSubjectValid);
                                    }
                                    if (is_destroyed || !isSubjectValid) {
                                        boolean GSSExpired = this.getWSCredTokenMapper().checkGSSCredExpired(subject);
                                        String cred_realm = credential.getRealmName();
                                        String cred_id = credential.getSecurityName();
                                        this.cache.removeEntry(cred_realm, cred_id);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                                        }
                                        if (GSSExpired) {
                                            GSSException gssExc = new GSSException(8, 0, "GSSCredential expired, must login again.");
                                            throw new WSLoginFailedException(gssExc.getMessage(), gssExc);
                                        }
                                        subject = null;
                                        break block67;
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "login(realm, token, authMech, . . .)");
                                    }
                                    Subject subject2 = subject;
                                    return subject2;
                                }
                            }
                            catch (CredentialDestroyedException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Credential is destroyed.", new Object[]{e});
                                }
                                subject = null;
                                break block67;
                            }
                            catch (CredentialExpiredException e) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Credential has expired.", new Object[]{e});
                                }
                                subject = null;
                                break block67;
                            }
                            {
                                subject = null;
                            }
                        }
                        if (subject == null && (subject = this.getJaasLoginHelper().jaas_login(token, authMech, req, resp, inSubject, appContext, authMechOid)) != null) {
                            this.processSubjectForPropagationAfterLogin(subject, authMech, token);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding new Subject to cache.");
                            }
                            if (cacheKeyString != null) {
                                this.cache.insert(subject, new Object[]{cacheKeyString, token});
                            } else {
                                this.cache.insert(subject, new Object[]{token});
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "login(realm, token, authMech, . . .)");
                        }
                        Subject subject3 = subject;
                        return subject3;
                    }
                    if (!tc.isEntryEnabled()) throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
                    Tr.exit(tc, "login(realm, token, authMech, . . .)");
                    throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
                }
                catch (WSLoginFailedException e) {
                    if (!SecurityMessages.suppressFFDCforKrbSkewError(e)) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3342", this);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "login failed: " + e);
                    }
                    if (!tc.isEntryEnabled()) throw e;
                    Tr.exit(tc, "login(realm, token, authMech, . . .)");
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3348", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "login failed: " + this.dump(e));
                    }
                    WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                    if (!tc.isEntryEnabled()) throw ae;
                    Tr.exit(tc, "login(realm, token, authMech, . . .)");
                    throw ae;
                }
                finally {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Clearing propagation token from thread.");
                    }
                    ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "login(realm, token, authMech, . . .)");
            }
            Subject subject = null;
            return subject;
        }
        finally {
            if (StatsFactory.isPMIEnabled()) {
                endTime = System.currentTimeMillis();
                if (this.authModule != null) {
                    this.authModule.onTokenAuthTime(endTime - startTime);
                }
            }
        }
    }

    private void processSubjectForPropagationAfterLogin(Subject subject, String auth_mech) {
        this.processSubjectForPropagationAfterLogin(subject, auth_mech, null);
    }

    public Subject login(String auth_mech, Object protocolPolicy, Subject invocation_subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
        }
        if (this.isCellSecurityEnabled() && protocolPolicy != null && invocation_subject != null) {
            if (!this.processIsServer()) {
                return null;
            }
            try {
                Subject subject = this.getJaasLoginHelper().jaas_login(auth_mech, protocolPolicy, invocation_subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                return subject;
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3392", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + e);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3398", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + this.dump(e));
                }
                WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw ae;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(auth_mech, protocolPolicy, invocation_subject)");
        }
        return null;
    }

    public Subject login(String realm, X509Certificate[] certChain) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, certChain) -> login(" + realm + ", " + certChain + ")");
        }
        Subject subject = this.login(realm, certChain, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, certChain)");
        }
        return subject;
    }

    public Subject login(String realm, X509Certificate[] certChain, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext) throws WSLoginFailedException {
        return this.login(realm, certChain, auth_mech, req, resp, appContext, (Subject)null);
    }

    public Subject login(String realm, X509Certificate[] certChain, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        return this.login(realm, (Object)certChain, auth_mech, req, resp, appContext, in_subject);
    }

    public Subject login(String realm, String user) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user) -> login(" + realm + ", " + user + ")");
        }
        Subject subject = this.login(realm, user, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user)");
        }
        return subject;
    }

    public Subject login(String realm, String user, Map ccacheMap) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user, ccacheMap) -> login(" + realm + ", " + user + ", " + ccacheMap + ")");
        }
        Subject subject = this.login(realm, user, null, null, null, null, null, null, ccacheMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user, ccacheMap)");
        }
        return subject;
    }

    public Subject login(String realm, String user, String password) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(realm, user, password) -> login(" + realm + ", " + user + ", " + ConfigUtils.mask(password) + ")");
        }
        String auth_mech = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        auth_mech = csiv2.getString("com.ibm.CSI.authMechAuthAlias");
        Subject subject = this.login(realm, user, password, auth_mech, null, null, (Map)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(realm, user, password)");
        }
        return subject;
    }

    public Subject login(String realm, String user, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext) throws WSLoginFailedException {
        return this.login(realm, user, auth_mech, req, resp, appContext, null);
    }

    public Subject login(String realm, String user, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        return this.login(realm, (Object)user, auth_mech, req, resp, appContext, in_subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Subject login(String realm, Object loginInfo, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject inSubject) throws WSLoginFailedException {
        long endTime;
        long startTime;
        block66: {
            SecurityManager sm;
            startTime = 0L;
            endTime = 0L;
            if (StatsFactory.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                if (this.authModule != null) {
                    this.authModule.onIDAssertionCount();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login(realm, loginInfo, auth_mech) -> login(" + realm + ", " + loginInfo + ", " + auth_mech + ")");
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                sm.checkPermission(MAP_CREDENTIAL);
            }
            if (!this.isCellSecurityEnabled()) break block66;
            if (!this.processIsServer()) {
                Subject subject = null;
                return subject;
            }
            this.checkAuthRetryForThread();
            Subject subject = null;
            ArrayList tokenHolderList = null;
            String cacheKeyString = null;
            try {
                block64: {
                    subject = this.getSubjectFromHashtableCacheKey(inSubject);
                    CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                    if (subject == null && (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") || csiv2.getBoolean("com.ibm.CSI.rmiOutboundPropagationEnabled") || csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled"))) {
                        Object[] returned_objects;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for opaque token in thread before doing Subject lookup.");
                        }
                        if ((returned_objects = this.getSubjectFromTokenHolderCacheKey(null, tokenHolderList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null) {
                            subject = (Subject)returned_objects[0];
                            cacheKeyString = (String)returned_objects[1];
                        }
                    }
                    String krbAuthnTokenUniqueId = null;
                    if (inSubject != null) {
                        krbAuthnTokenUniqueId = Krb5Utils.getAltKRBAuthnTokenUniqueId(inSubject);
                    }
                    if (subject == null && tokenHolderList == null && !this.getWSCredTokenMapper().subjectContainsLoginHashtable(inSubject) && krbAuthnTokenUniqueId != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for Subject using krbAuthnToken uniqueId.");
                        }
                        subject = this.cache.getSubject(krbAuthnTokenUniqueId);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cache return subject: " + subject);
                        }
                    }
                    if (subject == null && tokenHolderList == null && !this.getWSCredTokenMapper().subjectContainsLoginHashtable(inSubject) && krbAuthnTokenUniqueId == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for Subject using loginInfo(user or cert).");
                        }
                        subject = loginInfo instanceof String ? this.cache.getSubject(realm, (String)loginInfo) : this.cache.getSubject(loginInfo);
                    }
                    if (subject == null) break block64;
                    try {
                        WSCredential credential = subject.getPublicCredentials(WSCredential.class).iterator().next();
                        if (credential != null) {
                            boolean is_destroyed = credential.isDestroyed();
                            boolean is_forwardable = credential.isForwardable();
                            boolean isSubjectValid = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject, this.cache.getCushion());
                            if (tc.isDebugEnabled()) {
                                if (is_forwardable) {
                                    Tr.debug(tc, "login(realm, loginInfo, . . .): is subject valid? " + isSubjectValid);
                                } else {
                                    Tr.debug(tc, "login(realm, loginInfo, . . .): is subject valid? non-forwardable Subject");
                                }
                            }
                            if (is_destroyed || is_forwardable && !isSubjectValid) {
                                if (loginInfo instanceof String) {
                                    this.cache.removeEntry(realm, (String)loginInfo);
                                } else {
                                    this.cache.removeEntry(loginInfo);
                                }
                                subject = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                                }
                                break block64;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(realm, loginInfo, ...)");
                            }
                            Subject subject2 = subject;
                            return subject2;
                        }
                    }
                    catch (CredentialDestroyedException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Credential is destroyed.", new Object[]{e});
                        }
                        subject = null;
                        break block64;
                    }
                    catch (CredentialExpiredException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Credential has expired.", new Object[]{e});
                        }
                        subject = null;
                        break block64;
                    }
                    {
                        subject = null;
                    }
                }
                if (subject == null) {
                    if (auth_mech == null) {
                        if (loginInfo instanceof String) {
                            subject = this.getJaasLoginHelper().jaas_login(realm, (String)loginInfo, (String)null, inSubject);
                        } else {
                            if (!(loginInfo instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + loginInfo.getClass().getName());
                            subject = this.getJaasLoginHelper().jaas_login(realm, (X509Certificate[])loginInfo, inSubject);
                        }
                    } else if (req == null && appContext == null) {
                        if (loginInfo instanceof String) {
                            subject = this.getJaasLoginHelper().jaas_login(realm, (String)loginInfo, null, auth_mech, inSubject);
                        } else {
                            if (!(loginInfo instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + loginInfo.getClass().getName());
                            subject = this.getJaasLoginHelper().jaas_login(realm, (X509Certificate[])loginInfo, auth_mech, inSubject);
                        }
                    } else if (loginInfo instanceof String) {
                        subject = this.getJaasLoginHelper().jaas_login(realm, (String)loginInfo, null, auth_mech, req, resp, appContext, inSubject);
                    } else {
                        if (!(loginInfo instanceof X509Certificate[])) throw new WSLoginFailedException("Unknown login data type: " + loginInfo.getClass().getName());
                        subject = this.getJaasLoginHelper().jaas_login(realm, (X509Certificate[])loginInfo, auth_mech, req, resp, appContext, inSubject);
                    }
                    this.processSubjectForPropagationAfterLogin(subject, auth_mech);
                    if (cacheKeyString != null) {
                        this.cache.insert(subject, new Object[]{cacheKeyString});
                    } else if (loginInfo instanceof String) {
                        this.cache.insert(subject, (String)loginInfo, null, null);
                    } else {
                        this.cache.insert(subject, (Object[])null);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(realm, loginInfo, . . .)");
                }
                Subject subject3 = subject;
                return subject3;
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3643", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + e);
                }
                if (!tc.isEntryEnabled()) throw e;
                Tr.exit(tc, "login(realm, loginInfo, . . .)");
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3649", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + this.dump(e));
                }
                WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                if (!tc.isEntryEnabled()) throw ae;
                Tr.exit(tc, "login(realm, loginInfo, . . .)");
                throw ae;
            }
            finally {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing propagation token from thread.");
                }
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        if (!tc.isEntryEnabled()) return null;
        Tr.exit(tc, "login(realm, loginInfo, . . .)");
        return null;
        finally {
            if (StatsFactory.isPMIEnabled()) {
                endTime = System.currentTimeMillis();
                if (this.authModule != null) {
                    this.authModule.onIDAssertionTime(endTime - startTime);
                }
            }
        }
    }

    public Subject login(String realm, String user, String password, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext) throws WSLoginFailedException {
        return this.login(realm, user, password, auth_mech, req, resp, appContext, null);
    }

    public Subject login(String realm, String user, String password, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject) throws WSLoginFailedException {
        return this.login(realm, user, password, auth_mech, req, resp, appContext, in_subject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(final String realm, final String user, final String password, String auth_mech, HttpServletRequest req, HttpServletResponse resp, Map appContext, Subject in_subject, Map cCacheMap) throws WSLoginFailedException {
        long endTime;
        long startTime;
        block109: {
            Object newContext;
            Subject contextSubject;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login(realm, user, password) -> login(" + realm + ", " + user + ", " + ConfigUtils.mask(password) + ", " + auth_mech + ")");
            }
            startTime = 0L;
            endTime = 0L;
            boolean useKrb5CCache = false;
            if (cCacheMap != null && !cCacheMap.isEmpty()) {
                useKrb5CCache = true;
            }
            if (this.isCellSecurityEnabled() && this.processIsServer()) {
                String context_realm = this.getDefaultRealm();
                contextSubject = null;
                boolean pushed = false;
                newContext = null;
                if (!(realm == null || realm.equalsIgnoreCase(DEFAULT_REALM) || this.getAdminSecurityConfig().getAuthMechanism("KRB5") != null && realm.equalsIgnoreCase(this.getAdminSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm")) || realm.equalsIgnoreCase(context_realm) || !SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined() || SecurityObjectLocator.getSecurityConfig("AppSecurity") == null || SecurityObjectLocator.getSecurityConfig("AppSecurity").getActiveUserRegistry(false) == null || SecurityObjectLocator.getSecurityConfig("AppSecurity").getActiveUserRegistry(false).getString("realm") == null)) {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "in mutlti-domain case: realm is not null and is not default realm: about to validate realm");
                    }
                    try {
                        Object outboundRealms;
                        if (realm.equalsIgnoreCase(this.getAppRealm())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "targeting app domain realm for: " + realm);
                            }
                            pushed = SecurityObjectLocator.pushAppContext(EMPTY);
                            newContext = ContextManagerFactory.getInstance();
                            contextSubject = newContext.login(realm, user, password, auth_mech, req, resp, appContext, in_subject, cCacheMap);
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "got Subject based on app domain realm.");
                            }
                        } else if (realm.equalsIgnoreCase(this.getAdminRealm())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "realm equals admin domain realm.");
                            }
                            pushed = SecurityObjectLocator.pushAdminContext();
                            newContext = ContextManagerFactory.getInstance();
                            contextSubject = newContext.login(realm, user, password, auth_mech, req, resp, appContext, in_subject, cCacheMap);
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "got Subject based on admin domain realm.");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "passed in realm is not app domain nor it is admin realm. Check if a trusted outbound realm");
                            }
                            outboundRealms = this.getSecurityConfig().getOutboundTrustedAuthenticationRealm();
                            String realmList = ((TrustedAuthenticationRealm)outboundRealms).getRealmList();
                            boolean foundMatch = ((TrustedAuthenticationRealm)outboundRealms).getTrustAllRealms();
                            if (!foundMatch && realmList != null && !realmList.equals(EMPTY)) {
                                StringTokenizer st = new StringTokenizer(realmList, PKGNAME_DELIMITER);
                                while (st.hasMoreTokens() && !foundMatch) {
                                    String aTrustedRealm = st.nextToken();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "realm: " + realm);
                                    }
                                    if (!realm.equalsIgnoreCase(aTrustedRealm)) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "target realm matches a trusted outbound realm: " + aTrustedRealm);
                                    }
                                    foundMatch = true;
                                }
                            }
                            if (!foundMatch) throw new WSLoginFailedException("passed in realm is invalid.");
                            contextSubject = SubjectHelper.createBasicAuthSubject(realm, user, password);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "created a basic auth subject");
                            }
                        }
                        outboundRealms = contextSubject;
                        return outboundRealms;
                    }
                    catch (Exception e) {
                        if (!tc.isEntryEnabled()) throw new WSLoginFailedException(e.getMessage());
                        Tr.entry(tc, "caught exception validating passed in realm: " + e.getMessage());
                        throw new WSLoginFailedException(e.getMessage());
                    }
                    finally {
                        if (pushed) {
                            SecurityObjectLocator.popContext();
                        }
                    }
                }
                if (!(realm == null || realm.equalsIgnoreCase(DEFAULT_REALM) || this.getAdminSecurityConfig().getAuthMechanism("KRB5") != null && realm.equalsIgnoreCase(this.getAdminSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm")) || realm.equalsIgnoreCase(context_realm) || SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined())) {
                    if (!tc.isDebugEnabled()) throw new WSLoginFailedException("passed in realm is not valid: " + realm);
                    Tr.debug(tc, "caught exception: passed in realm is not valid: " + realm);
                    throw new WSLoginFailedException("passed in realm is not valid: " + realm);
                }
            }
            if (StatsFactory.isPMIEnabled()) {
                startTime = System.currentTimeMillis();
                if (this.authModule != null) {
                    this.authModule.onBasicAuthCount();
                }
            }
            if ((user == null || user.length() == 0 || password == null || password.length() == 0) && in_subject == null) {
                throw new WSLoginFailedException("Username and/or password is null.");
            }
            if (!this.isCellSecurityEnabled()) break block109;
            this.checkAuthRetryForThread();
            try {
                String appSubjectCacheKey;
                String cacheKeyString;
                Subject subject;
                block107: {
                    String currentRealm;
                    if (!this.processIsServer()) {
                        if (useKrb5CCache) {
                            if (user == null) throw new WSLoginFailedException("Username is null.");
                            if (user.length() == 0) {
                                throw new WSLoginFailedException("Username is null.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "login(realm, user, credential ccache, . . .)");
                            }
                            contextSubject = subject = this.getJaasLoginHelper().jaas_login(realm, user, password, auth_mech, req, resp, appContext, in_subject);
                            return contextSubject;
                        }
                        if (user == null) throw new WSLoginFailedException("Username and/or password is null.");
                        if (user.length() == 0) throw new WSLoginFailedException("Username and/or password is null.");
                        if (password == null) throw new WSLoginFailedException("Username and/or password is null.");
                        if (password.length() == 0) {
                            throw new WSLoginFailedException("Username and/or password is null.");
                        }
                        WSCredential cred = this.createBasicAuthCredential(realm, user, password);
                        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                        if (!csiv2.getBoolean("com.ibm.CORBA.validateBasicAuth")) {
                            Subject pae = SubjectHelper.createSubjectFromWSCredential(cred);
                            return pae;
                        }
                        try {
                            Boolean authResult = (Boolean)this.runAsSpecified(SubjectHelper.createUnauthenticatedSubject(), new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    boolean result = ContextManagerImpl.this.getSecurityServer().simple_authenticate(new BasicAuthData(user, password, realm));
                                    return new Boolean(result);
                                }
                            });
                            if (authResult.booleanValue()) {
                                if (!this.getThreadLocal().get_server_security_enabled()) {
                                    cred = null;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "login(realm, user, password)");
                                }
                                newContext = SubjectHelper.createSubjectFromWSCredential(cred);
                                return newContext;
                            }
                        }
                        catch (PrivilegedActionException pae) {
                            Exception e = pae.getException();
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "3838", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(realm, user, password)");
                            }
                            if (e instanceof WSLoginFailedException) {
                                throw e;
                            }
                            WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                            throw ae;
                        }
                        {
                            if (!tc.isEntryEnabled()) throw new WSLoginFailedException("Failed to authenticate " + cred.getRealmSecurityName());
                            Tr.exit(tc, "login(realm, user, password)");
                            throw new WSLoginFailedException("Failed to authenticate " + cred.getRealmSecurityName());
                        }
                    }
                    subject = null;
                    ArrayList tokenHolderList = null;
                    cacheKeyString = null;
                    appSubjectCacheKey = null;
                    CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                    if (csiv2.getBoolean("com.ibm.CSI.rmiInboundMappingEnabled") && csiv2.getString("com.ibm.CSI.rmiInboundMappingConfig") != null && csiv2.getString("com.ibm.CSI.rmiInboundMappingConfig").length() > 0 && in_subject != null && appContext != null) {
                        String subjectId;
                        String appName;
                        block106: {
                            WSSubjectWrapper subjectWrapper = null;
                            appName = null;
                            subjectId = null;
                            try {
                                Iterator<WSSubjectWrapperImpl> privateCreds = in_subject.getPrivateCredentials(WSSubjectWrapperImpl.class).iterator();
                                if (privateCreds.hasNext()) {
                                    subjectWrapper = privateCreds.next();
                                }
                                if (subjectWrapper == null) break block106;
                                appName = (String)appContext.get("WebAppName");
                                subjectId = this.getWSCredTokenMapper().createSubjectUniqueID(subjectWrapper.getSubject());
                                if (subjectId == null) {
                                    WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subjectWrapper.getSubject());
                                    subjectId = cred.getAccessId();
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, " appName = " + appName + " subjectId = " + subjectId);
                                }
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block106;
                                Tr.debug(tc, "Exception caught " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        if (subjectId != null && subjectId.length() > 0 && appName != null && appName.length() > 0) {
                            appSubjectCacheKey = subjectId + "__" + appName;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "appSubjectCacheKey = " + appSubjectCacheKey);
                            }
                            Hashtable<String, String> customProperties = new Hashtable<String, String>();
                            customProperties.put("com.ibm.wsspi.security.cred.cacheKey", appSubjectCacheKey);
                            in_subject.getPrivateCredentials().add(customProperties);
                        }
                    }
                    if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled") || csiv2.getBoolean("com.ibm.CSI.rmiOutboundPropagationEnabled") || csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled")) {
                        Object[] returned_objects;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for opaque token on the thread before Subject cache lookup.");
                        }
                        if ((returned_objects = this.getSubjectFromTokenHolderCacheKey(null, tokenHolderList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null && (returned_objects[0] != null || returned_objects[1] != null)) {
                            subject = (Subject)returned_objects[0];
                            cacheKeyString = (String)returned_objects[1];
                        }
                    }
                    if ((currentRealm = realm) == null) {
                        currentRealm = this.getDefaultRealm();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "realm is null, set default realm for cache lookup:" + currentRealm);
                        }
                    }
                    if (tokenHolderList == null) {
                        if (user != null && user.length() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Looking for subject from cache using user name token as lookup.");
                            }
                            subject = this.cache.getSubject(realm, user, password);
                        } else if (appSubjectCacheKey != null) {
                            subject = this.cache.getSubject(appSubjectCacheKey);
                            if (tc.isDebugEnabled() && subject != null) {
                                Tr.debug(tc, "found subject in cache with key = " + appSubjectCacheKey);
                            }
                        }
                    }
                    if (subject == null) break block107;
                    try {
                        WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                        if (credential != null) {
                            boolean is_destroyed = credential.isDestroyed();
                            boolean is_forwardable = credential.isForwardable();
                            boolean isSubjectValid = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject, this.cache.getCushion());
                            if (tc.isDebugEnabled()) {
                                if (is_forwardable) {
                                    Tr.debug(tc, "login(realm, user, password, . . .): is subject valid? " + isSubjectValid);
                                } else {
                                    Tr.debug(tc, "login(realm, user, password, . . .): is subject valid? non-forwardable Subject");
                                }
                            }
                            if (is_destroyed || is_forwardable && !isSubjectValid) {
                                this.cache.removeEntry(currentRealm, user);
                                subject = null;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                                }
                                break block107;
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
                            }
                            Subject subject2 = subject;
                            return subject2;
                        }
                    }
                    catch (CredentialDestroyedException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Credential is destroyed.", new Object[]{e});
                        }
                        subject = null;
                        break block107;
                    }
                    catch (CredentialExpiredException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Credential has expired.", new Object[]{e});
                        }
                        subject = null;
                        break block107;
                    }
                    {
                        subject = null;
                    }
                }
                if (subject == null) {
                    subject = auth_mech == null ? this.getJaasLoginHelper().jaas_login(realm, user, password, in_subject) : (req == null && appContext == null ? this.getJaasLoginHelper().jaas_login(realm, user, password, auth_mech, in_subject) : this.getJaasLoginHelper().jaas_login(realm, user, password, auth_mech, req, resp, appContext, in_subject));
                    this.processSubjectForPropagationAfterLogin(subject, auth_mech);
                    if (appSubjectCacheKey == null) {
                        this.cache.insert(subject, user, password, new Object[]{cacheKeyString});
                    } else {
                        block108: {
                            try {
                                appSubjectCacheKey = (String)this.getWSCredTokenMapper().getCacheKeyFromHashtable(subject);
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block108;
                                Tr.debug(tc, "Exception caught " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        if (appSubjectCacheKey != null && appSubjectCacheKey.length() > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "insert cache: user = " + user + "  cache key = " + appSubjectCacheKey);
                            }
                            this.cache.insert(subject, user, password, new Object[]{appSubjectCacheKey});
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
                }
                Subject subject3 = subject;
                return subject3;
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "4017", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + e);
                }
                if (!tc.isEntryEnabled()) throw e;
                Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "4025", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "login failed: " + this.dump(e));
                }
                WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                if (!tc.isEntryEnabled()) throw ae;
                Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
                throw ae;
            }
            finally {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing propagation token from thread.");
                }
                ContextManagerFactory.getInstance().put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), null);
            }
        }
        if (!tc.isEntryEnabled()) return null;
        Tr.exit(tc, "login(realm, user, password, auth_mech, . . .)");
        return null;
        finally {
            if (StatsFactory.isPMIEnabled()) {
                endTime = System.currentTimeMillis();
                if (this.authModule != null) {
                    this.authModule.onBasicAuthTime(endTime - startTime);
                }
            }
        }
    }

    public Subject login(WSCredential credential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login(credential)");
        }
        if (this.isCellSecurityEnabled() && credential != null) {
            this.checkAuthRetryForThread();
            try {
                if (credential.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "authenticating userid/password credential.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "login(credential)");
                    }
                    return this.login(credential.getRealmName(), credential.getSecurityName(), StringBytesConversion.getConvertedString(credential.getCredentialToken()));
                }
                if (credential.isCurrent()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "login(credential)");
                    }
                    return SubjectHelper.createSubjectFromWSCredential(credential);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Credential is not current.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw new WSLoginFailedException("Credential is not current.");
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "4085", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSLoginFailedException occurred.", new Object[]{e});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.login", "4091", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authenticate failed: ", this.dump(e));
                }
                WSLoginFailedException ae = new WSLoginFailedException(e.getMessage(), e);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "login(credential)");
                }
                throw ae;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(credential)");
        }
        return null;
    }

    public void popInvocationCredential(WSCredential pushedCreds) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationCredential(pushedCreds);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.popInvocationCredential", "4112", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void popInvocationSubject(Subject pushed_subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationSubject(pushed_subject);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.popInvocationSubject", "4126", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void popReceivedSubject(Subject pushedSubject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setCallerSubject(pushedSubject);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.popReceivedSubject", "4139", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public boolean processIsServer() {
        return RasHelper.isServer();
    }

    private void processSubjectForPropagationAfterLogin(Subject subject, String auth_mech, byte[] token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSubjectForPropagationAfterLogin", new Object[]{auth_mech, new ByteArray(token)});
        }
        try {
            byte[] opaque_token;
            ByteArray input_token = null;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled") && token != null && (opaque_token = (byte[])this.getDistributedObject(input_token = new ByteArray(token))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "processSubjectForPropagationAfterLogin (token already exists in DRS).");
                }
                return;
            }
            WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            if (csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled") || "oid:1.2.840.113554.1.2.2".endsWith(wsCred.getOID())) {
                if (wsCred.isForwardable()) {
                    SingleSignonToken ssoTokenObject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting SSO token from Subject.");
                    }
                    if ((ssoTokenObject = SubjectHelper.getDefaultSSOTokenFromSubject(subject)) != null) {
                        KRBAuthnToken krbAuthnToken;
                        ByteArray sso_token = new ByteArray(ssoTokenObject.getBytes());
                        PropagationToken propToken = this.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                        long expiration_time = 0L;
                        expiration_time = propToken != null ? (propToken.getExpiration() < wsCred.getExpiration() ? propToken.getExpiration() : wsCred.getExpiration()) : wsCred.getExpiration();
                        long current_time = System.currentTimeMillis();
                        long timeToLiveMillis = expiration_time - current_time;
                        int timeToLiveSeconds = (int)(timeToLiveMillis / 1000L);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "timeToLiveSeconds: " + timeToLiveSeconds);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "current_time: " + current_time);
                            Tr.debug(tc, "expiration_time: " + expiration_time);
                            Tr.debug(tc, "timeToLiveMillis: " + timeToLiveMillis);
                            Tr.debug(tc, "timeToLiveSeconds: " + timeToLiveSeconds);
                        }
                        if (csiv2.getBoolean("com.ibm.ws.security.webInboundPropagationEnabled")) {
                            byte[] opaque_token2;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking DRS using SSO token.");
                            }
                            if ((opaque_token2 = (byte[])this.getDistributedObject(sso_token)) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Creating new opaque token.");
                                }
                                opaque_token2 = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject);
                                if (timeToLiveMillis > 0L && opaque_token2 != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding opaque token to distributed cache with timeToLive " + timeToLiveSeconds + " seconds.");
                                    }
                                    this.putDistributedObject(sso_token, opaque_token2, timeToLiveSeconds);
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Opaque token was null.");
                                }
                            }
                            if (input_token != null) {
                                if (timeToLiveMillis > 0L && opaque_token2 != null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding input token to distributed cache with timeToLive " + timeToLiveSeconds + " seconds.");
                                    }
                                    this.putDistributedObject(input_token, opaque_token2, timeToLiveSeconds);
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Input token was null, not adding to DRS.");
                            }
                        }
                        if ((krbAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject)) != null) {
                            int krbTimeToLiveSeconds = (int)((krbAuthnToken.getTokenExpiration() - current_time) / 1000L);
                            if (krbTimeToLiveSeconds > 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding KRBAuthnToken to local cache with timeToLive " + krbTimeToLiveSeconds + " seconds.");
                                }
                                this.putDistributedObjectNotShared(sso_token, krbAuthnToken, krbTimeToLiveSeconds);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "KRBAuthnToken time to live is " + krbTimeToLiveSeconds);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "krbAuthnToken token was null, not adding to DRS.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cannot find LtpaToken2, not adding opaque token to distributed cache.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential is not forwardable, not adding to distributed cache.");
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception adding opaque authz token to distributed cache.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.processSubjectForPropagationAfterLogin", "4262", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSubjectForPropagationAfterLogin");
        }
    }

    public WSCredential pushInvocationCredential(WSCredential cred) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                WSCredential pushedCreds = this.getInvocationCredential();
                this.setInvocationCredential(cred);
                return pushedCreds;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationCredential", "4277", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Subject pushInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject pushedSubject = this.getInvocationSubject();
                this.setInvocationSubject(subject);
                return pushedSubject;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.pushInvocationSubject", "4295", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Subject pushReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject pushedSubject = this.getCallerSubject();
                this.setCallerSubject(subject);
                return pushedSubject;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.pushReceivedSubject", "4312", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Object put(String key, Object value) {
        if (this.isCellSecurityEnabled()) {
            return this.getThreadLocal().set_property(key, value);
        }
        return null;
    }

    private Object putDistributedObject(Object key, Object value, int timeToLive) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(key, value, timeToLive);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "4362");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting distributed object.", new Object[]{e});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object key, Object value, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(key, value, priority, timeToLive, sharingPolicy, dependencyIds);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.distContextManager.getDistributedObject", "4409");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting distributed object.", new Object[]{e});
            }
            return null;
        }
    }

    private Object putDistributedObjectNotShared(Object key, Object value, int timeToLive) {
        try {
            return this.getWSCredTokenMapper().putDistributedObjectNotShared(key, value, timeToLive);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.distContextManager.putDistributedObjectNotShared", "4449");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error setting none shared distributed object.", new Object[]{e});
            }
            return null;
        }
    }

    private void removeStateFromTable() {
        this.getThreadLocal().clearThreadContextImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object runAs(Subject subject, PrivilegedExceptionAction action, String method2) throws PrivilegedActionException {
        Exception exception;
        Object object;
        block44: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runAs", new Object[]{subject, action, method2});
            }
            object = null;
            if (!this.initialized && RasHelper.isServer()) {
                try {
                    object = action.run();
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
                return object;
            }
            this.debugCallingMethod();
            Subject savedSubject = null;
            Subject savedRecSubject = null;
            boolean isSubjectSaved = false;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
                try {
                    Subject receivedSubject;
                    Subject pushSubject = null;
                    if (method2.equals("System")) {
                        pushSubject = this.getServerSubject();
                    } else if (method2.equals("Client")) {
                        receivedSubject = this.getCallerSubject();
                        pushSubject = receivedSubject != null ? receivedSubject : this.getInvocationSubject();
                    } else if (method2.equals("ReceivedClient")) {
                        receivedSubject = this.getCallerSubject();
                        if (receivedSubject != null) {
                            pushSubject = receivedSubject;
                        }
                    } else if (method2.equals("Specified")) {
                        pushSubject = subject;
                    }
                    savedSubject = this.pushInvocationSubject(pushSubject);
                    savedRecSubject = this.pushReceivedSubject(pushSubject);
                    isSubjectSaved = this.setSavedSubjects(savedSubject, savedRecSubject);
                }
                catch (Exception e) {
                    try {
                        this.popInvocationSubject(savedSubject);
                        savedSubject = null;
                        this.popReceivedSubject(savedRecSubject);
                        savedRecSubject = null;
                    }
                    catch (Exception ex) {
                        try {
                            this.popReceivedSubject(savedRecSubject);
                            savedRecSubject = null;
                        }
                        catch (Exception e1) {
                            FFDCFilter.processException((Throwable)e1, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4544", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{e1});
                            }
                            throw new PrivilegedActionException(e1);
                        }
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4548", this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{ex});
                        }
                        throw new PrivilegedActionException(ex);
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4552", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{e});
                    }
                    throw new PrivilegedActionException(e);
                }
            }
            exception = null;
            object = action.run();
            Object var13_16 = null;
            if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) break block44;
            try {
                this.popInvocationSubject(savedSubject);
                savedSubject = null;
                this.popReceivedSubject(savedRecSubject);
                savedRecSubject = null;
                if (isSubjectSaved) {
                    this.clearSavedSubjects();
                }
                break block44;
            }
            catch (Exception ex) {
                try {
                    this.popInvocationSubject(savedSubject);
                    savedSubject = null;
                    this.popReceivedSubject(savedRecSubject);
                    savedRecSubject = null;
                }
                catch (Exception e1) {
                    FFDCFilter.processException((Throwable)e1, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4599", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{e1});
                    }
                    throw new PrivilegedActionException(e1);
                }
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4603", this);
                exception = ex;
            }
            break block44;
            {
                catch (Exception e) {
                    exception = e;
                    Object var13_17 = null;
                    if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) break block44;
                    try {
                        this.popInvocationSubject(savedSubject);
                        savedSubject = null;
                        this.popReceivedSubject(savedRecSubject);
                        savedRecSubject = null;
                        if (isSubjectSaved) {
                            this.clearSavedSubjects();
                        }
                        break block44;
                    }
                    catch (Exception ex) {
                        try {
                            this.popInvocationSubject(savedSubject);
                            savedSubject = null;
                            this.popReceivedSubject(savedRecSubject);
                            savedRecSubject = null;
                        }
                        catch (Exception e1) {
                            FFDCFilter.processException((Throwable)e1, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4599", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{e1});
                            }
                            throw new PrivilegedActionException(e1);
                        }
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4603", this);
                        exception = ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
                    try {
                        this.popInvocationSubject(savedSubject);
                        savedSubject = null;
                        this.popReceivedSubject(savedRecSubject);
                        savedRecSubject = null;
                        if (isSubjectSaved) {
                            this.clearSavedSubjects();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            this.popInvocationSubject(savedSubject);
                            savedSubject = null;
                            this.popReceivedSubject(savedRecSubject);
                            savedRecSubject = null;
                        }
                        catch (Exception e1) {
                            FFDCFilter.processException((Throwable)e1, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4599", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{e1});
                            }
                            throw new PrivilegedActionException(e1);
                        }
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4603", this);
                        exception = ex;
                    }
                }
                throw throwable;
            }
        }
        if (exception != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAs(" + method2 + ") -> Exception occurred.", new Object[]{exception});
            }
            throw new PrivilegedActionException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runAs(" + method2 + ")");
        }
        return object;
    }

    public Object runAsClient(PrivilegedExceptionAction action) throws PrivilegedActionException {
        return this.runAs(null, action, "Client");
    }

    public Object runAsReceivedClient(PrivilegedExceptionAction action) throws PrivilegedActionException {
        return this.runAs(null, action, "ReceivedClient");
    }

    public Object runAsSpecified(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return this.runAs(subject, action, "Specified");
    }

    public Object runAsSpecified(WSCredential cred, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return this.runAs(SubjectHelper.createSubjectFromWSCredential(cred), action, "Specified");
    }

    public Object runAsSystem(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (this.processIsServer()) {
            return this.runAs(null, action, "System");
        }
        try {
            this.debugCallingMethod();
            return action.run();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.runAs", "4661", this);
            if (e instanceof PrivilegedActionException) {
                throw (PrivilegedActionException)e;
            }
            throw new PrivilegedActionException(e);
        }
    }

    public Object runAsSystemOrSpecified(PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runAsSystemOrSpecified");
        }
        Object o = null;
        boolean runAsCalled = false;
        if (this.isCellSecurityEnabled() && PlatformHelperFactory.getPlatformHelper().isZOS()) {
            SecurityConfig security2;
            String useSAFid;
            WSCredential wsCred;
            block10: {
                wsCred = null;
                try {
                    Subject serverSubject = this.getServerSubject();
                }
                catch (WSSecurityException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.runAsSystemOrSpecified", "4690", this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "getServerSubject() failed", e);
                }
            }
            Iterator<WSCredential> publicCreds = this.serverSubject.getPublicCredentials(WSCredential.class).iterator();
            if (publicCreds.hasNext()) {
                wsCred = publicCreds.next();
            }
            if (wsCred != null && this.isInternalServerCredential(wsCred) && (useSAFid = (security2 = this.getSecurityConfig()).getProperty("com.ibm.ws.security.zOS.useSAFidForTransaction")) != null && (useSAFid.equalsIgnoreCase("true") || useSAFid.equalsIgnoreCase("yes"))) {
                Subject serverPlatformSubject;
                block11: {
                    serverPlatformSubject = WSLoginLocalOSExtensionFactory.getInstance().getLocalOSPlatformCredSubject();
                    try {
                        this.setInvocationSubject(serverPlatformSubject);
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "failed to set the invocation subject.", ex);
                    }
                }
                o = this.runAsSpecified(serverPlatformSubject, action);
                runAsCalled = true;
            }
        }
        if (!runAsCalled) {
            o = this.runAsSystem(action);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runAsSystemOrSpecified");
        }
        return o;
    }

    public void setCallerCredentials(WSCredential[] received_credentials) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCallerCredentials");
            }
            try {
                if (tc.isDebugEnabled() && received_credentials != null && received_credentials[0] != null) {
                    Tr.debug(tc, "Setting WS received credential: " + received_credentials[0].getRealmSecurityName());
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                the_state.setWSReceivedCreds(received_credentials);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setCallerCredentials");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setCallerCredentials", "4756", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void setCallerSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCallerSubject");
            }
            try {
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        final Subject subjectPriv = subject;
                        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Tr.debug(tc, "Setting caller subject: " + subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting caller subject to NULL.");
                    }
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                the_state.setCallerSubject(subject);
                if (RasHelper.isServer() && this.getPlatformHelper().isZOS() && (SmfJActivity.isServerActivityRecordingEnabled() || SmfJActivity.isServerIntervalRecordingEnabled())) {
                    this.setFirstAuthUser(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setCallerSubject");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setCallerSubject", "4797", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void setInvocationCredential(WSCredential creds) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setInvocationCredential");
                }
                if (tc.isDebugEnabled() && creds != null) {
                    Tr.debug(tc, "Setting WS invocation credential: " + creds.getRealmSecurityName());
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                the_state.setWSInvocationCred(creds);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setInvocationCredential");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setInvocationCredential", "4822", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void setInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setInvocationSubject");
                }
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        final Subject subjectPriv = subject;
                        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Tr.debug(tc, "Setting invocation subject: " + subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting invocation subject to NULL.");
                    }
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                the_state.setInvocationSubject(subject);
                if (RasHelper.isServer() && this.getPlatformHelper().isZOS() && (SmfJActivity.isServerActivityRecordingEnabled() || SmfJActivity.isServerIntervalRecordingEnabled())) {
                    this.setFirstAuthUser(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setInvocationSubject");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setInvocationSubject", "4863", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void setOwnSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "setOwnSubject");
                }
                if (tc.isDebugEnabled()) {
                    if (subject != null) {
                        final Subject subjectPriv = subject;
                        com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Tr.debug(tc, "Setting own subject: " + subjectPriv);
                                return null;
                            }
                        });
                    } else {
                        Tr.debug(tc, "Setting own subject to NULL.");
                    }
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                the_state.setOwnSubject(subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setOwnSubject");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setOwnSubject", "4898", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
    }

    public void setPlatformHelper(PlatformHelper hlpr) {
        PlatformHelperFactory.setPlatformHelper(hlpr);
    }

    public void setPropagationTokens(Map tokens) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            this.getThreadLocal().set_propagation_tokens(tokens);
        }
    }

    public PropagationToken setPropagationToken(String key, PropagationToken token) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (key == null) {
                throw new WSSecurityException("Invalid null parameters.");
            }
            return this.getThreadLocal().set_propagation_token(key, token);
        }
        return null;
    }

    public void setRootException(Throwable t) {
        Throwable e;
        if (this.isCellSecurityEnabled() && (e = this.getThreadLocal().get_root_exception()) == null) {
            this.getThreadLocal().set_root_exception(t);
        }
    }

    public void setServerSecurityEnabled(boolean value) {
        this.serverSecurityEnabled = value;
    }

    public boolean isGrantedAdminRole(String[] roleNames, Subject subject) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAdminRole");
        }
        if (!this.isCellSecurityEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isGrantedAdminRole - return true");
            }
            return true;
        }
        boolean granted = false;
        try {
            RoleBasedConfigurator configurator = RoleBasedConfiguratorFactory.getConfigurator();
            RoleBasedAuthorizer adminAuthorizer = configurator.getRoleBasedAuthorizer("admin-authz", "domain");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got the RoleBasedAuthorizer object.");
            }
            granted = adminAuthorizer.isGrantedRole(roleNames, subject);
        }
        catch (Throwable t) {
            String s = new String(this.getRegistryObject().toString());
            if (s.indexOf(this.WIM_UR) == -1) {
                FFDCFilter.processException(t, "com.ibm.ws.security.auth.ContextManagerImpl.isGrantedAdminRole", "4987", this);
            }
            throw new WSSecurityException(t.getMessage(), t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAdminRole", new Boolean(granted));
        }
        return granted;
    }

    public boolean isServerSubjectCreated() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isServerSubjectCreated");
        }
        if (!this.processIsServer()) {
            this.serverSubjectCreated = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "process is not server, returning true");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isServerSubjectCreated:" + this.serverSubjectCreated);
        }
        return this.serverSubjectCreated;
    }

    public boolean isInternalServerCredential(WSCredential cred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInternalServerCredential", cred);
        }
        boolean isInternalServerCred = false;
        try {
            String accessId = cred.getAccessId();
            isInternalServerCred = this.isInternalServerId(accessId);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to acquire access ID", e);
            }
            isInternalServerCred = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInternalServerCredential", new Boolean(isInternalServerCred));
        }
        return isInternalServerCred;
    }

    public boolean isInternalServerId(String accessId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInternalServerId", accessId);
        }
        boolean isInternalSvrId = false;
        try {
            StringBuffer sName = new StringBuffer(this.getDefaultRealm());
            sName.append("/").append("server");
            if (accessId != null && (accessId.startsWith("server") || accessId.startsWith(sName.toString()))) {
                isInternalSvrId = true;
            }
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to determine internal server ID", e);
            }
            isInternalSvrId = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInternalServerId", new Boolean(isInternalSvrId));
        }
        return isInternalSvrId;
    }

    public String removePrefix(String internalServerId) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePrefix", internalServerId);
        }
        if ((i = internalServerId.indexOf(":")) != 1) {
            String intSvrId = internalServerId.substring(i + 1);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removePrefix", intSvrId);
            }
            return intSvrId;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePrefix: prefix not found", internalServerId);
        }
        return internalServerId;
    }

    public String getFirstAuthUser() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstAuthUser");
        }
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        String firstAuthUser = the_state.getFirstAuthUser();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstAuthUser", firstAuthUser);
        }
        return firstAuthUser;
    }

    public void setFirstAuthUser(Subject subject) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setFirstAuthUser", subject);
            }
            StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            if (subject != null && !the_state.getAuthFlag()) {
                try {
                    if (!SubjectHelper.getWSCredentialFromSubject(subject).isUnauthenticated() && !this.isServerSubject(subject)) {
                        the_state.setAuthFlag(true);
                    }
                    PlatformCredential platformCred = this.getPlatformCredentialFromSubject(subject);
                    String user = null;
                    if (platformCred != null) {
                        user = platformCred.getUserId();
                    }
                    the_state.setFirstAuthUser(user);
                }
                catch (WSSecurityException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setFirstAuthUser", "5127", this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Error setting firstAuthUser");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFirstAuthUser");
        }
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCred;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCred = null;
            Iterator<PlatformCredential> privateCreds = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (privateCreds.hasNext()) {
                platformCred = privateCreds.next();
            }
            if (platformCred == null) {
                WSCredential wsCred = null;
                Iterator<WSCredential> publicCreds = subject.getPublicCredentials(WSCredential.class).iterator();
                if (publicCreds.hasNext()) {
                    wsCred = publicCreds.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wsCred);
                }
                if (wsCred != null) {
                    try {
                        final WSCredential wsc = wsCred;
                        platformCred = (PlatformCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return wsc.get("com.ibm.ws.security.zos.PlatformCredential");
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unable to get PlatformCredential", e);
                    }
                }
            }
        }
        if (platformCred == null) {
            platformCred = this._platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCred);
        }
        return platformCred;
    }

    public ServiceWithContext getServiceWithContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceWithContext");
        }
        if (svc == null) {
            svc = new ServiceWithContextImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceWithContext", svc);
        }
        return svc;
    }

    public Context getSerializableContext() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSerializableContext");
        }
        ContextImpl ctx = new ContextImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSerializableContext", ctx);
        }
        return ctx;
    }

    private SecurityService getSecurityService() {
        SecurityService ss;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityService");
            }
            ss = null;
            try {
                ss = WsServiceRegistry.getService(this, SecurityService.class);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception getting security service:", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityService", ss);
        }
        return ss;
    }

    public void stateChanged(SecurityServiceEvent event2) {
        int state;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged, current Security Service state: " + (this.isSecurityServiceStarted ? "STARTED" : "STOPPED"));
        }
        if ((state = event2.getState()) == 1) {
            this.isSecurityServiceStarted = true;
        } else if (state == 2) {
            this.isSecurityServiceStarted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged, new Security Service state: " + (this.isSecurityServiceStarted ? "STARTED" : "STOPPED"));
        }
    }

    public boolean isSecurityServiceStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityServiceStarted", new Boolean(this.isSecurityServiceStarted));
        }
        return this.isSecurityServiceStarted;
    }

    public boolean isAuthenticateSpecialMethodsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthenticateSpecialMethodsEnabled", new Boolean(this.isAuthenticateSpecialMethodsEnabled));
        }
        return this.isAuthenticateSpecialMethodsEnabled;
    }

    public boolean isPMIEnabled() {
        return StatsFactory.isPMIEnabled();
    }

    public void pmiCountStatistic(String name) {
        if (name.equalsIgnoreCase("RMIAuthCount")) {
            if (this.authModule != null) {
                this.authModule.onRMIAuthCount();
            }
        } else if (name.equalsIgnoreCase("JAASIDAssertionCount")) {
            if (this.authModule != null) {
                this.authModule.onJAASIDAssertionCount();
            }
        } else if (name.equalsIgnoreCase("JAASBasicAuthCount")) {
            if (this.authModule != null) {
                this.authModule.onJAASBasicAuthCount();
            }
        } else if (name.equalsIgnoreCase("JAASTokenAuthCount") && this.authModule != null) {
            this.authModule.onJAASTokenAuthCount();
        }
    }

    public void pmiTimeStatistic(String name, long elapsedTime) {
        if (name.equalsIgnoreCase("RMIAuthTime")) {
            if (this.authModule != null) {
                this.authModule.onRMIAuthTime(elapsedTime);
            }
        } else if (name.equalsIgnoreCase("JAASIDAssertionTime")) {
            if (this.authModule != null) {
                this.authModule.onJAASIDAssertionTime(elapsedTime);
            }
        } else if (name.equalsIgnoreCase("JAASBasicAuthTime")) {
            if (this.authModule != null) {
                this.authModule.onJAASBasicAuthTime(elapsedTime);
            }
        } else if (name.equalsIgnoreCase("JAASTokenAuthTime") && this.authModule != null) {
            this.authModule.onJAASTokenAuthTime(elapsedTime);
        }
    }

    public Subject getSubjectBeforeRunAs() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectBeforeRunAs");
        }
        Subject subjectBeforeRunAs = null;
        try {
            StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
            Subject[] subjects = the_state.getSavedSubjects();
            subjectBeforeRunAs = subjects[0] != null ? subjects[0] : subjects[1];
            if (subjectBeforeRunAs == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There were no saved subjects.  Getting invocationSubject");
                }
                subjectBeforeRunAs = this.getInvocationSubject();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getSubjectBeforeRunAs", "5385", this);
            throw new WSSecurityException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectBeforeRunAs - returning: " + subjectBeforeRunAs);
        }
        return subjectBeforeRunAs;
    }

    public String getUserBeforeRunAs() throws WSSecurityException {
        if (!this.isCellSecurityEnabled()) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserBeforeRunAs");
        }
        String userBeforeRunAs = null;
        Subject subject = null;
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        userBeforeRunAs = the_state.getUserBeforeRunAs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "user from the state: " + userBeforeRunAs);
        }
        if (userBeforeRunAs == null || userBeforeRunAs.trim().isEmpty()) {
            subject = this.getSubjectBeforeRunAs();
            try {
                WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
                if (creds != null) {
                    userBeforeRunAs = creds.getRealmSecurityName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user from the subject: " + userBeforeRunAs);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getUserBeforeRunAs", "5421", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserBeforeRunAs - returning: " + userBeforeRunAs);
        }
        return userBeforeRunAs;
    }

    public boolean setSavedSubjects(final Subject savedSubject, final Subject recSavedSubject) throws WSSecurityException {
        boolean subjectSaved = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSavedSubjects");
        }
        if (this.isCellSecurityEnabled()) {
            try {
                if (tc.isDebugEnabled()) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (savedSubject == null) {
                                Tr.debug(tc, "Setting null for savedSubject");
                            } else {
                                Tr.debug(tc, "Setting savedSubject:" + savedSubject);
                            }
                            if (recSavedSubject == null) {
                                Tr.debug(tc, "Setting null for recSavedSubject");
                            } else {
                                Tr.debug(tc, "Setting recSavedSubject:" + recSavedSubject);
                            }
                            return null;
                        }
                    });
                }
                StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
                subjectSaved = the_state.setSavedSubjects(savedSubject, recSavedSubject);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.setAuditSubject", "5468", this);
                throw new WSSecurityException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSavedSubjects");
        }
        return subjectSaved;
    }

    public void clearSavedSubjects() {
        StateofCurrObj the_state = this.getThreadLocal().get_state_of_curr_obj();
        the_state.clearSavedSubjects();
        the_state.clearUserBeforeRunAs();
    }

    public String getObjectAdapterName(byte[] userKeyBytes) {
        String OA_name;
        block8: {
            OA_name = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getObjectAdapterName");
            }
            if (userKeyBytes != null) {
                UserKey userKey = null;
                try {
                    userKey = new UserKey(userKeyBytes);
                    OA_name = userKey.getOAName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instantiated a UserKey with OA name:" + OA_name);
                    }
                    break block8;
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "create userKey failed: " + ex.getMessage());
                    }
                    break block8;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "null userKeyBytes");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectAdapterName");
        }
        return OA_name;
    }

    public GSSCredential getServerSpnGSSCred() throws Exception, GSSException {
        SecurityConfig security2;
        String activeAuthMechOid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerSpnGSSCred");
        }
        if (!this.processIsServer()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSpnGSSCred", null);
            }
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SERVER_CRED_PERM.toString());
            }
            sm.checkPermission(GET_SERVER_CRED_PERM);
        }
        if ((activeAuthMechOid = (security2 = this.getSecurityConfig()).getActiveAuthMechanism().getString("OID")) != null && activeAuthMechOid.length() > 0 && "oid:1.2.840.113554.1.2.2".endsWith(activeAuthMechOid)) {
            if (this.serverSpnGSSCred != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerSpnGSSCred", this.serverSpnGSSCred);
                }
                return this.serverSpnGSSCred;
            }
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            String krb5Spn = csiv2.getString("com.ibm.websphere.security.krb.spn");
            if (krb5Spn != null) {
                String krb5Keytab = csiv2.getString("com.ibm.websphere.security.krb.keytab");
                if (krb5Keytab != null) {
                    Krb5Utils.setKrbKeytabProp(krb5Keytab);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Kerberos SPN " + krb5Spn);
                    Tr.debug(tc, "Kerberos Keytab " + krb5Keytab);
                }
                try {
                    Oid krb5MechanismOid = new Oid("1.2.840.113554.1.2.2");
                    Oid spnegoMechanismOid = new Oid("1.3.6.1.5.5.2");
                    Krb5Utils.setUseSubjectCredsOnly(false);
                    GSSManager mgr = GSSManager.getInstance();
                    GSSName gssName = mgr.createName(krb5Spn.replace("/", "@"), GSSName.NT_HOSTBASED_SERVICE, krb5MechanismOid);
                    this.serverSpnGSSCred = mgr.createCredential(gssName.canonicalize(krb5MechanismOid), Integer.MAX_VALUE, krb5MechanismOid, 2);
                    this.serverSpnGSSCred.add(gssName.canonicalize(spnegoMechanismOid), Integer.MAX_VALUE, Integer.MAX_VALUE, spnegoMechanismOid, 2);
                    Krb5Utils.setUseSubjectCredsOnly(true);
                }
                catch (GSSException exc) {
                    exc.printStackTrace();
                    FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSpnGSSCred", "5587", this);
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "Unexpected GSSExecption getting Server SPN GSSCredential ", new Object[]{exc});
                    }
                    throw exc;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getServerSpnGSSCred", "5595", this);
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, "Unexpected Execption getting Server SPN GSSCredential ", new Object[]{e});
                    }
                    throw e;
                }
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerSpnGSSCred", null);
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerSpnGSSCred " + this.serverSpnGSSCred);
        }
        return this.serverSpnGSSCred;
    }

    public boolean isKrbAuthnTokenRenewable(KRBAuthnToken krbAuthnToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKrbAuthnTokenRenewable");
        }
        boolean renewable = true;
        if (!krbAuthnToken.isTokenValid() || !krbAuthnToken.isRenewable()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not refresh KRBAuthnToken, isTokenValid? " + krbAuthnToken.isTokenValid() + ", isTokenRenewable? " + krbAuthnToken.isRenewable());
            }
            renewable = false;
        } else {
            Date renewTill = krbAuthnToken.getRenewTill();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "renewTill: " + renewTill);
            }
            if (renewTill != null) {
                long renewTillInSeconds = renewTill.getTime();
                long current_time = System.currentTimeMillis();
                long timeleft = renewTillInSeconds - current_time - this.cache.getCushion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeleft: " + timeleft);
                }
                if (timeleft < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not much time left to refresh KRBAuthnToken.");
                    }
                    renewable = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKrbAuthnTokenRenewable " + renewable);
        }
        return renewable;
    }

    public String getDomainId() {
        return this._domainId;
    }

    public void setDomainId(String id) {
        this._domainId = id;
    }

    public String toString() {
        return "ContextManagerImpl: " + this.hashCode() + " domainId: " + this.getDomainId();
    }

    public SecurityCache getSecurityCache() {
        return this.cache;
    }

    public SecurityConfig getSecurityConfig() {
        if (this.domainSecurityConfig == null) {
            this.domainSecurityConfig = SecurityObjectLocator.getSecurityConfig();
        }
        return this.domainSecurityConfig;
    }

    public SecurityConfig getAdminSecurityConfig() {
        if (this.adminSecurityConfig == null) {
            this.adminSecurityConfig = SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() ? SecurityObjectLocator.getSecurityConfig() : SecurityObjectLocator.getSecurityConfig("security");
        }
        return this.adminSecurityConfig;
    }

    public static KerberosTicket cloneKerberosTicket(KerberosTicket kt) {
        KerberosTicket newKt = null;
        if (kt != null) {
            byte[] asn1Encoding = kt.getEncoded();
            KerberosPrincipal client = kt.getClient();
            KerberosPrincipal server = kt.getServer();
            byte[] sessionKey = kt.getSessionKey().getEncoded();
            int keyType = kt.getSessionKeyType();
            boolean[] flags = kt.getFlags();
            Date authTime = kt.getAuthTime();
            Date startTime = kt.getStartTime();
            Date endTime = kt.getEndTime();
            Date renewTill = kt.getRenewTill();
            InetAddress[] clientAddresses = kt.getClientAddresses();
            try {
                newKt = new KerberosTicket(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getCause());
            }
        }
        return newKt;
    }

    public static KerberosTicket refreshKerberosTicket(KerberosTicket kt) throws RefreshFailedException {
        KerberosTicket newTicket = ContextManagerImpl.cloneKerberosTicket(kt);
        if (newTicket != null) {
            newTicket.refresh();
        }
        return newTicket;
    }

    private KerberosTicket getKerberosTicketFromKDC() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosTicketFromKDC");
        }
        KerberosTicket kTicket = null;
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Subject in_subject = null;
            if (this.serverTokenCred != null) {
                String uniqueId = this.serverTokenCred.getAccessId();
                hashtable.put("com.ibm.wsspi.security.cred.uniqueId", uniqueId);
                in_subject = new Subject();
                in_subject.getPublicCredentials().add(hashtable);
                in_subject.getPublicCredentials().add(this.serverTokenCred);
            }
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            String loginPassword = csiv2.getString("com.ibm.CORBA.loginPassword");
            Subject subj = this.login(this.getAdminRealm(), csiv2.getString("com.ibm.CORBA.loginUserid"), loginPassword, "system.KRB5", null, null, (Map)null, in_subject);
            kTicket = SubjectHelper.getKerberosTicketFromSubject(subj);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.ContextManagerImpl.getKerberosTicketFromKDC", "5775", this);
            if (tc.isDebugEnabled()) {
                Tr.error(tc, "Unexpected Execption getting a Kerberos ticket from a KDC ", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosTicketFromKDC " + kTicket);
        }
        return kTicket;
    }

    private boolean isTokenMatch(byte[] token, Subject subject) {
        boolean tokenMatches;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTokenMatch");
            }
            tokenMatches = false;
            if (subject != null) {
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken ssoToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                try {
                    tokenMatches = ssoToken != null && Arrays.equals(token, ssoToken.getBytes()) || wsCred != null && Arrays.equals(token, wsCred.getCredentialToken());
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "An exception caught:" + e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenMatch: " + tokenMatches);
        }
        return tokenMatches;
    }

    private static final class SecurityThreadLocal
    extends WSThreadLocal {
        private SecurityThreadLocal() {
        }

        protected Object initialValue() {
            return new ThreadContextImpl();
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

