/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jzos.Rauditx;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.AuditEventSettings;
import com.ibm.ws.security.audit.SecurityAuditEventImpl;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.AuditServiceProvider;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.audit.GenericEvent;
import com.ibm.wsspi.security.audit.GenericEventCompletionException;
import com.ibm.wsspi.security.audit.GenericEventConfigurationException;
import com.ibm.wsspi.security.audit.GenericEventException;
import com.ibm.wsspi.security.audit.GenericEventValidationException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SMFEmitterImpl
implements AuditServiceProvider {
    private static final TraceComponent tc = Tr.register(SMFEmitterImpl.class, null, "com.ibm.ejs.resources.security");
    private AuditEventSettings _aes;
    private ConcurrentHashMap auditFilterSettings = new ConcurrentHashMap();
    private ConcurrentHashMap auditOutcomeSettings = new ConcurrentHashMap();
    private Object _auditEvent = null;
    private String sharedKeyAlias = null;
    private static AuditService auditService = null;
    private String activeUserRegistry = null;
    private int sequenceNumber = 0;
    private Rauditx rauditx = null;
    private boolean verbose = false;
    private static Object syncRauditxObject = new Object();
    private static ConcurrentHashMap aOutcome = new ConcurrentHashMap();

    public void SMFEmitterImpl() {
    }

    public void init(String name, Map properties, Map secProps, Map keyProperties) throws ProviderFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init: " + name);
        }
        if (auditService == null) {
            auditService = ContextManagerFactory.getInstance().getAuditService();
        }
        this.verbose = auditService != null ? auditService.isVerbose() : SecurityObjectLocator.getAuditConfig().getBoolean("verbose");
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        this._aes = new AuditEventSettings();
        this.auditFilterSettings = this._aes.getFilterSettings();
        this.auditOutcomeSettings = this._aes.getOutcomeSettings();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void refresh(Map properties) throws ProviderFailureException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendEvent(Object auditEvent) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent: " + auditEvent.toString());
        }
        SecurityAuditEventImpl sae = new SecurityAuditEventImpl();
        String eventType = sae.getEventType((HashMap)auditEvent);
        String outCome = sae.getOutcome((HashMap)auditEvent);
        int auditEventType = -1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " eventType: " + eventType + " outCome: " + outCome);
        }
        if (this.isActiveProviderSpec(eventType, outCome)) {
            byte[] eventBytes = new byte[16384];
            Object object = syncRauditxObject;
            synchronized (object) {
                this.rauditx = new Rauditx();
                sae.putSequenceNumber((HashMap)auditEvent, this.sequenceNumber);
                ++this.sequenceNumber;
                try {
                    int i;
                    String termR;
                    String authT;
                    String registryT;
                    String processR;
                    String processD;
                    String[] callerList;
                    String fC;
                    String[] rolesGranted;
                    String[] rolesChecked;
                    String[] permsGranted;
                    String[] permsChecked;
                    Long rUID;
                    String rT;
                    String nIA;
                    String aD;
                    String aUN;
                    String rUN;
                    String aN;
                    String pN;
                    String rH;
                    String rP;
                    String rA;
                    String sID;
                    Long gID;
                    eventBytes = sae.buildEventString((HashMap)auditEvent).getBytes("UTF-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "eventBytes: " + new String(eventBytes));
                    }
                    if (outCome.equals("SUCCESS") || outCome.equals("INFO")) {
                        this.rauditx.setEventSuccess();
                    } else {
                        this.rauditx.setEventFailure();
                    }
                    if (outCome.equals("SUCCESS")) {
                        this.rauditx.setQualifier(0);
                    } else if (outCome.equals("INFO")) {
                        this.rauditx.setQualifier(1);
                    } else if (outCome.equals("WARNING")) {
                        this.rauditx.setQualifier(2);
                    } else if (outCome.equals("FAILURE")) {
                        this.rauditx.setQualifier(3);
                    } else if (outCome.equals("REDIRECT")) {
                        this.rauditx.setQualifier(4);
                    } else if (outCome.equals("DENIED")) {
                        this.rauditx.setQualifier(5);
                    } else if (outCome.equals("ERROR")) {
                        this.rauditx.setQualifier(6);
                    }
                    if (eventType.equalsIgnoreCase("SECURITY_AUTHN")) {
                        auditEventType = 1;
                    } else if (eventType.equalsIgnoreCase("SECURITY_AUTHN_CREDS_MOD")) {
                        auditEventType = 18;
                    } else if (eventType.equalsIgnoreCase("SECURITY_AUTHN_DELEGATION")) {
                        auditEventType = 17;
                    } else if (eventType.equalsIgnoreCase("SECURITY_AUTHN_MAPPING")) {
                        auditEventType = 3;
                    } else if (eventType.equalsIgnoreCase("SECURITY_AUTHN_TERMINATE")) {
                        auditEventType = 2;
                    } else if (eventType.equalsIgnoreCase("SECURITY_AUTHZ")) {
                        auditEventType = 4;
                    } else if (eventType.equalsIgnoreCase("SECURITY_ENCRYPTION")) {
                        auditEventType = 16;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_AUDIT")) {
                        auditEventType = 13;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_CONFIG")) {
                        auditEventType = 8;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_KEY")) {
                        auditEventType = 12;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_POLICY")) {
                        auditEventType = 5;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_PROVISIONING")) {
                        auditEventType = 9;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_REGISTRY")) {
                        auditEventType = 6;
                    } else if (eventType.equalsIgnoreCase("SECURITY_MGMT_RESOURCE")) {
                        auditEventType = 10;
                    } else if (eventType.equalsIgnoreCase("SECURITY_RESOURCE_ACCESS")) {
                        auditEventType = 14;
                    } else if (eventType.equalsIgnoreCase("SECURITY_RUNTIME")) {
                        auditEventType = 7;
                    } else if (eventType.equalsIgnoreCase("SECURITY_RUNTIME_KEY")) {
                        auditEventType = 11;
                    } else if (eventType.equalsIgnoreCase("SECURITY_SIGNING")) {
                        auditEventType = 15;
                    }
                    this.rauditx.setEvent(auditEventType);
                    this.rauditx.setSubtype(5);
                    this.rauditx.setFmid("H28W700");
                    this.rauditx.setAlwaysLogSuccesses();
                    this.rauditx.setAlwaysLogFailures();
                    HashMap properties = new HashMap((HashMap)auditEvent);
                    String lastT = (String)properties.get("LastEventTrailId");
                    if (this.verbose) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "lastEventTrailId: " + lastT);
                        }
                        if (lastT != null && lastT.length() != 0) {
                            this.rauditx.addRelocateSection(100, lastT);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "added lastEventTrailId");
                            }
                        }
                    }
                    if (lastT != null && lastT.length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "eventTrailId: " + lastT);
                        }
                        this.rauditx.addRelocateSection(101, lastT);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added eventTrailId");
                        }
                    }
                    String st = new String();
                    Date createT = (Date)properties.get("CreationTime");
                    if (createT != null) {
                        this.rauditx.addRelocateSection(102, createT.toString());
                    }
                    if ((gID = (Long)properties.get("GlobalInstanceId")) != null) {
                        this.rauditx.addRelocateSection(103, gID.toString());
                    }
                    if ((sID = (String)properties.get("SessionId")) != null && sID.length() != 0) {
                        this.rauditx.addRelocateSection(105, sID);
                    }
                    if ((rA = (String)properties.get("RemoteAddr")) != null && rA.length() != 0) {
                        this.rauditx.addRelocateSection(106, rA);
                    }
                    if ((rP = (String)properties.get("RemotePort")) != null && rP.length() != 0) {
                        this.rauditx.addRelocateSection(107, rP);
                    }
                    if ((rH = (String)properties.get("RemoteHost")) != null && rH.length() != 0) {
                        this.rauditx.addRelocateSection(108, rH);
                    }
                    if ((pN = (String)properties.get("ProgName")) != null && pN.length() != 0) {
                        this.rauditx.addRelocateSection(110, pN);
                    }
                    if ((aN = (String)properties.get("Action")) != null && aN.length() != 0) {
                        this.rauditx.addRelocateSection(111, aN);
                    }
                    if ((rUN = (String)properties.get("RegistryUserName")) != null && rUN.length() != 0) {
                        this.rauditx.addRelocateSection(112, rUN);
                    }
                    if ((aUN = (String)properties.get("AppUserName")) != null && aUN.length() != 0) {
                        this.rauditx.addRelocateSection(113, aUN);
                    }
                    if ((aD = (String)properties.get("AccessDecision")) != null && aD.length() != 0) {
                        this.rauditx.addRelocateSection(114, aD);
                    }
                    if ((nIA = (String)properties.get("NameInApp")) != null && nIA.length() != 0) {
                        this.rauditx.addRelocateSection(115, nIA);
                    }
                    if ((rT = (String)properties.get("ResourceType")) != null && rT.length() != 0) {
                        this.rauditx.addRelocateSection(116, rT);
                    }
                    if ((rUID = (Long)properties.get("ResourceUniqueId")) != null) {
                        this.rauditx.addRelocateSection(117, rUID.toString());
                    }
                    if ((permsChecked = (String[])properties.get("PermissionsChecked")) != null && permsChecked.length != 0) {
                        st = "";
                        for (int i2 = 0; i2 < permsChecked.length; ++i2) {
                            st = st.concat(permsChecked[i2] + " , ");
                        }
                        if (st.endsWith(" , ")) {
                            st = st.substring(0, st.length() - 3);
                        }
                        this.rauditx.addRelocateSection(118, st);
                    }
                    if ((permsGranted = (String[])properties.get("PermissionsGranted")) != null && permsGranted.length != 0) {
                        st = "";
                        for (int i3 = 0; i3 < permsGranted.length; ++i3) {
                            st = st.concat(permsGranted[i3] + " , ");
                        }
                        if (st.endsWith(" , ")) {
                            st = st.substring(0, st.length() - 3);
                        }
                        this.rauditx.addRelocateSection(119, st);
                    }
                    if ((rolesChecked = (String[])properties.get("RolesChecked")) != null && rolesChecked.length != 0) {
                        st = "";
                        for (int i4 = 0; i4 < rolesChecked.length; ++i4) {
                            st = st.concat(rolesChecked[i4] + " , ");
                        }
                        if (st.endsWith(" , ")) {
                            st = st.substring(0, st.length() - 3);
                        }
                        this.rauditx.addRelocateSection(120, st);
                    }
                    if ((rolesGranted = (String[])properties.get("RolesGranted")) != null && rolesGranted.length != 0) {
                        st = "";
                        for (int i5 = 0; i5 < rolesGranted.length; ++i5) {
                            st = st.concat(rolesGranted[i5] + " , ");
                        }
                        if (st.endsWith(" , ")) {
                            st = st.substring(0, st.length() - 3);
                        }
                        this.rauditx.addRelocateSection(121, st);
                    }
                    if ((fC = (String)properties.get("FirstCaller")) != null && fC.length() != 0) {
                        this.rauditx.addRelocateSection(123, fC);
                    }
                    if (this.verbose && (callerList = (String[])properties.get("CallerList")) != null && callerList.length != 0) {
                        st = "";
                        for (int i6 = 0; i6 < callerList.length; ++i6) {
                            st = st.concat(callerList[i6] + " , ");
                        }
                        if (st.endsWith(" , ")) {
                            st = st.substring(0, st.length() - 3);
                        }
                        this.rauditx.addRelocateSection(124, st);
                    }
                    if (this.verbose && (processD = (String)properties.get("Domain")) != null && processD.length() != 0) {
                        this.rauditx.addRelocateSection(126, processD);
                    }
                    if ((processR = (String)properties.get("Realm")) != null && processR.length() != 0) {
                        this.rauditx.addRelocateSection(127, processR);
                    }
                    if ((registryT = (String)properties.get("RegistryType")) != null && registryT.length() != 0) {
                        this.rauditx.addRelocateSection(129, registryT);
                    }
                    if (auditEventType == 17) {
                        String delStr = (String)properties.get("DelegationType");
                        if (delStr != null && delStr.length() != 0) {
                            this.rauditx.addRelocateSection(131, delStr);
                        }
                        if ((delStr = (String)properties.get("RoleName")) != null && delStr.length() != 0) {
                            this.rauditx.addRelocateSection(132, delStr);
                        }
                        if ((delStr = (String)properties.get("IdentityName")) != null && delStr.length() != 0) {
                            this.rauditx.addRelocateSection(133, delStr);
                        }
                    }
                    if ((auditEventType == 1 || auditEventType == 2) && (authT = (String)properties.get("AuthnType")) != null && authT.length() != 0) {
                        this.rauditx.addRelocateSection(135, authT);
                    }
                    if (auditEventType == 1 || auditEventType == 2 || auditEventType == 3 || auditEventType == 4) {
                        String providerStr = (String)properties.get("Provider");
                        if (providerStr != null && providerStr.length() != 0) {
                            this.rauditx.addRelocateSection(137, providerStr);
                        }
                        if ((providerStr = (String)properties.get("ProviderStatus")) != null && providerStr.length() != 0) {
                            this.rauditx.addRelocateSection(138, providerStr);
                        }
                    }
                    if (auditEventType == 3) {
                        String mapStr = (String)properties.get("MappedSecurityDomain");
                        if (mapStr != null && mapStr.length() != 0) {
                            this.rauditx.addRelocateSection(140, mapStr);
                        }
                        if ((mapStr = (String)properties.get("MappedRealm")) != null && mapStr.length() != 0) {
                            this.rauditx.addRelocateSection(141, mapStr);
                        }
                        if ((mapStr = (String)properties.get("MappedUserName")) != null && mapStr.length() != 0) {
                            this.rauditx.addRelocateSection(142, mapStr);
                        }
                    }
                    if (auditEventType == 2 && (termR = (String)properties.get("TerminateReason")) != null && termR.length() != 0) {
                        this.rauditx.addRelocateSection(144, termR);
                    }
                    if (auditEventType == 4 || auditEventType == 5) {
                        String policyStr = (String)properties.get("PolicyName");
                        if (policyStr != null && policyStr.length() != 0) {
                            this.rauditx.addRelocateSection(146, policyStr);
                        }
                        if ((policyStr = (String)properties.get("PolicyType")) != null && policyStr.length() != 0) {
                            this.rauditx.addRelocateSection(147, policyStr);
                        }
                    }
                    if (auditEventType == 16 || auditEventType == 12 || auditEventType == 11 || auditEventType == 15) {
                        Date d;
                        String keyStr = (String)properties.get("KeyLabel");
                        if (keyStr != null && keyStr.length() != 0) {
                            this.rauditx.addRelocateSection(149, keyStr);
                        }
                        if ((keyStr = (String)properties.get("KeyLocation")) != null && keyStr.length() != 0) {
                            this.rauditx.addRelocateSection(150, keyStr);
                        }
                        if ((d = (Date)properties.get("CertLifetime")) != null) {
                            this.rauditx.addRelocateSection(151, d.toString());
                        }
                    }
                    if (auditEventType == 13 || auditEventType == 8 || auditEventType == 12 || auditEventType == 5 || auditEventType == 9 || auditEventType == 6 || auditEventType == 10) {
                        String mgmtStr = (String)properties.get("MgmtType");
                        if (mgmtStr != null && mgmtStr.length() != 0) {
                            this.rauditx.addRelocateSection(153, mgmtStr);
                        }
                        if ((mgmtStr = (String)properties.get("MgmtCommand")) != null && mgmtStr.length() != 0) {
                            this.rauditx.addRelocateSection(154, mgmtStr);
                        }
                        if (this.verbose) {
                            TargetAttributes[] ta = (TargetAttributes[])properties.get("TargetInfoAttributes");
                            if (ta != null && ta.length != 0) {
                                st = "";
                                for (i = 0; i < ta.length; ++i) {
                                    st = st.concat("MgmtAttrName = " + ta[i].getName() + " , ");
                                    st = st.concat("MgmtAttrUid = " + ta[i].getUniqueId() + " , ");
                                }
                            }
                            if (st.endsWith(" , ")) {
                                st = st.substring(0, st.length() - 3);
                            }
                            this.rauditx.addRelocateSection(155, st);
                        }
                    }
                    if (auditEventType == 14) {
                        String urlStr = (String)properties.get("Url");
                        if (urlStr != null & urlStr.length() != 0) {
                            this.rauditx.addRelocateSection(157, urlStr);
                        }
                        if (this.verbose) {
                            int i7;
                            Attributes[] httpRequestHeaders = (Attributes[])properties.get("HttpRequestHeaders");
                            Attributes[] httpResponseHeaders = (Attributes[])properties.get("HttpResponseHeaders");
                            st = "";
                            boolean foundInfo = false;
                            if (httpRequestHeaders != null && httpRequestHeaders.length != 0) {
                                if (!foundInfo) {
                                    foundInfo = true;
                                }
                                st = st.concat("HttpRequestHeaders: ");
                                for (i7 = 0; i7 < httpRequestHeaders.length; ++i7) {
                                    st = st.concat("ReqHdrName = " + httpRequestHeaders[i7].getName() + " | ");
                                    st = st.concat("ReqHdrVal = " + httpRequestHeaders[i7].getValue() + " | ");
                                    st = st.concat("ReqHdrSrc = " + httpRequestHeaders[i7].getSource() + " | ");
                                }
                                if (st.indexOf("|") != -1) {
                                    st = st.substring(0, st.length() - 2);
                                }
                                if (foundInfo) {
                                    this.rauditx.addRelocateSection(158, st);
                                    foundInfo = false;
                                }
                            }
                            if (httpResponseHeaders != null && httpResponseHeaders.length != 0) {
                                if (!foundInfo) {
                                    foundInfo = true;
                                }
                                st = st.concat("HttpResponseHeaders: ");
                                for (i7 = 0; i7 < httpResponseHeaders.length; ++i7) {
                                    st = st.concat("ResHdrName = " + httpResponseHeaders[i7].getName() + " | ");
                                    st = st.concat("ResHdrVal = " + httpResponseHeaders[i7].getValue() + " | ");
                                    st = st.concat("ResHdrSrc = " + httpResponseHeaders[i7].getSource() + " | ");
                                }
                                if (st.indexOf("|") != -1) {
                                    st = st.substring(0, st.length() - 2);
                                }
                                if (foundInfo) {
                                    this.rauditx.addRelocateSection(159, st);
                                }
                            }
                        }
                    }
                    String[] customKeys = sae.getCustomKeys();
                    String[] customValues = sae.getCustomValues();
                    if (customKeys != null && customKeys.length != 0) {
                        st = "";
                        if (customKeys[0] != null) {
                            for (i = 0; i < customKeys.length; ++i) {
                                st = st.concat("customKey: " + customKeys[i]);
                                st = st.concat(" customVal: " + customValues[i] + ", ");
                            }
                            if (st.endsWith(", ")) {
                                st = st.substring(0, st.length() - 2);
                            }
                            this.rauditx.addRelocateSection(161, st);
                        }
                    }
                    Integer seqNum = (Integer)properties.get("Seq");
                    this.rauditx.addRelocateSection(162, seqNum.toString());
                    String outcomeReason = (String)properties.get("OutcomeFailureReason");
                    this.rauditx.addRelocateSection(163, outcomeReason);
                    Long outcomeReasonCode = (Long)properties.get("OutcomeReason");
                    this.rauditx.addRelocateSection(164, outcomeReasonCode.toString());
                    this.rauditx.setComponent("WASAUDITCOMP");
                    Tr.debug(tc, "beforeRAUDITXISSUE");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "length of eventBytes: " + eventBytes.length);
                    }
                    this.rauditx.issue();
                    Tr.debug(tc, "afterRAUDITXISSUE");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Rauditx_issued");
                    }
                }
                catch (UnsupportedEncodingException ue) {
                    Tr.error(tc, "security.audit.unsupported.encode.error", new Object[]{ue});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unsupported encoding exception converting event. ", ue.getMessage());
                    }
                    throw new ProviderFailureException(ue.getMessage());
                }
                catch (GenericEventValidationException gve) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error validating audit record. ", gve.getMessage());
                    }
                    throw new ProviderFailureException(gve.getMessage());
                }
                catch (GenericEventConfigurationException gce) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Configuration error occured while creating audit record. ", gce.getMessage());
                    }
                    throw new ProviderFailureException(gce.getMessage());
                }
                catch (GenericEventCompletionException gcce) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error creating audit record. ", gcce.getMessage());
                    }
                    throw new ProviderFailureException(gcce.getMessage());
                }
                catch (Exception ee) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception writing to Rauditx: " + ee.getMessage());
                    }
                    throw new ProviderFailureException(ee.getMessage());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "sendEvent ");
            }
            return sae.getGlobalInstanceId((HashMap)auditEvent).toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "sendEvent ");
        }
        return null;
    }

    public String sendEvent(Object auditEvent, int synchronizationMode, int transactionMode) throws ProviderFailureException {
        return null;
    }

    public Object getEvent(String eventID) throws ProviderFailureException {
        return null;
    }

    public boolean isActiveProviderSpec(String auditEventType, String auditOutcome) {
        ConcurrentHashMap o;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
        if ((o = (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType)) != null && o.get(auditOutcome) != null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isActiveProviderSpec(true)");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActiveProviderSpec(false)");
        }
        return false;
    }

    public void setActiveProviderSpec(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActiveProviderSpec: " + auditEventType + " : " + auditOutcome);
        }
        ContextHandler contextHandler = null;
        this.auditOutcomeSettings = !this.auditFilterSettings.containsKey(auditEventType) ? new ConcurrentHashMap() : (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType);
        this.auditOutcomeSettings.putIfAbsent(auditOutcome, "ACTIVE");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditOutcomeSettings: " + this.auditOutcomeSettings.toString());
        }
        if (this.auditFilterSettings.containsKey(auditEventType)) {
            this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        } else {
            this.auditFilterSettings.put(auditEventType, this.auditOutcomeSettings);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditFilters: " + this.auditFilterSettings.toString());
        }
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterSet", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.BinaryEmitterImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                auditService.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
    }

    public void resetActiveProviderSpec(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
        ContextHandler contextHandler = null;
        this.auditOutcomeSettings.remove(auditOutcome);
        this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterRemove", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.BinaryEmitterImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                auditService.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
    }

    public String getActiveProviderSpec() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActiveProviderSpec");
        }
        String s = new String("{");
        s = s.concat(this.auditFilterSettings.toString()).concat("}");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActiveProviderSpec");
        }
        return s;
    }

    public String sendEvent(GenericEvent event2) throws GenericEventException {
        return null;
    }

    public String[] sendEvents(GenericEvent[] events) throws GenericEventException {
        return null;
    }

    public void close() throws GenericEventException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }
}

