/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DataHelper {
    private static final TraceComponent tc = Tr.register(DataHelper.class, "Security", "com.ibm.ejs.resources.security");
    private static final String customPrefix = new String("CustomAuditData_");
    private static final AuditConfig audit = SecurityObjectLocator.getAuditConfig();
    private static final String auditReportGranularity = audit.getString("com.ibm.audit.report.granularity");

    public static String convertRegistryInfoType(String userRegistry) {
        if (userRegistry == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "userRegistry: " + userRegistry);
        }
        if (userRegistry.equalsIgnoreCase("LDAP")) {
            return "LDAP";
        }
        if (userRegistry.equalsIgnoreCase("WIMUserRegistry")) {
            return "WIMUserRegistry";
        }
        if (userRegistry.equalsIgnoreCase("CUSTOM")) {
            return "CUSTOM";
        }
        if (userRegistry.equalsIgnoreCase("LOCALOS")) {
            return "LOCALOS";
        }
        return null;
    }

    public static HashMap buildCustomData(HashMap customMap) {
        HashMap data = new HashMap();
        Set thisSet = customMap.entrySet();
        for (Map.Entry thisEntry : thisSet) {
            Object thisKey = thisEntry.getKey();
            Object thisValue = thisEntry.getValue();
            String newKey = thisKey.toString();
            data.put(newKey, thisValue);
        }
        return data;
    }

    public static HashMap buildSessionData(String sessionId, String remoteAddr, String remoteHost, String remotePort) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (auditReportGranularity.equals("low")) {
            data.put("SessionId", sessionId);
            data.put("RemoteAddr", remoteAddr);
            data.put("RemotePort", remotePort);
            data.put("RemoteHost", remoteHost);
        } else if (auditReportGranularity.equals("medium")) {
            data.put("SessionId", sessionId);
            data.put("RemoteHost", remoteHost);
        } else {
            data.put("SessionId", sessionId);
        }
        return data;
    }

    public static HashMap buildPropagationData(String firstCaller, String[] callerList) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        WSSecurityPropagationHelper propHelper = WSSecurityPropagationHelper.getInstance();
        if (propHelper.isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled()) {
            data.put("FirstCaller", firstCaller);
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr != null && ctxMgr.getAuditService() != null && ctxMgr.getAuditService().isVerbose() && !auditReportGranularity.equals("high")) {
                data.put("CallerList", callerList);
            }
        }
        return data;
    }

    public static HashMap buildProcessData(String domain, String realm) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (!auditReportGranularity.equals("high")) {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            if (ctxMgr != null && ctxMgr.getAuditService() != null && ctxMgr.getAuditService().isVerbose()) {
                data.put("Domain", domain);
            }
            data.put("Realm", realm);
        }
        return data;
    }

    public static HashMap buildRegistryData(String type) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("RegistryType", type);
        return data;
    }

    public static HashMap buildAuthnData(String authnType) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (!auditReportGranularity.equals("high")) {
            data.put("AuthnType", authnType);
        }
        return data;
    }

    public static HashMap buildProviderData(String providerName, String providerStatus) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (!auditReportGranularity.equals("high")) {
            if (auditReportGranularity.equals("low")) {
                data.put("ProviderStatus", providerStatus);
            }
            data.put("Provider", providerName);
        }
        return data;
    }

    public static HashMap buildDelegationData(String delegationType, String roleName, String identityName) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("IdentityName", identityName);
        if (!auditReportGranularity.equals("high")) {
            data.put("DelegationType", delegationType);
        }
        if (auditReportGranularity.equals("low")) {
            data.put("RoleName", roleName);
        }
        return data;
    }

    public static HashMap buildAuthnMappingData(String mappedSecurityDomain, String mappedRealm, String mappedUserName) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("MappedUserName", mappedUserName);
        if (auditReportGranularity.equals("low")) {
            data.put("MappedSecurityDomain", mappedSecurityDomain);
        }
        if (!auditReportGranularity.equals("high")) {
            data.put("MappedRealm", mappedRealm);
        }
        return data;
    }

    public static HashMap buildAuthnTermData(String terminateReason) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("TerminateReason", terminateReason);
        return data;
    }

    public static HashMap buildAccessData(String progName, String action, String registryUserName, String appUserName, String accessDecision, String nameInApp, String resourceType, Long resourceUniqueId, String[] permissionsChecked, String[] permissionsGranted, String[] rolesChecked, String[] rolesGranted) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("ProgName", progName);
        data.put("Action", action);
        data.put("AppUserName", appUserName);
        data.put("NameInApp", nameInApp);
        if (!auditReportGranularity.equals("high")) {
            data.put("RegistryUserName", registryUserName);
            data.put("AccessDecision", accessDecision);
        }
        if (auditReportGranularity.equals("low")) {
            data.put("ResourceType", resourceType);
            data.put("ResourceUniqueId", resourceUniqueId);
            data.put("PermissionsChecked", permissionsChecked);
            data.put("PermissionsGranted", permissionsGranted);
            data.put("RolesChecked", rolesChecked);
            data.put("RolesGranted", rolesGranted);
        }
        return data;
    }

    public static HashMap buildEventData(String lastEventTrailId, String[] eventTrailId, Date creationTime, long globalInstanceId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("CreationTime", creationTime);
        if (!auditReportGranularity.equals("high")) {
            data.put("GlobalInstanceId", globalInstanceId);
        }
        if (auditReportGranularity.equals("low")) {
            data.put("LastEventTrailId", lastEventTrailId);
            data.put("EventTrailId", eventTrailId);
        }
        return data;
    }

    public static HashMap buildPolicyData(String policyName, String policyType) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (!auditReportGranularity.equals("high")) {
            data.put("PolicyName", policyName);
            if (auditReportGranularity.equals("low")) {
                data.put("PolicyType", policyType);
            }
        }
        return data;
    }

    public static HashMap buildKeyData(String keyLabel, String keyLocation, Date certLifetime) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("KeyLabel", keyLabel);
        if (!auditReportGranularity.equals("high")) {
            data.put("KeyLocation", keyLocation);
            if (auditReportGranularity.equals("low")) {
                data.put("CertLifetime", certLifetime);
            }
        }
        return data;
    }

    public static HashMap buildMgmtData(String mgmtType, String mgmtCommand, TargetAttributes[] targetInfoAttributes) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("MgmtType", mgmtType);
        if (!auditReportGranularity.equals("high")) {
            ContextManager ctxMgr;
            data.put("MgmtCommand", mgmtCommand);
            if (auditReportGranularity.equals("low") && (ctxMgr = ContextManagerFactory.getInstance()) != null && ctxMgr.getAuditService() != null && ctxMgr.getAuditService().isVerbose()) {
                data.put("TargetInfoAttributes", targetInfoAttributes);
            }
        }
        return data;
    }

    public static HashMap buildResponseData(String url, Attributes[] httpRequestHeaders, Attributes[] httpResponseHeaders) {
        ContextManager ctxMgr;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("Url", url);
        if (!auditReportGranularity.equals("high") && (ctxMgr = ContextManagerFactory.getInstance()) != null && ctxMgr.getAuditService() != null && ctxMgr.getAuditService().isVerbose()) {
            data.put("HttpRequestHeaders", httpRequestHeaders);
            data.put("HttpResponseHeaders", httpResponseHeaders);
        }
        return data;
    }

    public static ConcurrentHashMap buildOutcomeData(String result, Integer majorStatus, Integer minorStatus, String reason, long outcomeReason) {
        ConcurrentHashMap<String, Object> outcomeHashMap = new ConcurrentHashMap<String, Object>();
        outcomeHashMap.clear();
        outcomeHashMap.put("OutcomeResult", result);
        outcomeHashMap.put("OutcomeMajorStatus", majorStatus);
        outcomeHashMap.put("OutcomeMinorStatus", minorStatus);
        outcomeHashMap.put("OutcomeFailureReason", reason);
        outcomeHashMap.put("OutcomeReason", outcomeReason);
        return outcomeHashMap;
    }
}

