/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.audit.AuditEncryptionImpl;
import com.ibm.ws.security.audit.AuditSigningImpl;
import com.ibm.ws.security.audit.tools.AuditDataPoints;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AuditReader {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AuditReader.class, "AUDIT", "com.ibm.ws.security.audit.tools");
    private static Vector report = new Vector();
    private static int index = 0;
    private static String currentDate = null;
    private static String currentTime = null;
    private static boolean odd = false;
    private static String hostname = "unknown";
    private static boolean printBold = false;
    private static String htmlString = new String();
    private static Session _session = null;
    private static final String ANONYMOUS = "Script";
    private static final String begin = "<begin>";
    private static final String end = "<end>";
    private static final String newline = "\n";
    private static final String signatureOpenTag = "<signature>";
    private static final String signatureCloseTag = "</signature>";
    private static String signerCertAlias = new String();
    private static String signerKeyStoreLocation = new String();
    private static String signerKeyStoreScope = new String();
    private static String signerKeyStoreName = new String();
    private static String encryptedSignerSharedKey = new String();
    private static String encryptionCertAlias = new String();
    private static String encryptionKeyStoreLocation = new String();
    private static String encryptedSharedKey = new String();
    private static AuditDataPoints adp = new AuditDataPoints();
    private static ConcurrentHashMap hm = null;

    public static void getReport(String wasHome, Locale locale, String fileName, String reportMode, Vector eventFilter, Vector outcomeFilter, String sequenceFilter, String timeStampFilter, Vector dataPointsList, String outputLocation, String keyStorePassword) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport: fileName: " + fileName + " reportMode: " + reportMode + " eventsList: " + eventFilter.toString() + " outcomeFilter: " + outcomeFilter.toString() + " sequenceFilter: " + sequenceFilter + " dataPointsList: " + dataPointsList.toString() + " outputLocation: " + outputLocation);
        }
        boolean basicReport = true;
        if (reportMode.equals("complete") || reportMode.equals("custom")) {
            basicReport = false;
        }
        report.clear();
        index = 0;
        htmlString = new String();
        hm = adp.getDataPointsMap();
        AuditReader.processLog(fileName, reportMode, eventFilter, outcomeFilter, sequenceFilter, timeStampFilter, dataPointsList, outputLocation, keyStorePassword);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport");
        }
    }

    private static String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    private static String getLabel(String key) {
        String message = " ";
        try {
            message = resBundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + " in resource bundle" + resBundle.toString());
            }
        }
        catch (Exception e) {
            message = new String(key);
            return message;
        }
        if (message.startsWith("SECJ")) {
            message = message.substring(11, message.length());
        }
        return message;
    }

    public static void processLog(String filename, String reportMode, Vector eventsList, Vector outcomesList, String sequenceFilter, String timeStampFilter, Vector dataPointsList, String outputLocation, String keyStorePassword) throws Exception {
        try {
            String msg;
            byte[] yy;
            AuditSigningImpl as;
            Key publicKey;
            AttributeList keyStore;
            String signerKeyStorePassword;
            String signerKeyStoreType;
            String signerKeyStoreProvider;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processLog: filename: " + filename + " reportMode: " + reportMode + " eventsList: " + eventsList.toString() + " outcomesList: " + outcomesList + " sequenceFilter: " + sequenceFilter + " dataPointsList: " + dataPointsList + " outputLocation: " + outputLocation);
            }
            int beginSeq = -1;
            int endSeq = -1;
            if (sequenceFilter != null) {
                if (!sequenceFilter.contains(":")) {
                    Integer i = new Integer(sequenceFilter);
                    endSeq = beginSeq = i.intValue();
                } else {
                    String[] st = sequenceFilter.split(":");
                    if (st.length > 2) {
                        String msg2 = AuditReader.getMsg(resBundle, "security.admintask.InvalidSequenceSet", null);
                        throw new Exception(msg2);
                    }
                    Integer i = new Integer(st[0]);
                    beginSeq = i;
                    i = new Integer(st[1]);
                    endSeq = i;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "beginSeq: " + beginSeq + " endSeq: " + endSeq);
                }
            }
            Date beginTimeStamp = null;
            Date endTimeStamp = null;
            SimpleDateFormat df = new SimpleDateFormat("MMddhhmmyyyy");
            if (timeStampFilter != null) {
                try {
                    if (!timeStampFilter.contains(":")) {
                        endTimeStamp = beginTimeStamp = df.parse(timeStampFilter, new ParsePosition(0));
                    } else {
                        String[] st = timeStampFilter.split(":");
                        if (st.length > 2) {
                            String msg3 = AuditReader.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
                            throw new Exception(msg3);
                        }
                        beginTimeStamp = df.parse(st[0]);
                        endTimeStamp = df.parse(st[1]);
                    }
                }
                catch (NullPointerException pe) {
                    String msg4 = AuditReader.getMsg(resBundle, "security.admintask.InvalidTimeStampRange", null);
                    throw new Exception(msg4);
                }
                catch (ParseException pee) {
                    String msg5 = AuditReader.getMsg(resBundle, "security.admintask.InvalidTimeStamp", null);
                    throw new Exception(msg5);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "beginTimeStamp: " + beginTimeStamp + " endTimeStamp: " + endTimeStamp);
            }
            FileReader file_reader = null;
            file_reader = new FileReader(filename);
            BufferedReader buffered_reader = new BufferedReader(file_reader);
            String s = null;
            while ((s = buffered_reader.readLine()) != null && !s.contains("End Display Current Environment")) {
            }
            Hashtable<String, String> hashTable = new Hashtable<String, String>(3);
            hashTable.put("record", AuditReader.getLabel("security.audit.report.Record.name"));
            hashTable.put("event", AuditReader.getLabel("security.audit.report.EventType.name"));
            hashTable.put("outcome", AuditReader.getLabel("security.audit.report.Outcome.name"));
            report.add(index++, hashTable);
            boolean encryptedLog = false;
            boolean signedLog = false;
            while ((s = buffered_reader.readLine()) != null) {
                if (s.contains("<Encryption information>")) {
                    encryptedLog = true;
                }
                if (s.contains("<Signing information>")) {
                    signedLog = true;
                }
                if (!encryptedLog || !signedLog) continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "signedLog: " + signedLog + " encryptedLog: " + encryptedLog);
            }
            if (signedLog || encryptedLog) {
                AuditReader.getEncryptionAndSigningData(filename, signedLog, encryptedLog);
            }
            if (signedLog && !encryptedLog) {
                signerKeyStoreProvider = null;
                signerKeyStoreType = null;
                signerKeyStorePassword = null;
                try {
                    keyStore = AuditReader.getSignerKeyStore(signerKeyStoreLocation, signerKeyStoreScope);
                    signerKeyStoreType = (String)ConfigServiceHelper.getAttributeValue(keyStore, "type");
                    signerKeyStoreProvider = (String)ConfigServiceHelper.getAttributeValue(keyStore, "provider");
                    signerKeyStoreName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
                    signerKeyStorePassword = (String)ConfigServiceHelper.getAttributeValue(keyStore, "password");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                publicKey = null;
                publicKey = AuditReader.getPublicKey(signerKeyStoreType, signerKeyStoreProvider, signerKeyStoreLocation, signerKeyStorePassword, signerCertAlias);
                as = null;
                try {
                    as = new AuditSigningImpl(signerKeyStoreName, signerKeyStoreScope, signerCertAlias);
                }
                catch (Exception ase) {
                    throw new Exception(ase);
                }
                yy = Base64Coder.base64Decode(encryptedSignerSharedKey.getBytes("UTF8"));
                byte[] sk = encryptedSignerSharedKey.getBytes();
                String x = new String(sk);
                byte[] decryptedSharedKey = as.decryptSharedKey(yy, publicKey);
                String z = new String(decryptedSharedKey);
                FileInputStream fis = new FileInputStream(filename);
                file_reader = new FileReader(filename);
                AuditReader.processRecord(file_reader, signedLog, encryptedLog, beginSeq, endSeq, beginTimeStamp, endTimeStamp, eventsList, outcomesList, null, null, dataPointsList, reportMode);
                file_reader.close();
            }
            if (encryptedLog && !signedLog) {
                if (keyStorePassword == null || keyStorePassword.length() == 0) {
                    msg = AuditReader.getMsg(resBundle, "security.admintask.NoKeyStorePasswordValue", null);
                    throw new Exception(msg);
                }
                ConfigService cs = ConfigServiceFactory.getConfigService();
                Session session = AuditReader.getConfigSession();
                String encryptionKeyStoreProvider = null;
                String encryptionKeyStoreType = null;
                String encryptionKeyStoreName = null;
                try {
                    AttributeList keyStore2 = AuditReader.getEncryptionKeyStore(encryptionKeyStoreLocation);
                    encryptionKeyStoreType = (String)ConfigServiceHelper.getAttributeValue(keyStore2, "type");
                    encryptionKeyStoreProvider = (String)ConfigServiceHelper.getAttributeValue(keyStore2, "provider");
                    encryptionKeyStoreName = (String)ConfigServiceHelper.getAttributeValue(keyStore2, "name");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                Key publicKey2 = null;
                publicKey2 = AuditReader.getPublicKey(encryptionKeyStoreType, encryptionKeyStoreProvider, encryptionKeyStoreLocation, keyStorePassword, encryptionCertAlias);
                AuditEncryptionImpl ae = null;
                try {
                    ae = new AuditEncryptionImpl(encryptionKeyStoreName, encryptionKeyStoreLocation, encryptionKeyStoreType, encryptionKeyStoreProvider, keyStorePassword, encryptionCertAlias);
                }
                catch (Exception aee) {
                    throw new Exception(aee);
                }
                byte[] yy2 = Base64Coder.base64Decode(encryptedSharedKey.getBytes("UTF8"));
                byte[] sk = encryptedSharedKey.getBytes();
                String x = new String(sk);
                byte[] decryptedSharedKey = ae.decryptSharedKey(yy2, publicKey2);
                String z = new String(decryptedSharedKey);
                FileInputStream fis = new FileInputStream(filename);
                file_reader = new FileReader(filename);
                AuditReader.processRecord(file_reader, signedLog, encryptedLog, beginSeq, endSeq, beginTimeStamp, endTimeStamp, eventsList, outcomesList, decryptedSharedKey, ae, dataPointsList, reportMode);
                file_reader.close();
            }
            if (encryptedLog && signedLog) {
                if (keyStorePassword == null || keyStorePassword.length() == 0) {
                    msg = AuditReader.getMsg(resBundle, "security.admintask.NoKeyStorePasswordValue", null);
                    throw new Exception(msg);
                }
                signerKeyStoreProvider = null;
                signerKeyStoreType = null;
                signerKeyStorePassword = null;
                try {
                    keyStore = AuditReader.getSignerKeyStore(signerKeyStoreLocation, signerKeyStoreScope);
                    signerKeyStoreType = (String)ConfigServiceHelper.getAttributeValue(keyStore, "type");
                    signerKeyStoreProvider = (String)ConfigServiceHelper.getAttributeValue(keyStore, "provider");
                    signerKeyStoreName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
                    signerKeyStorePassword = (String)ConfigServiceHelper.getAttributeValue(keyStore, "password");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                publicKey = null;
                publicKey = AuditReader.getPublicKey(signerKeyStoreType, signerKeyStoreProvider, signerKeyStoreLocation, signerKeyStorePassword, signerCertAlias);
                as = null;
                try {
                    as = new AuditSigningImpl(signerKeyStoreName, signerKeyStoreScope, signerCertAlias);
                }
                catch (Exception ase) {
                    throw new Exception(ase);
                }
                yy = Base64Coder.base64Decode(encryptedSignerSharedKey.getBytes("UTF8"));
                byte[] decryptedSignedSharedKey = as.decryptSharedKey(yy, publicKey);
                String encryptionKeyStoreProvider = null;
                String encryptionKeyStoreType = null;
                String encryptionKeyStoreName = null;
                try {
                    AttributeList keyStore3 = AuditReader.getEncryptionKeyStore(encryptionKeyStoreLocation);
                    encryptionKeyStoreType = (String)ConfigServiceHelper.getAttributeValue(keyStore3, "type");
                    encryptionKeyStoreProvider = (String)ConfigServiceHelper.getAttributeValue(keyStore3, "provider");
                    encryptionKeyStoreName = (String)ConfigServiceHelper.getAttributeValue(keyStore3, "name");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                publicKey = null;
                publicKey = AuditReader.getPublicKey(encryptionKeyStoreType, encryptionKeyStoreProvider, encryptionKeyStoreLocation, keyStorePassword, encryptionCertAlias);
                AuditEncryptionImpl ae = null;
                try {
                    ae = new AuditEncryptionImpl(encryptionKeyStoreName, encryptionKeyStoreLocation, encryptionKeyStoreType, encryptionKeyStoreProvider, keyStorePassword, encryptionCertAlias);
                }
                catch (Exception aee) {
                    throw new Exception(aee);
                }
                byte[] yyy = Base64Coder.base64Decode(encryptedSharedKey.getBytes("UTF8"));
                byte[] decryptedSharedKey = ae.decryptSharedKey(yyy, publicKey);
                FileInputStream fis = new FileInputStream(filename);
                file_reader = new FileReader(filename);
                AuditReader.processRecord(file_reader, signedLog, encryptedLog, beginSeq, endSeq, beginTimeStamp, endTimeStamp, eventsList, outcomesList, decryptedSharedKey, ae, dataPointsList, reportMode);
                file_reader.close();
            }
            if (!encryptedLog && !signedLog) {
                file_reader = new FileReader(filename);
                buffered_reader = new BufferedReader(file_reader);
                while ((s = buffered_reader.readLine()) != null && !s.contains("End Display Current Environment")) {
                }
                while ((s = buffered_reader.readLine()) != null) {
                    AuditReader.parseRecord(s, beginSeq, endSeq, beginTimeStamp, endTimeStamp, eventsList, outcomesList, dataPointsList, reportMode);
                }
            }
            file_reader.close();
        }
        catch (UnknownHostException uhe) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.UnknownHost", null);
            msg = msg.concat(" ").concat(uhe.getMessage());
            throw new Exception(msg);
        }
        catch (KeyStoreException ke) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.KeyStoreException", null);
            msg = msg.concat(" ").concat(ke.getMessage());
            throw new Exception(msg);
        }
        catch (NoSuchProviderException nspe) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.NoSuchProviderException", null);
            msg = msg.concat(" ").concat(nspe.getMessage());
            throw new Exception(msg);
        }
        catch (MalformedURLException mue) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.MalformedURLException", null);
            msg = msg.concat(" ").concat(mue.getMessage());
            throw new Exception(msg);
        }
        catch (CertificateException ce) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.CertificateException", null);
            msg = msg.concat(" ").concat(ce.getMessage());
            throw new Exception(msg);
        }
        catch (NoSuchAlgorithmException nsae) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.NoSuchAlgorithmException", null);
            msg = msg.concat(" ").concat(nsae.getMessage());
            throw new Exception(msg);
        }
        catch (FileNotFoundException fnf) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.FileNotFound", new Object[]{filename});
            msg = msg.concat(" ").concat(fnf.getMessage());
            throw new Exception(msg);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        try {
            AuditReader.processData(report, reportMode, outputLocation, dataPointsList);
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (FileNotFoundException fnf) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.FileNotFound", new Object[]{outputLocation});
            msg = msg.concat(" ").concat(fnf.getMessage());
            throw new IOException(msg);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static void processRecord(FileReader file_reader, boolean signedLog, boolean encryptedLog, int beginSeq, int endSeq, Date beginTimeStamp, Date endTimeStamp, Vector eventsList, Vector outcomesList, byte[] decryptedSharedKey, AuditEncryptionImpl ae, Vector dataPointsList, String reportMode) throws Exception {
        String auditRecord = new String();
        String capturedRecord = new String();
        boolean startOfRecord = false;
        int num_captured_records = 0;
        String rec = null;
        try {
            int inByte;
            do {
                if ((inByte = file_reader.read()) == -1) continue;
                auditRecord = auditRecord.concat(Character.toString((char)inByte));
                if (startOfRecord) {
                    capturedRecord = capturedRecord.concat(Character.toString((char)inByte));
                }
                if (!startOfRecord && auditRecord.contains(begin)) {
                    startOfRecord = true;
                    capturedRecord = "";
                }
                if (!auditRecord.contains("<end")) continue;
                if (!startOfRecord) {
                    Tr.audit(tc, "WARNING: reached an end before a begin: " + auditRecord);
                    auditRecord = "";
                    capturedRecord = "";
                    continue;
                }
                startOfRecord = false;
                int lenRec = capturedRecord.length();
                if (capturedRecord.contains(begin)) {
                    Tr.audit(tc, "WARNING: reached a begin before the end: " + auditRecord);
                    auditRecord = "";
                    capturedRecord = "";
                    continue;
                }
                capturedRecord = capturedRecord.substring(0, lenRec - 4);
                ++num_captured_records;
                auditRecord = "";
                byte[] decodedRecord = Base64Coder.base64Decode(capturedRecord.getBytes("UTF8"));
                if (signedLog && !encryptedLog) {
                    rec = new String(decodedRecord);
                    int index3 = rec.indexOf(signatureOpenTag);
                    rec = rec.substring(0, index3 - 1);
                } else if (!signedLog && encryptedLog) {
                    SecretKeySpec recreatedSharedKey = new SecretKeySpec(decryptedSharedKey, "DESede");
                    byte[] decryptedRecord = ae.decrypt(decodedRecord, recreatedSharedKey);
                    rec = new String(decryptedRecord);
                } else if (signedLog && encryptedLog) {
                    String parsedSigRecord = new String();
                    byte[] strippedRecord = null;
                    for (int i = 0; i < decodedRecord.length; ++i) {
                        if (!(parsedSigRecord = parsedSigRecord.concat(Character.toString((char)decodedRecord[i]))).contains(signatureOpenTag)) continue;
                        strippedRecord = new byte[parsedSigRecord.length() - signatureOpenTag.length()];
                        System.arraycopy(decodedRecord, 0, strippedRecord, 0, parsedSigRecord.length() - signatureOpenTag.length());
                        break;
                    }
                    SecretKeySpec recreatedSharedKey = new SecretKeySpec(decryptedSharedKey, "DESede");
                    if (tc.isDebugEnabled()) {
                        byte[] rkey = recreatedSharedKey.getEncoded();
                        Tr.debug(tc, "decrypting audit record with key: " + new String(rkey));
                    }
                    byte[] decryptedRecord = ae.decrypt(strippedRecord, recreatedSharedKey);
                    rec = new String(decryptedRecord);
                }
                AuditReader.parseRecord(rec, beginSeq, endSeq, beginTimeStamp, endTimeStamp, eventsList, outcomesList, dataPointsList, reportMode);
            } while (inByte != -1);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static Key getPublicKey(String keyStoreType, String keyStoreProvider, String keyStoreLocation, String keyStorePassword, String certAlias) throws KeyStoreException, NoSuchProviderException, MalformedURLException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = null;
        PublicKey publicKey = null;
        InputStream is = null;
        X509Certificate c = null;
        try {
            ks = KeyStore.getInstance(keyStoreType, keyStoreProvider);
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ke.getMessage());
            }
            throw ke;
        }
        catch (NoSuchProviderException ne) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such provider.", ne.getMessage());
            }
            throw ne;
        }
        try {
            is = AuditReader.openKeyStore(keyStoreLocation);
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: malformed URL", me.getMessage());
            }
            throw me;
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw ioe;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully opened the keystore at " + keyStoreLocation);
        }
        try {
            ks.load(is, keyStorePassword.toCharArray());
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CertificateException while loading keystore.", ce.getMessage());
            }
            throw ce;
        }
        catch (IOException ioe) {
            String msg = AuditReader.getMsg(resBundle, "security.admintask.ErrorLoadingKeystore", null);
            msg = msg.concat(" ").concat(ioe.getMessage());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException while loading keystore.", ioe.getMessage());
            }
            throw new IOException(msg);
        }
        catch (NoSuchAlgorithmException ae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NoSuchAlgorithmException while loading keystore: no such algorithm", ae.getMessage());
            }
            throw ae;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully loaded the keystore at " + keyStoreLocation);
        }
        try {
            c = (X509Certificate)ks.getCertificate(certAlias);
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting certficate from keystore.", ke.getMessage());
            }
            throw ke;
        }
        publicKey = c.getPublicKey();
        return publicKey;
    }

    public static void getEncryptionAndSigningData(String filename, boolean signedLog, boolean encryptedLog) throws IOException {
        boolean foundSignerCertAlias = false;
        boolean foundSignerKeyStore = false;
        boolean foundSignerKeyStoreScope = false;
        boolean foundSignerKeyStoreName = false;
        boolean foundEncryptedSignerSharedKey = false;
        boolean foundEncryptionCertAlias = false;
        boolean foundEncryptionKeyStore = false;
        boolean foundEncryptedSharedKey = false;
        String s = null;
        FileReader file_reader = new FileReader(filename);
        BufferedReader buffered_reader = new BufferedReader(file_reader);
        while ((s = buffered_reader.readLine()) != null && !s.contains("End Display Current Environment")) {
        }
        while ((s = buffered_reader.readLine()) != null) {
            int index2;
            int index1;
            if (s.contains("signingCertAlias")) {
                foundSignerCertAlias = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</signingCertAlias>");
                signerCertAlias = s.substring(index1 + 1, index2);
            } else if (s.contains("signingKeyStore")) {
                foundSignerKeyStore = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</signingKeyStore>");
                signerKeyStoreLocation = s.substring(index1 + 1, index2);
            } else if (s.contains("scope")) {
                foundSignerKeyStoreScope = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</scope>");
                signerKeyStoreScope = s.substring(index1 + 1, index2);
            } else if (s.contains("signingSharedKey")) {
                foundEncryptedSignerSharedKey = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</signingSharedKey");
                encryptedSignerSharedKey = s.substring(index1 + 1, index2);
                Tr.debug(tc, "encryptedSignerSharedKey: " + encryptedSignerSharedKey);
            }
            if (s.contains("encryptionCertAlias")) {
                foundEncryptionCertAlias = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</encryptionCertAlias>");
                encryptionCertAlias = s.substring(index1 + 1, index2);
            } else if (s.contains("encryptionKeyStore")) {
                foundEncryptionKeyStore = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</encryptionKeyStore>");
                encryptionKeyStoreLocation = s.substring(index1 + 1, index2);
            } else if (s.contains("encryptedSharedKey")) {
                foundEncryptedSharedKey = true;
                index1 = s.indexOf(">");
                index2 = s.indexOf("</encryptedSharedKey");
                encryptedSharedKey = s.substring(index1 + 1, index2);
            }
            if (signedLog && !encryptedLog) {
                if (!foundSignerCertAlias || !foundSignerKeyStore || !foundSignerKeyStoreScope || !foundEncryptedSignerSharedKey) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "signerKeyStoreLocation: " + signerKeyStoreLocation + " signerKeyStoreScope: " + signerKeyStoreScope + "signerCertAlias: " + signerCertAlias);
                }
            } else if (!signedLog && encryptedLog) {
                if (!foundEncryptionCertAlias || !foundEncryptionKeyStore || !foundEncryptedSharedKey) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "encryptionCertAlias: " + encryptionCertAlias + " encryptionKeyStoreLocation: " + encryptionKeyStoreLocation);
                }
            } else {
                if (!signedLog || !encryptedLog || !foundEncryptionCertAlias || !foundEncryptionKeyStore || !foundEncryptedSharedKey || !foundSignerCertAlias || !foundSignerKeyStore || !foundSignerKeyStoreScope || !foundEncryptedSignerSharedKey) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "encryptionCertAlias: " + encryptionCertAlias + " encryptionKeyStoreLocation: " + encryptionKeyStoreLocation);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " signerKeyStoreLocation: " + signerKeyStoreLocation + " signerKeyStoreScope: " + signerKeyStoreScope + "signerCertAlias: " + signerCertAlias);
                }
            }
            break;
        }
    }

    public static AttributeList getEncryptionKeyStore(String encryptionKeyStoreLocation) throws Exception {
        ObjectName audit = null;
        ObjectName matches = null;
        ObjectName keyStoreObjName = null;
        String encryptionScopeName = null;
        try {
            boolean keyStoreFound;
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = AuditReader.getConfigSession();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Audit");
            audit = cs.queryConfigObjects(session, null, pattern, null)[0];
            matches = cs.resolve(session, "Cell=")[0];
            CommandHelper commandHelper = new CommandHelper();
            encryptionScopeName = commandHelper.defaultCellScope(matches);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default cell scopeName: " + encryptionScopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, "location", encryptionKeyStoreLocation);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryAttrs: " + queryAttrs.toString());
            }
            if (!(keyStoreFound = commandHelper.exists(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, encryptionScopeName))) {
                String msg = encryptionKeyStoreLocation + " object not found.";
                throw new Exception(msg);
            }
            keyStoreObjName = commandHelper.getObjectName(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, encryptionScopeName);
            AttributeList keyStore = cs.getAttributes(session, keyStoreObjName, null, false);
            return keyStore;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static AttributeList getSignerKeyStore(String signerKeyStoreLocation, String signerKeyStoreScope) throws Exception {
        ObjectName audit = null;
        ObjectName security2 = null;
        ObjectName keyStoreObjName = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, "location", signerKeyStoreLocation);
            boolean keyStoreFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, signerKeyStoreScope);
            if (!keyStoreFound) {
                pattern = ConfigServiceHelper.createObjectName(null, "Audit");
                audit = cs.queryConfigObjects(session, null, pattern, null)[0];
                keyStoreFound = commandHelper.exists(cs, session, audit, CommandConstants.KEY_STORES, queryAttrs, signerKeyStoreScope);
                if (!keyStoreFound) {
                    String msg = signerKeyStoreLocation + " object not found.";
                    throw new Exception(msg);
                }
                keyStoreObjName = commandHelper.getObjectName(cs, session, audit, "keyStores", queryAttrs, signerKeyStoreScope);
                AttributeList keyStore = cs.getAttributes(session, keyStoreObjName, null, false);
                return keyStore;
            }
            keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, signerKeyStoreScope);
            AttributeList keyStore = cs.getAttributes(session, keyStoreObjName, null, false);
            return keyStore;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public static void parseRecord(String s, int beginSeq, int endSeq, Date beginTimeStamp, Date endTimeStamp, Vector eventsList, Vector outcomesList, Vector dataPointsList, String reportMode) {
        Hashtable<String, String> recordHashTable = new Hashtable<String, String>();
        Hashtable<String, Object> dataHashTable = new Hashtable<String, Object>();
        boolean addSeqRecord = true;
        boolean addEventRecord = true;
        boolean addOutcomeRecord = true;
        boolean addFilterRecord = true;
        int number_of_records = 0;
        String record = null;
        LinkedList<String> requestll = new LinkedList<String>();
        LinkedList<String> responsell = new LinkedList<String>();
        String reqListEntry = null;
        String resListEntry = null;
        boolean firstRequestHeader = true;
        boolean firstResponseHeader = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parseRecord> s: " + s);
        }
        if (s.contains("Seq")) {
            addSeqRecord = true;
            addEventRecord = true;
            addOutcomeRecord = true;
            addFilterRecord = true;
            recordHashTable = new Hashtable();
            dataHashTable = new Hashtable();
            ++number_of_records;
            int start_of_record = s.indexOf("Seq");
            String ss = s.substring(start_of_record);
            record = new String(ss);
            String parsedRecord = new String(record);
            String[] kv = new String[1000];
            boolean endOfRecord = false;
            int i1 = 0;
            int i2 = 0;
            int kvindex = 0;
            while (!endOfRecord) {
                i2 = parsedRecord.indexOf(" | ");
                if (i2 != -1) {
                    kv[kvindex] = new String(parsedRecord.substring(0, i2));
                    ++kvindex;
                    i1 = i2 + 3;
                    parsedRecord = parsedRecord.substring(i1);
                    continue;
                }
                endOfRecord = true;
            }
            kv[kvindex] = new String(parsedRecord);
            ++kvindex;
            int reqHdrIndex = -1;
            int resHdrIndex = -1;
            block16: for (int i = 0; i < kvindex; ++i) {
                String[] key_value = new String[2];
                int splitLen = kv[i].indexOf("=");
                key_value[0] = kv[i].substring(0, splitLen - 1);
                key_value[1] = kv[i].substring(splitLen + 2, kv[i].length());
                key_value[0] = key_value[0].trim();
                key_value[1] = key_value[1].trim();
                if (!addSeqRecord || !addEventRecord || !addOutcomeRecord || !addFilterRecord) break;
                if (hm.get(key_value[0]) == null) {
                    dataHashTable.put(key_value[0], key_value[1]);
                    continue;
                }
                int intval = (Integer)hm.get(key_value[0]);
                switch (intval) {
                    case 0: {
                        if (beginSeq != -1 && endSeq != -1) {
                            Integer seqNum = new Integer(key_value[1]);
                            if (beginSeq == endSeq) {
                                if (seqNum != beginSeq) {
                                    addSeqRecord = false;
                                    continue block16;
                                }
                            } else if (seqNum >= beginSeq && seqNum <= endSeq) {
                                addSeqRecord = true;
                            } else {
                                addSeqRecord = false;
                                continue block16;
                            }
                        }
                        recordHashTable.put("Seq", key_value[1]);
                        continue block16;
                    }
                    case 1: {
                        if (!eventsList.isEmpty() && !eventsList.contains(key_value[1])) {
                            addEventRecord = false;
                            continue block16;
                        }
                        addEventRecord = true;
                        recordHashTable.put("Event Type", key_value[1]);
                        continue block16;
                    }
                    case 2: {
                        if (!outcomesList.isEmpty() && !outcomesList.contains(key_value[1])) {
                            addOutcomeRecord = false;
                            continue block16;
                        }
                        addOutcomeRecord = true;
                        recordHashTable.put("Outcome", key_value[1]);
                        continue block16;
                    }
                    case 3: {
                        dataHashTable.put("OutcomeReason", key_value[1]);
                        continue block16;
                    }
                    case 15: {
                        if (beginTimeStamp != null && endTimeStamp != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "beginTimeStamp: " + beginTimeStamp + " endTimeStamp: " + endTimeStamp);
                            }
                            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                            df.setLenient(false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "creation time: " + key_value[1]);
                            }
                            try {
                                Date d = df.parse(key_value[1]);
                                if (d.compareTo(beginTimeStamp) < 0 || d.compareTo(endTimeStamp) > 0) {
                                    addFilterRecord = false;
                                    continue block16;
                                }
                                addFilterRecord = true;
                                dataHashTable.put(key_value[0], key_value[1]);
                            }
                            catch (NullPointerException pe) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "NPE handling creation time value");
                                }
                                pe.printStackTrace();
                            }
                            catch (ParseException pee) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ParseException");
                                }
                                pee.printStackTrace();
                            }
                            continue block16;
                        }
                        addFilterRecord = true;
                        dataHashTable.put(key_value[0], key_value[1]);
                        continue block16;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 59: {
                        dataHashTable.put(key_value[0], key_value[1]);
                        continue block16;
                    }
                    case 53: {
                        if (++reqHdrIndex >= 0 && reqListEntry != null) {
                            requestll.add(reqListEntry);
                            reqListEntry = "";
                        }
                    }
                    case 54: 
                    case 55: {
                        if (reqListEntry == null || intval == 53) {
                            reqListEntry = new String(key_value[0] + " = " + key_value[1]);
                            continue block16;
                        }
                        reqListEntry = reqListEntry.concat(" | " + key_value[0] + " = " + key_value[1]);
                        continue block16;
                    }
                    case 56: {
                        if (++resHdrIndex >= 0 && resListEntry != null) {
                            responsell.add(resListEntry);
                            resListEntry = "";
                        }
                    }
                    case 57: 
                    case 58: {
                        resListEntry = resListEntry == null || intval == 56 ? new String(key_value[0] + " = " + key_value[1]) : resListEntry.concat(" | " + key_value[0] + " = " + key_value[1]);
                    }
                }
            }
            if (reqListEntry != null) {
                requestll.add(reqListEntry);
            }
            if (resListEntry != null) {
                responsell.add(resListEntry);
            }
            if (requestll != null) {
                ListIterator li = requestll.listIterator(0);
                if (tc.isDebugEnabled()) {
                    int blah = 0;
                    while (li.hasNext()) {
                        String hdrs = (String)li.next();
                        Tr.debug(tc, "ENTRY(" + blah + "): " + hdrs);
                        ++blah;
                    }
                }
                dataHashTable.put("httpRequestHeaders", requestll);
            }
            LinkedList testll = (LinkedList)dataHashTable.get("httpRequestHeaders");
            ListIterator testi = testll.listIterator();
            if (responsell != null) {
                dataHashTable.put("httpResponseHeaders", responsell);
            }
            if (addSeqRecord && addEventRecord && addOutcomeRecord && addFilterRecord) {
                report.add(index++, recordHashTable);
                report.add(index++, dataHashTable);
            }
        }
    }

    public static void processData(Vector report, String reportMode, String outputLocation, Vector dataPointsList) throws UnknownHostException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processData: report: " + report.toString() + " reportMode: " + reportMode + " outputLocation: " + outputLocation + " dataPointsList: " + dataPointsList.toString());
        }
        Date now = new Date();
        DateFormat df = DateFormat.getDateInstance();
        currentDate = df.format(now);
        Time t = new Time(now.getTime());
        currentTime = t.toString();
        hostname = InetAddress.getLocalHost().getHostName();
        DateFormat dfShort = DateFormat.getDateInstance(2);
        String displayTime = currentTime.replace(':', '_');
        String currentDateShort = dfShort.format(now);
        String displayDate = AuditReader.removeSpaces(currentDateShort);
        displayDate = displayDate.replace(',', '_');
        odd = true;
        String styleBody = "body { FONT-WEIGHT: normal; FONT-SIZE: 10pt; FONT-FAMILY: Helvetica, Verdana, Arial, sans-serif }";
        String styleTBody = "tbody { FONT-WEIGHT: normal; FONT-SIZE: 10pt; FONT-FAMILY: Helvetica, Verdana, Arial, sans-serif }";
        String styleReportInfo = "#reportInfo { DISPLAY: block; PADDING-BOTTOM: 1em; TEXT-ALIGN: center }";
        String styleH1 = "@media screen { h1 { PADDING-RIGHT: 0em; PADDING-LEFT: 0em; FONT-WEIGHT: bolder; FONT-SIZE: 120%; MARGIN-BOTTOM: 0.1em; PADDING-BOTTOM: 0em; PADDING-TOP: 0em; TEXT-ALIGN: center}}";
        String styleA = "a:link { TEXT-DECORATION: none } a:hover { TEXT-DECORATION: underline } a:active { TEXT-DECORATION: underline }";
        String styleCap = "caption { PADDING-RIGHT: 0.5em; PADDING-LEFT: 0.5em; FONT-WEIGHT: normal; FONT-SIZE: 12pt; MARGIN-BOTTOM: 0.25em; PADDING-BOTTOM: 0.5em; PADDING-TOP: 0.5em; TEXT-ALIGN: center }";
        String styleReport = "#report { border-top-width: 15px; border-right-width: 15px; border-bottom-width: 15px; border-left-width: 15px; border-top-style: solid; border-right-style: solid; border-bottom-style: solid; border-left-style: solid; border-top-color: #CCCCCC; border-right-color: #333333; border-bottom-color: #333333; border-left-color: #CCCCCC;}";
        String styleTable = ".table { background-color: #FFFFFF; text-align: left;}";
        String styleTh = ".heading {background-color: #CCFFFF; text-align: left;}";
        String styleTd = ".tableBorder {border: 1px solid #CCCCCC; width:25%; word-wrap:break-word; }";
        String TrEven = ".even {text-align: left; background-color: #E0E0E0;}";
        String TrOdd = ".odd {text-align: left; background-color: #FFFFFF;}";
        String TdSectionTitle = ".sectiontitle {border: 1px solid #CCCCCC; width:25%; background-color: #FF9900; text-align: left; font-weight: bold; word-wrap:break-word;}";
        String stylePrint = "@media print {body {font-family: Times, \"Times New Roman\", serif;font-weight: normal;font-size: 9pt;}";
        String stylePrH1 = "h1 {font-size: 16pt;font-weight: bolder;border-bottom: 2px solid #CCFFFF;padding: 0em;margin-bottom: 0.1em;}";
        String stylePrA = "a:link {color: #000;text-decoration: underline;font-weight: normal;}";
        String stylePrCap = "caption {font-family: Times, \"Times New Roman\", serif;font-size: 9pt;}";
        String stylePrTab = "table, caption, th { page-break-before: avoid; }table.report {padding-top: 0em;margin-top: 0.1em;}";
        String stylePrCap1 = "caption, tr, td {page-break-inside: avoid;}";
        String stylePrTr = " tr, td { page-break-before: auto;}";
        String stylePrTd = " td { font-family: Times, \"Times New Roman\", serif; font-weight: normal;font-size: 9pt; width:25%;}";
        String stylePrTh = " th { font-family: Times, \"Times New Roman\", serif; font-size: 9pt;}";
        String styleNoPr = ".noPrint { display: none; }";
        String styleEnd = " }</style>";
        String style = "<style type=\"text/css\">" + styleBody + styleTBody + styleReportInfo + styleH1 + styleA + styleCap + styleTable + styleTh + TrEven + TrOdd + TdSectionTitle + stylePrint + stylePrH1 + stylePrA + stylePrCap + stylePrTab + stylePrCap1 + stylePrTr + stylePrTd + stylePrTh + styleNoPr + styleEnd;
        htmlString = htmlString + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        htmlString = htmlString + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">";
        htmlString = htmlString + "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
        String title = "Audit Records";
        String reportHostname = "Hostname ";
        String reportTime = "ReportTime ";
        htmlString = htmlString + "<head><title>" + title + "</title>" + style + "</head>\n<body>";
        htmlString = htmlString + "<h1>" + title + "</h1><br><div align=\"center\" id=\"reportInfo\"> " + reportHostname + hostname + " . " + reportTime + currentDate + ", " + currentTime + "</div>";
        htmlString = htmlString + "<table id=\"report\"><thead>";
        FileWriter outputFile = null;
        outputFile = new FileWriter(outputLocation);
        outputFile.write(htmlString, 0, htmlString.length());
        if (report != null && report.toString().length() > 0) {
            AuditReader.writeOutput(report, reportMode, dataPointsList, outputFile);
        }
        AuditReader.endOutput();
        outputFile.write(htmlString, 0, htmlString.length());
        outputFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processData");
        }
    }

    private static void endOutput() {
        htmlString = "</tbody></table></body></html>";
    }

    private static void writeOutput(Vector result, String reportMode, Vector dataPointsList, FileWriter outputFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeOutput: reportMode : " + reportMode + " dataPointsList: " + dataPointsList.toString());
        }
        ConcurrentHashMap<Integer, String> cache = new ConcurrentHashMap<Integer, String>();
        boolean cacheFlag = false;
        boolean foundInCache = false;
        int currentSeqNum = 0;
        boolean printDataRegion = false;
        Hashtable header = new Hashtable();
        header = (Hashtable)result.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "header: " + header.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "result: " + result.toString());
        }
        htmlString = "";
        AuditReader.print("<TR class=\"heading\">");
        AuditReader.printTableBold((String)header.get("record"));
        AuditReader.printTableBold((String)header.get("event"));
        AuditReader.printTableBold((String)header.get("outcome"));
        AuditReader.print("</TR>");
        outputFile.write(htmlString, 0, htmlString.length());
        boolean odd = true;
        Integer intSeq = new Integer(0);
        for (int i = 1; i < result.size(); ++i) {
            String value;
            header = (Hashtable)result.get(i);
            if (i == 1) {
                currentSeqNum = new Integer((String)header.get("Seq"));
            }
            if (odd) {
                intSeq = new Integer((String)header.get("Seq"));
                htmlString = "";
                AuditReader.print("<TR class=\"odd\">");
                AuditReader.printTableBoldColor((String)header.get("Seq"));
                AuditReader.printTableBoldColor((String)header.get("Event Type"));
                AuditReader.printTableBoldColor((String)header.get("Outcome"));
                odd = false;
                AuditReader.print("</TR>");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Currently processing record number: " + currentSeqNum);
                }
                if (intSeq == currentSeqNum) {
                    outputFile.write(htmlString, 0, htmlString.length());
                    printDataRegion = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Currently processing: " + currentSeqNum + " but record " + intSeq + " is an out of sequence record, caching");
                    }
                    cacheFlag = true;
                }
            } else {
                if (printDataRegion) {
                    htmlString = "";
                }
                if (reportMode.equals("basic") || reportMode.equals("complete")) {
                    if (reportMode.equals("basic") || reportMode.equals("complete")) {
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("CreationTime") != null) {
                            AuditReader.printTable(new String("CreationTime").concat("=").concat((String)header.get("CreationTime")));
                        } else {
                            AuditReader.printTable(new String("CreationTime").concat("=").concat("null"));
                        }
                        if (header.get("Action") != null) {
                            AuditReader.printTable(new String("Action").concat("=").concat((String)header.get("Action")));
                        } else {
                            AuditReader.printTable(new String("Action").concat("=").concat("null"));
                        }
                        if (header.get("ProgName") != null) {
                            AuditReader.printTable(new String("ProgName").concat("=").concat((String)header.get("ProgName")));
                        } else {
                            AuditReader.printTable(new String("ProgName").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        if (header.get("RegistryType") != null || header.get("Domain") != null || header.get("Realm") != null) {
                            AuditReader.print("<TR class=\"even\">");
                            if (header.get("RegistryType") != null) {
                                AuditReader.printTable(new String("RegistryType").concat("=").concat((String)header.get("RegistryType")));
                            } else {
                                AuditReader.printTable(new String("RegistryType").concat("=").concat("null"));
                            }
                            if (header.get("Domain") != null) {
                                AuditReader.printTable(new String("Domain").concat("=").concat((String)header.get("Domain")));
                            } else {
                                AuditReader.printTable(new String("Domain").concat("=").concat("null"));
                            }
                            if (header.get("Realm") != null) {
                                AuditReader.printTable(new String("Realm").concat("=").concat((String)header.get("Realm")));
                            } else {
                                AuditReader.printTable(new String("Realm").concat("=").concat("null"));
                            }
                            AuditReader.print("</TR>");
                        }
                        if (header.get("RemoteAddr") != null || header.get("RemotePort") != null || header.get("RemoteHost") != null) {
                            AuditReader.print("<TR class=\"even\">");
                            if (header.get("RemoteAddr") != null) {
                                AuditReader.printTable(new String("RemoteAddr").concat("=").concat((String)header.get("RemoteAddr")));
                            } else {
                                AuditReader.printTable(new String("RemoteAddr").concat("=").concat("null"));
                            }
                            if (header.get("RemotePort") != null) {
                                AuditReader.printTable(new String("RemotePort").concat("=").concat((String)header.get("RemotePort")));
                            } else {
                                AuditReader.printTable(new String("RemotePort").concat("=").concat("null"));
                            }
                            if (header.get("RemoteHost") != null) {
                                AuditReader.printTable(new String("RemoteHost").concat("=").concat((String)header.get("RemoteHost")));
                            } else {
                                AuditReader.printTable(new String("RemoteHost").concat("=").concat("null"));
                            }
                            AuditReader.print("</TR>");
                        }
                        if (header.get("RegistryUserName") != null || header.get("AppUserName") != null || header.get("NameInApp") != null) {
                            AuditReader.print("<TR class=\"even\">");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "EFT Registry user name: " + header.get("RegistryUserName"));
                            }
                            if (header.get("RegistryUserName") == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "EFT: Registry user name is null");
                                }
                            } else if (header.get("RegistryUserName").equals("null")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "EFT: Registry user name is the string null");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "EFT: Registry user name something else ???");
                            }
                            if (header.get("RegistryUserName") != null) {
                                AuditReader.printTable(new String("RegistryUserName").concat("=").concat((String)header.get("RegistryUserName")));
                            }
                            if (header.get("AppUserName") != null) {
                                AuditReader.printTable(new String("AppUserName").concat("=").concat((String)header.get("AppUserName")));
                            } else {
                                AuditReader.printTable(new String("AppUserName").concat("=").concat("null"));
                            }
                            if (header.get("NameInApp") != null) {
                                AuditReader.printTable(new String("NameInApp").concat("=").concat((String)header.get("NameInApp")));
                            } else {
                                AuditReader.printTable(new String("NameInApp").concat("=").concat("null"));
                            }
                            AuditReader.print("</TR>");
                        }
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("FirstCaller") != null) {
                            AuditReader.printTable(new String("FirstCaller").concat("=").concat((String)header.get("FirstCaller")));
                        } else {
                            AuditReader.printTable(new String("FirstCaller").concat("=").concat("null"));
                        }
                        if (header.get("CallerList") != null) {
                            AuditReader.printTable(new String("CallerList").concat("=").concat((String)header.get("CallerList")));
                        } else {
                            AuditReader.printTable(new String("CallerList").concat("=").concat("null"));
                        }
                        if (header.get("TerminateReason") != null) {
                            AuditReader.printTable(new String("TerminateReason").concat("=").concat((String)header.get("TerminateReason")));
                        } else {
                            AuditReader.printTable(new String("TerminateReason").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        if (header.get("ResourceName") != null || header.get("ResourceType") != null || header.get("ResourceUniqueId") != null) {
                            AuditReader.print("<TR class=\"even\">");
                            if (header.get("ResourceName") != null) {
                                AuditReader.printTable(new String("ResourceName").concat("=").concat((String)header.get("ResourceName")));
                            } else {
                                AuditReader.printTable(new String("ResourceName").concat("=").concat("null"));
                            }
                            if (header.get("ResourceType") != null) {
                                AuditReader.printTable(new String("ResourceType").concat("=").concat((String)header.get("ResourceType")));
                            } else {
                                AuditReader.printTable(new String("ResourceType").concat("=").concat("null"));
                            }
                            if (header.get("ResourceUniqueId") != null) {
                                AuditReader.printTable(new String("ResourceUniqueId").concat("=").concat((String)header.get("ResourceUniqueId")));
                            } else {
                                AuditReader.printTable(new String("ResourceUniqueId").concat("=").concat("null"));
                            }
                            AuditReader.print("</TR>");
                        }
                        if (header.get("CertLifetime") != null || header.get("KeyLabel") != null || header.get("KeyLocation") != null) {
                            AuditReader.print("<TR class=\"even\">");
                            if (header.get("CertLifetime") != null) {
                                AuditReader.printTable(new String("CertLifetime").concat("=").concat((String)header.get("CertLifetime")));
                            } else {
                                AuditReader.printTable(new String("CertLifetime").concat("=").concat("null"));
                            }
                            if (header.get("KeyLabel") != null) {
                                AuditReader.printTable(new String("KeyLabel").concat("=").concat((String)header.get("KeyLabel")));
                            } else {
                                AuditReader.printTable(new String("KeyLabel").concat("=").concat("null"));
                            }
                            if (header.get("KeyLocation") != null) {
                                AuditReader.printTable(new String("KeyLocation").concat("=").concat((String)header.get("KeyLocation")));
                            } else {
                                AuditReader.printTable(new String("KeyLocation").concat("=").concat("null"));
                            }
                            AuditReader.print("</TR>");
                        }
                    }
                    if (reportMode.equals("complete")) {
                        String[] key_value;
                        String valueKeyValue;
                        String sourceKeyValue;
                        int sourceIndex;
                        String nameKeyValue;
                        String hdrs;
                        int nameIndex;
                        ListIterator li;
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("AuthnType") != null) {
                            AuditReader.printTable(new String("AuthnType").concat("=").concat((String)header.get("AuthnType")));
                        } else {
                            AuditReader.printTable(new String("AuthnType").concat("=").concat("null"));
                        }
                        if (header.get("Provider") != null) {
                            AuditReader.printTable(new String("Provider").concat("=").concat((String)header.get("Provider")));
                        } else {
                            AuditReader.printTable(new String("Provider").concat("=").concat("null"));
                        }
                        if (header.get("ProviderStatus") != null) {
                            AuditReader.printTable(new String("ProviderStatus").concat("=").concat((String)header.get("ProviderStatus")));
                        } else {
                            AuditReader.printTable(new String("ProviderStatus").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("MappedSecurityDomain") != null) {
                            AuditReader.printTable(new String("MappedSecurityDomain").concat("=").concat((String)header.get("MappedSecurityDomain")));
                        } else {
                            AuditReader.printTable(new String("MappedSecurityDomain").concat("=").concat("null"));
                        }
                        if (header.get("MappedRealm") != null) {
                            AuditReader.printTable(new String("MappedRealm").concat("=").concat((String)header.get("MappedRealm")));
                        } else {
                            AuditReader.printTable(new String("MappedRealm").concat("=").concat("null"));
                        }
                        if (header.get("MappedUserName") != null) {
                            AuditReader.printTable(new String("MappedUserName").concat("=").concat((String)header.get("MappedUserName")));
                        } else {
                            AuditReader.printTable(new String("MappedUserName").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("DelegationType") != null) {
                            AuditReader.printTable(new String("DelegationType").concat("=").concat((String)header.get("DelegationType")));
                        } else {
                            AuditReader.printTable(new String("DelegationType").concat("=").concat("null"));
                        }
                        if (header.get("RoleName") != null) {
                            AuditReader.printTable(new String("RoleName").concat("=").concat((String)header.get("RoleName")));
                        } else {
                            AuditReader.printTable(new String("RoleName").concat("=").concat("null"));
                        }
                        if (header.get("IdentityName") != null) {
                            AuditReader.printTable(new String("IdentityName").concat("=").concat((String)header.get("IdentityName")));
                        } else {
                            AuditReader.printTable(new String("IdentityName").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("AccessDecision") != null) {
                            AuditReader.printTable(new String("AccessDecision").concat("=").concat((String)header.get("AccessDecision")));
                        } else {
                            AuditReader.printTable(new String("AccessDecision").concat("=").concat("null"));
                        }
                        if (header.get("PolicyName") != null) {
                            AuditReader.printTable(new String("PolicyName").concat("=").concat((String)header.get("PolicyName")));
                        } else {
                            AuditReader.printTable(new String("PolicyName").concat("=").concat("null"));
                        }
                        if (header.get("PolicyType") != null) {
                            AuditReader.printTable(new String("PolicyType").concat("=").concat((String)header.get("PolicyType")));
                        } else {
                            AuditReader.printTable(new String("PolicyType").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("PermissionsChecked") != null) {
                            AuditReader.printTable(new String("PermissionsChecked").concat("=").concat((String)header.get("PermissionsChecked")));
                        } else {
                            AuditReader.printTable(new String("PermissionsChecked").concat("=").concat("null"));
                        }
                        if (header.get("PermissionsGranted") != null) {
                            AuditReader.printTable(new String("PermissionsGranted").concat("=").concat((String)header.get("PermissionsGranted")));
                        } else {
                            AuditReader.printTable(new String("PermissionsGranted").concat("=").concat("null"));
                        }
                        if (header.get("RolesChecked") != null) {
                            AuditReader.printTable(new String("RolesChecked").concat("=").concat((String)header.get("RolesChecked")));
                        } else {
                            AuditReader.printTable(new String("RolesChecked").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("RolesGranted") != null) {
                            AuditReader.printTable(new String("RolesGranted").concat("=").concat((String)header.get("RolesGranted")));
                        } else {
                            AuditReader.printTable(new String("RolesGranted").concat("=").concat("null"));
                        }
                        if (header.get("MgmtType") != null) {
                            AuditReader.printTable(new String("MgmtType").concat("=").concat((String)header.get("MgmtType")));
                        } else {
                            AuditReader.printTable(new String("MgmtType").concat("=").concat("null"));
                        }
                        if (header.get("MgmtCommand") != null) {
                            AuditReader.printTable(new String("MgmtCommand").concat("=").concat((String)header.get("MgmtCommand")));
                        } else {
                            AuditReader.printTable(new String("MgmtCommand").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("TargetInfoName") != null) {
                            AuditReader.printTable(new String("TargetInfoName").concat("=").concat((String)header.get("TargetInfoName")));
                        } else {
                            AuditReader.printTable(new String("TargetInfoName").concat("=").concat("null"));
                        }
                        if (header.get("TargetInfoUniqueId") != null) {
                            AuditReader.printTable(new String("TargetInfoUniqueId").concat("=").concat((String)header.get("TargetInfoUniqueId")));
                        } else {
                            AuditReader.printTable(new String("TargetInfoUniqueId").concat("=").concat("null"));
                        }
                        if (header.get("Url") != null) {
                            AuditReader.printTable(new String("Url").concat("=").concat((String)header.get("Url")));
                        } else {
                            AuditReader.printTable(new String("Url").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("httpRequestHeaders") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "found httpRequestHeaders");
                            }
                            LinkedList l = (LinkedList)header.get("httpRequestHeaders");
                            li = l.listIterator();
                            while (li.hasNext() && (nameIndex = (hdrs = (String)li.next()).indexOf(" | ")) != -1) {
                                if (hdrs.indexOf("ReqHeaderName") == -1 || hdrs.indexOf("ReqHeaderSrc") == -1 || hdrs.indexOf("ReqHeaderValue") == -1) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "FOUND AT LEAST one missing header string");
                                    continue;
                                }
                                nameKeyValue = hdrs.substring(0, nameIndex);
                                sourceIndex = (hdrs = hdrs.substring(nameIndex + 3)).indexOf(" | ");
                                if (sourceIndex == -1) continue;
                                sourceKeyValue = hdrs.substring(0, sourceIndex);
                                valueKeyValue = hdrs.substring(sourceIndex + 3);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "nameKeyValue: " + nameKeyValue + " sourceKeyValue: " + sourceKeyValue + " valueKeyValue: " + valueKeyValue);
                                }
                                key_value = new String[2];
                                key_value = nameKeyValue.split("\\=");
                                AuditReader.printTable(new String("ReqHeaderName").concat("=").concat(key_value[1]));
                                key_value = sourceKeyValue.split("\\=");
                                AuditReader.printTable(new String("ReqHeaderSrc").concat("=").concat(key_value[1]));
                                key_value = sourceKeyValue.split("\\=");
                                AuditReader.printTable(new String("ReqHeaderValue").concat("=").concat(key_value[1]));
                                AuditReader.print("</TR>");
                                AuditReader.print("<TR class=\"even\">");
                            }
                        } else {
                            AuditReader.printTable(new String("ReqHeaderName").concat("=").concat("null"));
                            AuditReader.printTable(new String("ReqHeaderSrc").concat("=").concat("null"));
                            AuditReader.printTable(new String("ReqHeaderValue").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("httpResponseHeaders") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "found httpResponseHeaders");
                            }
                            LinkedList l = (LinkedList)header.get("httpResponseHeaders");
                            li = l.listIterator();
                            while (li.hasNext() && (nameIndex = (hdrs = (String)li.next()).indexOf(" | ")) != -1) {
                                if (hdrs.indexOf("ResHeaderName") == -1 || hdrs.indexOf("ResHeaderSrc") == -1 || hdrs.indexOf("ResHeaderValue") == -1) continue;
                                nameKeyValue = hdrs.substring(0, nameIndex);
                                sourceIndex = (hdrs = hdrs.substring(nameIndex + 3)).indexOf(" | ");
                                if (sourceIndex == -1) continue;
                                sourceKeyValue = hdrs.substring(0, sourceIndex);
                                valueKeyValue = hdrs.substring(sourceIndex + 3);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "nameKeyValue: " + nameKeyValue + " sourceKeyValue: " + sourceKeyValue + " valueKeyValue: " + valueKeyValue);
                                }
                                key_value = new String[2];
                                key_value = nameKeyValue.split("\\=");
                                AuditReader.printTable(new String("ResHeaderName").concat("=").concat(key_value[1]));
                                key_value = sourceKeyValue.split("\\=");
                                AuditReader.printTable(new String("ResHeaderSrc").concat("=").concat(key_value[1]));
                                key_value = sourceKeyValue.split("\\=");
                                AuditReader.printTable(new String("ResHeaderValue").concat("=").concat(key_value[1]));
                                AuditReader.print("</TR>");
                                AuditReader.print("<TR class=\"even\">");
                            }
                        } else {
                            AuditReader.printTable(new String("ResHeaderName").concat("=").concat("null"));
                            AuditReader.printTable(new String("ResHeaderSrc").concat("=").concat("null"));
                            AuditReader.printTable(new String("ResHeaderValue").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                        AuditReader.print("<TR class=\"even\">");
                        if (header.get("OutcomeReasonCode") != null) {
                            AuditReader.printTable(new String("OutcomeReasonCode").concat("=").concat((String)header.get("OutcomeReasonCode")));
                        } else {
                            AuditReader.printTable(new String("OutcomeReasonCode").concat("=").concat("null"));
                        }
                        AuditReader.print("</TR>");
                    }
                    odd = true;
                } else if (reportMode.equals("custom")) {
                    htmlString = "";
                    int threePair = 0;
                    Enumeration en = dataPointsList.elements();
                    while (en.hasMoreElements()) {
                        String specifiedDataPoint;
                        if (threePair == 0) {
                            AuditReader.print("<TR class=\"even\">");
                        }
                        if (header.get(specifiedDataPoint = (String)en.nextElement()) != null) {
                            AuditReader.printTable(new String(specifiedDataPoint).concat("=").concat((String)header.get(specifiedDataPoint)));
                        } else {
                            AuditReader.printTable(new String(specifiedDataPoint).concat("=").concat("null"));
                        }
                        if (++threePair != 3) continue;
                        AuditReader.print("</TR>");
                        threePair = 0;
                    }
                    if (threePair != 0 && dataPointsList != null && !dataPointsList.isEmpty()) {
                        AuditReader.print("</TR>");
                    }
                    odd = true;
                }
                if (printDataRegion) {
                    outputFile.write(htmlString, 0, htmlString.length());
                    printDataRegion = false;
                    ++currentSeqNum;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "in printDataRegion, currentSeqNum: " + currentSeqNum);
                    }
                    if (cacheFlag) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "we have cached records");
                        }
                        foundInCache = true;
                        while (foundInCache) {
                            Integer seqKey = new Integer(currentSeqNum);
                            if (cache.containsKey(seqKey)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "cache contains sequence number: " + currentSeqNum);
                                }
                                value = (String)cache.get(seqKey);
                                outputFile.write(value, 0, value.length());
                                cache.remove(seqKey);
                                if (cache.isEmpty()) {
                                    cacheFlag = false;
                                    foundInCache = false;
                                }
                                ++currentSeqNum;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "processed cached record, currentSeqNum: " + currentSeqNum);
                                continue;
                            }
                            foundInCache = false;
                        }
                    }
                } else {
                    cache.put(intSeq, htmlString);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caching record: " + intSeq + " value: " + htmlString);
                    }
                    cacheFlag = true;
                }
            }
            if (!cacheFlag) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Flushing out the rest of the cache entries if any exist");
            }
            Enumeration e = cache.keys();
            while (e.hasMoreElements()) {
                value = (String)cache.get((Integer)e.nextElement());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "   Cached: key:  value: " + value);
                }
                outputFile.write(value, 0, value.length());
            }
            cache.clear();
        }
    }

    private static void printTable(String s) {
        htmlString = htmlString + "<TD class=\"tableBorder\">" + s + "</TD>";
    }

    private static void printTableBold(String s) {
        htmlString = htmlString + "<TD class=\"tableBorder\"><b>" + s + "</b></TD>";
    }

    private static void printTableBoldColor(String s) {
        htmlString = htmlString + "<TD class=\"sectiontitle\">" + s + "</TD>";
        printBold = true;
    }

    private static void printTableColor(String s) {
        htmlString = htmlString + "<TD class=\"sectiontitle\">" + s + "</TD>";
        printBold = false;
    }

    private static void print(String s) {
        htmlString = htmlString + s;
    }

    private static String adjustSeparator(String s) {
        String t = s.replace("|", "| ");
        return t;
    }

    private static String adjustSlash(String s) {
        String t = s.replace("/", "/ ");
        return t;
    }

    private static String removeSpaces(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f", false);
        String t = "";
        while (st.hasMoreTokens()) {
            t = t + st.nextToken();
        }
        return t;
    }

    private static String removeLeadingSpaces(String s) {
        char[] charArray = s.toCharArray();
        String newString = new String();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == ' ' || charArray[i] == '\n' || charArray[i] == '\t' || charArray[i] == '\f' || charArray[i] == '\r') continue;
            newString = s.substring(i, s.length());
            break;
        }
        return newString;
    }

    public static Session getConfigSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigSession");
        }
        if (_session == null) {
            AuditReader.createSession();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigSession");
        }
        return _session;
    }

    private static void createSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSession");
        }
        String id = Long.toHexString(System.currentTimeMillis());
        String user = ANONYMOUS + id;
        _session = new Session(user, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSession");
        }
    }

    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore" + fileName);
        }
        try {
            String expandedFilename = KeyStoreManager.getInstance().expand(fileName);
            OpenKeyStoreAction action = new OpenKeyStoreAction(expandedFilename);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "OpenKeyStoreAction.run");
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "OpenKeyStoreAction.run");
            }
            return fis;
        }
    }
}

