/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.GenericEvent;
import com.ibm.wsspi.security.audit.GenericEventCompletionException;
import com.ibm.wsspi.security.audit.GenericEventConfigurationException;
import com.ibm.wsspi.security.audit.GenericEventValidationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SecurityAuditEventImpl
implements GenericEvent,
Serializable {
    public static final String BASE_EVENT_TYPE = SecurityAuditEventImpl.class.getName() + ".baseEventType";
    private static AuditService auditService = null;
    private static final TraceComponent tc = Tr.register(SecurityAuditEventImpl.class, null, "com.ibm.ejs.resources.security");
    private Integer _seq = 0;
    private String _eventType = null;
    private String _outcome = null;
    private String _outcomeReason = null;
    private long _outcomeReasonCode = -1L;
    private String _sessionId = null;
    private String _remoteAddr = null;
    private String _remotePort = null;
    private String _remoteHost = null;
    private String _firstCaller = null;
    private String[] _callerList = null;
    private String _domain = null;
    private String _realm = null;
    private String _registryType = null;
    private String _authnType = null;
    private String _delegationType = null;
    private String _roleName = null;
    private String _identityName = null;
    private String _mappedSecurityDomain = null;
    private String _mappedRealm = null;
    private String _mappedUserName = null;
    private String _terminateReason = null;
    private String _provider = null;
    private String _providerStatus = null;
    private String _progName = null;
    private String _action = null;
    private String _registryUserName = null;
    private String _appUserName = null;
    private String _accessDecision = null;
    private String _resourceName = null;
    private String _resourceType = null;
    private Long _resourceUniqueId = null;
    private String[] _permissionsChecked = null;
    private String[] _permissionsGranted = null;
    private String[] _rolesChecked = null;
    private String[] _rolesGranted = null;
    private String _lastEventTrailId = null;
    private String[] _eventTrailId = null;
    private Date _creationTime = null;
    private Long _globalInstanceId = null;
    private String _policyName = null;
    private String _policyType = null;
    private String _keyLabel = null;
    private String _keyLocation = null;
    private Date _certLifetime = null;
    private String _mgmtType = null;
    private String _mgmtCommand = null;
    private TargetAttributes[] _targetInfoAttributes = null;
    private String _url = null;
    private Attributes[] _httpRequestHeaders = null;
    private Attributes[] _httpResponseHeaders = null;
    private String[] customKeys = new String[50];
    private Object[] customValues = new String[50];
    private int customDataSize = 0;
    private HashMap auditEvent = null;

    public String getEventType() {
        return this._eventType;
    }

    public String getEventType(HashMap auditEvent) {
        return (String)auditEvent.get("EVENT_TYPE");
    }

    public String getOutcome() {
        return this._outcome;
    }

    public String getOutcome(HashMap auditEvent) {
        return (String)auditEvent.get("OutcomeFailureReason");
    }

    public Date getCreationTime() {
        return this._creationTime;
    }

    public Date getCreationTime(HashMap auditEvent) {
        return (Date)auditEvent.get("CreationTime");
    }

    public String getVersion(HashMap props) throws GenericEventConfigurationException {
        return null;
    }

    public Long getGlobalInstanceId() {
        return this._globalInstanceId;
    }

    public Long getGlobalInstanceId(HashMap auditEvent) {
        return (Long)auditEvent.get("GlobalInstanceId");
    }

    public String[] getCustomKeys() {
        return this.customKeys;
    }

    public String[] getCustomValues() {
        return (String[])this.customValues;
    }

    public void validate() throws GenericEventValidationException {
        if (!(this._eventType.equals("SECURITY_AUTHN") || this._eventType.equals("SECURITY_AUTHN_CREDS_MODIFY") || this._eventType.equals("SECURITY_AUTHN_DELEGATION") || this._eventType.equals("SECURITY_AUTHN_MAPPING") || this._eventType.equals("SECURITY_AUTHN_TERMINATE") || this._eventType.equals("SECURITY_AUTHZ") || this._eventType.equals("SECURITY_ENCRYPTION") || this._eventType.equals("SECURITY_MGMT_AUDIT") || this._eventType.equals("SECURITY_MGMT_CONFIG") || this._eventType.equals("SECURITY_MGMT_KEY") || this._eventType.equals("SECURITY_MGMT_POLICY") || this._eventType.equals("SECURITY_MGMT_PROVISIONING") || this._eventType.equals("SECURITY_MGMT_REGISTRY") || this._eventType.equals("SECURITY_MGMT_RESOURCE") || this._eventType.equals("SECURITY_RESOURCE_ACCESS") || this._eventType.equals("SECURITY_RUNTIME") || this._eventType.equals("SECURITY_RUNTIME_KEY") || this._eventType.equals("SECURITY_SIGNING"))) {
            throw new GenericEventValidationException();
        }
    }

    public Object buildEvent(HashMap properties) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        this._eventType = (String)properties.get("EVENT_TYPE");
        try {
            this.validate();
        }
        catch (GenericEventValidationException e) {
            throw new GenericEventValidationException(e);
        }
        this._seq = 0;
        this.auditEvent = new HashMap();
        this.auditEvent.put("EVENT_TYPE", this._eventType);
        this.auditEvent.put("Seq", this._seq);
        this.auditEvent.putAll(properties);
        return this.auditEvent;
    }

    public String buildEventString(HashMap properties) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        boolean verbose = false;
        String auditReportGranularity = null;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildEventString: " + properties.toString());
        }
        if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "AuditService was not initialized");
        }
        verbose = auditService != null ? auditService.isVerbose() : SecurityObjectLocator.getAuditConfig().getBoolean("verbose");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "verbose mode: " + verbose);
        }
        auditReportGranularity = SecurityObjectLocator.getAuditConfig().getString("com.ibm.audit.report.granularity");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditReportGranularity: " + auditReportGranularity);
        }
        this._eventType = (String)properties.get("EVENT_TYPE");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_eventType: " + this._eventType);
        }
        try {
            this.validate();
        }
        catch (GenericEventValidationException e) {
            throw new GenericEventValidationException(e);
        }
        this._seq = (Integer)properties.get("Seq");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Seq: " + this._seq.toString() + "_eventType: " + this._eventType);
        }
        this._outcome = (String)properties.get("OutcomeResult");
        this._outcomeReason = (String)properties.get("OutcomeFailureReason");
        this._outcomeReasonCode = (Long)properties.get("OutcomeReason");
        this._sessionId = (String)properties.get("SessionId");
        if (!auditReportGranularity.equals("high")) {
            this._remoteHost = (String)properties.get("RemoteHost");
            if (auditReportGranularity.equals("low")) {
                this._remoteAddr = (String)properties.get("RemoteAddr");
                this._remotePort = (String)properties.get("RemotePort");
            }
        }
        this._progName = (String)properties.get("ProgName");
        this._action = (String)properties.get("Action");
        this._appUserName = (String)properties.get("AppUserName");
        this._resourceName = (String)properties.get("NameInApp");
        if (!auditReportGranularity.equals("high")) {
            this._accessDecision = (String)properties.get("AccessDecision");
            this._registryUserName = (String)properties.get("RegistryUserName");
            if (auditReportGranularity.equals("low")) {
                this._resourceType = (String)properties.get("ResourceType");
                this._resourceUniqueId = (Long)properties.get("ResourceUniqueId");
                this._permissionsChecked = (String[])properties.get("PermissionsChecked");
                this._permissionsGranted = (String[])properties.get("PermissionsGranted");
                this._rolesChecked = (String[])properties.get("RolesChecked");
                this._rolesGranted = (String[])properties.get("RolesGranted");
            }
        }
        this._creationTime = (Date)properties.get("CreationTime");
        if (!auditReportGranularity.equals("high")) {
            this._globalInstanceId = (Long)properties.get("GlobalInstanceId");
            if (auditReportGranularity.equals("low")) {
                this._lastEventTrailId = (String)properties.get("LastEventTrailId");
                this._eventTrailId = (String[])properties.get("EventTrailId");
            }
        }
        this._firstCaller = (String)properties.get("FirstCaller");
        if (!auditReportGranularity.equals("high") && verbose) {
            this._callerList = (String[])properties.get("CallerList");
        }
        if (!auditReportGranularity.equals("high")) {
            if (verbose) {
                this._domain = (String)properties.get("Domain");
            }
            this._realm = (String)properties.get("Realm");
        }
        this._registryType = (String)properties.get("RegistryType");
        if (!auditReportGranularity.equals("high")) {
            this._authnType = (String)properties.get("AuthnType");
        }
        this._identityName = (String)properties.get("IdentityName");
        if (!auditReportGranularity.equals("high")) {
            this._delegationType = (String)properties.get("DelegationType");
            if (auditReportGranularity.equals("low")) {
                this._roleName = (String)properties.get("RoleName");
            }
        }
        this._mappedUserName = (String)properties.get("MappedUserName");
        if (!auditReportGranularity.equals("high")) {
            this._mappedRealm = (String)properties.get("MappedRealm");
            if (auditReportGranularity.equals("low")) {
                this._mappedSecurityDomain = (String)properties.get("MappedSecurityDomain");
            }
        }
        this._terminateReason = (String)properties.get("TerminateReason");
        if (!auditReportGranularity.equals("high")) {
            this._provider = (String)properties.get("Provider");
            if (auditReportGranularity.equals("low")) {
                this._providerStatus = (String)properties.get("ProviderStatus");
            }
        }
        if (!auditReportGranularity.equals("high")) {
            this._policyName = (String)properties.get("PolicyName");
            if (auditReportGranularity.equals("low")) {
                this._policyType = (String)properties.get("PolicyType");
            }
        }
        this._keyLabel = (String)properties.get("KeyLabel");
        if (!auditReportGranularity.equals("high")) {
            this._keyLocation = (String)properties.get("KeyLocation");
            if (auditReportGranularity.equals("low")) {
                this._certLifetime = (Date)properties.get("CertLifetime");
            }
        }
        this._mgmtType = (String)properties.get("MgmtType");
        if (!auditReportGranularity.equals("high")) {
            this._mgmtCommand = (String)properties.get("MgmtCommand");
            if (auditReportGranularity.equals("low") && verbose) {
                this._targetInfoAttributes = (TargetAttributes[])properties.get("TargetInfoAttributes");
            }
        }
        this._url = (String)properties.get("Url");
        if (!auditReportGranularity.equals("high") && verbose) {
            this._httpRequestHeaders = (Attributes[])properties.get("HttpRequestHeaders");
            this._httpResponseHeaders = (Attributes[])properties.get("HttpResponseHeaders");
        }
        if (!properties.isEmpty()) {
            int size = properties.size();
            Set thisSet = properties.entrySet();
            Iterator thisIter = thisSet.iterator();
            int propertyNum = 0;
            while (thisIter.hasNext()) {
                Map.Entry thisEntry = thisIter.next();
                Object thisKey = thisEntry.getKey();
                String k = (String)thisKey;
                if (!k.startsWith("Extended_")) continue;
                Object thisValue = thisEntry.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom property[" + propertyNum + "]: key = " + thisKey.toString() + " value = " + thisValue.toString());
                }
                this.customKeys[propertyNum] = k.substring(9);
                this.customValues[propertyNum++] = thisValue.toString();
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; i < propertyNum; ++i) {
                    Tr.debug(tc, "customKeys[" + i + "]: " + this.customKeys[i]);
                    Tr.debug(tc, "  customValues[" + i + "]: " + this.customValues[i]);
                }
            }
            this.customDataSize = propertyNum;
        }
        StringBuilder st = new StringBuilder(1000);
        st = st.append("Seq = " + this._seq.toString() + " | ");
        st = st.append("Event Type = " + this._eventType + " | ");
        st = st.append("Outcome = " + this._outcome + " | ");
        st = st.append("OutcomeReason = " + this._outcomeReason + " | ");
        st = st.append("OutcomeReasonCode = " + new Long(this._outcomeReasonCode).toString() + " | ");
        st = st.append("SessionId = " + this._sessionId + " | ");
        if (!auditReportGranularity.equals("high")) {
            st = st.append("RemoteHost = " + this._remoteHost + " | ");
            if (auditReportGranularity.equals("low")) {
                st = st.append("RemoteAddr = " + this._remoteAddr + " | ");
                st = st.append("RemotePort = " + this._remotePort + " | ");
            }
        }
        st = st.append("ProgName = " + this._progName + " | ");
        st = st.append("Action = " + this._action + " | ");
        st = st.append("AppUserName = " + this._appUserName + " | ");
        st = st.append("ResourceName = " + this._resourceName + " | ");
        if (!auditReportGranularity.equals("high")) {
            st = st.append("RegistryUserName = " + this._registryUserName + " | ");
            st = st.append("AccessDecision = " + this._accessDecision + " | ");
            if (auditReportGranularity.equals("low")) {
                st = st.append("ResourceType = " + this._resourceType + " | ");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resourceUniqueId: " + this._resourceUniqueId);
                }
                st = this._resourceUniqueId == null ? st.append("ResourceUniqueId = null") : st.append("ResourceUniqueId = " + this._resourceUniqueId.toString() + " | ");
                st = st.append("PermissionsChecked = ");
                if (this._permissionsChecked != null) {
                    for (int i = 0; i < this._permissionsChecked.length; ++i) {
                        st = i < this._permissionsChecked.length - 1 ? st.append(this._permissionsChecked[i] + " , ") : st.append(this._permissionsChecked[i]);
                    }
                } else {
                    st = st.append("null");
                }
                st = st.append(" | ");
                st = st.append("PermissionsGranted = ");
                if (this._permissionsGranted != null) {
                    for (int i = 0; i < this._permissionsGranted.length; ++i) {
                        st = i < this._permissionsGranted.length - 1 ? st.append(this._permissionsGranted[i] + " , ") : st.append(this._permissionsGranted[i]);
                    }
                } else {
                    st = st.append("null");
                }
                st = st.append(" | ");
                st = st.append("RolesChecked = ");
                if (this._rolesChecked != null) {
                    for (int i = 0; i < this._rolesChecked.length; ++i) {
                        st = i < this._rolesChecked.length - 1 ? st.append(this._rolesChecked[i] + " , ") : st.append(this._rolesChecked[i]);
                    }
                } else {
                    st = st.append("null");
                }
                st = st.append(" | ");
                st = st.append("RolesGranted = ");
                if (this._rolesGranted != null) {
                    for (int i = 0; i < this._rolesGranted.length; ++i) {
                        st = i < this._rolesGranted.length - 1 ? st.append(this._rolesGranted[i] + " , ") : st.append(this._rolesGranted[i]);
                    }
                } else {
                    st = st.append("null");
                }
            }
        }
        st = st.append(" | ");
        st = st.append("CreationTime = " + this._creationTime.toString() + " | ");
        if (!auditReportGranularity.equals("high")) {
            st = st.append("GlobalInstanceId = " + this._globalInstanceId.toString() + " | ");
            if (auditReportGranularity.equals("low")) {
                if (verbose) {
                    st = this._lastEventTrailId == null ? st.append("LastEventTrailId = null | ") : st.append("LastEventTrailId = " + this._lastEventTrailId + " | ");
                }
                st = st.append("EventTrailId = ");
                st = this._lastEventTrailId == null || this._lastEventTrailId.length() == 0 ? st.append("null") : st.append(this._lastEventTrailId);
            }
        }
        st = st.append(" | ");
        if (this._firstCaller != null) {
            st = st.append("FirstCaller = " + this._firstCaller + " | ");
        }
        if (!auditReportGranularity.equals("high") && verbose) {
            st = st.append("CallerList = ");
            if (this._callerList != null) {
                for (int i = 0; i < this._callerList.length; ++i) {
                    st = i < this._callerList.length - 1 ? st.append(this._callerList[i] + " , ") : st.append(this._callerList[i]);
                }
            } else {
                st = st.append("null");
            }
            st = st.append(" | ");
        }
        if (!auditReportGranularity.equals("high")) {
            if (verbose) {
                st = st.append("Domain = " + this._domain + " | ");
            }
            st = st.append("Realm = " + this._realm + " | ");
        }
        st = st.append("RegistryType = " + this._registryType + " | ");
        if (!auditReportGranularity.equals("high") && (this._eventType.equals("SECURITY_AUTHN") || this._eventType.equals("SECURITY_AUTHN_TERMINATE"))) {
            st = st.append("AuthnType = " + this._authnType + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHN_DELEGATION")) {
            st = st.append("IdentityName = " + this._identityName + " | ");
            if (!auditReportGranularity.equals("high")) {
                st = st.append("DelegationType = " + this._delegationType + " | ");
                if (auditReportGranularity.equals("low")) {
                    st = st.append("RoleName = " + this._roleName + " | ");
                }
            }
        }
        if (this._eventType.equals("SECURITY_AUTHN_MAPPING")) {
            st = st.append("MappedUserName = " + this._mappedUserName + " | ");
            if (!auditReportGranularity.equals("high")) {
                st = st.append("MappedRealm = " + this._mappedRealm + " | ");
                if (auditReportGranularity.equals("low")) {
                    st = st.append("MappedSecurityDomain = " + this._mappedSecurityDomain + " | ");
                }
            }
        }
        if (this._eventType.equals("SECURITY_AUTHN_TERMINATE")) {
            st = st.append("TerminateReason = " + this._terminateReason + " | ");
        }
        if (!auditReportGranularity.equals("high") && (this._eventType.equals("SECURITY_AUTHN") || this._eventType.equals("SECURITY_AUTHN_MAPPING") || this._eventType.equals("SECURITY_AUTHN_TERMINATE") || this._eventType.equals("SECURITY_AUTHZ"))) {
            st = st.append("Provider = " + this._provider + " | ");
            if (auditReportGranularity.equals("low")) {
                st = st.append("ProviderStatus = " + this._providerStatus + " | ");
            }
        }
        if (!auditReportGranularity.equals("high") && (this._eventType.equals("SECURITY_AUTHZ") || this._eventType.equals("SECURITY_MGMT_POLICY"))) {
            st = st.append("PolicyName = " + this._policyName + " | ");
            if (auditReportGranularity.equals("low")) {
                st = st.append("PolicyType = " + this._policyType + " | ");
            }
        }
        if (this._eventType.equals("SECURITY_ENCRYPTION") || this._eventType.equals("SECURITY_MGMT_KEY") || this._eventType.equals("SECURITY_RUNTIME_KEY") || this._eventType.equals("SECURITY_SIGNING")) {
            st = st.append("KeyLabel = " + this._keyLabel + " | ");
            if (!auditReportGranularity.equals("high")) {
                st = st.append("KeyLocation = " + this._keyLocation + " | ");
                if (auditReportGranularity.equals("low")) {
                    st = this._certLifetime != null ? st.append("CertLifetime = " + this._certLifetime.toString() + " | ") : st.append("CertLifetime = null | ");
                }
            }
        }
        if (this._eventType.equals("SECURITY_MGMT_AUDIT") || this._eventType.equals("SECURITY_MGMT_CONFIG") || this._eventType.equals("SECURITY_MGMT_KEY") || this._eventType.equals("SECURITY_MGMT_POLICY") || this._eventType.equals("SECURITY_MGMT_PROVISIONING") || this._eventType.equals("SECURITY_MGMT_REGISTRY") || this._eventType.equals("SECURITY_MGMT_RESOURCE")) {
            st = st.append("MgmtType = " + this._mgmtType + " | ");
            if (!auditReportGranularity.equals("high")) {
                st = st.append("MgmtCommand = " + this._mgmtCommand + " | ");
                if (auditReportGranularity.equals("low") && verbose && this._targetInfoAttributes != null) {
                    for (int i = 0; i < this._targetInfoAttributes.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "i: " + i);
                        }
                        if (this._targetInfoAttributes[i] == null) {
                            Tr.debug(tc, "_targetInfoAttributes is null");
                            break;
                        }
                        st = st.append("TargetInfoName = " + this._targetInfoAttributes[i].getName() + " | ");
                        st = st.append("TargetInfoUniqueId = " + this._targetInfoAttributes[i].getUniqueId() + " | ");
                    }
                }
            }
        }
        if (this._eventType.equals("SECURITY_RESOURCE_ACCESS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "eventType is a Resource_Access");
            }
            st = st.append("Url = " + this._url + " | ");
            if (!auditReportGranularity.equals("high")) {
                if (verbose) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "verbose mode on");
                    }
                    if (this._httpRequestHeaders != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "_httpRequestHeaders not null, length: " + this._httpRequestHeaders.length);
                        }
                        for (int i = 0; i < this._httpRequestHeaders.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "i: " + i);
                            }
                            if (this._httpRequestHeaders[i] == null) {
                                Tr.debug(tc, "_httpRequestHeaders is null");
                                break;
                            }
                            if (this._httpRequestHeaders[i].getName() == null) {
                                Tr.debug(tc, "_httpRequestHeaders.getName() is null");
                            }
                            st = this._httpRequestHeaders[i].getName() != null ? st.append("ReqHeaderName = " + this._httpRequestHeaders[i].getName() + " | ") : st.append("ReqHeaderName = null | ");
                            if (this._httpRequestHeaders[i].getValue() == null) {
                                Tr.debug(tc, "_httpRequestHeaders.getValue() is null");
                            }
                            st = this._httpRequestHeaders[i].getValue() != null ? st.append("ReqHeaderValue = " + this._httpRequestHeaders[i].getValue() + " | ") : st.append("ReqHeaderValue = null | ");
                            if (this._httpRequestHeaders[i].getSource() == null) {
                                Tr.debug(tc, "_httpRequestHeaders.getSource() is null");
                            }
                            st = this._httpRequestHeaders[i].getSource() != null ? st.append("ReqHeaderSrc = " + this._httpRequestHeaders[i].getSource() + " | ") : st.append("ReqHeaderSrc = null | ");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "_httpRequestHeaders null");
                    }
                    if (this._httpResponseHeaders != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "_httpResponseHeaders not null, length: " + this._httpResponseHeaders.length);
                        }
                        for (int i = 0; i < this._httpResponseHeaders.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "i: " + i);
                            }
                            if (this._httpResponseHeaders[i] == null) {
                                Tr.debug(tc, "_httpResponseHeaders is null");
                                break;
                            }
                            if (this._httpResponseHeaders[i].getName() == null) {
                                Tr.debug(tc, "_httpResponseHeaders.getName() is null");
                            }
                            st = this._httpResponseHeaders[i].getName() != null ? st.append("ResHeaderName = " + this._httpResponseHeaders[i].getName() + " | ") : st.append("ResHeaderName = null | ");
                            if (this._httpResponseHeaders[i].getValue() == null) {
                                Tr.debug(tc, "_httpResponseHeaders.getValue() is null");
                            }
                            st = this._httpResponseHeaders[i].getValue() != null ? st.append("ResHeaderValue = " + this._httpResponseHeaders[i].getValue() + " | ") : st.append("ResHeaderValue = null | ");
                            if (this._httpResponseHeaders[i].getSource() == null) {
                                Tr.debug(tc, "_httpResponseHeaders.getSource() is null");
                            }
                            st = this._httpResponseHeaders[i].getSource() != null ? st.append("ResHeaderSrc = " + this._httpResponseHeaders[i].getSource() + " | ") : st.append("ResHeaderSrc = null | ");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "_httpResponseHeaders null");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "verbose mode off");
                }
            }
        }
        if (this.customDataSize != 0) {
            for (int i = 0; i < this.customDataSize; ++i) {
                st = st.append(this.customKeys[i] + " = " + this.customValues[i] + " | ");
            }
        }
        if (st.toString().endsWith(" | ")) {
            int startIndex = st.lastIndexOf(" | ");
            st.delete(startIndex, st.length());
        }
        st = st.append("\n");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildEventAsString: " + st.toString());
        }
        return st.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", s);
        }
        if (tc.isDebugEnabled()) {
            if (s == null) {
                Tr.debug(tc, "s is null");
            } else {
                Tr.debug(tc, "s is not null");
            }
        }
        ObjectOutputStream.PutField fields = s.putFields();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_eventType = " + this._eventType);
        }
        fields.put("_seq", this._seq);
        fields.put("_eventType", this._eventType);
        fields.put("_outcome", this._outcome);
        fields.put("_outcomeReason", this._outcomeReason);
        fields.put("_outcomeReasonCode", this._outcomeReasonCode);
        fields.put("_sessionId", this._sessionId);
        fields.put("_remoteAddr", this._remoteAddr);
        fields.put("_remotePort", this._remotePort);
        fields.put("_remoteHost", this._remoteHost);
        fields.put("_progName", this._progName);
        fields.put("_action", this._action);
        fields.put("_registryUserName", this._registryUserName);
        fields.put("_appUserName", this._appUserName);
        fields.put("_accessDecision", this._accessDecision);
        fields.put("_resourceName", this._resourceName);
        fields.put("_resourceType", this._resourceType);
        fields.put("_resourceUniqueId", this._resourceUniqueId);
        fields.put("_permissionsChecked", this._permissionsChecked);
        fields.put("_permissionsGranted", this._permissionsGranted);
        fields.put("_rolesChecked", this._rolesChecked);
        fields.put("_rolesGranted", this._rolesGranted);
        fields.put("_lastEventTrailId", this._lastEventTrailId);
        fields.put("_eventTrailId", this._eventTrailId);
        fields.put("_creationTime", this._creationTime);
        fields.put("_globalInstanceId", this._globalInstanceId);
        fields.put("_firstCaller", this._firstCaller);
        fields.put("_callerList", this._callerList);
        fields.put("_domain", this._domain);
        fields.put("_realm", this._realm);
        fields.put("_registryType", this._registryType);
        fields.put("_authnType", this._authnType);
        fields.put("_delegationType", this._delegationType);
        fields.put("_roleName", this._roleName);
        fields.put("_identityName", this._identityName);
        fields.put("_mappedSecurityDomain", this._mappedSecurityDomain);
        fields.put("_mappedRealm", this._mappedRealm);
        fields.put("_mappedUserName", this._mappedUserName);
        fields.put("_terminateReason", this._terminateReason);
        fields.put("_providerName", this._provider);
        fields.put("_providerStatus", this._providerStatus);
        fields.put("_policyName", this._policyName);
        fields.put("_policyType", this._policyType);
        fields.put("_keyLabel", this._keyLabel);
        fields.put("_keyLocation", this._keyLocation);
        fields.put("_certLifetime", this._certLifetime);
        fields.put("_mgmtType", this._mgmtType);
        fields.put("_mgmtCommand", this._mgmtCommand);
        fields.put("_targetInfoAttributes", this._targetInfoAttributes);
        fields.put("_url", this._url);
        fields.put("_httpRequestHeaders", this._httpRequestHeaders);
        fields.put("_httpResponseHeaders", this._httpResponseHeaders);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "before writeFields");
        }
        s.writeFields();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after writeFields");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", s);
        }
        ObjectInputStream.GetField fields = s.readFields();
        this._seq = (Integer)fields.get("_seq", new Integer(0));
        this._eventType = (String)fields.get("_eventType", null);
        this._outcome = (String)fields.get("_outcome", null);
        this._outcomeReason = (String)fields.get("_outcomeReason", null);
        this._outcomeReasonCode = fields.get("_outcomeReasonCode", -1);
        this._sessionId = (String)fields.get("_sessionId", null);
        this._remoteAddr = (String)fields.get("_remoteAddr", null);
        this._remotePort = (String)fields.get("_remotePort", null);
        this._remoteHost = (String)fields.get("_remoteHost", null);
        this._progName = (String)fields.get("_progName", null);
        this._action = (String)fields.get("_action", null);
        this._registryUserName = (String)fields.get("_registryUserName", null);
        this._appUserName = (String)fields.get("_appUserName", null);
        this._accessDecision = (String)fields.get("_accessDecision", null);
        this._resourceName = (String)fields.get("_resourceName", null);
        this._resourceType = (String)fields.get("_resourceType", null);
        this._resourceUniqueId = (Long)fields.get("_resourceUniqueId", new Long(0L));
        this._permissionsChecked = (String[])fields.get("_permissionsChecked", null);
        this._permissionsGranted = (String[])fields.get("_permissionsGranted", null);
        this._rolesChecked = (String[])fields.get("_rolesChecked", null);
        this._rolesGranted = (String[])fields.get("_rolesGranted", null);
        this._lastEventTrailId = (String)fields.get("_lastEventTrailId", null);
        this._eventTrailId = (String[])fields.get("_eventTrailId", null);
        this._creationTime = (Date)fields.get("_creationTime", null);
        this._globalInstanceId = (Long)fields.get("_globalInstanceId", null);
        this._firstCaller = (String)fields.get("_firstCaller", null);
        this._callerList = (String[])fields.get("_callerList", null);
        this._domain = (String)fields.get("_domain", null);
        this._realm = (String)fields.get("_realm", null);
        this._registryType = (String)fields.get("_registryType", null);
        this._authnType = (String)fields.get("_authnType", null);
        this._delegationType = (String)fields.get("_delegationType", null);
        this._roleName = (String)fields.get("_roleName", null);
        this._identityName = (String)fields.get("_identityName", null);
        this._mappedSecurityDomain = (String)fields.get("_mappedSecurityDomain", null);
        this._mappedRealm = (String)fields.get("_mappedRealm", null);
        this._mappedUserName = (String)fields.get("_mappedUserName", null);
        this._terminateReason = (String)fields.get("_terminateReason", null);
        this._provider = (String)fields.get("_providerName", null);
        this._providerStatus = (String)fields.get("_providerStatus", null);
        this._policyName = (String)fields.get("_policyName", null);
        this._policyType = (String)fields.get("_policyType", null);
        this._keyLabel = (String)fields.get("_keyLabel", null);
        this._keyLocation = (String)fields.get("_keyLocation", null);
        this._certLifetime = (Date)fields.get("_certLifetime", null);
        this._mgmtType = (String)fields.get("_mgmtType", null);
        this._mgmtCommand = (String)fields.get("_mgmtCommand", null);
        this._targetInfoAttributes = (TargetAttributes[])fields.get("_targetInfoAttributes", null);
        this._url = (String)fields.get("_url", null);
        this._httpRequestHeaders = (Attributes[])fields.get("_httpRequestHeaders", null);
        this._httpResponseHeaders = (Attributes[])fields.get("_httpResponseHeaders", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String printAsString() {
        int i;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "printAsString");
        }
        String st = new String("Seq = " + this._seq.toString() + " | ");
        st = st.concat("Event Type = " + this._eventType + " | ");
        if (this._eventType == null) {
            Tr.debug(tc, "_eventType is null");
        } else {
            Tr.debug(tc, "_eventType: " + this._eventType);
        }
        st = st.concat("Outcome = " + this._outcome + " | ");
        if (this._outcome == null) {
            Tr.debug(tc, "_outcome is null");
        } else {
            Tr.debug(tc, "_outcome: " + this._outcome);
        }
        st = st.concat("OutcomeReason = " + this._outcomeReason + " | ");
        st = st.concat("OutcomeReasonCode = " + new Long(this._outcomeReasonCode).toString() + " | ");
        st = st.concat("SessionId = " + this._sessionId + " | ");
        st = st.concat("RemoteAddr = " + this._remoteAddr + " | ");
        st = st.concat("RemotePort = " + this._remotePort + " | ");
        st = st.concat("RemoteHost = " + this._remoteHost + " | ");
        st = st.concat("ProgName = " + this._progName + " | ");
        if (this._progName == null) {
            Tr.debug(tc, "_progName is null");
        } else {
            Tr.debug(tc, "_progName: " + this._progName);
        }
        st = st.concat("Action = " + this._action + " | ");
        st = st.concat("RegistryUserName = " + this._registryUserName + " | ");
        st = st.concat("AppUserName = " + this._appUserName + " | ");
        st = st.concat("AccessDecision = " + this._accessDecision + " | ");
        st = st.concat("ResourceName = " + this._resourceName + " | ");
        st = st.concat("ResourceType = " + this._resourceType + " | ");
        st = st.concat("ResourceUniqueId = " + this._progName + " | ");
        st = st.concat("PermissionsChecked = " + this._permissionsChecked + " | ");
        st = st.concat("PermissionsGranted = " + this._permissionsGranted + " | ");
        st = st.concat("RolesChecked = " + this._rolesChecked + " | ");
        st = st.concat("RolesGranted = " + this._rolesGranted + " | ");
        st = st.concat("LastEventTrailId = " + this._lastEventTrailId + " | ");
        st = st.concat("EventTrailId = " + this._eventTrailId + " | ");
        if (this._creationTime == null) {
            Tr.debug(tc, "CREATIONTIME NULL");
        }
        st = st.concat("CreationTime = " + this._creationTime.toString() + " | ");
        st = st.concat("GlobalInstanceId = " + this._globalInstanceId.toString() + " | ");
        st = st.concat("FirstCaller = " + this._firstCaller + " | ");
        st = st.concat("CallerList = " + this._callerList + " | ");
        st = st.concat("Domain = " + this._domain + " | ");
        st = st.concat("Realm = " + this._realm + " | ");
        st = st.concat("RegistryType = " + this._registryType + " | ");
        if (this._eventType.equals("SECURITY_AUTHN") || this._eventType.equals("SECURITY_AUTHN_TERMINATE")) {
            st = st.concat("AuthnType = " + this._authnType + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHN_DELEGATION")) {
            st = st.concat("DelegationType = " + this._delegationType + " | ");
            st = st.concat("RoleName = " + this._roleName + " | ");
            st = st.concat("IdentityName = " + this._identityName + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHN_MAPPING")) {
            st = st.concat("MappedSecurityDomain = " + this._mappedSecurityDomain + " | ");
            st = st.concat("MappedRealm = " + this._mappedRealm + " | ");
            st = st.concat("MappedUserName = " + this._mappedUserName + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHN_TERMINATE")) {
            st = st.concat("TerminateReason = " + this._terminateReason + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHN") || this._eventType.equals("SECURITY_AUTHN_MAPPING") || this._eventType.equals("SECURITY_AUTHN_TERMINATE") || this._eventType.equals("SECURITY_AUTHZ")) {
            st = st.concat("Provider = " + this._provider + " | ");
            st = st.concat("ProviderStatus = " + this._providerStatus + " | ");
        }
        if (this._eventType.equals("SECURITY_AUTHZ") || this._eventType.equals("SECURITY_MGMT_POLICY")) {
            st = st.concat("PolicyName = " + this._policyName + " | ");
            st = st.concat("PolicyType = " + this._policyType + " | ");
        }
        if (this._eventType.equals("SECURITY_ENCRYPTION") || this._eventType.equals("SECURITY_MGMT_KEY") || this._eventType.equals("SECURITY_RUNTIME_KEY") || this._eventType.equals("SECURITY_SIGNING")) {
            st = st.concat("KeyLabel = " + this._keyLabel + " | ");
            st = st.concat("KeyLocation = " + this._keyLocation + " | ");
            st = this._certLifetime != null ? st.concat("CertLifetime = " + this._certLifetime.toString() + " | ") : st.concat("CertLifetime = null | ");
        }
        if (this._eventType.equals("SECURITY_MGMT_AUDIT") || this._eventType.equals("SECURITY_MGMT_CONFIG") || this._eventType.equals("SECURITY_MGMT_KEY") || this._eventType.equals("SECURITY_MGMT_POLICY") || this._eventType.equals("SECURITY_MGMT_PROVISIONING") || this._eventType.equals("SECURITY_MGMT_REGISTRY") || this._eventType.equals("SECURITY_MGMT_RESOURCE")) {
            st = st.concat("MgmtType = " + this._mgmtType + " | ");
            st = st.concat("MgmtCommand = " + this._mgmtCommand + " | ");
            if (this._targetInfoAttributes != null) {
                for (i = 0; i < this._targetInfoAttributes.length; ++i) {
                    st = st.concat("TargetInfoName = " + this._targetInfoAttributes[i].getName() + " | ");
                    st = st.concat("TargetInfoUniqueId = " + this._targetInfoAttributes[i].getUniqueId() + " | ");
                }
            }
        }
        if (this._eventType.equals("SECURITY_RESOURCE_ACCESS")) {
            st = st.concat("Url = " + this._url + " | ");
            if (this._httpRequestHeaders != null) {
                for (i = 0; i < this._httpRequestHeaders.length; ++i) {
                    st = st.concat("ReqHeaderName = " + this._httpRequestHeaders[i].getName() + " | ");
                    st = st.concat("ReqHeaderValue = " + this._httpRequestHeaders[i].getValue() + " | ");
                    st = st.concat("ReqHeaderSrc = " + this._httpRequestHeaders[i].getSource() + " | ");
                }
            }
            if (this._httpResponseHeaders != null) {
                for (i = 0; i < this._httpResponseHeaders.length; ++i) {
                    st = st.concat("ResHeaderName = " + this._httpResponseHeaders[i].getName() + " | ");
                    st = st.concat("ResHeaderValue = " + this._httpResponseHeaders[i].getValue() + " | ");
                    st = st.concat("ResHeaderSrc = " + this._httpResponseHeaders[i].getSource() + " | ");
                }
            }
        }
        st = st.substring(0, st.length() - 2);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildEventAsString: " + st);
        }
        return st;
    }

    public void putSequenceNumber(int sequenceNumber) {
        this._seq = new Integer(sequenceNumber);
    }

    public void putSequenceNumber(HashMap auditEvent, int sequenceNumber) {
        auditEvent.put("Seq", new Integer(sequenceNumber));
    }
}

