/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.audit.AccessContextObj;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.AuthnContextObj;
import com.ibm.ws.security.audit.AuthnMappingContextObj;
import com.ibm.ws.security.audit.AuthnTermContextObj;
import com.ibm.ws.security.audit.CustomPropertyContextObj;
import com.ibm.ws.security.audit.DelegationContextObj;
import com.ibm.ws.security.audit.EventContextObj;
import com.ibm.ws.security.audit.KeyContextObj;
import com.ibm.ws.security.audit.MgmtContextObj;
import com.ibm.ws.security.audit.PolicyContextObj;
import com.ibm.ws.security.audit.ProcessContextObj;
import com.ibm.ws.security.audit.PropagationContextObj;
import com.ibm.ws.security.audit.ProviderContextObj;
import com.ibm.ws.security.audit.RegistryContextObj;
import com.ibm.ws.security.audit.ResponseContextObj;
import com.ibm.ws.security.audit.SessionContextObj;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContextHandlerImpl
implements ContextHandler {
    private static final TraceComponent tc = Tr.register(ContextHandlerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private SessionContextObj _sessionContextObj = null;
    private PropagationContextObj _propagationContextObj = null;
    private RegistryContextObj _registryContextObj = null;
    private ProcessContextObj _processContextObj = null;
    private DelegationContextObj _delegationContextObj = null;
    private AuthnContextObj _authnContextObj = null;
    private AuthnMappingContextObj _authnMappingContextObj = null;
    private AuthnTermContextObj _authnTermContextObj = null;
    private AccessContextObj _accessContextObj = null;
    private EventContextObj _eventContextObj = null;
    private ProviderContextObj _providerContextObj = null;
    private PolicyContextObj _policyContextObj = null;
    private KeyContextObj _keyContextObj = null;
    private MgmtContextObj _mgmtContextObj = null;
    private ResponseContextObj _responseContextObj = null;
    private CustomPropertyContextObj _customPropertyContextObj = null;
    private static final AuditConfig audit = SecurityObjectLocator.getAuditConfig();
    private static final String auditReportGranularity = audit.getString("com.ibm.audit.report.granularity");

    public ContextHandlerImpl() throws WSSecurityException {
        this.initialize();
    }

    public void initialize() throws WSSecurityException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "on entry to ContextHandlerImpl.initialize(): ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
        }
        this._sessionContextObj = new SessionContextObj();
        this._propagationContextObj = new PropagationContextObj();
        this._registryContextObj = new RegistryContextObj();
        this._processContextObj = new ProcessContextObj();
        this._delegationContextObj = new DelegationContextObj();
        this._authnContextObj = new AuthnContextObj();
        this._authnMappingContextObj = new AuthnMappingContextObj();
        this._authnTermContextObj = new AuthnTermContextObj();
        this._accessContextObj = new AccessContextObj();
        this._eventContextObj = new EventContextObj();
        this._providerContextObj = new ProviderContextObj();
        this._policyContextObj = new PolicyContextObj();
        this._keyContextObj = new KeyContextObj();
        this._mgmtContextObj = new MgmtContextObj();
        this._responseContextObj = new ResponseContextObj();
        this._customPropertyContextObj = new CustomPropertyContextObj();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after new upping new context objects: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            Tr.exit(tc, "initialize");
        }
    }

    public void buildContextObject(String auditContextObjType, HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildContextObject: contextObjType: " + auditContextObjType + " with data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
        }
        if (auditContextObjType.equalsIgnoreCase("SESSION_CONTEXT")) {
            this.buildSessionContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("PROPAGATION_CONTEXT")) {
            this.buildPropagationContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("REGISTRY_CONTEXT")) {
            this.buildRegistryContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("PROCESS_CONTEXT")) {
            this.buildProcessContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("APPLICATION_DELEGATION")) {
            this.buildDelegationContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_CONTEXT")) {
            this.buildAuthnContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_PROVIDER_CONTEXT")) {
            this.buildProviderContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_MAPPING_CONTEXT")) {
            this.buildAuthnMappingContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("AUTHN_TERM_CONTEXT")) {
            this.buildAuthnTermContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("ACCESS_CONTEXT")) {
            this.buildAccessContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("EVENT_CONTEXT")) {
            this.buildEventContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("POLICY_CONTEXT")) {
            this.buildPolicyContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("KEY_CONTEXT")) {
            this.buildKeyContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("MGMT_CONTEXT")) {
            this.buildMgmtContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("RESPONSE_CONTEXT")) {
            this.buildResponseContext(data);
        } else if (auditContextObjType.equalsIgnoreCase("CUSTOM_PROPERTY_CONTEXT")) {
            this.buildCustomPropertyContext(data);
        }
    }

    public void buildCustomPropertyContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildCustomPropertyContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._customPropertyContextObj != null) {
                Tr.debug(tc, "TEQ: _customPropertyContextObj has data before build: " + this._customPropertyContextObj.getMap().toString());
            }
        }
        Set dataSet = data.entrySet();
        for (Map.Entry mapEntry : dataSet) {
            String key = mapEntry.getKey().toString();
            if (mapEntry.getValue() != null) {
                this._customPropertyContextObj.setEntry(key, mapEntry.getValue());
                continue;
            }
            this._customPropertyContextObj.setEntry(key, "null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building custom property context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _customPropertyContextObj: " + this._customPropertyContextObj.getMap().toString());
        }
    }

    public void buildSessionContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildSessionContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            if (this._sessionContextObj != null) {
                Tr.debug(tc, "TEQ: _sessionContextObj has data before build: " + this._sessionContextObj.getMap().toString());
            }
        }
        if (data.get("SessionId") != null) {
            this._sessionContextObj.setSessionId((String)data.get("SessionId"));
        } else {
            this._sessionContextObj.setSessionId("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("RemoteHost") != null) {
                this._sessionContextObj.setRemoteHost((String)data.get("RemoteHost"));
            } else {
                this._sessionContextObj.setRemoteHost("null");
            }
        }
        if (auditReportGranularity.equals("low")) {
            if (data.get("RemoteAddr") != null) {
                this._sessionContextObj.setRemoteAddr((String)data.get("RemoteAddr"));
            } else {
                this._sessionContextObj.setRemoteAddr("null");
            }
            if (data.get("RemotePort") != null) {
                this._sessionContextObj.setRemotePort((String)data.get("RemotePort"));
            } else {
                this._sessionContextObj.setRemotePort("null");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building session context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            Tr.debug(tc, "     _sessionContextObj: " + this._sessionContextObj.getMap().toString());
        }
    }

    public void buildPropagationContext(HashMap data) {
        WSSecurityPropagationHelper propHelper;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildPropagationContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._propagationContextObj != null) {
                Tr.debug(tc, "TEQ: _propagationContextObj has data before build: " + this._propagationContextObj.getMap().toString());
            }
        }
        if ((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SAP is enabled, gathering propagation context");
            }
            if (data.get("FirstCaller") != null) {
                this._propagationContextObj.setFirstCaller((String)data.get("FirstCaller"));
            } else {
                this._propagationContextObj.setFirstCaller("null");
            }
            if (!auditReportGranularity.equals("high")) {
                if (data.get("CallerList") != null) {
                    this._propagationContextObj.setCallerList((String[])data.get("CallerList"));
                } else {
                    String[] emptyData = new String[]{"null"};
                    this._propagationContextObj.setCallerList(emptyData);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SAP is not enabled, not gathering propagation context");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building propagation context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (!this._propagationContextObj.getMap().isEmpty()) {
                Tr.debug(tc, "     _propagationContextObj: " + this._propagationContextObj.getMap().toString());
            }
        }
    }

    public void buildRegistryContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildRegistryContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._registryContextObj != null) {
                Tr.debug(tc, "TEQ: _registryContextObj has data before build: " + this._registryContextObj.getMap().toString());
            }
        }
        if (data.get("RegistryType") != null) {
            this._registryContextObj.setType((String)data.get("RegistryType"));
        } else {
            this._registryContextObj.setType("null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building registry context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _registryContextObj: " + this._registryContextObj.getMap().toString());
        }
    }

    public void buildProcessContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildProcessContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._processContextObj != null) {
                Tr.debug(tc, "TEQ: _processContextObj has data before build: " + this._processContextObj.getMap().toString());
            }
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("Domain") != null) {
                this._processContextObj.setDomain((String)data.get("Domain"));
            } else {
                this._processContextObj.setDomain("null");
            }
            if (data.get("Realm") != null) {
                this._processContextObj.setRealm((String)data.get("Realm"));
            } else {
                this._processContextObj.setRealm("null");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building process context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _processContextObj: " + this._processContextObj.getMap().toString());
        }
    }

    public void buildDelegationContext(HashMap data) {
        if (data.get("IdentityName") != null) {
            this._delegationContextObj.setIdentityName((String)data.get("IdentityName"));
        } else {
            this._delegationContextObj.setIdentityName("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("DelegationType") != null) {
                this._delegationContextObj.setDelegationType((String)data.get("DelegationType"));
            } else {
                this._delegationContextObj.setDelegationType("null");
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("RoleName") != null) {
                    this._delegationContextObj.setRoleName((String)data.get("RoleName"));
                } else {
                    this._delegationContextObj.setRoleName("null");
                }
            }
        }
    }

    public void buildAuthnContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildAuthnContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._authnContextObj != null) {
                Tr.debug(tc, "TEQ: _authnContextObj has data before build: " + this._authnContextObj.getMap().toString());
            }
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("AuthnType") != null) {
                this._authnContextObj.setAuthnType((String)data.get("AuthnType"));
            } else {
                this._authnContextObj.setAuthnType("null");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building authn context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _authnContextObj: " + this._authnContextObj.getMap().toString());
        }
    }

    public void buildProviderContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildProviderContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._providerContextObj != null) {
                Tr.debug(tc, "TEQ: _providerContextObj has data before build: " + this._providerContextObj.getMap().toString());
            }
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("Provider") != null) {
                this._providerContextObj.setProvider((String)data.get("Provider"));
            } else {
                this._providerContextObj.setProvider("null");
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("ProviderStatus") != null) {
                    this._providerContextObj.setProviderStatus((String)data.get("ProviderStatus"));
                } else {
                    this._providerContextObj.setProviderStatus("null");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building provider context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _providerContextObj: " + this._providerContextObj.getMap().toString());
        }
    }

    public void buildAuthnMappingContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildAuthnMappingContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._authnMappingContextObj != null) {
                Tr.debug(tc, "TEQ: _authnMappingContextObj has data before build: " + this._authnMappingContextObj.getMap().toString());
            }
        }
        if (data.get("MappedUserName") != null) {
            this._authnMappingContextObj.setMappedUserName((String)data.get("MappedUserName"));
        } else {
            this._authnMappingContextObj.setMappedUserName("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("MappedRealm") != null) {
                this._authnMappingContextObj.setMappedRealm((String)data.get("MappedRealm"));
            } else {
                this._authnMappingContextObj.setMappedRealm("null");
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("MappedSecurityDomain") != null) {
                    this._authnMappingContextObj.setMappedSecurityDomain((String)data.get("MappedSecurityDomain"));
                } else {
                    this._authnMappingContextObj.setMappedSecurityDomain("null");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building authn mapping context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _authnMappingContextObj: " + this._authnMappingContextObj.getMap().toString());
        }
    }

    public void buildAuthnTermContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildAuthnTermContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._authnTermContextObj != null) {
                Tr.debug(tc, "TEQ: _authnTermContextObj has data before build: " + this._authnTermContextObj.getMap().toString());
            }
        }
        if (data.get("TerminateReason") != null) {
            this._authnTermContextObj.setTerminateReason((String)data.get("TerminateReason"));
        } else {
            this._authnTermContextObj.setTerminateReason("null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building authn term context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _authnTermContextObj: " + this._authnTermContextObj.getMap().toString());
        }
    }

    public void buildAccessContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildAccessContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            if (this._accessContextObj != null) {
                Tr.debug(tc, "TEQ: _accessContextObj has data before build: " + this._accessContextObj.getMap().toString());
            }
        }
        if (data.get("ProgName") != null) {
            this._accessContextObj.setProgName((String)data.get("ProgName"));
        } else {
            this._accessContextObj.setProgName("null");
        }
        if (data.get("Action") != null) {
            this._accessContextObj.setAction((String)data.get("Action"));
        } else {
            this._accessContextObj.setAction("null");
        }
        if (data.get("AppUserName") != null) {
            this._accessContextObj.setAppUserName((String)data.get("AppUserName"));
        } else {
            this._accessContextObj.setAppUserName("null");
        }
        if (data.get("NameInApp") != null) {
            this._accessContextObj.setNameInApp((String)data.get("NameInApp"));
        } else {
            this._accessContextObj.setNameInApp("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("RegistryUserName") != null) {
                this._accessContextObj.setRegistryUserName((String)data.get("RegistryUserName"));
            } else {
                this._accessContextObj.setRegistryUserName("null");
            }
            if (data.get("AccessDecision") != null) {
                this._accessContextObj.setAccessDecision((String)data.get("AccessDecision"));
            } else {
                this._accessContextObj.setAccessDecision("null");
            }
            if (auditReportGranularity.equals("low")) {
                String[] emptyData;
                if (data.get("ResourceType") != null) {
                    this._accessContextObj.setResourceType((String)data.get("ResourceType"));
                } else {
                    this._accessContextObj.setResourceType("null");
                }
                if (data.get("ResourceUniqueId") != null) {
                    this._accessContextObj.setResourceUniqueId((Long)data.get("ResourceUniqueId"));
                } else {
                    this._accessContextObj.setResourceUniqueId(new Long(0L));
                }
                if (data.get("PermissionsChecked") != null) {
                    this._accessContextObj.setPermissionsChecked((String[])data.get("PermissionsChecked"));
                } else {
                    emptyData = new String[]{"null"};
                    this._accessContextObj.setPermissionsChecked(emptyData);
                }
                if (data.get("PermissionsGranted") != null) {
                    this._accessContextObj.setPermissionsGranted((String[])data.get("PermissionsGranted"));
                } else {
                    emptyData = new String[]{"null"};
                    this._accessContextObj.setPermissionsGranted(emptyData);
                }
                if (data.get("RolesChecked") != null) {
                    this._accessContextObj.setRolesChecked((String[])data.get("RolesChecked"));
                } else {
                    emptyData = new String[]{"null"};
                    this._accessContextObj.setRolesChecked(emptyData);
                }
                if (data.get("RolesGranted") != null) {
                    this._accessContextObj.setRolesGranted((String[])data.get("RolesGranted"));
                } else {
                    emptyData = new String[]{"null"};
                    this._accessContextObj.setRolesGranted(emptyData);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building access context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            Tr.debug(tc, "     _accessContextObj: " + this._accessContextObj.getMap().toString());
        }
    }

    public void buildEventContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildEventContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            if (this._eventContextObj != null) {
                Tr.debug(tc, "TEQ: _eventContextObj has data before build: " + this._eventContextObj.getMap().toString());
            }
        }
        if (data.get("CreationTime") != null) {
            this._eventContextObj.setCreationTime((Date)data.get("CreationTime"));
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("GlobalInstanceId") != null) {
                this._eventContextObj.setGlobalInstanceId((long)((Long)data.get("GlobalInstanceId")));
            } else {
                this._eventContextObj.setGlobalInstanceId(new Long(0L));
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("LastEventTrailId") != null) {
                    this._eventContextObj.setLastEventTrailId((String)data.get("LastEventTrailId"));
                } else {
                    this._eventContextObj.setLastEventTrailId("null");
                }
                if (data.get("EventTrailId") != null) {
                    this._eventContextObj.setEventTrailId((String[])data.get("EventTrailId"));
                } else {
                    String[] emptyData = new String[]{"null"};
                    this._eventContextObj.setEventTrailId(emptyData);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building event context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, " contexthandlerimpl instance: ", new Object[]{this});
            Tr.debug(tc, "     _eventContextObj: " + this._eventContextObj.getMap().toString());
        }
    }

    public void buildPolicyContext(HashMap data) {
        if (!auditReportGranularity.equals("high")) {
            if (data.get("PolicyName") != null) {
                this._policyContextObj.setPolicyName((String)data.get("PolicyName"));
            } else {
                this._policyContextObj.setPolicyName("null");
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("PolicyType") != null) {
                    this._policyContextObj.setPolicyType((String)data.get("PolicyType"));
                } else {
                    this._policyContextObj.setPolicyType("null");
                }
            }
        }
    }

    public void buildKeyContext(HashMap data) {
        if (data.get("KeyLabel") != null) {
            this._keyContextObj.setKeyLabel((String)data.get("KeyLabel"));
        } else {
            this._keyContextObj.setKeyLabel("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("KeyLocation") != null) {
                this._keyContextObj.setKeyLocation((String)data.get("KeyLocation"));
            } else {
                this._keyContextObj.setKeyLocation("null");
            }
            if (auditReportGranularity.equals("low") && data.get("CertLifetime") != null) {
                this._keyContextObj.setCertLifetime((Date)data.get("CertLifetime"));
            }
        }
    }

    public void buildMgmtContext(HashMap data) {
        if (data.get("MgmtType") != null) {
            this._mgmtContextObj.setMgmtType((String)data.get("MgmtType"));
        } else {
            this._mgmtContextObj.setMgmtType("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("MgmtCommand") != null) {
                this._mgmtContextObj.setMgmtCommand((String)data.get("MgmtCommand"));
            } else {
                this._mgmtContextObj.setMgmtCommand("null");
            }
            if (auditReportGranularity.equals("low")) {
                if (data.get("TargetInfoAttributes") != null) {
                    this._mgmtContextObj.setTargetInfoAttributes((TargetAttributes[])data.get("TargetInfoAttributes"));
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "target attributes is null");
                    }
                    TargetAttributes[] ta = new TargetAttributes[1];
                    TargetAttributes cfr_ignored_0 = ta[0];
                    TargetAttributes.name = "null";
                    TargetAttributes cfr_ignored_1 = ta[0];
                    TargetAttributes.uniqueId = 0L;
                    this._mgmtContextObj.setTargetInfoAttributes(ta);
                }
            }
        }
    }

    public void buildResponseContext(HashMap data) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildResponseContext: data: " + data.toString());
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            if (this._responseContextObj != null) {
                Tr.debug(tc, "TEQ: _responseContextObj has data before build: " + this._responseContextObj.getMap().toString());
            }
        }
        if (data.get("Url") != null) {
            this._responseContextObj.setUrl((String)data.get("Url"));
        } else {
            this._responseContextObj.setUrl("null");
        }
        if (!auditReportGranularity.equals("high")) {
            if (data.get("HttpRequestHeaders") != null) {
                this._responseContextObj.setHttpRequestHeaders((Attributes[])data.get("HttpRequestHeaders"));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "http request headers null");
                }
                Attributes[] reqHdrs = new Attributes[1];
                Attributes cfr_ignored_0 = reqHdrs[0];
                Attributes.name = "null";
                Attributes cfr_ignored_1 = reqHdrs[0];
                Attributes.value = "null";
                Attributes cfr_ignored_2 = reqHdrs[0];
                Attributes.source = "null";
                this._responseContextObj.setHttpRequestHeaders(reqHdrs);
            }
            if (data.get("HttpResponseHeaders") != null) {
                this._responseContextObj.setHttpResponseHeaders((Attributes[])data.get("HttpResponseHeaders"));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "http response headers null");
                }
                Attributes[] resHdrs = new Attributes[1];
                Attributes cfr_ignored_3 = resHdrs[0];
                Attributes.name = "null";
                Attributes cfr_ignored_4 = resHdrs[0];
                Attributes.value = "null";
                Attributes cfr_ignored_5 = resHdrs[0];
                Attributes.source = "null";
                this._responseContextObj.setHttpResponseHeaders(resHdrs);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "after building response context: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     _responseContextObj: " + this._responseContextObj.getMap().toString());
        }
    }

    public Object getContextObject(String auditContextObjType) {
        if (auditContextObjType.equalsIgnoreCase("SESSION_CONTEXT")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getContextObj _sessionContextObj: contexthandlerimpl instance: ", new Object[]{this});
            }
            return this._sessionContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("PROPAGATION_CONTEXT")) {
            return this._propagationContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("REGISTRY_CONTEXT")) {
            return this._registryContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("PROCESS_CONTEXT")) {
            return this._processContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("APPLICATION_DELEGATION")) {
            return this._delegationContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_CONTEXT")) {
            return this._authnContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_PROVIDER_CONTEXT")) {
            return this._providerContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_MAPPING_CONTEXT")) {
            return this._authnMappingContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("AUTHN_TERM_CONTEXT")) {
            return this._authnTermContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("ACCESS_CONTEXT")) {
            return this._accessContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("EVENT_CONTEXT")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getContextObj _eventContextObj: contexthandlerimpl instance: ", new Object[]{this});
            }
            return this._eventContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("POLICY_CONTEXT")) {
            return this._policyContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("KEY_CONTEXT")) {
            return this._keyContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("MGMT_CONTEXT")) {
            return this._mgmtContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("RESPONSE_CONTEXT")) {
            return this._responseContextObj;
        }
        if (auditContextObjType.equalsIgnoreCase("CUSTOM_PROPERTY_CONTEXT")) {
            return this._customPropertyContextObj;
        }
        return null;
    }
}

