/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.security.audit.AuditEncryptionImpl;
import com.ibm.ws.security.audit.AuditEventSettings;
import com.ibm.ws.security.audit.AuditLogger;
import com.ibm.ws.security.audit.AuditSigningImpl;
import com.ibm.ws.security.audit.SecurityAuditEventImpl;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.wsspi.security.audit.AuditEncryptException;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.AuditServiceProvider;
import com.ibm.wsspi.security.audit.AuditSignException;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.audit.GenericEvent;
import com.ibm.wsspi.security.audit.GenericEventCompletionException;
import com.ibm.wsspi.security.audit.GenericEventConfigurationException;
import com.ibm.wsspi.security.audit.GenericEventException;
import com.ibm.wsspi.security.audit.GenericEventValidationException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class BinaryEmitterImpl
implements AuditServiceProvider {
    private static final TraceComponent tc = Tr.register(BinaryEmitterImpl.class, null, "com.ibm.ejs.resources.security");
    private AuditEventSettings _aes;
    private ConcurrentHashMap auditFilterSettings = new ConcurrentHashMap();
    private ConcurrentHashMap auditOutcomeSettings = new ConcurrentHashMap();
    private AuditLogger aLog = null;
    private AuditEncryptionImpl ae = null;
    private AuditSigningImpl as = null;
    private Object _auditEvent = null;
    private String sharedKeyAlias = null;
    private static AuditLogger _aLog;
    private static AuditService auditService;
    private String activeUserRegistry = null;
    private WsHandler _binaryLogger;
    WrappingFileOutputStream file_output = null;
    ObjectOutputStream oos = null;
    DataOutputStream d_oos = null;
    DataOutputStream dos = null;
    private static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String encryptionOpenTag = "<Encryption information>\n";
    private static final String encryptionCloseTag = "</Encryption information>\n";
    private static final String encryptedSharedKeyOpenTag = "   <encryptedSharedKey>";
    private static final String encryptedSharedKeyCloseTag = "</encryptedSharedKey>\n";
    private static final String encryptionCertAliasOpenTag = "   <encryptionCertAlias>";
    private static final String encryptionCertAliasCloseTag = "</encryptionCertAlias>\n";
    private static final String signingCertAliasOpenTag = "   <signingCertAlias>";
    private static final String signingCertAliasCloseTag = "</signingCertAlias>\n";
    private static final String encryptionKeyStoreOpenTag = "   <encryptionKeyStore>";
    private static final String encryptionKeyStoreCloseTag = "</encryptionKeyStore>\n";
    private static final String signingKeyStoreOpenTag = "   <signingKeyStore>";
    private static final String signingKeyStoreCloseTag = "</signingKeyStore>\n";
    private static final String keyStoreNameOpenTag = "   <keyStoreName>";
    private static final String keyStoreNameCloseTag = "</keyStoreName>\n";
    private static final String encryptionCertificateOpenTag = "   <encryptionCertificate>";
    private static final String encryptionCertificateCloseTag = "</encryptionCertificate>\n";
    private static final String signingCertificateOpenTag = "   <signingCertificate>";
    private static final String signingCertificateCloseTag = "</signingCertificate>\n";
    private static final String scopeOpenTag = "   <scope>";
    private static final String scopeCloseTag = "</scope>\n";
    private static final String signatureOpenTag = "<signature>";
    private static final String signatureCloseTag = "</signature>";
    private static final String signingOpenTag = "<Signing information>\n";
    private static final String signingCloseTag = "</Signing information>\n";
    private static final String signingSharedKeyOpenTag = "   <signingSharedKey>";
    private static final String signingSharedKeyCloseTag = "</signingSharedKey>\n";
    private static final String newLine = "\n";
    private static final String begin = "<begin>";
    private static final String end = "<end>";
    private Key sharedKey = null;
    private Key publicKey = null;
    private byte[] encryptedSharedKey = null;
    private X509Certificate cert = null;
    private byte[] certBytes = null;
    private Key signedSharedKey = null;
    private Key publicSignerKey = null;
    private Key privateSignerKey = null;
    private byte[] encryptedSignerSharedKey = null;
    private X509Certificate signerCert = null;
    private byte[] signerCertBytes = null;
    private int sequenceNumber = 0;
    private boolean isEncryptionEnabled = false;
    private boolean isSigningEnabled = false;
    private String maxFileSize = null;
    private String maxLogs = null;
    private String fileLocation = null;
    private String _name = null;
    private String _location = null;
    private String _type = null;
    private String _provider = null;
    private String _password = null;
    private String _alias = null;
    private String _signerKeyStoreName = null;
    private String _signerKeyStoreScope = null;
    private String _signerCertAlias = null;
    private String _signerKeyFileLocation = null;
    private boolean binaryLogInited = false;
    private static ConcurrentHashMap aOutcome;
    private static Object syncObject;
    private static Object syncSeqNum;
    byte[] aliasBytes = null;
    byte[] encryptedAuditRecord = null;
    byte[] signedEncryptedAuditRecord = null;
    byte[] signedAuditRecord = null;
    byte[] mergedByteRecord = null;
    byte[] er = null;
    ByteArrayOutputStream baos = null;

    public void BinaryEmitterImpl() {
    }

    public void init(String name, Map properties, Map secProps, Map keyProperties) throws ProviderFailureException {
        byte[] x;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init: " + name);
        }
        if (auditService != null || (auditService = ContextManagerFactory.getInstance().getAuditService()) != null) {
            // empty if block
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        this._aes = new AuditEventSettings();
        this.auditFilterSettings = this._aes.getFilterSettings();
        this.auditOutcomeSettings = this._aes.getOutcomeSettings();
        _aLog = new AuditLogger();
        if (secProps != null) {
            if (secProps.get("encrypt") != null) {
                this.isEncryptionEnabled = (Boolean)secProps.get("encrypt");
            }
            if (secProps.get("sign") != null) {
                this.isSigningEnabled = (Boolean)secProps.get("sign");
            }
            if (secProps.get("maxFileSize") != null) {
                this.maxFileSize = (String)secProps.get("maxFileSize");
            }
            if (secProps.get("maxLogs") != null) {
                this.maxLogs = (String)secProps.get("maxLogs");
            }
            if (secProps.get("maxFileSize") != null) {
                this.fileLocation = (String)secProps.get("fileLocation");
            }
        }
        if (this.isEncryptionEnabled || this.isSigningEnabled) {
            this.encryptedAuditRecord = new byte[16384];
            this.parseKeyProperties(keyProperties);
        }
        if (this.isEncryptionEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption enabled.");
            }
            try {
                this.ae = new AuditEncryptionImpl(this._name, this._location, this._type, this._provider, this._password, this._alias);
            }
            catch (AuditEncryptException aee) {
                throw new ProviderFailureException(aee);
            }
            try {
                this.sharedKey = this.ae.generateSharedKey();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.BinaryEmitterImpl.init", "1", this);
                Tr.error(tc, "security.audit.sharedkey.generation.error", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error generating key.", new Object[]{e});
                }
                throw new ProviderFailureException(e.getMessage(), e);
            }
            this.sharedKeyAlias = this.ae.generateAliasForSharedKey();
            try {
                this.publicKey = this.ae.retrievePublicKey();
                this.cert = this.ae.retrieveCertificate();
                this.encryptedSharedKey = this.ae.encryptSharedKey(this.sharedKey, this.publicKey);
            }
            catch (IOException ioe) {
                Tr.error(tc, "security.audit.keystore.open.error", new Object[]{ioe});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
                }
                throw new ProviderFailureException(ioe.getMessage());
            }
        }
        if (this.isSigningEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signing enabled.");
            }
            try {
                this.as = new AuditSigningImpl(this._signerKeyStoreName, this._signerKeyStoreScope, this._signerCertAlias);
                this._signerKeyFileLocation = this.as.getSignerKeyFileLocation();
            }
            catch (AuditSignException ase) {
                throw new ProviderFailureException(ase);
            }
            try {
                this.signedSharedKey = this.as.generateSharedKey();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.BinaryEmitterImpl.init", "1", this);
                Tr.error(tc, "security.audit.sharedkey.generation.error", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error generating key.", new Object[]{e});
                }
                throw new ProviderFailureException(e.getMessage(), e);
            }
            try {
                this.publicSignerKey = this.as.retrievePublicSignerKey();
                this.privateSignerKey = this.as.retrievePrivateSignerKey();
                this.signerCert = this.as.retrieveSignerCertificate();
                this.encryptedSignerSharedKey = this.as.encryptSharedKey(this.signedSharedKey, this.publicSignerKey);
            }
            catch (IOException ioe) {
                Tr.error(tc, "security.audit.keystore.open.error", new Object[]{ioe});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
                }
                throw new ProviderFailureException(ioe.getMessage());
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.retrieve.signer.error", new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to retrieve the signer information.", e.getMessage());
                }
                throw new ProviderFailureException(e.getMessage());
            }
        }
        String header = null;
        if (this.isEncryptionEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Audit log is new, adding public certificate and encrypted shared key as first record");
            }
            this.certBytes = this.publicKey.toString().getBytes();
            header = xmlDeclaration;
            header = header.concat(encryptionOpenTag);
            header = header.concat(encryptedSharedKeyOpenTag);
            x = Base64Coder.base64Encode(this.encryptedSharedKey);
            header = header.concat(new String(x));
            header = header.concat(encryptedSharedKeyCloseTag);
            header = header.concat(encryptionCertAliasOpenTag);
            header = header.concat(this._alias);
            header = header.concat(encryptionCertAliasCloseTag);
            header = header.concat(encryptionKeyStoreOpenTag);
            header = header.concat(this._location);
            header = header.concat(encryptionKeyStoreCloseTag);
            header = header.concat(encryptionCertificateOpenTag);
            header = header.concat(new String(this.certBytes));
            header = header.concat(newLine);
            header = header.concat(encryptionCertificateCloseTag);
            header = header.concat(encryptionCloseTag);
        }
        if (this.isSigningEnabled) {
            this.signerCertBytes = this.publicSignerKey.toString().getBytes();
            header = header == null ? signingOpenTag : header.concat(signingOpenTag);
            header = header.concat(signingSharedKeyOpenTag);
            x = Base64Coder.base64Encode(this.encryptedSignerSharedKey);
            header = header.concat(new String(x));
            header = header.concat(signingSharedKeyCloseTag);
            header = header.concat(signingCertAliasOpenTag);
            header = header.concat(this._signerCertAlias);
            header = header.concat(signingCertAliasCloseTag);
            header = header.concat(scopeOpenTag);
            header = header.concat(this._signerKeyStoreScope);
            header = header.concat(scopeCloseTag);
            header = header.concat(signingKeyStoreOpenTag);
            header = header.concat(this._signerKeyFileLocation);
            header = header.concat(signingKeyStoreCloseTag);
            header = header.concat(signingCertificateOpenTag);
            header = header.concat(new String(this.signerCertBytes));
            header = header.concat(newLine);
            header = header.concat(signingCertificateCloseTag);
            header = header.concat(signingCloseTag);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "maxFileSize: " + this.maxFileSize + " maxLogs: " + this.maxLogs + " fileLocation: " + this.fileLocation);
        }
        if (!this.binaryLogInited) {
            try {
                this._binaryLogger = header != null ? AuditLogger.createBinaryLogger(header, this.maxFileSize, this.maxLogs, this.fileLocation) : AuditLogger.createBinaryLogger(null, this.maxFileSize, this.maxLogs, this.fileLocation);
                this.binaryLogInited = true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error opening up binary audit log");
                }
                throw new ProviderFailureException(e);
            }
        }
        this.file_output = _aLog.getBinaryLog();
        if (this.isEncryptionEnabled || this.isSigningEnabled) {
            this.dos = new DataOutputStream(this.file_output);
        } else {
            this.d_oos = new DataOutputStream(this.file_output);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void refresh(Map properties) throws ProviderFailureException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendEvent(Object auditEvent) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent: " + auditEvent.toString());
        }
        SecurityAuditEventImpl sae = new SecurityAuditEventImpl();
        byte[] eventBytes = null;
        eventBytes = new byte[16384];
        String eventType = sae.getEventType((HashMap)auditEvent);
        String outCome = sae.getOutcome((HashMap)auditEvent);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " eventType: " + eventType + " outCome: " + outCome);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent 1 = " + auditEvent.toString());
        }
        if (this.isActiveProviderSpec(eventType, outCome)) {
            block72: {
                Object object = syncSeqNum;
                synchronized (object) {
                    sae.putSequenceNumber((HashMap)auditEvent, this.sequenceNumber);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "auditEvent 2 = " + auditEvent.toString());
                    }
                    ++this.sequenceNumber;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sequenceNumber: " + this.sequenceNumber);
                }
                try {
                    try {
                        eventBytes = sae.buildEventString((HashMap)auditEvent).getBytes("UTF-8");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "length of eventBytes: " + eventBytes.length);
                        }
                    }
                    catch (UnsupportedEncodingException ue) {
                        Tr.error(tc, "security.audit.unsupported.encode.error", new Object[]{ue});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unsupported encoding exception converting event. ", ue.getMessage());
                        }
                        throw new ProviderFailureException(ue.getMessage());
                    }
                    catch (GenericEventValidationException gve) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error validating audit record. ", gve.getMessage());
                        }
                        throw new ProviderFailureException(gve.getMessage());
                    }
                    catch (GenericEventConfigurationException gce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Configuration error occured while creating audit record. ", gce.getMessage());
                        }
                        throw new ProviderFailureException(gce.getMessage());
                    }
                    catch (GenericEventCompletionException gcce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error creating audit record. ", gcce.getMessage());
                        }
                        throw new ProviderFailureException(gcce.getMessage());
                    }
                    if (this.isEncryptionEnabled) {
                        byte[] tmpPrivate;
                        for (int i = 0; i < 16384; ++i) {
                            this.encryptedAuditRecord[i] = -1;
                        }
                        try {
                            String z = new String(eventBytes);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "eventBytes: " + z + "eventBytes.length: " + eventBytes.length);
                            }
                            this.er = this.ae.encrypt(eventBytes, this.sharedKey);
                            if (tc.isDebugEnabled()) {
                                System.arraycopy(this.er, 0, this.encryptedAuditRecord, 0, this.er.length);
                                Tr.debug(tc, "length of er: " + this.er.length + " length of encryptedAuditRecord: " + this.encryptedAuditRecord.length);
                                Tr.debug(tc, "encryptedAuditRecord: " + new String(this.encryptedAuditRecord));
                                Tr.debug(tc, "er: " + new String(this.er));
                            }
                        }
                        catch (AuditEncryptException ee) {
                            Tr.error(tc, "security.audit.encryption.error", new Object[]{ee});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failure encrypting audit record. ", ee.getMessage());
                            }
                            throw new ProviderFailureException(ee.getMessage());
                        }
                        if (this.isSigningEnabled) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Record: encrypted and signed");
                            }
                            try {
                                this.signedEncryptedAuditRecord = this.as.sign(this.er, this.signedSharedKey);
                                byte[] sopen = signatureOpenTag.getBytes();
                                byte[] byArray = signatureCloseTag.getBytes();
                                this.baos = new ByteArrayOutputStream(this.er.length + sopen.length + this.signedEncryptedAuditRecord.length + byArray.length);
                                this.baos.write(this.er, 0, this.er.length);
                                this.baos.write(sopen, 0, sopen.length);
                                this.baos.write(this.signedEncryptedAuditRecord, 0, this.signedEncryptedAuditRecord.length);
                                this.baos.write(byArray, 0, byArray.length);
                                this.mergedByteRecord = new byte[this.baos.toByteArray().length];
                                this.mergedByteRecord = this.baos.toByteArray();
                            }
                            catch (AuditSignException ee) {
                                Tr.error(tc, "security.audit.signing.error", new Object[]{ee});
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Failure signing audit record. ", ee.getMessage());
                                }
                                throw new ProviderFailureException(ee.getMessage());
                            }
                            tmpPrivate = Base64Coder.base64Encode(this.mergedByteRecord);
                            Object object2 = syncObject;
                            synchronized (object2) {
                                int total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "total_to_add_length: " + total_to_add_length);
                                }
                                int currentFileSize = new Long(this.file_output.getCurrentFileSize()).intValue();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "currentFileSize: " + currentFileSize);
                                }
                                int max = Integer.parseInt(this.maxFileSize) * 1024 * 1024;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "maxFileSize: " + max);
                                }
                                if (currentFileSize + total_to_add_length >= max) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "adding padding to roll into new log");
                                    }
                                    byte[] padding = new byte[max - currentFileSize];
                                    this.dos.write(padding);
                                }
                                this.dos.write(begin.getBytes());
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "tmpPrivate, to string: " + new String(tmpPrivate));
                                }
                                this.dos.write(tmpPrivate);
                                this.dos.write(end.getBytes());
                                break block72;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Record: encrypted: ");
                        }
                        tmpPrivate = Base64Coder.base64Encode(this.er);
                        Object object3 = syncObject;
                        synchronized (object3) {
                            int total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "total_to_add_length: " + total_to_add_length);
                            }
                            int currentFileSize = new Long(this.file_output.getCurrentFileSize()).intValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "currentFileSize: " + currentFileSize);
                            }
                            int max = Integer.parseInt(this.maxFileSize) * 1024 * 1024;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "maxFileSize: " + max);
                            }
                            if (currentFileSize + total_to_add_length >= max) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "adding padding to roll into new log");
                                }
                                byte[] padding = new byte[max - currentFileSize];
                                this.dos.write(padding);
                            }
                            this.dos.write(begin.getBytes());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tmpPrivate, to string: " + new String(tmpPrivate));
                            }
                            this.dos.write(tmpPrivate);
                            this.dos.write(end.getBytes());
                            break block72;
                        }
                    }
                    if (this.isSigningEnabled) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Record: signed");
                        }
                        try {
                            this.signedAuditRecord = this.as.sign(eventBytes, this.signedSharedKey);
                            byte[] sopen = signatureOpenTag.getBytes();
                            byte[] byArray = signatureCloseTag.getBytes();
                            this.mergedByteRecord = new byte[eventBytes.length];
                            this.mergedByteRecord = eventBytes;
                            this.baos = new ByteArrayOutputStream(eventBytes.length + sopen.length + this.signedAuditRecord.length + byArray.length);
                            this.baos.write(eventBytes, 0, eventBytes.length);
                            this.baos.write(sopen, 0, sopen.length);
                            this.baos.write(this.signedAuditRecord, 0, this.signedAuditRecord.length);
                            this.baos.write(byArray, 0, byArray.length);
                            this.mergedByteRecord = new byte[this.baos.toByteArray().length];
                            this.mergedByteRecord = this.baos.toByteArray();
                            if (tc.isDebugEnabled()) {
                                for (int i = 0; i < this.mergedByteRecord.length; ++i) {
                                    Tr.debug(tc, "decrypting: mergedByteRecord[" + i + "]: " + this.mergedByteRecord[i]);
                                }
                                Tr.debug(tc, "mergedByteRecord: " + new String(this.mergedByteRecord));
                            }
                        }
                        catch (AuditSignException ee) {
                            Tr.error(tc, "security.audit.signing.error", new Object[]{ee});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failure signing audit record. ", ee.getMessage());
                            }
                            throw new ProviderFailureException(ee.getMessage());
                        }
                        byte[] tmpPrivate = Base64Coder.base64Encode(this.mergedByteRecord);
                        Object object4 = syncObject;
                        synchronized (object4) {
                            int total_to_add_length = begin.getBytes().length + tmpPrivate.length + end.getBytes().length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "total_to_add_length: " + total_to_add_length);
                            }
                            int currentFileSize = new Long(this.file_output.getCurrentFileSize()).intValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "currentFileSize: " + currentFileSize);
                            }
                            int max = Integer.parseInt(this.maxFileSize) * 1024 * 1024;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "maxFileSize: " + max);
                            }
                            if (currentFileSize + total_to_add_length >= max) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "adding padding to roll into new log");
                                }
                                byte[] padding = new byte[max - currentFileSize];
                                this.dos.write(padding);
                            }
                            this.dos.write(begin.getBytes());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tmpPrivate, to string: " + new String(tmpPrivate));
                            }
                            this.dos.write(tmpPrivate);
                            this.dos.write(end.getBytes());
                            break block72;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Record: neither encrypted nor signed");
                    }
                    this.d_oos.write(eventBytes);
                }
                catch (IOException ioe) {
                    Tr.error(tc, "security.audit.emitter.binary.log.error", new Object[]{ioe});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to write to the binary output log ioe.toString(): " + ioe.toString() + " ioe.getMessage(): " + ioe.getMessage());
                    }
                    throw new ProviderFailureException(ioe.getMessage());
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "sendEvent ");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "sendEvent ");
        }
        return null;
    }

    public String sendEvent(Object auditEvent, int synchronizationMode, int transactionMode) throws ProviderFailureException {
        return null;
    }

    public Object getEvent(String eventID) throws ProviderFailureException {
        return null;
    }

    public boolean isActiveProviderSpec(String auditEventType, String auditOutcome) {
        ConcurrentHashMap o;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
        if ((o = (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType)) != null && o.get(auditOutcome) != null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isActiveProviderSpec(true)");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActiveProviderSpec(false)");
        }
        return false;
    }

    public void setActiveProviderSpec(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActiveProviderSpec: " + auditEventType + " : " + auditOutcome);
        }
        ContextHandler contextHandler = null;
        this.auditOutcomeSettings = !this.auditFilterSettings.containsKey(auditEventType) ? new ConcurrentHashMap() : (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType);
        this.auditOutcomeSettings.putIfAbsent(auditOutcome, "ACTIVE");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditOutcomeSettings: " + this.auditOutcomeSettings.toString());
        }
        if (this.auditFilterSettings.containsKey(auditEventType)) {
            this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        } else {
            this.auditFilterSettings.put(auditEventType, this.auditOutcomeSettings);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditFilters: " + this.auditFilterSettings.toString());
        }
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterSet", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.BinaryEmitterImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                auditService.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
    }

    public void resetActiveProviderSpec(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
        ContextHandler contextHandler = null;
        this.auditOutcomeSettings.remove(auditOutcome);
        this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterRemove", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.BinaryEmitterImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                auditService.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActiveProviderSpec: " + auditEventType + " " + auditOutcome);
        }
    }

    public String getActiveProviderSpec() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActiveProviderSpec");
        }
        String s = new String("{");
        s = s.concat(this.auditFilterSettings.toString()).concat("}");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActiveProviderSpec");
        }
        return s;
    }

    public void parseKeyProperties(Map keyProperties) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "parseKeyProperties");
        }
        this._name = (String)keyProperties.get("keyStoreName");
        this._location = (String)keyProperties.get("keyStoreLocation");
        this._type = (String)keyProperties.get("keyStoreType");
        this._provider = (String)keyProperties.get("keyStoreProvider");
        this._password = (String)keyProperties.get("keyStorePassword");
        this._alias = (String)keyProperties.get("alias");
        this._signerKeyStoreName = (String)keyProperties.get("signerKeyStoreName");
        this._signerKeyStoreScope = (String)keyProperties.get("signerKeyStoreScope");
        this._signerCertAlias = (String)keyProperties.get("signerCertAlias");
        this._signerKeyFileLocation = (String)keyProperties.get("signerKeyFileLocation");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "parseKeyProperties");
        }
    }

    public String sendEvent(GenericEvent event2) throws GenericEventException {
        return null;
    }

    public String[] sendEvents(GenericEvent[] events) throws GenericEventException {
        return null;
    }

    public void close() throws GenericEventException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        AuditLogger.closeBinaryLogger(this._binaryLogger);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    static {
        auditService = null;
        aOutcome = new ConcurrentHashMap();
        syncObject = new Object();
        syncSeqNum = new Object();
    }
}

