/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereSecurityPermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditEncryptionImpl;
import com.ibm.ws.security.audit.AuditLogger;
import com.ibm.ws.security.audit.AuditSigningImpl;
import com.ibm.ws.security.audit.AuditThreadLocal;
import com.ibm.ws.security.audit.ContextHandlerImpl;
import com.ibm.ws.security.audit.EventContextObj;
import com.ibm.ws.security.audit.SessionContextObj;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.AuditKeystoreConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.wsspi.security.audit.AuditEventFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.AuditServiceProvider;
import com.ibm.wsspi.security.audit.AuditSignException;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public final class AuditServiceImpl
implements AuditService {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static final TraceComponent tc = Tr.register(AuditServiceImpl.class, null, "com.ibm.ejs.resources.security");
    private static AuditServiceImpl _auditService = null;
    private static boolean _active = false;
    private boolean _verbose;
    private boolean _notificationEnabled;
    private String _notificationName;
    private boolean _sendEmail;
    private String[] _emailListEntries;
    private int _emailListSize;
    private String notificationText;
    private Map _keyStoreProps;
    private Map _secProps;
    private final int maximpls = 10;
    private static HashMap _factory = new HashMap();
    private HashMap _context;
    private static HashMap _provider = new HashMap();
    private String _providerName;
    private AuditServiceProvider _providerObj;
    private HashMap _factoryProviderMapping;
    private boolean _queueEnabled;
    private int _queueSize;
    private static int _recoveryPolicy = 1;
    private String _domain;
    private String _componentName;
    private String _cellName;
    private String _nodeName;
    private String _serverName;
    private String _realm;
    private String _spec;
    private List _providers;
    private static final WebSphereSecurityPermission AUDIT_PERM = WebSphereSecurityPermission.INTERNAL_PERMISSION;
    private static AuditLogger _aLog;
    private String _keyStoreName;
    private String _keyStoreType;
    private String _keyStoreProvider;
    private String _keyStoreLocation;
    private String _keyStorePassword;
    private String _keyStoreAlias;
    private boolean isEncryptionEnabled;
    private boolean isSigningEnabled;
    private static AuditEncryptionImpl _auditEncryptionService;
    private static AuditSigningImpl _auditSigningService;
    private static AuditConfig _audit;
    AuditEventFactory[] auditFactories;
    private String processName;
    private String processType;
    private String serverType;
    private AdminService adminService;
    private static String activeUserRegistry;
    private static ConcurrentHashMap auditOutcome;
    private static String propagateFirstCallerOnlyProperty;
    private static boolean propagateFirstCallerOnly;
    private static String auditReportGranularity;
    String[] eventTrailIds;

    public static AuditService getAuditService() throws Exception {
        SecurityManager sm;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getAuditService");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + AUDIT_PERM.toString());
            }
            sm.checkPermission((Permission)AUDIT_PERM);
        }
        if (_auditService == null) {
            Tr.audit(tc, "security.audit.service.disabled.audit");
            throw new Exception("AuditService has not been initialized");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getAuditService");
        }
        return _auditService;
    }

    public static void initAuditService() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "initAuditService");
        }
        ContextHandlerImpl _contextHandler = null;
        _contextHandler = new ContextHandlerImpl();
        if (_auditService == null) {
            try {
                _auditService = new AuditServiceImpl();
                _contextHandler = (ContextHandlerImpl)_auditService.getContextHandler();
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.service.init.error");
                throw new Exception(e);
            }
            if (_auditService == null) {
                Tr.error(tc, "security.audit.service.init.error");
                throw new Exception("AuditService is not initialized");
            }
        } else {
            throw new IllegalStateException("AuditService has already been initialized");
        }
        _audit = SecurityObjectLocator.getAuditConfig();
        _active = _audit.getBoolean("auditEnabled");
        Tr.debug(tc, "bbb2: _active: " + _active);
        SecurityConfig security2 = null;
        security2 = SecurityObjectLocator.getSecurityConfig();
        activeUserRegistry = security2.getActiveUserRegistry().getType();
        Tr.debug(tc, "_active: " + _active);
        if (_auditService != null) {
            Tr.debug(tc, "auditService not null");
        } else {
            Tr.debug(tc, "auditService is null");
        }
        propagateFirstCallerOnlyProperty = System.getProperty("com.ibm.CSI.propagateFirstCallerOnly");
        if (propagateFirstCallerOnlyProperty == null && security2 != null) {
            propagateFirstCallerOnlyProperty = security2.getProperties().getProperty("com.ibm.CSI.propagateFirstCallerOnly");
        }
        if (propagateFirstCallerOnlyProperty == null) {
            propagateFirstCallerOnlyProperty = "true";
        }
        boolean bl = propagateFirstCallerOnly = propagateFirstCallerOnlyProperty.equalsIgnoreCase("true") || propagateFirstCallerOnlyProperty.equalsIgnoreCase("yes");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propagateFirstCallerOnly: " + propagateFirstCallerOnly);
        }
        if ((auditReportGranularity = System.getProperty("com.ibm.audit.report.granularity")) == null && security2 != null && (auditReportGranularity = security2.getProperties().getProperty("com.ibm.audit.report.granularity")) == null) {
            auditReportGranularity = _audit.getString("com.ibm.audit.report.granularity");
        }
        if (auditReportGranularity == null) {
            auditReportGranularity = "low";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditReportGranularity: " + auditReportGranularity);
        }
        if (_active) {
            Iterator iter;
            Set ks;
            int index;
            TargetAttributes[] ta;
            String msg;
            HashMap data;
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
                if (_contextHandler != null) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "enable", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildMgmtData("subSystem", "enable", null);
                    auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 84L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    msg = "security.audit.service.sendevent.error";
                    _auditService.processAuditFailure(msg, e);
                }
            }
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "INFO")) {
                if (_contextHandler != null) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "auditNotificationChange", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    ta = new TargetAttributes[1];
                    TargetAttributes cfr_ignored_0 = ta[0];
                    TargetAttributes.name = "auditNotificationPolicy".concat(":").concat(new Integer(_recoveryPolicy).toString());
                    TargetAttributes cfr_ignored_1 = ta[0];
                    TargetAttributes.uniqueId = 0L;
                    data = DataHelper.buildMgmtData("subSystem", "auditNotificationChange", ta);
                    auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "INFO", 85L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    msg = "security.audit.service.sendevent.error";
                    _auditService.processAuditFailure(msg, e);
                }
            }
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "INFO")) {
                if (_contextHandler != null) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditEventFactoriesConfig", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    ta = new TargetAttributes[_factory.size()];
                    index = 0;
                    ks = _factory.keySet();
                    iter = _factory.keySet().iterator();
                    while (iter.hasNext()) {
                        TargetAttributes cfr_ignored_2 = ta[index];
                        TargetAttributes.name = (String)iter.next();
                        TargetAttributes cfr_ignored_3 = ta[index++];
                        TargetAttributes.uniqueId = 0L;
                    }
                    data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                    auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "INFO", 85L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    msg = "security.audit.service.sendevent.error";
                    _auditService.processAuditFailure(msg, e);
                }
            }
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "INFO")) {
                if (_contextHandler != null) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditServiceProvidersConfig", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    ta = new TargetAttributes[_provider.size()];
                    index = 0;
                    ks = _provider.keySet();
                    iter = _provider.keySet().iterator();
                    while (iter.hasNext()) {
                        TargetAttributes cfr_ignored_4 = ta[index];
                        TargetAttributes.name = (String)iter.next();
                        TargetAttributes cfr_ignored_5 = ta[index++];
                        TargetAttributes.uniqueId = 0L;
                    }
                    data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                    auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "INFO", 85L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    msg = "security.audit.service.sendevent.error";
                    _auditService.processAuditFailure(msg, e);
                }
            }
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
                if (_contextHandler != null) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "auditStart", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildMgmtData("subSystem", "auditStart", null);
                    auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 81L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    msg = "security.audit.service.sendevent.error";
                    _auditService.processAuditFailure(msg, e);
                }
            }
        } else if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (_contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "disable", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildMgmtData("subSystem", "enable", null);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 88L);
            }
            try {
                _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                _auditService.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "initAuditService");
        }
    }

    public void stopAuditService() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "stopAuditService");
        }
        List pList = new ArrayList();
        if (this._factoryProviderMapping != null) {
            Set factorySet = this._factoryProviderMapping.keySet();
            for (String factoryName : factorySet) {
                if (this._factoryProviderMapping.get(factoryName) == null) continue;
                pList = (List)this._factoryProviderMapping.get(factoryName);
                for (AuditServiceProvider provider : pList) {
                    if (provider != null) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.exit(tc, "stopping provider: ");
                            }
                            provider.close();
                        }
                        catch (Exception e) {
                            Tr.error(tc, "security.audit.service.provider.error", new Object[]{e});
                        }
                        continue;
                    }
                    Tr.error(tc, "security.audit.service.init.error");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "AuditServiceProvider not initialized");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "stopAuditService");
        }
    }

    private AuditServiceImpl() throws Exception {
        block14: {
            this._verbose = false;
            this._notificationEnabled = false;
            this._notificationName = null;
            this._sendEmail = false;
            this._emailListEntries = new String[20];
            this._emailListSize = 0;
            this.notificationText = new String("Failure in the Audit SubSystem");
            this._secProps = null;
            this.maximpls = 10;
            this._context = new HashMap(3);
            this._providerName = null;
            this._providerObj = null;
            this._factoryProviderMapping = new HashMap();
            this._queueEnabled = false;
            this._queueSize = 0;
            this._domain = null;
            this._componentName = null;
            this._cellName = null;
            this._nodeName = null;
            this._serverName = null;
            this._realm = null;
            this._spec = null;
            this._providers = null;
            this._keyStoreName = null;
            this._keyStoreType = null;
            this._keyStoreProvider = null;
            this._keyStoreLocation = null;
            this._keyStorePassword = null;
            this._keyStoreAlias = null;
            this.isEncryptionEnabled = false;
            this.isSigningEnabled = false;
            this.auditFactories = null;
            this.processName = null;
            this.processType = null;
            this.serverType = null;
            this.adminService = null;
            this.eventTrailIds = new String[1];
            try {
                _audit = SecurityObjectLocator.getAuditConfig();
                this._cellName = SecurityObjectLocator.getAdminData().getString("cellname");
                this._nodeName = SecurityObjectLocator.getAdminData().getString("nodename");
                this._serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
                if (this._componentName == null || this._componentName.length() == 0) {
                    this._componentName = "WebSphere Application Server";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cell = " + this._cellName + ", Node = " + this._nodeName + ", Server = " + this._serverName);
                }
                this._context.put("cell", this._cellName);
                this._context.put("node", this._nodeName);
                this._context.put("server", this._serverName);
                this._context.put("component", this._componentName);
                this._context.put("com.ibm.wsspi.security.audit.AuditService", this);
                this._domain = this.computeDomain();
                this._realm = this.computeRealm();
                _aLog = new AuditLogger();
                this.isEncryptionEnabled = _audit.getBoolean("encrypt");
                this.isSigningEnabled = _audit.getBoolean("sign");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Is encryption enabled: " + this.isEncryptionEnabled + ". Is signing enabled: " + this.isSigningEnabled);
                }
                if (this.isEncryptionEnabled) {
                    AuditKeystoreConfig aks = _audit.getActiveAuditKeystore();
                    if (aks == null) {
                        Tr.error(tc, "security.audit.keystore.not.found.error");
                        String msg = "Encryption is enabled, but could not find Auditor's keystore and certificate.";
                        throw new Exception(msg);
                    }
                    String _keyStoreName = aks.getString("name");
                    String _keyStoreType = aks.getString("type");
                    String _keyStoreProvider = aks.getString("provider");
                    String _keyStoreLocation = aks.getUnexpandedString("location");
                    if (_keyStoreLocation.indexOf("${CONFIG_ROOT}") != -1) {
                        String expandedConfigRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
                        _keyStoreLocation = expandedConfigRoot.concat(_keyStoreLocation.substring(_keyStoreLocation.indexOf("${CONFIG_ROOT}") + 14));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "_keyStoreLocation: " + _keyStoreLocation);
                        }
                    }
                    String _keyStorePassword = aks.getDecodedString("password");
                    String _keyStoreAlias = _audit.getString("encryptionCertName");
                    this._keyStoreProps = aks.buildKeyStoreProps(_keyStoreName, _keyStoreLocation, _keyStoreType, _keyStoreProvider, _keyStorePassword, _keyStoreAlias);
                    _auditEncryptionService = new AuditEncryptionImpl(_keyStoreName, _keyStoreLocation, _keyStoreType, _keyStoreProvider, _keyStorePassword, _keyStoreAlias);
                }
                if (!this.isSigningEnabled) break block14;
                String _signerKeyStoreName = _audit.getString("securityXmlSignerKeyStoreName");
                String _signerKeyStoreScope = _audit.getString("securityXmlSignerScopeName");
                String _signerCertAlias = _audit.getString("securityXmlSignerCertAlias");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_signerKeyStoreName: " + _signerKeyStoreName + " _signerKeyStoreScope: " + _signerKeyStoreScope + " _signerCertAlias: " + _signerCertAlias);
                }
                if (this._keyStoreProps == null) {
                    this._keyStoreProps = new HashMap();
                }
                this._keyStoreProps.put("signerKeyStoreName", _signerKeyStoreName);
                this._keyStoreProps.put("signerKeyStoreScope", _signerKeyStoreScope);
                this._keyStoreProps.put("signerCertAlias", _signerCertAlias);
                try {
                    _auditSigningService = new AuditSigningImpl(_signerKeyStoreName, _signerKeyStoreScope, _signerCertAlias);
                    this._keyStoreProps.put("signerKeyFileLocation", _auditSigningService.getSignerKeyFileLocation());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "_signerKeyFileLocation: " + _auditSigningService.getSignerKeyFileLocation());
                    }
                }
                catch (AuditSignException ase) {
                    throw new Exception(ase);
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.service.exception.error", new Object[]{e});
            }
        }
        this.refresh();
    }

    public void refresh() throws Exception {
        block30: {
            SecurityManager sm;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "refresh");
            }
            if ((sm = System.getSecurityManager()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + AUDIT_PERM.toString());
                }
                sm.checkPermission((Permission)AUDIT_PERM);
            }
            try {
                _active = _audit.getBoolean("auditEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "active = " + String.valueOf(_active));
                }
                this._verbose = _audit.getBoolean("verbose");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "verbose = " + this._verbose);
                }
                String auditPolicyStr = _audit.getString("auditPolicy");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "auditPolicyStr = " + auditPolicyStr);
                }
                if (_active) {
                    boolean failOnIncompleteConfig = true;
                    Tr.audit(tc, "security.audit.service.enabled.audit");
                    if (auditPolicyStr.equalsIgnoreCase("NOWARN")) {
                        _recoveryPolicy = 1;
                        failOnIncompleteConfig = false;
                    } else if (auditPolicyStr.equalsIgnoreCase("WARN")) {
                        _recoveryPolicy = 2;
                    } else if (auditPolicyStr.equalsIgnoreCase("FATAL")) {
                        _recoveryPolicy = 3;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "_recoveryPolicy: " + _recoveryPolicy);
                    }
                    if (_recoveryPolicy != 1) {
                        this._notificationEnabled = _audit.getBoolean("auditMonitorEnabled");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "monitor name = " + _audit.getString("auditMonitorName") + " isEnabled = " + this._notificationEnabled);
                        }
                        this._sendEmail = _audit.getBoolean("auditNotificationSendEmail");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sendEmail: " + this._sendEmail);
                        }
                        String emailList = _audit.getString("auditNotificationEmailList");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "emailList = " + emailList);
                        }
                        if (emailList.contains("|")) {
                            int index = 0;
                            StringTokenizer st = new StringTokenizer(emailList, "|");
                            while (st.hasMoreTokens()) {
                                this._emailListEntries[index++] = st.nextToken();
                            }
                            this._emailListSize = index;
                        } else {
                            this._emailListEntries[0] = new String(emailList);
                            this._emailListSize = 1;
                        }
                        if (tc.isDebugEnabled() && this._emailListEntries != null) {
                            Tr.debug(tc, "_emailListSize = " + this._emailListSize);
                        }
                        if (tc.isDebugEnabled()) {
                            for (int b = 0; b < this._emailListSize; ++b) {
                                Tr.debug(tc, "_emailListEntries[" + b + "]: " + this._emailListEntries[b]);
                            }
                        }
                    }
                    Map fpmap = null;
                    try {
                        fpmap = _audit.getFactoriesAndProviders(this._context, this._keyStoreProps, failOnIncompleteConfig);
                    }
                    catch (Exception e) {
                        _active = false;
                        throw new ProviderException(e);
                    }
                    _factory = (HashMap)fpmap.get("factories");
                    if (_factory.size() == 0) {
                        _active = false;
                        throw new ProviderException("No AuditEventFactory was defined.");
                    }
                    _provider = (HashMap)fpmap.get("providers");
                    if (_provider.size() == 0) {
                        _active = false;
                        throw new ProviderException("No AuditServiceProvider was defined.");
                    }
                    this._factoryProviderMapping = (HashMap)fpmap.get("mapping");
                    this.auditFactories = this.getAuditEventFactories();
                    break block30;
                }
                Tr.audit(tc, "security.audit.service.disabled.audit");
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.service.exception.error", new Object[]{e});
                FFDCFilter.processException(e, "com.ibm.ws.security.audit.AuditServiceImpl.refresh", "%");
                e.printStackTrace();
                _active = false;
                throw e;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    public Object getEvent(String factoryName, String eventID) {
        Iterator it;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getEvent: " + factoryName + " " + eventID);
        }
        List pList = new ArrayList();
        if (this._factoryProviderMapping != null && this._factoryProviderMapping.get(factoryName) != null) {
            pList = (List)this._factoryProviderMapping.get(factoryName);
        }
        if ((it = pList.iterator()).hasNext()) {
            AuditServiceProvider provider = (AuditServiceProvider)it.next();
            if (provider != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "getEvent: " + factoryName + " " + eventID);
                    }
                    return provider.getEvent(eventID);
                }
                catch (Exception e) {
                    Tr.error(tc, "security.audit.service.provider.error", new Object[]{e});
                    return null;
                }
            }
            Tr.error(tc, "security.audit.service.init.error");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditServiceProvider not initialized");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getEvent");
        }
        return null;
    }

    public static AuditLogger getAuditLogger() {
        return _aLog;
    }

    public void buildKeyStoreProps(String name, String keyFileLocation, String type, String provider, String password, String alias) {
        this._keyStoreProps = new HashMap();
        this._keyStoreProps.put("keyStoreName", name);
        this._keyStoreProps.put("keyStoreLocation", keyFileLocation);
        this._keyStoreProps.put("keyStoreType", type);
        this._keyStoreProps.put("keyStoreProvider", provider);
        this._keyStoreProps.put("keyStorePassword", password);
        this._keyStoreProps.put("alias", alias);
    }

    public String sendEvent(String auditEventType, ConcurrentHashMap auditOutcome) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent, eventType: " + auditEventType + " filter: " + auditOutcome.get("OutcomeFailureReason"));
        }
        if (!_active) {
            return null;
        }
        if (this.auditFactories == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            String msg = "Auditing is enabled, but no audit factories are defined.";
            throw new ProviderFailureException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of auditFactories configured: " + this.auditFactories.length);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of configured audit event factories: " + this.auditFactories.length);
        }
        for (int i = 0; i < this.auditFactories.length; ++i) {
            if (this.auditFactories[i] == null || !this.auditFactories[i].isActive(auditEventType, (String)auditOutcome.get("OutcomeFailureReason"))) continue;
            try {
                this.auditFactories[i].sendEvent(auditEventType, auditOutcome);
                continue;
            }
            catch (ProviderFailureException pfe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                _active = false;
                throw new ProviderFailureException(pfe);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "sendEvent");
        }
        return null;
    }

    public boolean isEventRequired(String auditEventType, String outcomeType) {
        if (this.auditFactories != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of configured audit event factories: " + this.auditFactories.length + " auditEventType: " + auditEventType + " outcomeType: " + outcomeType);
            }
            for (int i = 0; i < this.auditFactories.length; ++i) {
                if (this.auditFactories[i] == null || !this.auditFactories[i].isActive(auditEventType, outcomeType)) continue;
                return true;
            }
        }
        return false;
    }

    public String sendEvent(Object auditEvent, String factoryName) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent: factoryName: " + factoryName);
        }
        List pList = new ArrayList();
        if (this._factoryProviderMapping == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            _active = false;
            throw new ProviderFailureException("Found no configured event factories or emitters.");
        }
        if (this._factoryProviderMapping.get(factoryName) == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            _active = false;
            throw new ProviderFailureException("Audit event factory not found in list of configured factories.");
        }
        if (this._factoryProviderMapping != null && this._factoryProviderMapping.get(factoryName) != null) {
            pList = (List)this._factoryProviderMapping.get(factoryName);
        }
        if (pList == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            _active = false;
            throw new ProviderFailureException("Found no configured emitters.");
        }
        for (AuditServiceProvider provider : pList) {
            if (provider == null) continue;
            try {
                return provider.sendEvent(auditEvent);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.provider.error", new Object[]{e});
                _active = false;
                throw new ProviderFailureException(e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "sendEvent");
        }
        return null;
    }

    public String sendEvent(Object event2, int synchronizationMode, int transactionMode, String factoryName) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent: factoryName: " + factoryName);
        }
        return null;
    }

    public String getProviderName() {
        return this._providerName;
    }

    public ContextHandler getContextHandler() {
        ContextHandler contexth;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextHandler");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: getContextHandler, thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
        }
        if ((contexth = AuditThreadLocal.getContextHandlerThreadLocal()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TEQ: contexth is null, creating new thread local instance");
            }
            try {
                contexth = new ContextHandlerImpl();
            }
            catch (Exception e) {
                // empty catch block
            }
            AuditThreadLocal.setContextHandlerThreadLocal(contexth);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: context is not null, returning thread local instance");
        }
        if (tc.isDebugEnabled()) {
            EventContextObj eco;
            SessionContextObj sco = (SessionContextObj)contexth.getContextObject("SESSION_CONTEXT");
            if (sco != null && sco.getMap() != null) {
                Tr.debug(tc, "getCH: sessionContextObj: " + sco.getMap().toString());
            }
            if ((eco = (EventContextObj)contexth.getContextObject("EVENT_CONTEXT")) != null && eco.getMap() != null) {
                Tr.debug(tc, "getCH: eventContextObj: " + eco.getMap().toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextHandler");
        }
        return contexth;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public boolean isActive() {
        return _active;
    }

    public boolean isActive(String factoryName, String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActive: " + factoryName + " " + auditEventType + " " + auditOutcome);
        }
        boolean isActive = false;
        if (_active) {
            AuditEventFactory factory;
            if (_factory == null) {
                Tr.error(tc, "security.audit.event.factory.config.error");
            }
            if ((factory = (AuditEventFactory)_factory.get(factoryName)) == null) {
                Tr.error(tc, "security.audit.event.factory.config.error");
            } else {
                isActive = factory.isActive(auditEventType, auditOutcome);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActive");
        }
        return isActive;
    }

    public void setActive(String factoryName, String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActive: " + factoryName + " " + auditEventType + " " + auditOutcome);
        }
        if (_factory == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return;
        }
        AuditEventFactory factory = (AuditEventFactory)_factory.get(factoryName);
        if (factory != null) {
            factory.setActive(auditEventType, auditOutcome);
        } else {
            Tr.error(tc, "security.audit.event.factory.config.error");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActive");
        }
    }

    public void resetActive(String factoryName, String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActive: " + factoryName + " " + auditEventType + " " + auditOutcome);
        }
        if (_factory == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return;
        }
        AuditEventFactory factory = (AuditEventFactory)_factory.get(factoryName);
        if (factory != null) {
            factory.resetActive(auditEventType, auditOutcome);
        } else {
            Tr.error(tc, "security.audit.event.factory.config.error");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActive");
        }
    }

    public String getActive() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActive");
        }
        if (_factory == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return null;
        }
        AuditEventFactory[] factory = (AuditEventFactory[])_factory.values().toArray();
        if (factory == null || factory.length == 0) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return null;
        }
        String[] factoryName = (String[])_factory.keySet().toArray();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < factory.length; ++i) {
            try {
                String activeSet = factory[i].getActive();
                StringTokenizer st = new StringTokenizer(activeSet, "=;,");
                while (st.hasMoreTokens()) {
                    String eventType = st.nextToken().trim();
                    if (!st.hasMoreTokens()) continue;
                    String outcome = st.nextToken().trim();
                    sbuf.append(factoryName[i] + "=" + eventType + "=" + outcome + ";");
                }
                continue;
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.service.factory.error", new Object[]{new Integer(i), e});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActive");
        }
        return sbuf.toString();
    }

    public boolean isActiveProviderSpec(String providerName, String auditEventType, String auditOutcome) {
        AuditServiceProvider provider;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActiveProviderSpec: " + providerName + " " + auditEventType + " " + auditOutcome);
        }
        boolean isActiveProviderSpec = false;
        if (providerName == null) {
            Tr.error(tc, "security.audit.emitter.config.error");
        }
        if ((provider = (AuditServiceProvider)_provider.get(providerName)) == null) {
            Tr.error(tc, "security.audit.emitter.config.error");
        } else {
            isActiveProviderSpec = provider.isActiveProviderSpec(auditEventType, auditOutcome);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActiveProviderSpec");
        }
        return isActiveProviderSpec;
    }

    public void setActiveProviderSpec(String providerName, String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActiveProviderSpec: " + providerName + " " + auditEventType + " " + auditOutcome);
        }
        if (_provider == null) {
            Tr.error(tc, "security.audit.emitter.config.error");
            return;
        }
        AuditServiceProvider provider = (AuditServiceProvider)_provider.get(providerName);
        if (provider != null) {
            provider.setActiveProviderSpec(auditEventType, auditOutcome);
        } else {
            Tr.error(tc, "security.audit.emitter.config.error");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActiveProviderSpec");
        }
    }

    public void resetActiveProviderSpec(String providerName, String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActiveProviderSpec: " + providerName + " " + auditEventType + " " + auditOutcome);
        }
        if (_provider == null) {
            Tr.error(tc, "security.audit.emitter.config.error");
            return;
        }
        AuditServiceProvider provider = (AuditServiceProvider)_provider.get(providerName);
        if (provider != null) {
            provider.resetActiveProviderSpec(auditEventType, auditOutcome);
        } else {
            Tr.error(tc, "security.audit.emitter.config.error");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActiveProviderSpec");
        }
    }

    public String getActiveProviderSpec() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActiveProviderSpec");
        }
        if (_provider == null) {
            Tr.error(tc, "security.audit.emitter.config.error");
            return null;
        }
        AuditServiceProvider[] provider = (AuditServiceProvider[])_provider.values().toArray();
        if (provider == null || provider.length == 0) {
            Tr.error(tc, "security.audit.emitter.config.error");
            return null;
        }
        String[] providerName = (String[])_provider.keySet().toArray();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < provider.length; ++i) {
            try {
                String activeSet = provider[i].getActiveProviderSpec();
                StringTokenizer st = new StringTokenizer(activeSet, "=;,");
                while (st.hasMoreTokens()) {
                    String eventType = st.nextToken().trim();
                    if (!st.hasMoreTokens()) continue;
                    String outcome = st.nextToken().trim();
                    sbuf.append(providerName[i] + "=" + eventType + "=" + outcome + ";");
                }
                continue;
            }
            catch (Exception e) {
                Tr.error(tc, "security.audit.service.provider.error", new Object[]{new Integer(i), e});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActiveProviderSpec");
        }
        return sbuf.toString();
    }

    public String[] getAuditEventFactoryName() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getAuditEventFactoryName");
        }
        if (_factory == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getAuditEventFactoryName");
        }
        return _factory.keySet().toArray(new String[0]);
    }

    public AuditEventFactory getAuditEventFactory(String factoryName) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getAuditEventFactory");
        }
        if (_factory == null) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getAuditEventFactory");
        }
        return (AuditEventFactory)_factory.get(factoryName);
    }

    public AuditEventFactory[] getAuditEventFactories() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getAuditEventFactories");
        }
        if (_factory == null || _factory.isEmpty()) {
            Tr.error(tc, "security.audit.event.factory.config.error");
            return null;
        }
        int listSize = 0;
        Collection collection = _factory.values();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "number of event factories in collection: " + collection.size());
        }
        Iterator it = collection.iterator();
        AuditEventFactory[] afList = new AuditEventFactory[collection.size()];
        while (it.hasNext()) {
            AuditEventFactory af = (AuditEventFactory)it.next();
            afList[listSize++] = af;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getAuditEventFactories");
        }
        return afList;
    }

    public String getFirstCaller() {
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr != null) {
            WSSecurityPropagationHelper propHelper = WSSecurityPropagationHelper.getInstance();
            if (!(propHelper.isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
                try {
                    Subject sub = ctxMgr.getCallerSubject();
                    if (sub != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getFirstCaller, propagation not enabled, caller subject: " + ((Principal)sub.getPrincipals().toArray()[0]).getName());
                        }
                        return ((Principal)sub.getPrincipals().toArray()[0]).getName();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getFirstCaller, propagation not enabled, caller subject is null");
                    }
                    return null;
                }
                catch (WSSecurityException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getFirstCaller, propagation not enabled, caught exception, returning null");
                    }
                    return null;
                }
            }
            if (WSSecurityHelper.getFirstCaller() == null) {
                try {
                    Subject invokeSub;
                    Subject sub = ctxMgr.getCallerSubject();
                    if (sub != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caller subject: " + ((Principal)sub.getPrincipals().toArray()[0]).getName());
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caller subject is null");
                    }
                    if ((invokeSub = ctxMgr.getInvocationSubject()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "invokeSub is not null");
                            Tr.debug(tc, "getFirstCaller, propagation enabled, returning: " + ((Principal)invokeSub.getPrincipals().toArray()[0]).getName());
                        }
                        return ((Principal)invokeSub.getPrincipals().toArray()[0]).getName();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invokeSub is not null");
                        Tr.debug(tc, "getFirstCaller, propagation enabled, returning : null ");
                    }
                    return null;
                }
                catch (WSSecurityException e) {
                    return null;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityHelper.getFirstCaller not null, returning: " + WSSecurityHelper.getFirstCaller());
            }
            return WSSecurityHelper.getFirstCaller();
        }
        return null;
    }

    public String[] getCallerList() {
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr != null) {
            WSSecurityPropagationHelper propHelper = WSSecurityPropagationHelper.getInstance();
            if (!(propHelper.isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
                String[] callerStack = new String[2];
                callerStack[0] = this.getFirstCaller();
                try {
                    Subject sub = ctxMgr.getInvocationSubject();
                    callerStack[1] = sub != null ? ((Principal)sub.getPrincipals().toArray()[0]).getName() : null;
                }
                catch (WSSecurityException e) {
                    callerStack[1] = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCallerList, propagation not enabled, callerStack: " + callerStack[0] + ", " + callerStack[1]);
                }
                return callerStack;
            }
            if (propagateFirstCallerOnly) {
                String[] callerStack = new String[2];
                callerStack[0] = this.getFirstCaller();
                try {
                    Subject sub = ctxMgr.getInvocationSubject();
                    callerStack[1] = sub != null ? ((Principal)sub.getPrincipals().toArray()[0]).getName() : null;
                }
                catch (WSSecurityException e) {
                    callerStack[1] = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCallerList,propagation enabled, propagateFirstCallerOnly is true, callerStack: " + callerStack[0] + ", " + callerStack[1]);
                }
                return callerStack;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCallerList,propagation enabled, propagateFirstCallerOnly is false, callerStack: " + WSSecurityHelper.getCallerList());
            }
            return WSSecurityHelper.getCallerList();
        }
        return null;
    }

    public String computeDomain() {
        SecurityConfig sc = SecurityObjectLocator.getSecurityConfig();
        String domain = sc.getDomain();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "domain: " + domain);
        }
        return domain;
    }

    public String computeRealm() {
        String realm = ContextManagerFactory.getInstance().getDefaultRealm();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "realm: " + realm);
        }
        return realm;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getRealm() {
        return this._realm;
    }

    public String getLastTrailId() {
        String lastTrailId = null;
        try {
            PropagationToken token = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (token != null) {
                this.eventTrailIds[0] = lastTrailId = token.getUniqueID();
            }
            return lastTrailId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getEventTrailIds() {
        return this.eventTrailIds;
    }

    public void processAuditFailure(String notificationText, Exception e) {
        block17: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processAuditFailure");
            }
            ContextHandlerImpl _contextHandler = null;
            if (_auditService != null) {
                _contextHandler = (ContextHandlerImpl)_auditService.getContextHandler();
            }
            if (_auditService != null && _auditService.isEventRequired("SECURITY_MGMT_AUDIT", "ERROR")) {
                if (_contextHandler != null) {
                    HashMap data = DataHelper.buildSessionData(null, null, null, null);
                    _contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("WASServer", "auditStop", null, null, "authzSuccess", "AuditSubSystem", "process", new Long(0L), null, null, null, null);
                    _contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(_auditService.getLastTrailId(), _auditService.getEventTrailIds(), new Date(), new Long(0L));
                    _contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(_auditService.getFirstCaller(), _auditService.getCallerList());
                    _contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(_auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    _contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    _contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildMgmtData("subSystem", "auditStop", null);
                    auditOutcome = DataHelper.buildOutcomeData("ERROR", new Integer(0), new Integer(0), "ERROR", 83L);
                }
                try {
                    _auditService.sendEvent("SECURITY_MGMT_AUDIT", auditOutcome);
                }
                catch (ProviderFailureException pe) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                }
            }
            if (_recoveryPolicy != 1) {
                String emailAddress = null;
                String smtpServer = null;
                for (int i = 0; i < this._emailListSize; ++i) {
                    Tr.debug(tc, "_emailListEntry: " + this._emailListEntries[i]);
                    String emailEntry = this._emailListEntries[i].trim();
                    int index = emailEntry.indexOf("(");
                    if (index == -1) {
                        emailAddress = emailEntry;
                        index = emailEntry.indexOf("@");
                        if (index != -1) {
                            smtpServer = "smtp-server." + emailEntry.substring(index + 1);
                        }
                    } else {
                        smtpServer = emailEntry.substring(index + 1, emailEntry.length() - 1);
                        emailAddress = emailEntry.substring(0, index);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sending email to " + emailAddress + " at smtp server " + smtpServer + ".");
                    }
                    this.send(emailAddress, smtpServer, this.getMsg(resBundle, notificationText, new Object[]{e}));
                }
            }
            _active = false;
            this.stopAuditService();
            if (_recoveryPolicy == 3) {
                this.processName = AdminServiceFactory.getAdminService().getProcessName();
                this.processType = AdminServiceFactory.getAdminService().getProcessType();
                this.serverType = AdminServiceFactory.getAdminService().getServerType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processName: " + this.processName + " processType: " + this.processType + " serverType: " + this.serverType);
                }
                String fileExt = new String(".sh");
                String sOSName = System.getProperty("os.name").toLowerCase();
                if (sOSName.equals("^.*windows.*$")) {
                    fileExt = ".bat";
                }
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block9: {
                            try {
                                ObjectName server = AuditServiceImpl.this.getServerObjectName(AuditServiceImpl.this.processName);
                                if (server == null) break block9;
                                String opName = "stop";
                                try {
                                    Object[] params = null;
                                    String[] sig = null;
                                    int timeout = 600;
                                    ServerSocket statusSocket = AuditServiceImpl.this.getFreePort(timeout * 1000);
                                    Integer statusPort = null;
                                    if (statusSocket != null) {
                                        if (!AuditServiceImpl.this.processType.equals("NodeAgent")) {
                                            statusPort = new Integer(statusSocket.getLocalPort());
                                        }
                                        params = new Object[]{Boolean.TRUE, statusPort};
                                        sig = new String[]{"java.lang.Boolean", "java.lang.Integer"};
                                    }
                                    Object result = AuditServiceImpl.this.getAdminService().invoke(server, opName, params, sig);
                                    if (!AuditServiceImpl.this.processType.equals("NodeAgent")) {
                                        int status = -2;
                                        if (statusSocket != null) {
                                            status = AuditServiceImpl.this.waitForServerInit(statusSocket);
                                        }
                                        if (status != 0) {
                                            Tr.warning(tc, "Server did not stop");
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "An exception occurred waiting for the server stop:", e);
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "", "%", this);
                                if (!tc.isDebugEnabled()) break block9;
                                Tr.debug(tc, "Exception");
                            }
                        }
                        return null;
                    }
                };
                try {
                    ContextManagerFactory.getInstance().runAsSystem(action);
                }
                catch (PrivilegedActionException ee) {
                    FFDCFilter.processException((Throwable)ee.getException(), "com.ibm.ws.security.audit.AuditServiceImpl.processAuditFailure", "%", this);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Exception: ", new Object[]{ee.getException()});
                }
            }
        }
    }

    private ObjectName getServerObjectName(String serverName) {
        ObjectName _server = null;
        ObjectName queryName = null;
        try {
            queryName = new ObjectName("WebSphere:*,type=Server,process=" + serverName + ",node=" + this._nodeName);
            Set s = this.getAdminService().queryNames(queryName, null);
            if (s.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are " + s.size() + " Servers! queryName=" + queryName);
            }
            if (s.size() > 0) {
                Object[] o = s.toArray();
                _server = (ObjectName)o[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server handle is ==> " + _server.getCanonicalName());
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.AuditServiceImpl.getServerObjectName", "%", this);
            Tr.error(tc, "Exception gettingServerObjectName: " + e);
        }
        return _server;
    }

    private ServerSocket getFreePort(int timeout) {
        ServerSocket s = null;
        try {
            s = new ServerSocket(0);
            s.setSoTimeout(timeout);
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.security.audit.AuditServiceImpl.getFreePort", "%", this);
        }
        return s;
    }

    private AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        return this.adminService;
    }

    private int waitForServerInit(ServerSocket statusSocket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServerInit");
        }
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = statusSocket.accept();
            }
            catch (InterruptedIOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", "368", this);
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", "374", this);
                Tr.error(tc, "ADML0009E", ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = -1;
            }
            if (acceptedSocket == null || (result = this.getStatus(acceptedSocket)) != 0 && result != 0 && result != -1) continue;
            statusReceived = true;
        }
        if (!statusReceived) {
            result = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServerInit");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatus(Socket s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus");
        }
        int status = -1;
        InputStream socketInput = null;
        FilterInputStream dataInput = null;
        try {
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.nodeagent.NodeAgent.getStatus", "414", this);
            Tr.error(tc, "ADML0009E", e);
            int n = -1;
            return n;
        }
        finally {
            try {
                dataInput.close();
                socketInput.close();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.nodeagent.NodeAgent.getStatus", "425", this);
                Tr.error(tc, "ADML0009E", e);
            }
            dataInput = null;
            socketInput = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus");
        }
        return status;
    }

    public void send(String emailAddress, String smtpServer, String notificationText) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send");
        }
        try {
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", "smtp");
            props.setProperty("mail.host", smtpServer);
            props.setProperty("mail.user", emailAddress);
            props.setProperty("mail.password", "");
            Session mailSession = Session.getDefaultInstance(props, null);
            MimeMessage message = new MimeMessage(mailSession);
            message.setFrom(new InternetAddress("WebSphereNotification@ibm.com"));
            message.setContent(notificationText, "text/plain");
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(emailAddress));
            message.setSubject("WebSphere Notification from process: Audit Service");
            Transport transport = mailSession.getTransport();
            transport.connect();
            transport.sendMessage(message, message.getRecipients(Message.RecipientType.TO));
            transport.close();
        }
        catch (Exception e) {
            Tr.error(tc, "security.audit.send.mail.error", new Object[]{emailAddress, smtpServer, e.getMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception sending email to user.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.AuditServiceImpl.send", "156", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    static {
        _audit = null;
        activeUserRegistry = null;
        auditOutcome = new ConcurrentHashMap();
        propagateFirstCallerOnlyProperty = null;
        propagateFirstCallerOnly = true;
        auditReportGranularity = null;
    }
}

