/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditCrypto;
import com.ibm.ws.security.util.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuditKeyEncryptor {
    private static final TraceComponent tc = Tr.register(AuditKeyEncryptor.class, null, "com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    byte[] password;
    byte[] desKey;
    AuditCrypto des;

    public AuditKeyEncryptor(byte[] password) {
        this.password = password;
        MessageDigest md2 = null;
        try {
            md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            this.desKey = new byte[24];
            byte[] digest = md2.digest(this.password);
            ByteArray.copy(digest, 0, digest.length, this.desKey, 0);
            this.desKey[20] = 0;
            this.desKey[21] = 0;
            this.desKey[22] = 0;
            this.desKey[23] = 0;
        }
        catch (NoSuchAlgorithmException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", "21", this);
        }
        this.des = new AuditCrypto();
    }

    public byte[] decrypt(byte[] encrKey) {
        return AuditCrypto.decrypt(encrKey, this.desKey);
    }

    public byte[] encrypt(byte[] key) {
        return AuditCrypto.encrypt(key, this.desKey);
    }
}

