/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.audit.AccessContextObj;
import com.ibm.ws.security.audit.AuditEventSettings;
import com.ibm.ws.security.audit.AuthnContextObj;
import com.ibm.ws.security.audit.AuthnMappingContextObj;
import com.ibm.ws.security.audit.AuthnTermContextObj;
import com.ibm.ws.security.audit.CipherContextObj;
import com.ibm.ws.security.audit.CustomPropertyContextObj;
import com.ibm.ws.security.audit.DelegationContextObj;
import com.ibm.ws.security.audit.EventContextObj;
import com.ibm.ws.security.audit.KeyContextObj;
import com.ibm.ws.security.audit.MgmtContextObj;
import com.ibm.ws.security.audit.OutcomeType;
import com.ibm.ws.security.audit.PolicyContextObj;
import com.ibm.ws.security.audit.ProcessContextObj;
import com.ibm.ws.security.audit.PropagationContextObj;
import com.ibm.ws.security.audit.ProviderContextObj;
import com.ibm.ws.security.audit.RegistryContextObj;
import com.ibm.ws.security.audit.ResponseContextObj;
import com.ibm.ws.security.audit.SecurityAuditEventImpl;
import com.ibm.ws.security.audit.SessionContextObj;
import com.ibm.ws.security.audit.TargetAttributes;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.AuditConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.audit.AuditEventFactory;
import com.ibm.wsspi.security.audit.AuditEventType;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.audit.GenericEventCompletionException;
import com.ibm.wsspi.security.audit.GenericEventConfigurationException;
import com.ibm.wsspi.security.audit.GenericEventValidationException;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

public final class AuditEventFactoryImpl
implements AuditEventFactory {
    private static final TraceComponent tc = Tr.register(AuditEventFactoryImpl.class, "Security", "com.ibm.ejs.resources.security");
    private String _factoryName = null;
    private static AuditService _service = null;
    private String _cellName = null;
    private String _nodeName = null;
    private String _serverName = null;
    private Integer uniqueID = new Integer(0);
    private static final String _dummySessionId = "Null";
    private AuditEventSettings _aes = new AuditEventSettings();
    private ConcurrentHashMap auditFilterSettings = this._aes.getFilterSettings();
    private ConcurrentHashMap auditOutcomeSettings = this._aes.getOutcomeSettings();
    private static AuditConfig audit;
    private String activeUserRegistry = null;
    private static ConcurrentHashMap aOutcome;

    public void AuditEventFactoryImpl() {
    }

    public void init(String name, Map properties, Map context) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "init");
        }
        ContextHandler contextHandler = null;
        this._factoryName = name;
        if (context != null) {
            _service = (AuditService)context.get("com.ibm.wsspi.security.audit.AuditService");
            this._cellName = (String)context.get("cell");
            if (this._cellName == null) {
                this._cellName = SecurityObjectLocator.getAdminData().getString("cellname");
            }
            this._nodeName = (String)context.get("node");
            if (this._nodeName == null) {
                this._nodeName = SecurityObjectLocator.getAdminData().getString("nodename");
            }
            this._serverName = (String)context.get("server");
            if (this._serverName == null) {
                this._serverName = SecurityObjectLocator.getAdminData().getString("process.serverName");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell = " + this._cellName + " Node = " + this._nodeName + " Server = " + this._serverName);
            }
        }
        if (this._nodeName == null) {
            this._nodeName = _dummySessionId;
        }
        if (this._cellName == null) {
            this._cellName = _dummySessionId;
        }
        if (this._serverName == null) {
            this._serverName = _dummySessionId;
        }
        if (_service != null && (contextHandler = _service.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            _service.processAuditFailure(msg, null);
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void terminate() {
    }

    public void refresh(Map properties) throws ProviderFailureException {
    }

    public String getName() {
        return this._factoryName;
    }

    public boolean isAuditServiceActive() {
        if (audit != null) {
            return audit.getBoolean("auditEnabled");
        }
        audit = SecurityObjectLocator.getAuditConfig();
        if (audit == null) {
            return false;
        }
        return audit.getBoolean("auditEnabled");
    }

    public boolean isActive(String auditEventType, String auditOutcome) {
        ConcurrentHashMap o;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isActive");
        }
        if ((o = (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType)) != null && o.get(auditOutcome) != null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isActive(true)");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isActive(false)");
        }
        return false;
    }

    public void setActive(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setActive: " + auditEventType + " : " + auditOutcome);
        }
        this.auditOutcomeSettings = !this.auditFilterSettings.containsKey(auditEventType) ? new ConcurrentHashMap() : (ConcurrentHashMap)this.auditFilterSettings.get(auditEventType);
        this.auditOutcomeSettings.putIfAbsent(auditOutcome, "ACTIVE");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditOutcomeSettings: " + this.auditOutcomeSettings.toString());
        }
        if (this.auditFilterSettings.containsKey(auditEventType)) {
            this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        } else {
            this.auditFilterSettings.put(auditEventType, this.auditOutcomeSettings);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditFilters: " + this.auditFilterSettings.toString());
        }
        ContextHandler contextHandler = null;
        if (_service != null && (contextHandler = _service.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            _service.processAuditFailure(msg, null);
        }
        if (_service != null && _service.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterSet", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(_service.getLastTrailId(), _service.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(_service.getFirstCaller(), _service.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(_service.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.AuditEventFactoryImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                _service.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                _service.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setActive");
        }
    }

    public void resetActive(String auditEventType, String auditOutcome) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "resetActive");
        }
        this.auditOutcomeSettings.remove(auditOutcome);
        this.auditFilterSettings.replace(auditEventType, this.auditOutcomeSettings);
        ContextHandler contextHandler = null;
        if (_service != null && (contextHandler = _service.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            _service.processAuditFailure(msg, null);
        }
        if (_service != null && _service.isEventRequired("SECURITY_MGMT_AUDIT", "SUCCESS")) {
            if (contextHandler != null) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("WASServer", "auditPolicyModify", null, null, "authzSuccess", "AuditFilterRemove", "process", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(_service.getLastTrailId(), _service.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(_service.getFirstCaller(), _service.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(_service.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                TargetAttributes[] ta = new TargetAttributes[1];
                TargetAttributes cfr_ignored_0 = ta[0];
                TargetAttributes.name = "com.ibm.ws.security.audit.AuditEventFactoryImpl".concat(auditEventType).concat(":").concat(auditOutcome);
                TargetAttributes cfr_ignored_1 = ta[0];
                TargetAttributes.uniqueId = 0L;
                data = DataHelper.buildMgmtData("subSystem", "auditPolicyModify", ta);
                aOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 85L);
            }
            try {
                _service.sendEvent("SECURITY_MGMT_AUDIT", aOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                _service.processAuditFailure(msg, e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "resetActive");
        }
    }

    public String getActive() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getActive");
        }
        String s = new String("{");
        s = s.concat(this.auditFilterSettings.toString()).concat("}");
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getActive: " + s);
        }
        return s;
    }

    public boolean sendEvent(String auditEventType, OutcomeType auditOutcome) throws ProviderFailureException {
        return false;
    }

    public boolean sendEvent(String auditEventType, ConcurrentHashMap auditOutcome) throws ProviderFailureException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "sendEvent: " + auditEventType + " " + auditOutcome.get("OutcomeFailureReason"));
        }
        if (_service != null) {
            Object auditEvent = null;
            try {
                auditEvent = this.buildEvent(auditEventType, auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.build.event.object.error", new Object[]{e});
                throw new ProviderFailureException(e);
            }
            try {
                _service.sendEvent(auditEvent, this._factoryName);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                throw new ProviderFailureException(e);
            }
        }
        String msg = "AuditService is null: failure to send audit event";
        throw new ProviderFailureException(msg);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "sendEvent(true)");
        }
        return true;
    }

    public Object buildEvent(String auditEventType, ConcurrentHashMap auditOutcome) throws ProviderFailureException {
        ContextHandler contextHandler;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildEvent: auditEventType: " + auditEventType + " auditOutcome: " + auditOutcome.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: buildEvent, thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
        }
        if ((contextHandler = _service.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "Failure to gather audit record data";
            throw new ProviderFailureException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: buildEvent, thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
        }
        SessionContextObj sessionContext = (SessionContextObj)contextHandler.getContextObject("SESSION_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (sessionContext != null && sessionContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, sessionContext: " + sessionContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, sessionContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        PropagationContextObj propagationContext = (PropagationContextObj)contextHandler.getContextObject("PROPAGATION_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (propagationContext != null && propagationContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, progpagationContext: " + propagationContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, progpagationContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        RegistryContextObj registryContext = (RegistryContextObj)contextHandler.getContextObject("REGISTRY_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (registryContext != null && registryContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, registryContext: " + registryContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, registryContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        ProcessContextObj processContext = (ProcessContextObj)contextHandler.getContextObject("PROCESS_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (processContext != null && processContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, processContext: " + processContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, processContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        DelegationContextObj delegationContext = (DelegationContextObj)contextHandler.getContextObject("APPLICATION_DELEGATION");
        if (tc.isDebugEnabled()) {
            if (delegationContext != null && delegationContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, delegationContext: " + delegationContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, delegationContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        AuthnContextObj authnContext = (AuthnContextObj)contextHandler.getContextObject("AUTHN_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (authnContext != null && authnContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, authnContext: " + authnContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, authnContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        ProviderContextObj providerContext = (ProviderContextObj)contextHandler.getContextObject("AUTHN_PROVIDER_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (providerContext != null && providerContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, providerContext: " + providerContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, providerContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        AuthnMappingContextObj authnMappingContext = (AuthnMappingContextObj)contextHandler.getContextObject("AUTHN_MAPPING_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (authnMappingContext != null && authnMappingContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, authnMappingContext: " + authnMappingContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, authnMappingContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        AuthnTermContextObj authnTermContext = (AuthnTermContextObj)contextHandler.getContextObject("AUTHN_TERM_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (authnTermContext != null && authnTermContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, authnTermContext: " + authnTermContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, authnTermContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        AccessContextObj accessContext = (AccessContextObj)contextHandler.getContextObject("ACCESS_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (accessContext != null && accessContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, accessContext: " + accessContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, accessContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        EventContextObj eventContext = (EventContextObj)contextHandler.getContextObject("EVENT_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (eventContext != null && eventContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, eventContext: " + eventContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, eventContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        PolicyContextObj policyContext = (PolicyContextObj)contextHandler.getContextObject("POLICY_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (policyContext != null && policyContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, policyContext: " + policyContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, policyContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        KeyContextObj keyContext = (KeyContextObj)contextHandler.getContextObject("KEY_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (keyContext != null && keyContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, keyContext: " + keyContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, keyContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        CipherContextObj cipherContext = (CipherContextObj)contextHandler.getContextObject("CIPHER_CONTEXT");
        MgmtContextObj mgmtContext = (MgmtContextObj)contextHandler.getContextObject("MGMT_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (mgmtContext != null && mgmtContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, mgmtContext: " + mgmtContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, mgmtContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        ResponseContextObj responseContext = (ResponseContextObj)contextHandler.getContextObject("RESPONSE_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (responseContext != null && responseContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, responseContext: " + responseContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, responseContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        CustomPropertyContextObj customContext = (CustomPropertyContextObj)contextHandler.getContextObject("CUSTOM_PROPERTY_CONTEXT");
        if (tc.isDebugEnabled()) {
            if (customContext != null && customContext.getMap() != null) {
                Tr.debug(tc, "TEQ: buildEvent, customContext: " + customContext.getMap().toString() + "  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            } else {
                Tr.debug(tc, "TEQ: buildEvent, customContext is empty  thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            }
        }
        try {
            String reason = (String)auditOutcome.get("OutcomeFailureReason");
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHN")) {
                return this.buildAuthnEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, providerContext, authnContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHN_CREDS_MOD")) {
                return this.buildAuthnCredsModifyEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHN_DELEGATION")) {
                return this.buildAuthnDelegationEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, delegationContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHN_MAPPING")) {
                return this.buildAuthnMappingEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, authnMappingContext, providerContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHN_TERMINATE")) {
                return this.buildAuthnTerminateEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, authnContext, providerContext, authnTermContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_AUTHZ")) {
                return this.buildAuthzEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, providerContext, policyContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_ENCRYPTION")) {
                return this.buildEncryptionEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, keyContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_AUDIT")) {
                return this.buildMgmtAuditEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_CONFIG")) {
                return this.buildMgmtConfigEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_KEY")) {
                return this.buildMgmtKeyEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, keyContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_POLICY")) {
                return this.buildMgmtPolicyEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, policyContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_PROVISIONING")) {
                return this.buildMgmtProvisioningEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_REGISTRY")) {
                return this.buildMgmtRegistryEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_MGMT_RESOURCE")) {
                return this.buildMgmtResourceEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, mgmtContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_RESOURCE_ACCESS")) {
                return this.buildResourceAccessEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, responseContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_RUNTIME")) {
                return this.buildRuntimeEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_RUNTIME_KEY")) {
                return this.buildRuntimeKeyEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, keyContext, auditOutcome, customContext);
            }
            if (auditEventType.equalsIgnoreCase("SECURITY_SIGNING")) {
                return this.buildSigningEvent(reason, sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, keyContext, auditOutcome, customContext);
            }
        }
        catch (Exception e) {
            throw new ProviderFailureException(e);
        }
        return null;
    }

    public HashMap buildCommon(SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) {
        HashMap<String, String> properties;
        block29: {
            ContextManager ctxMgr;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "buildCommon");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TEQ: on entry to buildCommon: ");
                Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
                Tr.debug(tc, "     sessionContext: " + sessionContext.getMap().toString());
                Tr.debug(tc, "     accessContext: " + accessContext.getMap().toString());
                Tr.debug(tc, "     eventContext: " + eventContext.getMap().toString());
            }
            properties = new HashMap<String, String>();
            properties.putAll(sessionContext.getMap());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TEQ: properties after adding sessionContextMap: " + properties.toString());
            }
            if ((accessContext.getAppUserName() == null || accessContext.getAppUserName() == "null") && (ctxMgr = ContextManagerFactory.getInstance()) != null) {
                WSSecurityPropagationHelper propHelper = WSSecurityPropagationHelper.getInstance();
                if (!(propHelper.isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
                    try {
                        Subject sub = ctxMgr.getCallerSubject();
                        if (sub != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "PASSED IN NULL FOR APPNAME, buildCommon, propagation not enabled, caller subject: " + ((Principal)sub.getPrincipals().toArray()[0]).getName());
                            }
                            accessContext.setAppUserName(((Principal)sub.getPrincipals().toArray()[0]).getName());
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "PASSED IN NULL FOR APPNAME, buildCommon, propagation not enabled, caller subject is null, not setting");
                        }
                        break block29;
                    }
                    catch (WSSecurityException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "PASSED IN NULL FOR APPNAME, buildCommon, propagation not enabled, caught exception, doing nothing");
                        }
                        break block29;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PASSED IN NULL FOR APPNAME, buildCommon, propagation enabled, returning: " + _service.getFirstCaller());
                }
                if (_service.getFirstCaller() == null) {
                    accessContext.setAppUserName("null");
                } else {
                    accessContext.setAppUserName(_service.getFirstCaller());
                }
            }
        }
        properties.putAll(accessContext.getMap());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: properties after adding accessContextMap: " + properties.toString());
        }
        properties.putAll(eventContext.getMap());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: properties after adding eventContextMap: " + properties.toString());
        }
        if (!_service.isVerbose()) {
            if (!propagationContext.getMap().isEmpty() && propagationContext.getFirstCaller() != null) {
                properties.put("FirstCaller", propagationContext.getFirstCaller());
            }
            if (processContext.getRealm() != null) {
                properties.put("Realm", processContext.getRealm());
            }
        } else {
            if (!propagationContext.getMap().isEmpty()) {
                properties.putAll(propagationContext.getMap());
            }
            properties.putAll(processContext.getMap());
        }
        if (registryContext.getType() == null || registryContext.getType() == "null") {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            this.activeUserRegistry = security2.getActiveUserRegistry().getType();
            registryContext.setType(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PASSED IN NULL FOR REGISTRY, GETTING OURSELVES: " + DataHelper.convertRegistryInfoType(this.activeUserRegistry));
            }
        }
        properties.putAll(registryContext.getMap());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: properties after adding registryContextMap: " + properties.toString());
        }
        properties.putAll(auditOutcome);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: properties after adding auditOutcome: " + properties.toString());
        }
        if (customContext != null && customContext.getMap() != null && !customContext.getMap().isEmpty()) {
            properties.putAll(customContext.getMap());
            customContext.getMap().clear();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildCommon, properties: " + properties.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildCommon");
        }
        return properties;
    }

    public Object buildAuthnEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ProviderContextObj providerContext, AuthnContextObj authnContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthnEvent");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TEQ: on entry to buildAuthnEvent: ");
            Tr.debug(tc, "     thread id: " + Thread.currentThread().getId() + " thread info: " + Thread.currentThread().toString());
            Tr.debug(tc, "     sessionContext: " + sessionContext.getMap().toString());
            Tr.debug(tc, "     accessContext: " + accessContext.getMap().toString());
            Tr.debug(tc, "     eventContext: " + eventContext.getMap().toString());
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHN.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(providerContext.getMap());
        properties.putAll(authnContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthnEvent");
        }
        return auditEvent;
    }

    public Object buildAuthnCredsModifyEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthnCredsModifyEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHN_CREDS_MODIFY.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthnCredsModifyEvent");
        }
        return auditEvent;
    }

    public Object buildAuthnDelegationEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, DelegationContextObj delegationContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthnDelegationEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHN_DELEGATION.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(delegationContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthnDelegationEvent");
        }
        return auditEvent;
    }

    public Object buildAuthnMappingEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, AuthnMappingContextObj authnMappingContext, ProviderContextObj providerContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthnMappingEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHN_MAPPING.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(authnMappingContext.getMap());
        properties.putAll(providerContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthnMappingEvent");
        }
        return auditEvent;
    }

    public Object buildAuthnTerminateEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, AuthnContextObj authnContext, ProviderContextObj providerContext, AuthnTermContextObj authnTermContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthnTerminateEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHN_TERMINATE.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(authnContext.getMap());
        properties.putAll(providerContext.getMap());
        properties.putAll(authnTermContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthnTerminateEvent");
        }
        return auditEvent;
    }

    public Object buildAuthzEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ProviderContextObj providerContext, PolicyContextObj policyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildAuthzEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.AUTHZ.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(providerContext.getMap());
        properties.putAll(policyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildAuthzEvent");
        }
        return auditEvent;
    }

    public Object buildEncryptionEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, KeyContextObj keyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildEncryptionEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.ENCRYPTION.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(keyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildEncryptionEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtAuditEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtAuditEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_AUDIT.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildEncryptionEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtConfigEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtConfigEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_CONFIG.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtConfigEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtKeyEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, KeyContextObj keyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtKeyEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_KEY.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        properties.putAll(keyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtKeyEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtPolicyEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, PolicyContextObj policyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtPolicyEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_POLICY.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        properties.putAll(policyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtPolicyEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtProvisioningEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtProvisioningEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_PROVISIONING.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtProvisioningEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtRegistryEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtRegistryEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_REGISTRY.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtRegistryEvent");
        }
        return auditEvent;
    }

    public Object buildMgmtResourceEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, MgmtContextObj mgmtContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildMgmtResourceEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.MGMT_RESOURCE.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (mgmtContext.getMgmtType() != null) {
                properties.put("MgmtType", mgmtContext.getMgmtType());
            }
            if (mgmtContext.getMgmtCommand() != null) {
                properties.put("MgmtCommand", mgmtContext.getMgmtCommand());
            }
        } else {
            properties.putAll(mgmtContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildMgmtResourceEvent");
        }
        return auditEvent;
    }

    public Object buildResourceAccessEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ResponseContextObj responseContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildResourceAccessEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.RESOURCE_ACCESS.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        if (!_service.isVerbose()) {
            if (responseContext.getUrl() != null) {
                properties.put("Url", responseContext.getUrl());
            }
        } else {
            properties.putAll(responseContext.getMap());
        }
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildResourceAccessEvent");
        }
        return auditEvent;
    }

    public Object buildRuntimeEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildRuntimeEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.RUNTIME.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildRuntimeEvent");
        }
        return auditEvent;
    }

    public Object buildRuntimeKeyEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, KeyContextObj keyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildRuntimeKeyEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.RUNTIME_KEY.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(keyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildRuntimeKeyEvent");
        }
        return auditEvent;
    }

    public Object buildSigningEvent(String outcome, SessionContextObj sessionContext, AccessContextObj accessContext, EventContextObj eventContext, PropagationContextObj propagationContext, ProcessContextObj processContext, RegistryContextObj registryContext, KeyContextObj keyContext, ConcurrentHashMap auditOutcome, CustomPropertyContextObj customContext) throws GenericEventConfigurationException, GenericEventValidationException, GenericEventCompletionException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "buildSigningEvent");
        }
        SecurityAuditEventImpl genericEvent = new SecurityAuditEventImpl();
        Object auditEvent = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EVENT_TYPE", AuditEventType.SIGNING.getAuditEventTypeStr());
        properties.putAll(this.buildCommon(sessionContext, accessContext, eventContext, propagationContext, processContext, registryContext, auditOutcome, customContext));
        properties.putAll(keyContext.getMap());
        try {
            auditEvent = genericEvent.buildEvent(properties);
        }
        catch (GenericEventConfigurationException e1) {
            throw new GenericEventConfigurationException(e1);
        }
        catch (GenericEventValidationException e2) {
            throw new GenericEventValidationException(e2);
        }
        catch (GenericEventCompletionException e3) {
            throw new GenericEventCompletionException(e3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "auditEvent: " + auditEvent.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "buildRuntimeKeyEvent");
        }
        return auditEvent;
    }

    static {
        aOutcome = new ConcurrentHashMap();
    }
}

