/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditCrypto;
import com.ibm.ws.security.audit.AuditKeyEncryptor;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.wsspi.security.audit.AuditDecryptException;
import com.ibm.wsspi.security.audit.AuditEncryptException;
import com.ibm.wsspi.security.audit.AuditEncryption;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;

public class AuditEncryptionImpl
implements AuditEncryption {
    private static final TraceComponent tc = Tr.register(AuditEncryptionImpl.class, null, "com.ibm.ejs.resources.security");
    String[] ciphers = null;
    AuditCrypto crypto = null;
    Key sharedkey = null;
    String cellName = null;
    String nodeName = null;
    String serverName = null;
    int aliasIncrement = 1;
    private static AuditEncryptionImpl ae = null;
    private static String subjectDN = "CN=auditsigner, OU=SWG, O=IBM, C=US";
    private static String keyStoreName = "auditSignerKeyStore_";
    private static String certLabelPrefix = "auditcert";
    private static String CRYPTO_ALGORITHM = "SHA256withRSA";
    private int signerKeyStoreIncrement = 1;
    private CertReqInfo certInfo = null;
    private ObjectName mgmScopeObjName = null;
    AuditKeyEncryptor encryptor = null;
    private String expandedConfigRoot = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
    private String _name = null;
    private String _location = null;
    private String _type = null;
    private String _provider = null;
    private String _password = null;
    private String _alias = null;

    public static AuditEncryptionImpl getInstance(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptException {
        try {
            if (ae == null) {
                ae = new AuditEncryptionImpl(keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias);
            }
            return ae;
        }
        catch (AuditEncryptException e) {
            throw new AuditEncryptException(e);
        }
    }

    public AuditEncryptionImpl(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuditEncryptionImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyStoreName: " + keyStoreName + " keyStorePath: " + keyStorePath + " keyStoreType: " + keyStoreType + " keyStoreProvider: " + keyStoreProvider + " keyStorePassword: " + keyStorePassword + " keyAlias: " + keyAlias);
        }
        try {
            this.initialize(keyStoreName, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyAlias);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception initializing AuditEncryptionImpl.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.AuditEncryptionImpl.constructor", "96", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuditEncryptionImpl");
        }
    }

    public void initialize(String keyStoreName, String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyAlias) throws AuditEncryptException {
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        Boolean securityEnabled = security2.getBoolean("enabled");
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!(ContextManagerFactory.getInstance().isCellSecurityEnabled() || csiv2.getBoolean("com.ibm.CORBA.securityEnabled") || securityEnabled.booleanValue())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security disabled, not initializing audit encryptor.");
            }
            return;
        }
        this._name = keyStoreName;
        this._location = keyStorePath;
        this._type = keyStoreType;
        this._provider = keyStoreProvider;
        this._password = keyStorePassword;
        this._alias = keyAlias;
        this.crypto = new AuditCrypto();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_name: " + this._name + " _location: " + this._location + " _type: " + this._type + " _provider: " + this._provider + " _keyStorePassword: " + this._password + " _alias: " + this._alias);
        }
        long begin_time = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing audit encryptor at " + new Date(System.currentTimeMillis()));
        }
        this.cellName = SecurityObjectLocator.getAdminData().getString("cellname");
        this.nodeName = SecurityObjectLocator.getAdminData().getString("nodename");
        this.serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Key generateSharedKey() throws java.security.KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateSharedKey");
        }
        SecretKeySpec sharedKey = null;
        try {
            if (this.crypto != null) {
                AuditEncryptionImpl auditEncryptionImpl = this;
                sharedKey = new SecretKeySpec(auditEncryptionImpl.crypto.generate3DESKey(), 0, 24, "DESede");
            }
            if (sharedKey != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateSharedKey");
                }
                return sharedKey;
            }
            throw new KeyException("Key could not be generated.");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.audit.AuditEncryptionImpl.generateKey", "98", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error generating key.", new Object[]{e});
            }
            if (e instanceof java.security.KeyException) {
                throw (java.security.KeyException)e;
            }
            throw new java.security.KeyException(e.getMessage(), e);
        }
    }

    public String generateAliasForSharedKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateAliasForSharedKey");
        }
        String alias = null;
        if (this.cellName != null && this.nodeName != null && this.serverName != null) {
            alias = this.cellName + this.nodeName + this.serverName + "Alias" + new Integer(this.aliasIncrement).toString();
        }
        ++this.aliasIncrement;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateAliasForSharedKey: alias = " + alias);
        }
        return alias;
    }

    public X509Certificate retrieveCertificate() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveCertificate");
        }
        Object publicKey = null;
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(this._type, this._provider);
            InputStream is = AuditEncryptionImpl.openKeyStore(this._location);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "successfully opened the keystore at " + this._location);
            }
            ks.load(is, this._password.toCharArray());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "successfully loaded the keystore at " + this._location);
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(this._alias);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "retrieveCertificate");
            }
            return cert;
        }
        catch (NoSuchProviderException ne) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such provider.", ne.getMessage());
            }
            throw new IOException(ne.getMessage());
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: malformed URL", me.getMessage());
            }
            throw new IOException(me.getMessage());
        }
        catch (KeyStoreException ke) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ke.getMessage());
            }
            throw new IOException(ke.getMessage());
        }
        catch (NoSuchAlgorithmException ae) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore: no such algorithm", ae.getMessage());
            }
            throw new IOException(ae.getMessage());
        }
        catch (CertificateException ce) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting certificate.", ce.getMessage());
            }
            throw new IOException(ce.getMessage());
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw new IOException(ioe.getMessage());
        }
    }

    public Key retrievePublicKey() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrievePublicKey");
        }
        PublicKey publicKey = null;
        try {
            X509Certificate cert = this.retrieveCertificate();
            publicKey = cert.getPublicKey();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "retrievePublicKey");
            }
            return publicKey;
        }
        catch (MalformedURLException me) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", me.getMessage());
            }
            throw new IOException(me.getMessage());
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", ioe.getMessage());
            }
            throw new IOException(ioe.getMessage());
        }
    }

    public byte[] encryptSharedKey(Key sharedKey, Key pKey) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptSharedKey");
        }
        byte[] encryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR!!! shared key is null!");
            }
            return null;
        }
        byte[] encodedPublicKey = pKey.getEncoded();
        byte[] encodedSharedKey = sharedKey.getEncoded();
        this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        encryptedSharedKey = this.encryptor.encrypt(encodedSharedKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptedSharedKey");
        }
        return encryptedSharedKey;
    }

    public byte[] decryptSharedKey(byte[] sharedKey, Key pKey) throws IOException {
        byte[] encodedPublicKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptSharedKey");
        }
        byte[] decryptedSharedKey = null;
        if (sharedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR!!! shared key is null!");
            }
            return null;
        }
        if (this.encryptor == null) {
            encodedPublicKey = pKey.getEncoded();
            this.encryptor = new AuditKeyEncryptor(encodedPublicKey);
        }
        encodedPublicKey = pKey.getEncoded();
        decryptedSharedKey = this.encryptor.decrypt(sharedKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptSharedKey");
        }
        return decryptedSharedKey;
    }

    public byte[] encrypt(byte[] data, Key sharedKey) throws AuditEncryptException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt");
        }
        if (data == null) {
            Tr.error(tc, "security.audit.encryption.data.error");
            throw new AuditEncryptException("Invalid data passed into the encryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error(tc, "security.audit.invalid.shared.key.error");
            throw new AuditEncryptException("An invalid shared key was detected.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] encryptedData = AuditCrypto.encrypt(data, sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt");
        }
        return encryptedData;
    }

    public byte[] decrypt(byte[] data, Key sharedKey) throws AuditDecryptException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt");
        }
        if (data == null) {
            Tr.error(tc, "security.audit.decryption.data.error");
            throw new AuditDecryptException("Invalid data passed into the decryption algorithm.");
        }
        if (sharedKey == null) {
            Tr.error(tc, "security.audit.invalid.shared.key.error");
            throw new AuditDecryptException("An invalid shared key was detected.");
        }
        AuditCrypto ac = new AuditCrypto();
        byte[] decryptedData = AuditCrypto.decrypt(data, sharedKey.getEncoded());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt");
        }
        return decryptedData;
    }

    protected static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore" + fileName);
        }
        try {
            OpenKeyStoreAction action = new OpenKeyStoreAction(fileName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openKeyStore");
            }
            return (InputStream)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{ex});
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String fileName) {
            this.file = fileName;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "OpenKeyStoreAction.run");
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (kfile.exists() && kfile.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            urlFile = !kfile.exists() ? new URL(this.file) : new URL("file:" + kfile.getCanonicalPath());
            fis = urlFile.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "OpenKeyStoreAction.run");
            }
            return fis;
        }
    }
}

