/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.security.SecurityCommon;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.admintask.securityDomain.ConfigureAuthData;
import com.ibm.ws.security.admintask.securityDomain.ConfigureAuthzConfig;
import com.ibm.ws.security.admintask.securityDomain.ConfigureCustomUserRegistry;
import com.ibm.ws.security.admintask.securityDomain.ConfigureJAASLogin;
import com.ibm.ws.security.admintask.securityDomain.ConfigureLDAPUserRegistry;
import com.ibm.ws.security.admintask.securityDomain.ConfigureLTPAAuthMechanism;
import com.ibm.ws.security.admintask.securityDomain.ConfigureLocalOSUserRegistry;
import com.ibm.ws.security.admintask.securityDomain.ConfigureWIMUserRegistry;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SecurityConfigProvider
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(SecurityConfigProvider.class, "security", "com.ibm.ws.security.admintask.securityDomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    String inboundSAP = "com.ibm.CSI.rmiInboundPropagationEnabled";
    String inboundLoginCfg = "com.ibm.CSI.rmiInboundLoginConfig";
    String outboundSAP = "com.ibm.CSI.rmiOutboundPropagationEnabled";
    String outboundLogin = "com.ibm.CSI.rmiOutboundLoginEnabled";
    String outboundLoginCfg = "com.ibm.CSI.rmiOutboundLoginConfig";
    String outboundTargetRealms = "com.ibm.CSI.supportedTargetRealms";

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName = metadata2.getName();
        if (cmdName.equals("configureAdminLocalOSUserRegistry")) {
            return new ConfigureLocalOSUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAppLocalOSUserRegistry")) {
            return new ConfigureLocalOSUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAdminCustomUserRegistry")) {
            return new ConfigureCustomUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAppCustomUserRegistry")) {
            return new ConfigureCustomUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAdminWIMUserRegistry")) {
            return new ConfigureWIMUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAppWIMUserRegistry")) {
            return new ConfigureWIMUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureTrustAssociation")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureTrustAssociation")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getTrustAssociationInfo")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureInterceptor")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listInterceptors")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureInterceptor")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureSingleSignon")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getSingleSignon")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getLTPATimeout")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("setLTPATimeout")) {
            return new ConfigureLTPAAuthMechanism((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("createAuthDataEntry")) {
            return new ConfigureAuthData((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("modifyAuthDataEntry")) {
            return new ConfigureAuthData((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("deleteAuthDataEntry")) {
            return new ConfigureAuthData((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getAuthDataEntry")) {
            return new ConfigureAuthData((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listAuthDataEntries")) {
            return new ConfigureAuthData((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAdminLDAPUserRegistry")) {
            return new ConfigureLDAPUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAppLDAPUserRegistry")) {
            return new ConfigureLDAPUserRegistry((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureJAASLoginEntry")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listJAASLoginEntries")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureLoginModule")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("listLoginModules")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureJAASLoginEntry")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureJAASLogin")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureLoginModule")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getJAASLoginEntryInfo")) {
            return new ConfigureJAASLogin((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("configureAuthzConfig")) {
            return new ConfigureAuthzConfig((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("getAuthzConfigInfo")) {
            return new ConfigureAuthzConfig((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("unconfigureAuthzConfig")) {
            return new ConfigureAuthzConfig((TaskCommandMetadata)metadata2);
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName = cmdData.getName();
        if (cmdName.equals("configureAdminLocalOSUserRegistry")) {
            return new ConfigureLocalOSUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAppLocalOSUserRegistry")) {
            return new ConfigureLocalOSUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAdminCustomUserRegistry")) {
            return new ConfigureCustomUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAppCustomUserRegistry")) {
            return new ConfigureCustomUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAdminWIMUserRegistry")) {
            return new ConfigureWIMUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAppWIMUserRegistry")) {
            return new ConfigureWIMUserRegistry(cmdData);
        }
        if (cmdName.equals("configureTrustAssociation")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("unconfigureTrustAssociation")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("getTrustAssociationInfo")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("unconfigureInterceptor")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("listInterceptors")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("configureInterceptor")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("configureSingleSignon")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("getSingleSignon")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("getLTPATimeout")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("setLTPATimeout")) {
            return new ConfigureLTPAAuthMechanism(cmdData);
        }
        if (cmdName.equals("createAuthDataEntry")) {
            return new ConfigureAuthData(cmdData);
        }
        if (cmdName.equals("modifyAuthDataEntry")) {
            return new ConfigureAuthData(cmdData);
        }
        if (cmdName.equals("deleteAuthDataEntry")) {
            return new ConfigureAuthData(cmdData);
        }
        if (cmdName.equals("getAuthDataEntry")) {
            return new ConfigureAuthData(cmdData);
        }
        if (cmdName.equals("listAuthDataEntries")) {
            return new ConfigureAuthData(cmdData);
        }
        if (cmdName.equals("configureAdminLDAPUserRegistry")) {
            return new ConfigureLDAPUserRegistry(cmdData);
        }
        if (cmdName.equals("configureAppLDAPUserRegistry")) {
            return new ConfigureLDAPUserRegistry(cmdData);
        }
        if (cmdName.equals("configureJAASLoginEntry")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("listJAASLoginEntries")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("configureLoginModule")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("listLoginModules")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("unconfigureJAASLoginEntry")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("unconfigureLoginModule")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("unconfigureJAASLogin")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("getJAASLoginEntryInfo")) {
            return new ConfigureJAASLogin(cmdData);
        }
        if (cmdName.equals("configureAuthzConfig")) {
            return new ConfigureAuthzConfig(cmdData);
        }
        if (cmdName.equals("getAuthzConfigInfo")) {
            return new ConfigureAuthzConfig(cmdData);
        }
        if (cmdName.equals("unconfigureAuthzConfig")) {
            return new ConfigureAuthzConfig(cmdData);
        }
        return super.loadCommand(cmdData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public AttributeList getUserRegistryInfo(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistryInfo");
        }
        ObjectName secObj = null;
        AttributeList registryInfo = null;
        try {
            ArrayList registries;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            String registryType = (String)cmd.getParameter("userRegistryType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userRegistryInfo name is " + registryType);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            }
            if (registryType != null && registryType.length() > 0) {
                if (!this.validUserRegType(registryType)) {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                    throw new CommandValidationException(msg);
                }
            } else {
                ObjectName activeUserRegistry = (ObjectName)configService.getAttribute(session, secObj, "activeUserRegistry");
                if (activeUserRegistry != null) {
                    AttributeList attrs = configService.getAttributes(session, activeUserRegistry, null, false);
                    registryType = (String)ConfigServiceHelper.getAttributeValue(attrs, "_Websphere_Config_Data_Type");
                }
            }
            if ((registries = (ArrayList)configService.getAttribute(session, secObj, "userRegistries")) != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    String bindPassword;
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    String serverPassword = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "serverPassword");
                    String ur = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                    if (!ur.equals(registryType)) continue;
                    if (registryType.equalsIgnoreCase("LDAPUserRegistry") && (bindPassword = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "bindPassword")) != null && !bindPassword.equals("")) {
                        urAttrs.remove(new Attribute("bindPassword", bindPassword));
                        urAttrs.add(new Attribute("bindPassword", "*******"));
                    }
                    if (serverPassword != null && !serverPassword.equals("")) {
                        urAttrs.remove(new Attribute("serverPassword", serverPassword));
                        urAttrs.add(new Attribute("serverPassword", "*******"));
                    }
                    ConfigServiceHelper.removeAttribute(urAttrs, "limit");
                    if (secDomain != null && !secDomain.equals("")) {
                        ConfigServiceHelper.removeAttribute(urAttrs, "primaryAdminId");
                        ConfigServiceHelper.removeAttribute(urAttrs, "useRegistryServerId");
                        ConfigServiceHelper.removeAttribute(urAttrs, "serverId");
                        ConfigServiceHelper.removeAttribute(urAttrs, "serverPassword");
                    }
                    registryInfo = urAttrs;
                    break;
                }
            }
            if (registryInfo == null) {
                String msg = this.getMsg(resBundle, "security.admintask.registryDoesNotExist.SECJ7704E", null);
                throw new CommandValidationException(msg);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "198");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserRegistryInfo");
            }
        }
        return registryInfo;
    }

    public void unconfigureUserRegistry(AbstractAdminCommand cmd) throws Exception {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "unconfigureLocalOSUserRegistry");
            }
            ObjectName secObj = null;
            ObjectName activeRegistryObj = null;
            Boolean secEnabled = Boolean.FALSE;
            try {
                ArrayList registries;
                CommandProviderHelper helper = this.getCommandProviderHelper();
                ConfigService configService = helper.getConfigService();
                Session session = cmd.getConfigSession();
                String secDomain = (String)cmd.getParameter("securityDomainName");
                String registryType = (String)cmd.getParameter("userRegistryType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "securityDomainName name is " + secDomain);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "userRegistryInfo name is " + registryType);
                }
                if (!this.validUserRegType(registryType)) {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                    throw new CommandValidationException(msg);
                }
                if (secDomain != null) {
                    if (secDomain.equals("PassThroughToGlobalSecurity")) {
                        String command = cmd.getName();
                        String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                        throw new CommandValidationException(msg);
                    }
                    secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                    if (secObj == null) {
                        String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                        throw new CommandValidationException(msg);
                    }
                } else {
                    secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
                    if (secObj != null) {
                        secEnabled = (Boolean)configService.getAttribute(session, secObj, "enabled");
                    }
                }
                if ((registries = (ArrayList)configService.getAttribute(session, secObj, "userRegistries")) == null) break block21;
                for (int i = 0; i < registries.size(); ++i) {
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    ObjectName[] urObj = configService.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(urAttrs), null);
                    String ur = (String)ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                    if (!ur.equals(registryType)) continue;
                    if ((secEnabled.booleanValue() || secDomain != null) && (activeRegistryObj = (ObjectName)configService.getAttribute(session, secObj, "activeUserRegistry")) != null && activeRegistryObj.getKeyProperty("_Websphere_Config_Data_Type").equalsIgnoreCase(registryType)) {
                        String msg = this.getMsg(resBundle, "security.admintask.noUnconfigure.SECJ7726E", new Object[]{registryType});
                        throw new CommandValidationException(msg);
                    }
                    if (secDomain != null) {
                        configService.deleteConfigData(session, urObj[0]);
                    } else {
                        AttributeList attrs = new AttributeList();
                        attrs.add(new Attribute("serverId", null));
                        attrs.add(new Attribute("serverPassword", null));
                        attrs.add(new Attribute("realm", null));
                        attrs.add(new Attribute("primaryAdminId", null));
                        if (registryType.equals("LDAP")) {
                            attrs.add(new Attribute("sslEnabled", "false"));
                            attrs.add(new Attribute("sslConfig", null));
                            attrs.add(new Attribute("bindDN", null));
                            attrs.add(new Attribute("baseDN", null));
                            attrs.add(new Attribute("bindPassword", null));
                        }
                        configService.setAttributes(session, urObj[0], attrs);
                    }
                    break;
                }
            }
            catch (Exception cse) {
                FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "290");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", cse);
                }
                throw cse;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "unconfigureLocalOSUserRegistry");
                }
            }
        }
    }

    public void configureCSIInbound(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureCSIInbound");
        }
        ObjectName secObj = null;
        ArrayList attrList = null;
        String[] mechanisms = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            String messageLevelAuth = (String)cmd.getParameter("messageLevelAuth");
            String supportedAuthMechList = (String)cmd.getParameter("supportedAuthMechList");
            String clientCertAuth = (String)cmd.getParameter("clientCertAuth");
            String transportLayer = (String)cmd.getParameter("transportLayer");
            String sslConfiguration = (String)cmd.getParameter("sslConfiguration");
            Boolean enableIdentityAssertion = (Boolean)cmd.getParameter("enableIdentityAssertion");
            String trustedIdentities = (String)cmd.getParameter("trustedIdentities");
            Boolean statefulSession = (Boolean)cmd.getParameter("statefulSession");
            Boolean enableAttributePropagation = (Boolean)cmd.getParameter("enableAttributePropagation");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageLevelAuthentication name is " + messageLevelAuth);
            }
            ObjectName globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (secDomain != null && !secDomain.equals("")) {
                if (secDomain.equals("PassThroughToGlobalSecurity")) {
                    String command = cmd.getName();
                    String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                    throw new CommandValidationException(msg);
                }
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
                AttributeList CSIAttrs = (AttributeList)configService.getAttribute(session, secObj, "CSI");
                if (CSIAttrs == null) {
                    attrList = configService.getAttributes(session, globalSecObj, new String[]{"CSI"}, true);
                    configService.setAttributes(session, secObj, (AttributeList)attrList);
                    attrList.clear();
                    attrList = configService.getAttributes(session, globalSecObj, new String[]{"properties"}, true);
                    configService.setAttributes(session, secObj, (AttributeList)attrList);
                    attrList.clear();
                }
            } else {
                secObj = globalSecObj;
            }
            if (attrList != null) {
                attrList.clear();
            }
            attrList = (AttributeList)configService.getAttribute(session, secObj, "CSI");
            ObjectName csiObj = configService.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName((AttributeList)attrList), null)[0];
            attrList.clear();
            if (messageLevelAuth != null && !messageLevelAuth.equals("") && !this.validLevel(messageLevelAuth)) {
                String msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (transportLayer != null && !transportLayer.equals("") && !this.validLevel(transportLayer)) {
                String msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (clientCertAuth != null && !clientCertAuth.equals("") && !this.validLevel(clientCertAuth)) {
                String msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (supportedAuthMechList != null && !supportedAuthMechList.equals("") && !this.validMechanism(mechanisms = supportedAuthMechList.split("\\|"))) {
                String msg = this.getMsg(resBundle, "security.admintask.mechanismNotValid.SECJ7710E", null);
                throw new CommandValidationException(msg);
            }
            if (sslConfiguration != null && !sslConfiguration.equals("") && !SecConfigTaskHelper.validSSLConfig(session, configService, globalSecObj, sslConfiguration)) {
                String msg = this.getMsg(resBundle, "security.admintask.sslConfigNotValid.SECJ7711E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList claims = (AttributeList)configService.getAttribute(session, csiObj, "claims");
            if (statefulSession != null) {
                ConfigDataId id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(claims, "_Websphere_Config_Data_Id");
                ObjectName obj = ConfigServiceHelper.createObjectName(id);
                ((AttributeList)attrList).add(new Attribute("stateful", (boolean)statefulSession));
                configService.setAttributes(session, obj, (AttributeList)attrList);
                attrList.clear();
            }
            ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(claims, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                AttributeList requiredQOP;
                ObjectName obj;
                ConfigDataId id;
                ObjectName obj2;
                ConfigDataId id2;
                AttributeList supportedQOP;
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (layerType.equals("IdentityAssertionLayer")) {
                    if (enableIdentityAssertion != null && (supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP")) != null) {
                        id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                        obj2 = ConfigServiceHelper.createObjectName(id2);
                        ((AttributeList)attrList).add(new Attribute("enable", (boolean)enableIdentityAssertion));
                        configService.setAttributes(session, obj2, (AttributeList)attrList);
                        attrList.clear();
                    }
                    if (trustedIdentities == null || trustedIdentities.equals("")) continue;
                    ArrayList trustedServers = (ArrayList)ConfigServiceHelper.getAttributeValue(layer, "trustedServers");
                    if (trustedServers.size() > 0) {
                        AttributeList trustedServer = (AttributeList)trustedServers.get(0);
                        id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(trustedServer, "_Websphere_Config_Data_Id");
                        obj = ConfigServiceHelper.createObjectName(id);
                        ((AttributeList)attrList).add(new Attribute("serverId", trustedIdentities));
                        configService.setAttributes(session, obj, (AttributeList)attrList);
                        attrList.clear();
                        continue;
                    }
                    id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
                    obj2 = ConfigServiceHelper.createObjectName(id2);
                    ((AttributeList)attrList).add(new Attribute("serverId", trustedIdentities));
                    configService.createConfigData(session, obj2, "trustedServers", "ServerIdentity", (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                if (layerType.equals("MessageLayer")) {
                    if (messageLevelAuth != null && !messageLevelAuth.equals("")) {
                        supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                        if (supportedQOP != null) {
                            id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                            obj2 = ConfigServiceHelper.createObjectName(id2);
                            if (messageLevelAuth.equalsIgnoreCase("Never") || messageLevelAuth.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                            configService.setAttributes(session, obj2, (AttributeList)attrList);
                            attrList.clear();
                        }
                        if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                            id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(requiredQOP, "_Websphere_Config_Data_Id");
                            obj = ConfigServiceHelper.createObjectName(id);
                            if (messageLevelAuth.equalsIgnoreCase("Never") || messageLevelAuth.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                            configService.setAttributes(session, obj, (AttributeList)attrList);
                            attrList.clear();
                        }
                    }
                    if (supportedAuthMechList == null) continue;
                    ((AttributeList)attrList).add(new Attribute("supportedAuthMechList", supportedAuthMechList));
                    ConfigDataId id3 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
                    ObjectName obj3 = ConfigServiceHelper.createObjectName(id3);
                    configService.setAttributes(session, obj3, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                if (!layerType.equals("TransportLayer")) continue;
                if (transportLayer != null && !transportLayer.equals("") || clientCertAuth != null && !clientCertAuth.equals("")) {
                    supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                    if (supportedQOP != null) {
                        id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                        obj2 = ConfigServiceHelper.createObjectName(id2);
                        if (transportLayer != null) {
                            if (transportLayer.equalsIgnoreCase("Never") || transportLayer.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.TRUE));
                            }
                        }
                        if (clientCertAuth != null) {
                            if (clientCertAuth.equalsIgnoreCase("Never") || clientCertAuth.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                        }
                        configService.setAttributes(session, obj2, (AttributeList)attrList);
                        attrList.clear();
                    }
                    if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                        id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(requiredQOP, "_Websphere_Config_Data_Id");
                        obj = ConfigServiceHelper.createObjectName(id);
                        if (transportLayer != null) {
                            if (transportLayer.equalsIgnoreCase("Never") || transportLayer.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.TRUE));
                            }
                        }
                        if (clientCertAuth != null) {
                            if (clientCertAuth.equalsIgnoreCase("Never") || clientCertAuth.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                        }
                        configService.setAttributes(session, obj, (AttributeList)attrList);
                        attrList.clear();
                    }
                }
                if (sslConfiguration == null) continue;
                AttributeList serverAuthentication = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "serverAuthentication");
                if (serverAuthentication != null) {
                    id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(serverAuthentication, "_Websphere_Config_Data_Id");
                    obj2 = ConfigServiceHelper.createObjectName(id2);
                    ((AttributeList)attrList).add(new Attribute("sslConfig", sslConfiguration));
                    configService.setAttributes(session, obj2, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
                obj2 = ConfigServiceHelper.createObjectName(id2);
                ((AttributeList)attrList).add(new Attribute("sslConfig", sslConfiguration));
                configService.createConfigData(session, obj2, "serverAuthentication", "IIOPTransport", (AttributeList)attrList);
                attrList.clear();
            }
            AttributeList attributeList = configService.getAttributes(session, secObj, new String[]{"properties"}, false);
            ArrayList props = (ArrayList)((Attribute)attributeList.get(0)).getValue();
            for (int i = 0; i < props.size(); ++i) {
                ObjectName property = (ObjectName)props.get(i);
                String propName = (String)configService.getAttribute(session, property, "name");
                if (enableAttributePropagation == null || !propName.equals(this.inboundSAP)) continue;
                configService.deleteConfigData(session, property);
                ((AttributeList)attrList).add(new Attribute("name", propName));
                ((AttributeList)attrList).add(new Attribute("value", enableAttributePropagation.toString()));
                ((AttributeList)attrList).add(new Attribute("required", Boolean.FALSE));
                configService.createConfigData(session, secObj, "properties", null, (AttributeList)attrList);
                attrList.clear();
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureCSIInbound");
            }
        }
    }

    public void configureCSIOutbound(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureCSIInbound");
        }
        ObjectName secObj = null;
        ArrayList attrList = null;
        String[] mechanisms = null;
        boolean useCustomProp = false;
        try {
            String msg;
            String attrProp;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            Boolean enableAttributePropagation = (Boolean)cmd.getParameter("enableAttributePropagation");
            Boolean enableIdentityAssertion = (Boolean)cmd.getParameter("enableIdentityAssertion");
            Boolean useServerIdentity = (Boolean)cmd.getParameter("useServerIdentity");
            String trustedIdentity = (String)cmd.getParameter("trustedId");
            String trustedIdentityPassword = (String)cmd.getParameter("trustedIdentityPassword");
            String messageLevelAuth = (String)cmd.getParameter("messageLevelAuth");
            String supportedAuthMechList = (String)cmd.getParameter("supportedAuthMechList");
            String clientCertAuth = (String)cmd.getParameter("clientCertAuth");
            String transportLayer = (String)cmd.getParameter("transportLayer");
            String sslConfiguration = (String)cmd.getParameter("sslConfiguration");
            Boolean statefulSession = (Boolean)cmd.getParameter("statefulSession");
            Boolean enableOutboundMapping = (Boolean)cmd.getParameter("enableOutboundMapping");
            String trustedTargetRealms = (String)cmd.getParameter("trustedTargetRealms");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageLevelAuthentication name is " + messageLevelAuth);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableAttributePropagation is " + enableAttributePropagation);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableIdentityAssertion is " + enableIdentityAssertion);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "useServerIdentity is " + useServerIdentity);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trustedIdentity is " + trustedIdentity);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageLevelAuth is " + messageLevelAuth);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageLevelAuthentication is " + messageLevelAuth);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageLevelAuthentication is " + messageLevelAuth);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "supportedAuthMechList is " + supportedAuthMechList);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clientCertAuth is " + clientCertAuth);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "transportLayer is " + transportLayer);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfiguration is " + sslConfiguration);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "statefulSession is " + statefulSession);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableOutboundMapping is " + enableOutboundMapping);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trustedTargetRealms are " + trustedTargetRealms);
            }
            ObjectName globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (secDomain != null && !secDomain.equals("")) {
                if (secDomain.equals("PassThroughToGlobalSecurity")) {
                    String command = cmd.getName();
                    String msg2 = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                    throw new CommandValidationException(msg2);
                }
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg3 = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg3);
                }
                AttributeList CSIAttrs = (AttributeList)configService.getAttribute(session, secObj, "CSI");
                if (CSIAttrs == null) {
                    attrList = configService.getAttributes(session, globalSecObj, new String[]{"CSI"}, true);
                    configService.setAttributes(session, secObj, (AttributeList)attrList);
                    attrList.clear();
                    attrList = configService.getAttributes(session, globalSecObj, new String[]{"properties"}, true);
                    configService.setAttributes(session, secObj, (AttributeList)attrList);
                    attrList.clear();
                }
            } else {
                secObj = globalSecObj;
            }
            String trustedRealms = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.outboundTargetRealms);
            if (trustedRealms != null && trustedRealms.length() > 0) {
                useCustomProp = true;
            }
            if (attrList != null) {
                attrList.clear();
            }
            attrList = (AttributeList)configService.getAttribute(session, secObj, "CSI");
            ObjectName csiObj = configService.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName((AttributeList)attrList), null)[0];
            attrList.clear();
            if (enableAttributePropagation == null && (attrProp = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.outboundSAP)) != null) {
                enableAttributePropagation = new Boolean(attrProp);
            }
            if (useServerIdentity != null && useServerIdentity.booleanValue() && trustedIdentity != null && !trustedIdentity.equals("")) {
                msg = this.getMsg(resBundle, "security.admintask.identitySpecified.SECJ7712E", null);
                throw new CommandValidationException(msg);
            }
            if (messageLevelAuth != null && !messageLevelAuth.equals("") && !this.validLevel(messageLevelAuth)) {
                msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (transportLayer != null && !transportLayer.equals("") && !this.validLevel(transportLayer)) {
                msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (clientCertAuth != null && !clientCertAuth.equals("") && !this.validLevel(clientCertAuth)) {
                msg = this.getMsg(resBundle, "security.admintask.authLevelNotValid.SECJ7709E", null);
                throw new CommandValidationException(msg);
            }
            if (supportedAuthMechList != null && !supportedAuthMechList.equals("") && !this.validMechanism(mechanisms = supportedAuthMechList.split("\\|"))) {
                msg = this.getMsg(resBundle, "security.admintask.mechanismNotValid.SECJ7710E", null);
                throw new CommandValidationException(msg);
            }
            if (sslConfiguration != null && !sslConfiguration.equals("") && !SecConfigTaskHelper.validSSLConfig(session, configService, globalSecObj, sslConfiguration)) {
                msg = this.getMsg(resBundle, "security.admintask.sslConfigNotValid.SECJ7711E", null);
                throw new CommandValidationException(msg);
            }
            AttributeList performs = (AttributeList)configService.getAttribute(session, csiObj, "performs");
            if (statefulSession != null) {
                ConfigDataId id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(performs, "_Websphere_Config_Data_Id");
                ObjectName obj = ConfigServiceHelper.createObjectName(id);
                ((AttributeList)attrList).add(new Attribute("stateful", (boolean)statefulSession));
                configService.setAttributes(session, obj, (AttributeList)attrList);
                attrList.clear();
            }
            ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(performs, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                ObjectName obj;
                ConfigDataId id;
                AttributeList requiredQOP;
                ObjectName obj2;
                ConfigDataId id2;
                AttributeList supportedQOP;
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (layerType.equals("IdentityAssertionLayer")) {
                    if (enableIdentityAssertion == null && useServerIdentity == null && trustedIdentity == null || (supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP")) == null) continue;
                    id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                    obj2 = ConfigServiceHelper.createObjectName(id2);
                    if (enableAttributePropagation != null && enableAttributePropagation.booleanValue() && useServerIdentity != null && !useServerIdentity.booleanValue()) {
                        if (trustedIdentity == null) {
                            trustedIdentity = (String)configService.getAttribute(session, obj2, "trustedId");
                        }
                        if (trustedIdentityPassword == null) {
                            trustedIdentityPassword = (String)configService.getAttribute(session, obj2, "trustedPassword");
                        }
                        if (trustedIdentity == null || trustedIdentity != null && trustedIdentity.length() == 0) {
                            String msg4 = this.getMsg(resBundle, "security.admintask.noIdentity.SECJ7743E", null);
                            throw new CommandValidationException(msg4);
                        }
                    }
                    if (enableIdentityAssertion != null) {
                        ((AttributeList)attrList).add(new Attribute("enable", (boolean)enableIdentityAssertion));
                    }
                    if (useServerIdentity != null && useServerIdentity.booleanValue()) {
                        ((AttributeList)attrList).add(new Attribute("trustedId", null));
                        ((AttributeList)attrList).add(new Attribute("trustedPassword", null));
                    }
                    if (trustedIdentity != null) {
                        ((AttributeList)attrList).add(new Attribute("trustedId", trustedIdentity));
                    }
                    if (trustedIdentityPassword != null) {
                        ((AttributeList)attrList).add(new Attribute("trustedPassword", trustedIdentityPassword));
                    }
                    configService.setAttributes(session, obj2, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                if (layerType.equals("MessageLayer")) {
                    if (messageLevelAuth != null && !messageLevelAuth.equals("")) {
                        supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                        if (supportedQOP != null) {
                            id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                            obj2 = ConfigServiceHelper.createObjectName(id2);
                            if (messageLevelAuth.equalsIgnoreCase("Never") || messageLevelAuth.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                            configService.setAttributes(session, obj2, (AttributeList)attrList);
                            attrList.clear();
                        }
                        if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                            id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(requiredQOP, "_Websphere_Config_Data_Id");
                            obj = ConfigServiceHelper.createObjectName(id);
                            if (messageLevelAuth.equalsIgnoreCase("Never") || messageLevelAuth.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                            configService.setAttributes(session, obj, (AttributeList)attrList);
                            attrList.clear();
                        }
                    }
                    if (supportedAuthMechList == null) continue;
                    ((AttributeList)attrList).add(new Attribute("supportedAuthMechList", supportedAuthMechList));
                    ConfigDataId id3 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
                    ObjectName obj3 = ConfigServiceHelper.createObjectName(id3);
                    configService.setAttributes(session, obj3, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                if (!layerType.equals("TransportLayer")) continue;
                if (transportLayer != null && !transportLayer.equals("") || clientCertAuth != null && !clientCertAuth.equals("")) {
                    supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                    if (supportedQOP != null) {
                        id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(supportedQOP, "_Websphere_Config_Data_Id");
                        obj2 = ConfigServiceHelper.createObjectName(id2);
                        if (transportLayer != null) {
                            if (transportLayer.equalsIgnoreCase("Never") || transportLayer.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.TRUE));
                            }
                        }
                        if (clientCertAuth != null) {
                            if (clientCertAuth.equalsIgnoreCase("Never") || clientCertAuth.equalsIgnoreCase("Required")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                        }
                        configService.setAttributes(session, obj2, (AttributeList)attrList);
                        attrList.clear();
                    }
                    if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                        id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(requiredQOP, "_Websphere_Config_Data_Id");
                        obj = ConfigServiceHelper.createObjectName(id);
                        if (transportLayer != null) {
                            if (transportLayer.equalsIgnoreCase("Never") || transportLayer.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("enableProtection", Boolean.TRUE));
                            }
                        }
                        if (clientCertAuth != null) {
                            if (clientCertAuth.equalsIgnoreCase("Never") || clientCertAuth.equalsIgnoreCase("Supported")) {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.FALSE));
                            } else {
                                ((AttributeList)attrList).add(new Attribute("establishTrustInClient", Boolean.TRUE));
                            }
                        }
                        configService.setAttributes(session, obj, (AttributeList)attrList);
                        attrList.clear();
                    }
                }
                if (sslConfiguration == null) continue;
                AttributeList serverAuthentication = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "serverAuthentication");
                if (serverAuthentication != null) {
                    id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(serverAuthentication, "_Websphere_Config_Data_Id");
                    obj2 = ConfigServiceHelper.createObjectName(id2);
                    ((AttributeList)attrList).add(new Attribute("sslConfig", sslConfiguration));
                    configService.setAttributes(session, obj2, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                id2 = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
                obj2 = ConfigServiceHelper.createObjectName(id2);
                ((AttributeList)attrList).add(new Attribute("sslConfig", sslConfiguration));
                configService.createConfigData(session, obj2, "serverAuthentication", "IIOPTransport", (AttributeList)attrList);
                attrList.clear();
            }
            AttributeList attributeList = configService.getAttributes(session, secObj, new String[]{"properties"}, false);
            ArrayList props = (ArrayList)((Attribute)attributeList.get(0)).getValue();
            for (int i = 0; i < props.size(); ++i) {
                ObjectName property = (ObjectName)props.get(i);
                String propName = (String)configService.getAttribute(session, property, "name");
                if (enableAttributePropagation != null && propName.equals(this.outboundSAP)) {
                    configService.deleteConfigData(session, property);
                    ((AttributeList)attrList).add(new Attribute("name", propName));
                    ((AttributeList)attrList).add(new Attribute("value", enableAttributePropagation.toString()));
                    ((AttributeList)attrList).add(new Attribute("required", Boolean.FALSE));
                    configService.createConfigData(session, secObj, "properties", null, (AttributeList)attrList);
                    attrList.clear();
                }
                if (enableOutboundMapping != null && propName.equals(this.outboundLogin)) {
                    configService.deleteConfigData(session, property);
                    ((AttributeList)attrList).add(new Attribute("name", propName));
                    ((AttributeList)attrList).add(new Attribute("value", enableOutboundMapping.toString()));
                    ((AttributeList)attrList).add(new Attribute("required", Boolean.FALSE));
                    configService.createConfigData(session, secObj, "properties", null, (AttributeList)attrList);
                    attrList.clear();
                }
                if (trustedTargetRealms == null || !propName.equals(this.outboundTargetRealms)) continue;
                if (useCustomProp) {
                    configService.deleteConfigData(session, property);
                    if (trustedTargetRealms.length() <= 0) continue;
                    ((AttributeList)attrList).add(new Attribute("name", propName));
                    ((AttributeList)attrList).add(new Attribute("value", trustedTargetRealms));
                    ((AttributeList)attrList).add(new Attribute("required", Boolean.FALSE));
                    configService.createConfigData(session, secObj, "properties", null, (AttributeList)attrList);
                    attrList.clear();
                    continue;
                }
                this.setTrustedRealmObj(session, configService, secObj, trustedTargetRealms);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1552");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureCSIInbound");
            }
        }
    }

    public void unconfigureCSIInbound(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureCSIInbound");
        }
        ObjectName secObj = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (secDomain.equals("PassThroughToGlobalSecurity")) {
                String command = cmd.getName();
                String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                throw new CommandValidationException(msg);
            }
            secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
            if (secObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                throw new CommandValidationException(msg);
            }
            this.deleteCSIObj(session, configService, secObj, "claims");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1243");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unconfigureCSIInbound");
            }
        }
    }

    public void unconfigureCSIOutbound(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unconfigureCSIOutbound");
        }
        ObjectName secObj = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (secDomain.equals("PassThroughToGlobalSecurity")) {
                String command = cmd.getName();
                String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                throw new CommandValidationException(msg);
            }
            secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
            if (secObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                throw new CommandValidationException(msg);
            }
            this.deleteCSIObj(session, configService, secObj, "performs");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1284");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unconfigureCSIOutbound");
            }
        }
    }

    public void deleteCSIObj(Session session, ConfigService cs, ObjectName secObj, String csiType) throws Exception {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteCSIObj");
            }
            ObjectName typeObj = null;
            String otherType = "claims";
            if (csiType.equals("claims")) {
                otherType = "performs";
            }
            try {
                AttributeList csi = (AttributeList)cs.getAttribute(session, secObj, "CSI");
                if (csi == null) break block13;
                ObjectName csiObj = cs.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(csi), null)[0];
                if (csiObj != null) {
                    AttributeList types2 = (AttributeList)cs.getAttribute(session, csiObj, csiType);
                    if (types2 != null) {
                        typeObj = cs.queryConfigObjects(session, csiObj, ConfigServiceHelper.createObjectName(types2), null)[0];
                    }
                    if (typeObj == null) {
                        String msg = this.getMsg(resBundle, "security.admintask.CSIDoesNotExist.SECJ7738E", null);
                        throw new CommandValidationException(msg);
                    }
                    cs.deleteConfigData(session, typeObj);
                    types2 = (AttributeList)cs.getAttribute(session, csiObj, otherType);
                    if (types2 == null) {
                        cs.deleteConfigData(session, csiObj);
                    }
                    break block13;
                }
                String msg = this.getMsg(resBundle, "security.admintask.CSIDoesNotExist.SECJ7738E", null);
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1342");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught", e);
                }
                throw e;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteCSIObject");
                }
            }
        }
    }

    public AttributeList getCSIOutboundInfo(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIOutboundInfo");
        }
        ObjectName secObj = null;
        AttributeList attrList = null;
        AttributeList csiOutboundAttrs = new AttributeList();
        try {
            AttributeList performs;
            ObjectName csiObj;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            Boolean displayModel = (Boolean)cmd.getParameter("displayModel");
            ObjectName globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (secDomain != null && !secDomain.equals("")) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = globalSecObj;
            }
            if ((attrList = (AttributeList)configService.getAttribute(session, secObj, "CSI")) != null && (csiObj = configService.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(attrList), null)[0]) != null && (performs = (AttributeList)configService.getAttribute(session, csiObj, "performs")) != null) {
                String trustedRealms;
                String outLogin;
                if (displayModel != null && displayModel.booleanValue()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCSIOutboundInfo");
                    }
                    AttributeList attributeList = performs;
                    return attributeList;
                }
                String attrProp = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.outboundSAP);
                if (attrProp != null && attrProp.length() > 0 && (attrProp.equalsIgnoreCase("true") || attrProp.equalsIgnoreCase("false"))) {
                    csiOutboundAttrs.add(new Attribute("enableAttributePropagation", new Boolean(attrProp)));
                }
                if ((outLogin = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.outboundLogin)) != null && outLogin.length() > 0 && (outLogin.equalsIgnoreCase("true") || outLogin.equalsIgnoreCase("false"))) {
                    csiOutboundAttrs.add(new Attribute("enableOutBoundMapping", new Boolean(outLogin)));
                }
                if ((trustedRealms = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.outboundTargetRealms)) != null && trustedRealms.length() > 0) {
                    csiOutboundAttrs.add(new Attribute(this.outboundTargetRealms, trustedRealms));
                } else {
                    ObjectName trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, "outboundTrustedAuthenticationRealm");
                    String trustedRealm = "";
                    if (trustedRealmObj != null) {
                        trustedRealm = (String)configService.getAttribute(session, trustedRealmObj, "realmList");
                    }
                    csiOutboundAttrs.add(new Attribute("trustedTargetRealms", trustedRealm));
                }
                Boolean statefulSession = (Boolean)ConfigServiceHelper.getAttributeValue(performs, "stateful");
                if (statefulSession != null) {
                    csiOutboundAttrs.add(new Attribute("statefulSession", statefulSession));
                }
                ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(performs, "layers");
                for (int i = 0; i < layers.size(); ++i) {
                    String sslConfig;
                    AttributeList serverAuthentication;
                    AttributeList requiredQOP;
                    Boolean requiredEstablishTrustInClient;
                    Boolean supportedEstablishTrustInClient;
                    AttributeList supportedQOP;
                    AttributeList layer = (AttributeList)layers.get(i);
                    String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                    if (layerType.equals("IdentityAssertionLayer") && (supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP")) != null) {
                        Boolean enable = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP, "enable");
                        if (enable != null) {
                            csiOutboundAttrs.add(new Attribute("enableIdentityAssertion", enable));
                        }
                        String trustedId = (String)ConfigServiceHelper.getAttributeValue(supportedQOP, "trustedId");
                        String trustedPassword = (String)ConfigServiceHelper.getAttributeValue(supportedQOP, "trustedPassword");
                        if (trustedId != null && trustedId.length() > 0) {
                            csiOutboundAttrs.add(new Attribute("trustedId", trustedId));
                            if (trustedPassword != null && trustedPassword.length() > 0) {
                                csiOutboundAttrs.add(new Attribute("trustedIdentityPassword", "*******"));
                            }
                            csiOutboundAttrs.add(new Attribute("useServerIdentity", Boolean.FALSE));
                        } else {
                            csiOutboundAttrs.add(new Attribute("useServerIdentity", Boolean.TRUE));
                        }
                    }
                    if (layerType.equals("MessageLayer")) {
                        String supportedAuthMechanisms;
                        AttributeList requiredQOP2;
                        supportedEstablishTrustInClient = null;
                        requiredEstablishTrustInClient = null;
                        String level = null;
                        AttributeList supportedQOP2 = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                        if (supportedQOP2 != null) {
                            supportedEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP2, "establishTrustInClient");
                        }
                        if ((requiredQOP2 = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                            requiredEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP2, "establishTrustInClient");
                        }
                        if (supportedEstablishTrustInClient != null && requiredEstablishTrustInClient != null) {
                            if (!supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                                level = "Never";
                            } else if (supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                                level = "Supported";
                            } else if (!supportedEstablishTrustInClient.booleanValue() && requiredEstablishTrustInClient.booleanValue()) {
                                level = "Required";
                            }
                        }
                        if (level != null) {
                            csiOutboundAttrs.add(new Attribute("messageLevelAuth", level));
                        }
                        if ((supportedAuthMechanisms = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList")) != null) {
                            csiOutboundAttrs.add(new Attribute("supportedAuthMechanisms", supportedAuthMechanisms));
                        }
                    }
                    if (!layerType.equals("TransportLayer")) continue;
                    supportedEstablishTrustInClient = null;
                    requiredEstablishTrustInClient = null;
                    Boolean supportedEnableProtected = null;
                    Boolean requiredEnableProtected = null;
                    String level = null;
                    AttributeList supportedQOP3 = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                    if (supportedQOP3 != null) {
                        supportedEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP3, "establishTrustInClient");
                        supportedEnableProtected = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP3, "enableProtection");
                    }
                    if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                        requiredEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP, "establishTrustInClient");
                        requiredEnableProtected = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP, "enableProtection");
                    }
                    if (supportedEstablishTrustInClient != null && requiredEstablishTrustInClient != null) {
                        if (!supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                            level = "Never";
                        } else if (supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                            level = "Supported";
                        } else if (!supportedEstablishTrustInClient.booleanValue() && requiredEstablishTrustInClient.booleanValue()) {
                            level = "Required";
                        }
                        csiOutboundAttrs.add(new Attribute("clientCertAuth", level));
                    }
                    if (supportedEnableProtected != null && requiredEnableProtected != null) {
                        if (!supportedEnableProtected.booleanValue() && !requiredEnableProtected.booleanValue()) {
                            level = "Never";
                        } else if (supportedEnableProtected.booleanValue() && !requiredEnableProtected.booleanValue()) {
                            level = "Supported";
                        } else if (!supportedEnableProtected.booleanValue() && requiredEnableProtected.booleanValue()) {
                            level = "Required";
                        }
                        csiOutboundAttrs.add(new Attribute("transportLayer", level));
                    }
                    if ((serverAuthentication = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "serverAuthentication")) == null || (sslConfig = (String)ConfigServiceHelper.getAttributeValue(serverAuthentication, "sslConfig")) == null) continue;
                    csiOutboundAttrs.add(new Attribute("sslConfiguration", sslConfig));
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1552");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCSIOutboundInfo");
            }
        }
        return csiOutboundAttrs;
    }

    public AttributeList getCSIInboundInfo(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIInboundInfo");
        }
        ObjectName secObj = null;
        AttributeList attrList = null;
        AttributeList csiInboundAttrs = new AttributeList();
        String serverId = "";
        try {
            ObjectName csiObj;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            Boolean displayModel = (Boolean)cmd.getParameter("displayModel");
            ObjectName globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (secDomain != null && !secDomain.equals("")) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                secObj = globalSecObj;
            }
            if ((attrList = (AttributeList)configService.getAttribute(session, secObj, "CSI")) != null && (csiObj = configService.queryConfigObjects(session, secObj, ConfigServiceHelper.createObjectName(attrList), null)[0]) != null) {
                Boolean statefulSession;
                AttributeList claims = (AttributeList)configService.getAttribute(session, csiObj, "claims");
                if (claims != null) {
                    if (displayModel != null && displayModel.booleanValue()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getCSIInboundInfo");
                        }
                        AttributeList attributeList = claims;
                        return attributeList;
                    }
                    String attrProp = (String)SecConfigTaskHelper.getPropertyValue(session, configService, secObj, "properties", this.inboundSAP);
                    if (attrProp != null && attrProp.length() > 0 && (attrProp.equalsIgnoreCase("true") || attrProp.equalsIgnoreCase("false"))) {
                        csiInboundAttrs.add(new Attribute("enableAttributePropagation", new Boolean(attrProp)));
                    }
                }
                if ((statefulSession = (Boolean)ConfigServiceHelper.getAttributeValue(claims, "stateful")) != null) {
                    csiInboundAttrs.add(new Attribute("statefulSession", statefulSession));
                }
                ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(claims, "layers");
                for (int i = 0; i < layers.size(); ++i) {
                    String sslConfig;
                    AttributeList serverAuthentication;
                    AttributeList requiredQOP;
                    Boolean requiredEstablishTrustInClient;
                    Boolean supportedEstablishTrustInClient;
                    AttributeList layer = (AttributeList)layers.get(i);
                    String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                    if (layerType.equals("IdentityAssertionLayer")) {
                        ArrayList trustedServers;
                        Boolean enable;
                        AttributeList supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                        if (supportedQOP != null && (enable = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP, "enable")) != null) {
                            csiInboundAttrs.add(new Attribute("enableIdentityAssertion", enable));
                        }
                        if ((trustedServers = (ArrayList)ConfigServiceHelper.getAttributeValue(layer, "trustedServers")).size() > 0) {
                            AttributeList trustedServer = (AttributeList)trustedServers.get(0);
                            serverId = (String)ConfigServiceHelper.getAttributeValue(trustedServer, "serverId");
                        }
                        if (serverId != null) {
                            csiInboundAttrs.add(new Attribute("trustedIdentities", serverId));
                        }
                    }
                    if (layerType.equals("MessageLayer")) {
                        String supportedAuthMechanisms;
                        AttributeList requiredQOP2;
                        supportedEstablishTrustInClient = null;
                        requiredEstablishTrustInClient = null;
                        String level = null;
                        AttributeList supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                        if (supportedQOP != null) {
                            supportedEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP, "establishTrustInClient");
                        }
                        if ((requiredQOP2 = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                            requiredEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP2, "establishTrustInClient");
                        }
                        if (supportedEstablishTrustInClient != null && requiredEstablishTrustInClient != null) {
                            if (!supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                                level = "Never";
                            } else if (supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                                level = "Supported";
                            } else if (!supportedEstablishTrustInClient.booleanValue() && requiredEstablishTrustInClient.booleanValue()) {
                                level = "Required";
                            }
                            if (level != null) {
                                csiInboundAttrs.add(new Attribute("messageLevelAuth", level));
                            }
                        }
                        if ((supportedAuthMechanisms = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList")) != null) {
                            csiInboundAttrs.add(new Attribute("supportedAuthMechanisms", supportedAuthMechanisms));
                        }
                    }
                    if (!layerType.equals("TransportLayer")) continue;
                    supportedEstablishTrustInClient = null;
                    requiredEstablishTrustInClient = null;
                    Boolean supportedEnableProtected = null;
                    Boolean requiredEnableProtected = null;
                    String level = null;
                    AttributeList supportedQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "supportedQOP");
                    if (supportedQOP != null) {
                        supportedEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP, "establishTrustInClient");
                        supportedEnableProtected = (Boolean)ConfigServiceHelper.getAttributeValue(supportedQOP, "enableProtection");
                    }
                    if ((requiredQOP = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "requiredQOP")) != null) {
                        requiredEstablishTrustInClient = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP, "establishTrustInClient");
                        requiredEnableProtected = (Boolean)ConfigServiceHelper.getAttributeValue(requiredQOP, "enableProtection");
                    }
                    if (supportedEstablishTrustInClient != null && requiredEstablishTrustInClient != null) {
                        if (!supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                            level = "Never";
                        } else if (supportedEstablishTrustInClient.booleanValue() && !requiredEstablishTrustInClient.booleanValue()) {
                            level = "Supported";
                        } else if (!supportedEstablishTrustInClient.booleanValue() && requiredEstablishTrustInClient.booleanValue()) {
                            level = "Required";
                        }
                        csiInboundAttrs.add(new Attribute("clientCertAuth", level));
                    }
                    if (supportedEnableProtected != null && requiredEnableProtected != null) {
                        if (!supportedEnableProtected.booleanValue() && !requiredEnableProtected.booleanValue()) {
                            level = "Never";
                        } else if (supportedEnableProtected.booleanValue() && !requiredEnableProtected.booleanValue()) {
                            level = "Supported";
                        } else if (!supportedEnableProtected.booleanValue() && requiredEnableProtected.booleanValue()) {
                            level = "Required";
                        }
                        csiInboundAttrs.add(new Attribute("transportLayer", level));
                    }
                    if ((serverAuthentication = (AttributeList)ConfigServiceHelper.getAttributeValue(layer, "serverAuthentication")) == null || (sslConfig = (String)ConfigServiceHelper.getAttributeValue(serverAuthentication, "sslConfig")) == null) continue;
                    csiInboundAttrs.add(new Attribute("sslConfiguration", sslConfig));
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "1552");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCSIInboundInfo");
            }
        }
        return csiInboundAttrs;
    }

    public AttributeList getActiveSecuritySettings(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveSecuritySettings");
        }
        ObjectName secObj = null;
        AttributeList securitySettings = new AttributeList();
        SecurityCommon commonSecurity = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (secDomain != null) {
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            } else {
                ObjectName adminPreferredAuthMech;
                ObjectName activeAuthMechanism;
                Boolean dynUpdateSSLConfig;
                secObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
                Boolean enabled = (Boolean)configService.getAttribute(session, secObj, "enabled");
                if (enabled != null) {
                    securitySettings.add(new Attribute("enableGlobalSecurity", enabled.toString()));
                }
                if ((dynUpdateSSLConfig = (Boolean)configService.getAttribute(session, secObj, "dynamicallyUpdateSSLConfig")) != null) {
                    securitySettings.add(new Attribute("dynUpdateSSLConfig", dynUpdateSSLConfig.toString()));
                }
                if ((activeAuthMechanism = (ObjectName)configService.getAttribute(session, secObj, "activeAuthMechanism")) != null) {
                    AttributeList attrs = configService.getAttributes(session, activeAuthMechanism, null, false);
                    String authType = (String)ConfigServiceHelper.getAttributeValue(attrs, "_Websphere_Config_Data_Type");
                    securitySettings.add(new Attribute("activeAuthMechanism", authType));
                }
                if ((adminPreferredAuthMech = (ObjectName)configService.getAttribute(session, secObj, "adminPreferredAuthMech")) != null) {
                    AttributeList attrs = configService.getAttributes(session, adminPreferredAuthMech, null, false);
                    String authType = (String)ConfigServiceHelper.getAttributeValue(attrs, "_Websphere_Config_Data_Type");
                    securitySettings.add(new Attribute("adminPreferredAuthMech", authType));
                }
            }
            if (secObj != null) {
                ObjectName activeUserRegistry;
                Boolean enforceFineGrainedSec;
                Boolean appEnabled;
                Boolean enforceJava2Security;
                Boolean issuePermissionWarning;
                Integer cacheTimeout;
                commonSecurity = (SecurityCommon)MOFUtil.convertToEObject((Session)session, (ObjectName)secObj);
                Boolean useDomainQualifiedUserNames = (Boolean)configService.getAttribute(session, secObj, "useDomainQualifiedUserNames");
                if (useDomainQualifiedUserNames != null && commonSecurity.isSetUseDomainQualifiedUserNames()) {
                    securitySettings.add(new Attribute("useDomainQualifiedUserNames", useDomainQualifiedUserNames));
                }
                if ((cacheTimeout = (Integer)configService.getAttribute(session, secObj, "cacheTimeout")) != null && commonSecurity.isSetCacheTimeout()) {
                    securitySettings.add(new Attribute("cacheTimeout", cacheTimeout));
                }
                if ((issuePermissionWarning = (Boolean)configService.getAttribute(session, secObj, "issuePermissionWarning")) != null && commonSecurity.isSetIssuePermissionWarning()) {
                    securitySettings.add(new Attribute("issuePermissionWarning", issuePermissionWarning));
                }
                if ((enforceJava2Security = (Boolean)configService.getAttribute(session, secObj, "enforceJava2Security")) != null && commonSecurity.isSetEnforceJava2Security()) {
                    securitySettings.add(new Attribute("enforceJava2Security", enforceJava2Security));
                }
                if ((appEnabled = (Boolean)configService.getAttribute(session, secObj, "appEnabled")) != null && commonSecurity.isSetAppEnabled()) {
                    securitySettings.add(new Attribute("appSecurityEnabled", appEnabled));
                }
                if ((enforceFineGrainedSec = (Boolean)configService.getAttribute(session, secObj, "enforceFineGrainedJCASecurity")) != null && commonSecurity.isSetEnforceFineGrainedJCASecurity()) {
                    securitySettings.add(new Attribute("enforceFineGrainedJCASecurity", enforceFineGrainedSec));
                }
                if ((activeUserRegistry = (ObjectName)configService.getAttribute(session, secObj, "activeUserRegistry")) != null) {
                    AttributeList attrs = configService.getAttributes(session, activeUserRegistry, null, false);
                    String regType = (String)ConfigServiceHelper.getAttributeValue(attrs, "_Websphere_Config_Data_Type");
                    securitySettings.add(new Attribute("activeUserRegistry", regType));
                }
                ArrayList<AttributeList> propAttrs = new ArrayList<AttributeList>();
                AttributeList attributeList = configService.getAttributes(session, secObj, new String[]{"properties"}, false);
                List props = (List)((Attribute)attributeList.get(0)).getValue();
                if (props.size() > 0) {
                    ObjectName property = null;
                    Iterator iter = props.iterator();
                    while (iter.hasNext()) {
                        AttributeList attrs = new AttributeList();
                        property = (ObjectName)iter.next();
                        String propName = (String)configService.getAttribute(session, property, "name");
                        String propValue = (String)configService.getAttribute(session, property, "value");
                        if (propName != null) {
                            attrs.add(new Attribute("name", propName));
                        }
                        if (propName != null) {
                            attrs.add(new Attribute("value", propValue));
                        }
                        propAttrs.add(attrs);
                    }
                }
                if (propAttrs.size() > 0) {
                    securitySettings.add(new Attribute("properties", propAttrs));
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "2083");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActiveSecuritySettings");
            }
        }
        return securitySettings;
    }

    public void unsetAppActiveSecuritySettings(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAppActiveSecuritySettings");
        }
        ObjectName secObj = null;
        AttributeList securitySettings = new AttributeList();
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            Boolean cacheTimeout = (Boolean)cmd.getParameter("unsetCacheTimeout");
            Boolean issuePermissionWarning = (Boolean)cmd.getParameter("unsetIssuePermissionWarning");
            Boolean enforceJava2Security = (Boolean)cmd.getParameter("unsetEnforceJava2Security");
            Boolean enforceFineGrainedSec = (Boolean)cmd.getParameter("unsetEnforceFineGrainedJCASecurity");
            Boolean appSecurityEnabled = (Boolean)cmd.getParameter("unsetAppSecurityEnabled");
            Boolean activeUserRegistry = (Boolean)cmd.getParameter("unsetActiveUserRegistry");
            Boolean useDomainQualifiedUserNames = (Boolean)cmd.getParameter("unsetUseDomainQualifiedUserNames");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (secDomain != null) {
                if (secDomain.equals("PassThroughToGlobalSecurity")) {
                    String command = cmd.getName();
                    String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                    throw new CommandValidationException(msg);
                }
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
                if (secObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                    throw new CommandValidationException(msg);
                }
            }
            if (secObj != null) {
                if (appSecurityEnabled.booleanValue()) {
                    securitySettings.add(new Attribute("appEnabled", null));
                }
                if (useDomainQualifiedUserNames.booleanValue()) {
                    securitySettings.add(new Attribute("useDomainQualifiedUserNames", null));
                }
                if (issuePermissionWarning.booleanValue()) {
                    securitySettings.add(new Attribute("issuePermissionWarning", null));
                }
                if (enforceJava2Security.booleanValue()) {
                    securitySettings.add(new Attribute("enforceJava2Security", null));
                }
                if (enforceFineGrainedSec.booleanValue()) {
                    securitySettings.add(new Attribute("enforceFineGrainedJCASecurity", null));
                }
                if (activeUserRegistry.booleanValue()) {
                    securitySettings.add(new Attribute("activeUserRegistry", null));
                }
                if (cacheTimeout.booleanValue()) {
                    securitySettings.add(new Attribute("cacheTimeout", null));
                }
                if (securitySettings.size() > 0) {
                    configService.setAttributes(session, secObj, securitySettings);
                }
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.SecurityConfigProvider", "2083");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            throw cse;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unsetAppActiveSecuritySettings");
            }
        }
    }

    public String setAdminActiveSecuritySettings(AbstractAdminCommand cmd) throws Exception {
        ObjectName globalSecObj = null;
        ObjectName activeRegistryObj = null;
        ObjectName authMechanism = null;
        ObjectName preferredAuthMech = null;
        Boolean secEnabled = null;
        AttributeList attrList = new AttributeList();
        String displayMessages = null;
        try {
            boolean registryOK;
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configureAdminActiveSecurity");
            }
            Boolean enableSecurity = (Boolean)cmd.getParameter("enableGlobalSecurity");
            Integer cacheTimeout = (Integer)cmd.getParameter("cacheTimeout");
            Boolean issuePermissionWarning = (Boolean)cmd.getParameter("issuePermissionWarning");
            Boolean enforceJava2Security = (Boolean)cmd.getParameter("enforceJava2Security");
            Boolean enforceFineGrainedSec = (Boolean)cmd.getParameter("enforceFineGrainedJCASecurity");
            Boolean appSecurityEnabled = (Boolean)cmd.getParameter("appSecurityEnabled");
            Boolean dynUpdateSSLConfig = (Boolean)cmd.getParameter("dynUpdateSSLConfig");
            String activeAuthMechanism = (String)cmd.getParameter("activeAuthMechanism");
            String activeUserRegistry = (String)cmd.getParameter("activeUserRegistry");
            Boolean useDomainQualifiedUserNames = (Boolean)cmd.getParameter("useDomainQualifiedUserNames");
            String customProperties = (String)cmd.getParameter("customProperties");
            String adminPreferredAuthMech = (String)cmd.getParameter("adminPreferredAuthMech");
            globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            secEnabled = enableSecurity == null ? (Boolean)configService.getAttribute(session, globalSecObj, "enabled") : Boolean.valueOf(enableSecurity);
            if (activeUserRegistry != null && !activeUserRegistry.equals("")) {
                if (!this.validUserRegType(activeUserRegistry)) {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                    throw new CommandValidationException(msg);
                }
                activeRegistryObj = SecConfigTaskHelper.getRegObj(session, configService, globalSecObj, activeUserRegistry);
            }
            if (secEnabled.booleanValue()) {
                if (activeUserRegistry != null && activeUserRegistry.equals("")) {
                    String msg = this.getMsg(resBundle, "security.admintask.unsetActiveUserRegistry.SECJ7727E", null);
                    throw new CommandValidationException(msg);
                }
                if (activeRegistryObj == null) {
                    activeRegistryObj = (ObjectName)configService.getAttribute(session, globalSecObj, "activeUserRegistry");
                }
                if (activeRegistryObj == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.noActiveUserRegistsry.SECJ7720E", null);
                    throw new CommandValidationException(msg);
                }
            }
            if (activeRegistryObj != null && !(registryOK = SecConfigTaskHelper.isRegistryGood(session, configService, activeRegistryObj))) {
                String msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                throw new CommandValidationException(msg);
            }
            if (activeAuthMechanism != null) {
                if (!this.validAuthMechanism(activeAuthMechanism)) {
                    String msg = this.getMsg(resBundle, "security.admintask.authMechanismNotValid.SECJ7721E", null);
                    throw new CommandValidationException(msg);
                }
                authMechanism = SecConfigTaskHelper.getAuthMechanismObj(session, configService, globalSecObj, activeAuthMechanism);
                if (authMechanism == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.noAuthMechanismObj.SECJ7722E", null);
                    throw new CommandValidationException(msg);
                }
                if (activeAuthMechanism.equalsIgnoreCase("KRB5")) {
                    try {
                        if (!this.krb5IsConfigured(session, configService)) {
                            String msg = this.getMsg(resBundle, "security.admintask.authMechNotConfigured.SECJ7766E", null);
                            throw new CommandValidationException(msg);
                        }
                    }
                    catch (Exception ke) {
                        FFDCFilter.processException(ke, "com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", "%");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception caught", ke);
                        }
                        throw ke;
                    }
                }
            }
            if (adminPreferredAuthMech != null && adminPreferredAuthMech.length() > 0) {
                if (!adminPreferredAuthMech.equalsIgnoreCase("RSAToken")) {
                    String msg = this.getMsg(resBundle, "security.admintask.authMechanismNotValid.SECJ7721E", null);
                    throw new CommandValidationException(msg);
                }
                preferredAuthMech = SecConfigTaskHelper.getAuthMechanismObj(session, configService, globalSecObj, adminPreferredAuthMech);
                if (preferredAuthMech == null) {
                    String msg = this.getMsg(resBundle, "security.admintask.noAuthMechanismObj.SECJ7722E", null);
                    throw new CommandValidationException(msg);
                }
            }
            if (enableSecurity != null) {
                attrList.add(new Attribute("enabled", enableSecurity));
            }
            if (cacheTimeout != null) {
                attrList.add(new Attribute("cacheTimeout", cacheTimeout));
            }
            if (issuePermissionWarning != null) {
                attrList.add(new Attribute("issuePermissionWarning", issuePermissionWarning));
            }
            if (enforceJava2Security != null) {
                attrList.add(new Attribute("enforceJava2Security", enforceJava2Security));
            }
            if (enforceFineGrainedSec != null) {
                attrList.add(new Attribute("enforceFineGrainedJCASecurity", enforceFineGrainedSec));
            }
            if (appSecurityEnabled != null) {
                attrList.add(new Attribute("appEnabled", appSecurityEnabled));
            }
            if (dynUpdateSSLConfig != null) {
                attrList.add(new Attribute("dynamicallyUpdateSSLConfig", dynUpdateSSLConfig));
            }
            if (authMechanism != null) {
                attrList.add(new Attribute("activeAuthMechanism", authMechanism));
            }
            if (preferredAuthMech != null) {
                attrList.add(new Attribute("adminPreferredAuthMech", preferredAuthMech));
            } else if (adminPreferredAuthMech != null && adminPreferredAuthMech.length() == 0) {
                attrList.add(new Attribute("adminPreferredAuthMech", null));
            }
            if (activeUserRegistry != null) {
                if (activeUserRegistry.equals("")) {
                    attrList.add(new Attribute("activeUserRegistry", null));
                } else {
                    attrList.add(new Attribute("activeUserRegistry", activeRegistryObj));
                }
            }
            if (useDomainQualifiedUserNames != null) {
                attrList.add(new Attribute("useDomainQualifiedUserNames", useDomainQualifiedUserNames));
            }
            if (attrList != null) {
                configService.setAttributes(session, globalSecObj, attrList);
            }
            if (customProperties != null) {
                SecConfigTaskHelper.addCustomProperties(session, configService, globalSecObj, customProperties);
            }
            this.checkCSIAuthMechanism(session, configService, globalSecObj);
            if (this.isPropertySet(session, configService, globalSecObj, "security.zOS.domainName", "properties") || this.isPropertySet(session, configService, globalSecObj, "security.zOS.domainType", "properties")) {
                displayMessages = this.getMsg(resBundle, "security.admintask.oldZDomainPropsConfigured.SECJ7784W", null);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", "1696");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureAdminActiveSecurity", displayMessages);
        }
        return displayMessages;
    }

    private void checkCSIAuthMechanism(Session session, ConfigService configService, ObjectName globalSecObj) {
        block7: {
            boolean kerberosSet = false;
            try {
                ObjectName csiObj;
                AttributeList csiAttrs;
                ObjectName activeAuthMechanism = (ObjectName)configService.getAttribute(session, globalSecObj, "activeAuthMechanism");
                if (activeAuthMechanism != null) {
                    AttributeList authAttrs = configService.getAttributes(session, activeAuthMechanism, null, false);
                    String authType = (String)ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                    if (authType.equals("KRB5")) {
                        kerberosSet = true;
                    }
                    if (!kerberosSet) {
                        AttributeList preferedAuthAttrs;
                        String authPerferedType;
                        ObjectName adminPreferredAuthMech = (ObjectName)configService.getAttribute(session, globalSecObj, "adminPreferredAuthMech");
                        if (activeAuthMechanism != null && (authPerferedType = (String)ConfigServiceHelper.getAttributeValue(preferedAuthAttrs = configService.getAttributes(session, adminPreferredAuthMech, null, false), "_Websphere_Config_Data_Type")).equals("KRB5")) {
                            kerberosSet = true;
                        }
                    }
                }
                if ((csiAttrs = (AttributeList)configService.getAttribute(session, globalSecObj, "CSI")) != null && (csiObj = configService.queryConfigObjects(session, globalSecObj, ConfigServiceHelper.createObjectName(csiAttrs), null)[0]) != null) {
                    AttributeList performs = (AttributeList)configService.getAttribute(session, csiObj, "performs");
                    this.setAuthMech(session, configService, performs, kerberosSet);
                    AttributeList claims = (AttributeList)configService.getAttribute(session, csiObj, "claims");
                    this.setAuthMech(session, configService, claims, kerberosSet);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", "2318");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "exception caught", e);
            }
        }
    }

    private void setAuthMech(Session session, ConfigService configService, AttributeList csi, boolean kerberosSet) throws Exception {
        ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(csi, "layers");
        for (int i = 0; i < layers.size(); ++i) {
            AttributeList layer = (AttributeList)layers.get(i);
            String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
            if (!layerType.equals("MessageLayer")) continue;
            String authMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            String newList = null;
            if (authMechList.indexOf("KRB5") >= 0) {
                if (!kerberosSet) {
                    String[] mechanisms = authMechList.split("\\|");
                    boolean first = true;
                    for (int j = 0; j < mechanisms.length; ++j) {
                        if (mechanisms[j].equals("KRB5")) continue;
                        if (first) {
                            newList = mechanisms[j];
                            first = false;
                            continue;
                        }
                        newList = newList + "|" + mechanisms[j];
                    }
                }
            } else if (kerberosSet) {
                newList = authMechList + "|KRB5";
            }
            if (newList == null) continue;
            AttributeList attrList = new AttributeList();
            attrList.add(new Attribute("supportedAuthMechList", newList));
            ConfigDataId id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Id");
            ObjectName obj = ConfigServiceHelper.createObjectName(id);
            configService.setAttributes(session, obj, attrList);
            attrList.clear();
        }
    }

    public String setAppActiveSecuritySettings(AbstractAdminCommand cmd) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureAppActiveSecurity");
        }
        ObjectName secObj = null;
        ObjectName activeRegistryObj = null;
        AttributeList attrList = new AttributeList();
        String displayMessages = null;
        try {
            CommandProviderHelper helper = this.getCommandProviderHelper();
            ConfigService configService = helper.getConfigService();
            Session session = cmd.getConfigSession();
            String secDomain = (String)cmd.getParameter("securityDomainName");
            Integer cacheTimeout = (Integer)cmd.getParameter("cacheTimeout");
            Boolean issuePermissionWarning = (Boolean)cmd.getParameter("issuePermissionWarning");
            Boolean enforceJava2Security = (Boolean)cmd.getParameter("enforceJava2Security");
            Boolean enforceFineGrainedSec = (Boolean)cmd.getParameter("enforceFineGrainedJCASecurity");
            Boolean appSecurityEnabled = (Boolean)cmd.getParameter("appSecurityEnabled");
            String activeUserRegistry = (String)cmd.getParameter("activeUserRegistry");
            Boolean useDomainQualifiedUserNames = (Boolean)cmd.getParameter("useDomainQualifiedUserNames");
            String customProperties = (String)cmd.getParameter("customProperties");
            if (secDomain != null && secDomain.equals("PassThroughToGlobalSecurity")) {
                String command = cmd.getName();
                String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{command, secDomain});
                throw new CommandValidationException(msg);
            }
            secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
            if (secObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                throw new CommandValidationException(msg);
            }
            if (activeUserRegistry != null && !activeUserRegistry.equals("")) {
                if (!this.validUserRegType(activeUserRegistry)) {
                    String msg = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                    throw new CommandValidationException(msg);
                }
                activeRegistryObj = SecConfigTaskHelper.getRegObj(session, configService, secObj, activeUserRegistry);
                if (activeRegistryObj != null) {
                    boolean registryOK = SecConfigTaskHelper.isAppRegistryGood(session, configService, activeRegistryObj);
                    if (!registryOK) {
                        String msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                        throw new CommandValidationException(msg);
                    }
                } else {
                    String msg = this.getMsg(resBundle, "security.admintask.noUserRegistry.SECJ7723E", new Object[]{activeUserRegistry});
                    throw new CommandValidationException(msg);
                }
            }
            if (cacheTimeout != null) {
                attrList.add(new Attribute("cacheTimeout", cacheTimeout));
            }
            if (issuePermissionWarning != null) {
                attrList.add(new Attribute("issuePermissionWarning", issuePermissionWarning));
            }
            if (enforceJava2Security != null) {
                attrList.add(new Attribute("enforceJava2Security", enforceJava2Security));
            }
            if (enforceFineGrainedSec != null) {
                attrList.add(new Attribute("enforceFineGrainedJCASecurity", enforceFineGrainedSec));
            }
            if (appSecurityEnabled != null) {
                attrList.add(new Attribute("appEnabled", appSecurityEnabled));
            }
            if (activeUserRegistry != null) {
                if (activeUserRegistry.equals("")) {
                    attrList.add(new Attribute("activeUserRegistry", null));
                } else {
                    attrList.add(new Attribute("activeUserRegistry", activeRegistryObj));
                }
            }
            if (useDomainQualifiedUserNames != null) {
                attrList.add(new Attribute("useDomainQualifiedUserNames", useDomainQualifiedUserNames));
            }
            if (attrList != null) {
                configService.setAttributes(session, secObj, attrList);
            }
            if (customProperties != null) {
                SecConfigTaskHelper.addCustomProperties(session, configService, secObj, customProperties);
            }
            if (this.isPropertySet(session, configService, secObj, "security.zOS.domainName", "properties") || this.isPropertySet(session, configService, secObj, "security.zOS.domainType", "properties")) {
                displayMessages = this.getMsg(resBundle, "security.admintask.oldZDomainPropsConfigured.SECJ7784W", null);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", "1809");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureAppActiveSecurity", displayMessages);
        }
        return displayMessages;
    }

    private boolean validLevel(String level) {
        return level.equalsIgnoreCase("Never") || level.equalsIgnoreCase("Supported") || level.equalsIgnoreCase("Required");
    }

    private boolean validAuthMechanism(String activeAuthMechanism) {
        return activeAuthMechanism.equalsIgnoreCase("KRB5") || activeAuthMechanism.equalsIgnoreCase("LTPA") || activeAuthMechanism.equalsIgnoreCase("RSAToken") || activeAuthMechanism.equalsIgnoreCase("BasicAuth") || activeAuthMechanism.equalsIgnoreCase("Custom");
    }

    private boolean validMechanism(String[] mechanisms) {
        for (int i = 0; i < mechanisms.length; ++i) {
            if (mechanisms[i].equalsIgnoreCase("KRB5") || mechanisms[i].equalsIgnoreCase("LTPA") || mechanisms[i].equalsIgnoreCase("RSAToken") || mechanisms[i].equalsIgnoreCase("BasicAuth") || mechanisms[i].equalsIgnoreCase("Custom")) continue;
            return false;
        }
        return true;
    }

    private boolean validUserRegType(String userRegType) {
        return userRegType.equalsIgnoreCase("LDAPUserRegistry") || userRegType.equalsIgnoreCase("WIMUserRegistry") || userRegType.equalsIgnoreCase("CustomUserRegistry") || userRegType.equalsIgnoreCase("LocalOSUserRegistry");
    }

    private ObjectName getCellObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellObjectName", new Object[]{session, configService, this});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName cell = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell ObjectName is " + cell + ". Cell Name is " + ConfigServiceHelper.getDisplayName(cell));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellObjectName", cell);
        }
        return cell;
    }

    private boolean krb5IsConfigured(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "krb5IsConfigured");
        }
        Boolean krbValid = Boolean.FALSE;
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand getUserCmd = commandMgr.createCommand("validateKrbConfig");
            getUserCmd.setParameter("checkConfigOnly", false);
            getUserCmd.setParameter("validateKrbRealm", true);
            getUserCmd.setParameter("useGlobalSecurityConfig", true);
            configService = ConfigServiceFactory.getConfigService();
            session = new Session();
            getUserCmd.setConfigSession(session);
            getUserCmd.execute();
            CommandResult cmdResult = getUserCmd.getCommandResult();
            if (cmdResult.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "krb5IsConfigured");
                }
                krbValid = (Boolean)cmdResult.getResult();
            } else {
                Throwable e = cmdResult.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "verifyKrbConfig did not execute.", new Object[]{e});
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verifyKrbConfig did not execute.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "krb5IsConfigured");
        }
        return krbValid;
    }

    private void setTrustedRealmObj(Session session, ConfigService configService, ObjectName secObj, String trustedTargetRealms) throws Exception {
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("realmList", trustedTargetRealms));
        if (trustedTargetRealms != null && trustedTargetRealms.length() > 0) {
            ObjectName trustedRealmObj = SecConfigTaskHelper.getTrustedRealms(session, configService, secObj, "outboundTrustedAuthenticationRealm");
            if (trustedRealmObj != null) {
                configService.setAttributes(session, trustedRealmObj, attrList);
            } else {
                configService.createConfigData(session, secObj, "outboundTrustedAuthenticationRealm", "TrustedAuthenticationRealm", attrList);
            }
        }
    }

    private boolean isPropertySet(Session session, ConfigService cs, ObjectName targetObj, String propertyName, String customEntName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPropertySet", propertyName);
        }
        boolean isPropertySet = false;
        if (propertyName != null && propertyName.length() > 0) {
            List props = null;
            AttributeList attributeList = cs.getAttributes(session, targetObj, new String[]{customEntName}, false);
            if (attributeList != null) {
                props = (List)((Attribute)attributeList.get(0)).getValue();
            }
            ObjectName property = null;
            if (props != null && !props.isEmpty()) {
                for (int j = 0; j < props.size(); ++j) {
                    property = (ObjectName)props.get(j);
                    String propName = (String)cs.getAttribute(session, property, "name");
                    if (!propName.equals(propertyName)) continue;
                    isPropertySet = true;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPropertySet", isPropertySet);
        }
        return isPropertySet;
    }
}

