/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.security.Result;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.securitydomain.ServerProcessNotFoundException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class SecConfigTaskHelper {
    private static TraceComponent tc = Tr.register(SecConfigTaskHelper.class, "security", "com.ibm.ws.security.admintask.securityDomain");
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static final String CELL = "Cell";
    private static final String SERVER = "Server";
    private static final String SERVERCLUSTER = "ServerCluster";
    private static final String CLUSTER = "Cluster";
    private static final String SIBUS = "SIBus";

    private static String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public static ObjectName getSecDomain(Session session, ConfigService configService, String secDomainName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecDomain", secDomainName);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName apps;
            ObjectName domain = domains[i];
            String name = (String)configService.getAttribute(session, domain, "name");
            if (!name.equals(secDomainName) || (apps = configService.queryConfigObjects(session, domain, pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity"), null)[0]) == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecDomain");
            }
            return apps;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecDomain");
        }
        return null;
    }

    public static ObjectName getSecurityObjectName(Session session, ConfigService configService) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityObjectName", new Object[]{session, configService});
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
        ObjectName security2 = configService.queryConfigObjects(session, null, pattern, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security ObjectName is " + security2 + ". Cell Name is " + ConfigServiceHelper.getDisplayName(security2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityObjectName", security2);
        }
        return security2;
    }

    public static ObjectName getRegObj(Session session, ConfigService configService, ObjectName secObj, String regType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRegObj", regType);
        }
        ObjectName regObj = null;
        try {
            ArrayList registries = (ArrayList)configService.getAttribute(session, secObj, "userRegistries");
            if (registries != null) {
                for (int i = 0; i < registries.size(); ++i) {
                    ObjectName matches;
                    AttributeList urAttrs = (AttributeList)registries.get(i);
                    Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                    if (!urObj.toString().equals(regType) || (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(urAttrs), null)[0]) == null) continue;
                    regObj = matches;
                }
            }
        }
        catch (InvalidAttributeNameException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRegObj");
            }
            return regObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegObj");
        }
        return regObj;
    }

    public static Properties getCustomProperties(String propString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomProperties");
        }
        Properties customProps = new Properties();
        if (propString != null) {
            String[] entries = propString.split(",");
            for (int i = 0; i < entries.length; ++i) {
                String entry = entries[i];
                int index = entry.indexOf("=");
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                customProps.put(name, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomProperties");
        }
        return customProps;
    }

    public static boolean authenticateUser(Session session, String username, String password, String regType, Properties props, String process) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticateUser", new Object[]{username, regType});
        }
        Boolean results = Boolean.TRUE;
        try {
            if (regType.equalsIgnoreCase("WIMUserRegistry")) {
                UserRegistryValidator urV = new UserRegistryValidator(session.toString());
                String s = urV.checkPassword(username, password);
                if (s == null) {
                    results = Boolean.FALSE;
                }
            } else if (SecConfigTaskHelper.isGoodServerId(session, username, regType, props)) {
                String processName = null;
                ObjectName on = null;
                processName = process != null && process.indexOf("Server=") >= 0 ? process.substring(process.indexOf("Server=") + 7) : AdminServiceFactory.getAdminService().getProcessName();
                on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                if (!it.hasNext()) {
                    return false;
                }
                on = (ObjectName)it.next();
                results = (Boolean)AdminServiceFactory.getAdminService().invoke(on, "checkPassword", new Object[]{username, password, props}, new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"});
            } else {
                results = Boolean.FALSE;
            }
        }
        catch (MBeanException ex) {
            Exception e = (Exception)ex.getCause();
            if (e != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get cause exception while trying to authenticate the server id, " + username + ",  in the " + regType + " user registry: " + e.getMessage());
                }
                throw e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Rethrow exception while trying to authenticate the server id, " + username + ",  in the " + regType + " user registry: " + ex.getMessage());
            }
            throw ex;
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while trying to authenticate the server id, " + username + ",  in the " + regType + " user registry: " + ex.getMessage());
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticateUser: " + results);
        }
        return results;
    }

    public static boolean isGoodServerId(Session session, String username, String regType, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGoodServerId", new Object[]{username, regType});
        }
        boolean userExists = false;
        int count = 0;
        try {
            if (regType.equalsIgnoreCase("WIMUserRegistry")) {
                UserRegistryValidator urV = new UserRegistryValidator(session.toString());
                Result userResult = urV.getUsers(username, 2);
                if (userResult.getList().isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "user " + username + " not found in WIM UR");
                    }
                    userExists = false;
                } else {
                    userExists = true;
                }
            } else {
                List list;
                String processName = AdminServiceFactory.getAdminService().getProcessName();
                ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                if (!it.hasNext()) {
                    userExists = false;
                }
                on = (ObjectName)it.next();
                Result results = (Result)AdminServiceFactory.getAdminService().invoke(on, "getUsers", new Object[]{username, new Integer(2), props}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                if (results != null && results.getList() != null && (count = (list = results.getList()).size()) > 0) {
                    userExists = true;
                }
            }
        }
        catch (MBeanException ex) {
            Exception e = (Exception)ex.getCause();
            if (e != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get cause mbean exception while trying to see if the primary admin id, " + username + ", exists in the " + regType + " user registry: " + e.getMessage());
                }
                throw e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rethrow exception while trying to see if the primary admin id, " + username + ", exists in the " + regType + " user registry: " + ex.getMessage());
            }
            throw ex;
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while trying to see if the primary admin id, " + username + ", exists in the " + regType + " user registry: " + ex.getMessage());
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGoodServerId");
        }
        return userExists;
    }

    public static void addInfoToConfig(Session session, ConfigService configService, ObjectName secObj, ObjectName reg, String regType, AttributeList regAttrs, String propString) throws Exception {
        ObjectName regObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInfoToConfig", regType);
        }
        if ((regObj = reg) != null) {
            configService.setAttributes(session, reg, regAttrs);
        } else {
            regObj = configService.createConfigData(session, secObj, "userRegistries", regType, regAttrs);
        }
        if (propString != null && propString.length() > 0) {
            SecConfigTaskHelper.addCustomProperties(session, configService, regObj, propString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInfoToConfig");
        }
    }

    public static void addCustomProperties(Session session, ConfigService cs, ObjectName targetObj, String propString) throws Exception {
        if (!SecConfigTaskHelper.isCustomPropStringGood(propString)) {
            String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badCustomProp.SECJ7773E", new Object[]{propString});
            throw new CommandValidationException(msg);
        }
        SecConfigTaskHelper.addCustomValues(session, cs, targetObj, propString, "properties");
    }

    public static void addCustomEntries(Session session, ConfigService cs, ObjectName targetObj, String propString, String type) throws Exception {
        if (!SecConfigTaskHelper.isCustomPropStringGood(propString)) {
            String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badCustomProp.SECJ7773E", new Object[]{propString});
            throw new CommandValidationException(msg);
        }
        SecConfigTaskHelper.addCustomValues(session, cs, targetObj, propString, type);
    }

    public static void addCustomValues(Session session, ConfigService cs, ObjectName targetObj, String propString, String customEntName) throws Exception {
        if (propString != null && propString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
            while (tokenizer.hasMoreTokens()) {
                List props = null;
                AttributeList attributeList = cs.getAttributes(session, targetObj, new String[]{customEntName}, false);
                if (attributeList != null) {
                    props = (List)((Attribute)attributeList.get(0)).getValue();
                }
                AttributeList attrList = new AttributeList();
                String entry = tokenizer.nextToken();
                if (entry != null && entry.equals(",")) continue;
                ObjectName property = null;
                int index = entry.indexOf("=");
                if (index <= 0) continue;
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                if (name != null && name.length() > 0) {
                    name = name.trim();
                }
                if (value != null && value.length() > 0) {
                    value = value.trim();
                }
                attrList.clear();
                attrList.add(new Attribute("name", name));
                if (value != null && value.equals("''")) {
                    attrList.add(new Attribute("value", ""));
                } else {
                    attrList.add(new Attribute("value", value));
                }
                if (props != null && !props.isEmpty()) {
                    boolean propertySet = false;
                    for (int j = 0; j < props.size(); ++j) {
                        property = (ObjectName)props.get(j);
                        String propName = (String)cs.getAttribute(session, property, "name");
                        if (!propName.equals(name)) continue;
                        cs.deleteConfigData(session, property);
                        if (value != null && value.length() > 0) {
                            cs.createConfigData(session, targetObj, customEntName, null, attrList);
                        }
                        propertySet = true;
                        break;
                    }
                    if (propertySet || value == null || value.length() <= 0) continue;
                    cs.createConfigData(session, targetObj, customEntName, null, attrList);
                    continue;
                }
                if (value == null || value.length() <= 0) continue;
                cs.createConfigData(session, targetObj, customEntName, null, attrList);
            }
        }
    }

    public static String getDefaultRealm(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        String realm = null;
        try {
            String processName = AdminServiceFactory.getAdminService().getProcessName();
            ObjectName on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
            Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!it.hasNext()) {
                return null;
            }
            on = (ObjectName)it.next();
            realm = (String)AdminServiceFactory.getAdminService().invoke(on, "getRealm", new Object[]{props}, new String[]{"java.util.Properties"});
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while getting the realm", ex.getMessage());
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm");
        }
        return realm;
    }

    public static ObjectName getAuthMechanismObj(Session session, ConfigService cs, ObjectName secObj, String authType) {
        ObjectName authObj = null;
        try {
            ArrayList authMechanisms = (ArrayList)cs.getAttribute(session, secObj, "authMechanisms");
            if (authMechanisms != null) {
                for (int i = 0; i < authMechanisms.size(); ++i) {
                    ObjectName matches;
                    AttributeList authAttrs = (AttributeList)authMechanisms.get(i);
                    Object auth = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                    if (!auth.toString().equals(authType) || (matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(authAttrs), null)[0]) == null) continue;
                    authObj = matches;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return authObj;
    }

    public static boolean isRegistryGood(Session session, ConfigService cs, ObjectName regObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistryGood");
        }
        boolean isGood = true;
        Boolean useRegServerId = null;
        String primaryAdminId = null;
        String serverid = null;
        String password = null;
        String regType = null;
        Properties props = new Properties();
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        try {
            String msg;
            useRegServerId = (boolean)((Boolean)cs.getAttribute(session, regObj, "useRegistryServerId", false));
            serverid = (String)cs.getAttribute(session, regObj, "serverId", false);
            password = (String)cs.getAttribute(session, regObj, "serverPassword", false);
            primaryAdminId = (String)cs.getAttribute(session, regObj, "primaryAdminId", false);
            AttributeList regAttrs = cs.getAttributes(session, regObj, null, true);
            regType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
            props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, cs, regObj, props);
            if (regType.equalsIgnoreCase("LocalOSUserRegistry")) {
                props.setProperty("activeRegistry", "LOCALOS");
            } else if (regType.equalsIgnoreCase("CustomUserRegistry")) {
                String customRegClass = (String)cs.getAttribute(session, regObj, "customRegistryClassName", false);
                Boolean ignoreCase = (Boolean)cs.getAttribute(session, regObj, "ignoreCase", false);
                props.setProperty("activeRegistry", "CUSTOM");
                props.setProperty("CustUserRegImplClass", customRegClass);
                props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
            } else if (regType.equalsIgnoreCase("WIMUserRegistry")) {
                props.setProperty("activeRegistry", "WIM");
                props.setProperty("CustUserRegImplClass", "com.ibm.ws.wim.registry.WIMUserRegistry");
            } else if (regType.equalsIgnoreCase("LDAPUserRegistry")) {
                props = SecConfigTaskHelper.getLDAPProps(props, regAttrs);
                props.setProperty("activeRegistry", "LDAP");
            } else {
                String msg2 = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                throw new CommandValidationException(msg2);
            }
            if (useRegServerId.booleanValue()) {
                if (serverid != null && serverid.length() > 0) {
                    if (password != null && serverid.length() > 0) {
                        boolean authenticated = SecConfigTaskHelper.authenticateUser(session, serverid, password, regType, props, null);
                        if (!authenticated) {
                            String msg3 = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badUserOrPassword.SECJ7715E", null);
                            throw new CommandValidationException(msg3);
                        }
                    } else if (!SecConfigTaskHelper.isGoodServerId(session, serverid, regType, props)) {
                        msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badAdminID.SECJ7716E", null);
                        throw new CommandValidationException(msg);
                    }
                } else {
                    isGood = platformHelper.isZOS() && regType.equalsIgnoreCase("LocalOSUserRegistry");
                }
            }
            if (primaryAdminId != null && primaryAdminId.length() > 0) {
                if (!SecConfigTaskHelper.isGoodServerId(session, primaryAdminId, regType, props)) {
                    msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badAdminID.SECJ7716E", null);
                    throw new CommandValidationException(msg);
                }
            } else {
                Boolean safEnabled = Boolean.FALSE;
                if (platformHelper.isZOS()) {
                    String safValue = (String)SecConfigTaskHelper.getCustomProperty(session, cs, "com.ibm.security.SAF.authorization");
                    if (safValue != null) {
                        safEnabled = Boolean.valueOf(safValue);
                    }
                    if (!safEnabled.booleanValue()) {
                        isGood = false;
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "%");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while checking for a good registry", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistryGood", new Object[]{isGood});
        }
        return isGood;
    }

    public static Object getCustomProperty(Session session, ConfigService cs, String prop) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomProperty");
        }
        Object propValue = null;
        try {
            ObjectName sec2 = SecConfigTaskHelper.getSecurityObjectName(session, cs);
            AttributeList attributeList = cs.getAttributes(session, sec2, new String[]{"properties"}, false);
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                if (!propName.equals(prop)) continue;
                propValue = cs.getAttribute(session, property, "value");
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomProperty");
        }
        return propValue;
    }

    public static boolean isRegistryGood(Session session, ConfigService cs, String regType, AttributeList regAttrs, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistryGood");
        }
        boolean isGood = true;
        Boolean useRegServerId = null;
        String primaryAdminId = null;
        String serverid = null;
        String password = null;
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        try {
            useRegServerId = (Boolean)ConfigServiceHelper.getAttributeValue(regAttrs, "useRegistryServerId");
            serverid = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "serverId");
            password = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "serverPassword");
            primaryAdminId = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "primaryAdminId");
            if (useRegServerId.booleanValue()) {
                if (serverid != null && serverid.length() > 0) {
                    if (password != null && password.length() > 0) {
                        boolean authenticated = SecConfigTaskHelper.authenticateUser(session, serverid, password, regType, props, null);
                        if (!authenticated) {
                            String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badUserOrPassword.SECJ7715E", null);
                            throw new CommandValidationException(msg);
                        }
                    } else if (!SecConfigTaskHelper.isGoodServerId(session, serverid, regType, props)) {
                        String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badAdminID.SECJ7716E", null);
                        throw new CommandValidationException(msg);
                    }
                } else {
                    isGood = platformHelper.isZOS() && regType.equalsIgnoreCase("LocalOSUserRegistry");
                }
            }
            if (primaryAdminId != null && primaryAdminId.length() > 0) {
                if (!SecConfigTaskHelper.isGoodServerId(session, primaryAdminId, regType, props)) {
                    String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.badAdminID.SECJ7716E", null);
                    throw new CommandValidationException(msg);
                }
            } else {
                String safValue;
                Boolean safEnabled = Boolean.FALSE;
                if (platformHelper.isZOS() && (safValue = (String)SecConfigTaskHelper.getCustomProperty(session, cs, "com.ibm.security.SAF.authorization")) != null) {
                    safEnabled = Boolean.valueOf(safValue);
                }
                if (!safEnabled.booleanValue()) {
                    isGood = false;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "591");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while checking for a good registry", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistryGood");
        }
        return isGood;
    }

    public static boolean isAppRegistryGood(Session session, ConfigService cs, ObjectName regObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAppRegistryGood", regObj);
        }
        boolean isGood = true;
        String regType = null;
        Properties props = new Properties();
        try {
            AttributeList regAttrs = cs.getAttributes(session, regObj, null, true);
            regType = (String)ConfigServiceHelper.getAttributeValue(regAttrs, "_Websphere_Config_Data_Type");
            String realm = (String)cs.getAttribute(session, regObj, "realm", false);
            if (realm != null && realm.length() == 0 || realm == null) {
                String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.noRealm.SECJ7725E", null);
                throw new CommandValidationException(msg);
            }
            props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, cs, regObj, props);
            if (regType.equalsIgnoreCase("LocalOSUserRegistry")) {
                props.setProperty("activeRegistry", "LOCALOS");
            } else if (regType.equalsIgnoreCase("CustomUserRegistry")) {
                String customRegClass = (String)cs.getAttribute(session, regObj, "customRegistryClassName", false);
                Boolean ignoreCase = (Boolean)cs.getAttribute(session, regObj, "ignoreCase", false);
                props.setProperty("activeRegistry", "CUSTOM");
                props.setProperty("CustUserRegImplClass", customRegClass);
                props.setProperty("security.registry.IgnoreCase", ignoreCase.toString());
            } else if (regType.equalsIgnoreCase("WIMUserRegistry")) {
                props.setProperty("activeRegistry", "WIM");
                props.setProperty("CustUserRegImplClass", "com.ibm.ws.wim.registry.WIMUserRegistry");
            } else if (regType.equalsIgnoreCase("LDAPUserRegistry")) {
                props = SecConfigTaskHelper.getLDAPProps(props, regAttrs);
                props.setProperty("activeRegistry", "LDAP");
            } else {
                String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
                throw new CommandValidationException(msg);
            }
            Boolean useRegistryRealm = (Boolean)cs.getAttribute(session, regObj, "useRegistryRealm");
            String myRealm = (String)cs.getAttribute(session, regObj, "realm");
            if (useRegistryRealm != null && myRealm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting WAS_UseRegistryRealm = " + useRegistryRealm.toString() + " and WAS_Realm = " + myRealm);
                }
                props.setProperty("WAS_UseRegistryRealm", useRegistryRealm.toString());
                props.setProperty("WAS_Realm", myRealm);
            }
            if (!SecConfigTaskHelper.isGoodServerId(session, "*", regType, props)) {
                PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                Boolean safEnabled = Boolean.FALSE;
                if (platformHelper.isZOS()) {
                    String safValue = (String)SecConfigTaskHelper.getCustomProperty(session, cs, "com.ibm.security.SAF.authorization");
                    if (safValue != null) {
                        safEnabled = Boolean.valueOf(safValue);
                    }
                    if (!safEnabled.booleanValue()) {
                        isGood = false;
                    }
                } else {
                    isGood = false;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "661");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught while checking for a good registry", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAppRegistryGood");
        }
        return isGood;
    }

    public static Properties getCustomPropertiesFromConfig(Session session, ConfigService cs, ObjectName regObj, Properties props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomPropertiesFromConfig");
        }
        try {
            AttributeList attrList = cs.getAttributes(session, regObj, new String[]{"properties"}, false);
            if (attrList != null) {
                List regProps = (List)((Attribute)attrList.get(0)).getValue();
                for (int i = 0; i < regProps.size(); ++i) {
                    ObjectName property = (ObjectName)regProps.get(i);
                    String name = (String)cs.getAttribute(session, property, "name");
                    String value = (String)cs.getAttribute(session, property, "value");
                    props.setProperty(name, value);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "692");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught validating the ssl config name", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomPropertiesFromConfig");
        }
        return props;
    }

    public static Properties mergeCustomProperties(String propString, Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeCustomProperties");
        }
        if (propString != null) {
            StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
            while (tokenizer.hasMoreTokens()) {
                int index;
                String entry = tokenizer.nextToken();
                if (entry != null && entry.equals(",") || (index = entry.indexOf("=")) <= 0) continue;
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                if (name != null && name.length() > 0) {
                    name = name.trim();
                }
                if (value != null && value.length() > 0) {
                    value = value.trim();
                }
                if (!props.isEmpty()) {
                    if (props.containsKey(name)) {
                        props.remove(name);
                    }
                    if (value.length() <= 0) continue;
                    props.put(name, value);
                    continue;
                }
                if (value.length() <= 0) continue;
                props.put(name, value);
            }
        }
        if (tc.isDebugEnabled()) {
            Properties printProps = SetLdapConfig.clearPasswordProps(props);
            Tr.debug(tc, "props returned " + printProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeCustomProperties");
        }
        return props;
    }

    public static boolean validSSLConfig(Session session, ConfigService cs, ObjectName secObj, String sslConfig) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validSSLConfig", sslConfig);
        }
        try {
            List repertoires = (List)cs.getAttribute(session, secObj, CommandConstants.REPERTOIRE);
            for (AttributeList repertoire : repertoires) {
                String sslConfigName = (String)ConfigServiceHelper.getAttributeValue(repertoire, "alias");
                if (!sslConfigName.equals(sslConfig)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validSSLConfig:true");
                }
                return true;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "758");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught validating the ssl config name", e);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validSSLConfig: false");
        }
        return false;
    }

    public static Object getPropertyValue(Session session, ConfigService cs, ObjectName obj, String propAttrName, String name) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyValue", name);
        }
        try {
            Object value = null;
            AttributeList attrList = cs.getAttributes(session, obj, new String[]{propAttrName}, false);
            if (attrList != null) {
                List props = (List)((Attribute)attrList.get(0)).getValue();
                for (int i = 0; i < props.size(); ++i) {
                    ObjectName property = (ObjectName)props.get(i);
                    String propName = (String)cs.getAttribute(session, property, "name");
                    if (!propName.equals(name)) continue;
                    value = cs.getAttribute(session, property, "value");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getPropertyValue", value);
                    }
                    return value;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropertyValue", value);
            }
            return value;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecurityConfigProvider", "790");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught validating the ssl config name", e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getLDAPProps(Properties props, AttributeList attrs) throws Exception {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLDAPProps");
            }
            try {
                String certMode;
                block27: {
                    String groupMemberIdMap;
                    String groupIdMap;
                    String userIdMap;
                    String groupFilter;
                    AttributeList hostAttrs;
                    ArrayList hosts;
                    String realm;
                    Boolean sslEnabled;
                    String type;
                    Long timeout;
                    Boolean reuseConnection;
                    String bindPwd;
                    String bindDN;
                    String baseDN = (String)ConfigServiceHelper.getAttributeValue(attrs, "baseDN");
                    if (baseDN != null) {
                        props.setProperty("ldap.basedn", baseDN);
                    }
                    if ((bindDN = (String)ConfigServiceHelper.getAttributeValue(attrs, "bindDN")) != null) {
                        props.setProperty("java.naming.security.principal", bindDN);
                    }
                    if ((bindPwd = (String)ConfigServiceHelper.getAttributeValue(attrs, "bindPassword")) != null) {
                        props.setProperty("java.naming.security.credentials", bindPwd);
                    }
                    if ((reuseConnection = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "reuseConnection")) != null) {
                        props.setProperty("security.registry.ldap.reuseConn", reuseConnection.toString());
                    }
                    if ((timeout = (Long)ConfigServiceHelper.getAttributeValue(attrs, "searchTimeout")) != null) {
                        props.setProperty("security.registry.ldap.searchTimeLimit", timeout.toString());
                    }
                    if ((type = (String)ConfigServiceHelper.getAttributeValue(attrs, "type")) != null) {
                        props.setProperty("dirType", type);
                    }
                    if ((sslEnabled = (Boolean)ConfigServiceHelper.getAttributeValue(attrs, "sslEnabled")) != null) {
                        props.put("sslEnabled", sslEnabled);
                    }
                    if ((realm = (String)ConfigServiceHelper.getAttributeValue(attrs, "realm")) != null) {
                        props.setProperty("LDAP.server.realm", realm);
                    }
                    if ((hosts = (ArrayList)ConfigServiceHelper.getAttributeValue(attrs, "hosts")).size() > 0 && (hostAttrs = (AttributeList)hosts.get(0)) != null) {
                        String host = (String)ConfigServiceHelper.getAttributeValue(hostAttrs, "host");
                        Integer port = (Integer)ConfigServiceHelper.getAttributeValue(hostAttrs, "port");
                        if (host != null && port != null) {
                            String ldapProtocol = "ldap://";
                            StringBuffer ldapUrl = new StringBuffer();
                            boolean ldapServerTypeValue = false;
                            if (host.indexOf(":") != -1) {
                                ldapUrl.append(ldapProtocol).append("[" + host + "]");
                            } else {
                                ldapUrl.append(ldapProtocol).append(host);
                            }
                            if (port != null && port > 0) {
                                ldapUrl.append(":" + port);
                            }
                            props.setProperty("java.naming.provider.url", ldapUrl.toString());
                        }
                    }
                    props.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                    AttributeList searchAttrs = (AttributeList)ConfigServiceHelper.getAttributeValue(attrs, "searchFilter");
                    if (searchAttrs == null) break block26;
                    String userFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "userFilter");
                    if (userFilter != null) {
                        props.setProperty("user.filter", userFilter);
                    }
                    if ((groupFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupFilter")) != null) {
                        props.setProperty("group.filter", groupFilter);
                    }
                    if ((userIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "userIdMap")) != null) {
                        props.setProperty("user.idmap", userIdMap);
                    }
                    if ((groupIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupIdMap")) != null) {
                        props.setProperty("group.idmap", groupIdMap);
                    }
                    if ((groupMemberIdMap = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "groupMemberIdMap")) != null) {
                        props.setProperty("groupmember.idmap", groupMemberIdMap);
                    }
                    certMode = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "certificateMapMode");
                    String certFilter = (String)ConfigServiceHelper.getAttributeValue(searchAttrs, "certificateFilter");
                    if (certMode != null && certMode.equals("CERTIFICATE_FILTER")) {
                        certMode = "filterDescriptorMode";
                        if (certFilter != null && certFilter.length() > 0) {
                            props.setProperty("certificate.map.filter", certFilter);
                            break block27;
                        } else {
                            String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.noUserReg.SECJ7763E", null);
                            throw new CommandValidationException(msg);
                        }
                    }
                    certMode = "exactDNMode";
                }
                props.setProperty("certificate.map.mode", certMode);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.adminTasks.securityDomain.SecConfigTaskHelper", "911");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception caught getting ldap attributes", e);
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLDAPProps");
        }
        return props;
    }

    public static ObjectName getTrustedRealms(Session session, ConfigService configService, ObjectName secObj, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustedRealms");
        }
        ObjectName trustedRealmObj = null;
        try {
            ObjectName matches;
            AttributeList trustedRealms = (AttributeList)configService.getAttribute(session, secObj, type);
            if (trustedRealms != null && (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(trustedRealms), null)[0]) != null) {
                trustedRealmObj = matches;
            }
        }
        catch (InvalidAttributeNameException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTrustedRealms");
            }
            return trustedRealmObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustedRealms");
        }
        return trustedRealmObj;
    }

    public static boolean isCustomPropStringGood(String propString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCustomPropStringGood", propString);
        }
        try {
            if (propString != null && propString.length() > 0) {
                if (!propString.startsWith("\"") && !propString.endsWith("\"")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
                StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
                while (tokenizer.hasMoreTokens()) {
                    String getComma;
                    String token = tokenizer.nextToken();
                    if (token.indexOf("=") < 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isCustomPropStringGood: false");
                        }
                        return false;
                    }
                    if (!tokenizer.hasMoreTokens() || (getComma = tokenizer.nextToken()) != null && getComma.trim().equals(",") && tokenizer.hasMoreTokens()) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCustomPropStringGood: false");
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while tokenizing custom property string " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCustomPropStringGood: true");
        }
        return true;
    }

    public static boolean checkRunAsUser(Session session, List userList, List groupList, String username, Properties props, String process) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRunAsUser", new Object[]{username, userList, groupList});
        }
        Boolean results = Boolean.TRUE;
        try {
            String processName = null;
            ObjectName on = null;
            processName = process != null && process.indexOf("Server=") >= 0 ? process.substring(process.indexOf("Server=") + 7) : AdminServiceFactory.getAdminService().getProcessName();
            on = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
            Iterator it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!it.hasNext()) {
                String msg = SecConfigTaskHelper.getMsg(resBundle, "security.admintask.serverProcessNotFound.SECJ7798E", new Object[]{processName});
                throw new ServerProcessNotFoundException(msg);
            }
            on = (ObjectName)it.next();
            results = (Boolean)AdminServiceFactory.getAdminService().invoke(on, "checkRunAsUser", new Object[]{userList, groupList, username, props}, new String[]{"java.util.List", "java.util.List", "java.lang.String", "java.util.Properties"});
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while checking runas user " + username + ": " + ex.getMessage());
            }
            results = Boolean.FALSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRunAsUser" + results);
        }
        return results;
    }

    public static String updateRealmList(Session session, ConfigService configService, ObjectName trustedRealmObj, String realmList) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRealmList");
        }
        String realms = null;
        String realmsFromConfig = null;
        ArrayList<String> cfgRealmsArray = new ArrayList<String>();
        if (trustedRealmObj != null) {
            realmsFromConfig = (String)configService.getAttribute(session, trustedRealmObj, "realmList");
        }
        if (realmsFromConfig != null && realmsFromConfig.length() > 0) {
            int i;
            String[] cfgRealms = realmsFromConfig.split("\\|");
            for (int i2 = 0; i2 < cfgRealms.length; ++i2) {
                cfgRealmsArray.add(cfgRealms[i2]);
            }
            String[] cmdRealms = realmList.split("\\|");
            for (i = 0; i < cmdRealms.length; ++i) {
                String delRealm = cmdRealms[i];
                if (!cfgRealmsArray.contains(delRealm)) continue;
                cfgRealmsArray.remove(delRealm);
            }
            if (cfgRealmsArray.size() > 0) {
                for (i = 0; i < cfgRealmsArray.size(); ++i) {
                    realms = realms != null ? realms + "|" + cfgRealmsArray.get(i) : (String)cfgRealmsArray.get(i);
                }
            } else {
                realms = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRealmList");
        }
        return realms;
    }

    public static boolean removeResourceFromSecurityDomain(ConfigService cs, Session session, String resourceID, String resourceType) throws Exception {
        block19: {
            int inx2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeResourceFromSecurityDomain", new Object[]{resourceID});
            }
            Object altResourceName = null;
            String resource = null;
            if (cs == null) {
                cs = ConfigServiceFactory.getConfigService();
            }
            if (cs == null) {
                Properties prop = new Properties();
                prop.setProperty("location", "local");
                try {
                    cs = ConfigServiceFactory.createConfigService(true, prop);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (cs == null) {
                return false;
            }
            resource = resourceID;
            int inx = resourceID.indexOf("|");
            if (inx > 0) {
                resource = resourceID.substring(0, inx);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource is ", resource);
            }
            if (resourceType == null && (inx = resourceID.indexOf("#")) > 0 && (inx2 = resourceID.indexOf("_", inx)) > 0) {
                resourceType = resourceID.substring(inx + 1, inx2);
            }
            try {
                if (resourceType == null || resource == null) {
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resourceType ", resourceType);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resource ", resource);
                }
                if (resourceType.equals(SERVER) || resourceType.equals(SERVERCLUSTER)) {
                    ObjectName domain = null;
                    ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                    ObjectName[] domains = cs.queryConfigObjects(session, null, pattern, null);
                    block4: for (int i = 0; i < domains.length; ++i) {
                        domain = domains[i];
                        String name = (String)cs.getAttribute(session, domain, "name");
                        ArrayList members = (ArrayList)cs.getAttribute(session, domain, "members", false);
                        for (int j = 0; j < members.size(); ++j) {
                            ObjectName member = (ObjectName)members.get(j);
                            String memberName = (String)cs.getAttribute(session, member, "resourceName");
                            String memberType = (String)cs.getAttribute(session, member, "resourceType");
                            if (!memberName.equals(resource) || !memberType.equals(resourceType)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "deleting member ", memberName);
                            }
                            Tr.info(tc, "security.admintask.resourceRemovedFromSecurityDomain.SECJ7818I", new Object[]{resource, name});
                            cs.deleteConfigData(session, member);
                            continue block4;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Exception while trying to remove resrouce from a security domain ", e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeResourceFromSecurityDomain");
        }
        return true;
    }
}

