/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetRSATokenAuthorization
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GetRSATokenAuthorization.class, "GetRolePropAuthorization", "com.ibm.ws.security.admintask.securityDomain");
    Boolean globalSecEnabled = new Boolean(false);
    Long tokenExpiration = null;
    Long nonceCacheTimeout = null;
    String adminCertTrustStore = null;
    String adminCertTrustStoreScope = null;
    String adminCertKeyStore = null;
    String adminCertKeyStoreScope = null;
    String adminCertAlias = null;
    ObjectName trustStoreObj = null;
    ObjectName keyStoreObj = null;
    ObjectName certObj = null;

    public GetRSATokenAuthorization(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetRSATokenAuthorization(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ObjectName secObj = null;
        AttributeList attrList = new AttributeList();
        try {
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            secObj = configService.resolve(session, "Cell=:Security=")[0];
            ObjectName rolePropObj = GetRSATokenAuthorization.getRolePropObj(session, configService, secObj);
            if (rolePropObj != null) {
                String authValidationConfig;
                String simpleAuthConfig;
                String authConfig;
                String authContextImplClass;
                String OID2 = (String)configService.getAttribute(session, rolePropObj, "OID");
                if (OID2 != null) {
                    attrList.add(new Attribute("OID", OID2));
                }
                if ((authContextImplClass = (String)configService.getAttribute(session, rolePropObj, "authContextImplClass")) != null) {
                    attrList.add(new Attribute("authContextImplClass", authContextImplClass));
                }
                if ((authConfig = (String)configService.getAttribute(session, rolePropObj, "authConfig")) != null) {
                    attrList.add(new Attribute("authConfig", authConfig));
                }
                if ((simpleAuthConfig = (String)configService.getAttribute(session, rolePropObj, "simpleAuthConfig")) != null) {
                    attrList.add(new Attribute("simpleAuthConfig", simpleAuthConfig));
                }
                if ((authValidationConfig = (String)configService.getAttribute(session, rolePropObj, "authValidationConfig")) != null) {
                    attrList.add(new Attribute("authValidationConfig", authValidationConfig));
                }
                this.tokenExpiration = (Long)configService.getAttribute(session, rolePropObj, "tokenExpiration");
                if (this.tokenExpiration != null) {
                    this.tokenExpiration = this.tokenExpiration / 60L;
                    attrList.add(new Attribute("tokenExpiration", this.tokenExpiration));
                }
                this.nonceCacheTimeout = (Long)configService.getAttribute(session, rolePropObj, "nonceCacheTimeout");
                if (this.nonceCacheTimeout != null) {
                    this.nonceCacheTimeout = this.nonceCacheTimeout / 60L;
                    attrList.add(new Attribute("nonceCacheTimeout", this.nonceCacheTimeout));
                }
                this.trustStoreObj = (ObjectName)configService.getAttribute(session, rolePropObj, "adminCertificateTrustStore");
                if (this.trustStoreObj != null) {
                    this.adminCertTrustStore = (String)configService.getAttribute(session, this.trustStoreObj, "name");
                    if (this.adminCertTrustStore != null) {
                        attrList.add(new Attribute("adminCertTrustStore", this.adminCertTrustStore));
                    }
                    ObjectName trustStoreMgmtScope = (ObjectName)configService.getAttribute(session, this.trustStoreObj, "managementScope");
                    this.adminCertTrustStoreScope = (String)configService.getAttribute(session, trustStoreMgmtScope, "scopeName");
                    if (this.adminCertTrustStoreScope != null) {
                        attrList.add(new Attribute("adminCertTrustStoreScope", this.adminCertTrustStoreScope));
                    }
                }
                this.certObj = (ObjectName)configService.getAttribute(session, rolePropObj, "adminCertificate");
                if (this.certObj != null) {
                    this.keyStoreObj = (ObjectName)configService.getAttribute(session, this.certObj, "keyStore");
                    this.adminCertKeyStore = (String)configService.getAttribute(session, this.keyStoreObj, "name");
                    if (this.adminCertKeyStore != null) {
                        attrList.add(new Attribute("adminCertKeyStore", this.adminCertKeyStore));
                    }
                    ObjectName keyStoreMgmtScope = (ObjectName)configService.getAttribute(session, this.keyStoreObj, "managementScope");
                    this.adminCertKeyStoreScope = (String)configService.getAttribute(session, keyStoreMgmtScope, "scopeName");
                    if (this.adminCertKeyStoreScope != null) {
                        attrList.add(new Attribute("adminCertKeyStoreScope", this.adminCertKeyStoreScope));
                    }
                    this.adminCertAlias = (String)configService.getAttribute(session, this.certObj, "alias");
                    if (this.adminCertAlias != null) {
                        attrList.add(new Attribute("adminCertAlias", this.adminCertAlias));
                    }
                }
            } else {
                String msg = this.getMsg(resBundle, "security.admintask.rsaTokenNotPresent.SECJ7751E", null);
                throw new CommandValidationException(msg);
            }
            result.setResult(attrList);
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.GetRolePropAuthorization", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
        }
    }

    public static ObjectName getRolePropObj(Session session, ConfigService configService, ObjectName secObj) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRolePropObj");
        }
        ObjectName authMechObj = null;
        try {
            ArrayList mechanisms = (ArrayList)configService.getAttribute(session, secObj, "authMechanisms");
            if (mechanisms != null) {
                for (int i = 0; i < mechanisms.size(); ++i) {
                    ObjectName[] matches;
                    AttributeList authAttrs = (AttributeList)mechanisms.get(i);
                    Object authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                    if (!authObj.toString().equals("RSAToken") || (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(authAttrs), null))[0] == null) continue;
                    authMechObj = matches[0];
                }
            }
        }
        catch (InvalidAttributeNameException e) {
            return authMechObj;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRolePropObj");
        }
        return authMechObj;
    }
}

