/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask.securityDomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.securityDomain.SecConfigTaskHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigureWIMUserRegistry
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigureWIMUserRegistry.class, "ConfigureWIMUserRegistry", "com.ibm.ws.security.admintask.securityDomain");
    Boolean globalSecEnabled = new Boolean(false);

    public ConfigureWIMUserRegistry(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ConfigureWIMUserRegistry(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        ObjectName secObj = null;
        ObjectName globalSecObj = null;
        boolean useRegServerId = true;
        AttributeList attrList = new AttributeList();
        String commandName = this.getName();
        String secDomain = null;
        String serverid = null;
        String password = null;
        String primaryAdminId = null;
        Boolean autoGenServerId = null;
        Boolean ignoreCase = null;
        String customProps = null;
        Boolean verifyRegistry = null;
        String realm = null;
        String registryClassName = "com.ibm.ws.wim.registry.WIMUserRegistry";
        Boolean useRegistryRealm = null;
        Properties props = new Properties();
        try {
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            if (realm != null && realm.length() > 0) {
                useRegistryRealm = Boolean.FALSE;
            }
            if (commandName.equalsIgnoreCase("configureAdminWIMUserRegistry")) {
                serverid = (String)this.getParameter("serverId");
                password = (String)this.getParameter("serverIdPassword");
                primaryAdminId = (String)this.getParameter("primaryAdminId");
                autoGenServerId = (Boolean)this.getParameter("autoGenerateServerId");
                ignoreCase = (Boolean)this.getParameter("ignoreCase");
                customProps = (String)this.getParameter("customProperties");
                realm = (String)this.getParameter("realmName");
            } else {
                secDomain = (String)this.getParameter("securityDomainName");
            }
            verifyRegistry = (Boolean)this.getParameter("verifyRegistry");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityDomainName name is " + secDomain);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverId name is " + serverid);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "primaryAdminId name is " + primaryAdminId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autoGenerateServerId name is " + autoGenServerId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoreCase name is " + ignoreCase);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customProperties name is " + customProps);
            }
            globalSecObj = SecConfigTaskHelper.getSecurityObjectName(session, configService);
            if (secDomain != null) {
                if (secDomain.equals("PassThroughToGlobalSecurity")) {
                    String msg = this.getMsg(resBundle, "security.admintask.unableToRunCommand.SECJ7810E", new Object[]{commandName, secDomain});
                    throw new CommandValidationException(msg);
                }
                secObj = SecConfigTaskHelper.getSecDomain(session, configService, secDomain);
            } else {
                secObj = globalSecObj;
            }
            if (secObj == null) {
                String msg = this.getMsg(resBundle, "security.admintask.config.does.not.exist.SECJ7702E", new Object[]{secDomain});
                throw new CommandValidationException(msg);
            }
            ObjectName regObj = SecConfigTaskHelper.getRegObj(session, configService, secObj, "WIMUserRegistry");
            if (regObj != null) {
                if (commandName.equalsIgnoreCase("configureAdminWIMUserRegistry")) {
                    attrList.add(new Attribute("serverId", (String)configService.getAttribute(session, regObj, "serverId")));
                    attrList.add(new Attribute("serverPassword", (String)configService.getAttribute(session, regObj, "serverPassword")));
                    attrList.add(new Attribute("primaryAdminId", (String)configService.getAttribute(session, regObj, "primaryAdminId")));
                    attrList.add(new Attribute("useRegistryServerId", (Boolean)configService.getAttribute(session, regObj, "useRegistryServerId")));
                }
                if (realm == null) {
                    realm = (String)configService.getAttribute(session, regObj, "realm");
                    attrList.add(new Attribute("realm", realm));
                    useRegistryRealm = (Boolean)configService.getAttribute(session, regObj, "useRegistryRealm");
                }
                if (ignoreCase == null) {
                    ignoreCase = (Boolean)configService.getAttribute(session, regObj, "ignoreCase");
                    attrList.add(new Attribute("ignoreCase", ignoreCase));
                }
                props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, configService, regObj, props);
            } else {
                ObjectName globalRegObj = SecConfigTaskHelper.getRegObj(session, configService, globalSecObj, "WIMUserRegistry");
                realm = (String)configService.getAttribute(session, globalRegObj, "realm");
                attrList.add(new Attribute("realm", realm));
                useRegistryRealm = (Boolean)configService.getAttribute(session, globalRegObj, "useRegistryRealm");
                attrList.add(new Attribute("useRegistryRealm", useRegistryRealm));
                ignoreCase = (Boolean)configService.getAttribute(session, globalRegObj, "ignoreCase");
                attrList.add(new Attribute("ignoreCase", ignoreCase));
                props = SecConfigTaskHelper.getCustomPropertiesFromConfig(session, configService, globalRegObj, props);
            }
            if (serverid != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "serverId", serverid);
            }
            if (password != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "serverPassword", password);
            }
            if (primaryAdminId != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "primaryAdminId", primaryAdminId);
            }
            if (realm != null && realm.length() > 0) {
                ConfigServiceHelper.setAttributeValue(attrList, "realm", realm);
            } else {
                useRegistryRealm = Boolean.TRUE;
                ConfigServiceHelper.setAttributeValue(attrList, "realm", "defaultWIMFileBasedRealm");
            }
            ConfigServiceHelper.setAttributeValue(attrList, "useRegistryRealm", useRegistryRealm);
            if (ignoreCase != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "ignoreCase", ignoreCase);
            }
            ConfigServiceHelper.setAttributeValue(attrList, "registryClassName", registryClassName);
            if (autoGenServerId != null) {
                useRegServerId = autoGenServerId == false;
                ConfigServiceHelper.setAttributeValue(attrList, "useRegistryServerId", new Boolean(useRegServerId));
            }
            if (verifyRegistry != null && verifyRegistry.booleanValue()) {
                String msg;
                props = SecConfigTaskHelper.mergeCustomProperties(customProps, props);
                props.setProperty("ACTIVE_REGISTRY", "WIM");
                props.setProperty("CustUserRegImplClass", registryClassName);
                if (commandName.equalsIgnoreCase("configureAdminWIMUserRegistry")) {
                    if (!SecConfigTaskHelper.isRegistryGood(session, configService, "WIMUserRegistry", attrList, props)) {
                        msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                        throw new CommandValidationException(msg);
                    }
                } else if (!SecConfigTaskHelper.isGoodServerId(session, "*", "WIMUserRegistry", props)) {
                    msg = this.getMsg(resBundle, "security.admintask.verifyUserRegistry.SECJ7724E", null);
                    throw new CommandValidationException(msg);
                }
            }
            SecConfigTaskHelper.addInfoToConfig(session, configService, secObj, regObj, "WIMUserRegistry", attrList, customProps);
            if (secObj.equals(globalSecObj)) {
                ConfigServiceHelper.removeAttribute(attrList, "serverId");
                ConfigServiceHelper.removeAttribute(attrList, "serverPassword");
                ConfigServiceHelper.removeAttribute(attrList, "primaryAdminId");
                this.updateWIMInDomains(session, configService, attrList, customProps);
            }
        }
        catch (Exception cse) {
            FFDCFilter.processException(cse, "com.ibm.ws.security.commands.securityDomain.ConfigureWIMUserRegistry", "203");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught", cse);
            }
            result.setException(new CommandValidationException(cse, cse.getMessage()));
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configureWIMUserRegistry");
            }
        }
    }

    private void updateWIMInDomains(Session session, ConfigService configService, AttributeList attrList, String customProps) throws Exception {
        ObjectName domain = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
        ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
        for (int i = 0; i < domains.length; ++i) {
            ObjectName wimObj;
            domain = domains[i];
            pattern = ConfigServiceHelper.createObjectName(null, "AppSecurity");
            ObjectName appSec = configService.queryConfigObjects(session, domain, pattern, null)[0];
            if (appSec == null || (wimObj = SecConfigTaskHelper.getRegObj(session, configService, appSec, "WIMUserRegistry")) == null) continue;
            SecConfigTaskHelper.addInfoToConfig(session, configService, domain, wimObj, "WIMUserRegistry", attrList, customProps);
        }
    }
}

